//////////////////////////////////////////////////////////////////////
//
// :  Ը aka , mailto: alf@dorex.ru
//
//////////////////////////////////////////////////////////////////////
//
// FormEx.cpp: implementation of the CEnviromentContext class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Service.h"
#include "AttribEx.h"
#include "FormEx.h"
#include "FormExFormView.h"
#include "BLModuleWrapper.h"
#ifndef FORMEX_DLL
//#include ".\\TurboBL\\gcboost.h"
#endif
#include "supergrid\MySuperGrid.h"

#define HIMETRIC_INCH 2540
#define WS_EX_LAYERED 0x00080000

#define LWA_COLORKEY	0x01
#define LWA_ALPHA		0x02

typedef BOOL (__stdcall *PFN_SETLAYEREDWINDOWATTRIBUTES)(HWND,COLORREF,BYTE,DWORD);
typedef BOOL (__stdcall *PFN_GETLAYEREDWINDOWATTRIBUTES)(HWND, COLORREF*, BYTE*, DWORD*);

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction 
//////////////////////////////////////////////////////////////////////

extern CMetaDataCont * pMetaDataCont;
extern CBkEndUI * pBkEndUI;
extern CDWordArray glColContArray;

extern CDWordArray glCursorArray;
extern CDWordArray glCursorWindowsArray;

void CALLBACK TimerProcFormEx(HWND hWnd, UINT nMsg, UINT nIDEvent, DWORD dwTime)
{
	if(nIDEvent == 501)
	{
		CTimerWindow* pWnd = (CTimerWindow*)CWnd::FromHandle(hWnd);
		if(!pWnd->m_strTimerName.IsEmpty())
			_CallModuleProc(pWnd->m_pDoc,(LPCSTR)pWnd->m_strTimerName,NULL,0,NULL,FALSE);
	}
}

IMPLEMENT_DYNCREATE(CFormEx,CBLContext);

class CObjID CFormEx::ObjID;

struct CFormEx::paramdefs CFormEx::defFnNames[] = {
	{{"AssignForm",""}, FALSE, 1},
	{{"GetForm",""}, TRUE, 0},
	{{"GetNumAttrib",""}, TRUE, 0},
	{{"GetAttrib",""}, TRUE, 1},
	{{"ObjectType",""}, TRUE, 0},
	{{"FullObjectType",""}, TRUE, 0},
	{{"FullPath",""}, TRUE, 0},
	{{"FixMultiLine",""}, FALSE, 1},
	{{"AddAttrib",""}, TRUE, 1},
	{{"GetAttribAtPos",""}, TRUE, 2},
	{{"AddToolBarsButton",""}, FALSE, 0},
	{{"FindAttrib",""}, TRUE, 2},
	{{"GetNextAttrib",""}, TRUE, 0},
	{{"CurrentAttrib",""}, TRUE, 0},
	{{"GetPicture",""}, TRUE, 4},
	{{"HighlightTabItem",""}, FALSE, 2},
	{{"AddTabImages",""}, TRUE, 1},
	{{"RefreshTabImages",""}, FALSE, 0},
	{{"DisableCloseFormByButton",""}, TRUE, 1},
	{{"Refresh",""}, FALSE, 0},
	{{"ColourTable",""}, FALSE, 1},
	{{"AttachForm",""}, TRUE, 7},
	{{"DetachForm",""}, FALSE, 0},
	{{"TableColumnPosition",""}, FALSE, 3},
	{{"SetAutoAdjustTable",""}, FALSE, 2},
	{{"SetCursor",""}, FALSE, 1},
	{{"AttachFormToAttrib",""}, TRUE, 7},
	{{"AddFormTab",""}, FALSE, 0},
	{{"BeginDirectEnter",""}, FALSE, 1},
	{{"EndDirectEnter",""}, FALSE, 1},
	{{"ResetModify",""}, FALSE, 0},
	{{"SetFont",""}, FALSE, 6},
	{{"GetTablesName",""}, TRUE, 0},
	{{"SetColumnWidth",""}, FALSE, 3},
	{{"GetColumnWidth",""}, TRUE, 2},
	{{"GetCurrentCellCoordinates",""}, FALSE, 5},
	{{"GetCellCoordinates",""}, FALSE, 7},
	{{"SetTabFont",""}, FALSE, 1},
	{{"IdleProcessing", ""}, TRUE, 2},
	{{"SetTablePicture",""}, FALSE, 1},
	{{"Test",""}, TRUE, 2},
	{NULL,0,0}
};

struct CFormEx::parampropdefs CFormEx::defPropNames[] = {
	{{"Height",""}, TRUE, TRUE, NULL},
	{{"Width",""}, TRUE, TRUE, NULL},
	{{"Maximize",""}, TRUE, TRUE, NULL},
	{{"Label",""}, TRUE, TRUE, NULL},
	{{"Top",""}, TRUE, TRUE, NULL},
	{{"Left",""}, TRUE, TRUE, NULL},
	{{"Minimize",""}, TRUE, TRUE, NULL},
	{{"Description",""}, TRUE, FALSE, NULL},
	{{"BkColor",""}, TRUE, TRUE, NULL},
	{{"ModuleText",""}, TRUE, FALSE, NULL},
	{{"Transparency",""}, TRUE, TRUE, NULL},
	{NULL,0,0, NULL}
};

CFormEx::CFormEx():CBLContext()
{
	m_pTableCtrl = NULL;
	m_pWorkCtrl = NULL;
	m_pWorkField = NULL;
	m_pTable = NULL;
	m_curCol = 0;
	m_curRow = 0;
	m_uTimer = 0;
	wndTimer.m_hWnd = NULL;

	CurrentAtr = -1;
	KindOfSelection = -1;
	m_Form = NULL;

	CBLModule* pMod = CBLModule::GetExecutedModule();
#ifdef FORMEX_DLL
	CGroupContext * pCont = (CGroupContext*)GetContextFromModule(pMod);
#else
	CGroupContext * pCont = (CGroupContext*)CBLModuleWrapper::GetContextFromModule(pMod);
#endif
	if(pCont)
	{
		int n = pCont->FindProp("");
		if(n>=0)
		{
			CValue valForm;
			pCont->GetPropVal(n,valForm);
			CBLContext* pFormCont = valForm.GetContext();
			if(pFormCont) if(!strcmp(pFormCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
			{
				m_Form = (CFormAllCtrlsContext*)pFormCont;
				m_Form->IncrRef();
			}
		}
	}
}

CFormEx::~CFormEx()
{
	m_pTableCtrl = NULL;
	m_pWorkCtrl = NULL;
	m_pWorkField = NULL;
	m_pTable = NULL;
	m_curCol = 0;
	m_curRow = 0;

	if(wndTimer.m_hWnd != 0)
	{
		if(m_uTimer != 0)
			wndTimer.KillTimer(m_uTimer);
		wndTimer.DestroyWindow();
	}

	if(m_Form) m_Form->DecrRef();
	m_Form = NULL;
}

int  CFormEx::CallAsFunc(int iMethNum,class CValue & rValue,class CValue **ppValue)
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   .",0);
		return S_FALSE;
	}

	switch (iMethNum) {
		case methIdleProcessing:
			{
				rValue = "";
				if((wndTimer.m_hWnd != 0) && (wndTimer.m_strTimerName.IsEmpty() == FALSE))
					rValue = wndTimer.m_strTimerName;

				CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;

				if(pDoc)
				{
					if(pDoc->ExistWindow())
					{
						CWnd* pWnd = pDoc->GetFrame();
						if(pWnd)
						{
							UINT nElapse = ppValue[1]->GetNumeric();
							CString m_strTimerName = ppValue[0]->GetString();
							if(m_strTimerName.IsEmpty() || (nElapse == 0))
							{
								if((m_uTimer != 0) && (wndTimer.m_hWnd != 0))
									wndTimer.KillTimer(m_uTimer);
								m_uTimer = 0;
							}
							else
							{
								if((m_uTimer != 0) && (wndTimer.m_hWnd != 0))
									wndTimer.KillTimer(m_uTimer);

								if(wndTimer.m_hWnd == 0)
								{
									CRect rect(0,0,0,0);
									if(wndTimer.Create("STATIC", "", WS_CHILD, rect, pWnd, 0x0001) == FALSE)
										return S_FALSE;
								}
								wndTimer.m_strTimerName = m_strTimerName;
								wndTimer.m_pDoc = pDoc;

								m_uTimer = wndTimer.SetTimer(501,nElapse,TimerProcFormEx);
							}
						}
					}
				}
				break;
			}
		case methGetColumnWidth:
		{
			rValue = 0L;
			int nCol = ppValue[1]->GetNumeric();
			if(nCol<0)
				return S_OK;

			CString str = ppValue[0]->GetString();
			if((str.CompareNoCase("") == 0) ||
				(str.CompareNoCase("MULTYCOLUMN") == 0))
			{
				CGetDoc* pDoc = (CGetDoc*)m_Form->m_GetDoc;
				CBrowse * pBrowse = pDoc->GetBrowse();
				if(pBrowse)
				{
					if(nCol >= pBrowse->GetColumnNum())
						return S_OK;

					CColumn& cCol = pBrowse->GetColumnN(nCol);
					rValue = pBrowse->GetColumnWidth(cCol.m_ID);
				}
			}
			else
			{
				CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
				CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
				bool f = false;
				int ID = 0;
				for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
				{
					CGetField* pGetField = pGetFieldsArray->GetAt(i);
					if(str.CompareNoCase(pGetField->GetCtrlInfo()->GetCodeName()) == 0) {f = true; ID = ((CFormCtrl*)pGetField)->m_ID;};
				}
				if(f)
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd* pWnd = NULL;
					if(pView)
						pWnd = pView->GetDlgItem(ID);
					else
					{
						CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
						if(pGetDlg) pWnd = pGetDlg->GetDlgItem(ID);
					}
					if(pWnd)
						if(CString("CBrowse") == pWnd->GetRuntimeClass()->m_lpszClassName)
						{
							if(nCol >= ((CBrowse*)pWnd)->GetColumnNum())
								return S_OK;
							CColumn& cCol = ((CBrowse*)pWnd)->GetColumnN(nCol);
							rValue = ((CBrowse*)pWnd)->GetColumnWidth(cCol.m_ID);
						}
				}
			}
			break;
		}
	case methGetForm:
		{
			rValue.AssignContext(m_Form);
			break;
		}
	case methGetNumAttrib:
		{
			rValue = (long)m_Form->m_GetDoc->m_Array.GetSize();
			break;
		}
	case methGetAttrib:
		{
			int n;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
			n = -1;
			if(ppValue[0]->type == 2)
			{
				if((ppValue[0]->GetString().CompareNoCase("") == 0) ||
					(ppValue[0]->GetString().CompareNoCase("MULTYCOLUMN") == 0))
				{
					n = -2;
				}
				else
				{
					char* str = (char*)(LPCSTR)ppValue[0]->GetString();
					for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
					{
						CGetField* pGetField = pGetFieldsArray->GetAt(i);
						char* pCodeName = (char*)pGetField->GetCtrlInfo()->GetCodeName();
						if(!strcmp(str,pCodeName)) n = i;
					}
					if(n<0)
					{
						CBLModule::RaiseExtRuntimeError("  ",0);
						return S_FALSE;
					}
				}
			}
			else if(ppValue[0]->type == 1)
			{
				n = ppValue[0]->GetNumeric();
			}
			if(((pGetFieldsArray->GetSize() <= n) || (n<0)) && (n != -2))
			{
				CBLModule::RaiseExtRuntimeError("  ",0);
				return S_FALSE;
			}
			CAttribEx* pAttrExCont;
			pAttrExCont = new CAttribEx;
			pAttrExCont->m_Form = m_Form;
			m_Form->IncrRef();
			pAttrExCont->num = n;

			rValue.AssignContext(pAttrExCont);
			pAttrExCont->DecrRef();
			break;
		}
		case methAddAttrib:
		{
			
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;

			if(pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
				UINT CtrlID = 0;
				int n = pGetFieldsArray->GetSize();
				CControlID* pControlID_i;
				CGetField* pGetField_i;
				for(int i = 0;i<n;i++)
				{
					pGetField_i = pGetFieldsArray->GetAt(i);
					pControlID_i = pGetField_i->GetCtrlInfo();

					if(CtrlID < pGetField_i->GetCtrlID())
						CtrlID = pGetField_i->GetCtrlID();
				}
				CtrlID++;
				UINT CtrlType = ppValue[0]->GetNumeric();

				CGetField* pGetField = pGetFieldsArray->NewItem();
				CControlID* pControlID;
				pControlID = new CControlID;
				CRect rect(10,20,110,70);
				CType type(3);

				pControlID->SetPlace(rect);
				pControlID->SetCtrlID(CtrlID);
				pControlID->SetCtrlType(5);
				pControlID->SetValType(type);
				pControlID->SetStyle(WS_VISIBLE | WS_CHILD);// | WS_GROUP | WS_BORDER);
				pControlID->SetExStyle(0);
				pControlID->SetBkColor(RGB(0xFF,0xFF,0xFF));
				pControlID->SetFontColor(RGB(0x00,0x00,0xFF));
				pControlID->SetLongID(-1);
				pControlID->SetLayerName("");
				pControlID->m_Font.lfItalic = 1;

				pGetField->SetCtrlID(CtrlID);
				pGetField->SetCtrlType(type);
				pGetField->SetDoc(pDoc);
				pGetField->SetInternalValue(type);
				pGetField->SetBrOldStateEnable(1);
				pGetField->SetFixKind(1);
				pGetField->SetCtrlInfo(pControlID);
				pGetField->TranslateType();
				pGetField->UpdateMask();
				pGetField->UpdateState();
				//pGetField->ReCreateValue(type);


				//pDoc->CreateControl(pGetField,CtrlType,rect,pView,pControlID->GetStyle(),pControlID->GetExStyle());
				;
				if(pDoc->LayoutControl(pView,pGetField))
				{
					CGetCtrl* pGetCtrl = pDoc->GetCtrl(CtrlID);
					//CDocEditGet(0x4c)->CEditGet(0x40)->CGetCtrl(0x34)->CCmdTarget(0x20)->CObject(0x4)->
					if(pGetCtrl)
					{
//						CWnd* pWnd = pGetCtrl->GetDlgItem();
//						if(pWnd) pBkEndUI->DoMessageLine(PrintRTC(pWnd));
					}

					pView->Invalidate();
				}
			}
			

			/*/
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;

			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
			UINT CtrlID = 0;
			int n = pGetFieldsArray->GetSize();
			for(int i = 0;i<n;i++) if(CtrlID < pGetFieldsArray->GetAt(i)->GetCtrlID())
				CtrlID = pGetFieldsArray->GetAt(i)->GetCtrlID();
			CtrlID++;
			CGetField* pGetField = pGetFieldsArray->NewItem();
			CControlID* pControlID;
			pControlID = new CControlID(*pGetField->GetCtrlInfo());
			pGetField->SetCtrlInfo(pControlID);

			pGetField->SetDoc(pDoc);
			pGetField->SetCtrlID(CtrlID);
			
			UINT CtrlType = ppValue[0]->GetNumeric();
			pControlID->SetCtrlType(CtrlType);
			pControlID->SetCtrlID(CtrlID);
			pControlID->SetExStyle(0);

			switch(CtrlType)
			{
			case 1://STATIC ()
				{
					pControlID->SetStyle(0x50020201);
					break;
				}
			case 2://1CEDIT ( )
				{
					pControlID->SetStyle(0x50820000);
					pControlID->SetExStyle(0x220);
					break;
				}
			case 3://BUTTON ()
				{
					pControlID->SetStyle(0x5002000B);
					break;
				}
			case 4://1CGROUPBOX ( )
				{
					pControlID->SetStyle(0x50020007);
					break;
				}
			case 5://1CEDIT (   )
				{
					pControlID->SetStyle(0x50000000);
					break;
				}
			case 8://  !!! //SysTreeView32 ( )
				{
					pControlID->SetStyle(0x50A20007);
					break;
				}
			case 9://  !!! //STATIC (       )
				{
					pControlID->SetStyle(0x50000000);
					pControlID->SetExStyle(0x10004000);
					break;
				}
			case 10://PICTURE ()
				{
					pControlID->SetStyle(0x5002800B);
					pControlID->SetExStyle(0x800);
					break;
				}
			case 11://LISTBOX ()
				{
					pControlID->SetStyle(0x50A20101);
					break;
				}
			case 12://CHECKBOX ()
				{
					pControlID->SetStyle(0x50020003);
					break;
				}
			case 13://RADIO ()
				{
					pControlID->SetStyle(0x50020009);
					break;
				}
			case 14://COMBOBOX (  )
				{
					pControlID->SetStyle(0x50A20043);
					break;
				}
			case 15://TABLE ()
				{
					pControlID->SetStyle(0x50A20000);
					break;
				}
			default: 
				{
					pControlID->SetStyle(0x5002000b);
				}
			};
			pControlID->SetLongID(-1);
			pControlID = NULL;
			CRect rect(0,0,20,10);
			//pControlID->SetPlace(rect);

			if(pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				pDoc->CreateControl(pGetField,CtrlType,rect,pView,pControlID->GetStyle(),pControlID->GetExStyle());
				//pDoc->LayoutControl(pView,pGetField);
			}
			pDoc->LinkAllFormEdits();

			CAttribEx* pAttrExCont;
			pAttrExCont = new CAttribEx;
			pAttrExCont->m_Form = m_Form;
			m_Form->IncrRef();
			pAttrExCont->num = n;

			rValue.AssignContext(pAttrExCont);
			pAttrExCont->DecrRef();
			//*/
			break;
		}
	case methObjectType:
		{
			CTypedCont *pContainer = (CTypedCont *)m_Form -> m_GetDoc -> buf2[70];

			if (pContainer) {
				CString csType;
				long lMetaID = CConfigCont::DocumentToID (pContainer, csType);

				CString str = "";
				if (lMetaID > 0)
				{
					str = GetModuleFullName (lMetaID, csType, 0, pMetaDataCont);
					int n = str.Find(".");
					if(n >= 0)
						str = str.Left(n);
				}
				rValue = str;
			} else
				rValue = "";

			/*
			CGetDoc77* pDoc = (CGetDoc77*)m_Form->m_GetDoc;
			if(pDoc->buf2[70])
			{
				char* str = (char*)(*((BYTE**)(*((BYTE**)(pDoc->buf2[70])+21))+2));
				int ObjNum = CConfigCont::PathToID(str);
				str = (char*)pMetaDataCont->GetFullName(ObjNum,0,1);
				char* str0 = str;
				while((*str0!='.') && (*str0!=0)) *str0++;
				strcpy(str0,"\0");
				rValue = str;
			}
			else
			{
				rValue = "";
			};
			*/
			break;
		}
	case methGetTablesName:
		{
			CTypedCont *pContainer = (CTypedCont *)m_Form -> m_GetDoc -> buf2[70];

			rValue = "";
			if (pContainer) {
				CStringArray strArr;
				pContainer->GetTablesName(strArr);
				int f = strArr.GetSize();
				CString resString = "";
				for(int i = 0; i < f; i++)
					resString += strArr.GetAt(i) + "\r\n";;

				if(resString != "")
					rValue = resString.Left(resString.GetLength() - 2);
			}
			break;
		}
	case methFullObjectType:
		{

			CTypedCont *pContainer = (CTypedCont *)m_Form -> m_GetDoc -> buf2[70];

			if (pContainer) {
				CString csType;
				long lMetaID = CConfigCont::DocumentToID (pContainer, csType);

				if (lMetaID > 0)
					rValue = GetModuleFullName (lMetaID, csType, 0, pMetaDataCont);
				else
					rValue = "";
			} else
				rValue = "";


			/*
			CGetDoc77* pDoc = (CGetDoc77*)m_Form->m_GetDoc;
			if(pDoc->buf2[70])
			{
				char* str = (char*)(*((BYTE**)(*((BYTE**)(pDoc->buf2[70])+21))+2));
				int ObjNum = CConfigCont::PathToID(str);
				rValue = CString(pMetaDataCont->GetFullName(ObjNum,0,1));
			}
			else
			{
				rValue = "";
			}
			*/
			break;
		}
	case methFullPath:
		{
			CTypedCont *pContainer = (CTypedCont *)m_Form -> m_GetDoc -> buf2[70];

			if (pContainer) {
				CString csPath;
				CConfigCont::DocumentToPath (pContainer, csPath);
				rValue = csPath;
			} else
				rValue = "";

			/*
			CGetDoc77* pDoc = (CGetDoc77*)m_Form->m_GetDoc;
			if(pDoc->buf2[70])
			{
				rValue = (char*)(*((BYTE**)(*((BYTE**)(pDoc->buf2[70])+21))+2));
			}
			else
			{
				rValue = "";
			}
			*/
			break;
		}
	case methGetAttribAtPos:
		{
			rValue = 0L;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if(pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CWnd* pView = (/*CFormView*/CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView == NULL)
					pView = pDoc->GetFrame();

				if(pView)
				{
					POINT point;
					point.x = ppValue[0]->GetNumeric();
					point.y = ppValue[1]->GetNumeric();
					CWnd* pWnd = pView->ChildWindowFromPoint(point, CWP_SKIPINVISIBLE | CWP_SKIPTRANSPARENT);
					if(pWnd)
					if((CString("CButton") == pWnd->GetRuntimeClass()->m_lpszClassName) && ((pWnd->GetStyle() & BS_GROUPBOX) == BS_GROUPBOX))
					{
						if(::SetWindowPos(pWnd->GetSafeHwnd(),HWND_BOTTOM,0,0,0,0,
											SWP_NOMOVE|
											SWP_NOACTIVATE|
											SWP_NOREDRAW|
											SWP_NOOWNERZORDER|
											SWP_NOSIZE|
											SWP_NOSENDCHANGING))
							pWnd = pView->ChildWindowFromPoint(point,CWP_ALL);
					}
					else
					if((CString("CTabCtrl") == pWnd->GetRuntimeClass()->m_lpszClassName))
					{
						if(::SetWindowPos(pWnd->GetSafeHwnd(),HWND_BOTTOM,0,0,0,0,
											SWP_NOMOVE|
											SWP_NOACTIVATE|
											SWP_NOREDRAW|
											SWP_NOOWNERZORDER|
											SWP_NOSIZE|
											SWP_NOSENDCHANGING))
							pWnd = pView->ChildWindowFromPoint(point,CWP_ALL);
					}

					if((pWnd != NULL)
						&& (strcmp(pWnd->GetRuntimeClass()->m_pfnGetBaseClass()->m_lpszClassName,"CBrowseView7")))
					{
						CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
						if(pGetFieldsArray)
						{
							UINT DlgCtrlID = pWnd->GetDlgCtrlID();
							int n = -1;
							for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
							{
								CGetField* pGetField = pGetFieldsArray->GetAt(i);
								if(pGetField->GetCtrlID() == DlgCtrlID) n = i;
							}
							if(n >= 0)
							{
								CAttribEx* pAttrExCont;
								pAttrExCont = new CAttribEx;
								pAttrExCont->m_Form = m_Form;
								m_Form->IncrRef();
								pAttrExCont->num = n;

								rValue.AssignContext(pAttrExCont);
								pAttrExCont->DecrRef();
							}
						}
					}
				}
			}
			break;
		}
	case methFindAttrib:
		{
			rValue = 0L;
			KindOfSelection = ppValue[0]->GetNumeric();
			Selection = *ppValue[1];
			CurrentAtr = 0;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
			if(pGetFieldsArray)
			{
				for(int i = CurrentAtr; i<pGetFieldsArray->GetSize(); i++)
				{
					CGetField* pGetField = pGetFieldsArray->GetAt(i);
					CControlID* pControlID = pGetField->GetCtrlInfo();
					switch (KindOfSelection)
					{
					case selType:
						{
							if(pControlID->GetCtrlType() == Selection.GetNumeric())
							{
								rValue = 1L;
								CurrentAtr = i;
							}
							break;
						}
					case selCaption:
						{
							if(!strcmp(pControlID->GetTitle(),Selection.GetString()))
							{
								rValue = 1L;
								CurrentAtr = i;
							}
							break;
						}
					case selVisible:
						{
							int IsVis = 0;
							if(((CFormCtrl*)pGetField)->m_RefFlag==0)
							{
								unsigned long lStyleEx = pControlID->GetExStyle();
								IsVis = (lStyleEx & CS_EX_VISIBLE);
							}
							else
							{
								IsVis = ((CFormCtrl*)pGetField)->m_Visible;
							}
							if(IsVis == Selection.GetNumeric())
							{
								rValue = 1L;
								CurrentAtr = i;
							}
							break;
						}
					case selReadOnly:
						{
							if(pGetField->GetReadOnly() == !Selection.GetNumeric())
							{
								rValue = 1L;
								CurrentAtr = i;
							}
							break;
						}
					case selLayer:
						{
							if(!strcmp(pControlID->GetLayerName(),Selection.GetString()))
							{
								rValue = 1L;
								CurrentAtr = i;
							}
							break;
						}
					};
					if(rValue == 1L)
						break;
				}
			}
			if(rValue == 0L)
			{
				KindOfSelection = -1;
				CurrentAtr = -1;
			}
			break;
		}
	case methGetNextAttrib:
		{
			rValue = 0L;
			if(KindOfSelection>0)
			{
				CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
				CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
				if(pGetFieldsArray)
				{
					if(CurrentAtr<0) CurrentAtr = 0;
					else CurrentAtr++;
					for(int i = CurrentAtr; i<pGetFieldsArray->GetSize(); i++)
					{
						CGetField* pGetField = pGetFieldsArray->GetAt(i);
						CControlID* pControlID = pGetField->GetCtrlInfo();
						switch (KindOfSelection)
						{
						case selType:
							{
								if(pControlID->GetCtrlType() == Selection.GetNumeric())
								{
									rValue = 1L;
									CurrentAtr = i;
								}
								break;
							}
						case selCaption:
							{
								if(!strcmp(pControlID->GetTitle(),Selection.GetString()))
								{
									rValue = 1L;
									CurrentAtr = i;
								}
								break;
							}
						case selVisible:
							{
								int IsVis = 0;
								if(((CFormCtrl*)pGetField)->m_RefFlag==0)
								{
									unsigned long lStyleEx = pControlID->GetExStyle();
									IsVis = (lStyleEx & CS_EX_VISIBLE);
								}
								else
								{
									IsVis = ((CFormCtrl*)pGetField)->m_Visible;
								}
								if(IsVis == Selection.GetNumeric())
								{
									rValue = 1L;
									CurrentAtr = i;
								}
								break;
							}
						case selReadOnly:
							{
								if(pGetField->GetReadOnly() == !Selection.GetNumeric())
								{
									rValue = 1L;
									CurrentAtr = i;
								}
								break;
							}
						case selLayer:
							{
								if(!strcmp(pControlID->GetLayerName(),Selection.GetString()))
								{
									rValue = 1L;
									CurrentAtr = i;
								}
								break;
							}
//						default:
//							return S_FALSE;
						};
						if(rValue == 1L)
							break;
					}
				}
				if(rValue == 0L)
				{
					KindOfSelection = -1;
					CurrentAtr = -1;
				}
			}
			break;
		}
	case methCurrentAttrib:
		{
			if(CurrentAtr>=0)
			{
				CAttribEx* pAttrExCont;
				pAttrExCont = new CAttribEx;
				pAttrExCont->m_Form = m_Form;
				m_Form->IncrRef();
				pAttrExCont->num = CurrentAtr;

				rValue.AssignContext(pAttrExCont);
				pAttrExCont->DecrRef();
			}
			break;
		}
	case methGetPicture:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;

			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);

				if(pView)
				{
					CBitmap 	bitmap;
					CWindowDC	dc(pView);
					CDC 		memDC;
					CRect		rect;

					memDC.CreateCompatibleDC(&dc);
					rect.left = ppValue[0]->GetNumeric();
					rect.top = ppValue[1]->GetNumeric();
					rect.right = rect.left + ppValue[2]->GetNumeric();
					rect.bottom = rect.top + ppValue[3]->GetNumeric();
					rect.left += 2;
					rect.top +=2;

					bitmap.CreateCompatibleBitmap(&dc, rect.Width(),rect.Height() );
					
					CBitmap* pOldBitmap = memDC.SelectObject(&bitmap);
					memDC.BitBlt(0, 0, rect.Width(),rect.Height(), &dc, rect.left, rect.top, SRCCOPY); 

					IPictureDisp *pPic=NULL;
					PICTDESC pd;
					pd.cbSizeofstruct = sizeof(PICTDESC);
					pd.picType = PICTYPE_BITMAP;
					pd.bmp.hbitmap = HBITMAP(bitmap);
					::OleCreatePictureIndirect(&pd, IID_IPictureDisp, TRUE, (VOID**)&pPic);
					char TMPbuf[_MAX_PATH];
					int res = ::GetEnvironmentVariable("TEMP", TMPbuf, _MAX_PATH);
					strcpy(TMPbuf+res,"\\piFormEx.bmp\0");
					CString TMPstr = TMPbuf;

					if(pPic != NULL)
					{
						::OleSavePictureFile(pPic, TMPstr.AllocSysString());
						pPic->Release();
					};

					CBLContext* rCont = CBLContext::CreateInstance("Picture");
					int nMeth = rCont->FindMethod("Load");
					CValue** lArray = new PValueT[1];
					lArray[0] = (CValue*)malloc(sizeof(CValue));
					lArray[0]->CValue::CValue();
					*lArray[0] = TMPstr;
					if( nMeth >=0 ) rCont->CallAsProc(nMeth,lArray);
					lArray[0]->CValue::~CValue();
					free(lArray[0]);
					delete[] lArray;


					rValue.AssignContext(rCont);
					CFile::Remove(TMPstr);

					memDC.SelectObject(pOldBitmap);
				}
			}
			break;
		}
	case methAddTabImages:
		{
			rValue = 0L;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd * pView = pDoc->GetFrame();
				if(pView)
				{
					CWnd * pWnd = pView->GetWindow(GW_CHILD);
					while(pWnd)
					{
						if(!strcmp(pWnd->GetRuntimeClass()->m_lpszClassName,"CTabCtrl"))
							break;
						pWnd = pWnd->GetNextWindow();
					}
					if(pWnd)
					{
						CGalleryHolder * pGalleryHolder = CGalleryHolder::GetGallery();
						if(pGalleryHolder)
						{
							ULONG picID = pGalleryHolder->FindByAlias(ppValue[0]->GetString());
							if(picID)
							{
								CPictureHolder7 * pic;
								pic = new CPictureHolder7(pGalleryHolder->GetPicture(picID));

								CBitmap bitmap;
								BOOL bResult = FALSE;
								CDC dcMem;
								CDC* pDC = CWnd::GetDesktopWindow()->GetDC();

								if (dcMem.CreateCompatibleDC(pDC))
								{
									CSize hmSize = pic->GetSize();

									CBitmap bmMem;

									if (bmMem.CreateCompatibleBitmap(pDC, hmSize.cx, 16))
									{
										CBitmap* pOldBM = dcMem.SelectObject(&bmMem);

										dcMem.FillSolidRect(0, 0, hmSize.cx, 16, RGB(0x00,0x80,0x80));
										RECT rect1;
										RECT rect2;
										rect1.top = rect1.left = 0;
										rect1.right = hmSize.cx;
										if(hmSize.cy<16) rect1.bottom = hmSize.cy;
										else rect1.bottom = 16;
										
										pic->Render(dcMem, rect1, 0, &rect2);

										bResult = bitmap.Attach(bmMem.Detach());

										dcMem.SelectObject(pOldBM);
									}
								}

								CWnd::GetDesktopWindow()->ReleaseDC(pDC);
								if(bResult)
								{
									CTabCtrl* pTabCtrl = (CTabCtrl*)pWnd;
									CImageList* pImageList;
									pImageList = pTabCtrl->GetImageList();
									if(pImageList == NULL)
									{
										pImageList = new CImageList;
										pImageList->Create(16, 16, ILC_MASK, 6, 0);
										pTabCtrl->SetImageList(pImageList);
									}
									pImageList->Add(&bitmap, RGB(0x00,0x80,0x80));
									
									TCITEM TabCtrlItem;
									TabCtrlItem.pszText = (char*)malloc(200);
									TabCtrlItem.cchTextMax = 200;
									TabCtrlItem.mask = TCIF_IMAGE | TCIF_TEXT;
									for(int it = 0; it < pTabCtrl->GetItemCount(); it ++)
									{
										if(it < pImageList->GetImageCount())
										{
											pTabCtrl->GetItem(it, &TabCtrlItem);
											TabCtrlItem.iImage = it;
											TabCtrlItem.mask = TCIF_IMAGE | TCIF_TEXT;
											pTabCtrl->SetItem(it, &TabCtrlItem);
										}
									}
									free(TabCtrlItem.pszText);

									rValue = 1L;
								}
								delete pic;
							}
						}
					}
				}
			}
			break;
		}
	case methDisableCloseForm:
		{
			rValue = 0L;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd * pView = pDoc->GetFrame();
				if(pView)
				{
					HMENU hMenu = ::GetSystemMenu(pView->GetSafeHwnd(),FALSE);
					if(hMenu)
					{
						if(::GetMenuState(hMenu, SC_CLOSE, MF_BYCOMMAND) == 0xFFFFFFFF)
							rValue = 1L;
						if((ppValue[0]->GetNumeric() == 0) && (rValue.GetNumeric() == 1))
							::GetSystemMenu(pView->GetSafeHwnd(),TRUE);
						else
						if((ppValue[0]->GetNumeric() == 1) && (rValue.GetNumeric() == 0))
							::DeleteMenu(hMenu, SC_CLOSE, MF_BYCOMMAND);
					}
				}
			}
			break;
		}
	case methAttachForm:
		{
			rValue = 0L;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd* pView = pDoc->GetFrame();

				if(pView)
				{
					SECMDIFrameWnd* pParent = (SECMDIFrameWnd*)GetMainFrame();
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CFormView* pFView0 = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
					if(pFView0)
					{
						if(!strcmp(pFView0->GetParent()->GetRuntimeClass()->m_lpszClassName,"CFormExFormView"));
						else
						{
							//CWnd * pParent = pView->GetParent(); //GetMainFrame();
							CSplitterWnd* pSWnd;
							pSWnd = new CSplitterWnd();
							BOOL bResult = FALSE;
							int n = ppValue[0]->GetNumeric();
							int DlgCtrlID0;
							int DlgCtrlIDex;
							SIZE sizeInit;
							sizeInit.cx = 200;
							sizeInit.cy = 200;

							CFormExFormView* pPane0 = NULL;
							CFormExFormView* pPane1 = NULL;
							if(n & 1)
							{
								if(bResult = pSWnd->CreateStatic(pView,2,1,WS_CHILD | WS_VISIBLE | SPLS_DYNAMIC_SPLIT))
								//if(bResult = pSWnd->CreateStatic(pParent,2,1,0x0000C000 | WS_DLGFRAME | WS_VISIBLE | WS_CHILD | WS_CLIPSIBLINGS | SPLS_DYNAMIC_SPLIT))
								{
									pSWnd->CreateView(0,0,RUNTIME_CLASS(CFormExFormView), sizeInit,NULL);
									pSWnd->CreateView(1,0,RUNTIME_CLASS(CFormExFormView), sizeInit,NULL);
									if(n & 2)
									{
										DlgCtrlID0 = 0xE910;
										DlgCtrlIDex = 0xE900;
										pPane0 = (CFormExFormView*)pSWnd->GetPane(1,0);
										pPane1 = (CFormExFormView*)pSWnd->GetPane(0,0);
									}
									else
									{
										DlgCtrlID0 = 0xE900;
										DlgCtrlIDex = 0xE910;
										pPane0 = (CFormExFormView*)pSWnd->GetPane(0,0);
										pPane1 = (CFormExFormView*)pSWnd->GetPane(1,0);
									}
								}
							}
							else
							{
								if(bResult = pSWnd->CreateStatic(pView,1,2,WS_CHILD | WS_VISIBLE | SPLS_DYNAMIC_SPLIT))
								{
									pSWnd->CreateView(0,0,RUNTIME_CLASS(CFormExFormView), sizeInit,NULL);
									pSWnd->CreateView(0,1,RUNTIME_CLASS(CFormExFormView), sizeInit,NULL);
									if(n & 2)
									{
										DlgCtrlID0 = 0xE901;
										DlgCtrlIDex = 0xE900;
										pPane0 = (CFormExFormView*)pSWnd->GetPane(0,1);
										pPane1 = (CFormExFormView*)pSWnd->GetPane(0,0);
									}
									else
									{
										DlgCtrlID0 = 0xE900;
										DlgCtrlIDex = 0xE901;
										pPane0 = (CFormExFormView*)pSWnd->GetPane(0,0);
										pPane1 = (CFormExFormView*)pSWnd->GetPane(0,1);
									}
								}
							}
							if(bResult)
							{
								pPane0->m_tabctrl = ((CTabFrame*)pView)->GetTabControl();
								pPane0->m_ctrlbar = ((CTabFrame*)pView)->GetControlBar(0);
								CWnd* pWnd = pView->GetWindow(GW_CHILD);
								while(pWnd)
								{
									if(CString("CToolBar7") == pWnd->GetRuntimeClass()->m_lpszClassName)
										pPane0->m_ctrlbar = pWnd;
									pWnd->SetParent(pPane0);
									pWnd = pView->GetWindow(GW_CHILD);
									if(pWnd == pSWnd)
										pWnd = pWnd->GetNextWindow();
								}
								pPane0->m_frame = (CFrameWnd*)pView;
								pPane0->m_parentframe = (CFrameWnd*)pView;
								pPane1->m_parentframe = (CFrameWnd*)pView;
								pPane0->m_doc = (CDocument*)pDoc;
								pPane0->m_view = pFView0;
								pPane0->m_bAttached = false;
								pFView0->SetOwner(pView);

								CWnd* pWndSpl = NULL;

								CBLContext* pCont2 = ppValue[1]->GetContext();
								bool bNeedOpen = true;
								if(pCont2)
								if(CString("CFormAllCtrlsContext") == pCont2->GetRuntimeClass()->m_lpszClassName)
								{
									bNeedOpen = false;
									CGetDoc7* pDoc2 = (CGetDoc7*)((CFormAllCtrlsContext*)pCont2)->m_GetDoc;
									if(pDoc2)
									if (pDoc2->ExistWindow())
									if  (CWnd* pWndSplCld = pDoc2->GetForm())
										pWndSpl = pWndSplCld->GetParentFrame();
								}

								if(bNeedOpen)
								{
									CBLContext* pGlobal=CBLContext::GetLoadedContext(1);
									int iOF=pGlobal->FindMethod("");
									int colParam=pGlobal->GetNParams(iOF);
									CValue retVal;
									CValue *paramVal[6];
									for(int num=0;num<colParam;num++)
										paramVal[num]=ppValue[num+1];

									if(pGlobal->CallAsFunc(iOF,retVal,paramVal))
									{
										rValue = retVal;
										CGroupContext* pContSplGr = (CGroupContext*)paramVal[1]->GetContext();
										if(pContSplGr)
										{
											int sz = pContSplGr->GetSize();
											for(int iGr = 0; iGr < sz; iGr++)
											{
												CBLContext* pContSplWnd = pContSplGr->GetContext(iGr);
												if(pContSplWnd && pContSplWnd->IsKindOf(RUNTIME_CLASS(CFormContext)))
												{
													CFormContext* pContSplWndFC = (CFormContext*)pContSplWnd;
													if(pContSplWndFC->m_pDocFC && pContSplWndFC->m_pDocFC->ExistWindow())
														if(CWnd* pWndSplCld = pContSplWndFC->m_pDocFC->GetForm())
															pWndSpl = pWndSplCld->GetParentFrame();
												}
											}
										}
									};
								}

								if(pWndSpl)
								{
									CDocument* pDoc1 = ((CFrameWnd*)pWndSpl)->GetActiveDocument();
									CFormView* pFView1 = NULL;
									if(pDoc1)
									{
										POSITION aPOS1 = pDoc1->GetFirstViewPosition();
										pFView1 = (CFormView*)pDoc1->GetNextView(aPOS1);
										pPane1->m_doc = pDoc1;
										pPane0->m_docAtt = pDoc1;
									}

									pPane1->m_tabctrl = ((CTabFrame*)pWndSpl)->GetTabControl();
									pPane1->m_ctrlbar = ((CTabFrame*)pWndSpl)->GetControlBar(0);

									CWnd* pWnd = pWndSpl->GetWindow(GW_CHILD);

									while(pWnd)
									{
										if(CString("CToolBar7") == pWnd->GetRuntimeClass()->m_lpszClassName)
											pPane1->m_ctrlbar = pWnd;
										pWnd->SetParent(pPane1);
										pWnd = pWndSpl->GetWindow(GW_CHILD);
									}
									pPane1->m_frame = (CFrameWnd*)pWndSpl;
									pPane1->m_view = pFView1;
									pPane1->m_bAttached = true;

									if(pFView1)
										pFView1->SetOwner(pWndSpl);

//									pWndSpl->SetParent(pFView0);
									pWndSpl->SetParent(pSWnd);
									pWndSpl->SetForegroundWindow();
									pWndSpl->ShowWindow(SW_HIDE);

									pWndSpl = NULL;
									
									if(n & 1)
									{
										pSWnd->SetRowInfo(0, 200, 0);
										pSWnd->SetRowInfo(1, 200, 0);
									}
									else
									{
										pSWnd->SetColumnInfo(0, 200, 0);
										pSWnd->SetColumnInfo(1, 200, 0);
									}
									pSWnd->SetActivePane((DlgCtrlID0&0x00F0)>>4,DlgCtrlID0&0x000F);
									pSWnd->ShowCaret();

									pSWnd->RecalcLayout();
									((CTabFrame*)pView)->RecalcLayout(1);
								}
							}
						}
					}
				}
			}
			break;
		}
	case methAttachFormToAttrib:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CGetFieldsArray* pGetFieldsArray = &(pDoc->m_cGetFieldsArray1); //(CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));

			CString str = ppValue[0]->GetString();
			bool f = false;
			int ID = 0;
			for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
			{
				CGetField* pGetField = pGetFieldsArray->GetAt(i);
				char* pCodeName = (char*)pGetField->GetCtrlInfo()->GetCodeName();
				if(!str.CompareNoCase(pCodeName)) {f = true; ID = ((CFormCtrl*)pGetField)->m_ID; break;};
			}
			if(f)
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				CWnd* pWnd = NULL;
				CWnd* pFrame = pDoc->GetFrame();
				CWnd* pParent = pView;
				if(pView)
					pWnd = pView->GetDlgItem(ID);
				else
				{
					CGetDlg* pGetDlg = (CGetDlg*)pFrame;
					pParent = pGetDlg;
					if(pGetDlg) pWnd = pGetDlg->GetDlgItem(ID);
				}
				if(pWnd)
				{
					RECT rect;
					pWnd->GetClientRect(&rect);
					CBLContext* pCont2 = ppValue[1]->GetContext();
					CWnd* pWndSpl = NULL;
					bool bNeedOpen = true;
					if(pCont2)
					if(CString("CFormAllCtrlsContext") == pCont2->GetRuntimeClass()->m_lpszClassName)
					{
						bNeedOpen = false;
						CGetDoc7* pDoc2 = (CGetDoc7*)((CFormAllCtrlsContext*)pCont2)->m_GetDoc;
						if(pDoc2)
						if (pDoc2->ExistWindow())
						if  (CWnd* pWndSplCld = pDoc2->GetForm())
							pWndSpl = pWndSplCld->GetParentFrame();
					}

					if(bNeedOpen)
					{
						CBLContext* pGlobal=CBLContext::GetLoadedContext(1);
						int iOF=pGlobal->FindMethod("");
						int colParam=pGlobal->GetNParams(iOF);
						CValue retVal;
						CValue *paramVal[6];
						for(int num=0;num<colParam;num++)
							paramVal[num]=ppValue[num+1];

						pGlobal->CallAsFunc(iOF,retVal,paramVal);
						rValue = retVal;
						CGroupContext* pContSplGr = (CGroupContext*)paramVal[1]->GetContext();
						if(pContSplGr)
						{
							int sz = pContSplGr->GetSize();
							for(int iGr = 0; iGr < sz; iGr++)
							{
								CBLContext* pContSplWnd = pContSplGr->GetContext(iGr);
								if(pContSplWnd && pContSplWnd->IsKindOf(RUNTIME_CLASS(CFormContext)))
								{
									CFormContext* pContSplWndFC = (CFormContext*)pContSplWnd;
									if(pContSplWndFC->m_pDocFC && pContSplWndFC->m_pDocFC->ExistWindow())
										if(CWnd* pWndSplCld = pContSplWndFC->m_pDocFC->GetForm())
										{
											pWndSpl = pWndSplCld->GetParentFrame();
											break;
										}
								}
							}
						}
					}

					if(pWndSpl)
					{
						//CGetCtrl
						//CSplitterWnd* pSWnd;
						//pSWnd = new CSplitterWnd();
						CBaseWnd* pSWnd;
						pSWnd = new CBaseWnd();

						SIZE sizeInit;
						sizeInit.cx = 200;
						sizeInit.cy = 200;

						pWnd->ClientToScreen(&rect);
						pParent->ScreenToClient(&rect);

						//if(pSWnd->CreateStatic(pParent,1,1,WS_CHILD | WS_VISIBLE | SPLS_DYNAMIC_SPLIT, pWnd->GetDlgCtrlID()))
						if(pSWnd->Create("STATIC"," ",WS_CHILD | WS_VISIBLE, rect, pParent, pWnd->GetDlgCtrlID()))
						{
							pSWnd->SetWindowPos(pWnd,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
							DWORD dwStyle = pWnd->GetStyle();

							pWnd->DestroyWindow();

							//pSWnd->CreateView(0,0,RUNTIME_CLASS(CFormExFormView), sizeInit,NULL);
							//CFormExFormView* pBase = NULL;
							//pBase = (CFormExFormView*)pSWnd->GetPane(0,0);
							CBaseWnd* pBase = pSWnd;
//							CWnd* pWndCld = pWndSpl->GetWindow(GW_CHILD);
//							while(pWndCld)
//							{
//								pWndCld->SetParent(pBase);
//								pWndCld = pWndSpl->GetWindow(GW_CHILD);
//							}

							CDocument* pDoc1 = ((CFrameWnd*)pWndSpl)->GetActiveDocument();
							CFormView* pFView1 = NULL;
							if(pDoc1)
							{
								POSITION aPOS1 = pDoc1->GetFirstViewPosition();
								pFView1 = (CFormView*)pDoc1->GetNextView(aPOS1);
								pBase->m_doc = pDoc1;
							}

							/*
							pBase->m_tabctrl = ((CTabFrame*)pWndSpl)->GetTabControl();
							pBase->m_ctrlbar = ((CTabFrame*)pWndSpl)->GetControlBar(0);
							pBase->m_frame = (CFrameWnd*)pWndSpl;
							pBase->m_parentframe = (CFrameWnd*)pFrame;
							pBase->m_view = pFView1;
							pBase->m_bAttached = true;
							pBase->m_bToAttrib = true;
							*/

//							pWndSpl->SetForegroundWindow();
//							pWndSpl->ShowWindow(SW_HIDE);

							//((CTabFrame*)pWndSpl)->RecalcLayout(1);
							pWndSpl->SetParent(pBase);
							pWndSpl->MoveWindow(&rect);
//							((CTabFrame*)pWndSpl)->RecalcLayout(1);
//							if((dwStyle & WS_VISIBLE) != WS_VISIBLE)
//								pBase->ShowWindow(SW_HIDE);

							pWndSpl = NULL;

//							pSWnd->MoveWindow(&rect);
							//pSWnd->SetActivePane(0,0);
							//pSWnd->ShowCaret();

							//pSWnd->RecalcLayout();
							pDoc1->UpdateAllViews(pView);
						}

						((CTabFrame*)pFrame)->RecalcLayout(1);
						//((CTabFrame*)pFrame)->ActivateFrame();
						((CTabFrame*)pFrame)->SetActiveDocument(pDoc);
					}
				}
			}
			break;
		}
	case methTest:
		{
			/*
			SECMDIFrameWnd * pMainFrame = (SECMDIFrameWnd*)GetMainFrame();
			CTemplate7* pMyTemplate;
			pMyTemplate = new CTemplate7(0xD2, my_RUNTIME_CLASS(CBodyTextDoc), my_RUNTIME_CLASS(CSplittFrame), my_RUNTIME_CLASS(CBodyTextView));
			CDocument* pDocT = pMyTemplate->CreateNewDocument();
			if(pDocT)
			{
				pBkEndUI->DoMessageLine(pDocT->GetRuntimeClass()->m_lpszClassName);
				CFrameWnd *pFrameT = pMyTemplate->CreateNewFrame(pDocT,pMainFrame);
				if(pFrameT)
				{
					pBkEndUI->DoMessageLine(pFrameT->GetRuntimeClass()->m_lpszClassName);
					pFrameT->ShowWindow(SW_SHOW);
				}
			}
			rValue = 0L;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd* pView = pDoc->GetFrame();
				if(pView)
				{
					CTemplate7* pTempl = (CTemplate7*)pDoc->GetDocTemplate();
					if(pTempl)
					{
						//pTempl->GetFrameClass();
					}
				}
			}
			//CBLModule* pMod1 = CBLModule::GetExecutedModule();
			//CString stDeb = "";
			//stDeb.Format("%x",(DWORD)pMod1);
			//SaveCompiledModuleToFile(pMod1, "F:\\test_log.txt");
			//pBkEndUI->DoMessageLine(stDeb);
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CBrowse* pBr = pDoc->GetBrowse();
			CObject* pObj1 = pBr->m_colArray.GetAt(3);
			CObject* pObj2 = pBr->m_colArray.GetAt(4);
			pBr->m_colArray.SetAt(3,pObj2);
			pBr->m_colArray.SetAt(4,pObj1);
			//pBr->pubNumCols();
			//pBr->pub_refresh();
			pBr->Invalidate();
			*/

			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CBLContext* pValTableCtrlCont = ppValue[0]->GetContext();
			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));

			if(pValTableCtrlCont)
			{
				CBLContext* pValTableCont = (CBLContext*)*((DWORD*)*((DWORD*)*((DWORD*)pValTableCtrlCont+8)+1)+18);
				DWORD ID = *((DWORD*)*((DWORD*)pValTableCtrlCont+8)+5);
				if(!strcmp(pValTableCont->GetRuntimeClass()->m_lpszClassName,"CValueTableContext"))
				{
					if(pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
						CWnd* pWnd = NULL;
						if(pView)
							pWnd = pView->GetDlgItem(ID);
						else
						{
							CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
							if(pGetDlg) pWnd = pGetDlg->GetDlgItem(ID);
						}
						if(pWnd)
						if(CString("CBrowse") == pWnd->GetRuntimeClass()->m_lpszClassName)
						{
							CBrowse* pBrowse = (CBrowse*)pWnd;
							UINT test_id = 0x10F1;
							/*
							CGetColumn* pGetColumn;
							pGetColumn = new CGetColumn(0x10F1,"Test Col",10,2);
							pBrowse->Add((CColumn*)pGetColumn,0);
							CCellGet* pCellGet;
							CString strCaption = "";
							pCellGet = new CCellGet(pBrowse,0x10F1,"TestCol",1);
							pDoc->AddGet((CGetCtrl*)pCellGet);
							*/
							CBLContext* pTempCont = ppValue[1]->GetContext();
							CGetField* pGetField = (CGetField*)*((DWORD*)pTempCont+8);
							//CGetField cGetField;
							//cGetField.SetCtrlType(ppValue[1]->m_ValueType);
							//cGetField.TranslateType();
							if(pGetField)
							{
								test_id = pGetField->m_ID;
								pGetField->SetInTable(TRUE);
								CGetColumn* pCol;
								pCol = new CGetColumn(test_id,"Test Col",10,20);
								//pCol->m_CellGet = pDoc;
								//pCol->m_pGetField = pGetField;
								pBrowse->Add((CColumn*)pCol,0);
								/*
								CCellGet* pCellGet;
								pCellGet = new CCellGet(pBrowse,test_id,10,"TestCol",20,pGetField->m_strWindowName,30);
								//2a0f34a8
								pDoc->AddGet((CGetCtrl*)pCellGet);
								CColumnEdited* pCol = (CColumnEdited*)&(pBrowse->GetColumn(0x1F01));
								pCol->m_CellGet = pDoc;
								pCol->m_pGetField = pGetField;
								CControlID* pControlID;
								pControlID = new CControlID;

								pControlID->SetPlace(CRect(0,0,0,0));
								pControlID->SetCtrlID(0x1F01);
								pControlID->SetCtrlType(5);
								pControlID->SetValType(ppValue[1]->m_ValueType);
								pControlID->SetStyle(WS_VISIBLE | WS_CHILD);// | WS_GROUP | WS_BORDER);
								pControlID->SetExStyle(0);
								pControlID->SetBkColor(RGB(0xFF,0xFF,0xFF));
								pControlID->SetFontColor(RGB(0x00,0x00,0x00));
								pControlID->SetLongID(-1);
								pControlID->SetLayerName("");
								pControlID->SetToolTip(" ");
								pControlID->SetDependParam(0x20);
								pGetField->SetCtrlInfo(pControlID);
								*/

								//*((DWORD*)pCol) = 0x2a0f34a8;
							}
						}
					}
				}
				else pBkEndUI->DoMessageLine(" ",mmRedErr);
			}

			break;
		}
	default:
		return S_FALSE;
	};
	return S_OK;
}

typedef long (CBrowse::*PF_GETSETFONT)(UINT, long);

union PtrConvFONT{
	void* pV;
	PF_GETSETFONT pGetFont;
	PF_GETSETFONT pSetFont;
} prtconvFont;

int  CFormEx::CallAsProc(int iMethNum,class CValue * * ppValue)
{
	if(!m_Form && iMethNum != methAssignForm)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}
	switch (iMethNum) {
		case methSetTablePicture:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CBrowse* pBrowse = pDoc->GetBrowse();
				if(pBrowse)
				{
					CColumn* pColumn = &(pBrowse->GetColumnN(0));
					if(pColumn)
					{
						CGalleryHolder * pGalleryHolder = CGalleryHolder::GetGallery();
						if(pGalleryHolder)
						{
							ULONG picID = pGalleryHolder->FindByAlias(ppValue[0]->GetString());
							if(picID)
							{
								CPictureHolder7 * pic;
								pic = new CPictureHolder7(pGalleryHolder->GetPicture(picID));

								CBitmap bitmap;
								BOOL bResult = FALSE;
								CDC dcMem;
								CDC* pDC = CWnd::GetDesktopWindow()->GetDC();

								if (dcMem.CreateCompatibleDC(pDC))
								{
									CSize hmSize = pic->GetSize();

									CBitmap bmMem;

									if (bmMem.CreateCompatibleBitmap(pDC, hmSize.cx, 16))
									{
										CBitmap* pOldBM = dcMem.SelectObject(&bmMem);

										dcMem.FillSolidRect(0, 0, hmSize.cx, 16, RGB(0x00,0x80,0x80));
										RECT rect1;
										RECT rect2;
										rect1.top = rect1.left = 0;
										rect1.right = hmSize.cx;
										if(hmSize.cy<16) rect1.bottom = hmSize.cy;
										else rect1.bottom = 16;
											
										pic->Render(dcMem, rect1, 0, &rect2);

										bResult = bitmap.Attach(bmMem.Detach());

										dcMem.SelectObject(pOldBM);
									}
								}

								CWnd::GetDesktopWindow()->ReleaseDC(pDC);
								if(bResult)
								{
									CImageList* pImageList;
									pImageList = &(pColumn->m_Image);
									pImageList->DeleteImageList();
									pImageList->Create(16, 16, ILC_MASK, 6, 0);
									pImageList->Add(&bitmap, RGB(0x00,0x80,0x80));
								}
								delete pic;
							}
						}
					}
				}
			}
			break;
		}
		case methSetFont:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CBrowse* pBrowse = pDoc->GetBrowse();
			if(pBrowse)
			{
				HINSTANCE hBr32=GetModuleHandle("br32.dll");
				BYTE* adr1;
				adr1=(BYTE*)GetProcAddress(hBr32,"?GetFont@CBrowse@@IAEJIJ@Z");
				prtconvFont.pV = adr1;

				HFONT hFont = (HFONT)(pBrowse->*prtconvFont.pGetFont)(NULL, 0);

				LOGFONT lFont;
				GetObject(hFont, sizeof(LOGFONT), (LPSTR)&lFont);
				CString strFaceName = ppValue[0]->GetString();
				if(!strFaceName.IsEmpty())
				{
					memcpy(lFont.lfFaceName,LPCSTR(strFaceName),strFaceName.GetLength());
					lFont.lfFaceName[strFaceName.GetLength()] = char(0);
				}
				if(ppValue[1]->GetNumeric() >= 0)
					lFont.lfHeight = ppValue[1]->GetNumeric();
				int w = ppValue[2]->GetNumeric();
				if(w >=0)
				{
					if(w == 1)
						lFont.lfWeight = FW_THIN;
					else if(w == 2)
						lFont.lfWeight = FW_EXTRALIGHT;
					else if(w == 3)
						lFont.lfWeight = FW_LIGHT;
					else if(w == 4)
						lFont.lfWeight = FW_NORMAL;
					else if(w == 5)
						lFont.lfWeight = FW_MEDIUM;
					else if(w == 6)
						lFont.lfWeight = FW_SEMIBOLD;
					else if(w == 7)
						lFont.lfWeight = FW_BOLD;
					else if(w == 8)
						lFont.lfWeight = FW_EXTRABOLD;
					else if(w == 9)
						lFont.lfWeight = FW_HEAVY;
					else
						lFont.lfWeight = FW_DONTCARE;
				}

				if(ppValue[3]->GetNumeric() >= 0)
					lFont.lfItalic = ppValue[3]->GetNumeric();

				if(ppValue[4]->GetNumeric() >= 0)
					lFont.lfUnderline = ppValue[4]->GetNumeric();
				if(ppValue[5]->GetNumeric() >= 0)
					lFont.lfStrikeOut = ppValue[5]->GetNumeric();
				//DeleteObject(hFont);
				hFont = CreateFontIndirect(&lFont);

				adr1=(BYTE*)GetProcAddress(hBr32,"?SetFont@CBrowse@@IAEJIJ@Z");
				prtconvFont.pV = adr1;
				(pBrowse->*prtconvFont.pSetFont)((UINT)hFont,0);
			}

			break;
		}
		case methResetModify:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			pDoc->SetDocModify(0);
			break;
		}
		case methAssignForm:
		{
			if(wndTimer.m_hWnd != 0)
			{
				if(m_uTimer != 0)
					wndTimer.KillTimer(m_uTimer);
				wndTimer.DestroyWindow();
				wndTimer.m_hWnd = 0;
			}

			CBLContext* pBLCont = ppValue[0]->GetContext();
			if (pBLCont)
			{
				if(!strcmp(pBLCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
				{
					if(m_Form) m_Form->DecrRef();
					m_Form = (CFormAllCtrlsContext*)pBLCont;
					m_Form->IncrRef();
				}
				else
				{
					CBLModule::RaiseExtRuntimeError(" ",0);
					return S_FALSE;
				}
			}
			break;
		}
		case methSetCursor:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd * pView = pDoc->GetFrame();
				if(pView)
				{
					HCURSOR hCur = NULL;
					bool reset = false;
					if(ppValue[0]->type == 1)
					{
						int sysCursor = ppValue[0]->GetNumeric();
						if(sysCursor == 1)
							hCur = ::LoadCursor(NULL, IDC_ARROW);
						else if(sysCursor == 2)
							hCur = ::LoadCursor(NULL, IDC_IBEAM);
						else if(sysCursor == 3)
							hCur = ::LoadCursor(NULL, IDC_WAIT);
						else if(sysCursor == 4)
							hCur = ::LoadCursor(NULL, IDC_CROSS);
						else if(sysCursor == 5)
							hCur = ::LoadCursor(NULL, IDC_UPARROW);
						else if(sysCursor == 6)
							hCur = ::LoadCursor(NULL, IDC_SIZENWSE);
						else if(sysCursor == 7)
							hCur = ::LoadCursor(NULL, IDC_SIZENESW);
						else if(sysCursor == 8)
							hCur = ::LoadCursor(NULL, IDC_SIZEWE);
						else if(sysCursor == 9)
							hCur = ::LoadCursor(NULL, IDC_SIZENS);
						else if(sysCursor == 10)
							hCur = ::LoadCursor(NULL, IDC_SIZEALL);
						else if(sysCursor == 11)
							hCur = ::LoadCursor(NULL, IDC_NO);
						else if(sysCursor == 12)
							hCur = ::LoadCursor(NULL, IDC_APPSTARTING);
						else if(sysCursor == 13)
							hCur = ::LoadCursor(NULL, IDC_HELP);
						else if(sysCursor == 14)
							hCur = ::LoadCursor(NULL, MAKEINTRESOURCE(32649));//IDC_HAND
						else if(sysCursor == 15)
							hCur = ::LoadCursor(NULL, IDC_APPSTARTING);
						else
							reset = true;
					}
					else if(ppValue[0]->type == 2)
					{
						hCur = ::LoadCursorFromFile(ppValue[0]->GetString());
					}
					if((hCur == NULL) && (reset == false))
						pBkEndUI->DoMessageLine("  .",mmRedErr);
					else if(reset == true)
					{
						int szArr = glCursorWindowsArray.GetSize();
						for(int iContAr = 0; iContAr < szArr; iContAr++)
							if(glCursorWindowsArray.GetAt(iContAr) == (DWORD)pView->GetSafeHwnd())
							{
								glCursorWindowsArray.RemoveAt(iContAr);
								glCursorArray.RemoveAt(iContAr);
								break;
							}
					}
					else
					{
						int szArr = glCursorWindowsArray.GetSize();
						int iContAr = -1;
						if(szArr > 0)
						{
							//szArr++;
							for(iContAr = 0; iContAr < szArr; iContAr++)
								if(glCursorWindowsArray.GetAt(iContAr) == (DWORD)pView->GetSafeHwnd())
									break;
						}
						if((iContAr < 0) || (iContAr == szArr))
						{
							glCursorWindowsArray.Add((DWORD)pView->GetSafeHwnd());
							glCursorArray.Add((DWORD)hCur);
						}
						else
							glCursorArray.SetAt(iContAr,(DWORD)hCur);
					}
				}
			}

			break;
		}
		case methFixBrowse:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if(pDoc->HasBrowse())
			{
				CBrowse *pBrowse = ((CGetDoc*)pDoc)->GetBrowse();
				if(pBrowse) pBrowse->FixHorz(ppValue[0]->GetNumeric());
				else pBkEndUI->DoMessageLine("     .",mmRedErr);
			}
			else
				pBkEndUI->DoMessageLine("    .",mmRedErr);

			break;
		}
		case methAddTBButton:
		{
			//CTokeniseBox CBLModule7
			//CBLModule * pBLModule = CBLModule::GetExecutedModule();
			//pBLModule->ResetCompiled();
			//pBLModule->Compile();
/*
			int i = 54;
			CString st;
			CString st_res;
			CBLModule::TokenizeSourceLine(" ;  () .();   = (\"\");",
				i,&st);
			st_res.Format("%d :: %d",i, st.GetLength());
			pBkEndUI->DoMessageLine(st_res, mmNone);
			pBkEndUI->DoMessageLine(st, mmNone);
*/
			break;

			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd * pView = pDoc->GetFrame();;
				CWnd * pWnd = pView->GetWindow(GW_CHILD);
				CToolBar7* pTB = NULL;
				while(pWnd)
				{
					if(!strcmp(pWnd->GetRuntimeClass()->m_lpszClassName,"CToolBar7"))
						pTB = (CToolBar7*)pWnd;
					pWnd = pWnd->GetNextWindow();
				}

				if(pTB)
				{
					/*
					CToolBar7
					SECCustomToolBar
					SECControlBar
					CControlBar
					*/
					//CToolBar7* pTB = (CToolBar7*)pWnd;

					CString st;
					CRect rc(0,0,0,0);
					CPtrArray * mPtrArray = NULL;
					mPtrArray = (CPtrArray*)((int*)pTB+101);
					int count = mPtrArray->GetSize();
					pTB->GetItemRect(count - 1, rc);
					CRect rcBtn(rc.right,rc.top,2*rc.right - rc.left,rc.bottom);

					/*
					CBitmapButton * pBtn;
					pBtn = new CBitmapButton;
					pBtn->Create("Test",WS_CHILD | WS_VISIBLE,rcBtn, pTB, 0xF0F0);
					pBtn->EnableWindow();
					*/

					SECStdBtn * pStdBtn = SECStdBtn::CreateButton();
					if(pStdBtn)
					{
						pStdBtn->SetToolBar(pTB);
						mPtrArray->Add(pStdBtn);
					}
					else
						pBkEndUI->DoMessageLine("ERROR!", mmNone);

//					st.Format("%d,%d - %d,%d", rc.left, rc.top, rc.right, rc.bottom);
//					pBkEndUI->DoMessageLine(st, mmNone);

					//rc.bottom += 100;
					//rc.left += 100;
					/*
					rc.bottom = 100;
					rc.right = 200;
					rc.left = 150;
					rc.top = 5;
					CComboBox * m_ComboBox;

					m_ComboBox = new CComboBox;
					m_ComboBox->Create( WS_CHILD | WS_VISIBLE | WS_TABSTOP | 
									 WS_VSCROLL | CBS_AUTOHSCROLL | CBS_DROPDOWN, 
									 rc, pTB, 3001);

					//  
					m_ComboBox->AddString( " 1" ); 
					m_ComboBox->AddString( " 2" );
					m_ComboBox->SetCurSel(0);
					*/

 				}
			}

			break;
		}
		case methSetTabFont:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd * pView = pDoc->GetFrame();
				if(pView)
				{
					bool f = false;
					CWnd * pWnd = pView->GetWindow(GW_CHILD);
					while(pWnd)
					{
						if(!strcmp(pWnd->GetRuntimeClass()->m_lpszClassName,"CTabCtrl"))
						{
							f = true;
							break;
						}
						pWnd = pWnd->GetNextWindow();
					}
					if(f)
					{
						CTabCtrl* pTabCtrl = (CTabCtrl*)pWnd;
						DWORD dwFont = (DWORD)ppValue[0]->GetNumeric();
						if(dwFont > 0)
						{
							pTabCtrl->SetFont(CFont::FromHandle((HFONT)dwFont));
						}
					}
				}
			}
			break;
		}
		case methHighlightTabItem:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd * pView = pDoc->GetFrame();
				if(pView)
				{
					bool f = false;
					CWnd * pWnd = pView->GetWindow(GW_CHILD);
					while(pWnd)
					{
						if(!strcmp(pWnd->GetRuntimeClass()->m_lpszClassName,"CTabCtrl"))
						{
							f = true;
							break;
						}
						pWnd = pWnd->GetNextWindow();
					}
					if(f)
					{
						CTabCtrl* pTabCtrl = (CTabCtrl*)pWnd;
						if((pTabCtrl->GetItemCount() >= ppValue[0]->GetNumeric()) &&
							(ppValue[0]->GetNumeric() > 0))
						{
							pTabCtrl->HighlightItem(int(ppValue[0]->GetNumeric()) - 1, ppValue[1]->GetNumeric() == 1);
						}
					}
				}
			}
			break;
		}
		case methRefreshTabImages:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd * pView = pDoc->GetFrame();
				if(pView)
				{
					bool f = false;
					CWnd * pWnd = pView->GetWindow(GW_CHILD);
					while(pWnd)
					{
						if(!strcmp(pWnd->GetRuntimeClass()->m_lpszClassName,"CTabCtrl"))
						{
							f = true;
							break;
						}
						pWnd = pWnd->GetNextWindow();
					}
					if(f)
					{
						CTabCtrl* pTabCtrl = (CTabCtrl*)pWnd;
						CImageList* pImageList;
						pImageList = pTabCtrl->GetImageList();
						if(pImageList)
						{
							TCITEM TabCtrlItem;
							for(int it = 0; it < pTabCtrl->GetItemCount(); it ++)
							{
								if(it < pImageList->GetImageCount())
								{
									pTabCtrl->GetItem(it, &TabCtrlItem);
									TabCtrlItem.iImage = it;
									TabCtrlItem.mask |= TCIF_IMAGE;
									pTabCtrl->SetItem(it, &TabCtrlItem);
								}
							}
						}
					}
				}
			}
			break;
		}
		case methRefresh:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
					pView->RedrawWindow();
				else
				{
					CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
					if(pGetDlg)
						pGetDlg->RedrawWindow();
				}
			}
			break;
		}
		case methColourTable:
		{
			bool flag = true;
			if(ppValue[0]->type == 2)
			{
				if((ppValue[0]->GetString().CompareNoCase("") == 0) ||
					(ppValue[0]->GetString().CompareNoCase("MultiColumn") == 0))
				{
					CGetDoc* pDoc = (CGetDoc*)m_Form->m_GetDoc;
					if(pDoc)
					{
						CBrowse* pBrowse = pDoc->GetBrowse();
						if(pBrowse)
						{
							CSkipper* pDocBr = pBrowse->pDoc;
							if(pDocBr)
							{
								glColContArray.Add((DWORD)pDocBr);
								flag = false;
							}
						}
					}
				}
				else
				{
					char* str = (char*)(LPCSTR)ppValue[0]->GetString();
					CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
					CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
					for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
					{
						CGetField* pGetField = pGetFieldsArray->GetAt(i);
						char* pCodeName = (char*)pGetField->GetCtrlInfo()->GetCodeName();
						if(!strcmp(str,pCodeName))
						{
							CValue *pValue = pGetField->GetPValue();
							if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueTable") == pValue->GetTypeString()))
							{
								if(pDoc->ExistWindow())
								{
									POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
									CWnd* pView = NULL;
									pView = ((CDocument*)pDoc)->GetNextView(aPOS);
									if(!pView)
										pView = pDoc->GetFrame();
									if(pView)
									{
										CBrowse* pBrowse = (CBrowse*)pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
										if(pBrowse)
										{
											CSkipper* pDocBr = pBrowse->pDoc;
											if(pDocBr)
											{
												glColContArray.Add((DWORD)pDocBr);
												flag = false;
											}
										}
									}
								}
							}
							break;
						}
					}
				}
			}
			if(flag)
			{
				CBLModule::RaiseExtRuntimeError("  ",0);
				return S_FALSE;
			}
			break;
		}
		case methDetachForm:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if(pDoc->ExistWindow())
			{
				CWnd* pFrame = pDoc->GetFrame();
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pFView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pFView)
				{
					CWnd* pParent1 = pFView->GetParent();
					if(pParent1)
					if(CString("CFormExFormView") == pParent1->GetRuntimeClass()->m_lpszClassName)
					{
						CWnd* pAFrame = NULL;
						CWnd* pParent0 = pParent1->GetParent();
						CWnd* pWnd = NULL;
						if(pParent0)
						{
							pWnd = pParent0->GetWindow(GW_CHILD);
							while(pWnd)
							{
								if(CString("CFormExFormView") != pWnd->GetRuntimeClass()->m_lpszClassName)
								{
									pAFrame = pWnd;
									pWnd = NULL;
								}
								else
									pWnd = pWnd->GetNextWindow();
							}
						}
						if(pAFrame)
						{
							CSplitterWnd* pSWnd = (CSplitterWnd*)pParent0;
							CFormExFormView* pPane0 = (CFormExFormView*)pSWnd->GetPane(0,0);
							CFormExFormView* pPane1 = (CFormExFormView*)pSWnd->GetPane((pSWnd->GetRowCount())-1, (pSWnd->GetColumnCount())-1);
							if(pPane0->m_bAttached)
							{
								pWnd = pPane0->GetWindow(GW_CHILD);
								while(pWnd)
								{
									pWnd->SetParent(pAFrame);
									pWnd = pPane0->GetWindow(GW_CHILD);
								}
								pWnd = pPane1->GetWindow(GW_CHILD);
								while(pWnd)
								{
									pWnd->SetParent(pFrame);
									pWnd = pPane1->GetWindow(GW_CHILD);
								}
							}
							else
							{
								pWnd = pPane1->GetWindow(GW_CHILD);
								while(pWnd)
								{
									pWnd->SetParent(pAFrame);
									pWnd = pPane1->GetWindow(GW_CHILD);
								}
								pWnd = pPane0->GetWindow(GW_CHILD);
								while(pWnd)
								{
									pWnd->SetParent(pFrame);
									pWnd = pPane0->GetWindow(GW_CHILD);
								}
							}
							pAFrame->SetParent(pFrame->GetParent());
							delete pSWnd;
							pAFrame->SendMessage(WM_CLOSE);
							((CTabFrame*)pFrame)->RecalcLayout(1);
						}
					}
				}
			}
			break;
		}
		case methTableColumnPosition:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));

			CString str = ppValue[0]->GetString();
			bool f = false;
			int ID = 0;
			for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
			{
				CGetField* pGetField = pGetFieldsArray->GetAt(i);
				char* pCodeName = (char*)pGetField->GetCtrlInfo()->GetCodeName();
				if(str == pCodeName) {f = true; ID = ((CFormCtrl*)pGetField)->m_ID;};
			}
			if(f)
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				CWnd* pWnd = NULL;
				if(pView)
					pWnd = pView->GetDlgItem(ID);
				else
				{
					CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
					if(pGetDlg) pWnd = pGetDlg->GetDlgItem(ID);
				}
				if(pWnd)
				{
					if(CString("CBrowse") == pWnd->GetRuntimeClass()->m_lpszClassName)
					{
						CBrowse* pWndBr = (CBrowse*)pWnd;
						int n = ppValue[1]->GetNumeric();
						if((n >= 0) && (n < pWndBr->GetColumnNum()))
						{
							CColumn &col = pWndBr->GetColumnN(n);
							int* adr = (int*)(&col)+0x0f;
							int s = ppValue[2]->GetNumeric();
							(*adr) = s;
							if((*adr) == 2)
							{
								int MHL = pWndBr->GetMaxHeadLines();
								pWndBr->SetMaxHeadLines(MHL+1);
							}
							// ---       
							//		  .    
							//		 .
							CColumn* newCol = new CColumn(0,"",0);
							pWndBr->Add(newCol, 0);
							pWndBr->Delete(pWndBr->GetColumnNum() - 1);
							// ---

							CTabFrame* pView0 = (CTabFrame*)pDoc->GetFrame();
							if(pView0 && !pView0->IsKindOf(RUNTIME_CLASS(CGetDlg))) pView0->RecalcLayout(1);
							pWnd->RedrawWindow();
						}
					}
				}
			}
			break;
		}
		case methSetAutoAdjustTable:
		{
			CString str = ppValue[0]->GetString();
			if((str.CompareNoCase("") == 0) ||
				(str.CompareNoCase("MULTYCOLUMN") == 0))
			{
				CGetDoc* pDoc = (CGetDoc*)m_Form->m_GetDoc;
				CBrowse * pBrowse = pDoc->GetBrowse();
				if(pBrowse) pBrowse->SetAutoAdjust(ppValue[1]->GetNumeric());
			}
			else
			{
				CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
				CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
				bool f = false;
				int ID = 0;
				for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
				{
					CGetField* pGetField = pGetFieldsArray->GetAt(i);
//					char* pCodeName = (char*)pGetField->GetCtrlInfo()->GetCodeName();
					if(str.CompareNoCase(pGetField->GetCtrlInfo()->GetCodeName()) == 0) {f = true; ID = ((CFormCtrl*)pGetField)->m_ID;};
				}
				if(f)
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd* pWnd = NULL;
					if(pView)
						pWnd = pView->GetDlgItem(ID);
					else
					{
						CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
						if(pGetDlg) pWnd = pGetDlg->GetDlgItem(ID);
					}
					if(pWnd)
						if(CString("CBrowse") == pWnd->GetRuntimeClass()->m_lpszClassName)
							((CBrowse*)pWnd)->SetAutoAdjust(ppValue[1]->GetNumeric());
				}
			}
			break;
		}
		case methSetColumnWidth:
		{
			int nCol = ppValue[1]->GetNumeric();
			if(nCol < 0)
				return S_OK;
			int wCol = ppValue[2]->GetNumeric();
			if(wCol <= 0)
				return S_OK;

			CString str = ppValue[0]->GetString();
			if((str.CompareNoCase("") == 0) ||
				(str.CompareNoCase("MULTYCOLUMN") == 0))
			{
				CGetDoc* pDoc = (CGetDoc*)m_Form->m_GetDoc;
				CBrowse * pBrowse = pDoc->GetBrowse();
				if(pBrowse)
				{
					if(nCol >= pBrowse->GetColumnNum())
						return S_OK;

					CColumn& cCol = pBrowse->GetColumnN(nCol);
					pBrowse->SetColumnWidth(cCol.m_ID, wCol);
				}
			}
			else
			{
				CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
				CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
				bool f = false;
				int ID = 0;
				for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
				{
					CGetField* pGetField = pGetFieldsArray->GetAt(i);
					if(str.CompareNoCase(pGetField->GetCtrlInfo()->GetCodeName()) == 0) {f = true; ID = ((CFormCtrl*)pGetField)->m_ID;};
				}
				if(f)
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd* pWnd = NULL;
					if(pView)
						pWnd = pView->GetDlgItem(ID);
					else
					{
						CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
						if(pGetDlg) pWnd = pGetDlg->GetDlgItem(ID);
					}
					if(pWnd)
						if(CString("CBrowse") == pWnd->GetRuntimeClass()->m_lpszClassName)
						{
							if(nCol >= ((CBrowse*)pWnd)->GetColumnNum())
								return S_OK;

							CColumn& cCol = ((CBrowse*)pWnd)->GetColumnN(nCol);
							((CBrowse*)pWnd)->SetColumnWidth(cCol.m_ID, wCol);
						}
				}
			}
			break;
		}
		case methGetCellCoordinates:
		{
			CString str = ppValue[0]->GetString();
			if((str.CompareNoCase("") == 0) ||
				(str.CompareNoCase("MULTYCOLUMN") == 0))
			{
				CGetDoc* pDoc = (CGetDoc*)m_Form->m_GetDoc;
				CBrowse * pBrowse = pDoc->GetBrowse();
				if(pBrowse)
				{
					int iCol = ppValue[2]->GetNumeric();
					int iRow = ppValue[1]->GetNumeric();
					CRect cRect;
					pBrowse->GetCellRect(cRect,iRow-1,iCol-1);
					pBrowse->ClientToScreen(cRect);
					if(CWnd* pParent = pBrowse->GetParent())
						pParent->ScreenToClient(cRect);
					*(ppValue[3]) = cRect.top;
					*(ppValue[4]) = cRect.left;
					*(ppValue[5]) = cRect.bottom;
					*(ppValue[6]) = cRect.right;
				}
			}
			else
			{
				CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
				CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
				bool f = false;
				int ID = 0;
				for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
				{
					CGetField* pGetField = pGetFieldsArray->GetAt(i);
					if(str.CompareNoCase(pGetField->GetCtrlInfo()->GetCodeName()) == 0) {f = true; ID = ((CFormCtrl*)pGetField)->m_ID;};
				}
				if(f)
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd* pParent = pView;
					CWnd* pWnd = NULL;
					if(pView)
						pWnd = pView->GetDlgItem(ID);
					else
					{
						CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
						pParent = pGetDlg;
						if(pGetDlg) pWnd = pGetDlg->GetDlgItem(ID);
					}
					if(pWnd)
						if(CString("CBrowse") == pWnd->GetRuntimeClass()->m_lpszClassName)
						{
							int iCol = ppValue[2]->GetNumeric();
							int iRow = ppValue[1]->GetNumeric();
							CRect cRect;
							((CBrowse*)pWnd)->GetCellRect(cRect,iRow-1,iCol-1);
							pWnd->ClientToScreen(cRect);
							pParent->ScreenToClient(cRect);
							*(ppValue[3]) = cRect.top;
							*(ppValue[4]) = cRect.left;
							*(ppValue[5]) = cRect.bottom;
							*(ppValue[6]) = cRect.right;
						}
						else if(CString("CMySuperGrid") == pWnd->GetRuntimeClass()->m_lpszClassName)
						{
							int iCol = ppValue[2]->GetNumeric();
							CString sRow = ppValue[1]->GetString();
							CRect cRect;
							((CMySuperGrid*)pWnd)->GetCellRect(cRect,sRow,iCol-1);
							pWnd->ClientToScreen(cRect);
							pParent->ScreenToClient(cRect);
							*(ppValue[3]) = cRect.top;
							*(ppValue[4]) = cRect.left;
							*(ppValue[5]) = cRect.bottom;
							*(ppValue[6]) = cRect.right;
						}
				}
			}
			break;
		}
		case methGetCoordinatesCurrentCell:
		{
			CString str = ppValue[0]->GetString();
			if((str.CompareNoCase("") == 0) ||
				(str.CompareNoCase("MULTYCOLUMN") == 0))
			{
				CGetDoc* pDoc = (CGetDoc*)m_Form->m_GetDoc;
				CBrowse * pBrowse = pDoc->GetBrowse();
				if(pBrowse)
				{
					int curCol = (int)*((int*)pBrowse+0x31);//((CBrowse *)this)->m_SelCol;//
					int curRow = (int)*((int*)pBrowse+0x30);//((CBrowse *)this)->m_SelRow;//
					if((*((int*)pBrowse+0x23) == 0) && (*((int*)pBrowse+0x2A) >= 0))
						curRow =  (int)*((int*)pBrowse+0x2A);

					CRect cRect;
					pBrowse->GetCellRect(cRect,curRow,curCol);
					pBrowse->ClientToScreen(cRect);
					if(CWnd* pParent = pBrowse->GetParent())
						pParent->ScreenToClient(cRect);
					*(ppValue[1]) = cRect.top;
					*(ppValue[2]) = cRect.left;
					*(ppValue[3]) = cRect.bottom;
					*(ppValue[4]) = cRect.right;
				}
			}
			else
			{
				CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
				CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
				bool f = false;
				int ID = 0;
				for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
				{
					CGetField* pGetField = pGetFieldsArray->GetAt(i);
					if(str.CompareNoCase(pGetField->GetCtrlInfo()->GetCodeName()) == 0) {f = true; ID = ((CFormCtrl*)pGetField)->m_ID;};
				}
				if(f)
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd* pParent = pView;
					CWnd* pWnd = NULL;
					if(pView)
						pWnd = pView->GetDlgItem(ID);
					else
					{
						CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
						pParent = pGetDlg;
						if(pGetDlg) pWnd = pGetDlg->GetDlgItem(ID);
					}
					if(pWnd)
						if(CString("CBrowse") == pWnd->GetRuntimeClass()->m_lpszClassName)
						{
							int curCol = (int)*((int*)pWnd+0x31);//((CBrowse *)this)->m_SelCol;//
							int curRow = (int)*((int*)pWnd+0x30);//((CBrowse *)this)->m_SelRow;//
							if((*((int*)pWnd+0x23) == 0) && (*((int*)pWnd+0x2A) >= 0))
								curRow =  (int)*((int*)pWnd+0x2A);

							CRect cRect;
							((CBrowse*)pWnd)->GetCellRect(cRect,curRow,curCol);
							pWnd->ClientToScreen(cRect);
							pParent->ScreenToClient(cRect);
							*(ppValue[1]) = cRect.top;
							*(ppValue[2]) = cRect.left;
							*(ppValue[3]) = cRect.bottom;
							*(ppValue[4]) = cRect.right;
						}
						else if(CString("CMySuperGrid") == pWnd->GetRuntimeClass()->m_lpszClassName)
						{
							CRect cRect;
							((CMySuperGrid*)pWnd)->GetSelRect(cRect);
							pWnd->ClientToScreen(cRect);
							pParent->ScreenToClient(cRect);
							*(ppValue[1]) = cRect.top;
							*(ppValue[2]) = cRect.left;
							*(ppValue[3]) = cRect.bottom;
							*(ppValue[4]) = cRect.right;
						}
				}
			}
			break;
		}
		case methAddFormTab:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
			CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
			if(pView)
			{
				if (pDoc->ExistWindow())
				{
					CWnd * pView0 = pDoc->GetFrame();
					if(pView0)
					{
						RECT rect;
						pView0->GetClientRect(&rect);
						//pView0->ScreenToClient(&rect);
						TabCtrl.Create(WS_VISIBLE | WS_CHILD,rect,pView0,0x3021);

						CWnd * pWnd;
						while(pWnd = pView0->GetWindow(GW_CHILD))
						{
							if(pWnd->GetSafeHwnd() == TabCtrl.GetSafeHwnd())
								break;
							pWnd->SetParent(&TabCtrl);
						}
						
						TC_ITEM tc;
						tc.mask=TCIF_TEXT;
						CString str1="Nomer 1";
						tc.pszText=(LPSTR)(LPCTSTR)str1;
						tc.cchTextMax=str1.GetLength();
						TabCtrl.InsertItem(0,&tc);
						tc.mask=TCIF_TEXT;
						str1="Nomer 2";
						tc.pszText=(LPSTR)(LPCTSTR)str1;
						tc.cchTextMax=str1.GetLength();
						TabCtrl.InsertItem(0,&tc);
					}
				}
			}
			break;
		}
	case methStopDirectEnter:
		{
			if(m_pTableCtrl)
			{
				m_pWorkCtrl->SetDlgCtrlID(m_pTableCtrl->GetDlgCtrlID());
				CValue* pValue;
				pValue = m_pWorkField->GetPValue();
				if(pValue)
				{
					//m_pTable->SetValue(*pValue, m_curCol, m_curRow);
				}
				m_pTableCtrl->DestroyWindow();
				CControlID* pControlID = m_pWorkField->GetCtrlInfo();
				pControlID->SetCodeName(m_WorkCodeName);
			}
			m_pTableCtrl = NULL;
			m_pWorkCtrl = NULL;
			m_pWorkField = NULL;
			m_pTable = NULL;
			m_curCol = 0;
			m_curRow = 0;
			break;
		}
	case methStartDirectEnter: //CProfile7
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CBLContext* pValTableCtrlCont = ppValue[0]->GetContext();
			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));

			if(pValTableCtrlCont)
			{
				CBLContext* pValTableCont = (CBLContext*)*((DWORD*)*((DWORD*)*((DWORD*)pValTableCtrlCont+8)+1)+18);
				DWORD ID = *((DWORD*)*((DWORD*)pValTableCtrlCont+8)+5);
				if(!strcmp(pValTableCont->GetRuntimeClass()->m_lpszClassName,"CValueTableContext"))
				{
					if(pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
						CWnd* pWnd = NULL;
						if(pView)
							pWnd = pView->GetDlgItem(ID);
						else
						{
							CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
							if(pGetDlg) pWnd = pGetDlg->GetDlgItem(ID);
						}
						if(pWnd)
						if(CString("CBrowse") == pWnd->GetRuntimeClass()->m_lpszClassName)
						{
							CBrowse* pBrowse = (CBrowse*)pWnd;
							pBrowse->BeginEdit();

							/* WM_QUIT
							CRect rect(0,0,0,0);
							int curCol = (int)*((int*)pBrowse+0x31);
							int curRow = (int)*((int*)pBrowse+0x30);
							if((*((int*)pBrowse+0x23) == 0) && (*((int*)pBrowse+0x2A) >= 0))
								curRow =  (int)*((int*)pBrowse+0x2A);
							pBrowse->GetTextRect(LPRECT(rect), curRow,curCol);
							pBrowse->ClientToScreen(LPRECT(rect));
							pView->ScreenToClient(LPRECT(rect));

							CEditDoc* pEditDoc = (CEditDoc*)pDoc->buf[224];
							pEditDoc->ScreenToDialog(rect);

							CValueTable* pTable = ((CValueTableContextData*)pValTableCont->GetInternalData())->GetValueTable();
							if(pTable)
							{

								CVTColumn* pVTCol = pTable->GetColumn(curCol);

								CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
								UINT CtrlID = 0;
								int n = pGetFieldsArray->GetSize();
								CControlID* pControlID_i;
								CGetField* pGetField_i;
								for(int i = 0;i<n;i++)
								{
									pGetField_i = pGetFieldsArray->GetAt(i);
									pControlID_i = pGetField_i->GetCtrlInfo();

									if(CtrlID < pGetField_i->GetCtrlID())
										CtrlID = pGetField_i->GetCtrlID();
								}
								CtrlID++;
								UINT CtrlType = 5;

								CGetField* pGetField = pGetFieldsArray->NewItem();
								CControlID* pControlID;
								pControlID = new CControlID;
								CType type = pVTCol->GetType();

								pControlID->SetPlace(rect);
								pControlID->SetCtrlID(CtrlID);
								pControlID->SetCtrlType(CtrlType);
								pControlID->SetValType(type);
								pControlID->SetStyle(WS_VISIBLE | WS_CHILD);// | WS_GROUP | WS_BORDER);
								pControlID->SetExStyle(0);
								pControlID->SetBkColor(RGB(0xFF,0xFF,0xFF));
								pControlID->SetFontColor(RGB(0x00,0x00,0xFF));
								pControlID->SetLongID(-1);
								CString str;
								str = CString("(\"")+CString(pValTableCont->GetCode())+"."+pVTCol->GetCode()+"\")";
								pControlID->SetFormul(str);
								str = CString(pValTableCont->GetCode())+"."+pVTCol->GetCode();
								pControlID->SetCodeName(str);
								pBkEndUI->DoMessageLine(str);
								//pControlID->SetLayerName("");

								pGetField->SetCtrlID(CtrlID);
								//pGetField->SetInTable(1);
								pGetField->SetCtrlType(type);
								pGetField->SetDoc(pDoc);
								pGetField->SetInternalValue(type);
								//pGetField->SetBrOldStateEnable(1);
								//pGetField->SetFixKind(1);
								pGetField->SetCtrlInfo(pControlID);
								pGetField->TranslateType();
								pGetField->UpdateMask();
								pGetField->UpdateState();
								CValue* pVal = pGetField->GetPValue();
								*pVal = pTable->GetValue(curCol,curRow);
								//pGetField->ReCreateValue(type);


								//pDoc->CreateControl(pGetField,CtrlType,rect,pBrowse,pControlID->GetStyle(),pControlID->GetExStyle());
								
								pDoc->LayoutControl(pView,pGetField);
								pDoc->SetActiveCtl(CtrlID);

								//pView->Invalidate();
								//pView->RedrawWindow();
								pWnd = pView->GetDlgItem(CtrlID);
								pWnd->BringWindowToTop();
								pWnd->Invalidate();
								pWnd->RedrawWindow();
							}
							*/
						}
					}
				}
				else pBkEndUI->DoMessageLine(" ",mmRedErr);
			}
			break;
		}
		default:
			return S_FALSE;
	};
	return S_OK;
}


int  CFormEx::FindMethod(char const * lpMethodName)const
{
	int i;
	for (i = 0;i<lastMethod;i++){
		if (!stricmp(lpMethodName,defFnNames[i].Names[0]))
			return i;
		if (!stricmp(lpMethodName,defFnNames[i].Names[1]))
			return i;
	}
	return -1;
}

char const *  CFormEx::GetMethodName(int iMethodNum,int iMethodAlias)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].Names[iMethodAlias];
	return 0;
}

int  CFormEx::GetNMethods(void)const
{
	return lastMethod;
}

int  CFormEx::HasRetVal(int iMethodNum)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
	{
		return defFnNames[iMethodNum].HasReturnValue;
	}
	return 0;
}

int CFormEx::GetNParams(int iMethodNum)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].NumberOfParams;
	return 0;
}

int  CFormEx::GetParamDefValue(int iMethodNum,int iParamNum,class CValue * pDefValue)const
{
	switch (iMethodNum) {
	case methGetCoordinatesCurrentCell:
		{
			if(iParamNum != 0)
				*pDefValue = 0L;
		}
	case methSetFont:
		{
			if(iParamNum == 0)
				*pDefValue = "";
			else
				*pDefValue = -1;
			break;
		}
	case methSetCursor:
		{
			*pDefValue = -1;
			break;
		}
	case methDisableCloseForm:
		{
			*pDefValue = -1;
			break;
		}
	case methAttachForm:
		{
			if(iParamNum == 0)
				*pDefValue = 1;
			else
			{
				CBLContext* pGlobal=CBLContext::GetLoadedContext(1);
				int iOF=pGlobal->FindMethod("");
				int colParam=pGlobal->GetNParams(iOF);
				int num = iParamNum-1;
				if(iParamNum <= colParam) pGlobal->GetParamDefValue(iOF,num,pDefValue);
			}
			break;
		}
	case methAttachFormToAttrib:
		{
			if(iParamNum != 0)
			{
				CBLContext* pGlobal=CBLContext::GetLoadedContext(1);
				int iOF=pGlobal->FindMethod("");
				int colParam=pGlobal->GetNParams(iOF);
				int num = iParamNum-1;
				if(iParamNum <= colParam) pGlobal->GetParamDefValue(iOF,num,pDefValue);
			}
			break;
		}
	default:
		return 0;
	};
	return 1;
}

void  CFormEx::DecrRef(void)
{
	CBLContext::DecrRef();
}

char const *  CFormEx::GetCode(void)const
{
	return NULL;
}

int  CFormEx::GetDestroyUnRefd(void)const
{
	return 1;
}

void  CFormEx::GetExactValue(class CValue & vParam)
{
	CBLContext::GetExactValue(vParam);
}

class CObjID   CFormEx::GetID(void)const
{
	return ObjID;
}

class CBLContextInternalData *  CFormEx::GetInternalData(void)
{

	return CBLContext::GetInternalData();

}

long  CFormEx::GetTypeID(void)const
{
	return 100;
}

char const *  CFormEx::GetTypeString(void)const
{
	return "";
}

class CType   CFormEx::GetValueType(void)const
{
	CType tType(100);
	
	return tType;
}

void  CFormEx::IncrRef(void)
{
	CBLContext::IncrRef();
}

void  CFormEx::InitObject(class CType const & tType)
{
	CBLContext::InitObject(tType);
}

void  CFormEx::InitObject(char const * strName)
{
	CBLContext::InitObject(strName);
}

int  CFormEx::IsExactValue(void)const
{
	return 0;
}

int  CFormEx::IsOleContext(void)const
{
	return 0;
}

int  CFormEx::IsPropReadable(int iPropNum)const
{
	if ((iPropNum>=0) && (iPropNum<lastProp))
		return defPropNames[iPropNum].IsReadable;
	return TRUE;
}

int  CFormEx::IsPropWritable(int iPropNum)const
{
	if ((iPropNum>=0) && (iPropNum<lastProp))
		return defPropNames[iPropNum].IsWritable;
	return FALSE;
}

int  CFormEx::IsSerializable(void)
{
	return 0;
}

int  CFormEx::SaveToString(class CString & csStr)
{
	CBLContext::SaveToString(csStr);
	//csStr = "";
	return 1;
}

void  CFormEx::SelectByID(class CObjID cID,long lNum)
{
	CBLContext::SelectByID(cID,lNum);
}

int  CFormEx::GetNProps(void)const
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return 0;
	}
	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
	CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
	return lastProp + pGetFieldsArray->GetSize();
}

char const *  CFormEx::GetPropName(int iPropNum,int iPropAlias)const
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return NULL;
	}

	if ((iPropNum>=0) && (iPropNum<lastProp))
	{
		return defPropNames[iPropNum].Names[iPropAlias];
	}
	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
	CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
	if (iPropNum < (lastProp + pGetFieldsArray->GetSize()))
	{
		CGetField* pGetField = pGetFieldsArray->GetAt(iPropNum - lastProp);
		return pGetField->GetCtrlInfo()->GetCodeName();
	}
	return NULL;
}

int  CFormEx::GetPropVal(int iPropNum,class CValue & rValue)const
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}

	if(iPropNum < 0) return S_FALSE;

	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;

	switch (iPropNum) {
	case propBkColor:
		{
			rValue = -1;
			if (pDoc->ExistWindow())
			{
				CWnd* pWnd = pDoc->GetForm();
				DWORD* dwWnd0 = NULL;
				DWORD* dwWnd = (DWORD*)pWnd;
				if(pWnd != NULL && pWnd->IsKindOf(RUNTIME_CLASS(CBrowseView)))
					dwWnd0 = (DWORD*)dwWnd[0x10];
				else if(pWnd != NULL && pWnd->IsKindOf(RUNTIME_CLASS(CGetDlg)))
					dwWnd0 = (DWORD*)dwWnd[0x9D];

				if(dwWnd0)
					rValue = dwWnd0[0xCE];
			}
			break;
		}
	case propHeight:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				//CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView == NULL)
					pView = pDoc->GetFrame();

				if(pView)
				{
					CRect wndRect(0,0,0,0);
					pView->GetClientRect(&wndRect);

					rValue = wndRect.bottom - wndRect.top;
				}
			}
			else
			{
				rValue = m_Form->m_GetDoc->m_Height;
			}
			break;
		}
	case propWidth:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				//CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView == NULL)
					pView = pDoc->GetFrame();

				if(pView)
				{
					CRect wndRect(0,0,0,0);
					pView->GetClientRect(&wndRect);
					rValue = wndRect.right - wndRect.left;
				}
			}
			else
			{
				rValue = m_Form->m_GetDoc->m_Width;
			}
			break;
		}
	case propTop:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CWnd * pWnd = pView->GetParent();
					if(pWnd)
					{
						WINDOWPLACEMENT wp;
						wp.length = sizeof(WINDOWPLACEMENT);
						if(pWnd->GetWindowPlacement(&wp))
							rValue = wp.rcNormalPosition.top;
					}
				}
			}
			else
			{
				rValue = 0L;
			}
			break;
		}
	case propLeft:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CWnd * pWnd = pView->GetParent();
					if(pWnd)
					{
						WINDOWPLACEMENT wp;
						wp.length = sizeof(WINDOWPLACEMENT);
						if(pWnd->GetWindowPlacement(&wp))
							rValue = wp.rcNormalPosition.left;
					}
				}
			}
			else
			{
				rValue = 0L;
			}
			break;
		}
	case propMaximize:
		{
			rValue = 0L;
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CWnd * pWnd = pView->GetParent();
					if(pWnd)
					if(CString("CFormExFormView") == pWnd->GetRuntimeClass()->m_lpszClassName)
						pWnd = pWnd->GetParent();
					if(pWnd)
						rValue = pWnd->IsZoomed();
				}
			}
			break;
		}
	case propMinimize:
		{
			rValue = 0L;
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CWnd * pWnd = pView->GetParent();
					if(pWnd)
					if(CString("CFormExFormView") == pWnd->GetRuntimeClass()->m_lpszClassName)
						pWnd = pWnd->GetParent();
					if(pWnd)
						rValue = pWnd->IsIconic();
				}
			}
			break;
		}
	case propLabel:
		{
			CGetDoc77* pDoc = (CGetDoc77*)m_Form->m_GetDoc;
			if(pDoc->buf2[70])
			{
				rValue = "";
				CString st = pDoc->GetPathName();
				int p = st.Find("CurName:");
				if(p > 0)
					rValue = st.Mid(p+8);
			}
			else
				rValue = "";
			break;
		}
	case propDescription:
		{
			rValue = "";
			CTypedCont *pContainer = (CTypedCont *)m_Form -> m_GetDoc -> buf2[70];

			if (pContainer) {
				CString csType;
				long lMetaID = CConfigCont::DocumentToID (pContainer, csType);

				if (lMetaID > 0)
				{
					CModuleCont* pModuleCont = (CModuleCont*)CModuleCont::CreateObject();
					if(pModuleCont)
					{
						CConfigCont::IDToTextModule(lMetaID, "UserHelp", csType, &pModuleCont, 1); 
						CTxtModuleReader* pDocum = (CTxtModuleReader*)pModuleCont->GetTextDocument();
						if(pDocum)
						{
							pDocum->GetText(csType);
							rValue = csType;
						}
					}
				}
			}
			break;
		}
	case propModuleText:
		{
			rValue = "";
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if(pDoc)
			{
				rValue = pDoc->m_pBLModule->pIntInfo->mSource;
			}
			break;
		}
	case propTransparency:
		{
			rValue = 0x1FF;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if(pDoc)
			{
				CWnd* pWnd = pDoc->GetForm();
				if(pWnd)
				{
					if(pWnd->GetExStyle() & WS_EX_LAYERED)
					{
						COLORREF crKey = 0;
						BYTE bAlpha = 0;
						DWORD dwFlags = LWA_ALPHA;
						PFN_GETLAYEREDWINDOWATTRIBUTES pfnGetLayeredWindowAttributes;
						HINSTANCE hLib = LoadLibrary("user32.dll");
						if (hLib != NULL)
						{
							pfnGetLayeredWindowAttributes = (PFN_GETLAYEREDWINDOWATTRIBUTES)GetProcAddress(hLib,"GetLayeredWindowAttributes");
							if(pfnGetLayeredWindowAttributes)
							{
								//     XP  
								if(pfnGetLayeredWindowAttributes(pWnd->GetSafeHwnd(), &crKey, &bAlpha, &dwFlags))
									rValue = (long)bAlpha;
							}
						}
					}
				}
			}
			break;
		}
	default:
		{
			int n = -1;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
			if(pGetFieldsArray->GetSize() == iPropNum - lastProp)
				n = -2;
			else
			{
				n = iPropNum - lastProp;
				if(n<0)
					return S_FALSE;
			}
			if(((pGetFieldsArray->GetSize() <= n) || (n<0)) && (n != -2))
				return S_FALSE;

			CAttribEx* pAttrExCont;
			pAttrExCont = new CAttribEx;
			pAttrExCont->m_Form = m_Form;
			m_Form->IncrRef();
			pAttrExCont->num = n;

			rValue.AssignContext(pAttrExCont);
			pAttrExCont->DecrRef();
		}
		//return S_FALSE;
	};
	return S_OK;
}

int  CFormEx::SetPropVal(int iPropNum,class CValue const & vValue)
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}

	if(iPropNum < 0) return S_FALSE;

	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;

	switch (iPropNum) {
	case propBkColor:
		{
			if (pDoc->ExistWindow())
			{
				CWnd* pWnd = pDoc->GetForm();
				DWORD* dwWnd = (DWORD*)pWnd;
				DWORD* dwWnd0 = NULL;
				if(pWnd != NULL && pWnd->IsKindOf(RUNTIME_CLASS(CBrowseView)))
					dwWnd0 = (DWORD*)dwWnd[0x10];
				else if(pWnd != NULL && pWnd->IsKindOf(RUNTIME_CLASS(CGetDlg)))
					dwWnd0 = (DWORD*)dwWnd[0x9D];
				if(dwWnd0)
				{
					dwWnd0[0xCE] = vValue.GetNumeric();
					pWnd->Invalidate();
				}
			}
			break;
		}
	case propHeight:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				//CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
				CWnd * pWnd = NULL;
				bool modal = false;
				if(pView == NULL)
				{
					pWnd = pDoc->GetFrame();
					pView = pWnd;
					modal = true;
				}
				else
					pWnd = pView->GetParent();

				if(pWnd)
				{
					WINDOWPLACEMENT wp;
					wp.length = sizeof(WINDOWPLACEMENT);
					if(pWnd->GetWindowPlacement(&wp))
					{
						if(wp.showCmd == SW_SHOWNORMAL)
						{
							CRect wndRect(0,0,0,0);
							pView->GetClientRect(&wndRect);
							int fH = (wp.rcNormalPosition.bottom - wp.rcNormalPosition.top) -
								(wndRect.bottom - wndRect.top);

							pWnd->MoveWindow(wp.rcNormalPosition.left,wp.rcNormalPosition.top,
												wp.rcNormalPosition.right - wp.rcNormalPosition.left,
												fH + vValue.GetNumeric());
							if(modal) pWnd->CenterWindow();
						}
					}
				}
			}
			else
			{
				m_Form->m_GetDoc->m_Height = vValue.GetNumeric();
			}
			break;
		}
	case propWidth:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				//CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
				CWnd * pWnd = NULL;
				bool modal = false;
				if(pView == NULL)
				{
					pWnd = pDoc->GetFrame();
					pView = pWnd;
					modal = true;
				}
				else
					pWnd = pView->GetParent();

				if(pWnd)
				{
					WINDOWPLACEMENT wp;
					wp.length = sizeof(WINDOWPLACEMENT);
					if(pWnd->GetWindowPlacement(&wp))
					{
						if(wp.showCmd == SW_SHOWNORMAL)
						{
							CRect wndRect(0,0,0,0);
							pView->GetClientRect(&wndRect);
							int fW = (wp.rcNormalPosition.right - wp.rcNormalPosition.left) -
								(wndRect.right - wndRect.left);
							pWnd->MoveWindow(wp.rcNormalPosition.left,wp.rcNormalPosition.top,
												fW + vValue.GetNumeric(),
												wp.rcNormalPosition.bottom - wp.rcNormalPosition.top);
							if(modal) pWnd->CenterWindow();
						}
					}
				}
			}
			else
			{
				m_Form->m_GetDoc->m_Width = vValue.GetNumeric();
			}
			break;
		}
	case propTop:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				//CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
				CWnd * pWnd = NULL;
				if(pView == NULL)
				{
					pWnd = pDoc->GetFrame();
					pView = pWnd;
				}
				else
					pWnd = pView->GetParent();

				if(pWnd)
				{
					WINDOWPLACEMENT wp;
					wp.length = sizeof(WINDOWPLACEMENT);
					if(pWnd->GetWindowPlacement(&wp))
						if(wp.showCmd == SW_SHOWNORMAL)
							pWnd->MoveWindow(wp.rcNormalPosition.left,vValue.GetNumeric(),
												wp.rcNormalPosition.right - wp.rcNormalPosition.left,
												wp.rcNormalPosition.bottom - wp.rcNormalPosition.top);
				}
			}
			break;
		}
	case propLeft:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				//CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
				CWnd * pWnd = NULL;
				bool modal = false;
				if(pView == NULL)
				{
					pWnd = pDoc->GetFrame();
					pView = pWnd;
					modal = true;
				}
				else
					pWnd = pView->GetParent();

				if(pWnd)
				{
					WINDOWPLACEMENT wp;
					wp.length = sizeof(WINDOWPLACEMENT);
					if(pWnd->GetWindowPlacement(&wp))
						if(wp.showCmd == SW_SHOWNORMAL)
							pWnd->MoveWindow(vValue.GetNumeric(),wp.rcNormalPosition.top,
												wp.rcNormalPosition.right - wp.rcNormalPosition.left,
												wp.rcNormalPosition.bottom - wp.rcNormalPosition.top);
				}
			}
			break;
		}
	case propMaximize:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CWnd * pWnd = pView->GetParent();
					if(pWnd)
					if(CString("CFormExFormView") == pWnd->GetRuntimeClass()->m_lpszClassName)
						pWnd = pWnd->GetParent();
					if(pWnd)
					{
//						WINDOWPLACEMENT wp;
//						wp.length = sizeof(WINDOWPLACEMENT);
//						if(pWnd->GetWindowPlacement(&wp))
						{
							if(vValue.GetNumeric())
//								wp.showCmd = SW_SHOWMAXIMIZED;
								pWnd->ShowWindow(SW_SHOWMAXIMIZED);
							else
//								wp.showCmd = SW_SHOWNORMAL;
								pWnd->ShowWindow(SW_SHOWNORMAL);
//							pWnd->SetWindowPlacement(&wp);
						}
					}
				}
			}
			break;
		}
	case propMinimize:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CWnd * pWnd = pView->GetParent();
					if(pWnd)
					if(CString("CFormExFormView") == pWnd->GetRuntimeClass()->m_lpszClassName)
						pWnd = pWnd->GetParent();
					if(pWnd)
					{
						if(vValue.GetNumeric())
							pWnd->ShowWindow(SW_MINIMIZE);
						else
							pWnd->ShowWindow(SW_NORMAL);
					}
				}
			}
			break;
		}
	case propLabel:
		{
			CGetDoc77* pDoc = (CGetDoc77*)m_Form->m_GetDoc;
			if(pDoc->buf2[70])
			{
				CString st = pDoc->GetPathName();
				int p = st.Find("CurName:");
				if(p > 0)
					pDoc->SetPathName(st.Left(p+8)+vValue.GetString());
				else
					pDoc->SetPathName(st+"CurName:"+vValue.GetString());
			}
			break;
		}
	case propTransparency:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if(pDoc)
			{
				CWnd* pWnd = pDoc->GetForm();
				if(pWnd)
				{
					if(!pWnd->IsKindOf(RUNTIME_CLASS(CGetDlg)))
					{
						pWnd = pWnd->GetParentFrame();
					}
					HWND hwnd = pWnd->GetSafeHwnd();
					SetWindowLong(hwnd,GWL_EXSTYLE,GetWindowLong(hwnd,GWL_EXSTYLE) | WS_EX_LAYERED);
//					if(pWnd->ModifyStyleEx(0,WS_EX_LAYERED))
					{
						BYTE bAlpha = (BYTE)(long)vValue.GetNumeric();

						PFN_SETLAYEREDWINDOWATTRIBUTES pfnSetLayeredWindowAttributes;
						HINSTANCE hLib = LoadLibrary("user32.dll");
						if (hLib != NULL)
						{
							pfnSetLayeredWindowAttributes = (PFN_SETLAYEREDWINDOWATTRIBUTES)GetProcAddress(hLib,"SetLayeredWindowAttributes");
							if(pfnSetLayeredWindowAttributes)
							{
								BOOL res = pfnSetLayeredWindowAttributes(pWnd->GetSafeHwnd(), 0, bAlpha, LWA_ALPHA);
								pWnd->RedrawWindow(NULL,
													NULL,
													RDW_ERASE | RDW_INVALIDATE | RDW_FRAME | RDW_ALLCHILDREN);
							}
						}
					}
				}
			}
			break;
		}
	default:
		return S_FALSE;
	};
	return S_OK;
}

int  CFormEx::FindProp(char const * lpPropName)const
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return -1;
	}
	int i;
	for (i = 0;i<lastProp;i++)
	{
		if (!stricmp(lpPropName,defPropNames[i].Names[0]))
			return i;
		if (!stricmp(lpPropName,defPropNames[i].Names[1]))
			return i;
	}
	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
	CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
	CString m_AttribName(lpPropName);
	for (i = 0;i<pGetFieldsArray->GetSize();i++)
	{
		CGetField* pGetField = pGetFieldsArray->GetAt(i);
		char* pCodeName = (char*)pGetField->GetCtrlInfo()->GetCodeName();
		if(m_AttribName.CompareNoCase(pCodeName) == 0)
			return i+lastProp;
	}
	if((m_AttribName.CompareNoCase("") == 0) ||
		(m_AttribName.CompareNoCase("MULTYCOLUMN") == 0))
	{
		return lastProp+pGetFieldsArray->GetSize();
	}
	return -1;//lastProp;//S_FALSE;
}

