#if !defined(AFX_WRAPABOUTDLG_H__2DE2DC9B_D287_4475_9207_80ECD8EB2858__INCLUDED_)
#define AFX_WRAPABOUTDLG_H__2DE2DC9B_D287_4475_9207_80ECD8EB2858__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// WrapAboutDlg.h : header file
//

class CHyperLink : public CStatic
{
// Construction/destruction
public:
    CHyperLink();
    virtual ~CHyperLink();

public:
    enum UnderLineOptions { ulHover = -1, ulNone = 0, ulAlways = 1};

// Attributes
public:
    void SetURL(CString strURL);
    CString GetURL() const;

    void SetColours(COLORREF crLinkColour, COLORREF crVisitedColour,
                    COLORREF crHoverColour = -1);
    COLORREF GetLinkColour() const;
    COLORREF GetVisitedColour() const;
    COLORREF GetHoverColour() const;

    void SetVisited(BOOL bVisited = TRUE);
    BOOL GetVisited() const;

    void SetLinkCursor(HCURSOR hCursor);
    HCURSOR GetLinkCursor() const;

    void SetUnderline(int nUnderline = ulHover);
    int  GetUnderline() const;

    void SetAutoSize(BOOL bAutoSize = TRUE);
    BOOL GetAutoSize() const;

	void SetAltToolTips(BOOL bAltToolTips = TRUE);
	BOOL GetAltToolTips() const;

// Overrides
    // ClassWizard generated virtual function overrides
    //{{AFX_VIRTUAL(CHyperLink)
	public:
    virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual BOOL DestroyWindow();
	protected:
    virtual void PreSubclassWindow();
	//}}AFX_VIRTUAL

// Implementation
protected:
    HINSTANCE GotoURL(LPCTSTR url, int showcmd);
    void ReportError(int nError);
    LONG GetRegKey(HKEY key, LPCTSTR subkey, LPTSTR retdata);
    void PositionWindow();
    void SetDefaultCursor();
	void CreateToolTipText(LPCTSTR url); // (Leo Davidson 24/Nov/2000)

// Protected attributes
protected:
    COLORREF m_crLinkColour, m_crVisitedColour;     // Hyperlink colours
    COLORREF m_crHoverColour;                       // Hover colour
    BOOL     m_bOverControl;                        // cursor over control?
    BOOL     m_bVisited;                            // Has it been visited?
    int      m_nUnderline;                          // underline hyperlink?
    BOOL     m_bAdjustToFit;                        // Adjust window size to fit text?
    CString  m_strURL;                              // hyperlink URL
	CString  m_strToolTip;							// (Leo Davidson 23/Nov/2000)
	BOOL     m_bAltToolTips;						// (Leo Davidson 23/Nov/2000)
    CFont    m_UnderlineFont;                       // Font for underline display
    CFont    m_StdFont;                             // Standard font
    HCURSOR  m_hLinkCursor;                         // Cursor for hyperlink
    CToolTipCtrl m_ToolTip;                         // The tooltip
    UINT     m_nTimerID;

    // Generated message map functions
protected:
    //{{AFX_MSG(CHyperLink)
    afx_msg HBRUSH CtlColor(CDC* pDC, UINT nCtlColor);
    afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
    afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	//}}AFX_MSG
    afx_msg void OnClicked();
    DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CWrapAboutDlg dialog

class CWrapAboutDlg
{
public:
	static void Wrap(CAboutDlg* pDlg);
protected:
	static DWORD* m_pMyVTable;
	static DWORD* m_pRealVTable;
	virtual int  OnInitDialog(void);
	virtual void DestrAboutDlg(void);
	~CWrapAboutDlg();
};

class CWrapColumn
{
public:
	static void Wrap(CColumn* pColumn);
protected:
	static DWORD* m_pMyVTable;
	static DWORD* m_pRealVTable;
	virtual class CWnd *  Edit(class CRect & a_Rect,class CBrowse * a_pBrowse);
};

#endif // !defined(AFX_WRAPABOUTDLG_H__2DE2DC9B_D287_4475_9207_80ECD8EB2858__INCLUDED_)
