//////////////////////////////////////////////////////////////////////
//
// :  Ը aka , mailto: alf@dorex.ru
//
//////////////////////////////////////////////////////////////////////
//
// AttribEx.cpp: implementation of the CEnviromentContext class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Service.h"
#include "AttribEx.h"
#include "MyComboBox.h"
#include "supergrid\MySuperGrid.h"
#ifndef FORMEX_DLL
#include "mycontextbase.h"
#include "V7Control.h"
#endif

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

extern CMetaDataCont * pMetaDataCont;
extern CBkEndUI * pBkEndUI;
extern CDWordArray glCursorArray;
extern CDWordArray glCursorWindowsArray;

CEmptySkipper::CEmptySkipper() {}
CEmptySkipper::~CEmptySkipper(void) {}
int  CEmptySkipper::next(void) {return 1;}
int  CEmptySkipper::prev(void) {return 1;}
void  CEmptySkipper::gotop(void) {}
void  CEmptySkipper::gobot(void) {}
long  CEmptySkipper::getpos(void) {return 0;}
long  CEmptySkipper::setpos(void) {return 0;}

void  CEmptySkipper::read(void) {}
int  CEmptySkipper::skip(int) {return 1;}
int  CEmptySkipper::Ok(void) {return 1;}
int  CEmptySkipper::ateof(void) {return 1;}
void  CEmptySkipper::godba(long) {}
long  CEmptySkipper::getdba(void) {return 0;}
void  CEmptySkipper::goeof(void) {}
long  CEmptySkipper::MaxIndex(void) {return 0;}
long  CEmptySkipper::MinIndex(void) {return 0;}
long  CEmptySkipper::GetIndex(void) {return 0;}
void  CEmptySkipper::SetIndex(long) {}
void  CEmptySkipper::SetMinMaxIndex(void) {}
int  CEmptySkipper::find(char const *) {return 0;}
void  CEmptySkipper::init(void) {}

IMPLEMENT_DYNAMIC(CEmptySkipper,CSkipper)


IMPLEMENT_DYNCREATE(CAttribEx, CBLContext)

class CObjID CAttribEx::ObjID;

struct CAttribEx::paramdefs CAttribEx::defFnNames[] = {
	{{"AssignAttrib",""}, FALSE, 2},
	{{"GetForm",""}, TRUE, 0},
	{{"SetCoordinates",""}, FALSE, 5},
	{{"GetCoordinates",""}, FALSE, 5},
	{{"ValueTypeStr",""}, TRUE, 0},
	{{"WrapValueList",""}, FALSE, 0},
	{{"WrapValueTable",""}, FALSE, 0},
	{{"UpdateTree",""}, FALSE, 0},
	{{"CurrentTreeItem",""}, TRUE, 0},
	{{"CurrentTreeColumn",""}, TRUE, 0},
	{{"ValueFromTree",""}, TRUE, 2},
	{{"ValueToTree",""}, TRUE, 3},
	{{"SetCursor",""}, FALSE, 1},
	{{"ExpandNode",""}, FALSE, 1},
	{{"CollapseNode",""}, FALSE, 1},
	{{"IsGroupNode",""}, TRUE, 1},
	{{"SetCurrentNode",""}, FALSE, 1},
#ifndef FORMEX_DLL
	{{"CreateControl",""}, TRUE, 1},
#endif
	{{"TreeColumnName",""}, TRUE, 1},
	{{"GetValueTableColumnNum",""}, TRUE, 1},
	{{"TreeOptions",""}, FALSE, 10},
	{{"ModifyStyle",""}, FALSE, 2},
	{{"ModifyStyleEx",""}, FALSE, 2},
	{NULL,0,0}
};

struct CAttribEx::parampropdefs CAttribEx::defPropNames[] = {
	{{"Caption",""}, TRUE, TRUE, NULL},
	{{"Hint",""}, TRUE, TRUE, NULL},
	{{"Description",""}, TRUE, TRUE, NULL},
	{{"Formula",""}, TRUE, TRUE, NULL},
	{{"Visible",""}, TRUE, TRUE, NULL},
	{{"ReadOnly",""}, TRUE, TRUE, NULL},
	{{"Layer",""}, TRUE, TRUE, NULL},
	{{"Value",""}, TRUE, TRUE, NULL},
	{{"AttribID",""}, TRUE, FALSE, NULL},
	{{"Type",""}, TRUE, FALSE, NULL},
	{{"BkColor",""}, TRUE, TRUE, NULL},
	{{"FontColor",""}, TRUE, TRUE, NULL},
	{{"Mask",""}, TRUE, TRUE, NULL},
	{{"Related",""}, TRUE, TRUE, NULL},
	{{"Font",""}, TRUE, TRUE, NULL},
	{{"Class",""}, TRUE, FALSE, NULL},
	{{"Border",""}, TRUE, TRUE, NULL},
	{{"ParentWindow",""}, FALSE, TRUE, NULL},
	{{"Handle",""}, TRUE, FALSE, NULL},
	{{"Style",""}, TRUE, TRUE, NULL},
	{{"StyleEx",""}, TRUE, TRUE, NULL},
	{{"Picture",""}, FALSE, TRUE, NULL},
	{{"Focus",""}, TRUE, TRUE, NULL},
	{NULL,0,0, NULL}
};

CAttribEx::CAttribEx():CBLContext()
{
	m_Form = NULL;
	num = 0;
}

CAttribEx::CAttribEx(int param):CBLContext(param)
{
	m_Form = NULL;
	num = 0;
}

CAttribEx::~CAttribEx()
{
	if(m_Form) m_Form->DecrRef();
	m_Form = NULL;
	num = 0;
}

int  CAttribEx::CallAsFunc(int iMethNum,class CValue & rValue,class CValue * *ppValue)
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}
	
	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
	CGetFieldsArray* pGetFieldsArray = NULL;
	CGetField* pGetField = NULL;
	CControlID* pControlID = NULL;
	CBrowse* pBrowse = NULL;
	if(num == -2)
	{
		if(pDoc->ExistWindow())
			pBrowse = ((CGetDoc*)pDoc)->GetBrowse();
	}
	else
	{
		pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
		pGetField = pGetFieldsArray->GetAt(num);
		pControlID = pGetField->GetCtrlInfo();
	}
	
	switch (iMethNum) {
#ifndef FORMEX_DLL
    case methCreateControl:
        {
            if (!(pDoc)->ExistWindow())
                RuntimeError("   .");

            POSITION pos = pDoc->GetFirstViewPosition();
			CWnd* pParentWnd = pDoc->GetNextView(pos);
            if (!pParentWnd)
                pParentWnd = pDoc->GetFrame();

            if (ppValue[0]->GetTypeCode() == STRING_TYPE_1C)
            {
                if (!rValue.CreateObject(ppValue[0]->GetString()))
                    RuntimeError("   : '%s'.", ppValue[0]->GetString());
            }
            else if (ppValue[0]->GetTypeCode() == AGREGATE_TYPE_1C)
                rValue = *ppValue[0];
            else
                RuntimeError("   .");

            CV7Control* pV7Control = NULL;
            CBLContext* pUDC = NULL;

            if (IS_BLTYPE(rValue, CComponentClass))
            {
                pUDC = rValue.GetContext();
                if (!static_cast<CComponentClass*>(pUDC)->GetBaseClass(&pV7Control))
                    RuntimeError("        '%s'.", pUDC->GetTypeString());
            }
            else
            {
                pV7Control = dynamic_cast<CV7Control*>(rValue.GetContext());
                if (!pV7Control)
                    RuntimeError(" '%s'   .", rValue.GetTypeString());
            }

            if (!pV7Control->CreateControlWnd(pParentWnd, pDoc, pGetField, pUDC))
                RuntimeError("    '%s'.", rValue.GetTypeString());

            // :   rValue     
            //        
        }
        break;
#endif
	case methGetValueTableColumnNum:
		{
			rValue = 0L;
			if(num < 0)
			{
				CBLModule::RaiseExtRuntimeError("     .",0);
				return S_FALSE;
			}
			
			CValue *pValue = pGetField->GetPValue();
			if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueTable") == pValue->GetTypeString()))
			{
				if(pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							if(CString("CMySuperGrid") == pWnd->GetRuntimeClass()->m_lpszClassName)
							{
								rValue = ((CMySuperGrid*)pWnd)->GetRealColumnNum(ppValue[0]->GetNumeric());
							}
						}
					}
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("  .",0);
				return S_FALSE;
			}
			break;
		}
	case methTreeColumnName:
		{
			rValue = CString("");
			if(num < 0)
			{
				CBLModule::RaiseExtRuntimeError("     .",0);
				return S_FALSE;
			}
			
			CValue *pValue = pGetField->GetPValue();
			if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueTable") == pValue->GetTypeString()))
			{
				if(pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							if(CString("CMySuperGrid") == pWnd->GetRuntimeClass()->m_lpszClassName)
							{
								rValue = ((CMySuperGrid*)pWnd)->GetColumnName(ppValue[0]->GetNumeric());
							}
						}
					}
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("  .",0);
				return S_FALSE;
			}
			break;
		}
	case methIsGroupNode:
		{
			if(num < 0)
			{
				CBLModule::RaiseExtRuntimeError("     .",0);
				return S_FALSE;
			}
			
			CValue *pValue = pGetField->GetPValue();
			if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueTable") == pValue->GetTypeString()))
			{
				if(pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							if(CString("CMySuperGrid") == pWnd->GetRuntimeClass()->m_lpszClassName)
							{
								CString stPath = ppValue[0]->GetString();
								if(stPath.IsEmpty())
									stPath = ((CMySuperGrid*)pWnd)->GetCurrentItemIndex();
								if(!stPath.IsEmpty())
								{
									rValue = ((CMySuperGrid*)pWnd)->IsGroupByPath(stPath);
								}
							}
						}
					}
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("  .",0);
				return S_FALSE;
			}
			break;
		}
	case methValueToTree:
		{
			if(num < 0)
			{
				CBLModule::RaiseExtRuntimeError("     .",0);
				return S_FALSE;
			}
			
			CValue *pValue = pGetField->GetPValue();
			if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueTable") == pValue->GetTypeString()))
			{
				if(pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							if(CString("CMySuperGrid") == pWnd->GetRuntimeClass()->m_lpszClassName)
							{
								CString stPath = ppValue[0]->GetString();
								if(stPath.IsEmpty())
									stPath = ((CMySuperGrid*)pWnd)->GetCurrentItemIndex();
								if(!stPath.IsEmpty())
								{
									rValue = ((CMySuperGrid*)pWnd)->SetValueByPath(stPath,ppValue[1]->GetNumeric(), *ppValue[2]);
								}
							}
						}
					}
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("  .",0);
				return S_FALSE;
			}
			break;
		}
	case methValueFromTree:
		{
			if(num < 0)
			{
				CBLModule::RaiseExtRuntimeError("     .",0);
				return S_FALSE;
			}
			
			CValue *pValue = pGetField->GetPValue();
			if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueTable") == pValue->GetTypeString()))
			{
				if(pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							if(CString("CMySuperGrid") == pWnd->GetRuntimeClass()->m_lpszClassName)
							{
								CString stPath = ppValue[0]->GetString();
								if(stPath.IsEmpty())
									stPath = ((CMySuperGrid*)pWnd)->GetCurrentItemIndex();
								if(!stPath.IsEmpty())
								{
									((CMySuperGrid*)pWnd)->GetValueByPath(stPath,ppValue[1]->GetNumeric(), rValue);
								}
							}
						}
					}
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("  .",0);
				return S_FALSE;
			}
			break;
		}
	case methCurrentTreeItem:
		{
			if(num < 0)
			{
				CBLModule::RaiseExtRuntimeError("     .",0);
				return S_FALSE;
			}
			
			CValue *pValue = pGetField->GetPValue();
			if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueTable") == pValue->GetTypeString()))
			{
				if(pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							if(CString("CMySuperGrid") == pWnd->GetRuntimeClass()->m_lpszClassName)
							{
								rValue = ((CMySuperGrid*)pWnd)->GetCurrentItemIndex();
							}
						}
					}
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("  .",0);
				return S_FALSE;
			}
			break;
		}
	case methCurrentTreeColumn:
		{
			if(num < 0)
			{
				CBLModule::RaiseExtRuntimeError("     .",0);
				return S_FALSE;
			}
			
			CValue *pValue = pGetField->GetPValue();
			if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueTable") == pValue->GetTypeString()))
			{
				if(pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							if(CString("CMySuperGrid") == pWnd->GetRuntimeClass()->m_lpszClassName)
							{
								rValue = ((CMySuperGrid*)pWnd)->GetCurrentColumn();
							}
						}
					}
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("  .",0);
				return S_FALSE;
			}
			break;
		}
	case methgetForm:
		{
			rValue.AssignContext(m_Form);
			break;
		}
	case methValueTypeStr:
		{
			if(num == -2)
			{
				rValue = CString("");
			}
			else
			{
				CValue* ctrlPValue = pGetField->GetPValue();
				if(ctrlPValue)
					rValue = ctrlPValue->GetTypeString();
			}
			break;
		}
	default:
		return 0;
        };
        return 1;
}

int  CAttribEx::CallAsProc(int iMethNum,class CValue * * ppValue)
{
	if(iMethNum == methAssignAttrib)
	{
		CBLContext* pBLCont = ppValue[0]->GetContext();
		if (pBLCont)
		{
			if(!strcmp(pBLCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
			{
				if(m_Form) m_Form->DecrRef();
				
				m_Form = (CFormAllCtrlsContext*)pBLCont;
				m_Form->IncrRef();
				CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
				CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
				num = -1;
				if(ppValue[1]->type == 2)
				{
					if((ppValue[1]->GetString().CompareNoCase("") == 0) ||
						(ppValue[1]->GetString().CompareNoCase("MULTYCOLUMN") == 0))
					{
						num = -2;
					}
					else
					{
						char* str = (char*)(LPCSTR)ppValue[1]->GetString();
						for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
						{
							CGetField* pGetField = pGetFieldsArray->GetAt(i);
							char* pCodeName = (char*)pGetField->GetCtrlInfo()->GetCodeName();
							if(!strcmp(str,pCodeName)) num = i;
						}
						if(num<0)
						{
							num = 0;
							if(m_Form) m_Form->DecrRef();
							m_Form = NULL;
							CBLModule::RaiseExtRuntimeError("  ",0);
							return S_FALSE;
						}
					}
				}
				else if(ppValue[1]->type == 1)
				{
					num = ppValue[1]->GetNumeric();
				}
				if(((pGetFieldsArray->GetSize() <= num) || (num<0)) && (num != -2))
				{
					num = 0;
					if(m_Form) m_Form->DecrRef();
					m_Form = NULL;
					CBLModule::RaiseExtRuntimeError("  ",0);
					return S_FALSE;
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("     ",0);
				return S_FALSE;
			}
		}
		return S_OK;
	}
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}
	
	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
	CGetFieldsArray* pGetFieldsArray = NULL;
	CGetField* pGetField = NULL;
	CControlID* pControlID = NULL;
	CBrowse* pBrowse = NULL;
	if(num == -2)
	{
		if(pDoc->ExistWindow())
			pBrowse = ((CGetDoc*)m_Form->m_GetDoc)->GetBrowse();
	}
	else
	{
		if(num < 0)
		{
			CBLModule::RaiseExtRuntimeError("  .",0);
			return S_FALSE;
		}
		pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
		pGetField = pGetFieldsArray->GetAt(num);
		pControlID = pGetField->GetCtrlInfo();
	}
	
	switch (iMethNum) {
	case methModifyStyle:
		{
			DWORD dwAddStyle = ppValue[1]->GetNumeric();
			DWORD dwDelStyle = ppValue[0]->GetNumeric();
			if(num != -2)
			{
				if(pControlID)
				{
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CWnd* pView = NULL;
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							CWnd* pWnd = pView->GetDlgItem(pGetField->m_ID);
							if(pWnd)
							{
								pWnd->ModifyStyle(dwDelStyle,dwAddStyle,SWP_DRAWFRAME);
							}
						}
					}
				}
			}
			else if(pBrowse)
			{
				pBrowse->ModifyStyle(dwDelStyle,dwAddStyle,SWP_DRAWFRAME);
			}
			break;
		}
	case methModifyStyleEx:
		{
			DWORD dwAddStyle = ppValue[1]->GetNumeric();
			DWORD dwDelStyle = ppValue[0]->GetNumeric();
			if(num != -2)
			{
				if(pControlID)
				{
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CWnd* pView = NULL;
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							CWnd* pWnd = pView->GetDlgItem(pGetField->m_ID);
							if(pWnd)
							{
								pWnd->ModifyStyleEx(dwDelStyle,dwAddStyle,SWP_DRAWFRAME);
							}
						}
					}
				}
			}
			else if(pBrowse)
			{
				pBrowse->ModifyStyleEx(dwDelStyle,dwAddStyle,SWP_DRAWFRAME);
			}
			break;
		}
	case methTreeOptions:
		{
			if(num < 0)
			{
				CBLModule::RaiseExtRuntimeError("     .",0);
				return S_FALSE;
			}
			
			CValue *pValue = pGetField->GetPValue();
			if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueTable") == pValue->GetTypeString()))
			{
				if(pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							if(CString("CMySuperGrid") == pWnd->GetRuntimeClass()->m_lpszClassName)
							{
								int ShowHGrid = ppValue[0]->GetNumeric();
								int ShowVGrid = ppValue[1]->GetNumeric();
								int ShowTGrid = ppValue[2]->GetNumeric();
								
								((CMySuperGrid*)pWnd)->SetOptions(ShowHGrid, ShowVGrid, ShowTGrid);
								pWnd->Invalidate(FALSE);
							}
						}
					}
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("  .",0);
				return S_FALSE;
			}
			break;
		}
	case methSetCurrentNode:
		{
			if(num < 0)
			{
				CBLModule::RaiseExtRuntimeError("     .",0);
				return S_FALSE;
			}
			
			CValue *pValue = pGetField->GetPValue();
			if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueTable") == pValue->GetTypeString()))
			{
				if(pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							if(CString("CMySuperGrid") == pWnd->GetRuntimeClass()->m_lpszClassName)
							{
								CString stPath = ppValue[0]->GetString();
								if(stPath.IsEmpty())
									break;
								
								if(!stPath.IsEmpty())
								{
									((CMySuperGrid*)pWnd)->SetCurrentByPath(stPath);
									pWnd->Invalidate(FALSE);
								}
							}
						}
					}
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("  .",0);
				return S_FALSE;
			}
			break;
		}
	case methExpandNode:
		{
			if(num < 0)
			{
				CBLModule::RaiseExtRuntimeError("     .",0);
				return S_FALSE;
			}
			
			CValue *pValue = pGetField->GetPValue();
			if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueTable") == pValue->GetTypeString()))
			{
				if(pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							if(CString("CMySuperGrid") == pWnd->GetRuntimeClass()->m_lpszClassName)
							{
								CString stPath = ppValue[0]->GetString();
								if(stPath.IsEmpty())
									stPath = ((CMySuperGrid*)pWnd)->GetCurrentItemIndex();
								
								if(!stPath.IsEmpty())
								{
									((CMySuperGrid*)pWnd)->ExpandNodeByPath(stPath);
									pWnd->Invalidate(FALSE);
								}
							}
						}
					}
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("  .",0);
				return S_FALSE;
			}
			break;
		}
	case methCollapseNode:
		{
			if(num < 0)
			{
				CBLModule::RaiseExtRuntimeError("     .",0);
				return S_FALSE;
			}
			
			CValue *pValue = pGetField->GetPValue();
			if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueTable") == pValue->GetTypeString()))
			{
				if(pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							if(CString("CMySuperGrid") == pWnd->GetRuntimeClass()->m_lpszClassName)
							{
								CString stPath = ppValue[0]->GetString();
								if(stPath.IsEmpty())
									stPath = ((CMySuperGrid*)pWnd)->GetCurrentItemIndex();
								
								if(!stPath.IsEmpty())
								{
									((CMySuperGrid*)pWnd)->CollapseNodeByPath(stPath);
									pWnd->Invalidate(FALSE);
								}
							}
						}
					}
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("  .",0);
				return S_FALSE;
			}
			break;
		}
	case methSetCursor:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd * pView = NULL;
                if(num == -2)
					pView = (CWnd*)pBrowse;
                else
                {
                    POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
                    CWnd * pFrame = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
                    if(pFrame == NULL)
						pFrame = (CWnd*)pDoc->GetFrame();
					
					if(pFrame)
						pView = pFrame->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
				}
				if(pView)
				{
					HCURSOR hCur = NULL;
					bool reset = false;
					if(ppValue[0]->type == 1)
					{
						int sysCursor = ppValue[0]->GetNumeric();
						if(sysCursor == 1)
							hCur = ::LoadCursor(NULL, IDC_ARROW);
						else if(sysCursor == 2)
							hCur = ::LoadCursor(NULL, IDC_IBEAM);
						else if(sysCursor == 3)
							hCur = ::LoadCursor(NULL, IDC_WAIT);
						else if(sysCursor == 4)
							hCur = ::LoadCursor(NULL, IDC_CROSS);
						else if(sysCursor == 5)
							hCur = ::LoadCursor(NULL, IDC_UPARROW);
						else if(sysCursor == 6)
							hCur = ::LoadCursor(NULL, IDC_SIZENWSE);
						else if(sysCursor == 7)
							hCur = ::LoadCursor(NULL, IDC_SIZENESW);
						else if(sysCursor == 8)
							hCur = ::LoadCursor(NULL, IDC_SIZEWE);
						else if(sysCursor == 9)
							hCur = ::LoadCursor(NULL, IDC_SIZENS);
						else if(sysCursor == 10)
							hCur = ::LoadCursor(NULL, IDC_SIZEALL);
						else if(sysCursor == 11)
							hCur = ::LoadCursor(NULL, IDC_NO);
						else if(sysCursor == 12)
							hCur = ::LoadCursor(NULL, IDC_APPSTARTING);
						else if(sysCursor == 13)
							hCur = ::LoadCursor(NULL, IDC_HELP);
						else if(sysCursor == 14)
							hCur = ::LoadCursor(NULL, MAKEINTRESOURCE(32649));//IDC_HAND
						else if(sysCursor == 15)
							hCur = ::LoadCursor(NULL, IDC_APPSTARTING);
						else
							reset = true;
					}
					else if(ppValue[0]->type == 2)
					{
						hCur = ::LoadCursorFromFile(ppValue[0]->GetString());
					}
					if((hCur == NULL) && (reset == false))
						pBkEndUI->DoMessageLine("  .",mmRedErr);
					else if(reset == true)
					{
						int szArr = glCursorWindowsArray.GetSize();
						for(int iContAr = 0; iContAr < szArr; iContAr++)
							if(glCursorWindowsArray.GetAt(iContAr) == (DWORD)pView->GetSafeHwnd())
							{
								glCursorWindowsArray.RemoveAt(iContAr);
								glCursorArray.RemoveAt(iContAr);
								break;
							}
					}
					else
					{
						int szArr = glCursorWindowsArray.GetSize();
						int iContAr = -1;
						if(szArr > 0)
						{
							//szArr++;
							for(iContAr = 0; iContAr < szArr; iContAr++)
								if(glCursorWindowsArray.GetAt(iContAr) == (DWORD)pView->GetSafeHwnd())
									break;
						}
						if((iContAr < 0) || (iContAr == szArr))
						{
							glCursorWindowsArray.Add((DWORD)pView->GetSafeHwnd());
							glCursorArray.Add((DWORD)hCur);
						}
						else
							glCursorArray.SetAt(iContAr,(DWORD)hCur);
					}
				}
			}
			
			break;
		}
	case methUpdateTree:
		{
			if(num < 0)
			{
				CBLModule::RaiseExtRuntimeError("     .",0);
				return S_FALSE;
			}
			
			CValue *pValue = pGetField->GetPValue();
			if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueTable") == pValue->GetTypeString()))
			{
				if(pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							if(CString("CMySuperGrid") == pWnd->GetRuntimeClass()->m_lpszClassName)
							{
								((CMySuperGrid*)pWnd)->InitializeGrid();
							}
						}
					}
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("  .",0);
				return S_FALSE;
			}
			break;
		}
	case methWrapValueTable:
		{
			if(num < 0)
			{
				CBLModule::RaiseExtRuntimeError("     .",0);
				return S_FALSE;
			}
			
			CValue *pValue = pGetField->GetPValue();
			if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueTable") == pValue->GetTypeString()))
			{
				if(pDoc->ExistWindow())
				{
					UINT brID = pDoc->GetBrowseID();
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							CMySuperGrid* pSuperGrid;
							pSuperGrid = new CMySuperGrid;
							
							CWnd* pParent = pWnd->GetParent();
							RECT rect;
							pWnd->GetWindowRect(&rect);
							pParent->ScreenToClient(&rect);
							
							CValueTable* pTable = NULL;
							if(((CBrowse*)pWnd)->pDoc != NULL)
							{
								if(!strcmp(((CBrowse*)pWnd)->pDoc->GetRuntimeClass()->m_lpszClassName,"CTableSkipper"))
								{
									CBLContext* pTblCont = (CBLContext*)*((int**)((CBrowse*)pWnd)->pDoc+5);
									pTable = ((CValueTableContextData*)pTblCont->GetInternalData())->GetValueTable();
								}
							}
							CPictureHolder7 * pic;
							pic = new CPictureHolder7(pControlID->GetPicture());
							DWORD dwStyle = WS_CHILD|WS_BORDER;
//							if(pWnd->IsWindowVisible())
//								dwStyle |= WS_VISIBLE; CGetDoc7

							pSuperGrid->Create(dwStyle,rect,pParent,((CFormCtrl*)pGetField)->m_ID);
							pSuperGrid->m_pDoc = pDoc;

							pSuperGrid->SetWindowPos(pWnd,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
							dwStyle = pWnd->GetStyle();
							if((dwStyle & WS_VISIBLE) != WS_VISIBLE)
								pSuperGrid->ShowWindow(SW_HIDE);

//							pWnd->SetDlgCtrlID(0);
							pWnd->DestroyWindow();

							if(pDoc->m_ActiveCtrl->m_uiID == ((CFormCtrl*)pGetField)->m_ID)
								pSuperGrid->GetFocus();
							
							CBitmap bitmap;
							BOOL bResult = FALSE;
							CDC dcMem;
							CDC* pDC = CWnd::GetDesktopWindow()->GetDC();
							
							if (dcMem.CreateCompatibleDC(pDC))
							{
								CSize hmSize = pic->GetSize();
								
								CBitmap bmMem;
								
								if (bmMem.CreateCompatibleBitmap(pDC, hmSize.cx, 16))
								{
									CBitmap* pOldBM = dcMem.SelectObject(&bmMem);
									
									dcMem.FillSolidRect(0, 0, hmSize.cx, 16, RGB(0x00,0x80,0x80));
									RECT rect1;
									RECT rect2;
									rect1.top = rect1.left = 0;
									rect1.right = hmSize.cx;
									if(hmSize.cy<16) rect1.bottom = hmSize.cy;
									else rect1.bottom = 16;
									
									pic->Render(dcMem, rect1, 0, &rect2);
									
									bResult = bitmap.Attach(bmMem.Detach());
									
									dcMem.SelectObject(pOldBM);
								}
							}
							
							CWnd::GetDesktopWindow()->ReleaseDC(pDC);
							if(bResult)
							{
								CImageList* pImageList = pSuperGrid->GetImageList(LVSIL_SMALL);
								if(pImageList == NULL)
								{
									pImageList = new CImageList;
									pImageList->Create(16, 16, ILC_MASK, 4, 0);
								}
								pImageList->Add(&bitmap, RGB(0x00,0x80,0x80));
								pSuperGrid->SetImageList(pImageList, LVSIL_SMALL);
							}
							delete pic;
							
							pSuperGrid->m_pTable = pTable;
							pSuperGrid->InitializeGrid();
							pSuperGrid->SetFont((CFont*)&pDoc->m_cFont);
							if((brID == 0) || (brID == (UINT)((CFormCtrl*)pGetField)->m_ID))
							{
								pDoc->SetBrowseID((UINT)((CFormCtrl*)pGetField)->m_ID);
								if(pParent->IsKindOf(RUNTIME_CLASS(CBrowseView7)))
									((CBrowseView7*)pParent)->hBrowse = pSuperGrid->GetSafeHwnd();
							}
						}
					}
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("  .",0);
				return S_FALSE;
			}
			break;
		}
        case methWrapValueList:
			{
				if(num < 0)
				{
					CBLModule::RaiseExtRuntimeError("     .",0);
					return S_FALSE;
				}
				
				CValue *pValue = pGetField->GetPValue();
				if(pValue && (CString("") == pValue->GetTypeString() || CString("ValueList") == pValue->GetTypeString()))
				{
					if(pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CWnd* pView = NULL;
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
							if(pWnd)
							{
								CMyComboBox* ComboBox;
								ComboBox = new CMyComboBox;
								
								CWnd* pParent = pWnd->GetParent();
								DWORD dwExStyle = pWnd->GetExStyle();
								DWORD dwStyle = pWnd->GetStyle();
								RECT rect;
								pWnd->GetWindowRect(&rect);
								pParent->ScreenToClient(&rect);
								
								CValueListContext* pVLCont = (CValueListContext*)pGetField->GetBLContext();
								
								int n = pVLCont->GetCtrlSel();
								
								pWnd->DestroyWindow();
								dwStyle &= 0xFFFFFFFC;
								dwStyle |= CBS_DROPDOWN;
								
								rect.bottom += (rect.bottom - rect.top)*5;
								ComboBox->Create(dwStyle,rect,pParent,((CFormCtrl*)pGetField)->m_ID);
								ComboBox->SetFont((CFont*)&pDoc->m_cFont);
								
								CItemList ItemList;
								pVLCont->ToList(ItemList);
								pVLCont->SetCtrl(ComboBox->GetSafeHwnd());
								pVLCont->FromList(ItemList);
								pVLCont->SetCtrlSel(n);
							}
						}
					}
				}
				else
				{
					CBLModule::RaiseExtRuntimeError("  .",0);
					return S_FALSE;
				}
				
				break;
			}
        case methGetCoordinates: // TODO:    /1- 
			{
				CRect mRect(0,0,0,0);
				if(num == -2)
				{
					if(pBrowse)
					{
						pBrowse->GetWindowRect(&mRect);
						if(ppValue[4]->GetNumeric() != 1)
						{
							POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
							CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
							if(pView)
								pView->ScreenToClient(&mRect);
							else
							{
								CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
								if(pGetDlg)
								{
									pGetDlg->ScreenToClient(&mRect);
								}
							}
						}
					}
				}
				else
				{
					mRect = pControlID->GetPlace();
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
						if(pView)
						{
							CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
							if(pWnd)
							{
								pWnd->GetWindowRect(&mRect);
								if(ppValue[4]->GetNumeric() != 1)
									pView->ScreenToClient(&mRect);
							}
						}
						else
						{
							CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
							if(pGetDlg)
							{
								CWnd* pWnd = pGetDlg->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
								if(pWnd)
								{
									pWnd->GetWindowRect(&mRect);
									if(ppValue[4]->GetNumeric() != 1)
										pGetDlg->ScreenToClient(&mRect);
								}
							}
						}
					}
				}
				(*ppValue[0]) = mRect.left;
				(*ppValue[1]) = mRect.top;
				(*ppValue[2]) = mRect.right - mRect.left;
				(*ppValue[3]) = mRect.bottom - mRect.top;
				break;
			}
        case methSetCoordinates:
			{
				CRect mRect(0,0,0,0);
				
				if(num == -2)
				{
					if(pBrowse)
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
						if(pView)
						{
							pBrowse->GetWindowRect(&mRect);
							if(ppValue[4]->GetNumeric() != 1)
								pView->ScreenToClient(&mRect);
							if(ppValue[0]->GetNumeric()>=0)
							{
								int oldLeft = mRect.left;
								mRect.left = ppValue[0]->GetNumeric();
								if(ppValue[2]->GetNumeric()<=0)
									mRect.right = mRect.right + mRect.left - oldLeft;
							}
							if(ppValue[1]->GetNumeric()>=0)
							{
								int oldTop = mRect.top;
								mRect.top = ppValue[1]->GetNumeric();
								if(ppValue[3]->GetNumeric()<=0)
									mRect.bottom = mRect.bottom + mRect.top - oldTop;
							}
							if(ppValue[2]->GetNumeric()>0)
								mRect.right = mRect.left + ppValue[2]->GetNumeric();
							if(ppValue[3]->GetNumeric()>0)
								mRect.bottom = mRect.top + ppValue[3]->GetNumeric();
							
							if(ppValue[4]->GetNumeric() == 1)
								pView->ScreenToClient(&mRect);

							pBrowse->MoveWindow(mRect);
							
							pBrowse->RedrawWindow();
						}
						else
						{
							CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
							if(pGetDlg)
							{
								pBrowse->GetWindowRect(&mRect);
								if(ppValue[4]->GetNumeric() != 1)
									pGetDlg->ScreenToClient(&mRect);
								if(ppValue[0]->GetNumeric()>=0)
								{
									int oldLeft = mRect.left;
									mRect.left = ppValue[0]->GetNumeric();
									if(ppValue[2]->GetNumeric()<=0)
										mRect.right = mRect.right + mRect.left - oldLeft;
								}
								if(ppValue[1]->GetNumeric()>=0)
								{
									int oldTop = mRect.top;
									mRect.top = ppValue[1]->GetNumeric();
									if(ppValue[3]->GetNumeric()<=0)
										mRect.bottom = mRect.bottom + mRect.top - oldTop;
								}
								if(ppValue[2]->GetNumeric()>0)
									mRect.right = mRect.left + ppValue[2]->GetNumeric();
								if(ppValue[3]->GetNumeric()>0)
									mRect.bottom = mRect.top + ppValue[3]->GetNumeric();
								
								if(ppValue[4]->GetNumeric() == 1)
									pGetDlg->ScreenToClient(&mRect);

								pBrowse->MoveWindow(mRect);
								
								pBrowse->RedrawWindow();
							}
						}
					}
				}
				else
				{
					mRect = pControlID->GetPlace();
					
					if(ppValue[0]->GetNumeric()>=0)
					{
						int oldLeft = mRect.left;
						mRect.left = ppValue[0]->GetNumeric();
						if(ppValue[2]->GetNumeric()<=0)
							mRect.right = mRect.right + mRect.left - oldLeft;
					}
					if(ppValue[1]->GetNumeric()>=0)
					{
						int oldTop = mRect.top;
						mRect.top = ppValue[1]->GetNumeric();
						if(ppValue[3]->GetNumeric()<=0)
							mRect.bottom = mRect.bottom + mRect.top - oldTop;
					}
					if(ppValue[2]->GetNumeric()>0)
						mRect.right = mRect.left + ppValue[2]->GetNumeric();
					if(ppValue[3]->GetNumeric()>0)
						mRect.bottom = mRect.top + ppValue[3]->GetNumeric();
					
					pControlID->SetPlace(mRect);
					
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
						if(pView)
						{
							CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
							if(pWnd)
							{
								pWnd->GetWindowRect(&mRect);
								if(ppValue[4]->GetNumeric() != 1)
									pView->ScreenToClient(&mRect);
								if(ppValue[0]->GetNumeric()>=0)
								{
									int oldLeft = mRect.left;
									mRect.left = ppValue[0]->GetNumeric();
									if(ppValue[2]->GetNumeric()<=0)
										mRect.right = mRect.right + mRect.left - oldLeft;
								}
								if(ppValue[1]->GetNumeric()>=0)
								{
									int oldTop = mRect.top;
									mRect.top = ppValue[1]->GetNumeric();
									if(ppValue[3]->GetNumeric()<=0)
										mRect.bottom = mRect.bottom + mRect.top - oldTop;
								}
								if(ppValue[2]->GetNumeric()>0)
									mRect.right = mRect.left + ppValue[2]->GetNumeric();
								if(ppValue[3]->GetNumeric()>0)
									mRect.bottom = mRect.top + ppValue[3]->GetNumeric();
								
								if(ppValue[4]->GetNumeric() == 1)
									pView->ScreenToClient(&mRect);

								pWnd->MoveWindow(mRect);
								
								int CtrlType = pControlID->GetCtrlType();
								if (CtrlType == 4 || CtrlType == 12 || CtrlType == 13)
									pWnd->Invalidate();
								else if(CtrlType==1){
									CWnd *child=pWnd->GetWindow(GW_CHILD);
									if(child){
										child->MoveWindow(0,0,mRect.right-mRect.left,mRect.bottom-mRect.top);
										child->Invalidate();
									}
								}
								else
									pWnd->RedrawWindow();
							}
						}
						else
						{
							CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
							if(pGetDlg)
							{
								CWnd* pWnd = pGetDlg->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
								if(pWnd)
								{
									pWnd->GetWindowRect(&mRect);
									if(ppValue[4]->GetNumeric() != 1)
										pGetDlg->ScreenToClient(&mRect);
									if(ppValue[0]->GetNumeric()>=0)
									{
										int oldLeft = mRect.left;
										mRect.left = ppValue[0]->GetNumeric();
										if(ppValue[2]->GetNumeric()<=0)
											mRect.right = mRect.right + mRect.left - oldLeft;
									}
									if(ppValue[1]->GetNumeric()>=0)
									{
										int oldTop = mRect.top;
										mRect.top = ppValue[1]->GetNumeric();
										if(ppValue[3]->GetNumeric()<=0)
											mRect.bottom = mRect.bottom + mRect.top - oldTop;
									}
									if(ppValue[2]->GetNumeric()>0)
										mRect.right = mRect.left + ppValue[2]->GetNumeric();
									if(ppValue[3]->GetNumeric()>0)
										mRect.bottom = mRect.top + ppValue[3]->GetNumeric();
									
									if(ppValue[4]->GetNumeric() == 1)
										pGetDlg->ScreenToClient(&mRect);

									pWnd->MoveWindow(mRect);
									
									int CtrlType = pControlID->GetCtrlType();
									if (CtrlType == 1 || CtrlType == 4 || CtrlType == 12 || CtrlType == 13)
										pWnd->Invalidate();
									else
										pWnd->RedrawWindow();
								}
							}
						}
					}
				}
				break;
			}
        default:
			return S_FALSE;
        };
        return S_OK;
}


int  CAttribEx::FindMethod(char const * lpMethodName)const
{
	int i;
	for (i = 0;i<lastMethod;i++){
		if (!stricmp(lpMethodName,defFnNames[i].Names[0]))
			return i;
		if (!stricmp(lpMethodName,defFnNames[i].Names[1]))
			return i;
	}
	return -1;
}

char const *  CAttribEx::GetMethodName(int iMethodNum,int iMethodAlias)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].Names[iMethodAlias];
	return 0;
}

int  CAttribEx::GetNMethods(void)const
{
	return lastMethod;
}

int  CAttribEx::HasRetVal(int iMethodNum)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].HasReturnValue;
	return 0;
}

int CAttribEx::GetNParams(int iMethodNum)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].NumberOfParams;
	return 0;
}

int  CAttribEx::GetParamDefValue(int iMethodNum,int iParamNum,class CValue * pDefValue)const
{
	switch (iMethodNum) {
	case methSetCoordinates:
	case methGetCoordinates:
	case methTreeOptions:
	case methSetCursor:
		{
			*pDefValue = -1;
			break;
		}
	case methSetCurrentNode:
	case methIsGroupNode:
    case methExpandNode:
	case methCollapseNode:
		{
			*pDefValue = CString("");
			break;
		}
	case methValueFromTree:
		{
			if(iParamNum == 0)
				*pDefValue = CString("");
			else
				*pDefValue = 1;
			break;
		}
	case methModifyStyle:
	case methModifyStyleEx:
		{
			*pDefValue = 0L;
			break;
		}
	default:
		return 0;
	};
	return 1;
}

void  CAttribEx::DecrRef(void)
{
	CBLContext::DecrRef();
}

char const *  CAttribEx::GetCode(void)const
{
	return 0;
}

int  CAttribEx::GetDestroyUnRefd(void)const
{
	return 1;
}

void  CAttribEx::GetExactValue(class CValue & vParam)
{
	CBLContext::GetExactValue(vParam);
}

class CObjID   CAttribEx::GetID(void)const
{
	return ObjID;
}

class CBLContextInternalData *  CAttribEx::GetInternalData(void)
{
	
	return CBLContext::GetInternalData();
	
}

long  CAttribEx::GetTypeID(void)const
{
	return 100;
}

char const *  CAttribEx::GetTypeString(void)const
{
	return "";
}

class CType   CAttribEx::GetValueType(void)const
{
	CType tType(100);
	
	return tType;
}

void  CAttribEx::IncrRef(void)
{
	CBLContext::IncrRef();
}

void  CAttribEx::InitObject(class CType const & tType)
{
	CBLContext::InitObject(tType);
}

void  CAttribEx::InitObject(char const * strName)
{
	CBLContext::InitObject(strName);
}

int  CAttribEx::IsExactValue(void)const
{
	return 0;
}

int  CAttribEx::IsOleContext(void)const
{
	return 0;
}

int  CAttribEx::IsPropReadable(int iPropNum)const
{
	if ((iPropNum>=0) && (iPropNum<lastProp))
		return defPropNames[iPropNum].IsReadable;
	return 0;
}

int  CAttribEx::IsPropWritable(int iPropNum)const
{
	if ((iPropNum>=0) && (iPropNum<lastProp))
		return defPropNames[iPropNum].IsWritable;
	return 0;
}

int  CAttribEx::IsSerializable(void)
{
	return 0;
}

int  CAttribEx::SaveToString(class CString & csStr)
{
	csStr = "";
	return 1;
}

void  CAttribEx::SelectByID(class CObjID cID,long lNum)
{
	CBLContext::SelectByID(cID,lNum);
}

int  CAttribEx::GetNProps(void)const
{
	return lastProp;
}

char const *  CAttribEx::GetPropName(int iPropNum,int iPropAlias)const
{
	if ((iPropNum>=0) && (iPropNum<lastProp))
		return defPropNames[iPropNum].Names[iPropAlias];
	return NULL;
}

int  CAttribEx::GetPropVal(int iPropNum,class CValue & rValue)const
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}
	
	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
	CGetFieldsArray* pGetFieldsArray = NULL;
	CGetField* pGetField = NULL;
	CControlID* pControlID = NULL;
	CBrowse* pBrowse = NULL;
	if(num == -2)
	{
		if(pDoc->ExistWindow())
			pBrowse = ((CGetDoc*)m_Form->m_GetDoc)->GetBrowse();
	}
	else
	{
		pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
		pGetField = pGetFieldsArray->GetAt(num);
		pControlID = pGetField->GetCtrlInfo();
	}
	
	switch (iPropNum) {
	case propCaption:
		{
			if(num != -2)
				rValue = pControlID->GetTitle();
			break;
		}
	case propHint:
		{
			if(num != -2)
				rValue = pControlID->GetToolTip();
			break;
		}
	case propDescription:
		{
			if(num != -2)
				rValue = pControlID->GetHelpString();
			break;
		}
	case propFormula:
		{
			if(num != -2)
				rValue = pControlID->GetFormul();
			break;
		}
	case propVisible:
		{
			if(num == -2)
			{
				if(pBrowse) rValue = pBrowse->IsWindowVisible();
			}
			else
			{
				CBrowse* pBrowse = pDoc->GetBrowse();
				if (pBrowse){
					if (pGetField->m_InTable){
						CColumn& col = pBrowse->GetColumn(pGetField->m_ID);
						long res = (col.m_StyleEx & C_BROWSE_STYLE_EX_DONOT_VISIBLE) ? 0 : 1;
						rValue = res;
					}

				}
				else
					if(((CFormCtrl*)pGetField)->m_RefFlag==0)
					{
						unsigned long lStyleEx = pControlID->GetExStyle();
						rValue = (lStyleEx & CS_EX_VISIBLE);
					}
					else
						rValue = ((CFormCtrl*)pGetField)->m_Visible;
			}
			break;
		}
	case propReadOnly:
		{
			if(num != -2)
				rValue = pGetField->GetReadOnly();
			break;
		}
	case propLayer:
		{
			if(num != -2)
				rValue = pControlID->GetLayerName();
			break;
		}
	case propValue:
		{
			if(num != -2)
			{
				CValue* pValue = pGetField->GetPValue();
				if(pValue)
				{
					pValue->LinkContext(TRUE);
					rValue = *pValue;
				}
			}
			break;
		}
	case propAttribID:
		{
			if(num != -2)
				rValue = pControlID->GetCodeName();
			else
				rValue = CString("");
			break;
		}
	case propType:
		{
			if(num != -2)
				rValue = pControlID->GetCtrlType();
			break;
		}
	case propBkColor:
		{
			if(pControlID)
			{
				rValue = pControlID->GetBkColor();
			}
			break;
		}
	case propFontColor:
		{
			if(pControlID)
			{
				rValue = pControlID->GetFontColor();
			}
			break;
		}
	case propMask:
	case propRelated:
		{
			if(num != -2)
			{
				if(pControlID)
				{
					rValue = CString(pControlID->m_SDependParam);
				}
			}
			break;
		}
	case propFont:
		{
			rValue = 0L;
			if(num != -2)
			{
				if(pControlID)
				{
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CWnd* pView = NULL;
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
							if(pWnd)
							{
								CFont* pFont = pWnd->GetFont();
								rValue = (DWORD)pFont->GetSafeHandle();
							}
						}
					}
				}
			}
			else if(pBrowse)
			{
				rValue = pBrowse->m_br_Font;
			}
			break;
		}
	case propClass:
		{
			rValue = "";
			if(num != -2)
			{
				if(pGetField)
				{
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CWnd* pView = NULL;
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
							if(pWnd)
							{
								rValue = PrintRTC(pWnd);
							}
						}
					}
				}
			}
			break;
		}
	case propBorder:
		{
			rValue = 0L;
			if(num != -2)
			{
				if(pControlID)
				{
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CWnd* pView = NULL;
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
							if(pWnd)
							{
								if(pWnd->GetStyle() & WS_BORDER)
									rValue = 1L;
							}
						}
					}
				}
			}
			else if(pBrowse)
			{
				if(pBrowse->GetStyle() & WS_BORDER)
					rValue = 1L;
			}
			break;
		}
	case propHandle:
		{
			rValue = 0L;
			if(num != -2)
			{
				if(pControlID)
				{
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CWnd* pView = NULL;
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
							if(pWnd)
							{
								rValue = (long)pWnd->GetSafeHwnd();
							}
						}
					}
				}
			}
			else if(pBrowse)
			{
				rValue = (long)pBrowse->GetSafeHwnd();
			}
			break;
		}
	case propStyle:
		{
			if(num != -2)
			{
				if(pControlID)
				{
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CWnd* pView = NULL;
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							CWnd* pWnd = pView->GetDlgItem(pGetField->m_ID);
							if(pWnd)
							{
								//pWnd->ModifyStyle(0xFFFFFFFF,dwNewStyle,SWP_DRAWFRAME);
								rValue = (long)pWnd->GetStyle();
							}
						}
					}
				}
			}
			else if(pBrowse)
			{
				//pBrowse->ModifyStyle(0xFFFFFFFF,dwNewStyle,SWP_DRAWFRAME);
				rValue = (long)pBrowse->GetStyle();
			}
			break;
		}
	case propStyleEx:
		{
			if(num != -2)
			{
				if(pControlID)
				{
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CWnd* pView = NULL;
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							CWnd* pWnd = pView->GetDlgItem(pGetField->m_ID);
							if(pWnd)
							{
								//pWnd->ModifyStyleEx(0xFFFFFFFF,dwNewStyle,SWP_DRAWFRAME);
								rValue = (long)pWnd->GetStyle();
							}
						}
					}
				}
			}
			else if(pBrowse)
			{
				//pBrowse->ModifyStyleEx(0xFFFFFFFF,dwNewStyle,SWP_DRAWFRAME);
				rValue = (long)pBrowse->GetStyle();
			}
			break;
		}
	case propFocus:
		{
			rValue = 0L;
			CWnd* pWnd = NULL;
			CWnd* pView = NULL;
			if(num != -2)
			{
				if(pControlID)
				{
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							pWnd = pView->GetDlgItem(pGetField->m_ID);
						}
					}
				}
			}
			else if(pBrowse)
			{
				if (pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
				}
				pWnd = pBrowse;
			}
			if((pView != NULL) && (pWnd != NULL))
			{
				if(pView->GetFocus() == pWnd)
					rValue = 1;
			}
			break;
		}
	default:
		return S_FALSE;
	};
	return S_OK;
}

typedef long (CBrowse::*PF_GETSETFONT)(UINT, long);

extern union PtrConvFONT{
	void* pV;
	PF_GETSETFONT pGetFont;
	PF_GETSETFONT pSetFont;
} prtconvFont;

int  CAttribEx::SetPropVal(int iPropNum,class CValue const & vValue)
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}
	
	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
	CGetFieldsArray* pGetFieldsArray = NULL;
	CGetField* pGetField = NULL;
	CControlID* pControlID = NULL;
	CBrowse* pBrowse = NULL;
	if(num == -2)
	{
		if(pDoc->ExistWindow())
			pBrowse = ((CGetDoc*)pDoc)->GetBrowse();
	}
	else
	{
		pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
		pGetField = pGetFieldsArray->GetAt(num);
		pControlID = pGetField->GetCtrlInfo();
	}
	
	switch (iPropNum) {
/*
	case propDoc:
		{
			if(pBrowse)
			{
				CBLContext* pBLContext = vValue.GetContext();
				if (pBLContext->GetInternalData()->GetRuntimeClass() == RUNTIME_CLASS(CValueTableContextData))
				{
					CValueTableContextData* pVTContextData = static_cast<CValueTableContextData*>(pBLContext->GetInternalData());
					if(pVTContextData)
					{
						pVTContextData->GetValueTable()
						pBrowse->SetSkipper(NULL,0);
					}
				}
			}
			break
		}
*/
	case propCaption:
		{
			if(num != -2)
			{
				pControlID->SetTitle(vValue.GetString());
				
				if (pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
					if(pView)
						pView->SetDlgItemText(((CFormCtrl*)pGetField)->m_ID,(LPCSTR)vValue.GetString());
				}
			}
			break;
		}
	case propHint:
		{
			if(num != -2)
			{
				pControlID->SetToolTip((LPCSTR)vValue.GetString());
				
				if (pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							CToolTip7 * pToolTipCtrl = &(pDoc->GetToolTipCtrl());
							if(pToolTipCtrl)
							{
								TOOLINFO ti;
								ZeroMemory(&ti,sizeof(TOOLINFO));
								ti.cbSize = sizeof(TOOLINFO);
								ti.hwnd = pView->GetSafeHwnd();
								ti.uFlags = TTF_IDISHWND;
								ti.uId = (UINT)(pWnd->GetSafeHwnd());
								LPCTSTR szText = (LPCSTR)vValue.GetString();
								ti.lpszText = LPSTR( szText ? szText : LPSTR_TEXTCALLBACK);
								SendMessage(pToolTipCtrl->m_ToolTipCtrl, TTM_UPDATETIPTEXT, 0, (LPARAM)&ti);
							}
						}
					}
					else
					{
						CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
						if(pGetDlg)
						{
							CWnd* pWnd = pGetDlg->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
							if(pWnd)
							{
								CToolTip7 * pToolTipCtrl = &(pDoc->GetToolTipCtrl());
								if(pToolTipCtrl)
								{
									TOOLINFO ti;
									ZeroMemory(&ti,sizeof(TOOLINFO));
									ti.cbSize = sizeof(TOOLINFO);
									ti.hwnd = pView->GetSafeHwnd();
									ti.uFlags = TTF_IDISHWND;
									ti.uId = (UINT)(pWnd->GetSafeHwnd());
									LPCTSTR szText = (LPCSTR)vValue.GetString();
									ti.lpszText = LPSTR( szText ? szText : LPSTR_TEXTCALLBACK);
									SendMessage(pToolTipCtrl->m_ToolTipCtrl, TTM_UPDATETIPTEXT, 0, (LPARAM)&ti);
								}
							}
						}
					}
				}
			}
			break;
		}
	case propDescription:
		{
			if(num != -2)
				pControlID->SetHelpString((LPCSTR)vValue.GetString());
			break;
		}
	case propFormula:
		{
			if(num != -2)
				pControlID->SetFormul(vValue.GetString());
			break;
		}
	case propVisible:
		{
			if(num == -2)
			{
				pDoc->SetBrowseVisible(vValue.GetNumeric(), 1);
//				CEmptySkipper* pSkipper;
//				pSkipper = new CEmptySkipper();
//				pBrowse->SetSkipper(pSkipper,1);
			}
			else
			{
				if (pDoc->ExistWindow())
				{
					CBrowse* pBrowse = pDoc->GetBrowse();
					if (pBrowse && pGetField->m_InTable){
 						if ((long)vValue.GetNumeric())
 							pBrowse->ShowColumn(pGetField->m_ID);
						else
 							pBrowse->HideColumn(pGetField->m_ID);
						break;
					}
					
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						
						if(pWnd)
						{
							if(vValue.GetNumeric()==0)
								pWnd->ShowWindow(SW_HIDE);
							else
								pWnd->ShowWindow(SW_SHOW);
						}
					}
					else
					{
						CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
						if(pGetDlg)
						{
							CWnd* pWnd = pGetDlg->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
							if(pWnd)
							{
								if(vValue.GetNumeric()==0)
									pWnd->ShowWindow(SW_HIDE);
								else
									pWnd->ShowWindow(SW_SHOW);
							}
						}
					}
				}
				((CFormCtrl*)pGetField)->m_RefFlag = 1;
				((CFormCtrl*)pGetField)->m_Visible = vValue.GetNumeric();
			}
			break;
		}
	case propReadOnly:
		{
			if(num != -2)
				pGetField->SetReadOnly(vValue.GetNumeric()==0);
			break;
		}
	case propLayer:
		{
			if(num != -2)
				pControlID->SetLayerName((LPCSTR)vValue.GetString());
			break;
		}
	case propValue:
		{
			if(num != -2)
			{
				CValue* pValue = pGetField->GetPValue();
				if(pValue)
				{
					*pValue = vValue;
					pGetField->SetPValue(pValue);
				}
			}
			break;
		}
	case propBkColor:
		{
			if(pControlID)
			{
				if (pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							if(CString("CBrowse") == pWnd->GetRuntimeClass()->m_lpszClassName)
							{
								((CBrowse*)pWnd)->SetBkColor(vValue.GetNumeric());
								pWnd->RedrawWindow();
							}
							else
							{
								DWORD* userdata = (DWORD*)GetWindowLong(pWnd->GetSafeHwnd(),0);
								(*(userdata)) = vValue.GetNumeric(); // userdata+3 -  
								
								//(*(userdata+0x25)) = 1;
								//+6 - border
								//+2 - negative color
								//+3 - text color
								//+32h - font flag
								//+4 - font
								//+1 - highlight color
								//47h - parent params flag
								//10h - outtext brush flag
								//Eh -   0    (  )
								
								
								pWnd->RedrawWindow();
								//WM_CTLCOLORSTATIC
								
								//                                                      if(oldWndProc == NULL)
								//                                                      {
								
								//                                                              {
								//                                                                      WNDCLASS wndClass;
								//                                                                      AFX_MANAGE_STATE(AfxGetStaticModuleState())
								//                                                                      GetClassInfo(0,"1CEDITSPR",&wndClass); //BMASKED 1CEDITSPR
								//                                                              CString st = "";
								//                                                              st.Format("%x", wndClass.lpfnWndProc);
								//                                                              pBkEndUI->DoMessageLine(st);
								
								//                                                                      oldWndProc = wndClass.lpfnWndProc;
								//                                                                      wndClass.lpfnWndProc = newWndProc;
								
								//                                                                      if(!AfxRegisterClass(&wndClass))
								//                                                                              pBkEndUI->DoMessageLine("OBLOM!");
								//                                                                      else
								//                                                                              pBkEndUI->DoMessageLine("OK!");
								//                                                              }
								//                                                      }
								
								
								//                                                      char strClassName[0x10];
								//                                                      GetClassName(pWnd->GetSafeHwnd(),strClassName, 0x0f);
								//                                                      pBkEndUI->DoMessageLine(strClassName); //CBtnEdit
							}
						}
					}
				}
				pControlID->SetBkColor(vValue.GetNumeric());
			}
			else if(pBrowse)
			{
				pBrowse->SetBkColor(vValue.GetNumeric());
				pBrowse->RedrawWindow();
			}
			
			break;
		}
	case propFontColor:
		{
			if(pControlID)
			{
				if (pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = NULL;
					pView = ((CDocument*)pDoc)->GetNextView(aPOS);
					if(!pView)
						pView = pDoc->GetFrame();
					if(pView)
					{
						CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							DWORD* userdata = (DWORD*)GetWindowLong(pWnd->GetSafeHwnd(),0);
							(*(userdata+3)) = vValue.GetNumeric();
							
							pWnd->RedrawWindow();
						}
					}
				}
				pControlID->SetBkColor(vValue.GetNumeric());
			}
			break;
		}
	case propMask:
	case propRelated:
		{
			if(num != -2)
			{
				if(pControlID)
				{
					pControlID->SetDependParam(vValue.GetString());
					pGetField->TranslateType();
					pGetField->UpdateState();
				}
			}
			break;
		}
	case propFont:
		{
			DWORD hFont = vValue.GetNumeric();
			if(num != -2)
			{
				if(pControlID)
				{
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CWnd* pView = NULL;
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							CFont* pFont = CFont::FromHandle((HFONT)hFont);
							CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
							if(pWnd)
							{
								CFont* pOldFont = pWnd->GetFont();
								//  
								UINT CtrlType = pControlID->GetCtrlType();
								switch(CtrlType)
								{
								case 1://STATIC ()
									{
										break;
									}
								case 2://1CEDIT ( )
									{
										break;
									}
								case 3://BUTTON ()
									{
										break;
									}
								case 4://1CGROUPBOX ( )
									{
										((DWORD*)pWnd)[0x11] = hFont;
										break;
									}
								case 5://1CEDIT (   )
									{
										break;
									}
								case 8://SysTreeView32 ( )
									{
										break;
									}
								case 9://STATIC (       )
									{
										break;
									}
								case 10://PICTURE ()
									{
										break;
									}
								case 11://LISTBOX ()
									{
										//CCheckListBox7
										break;
									}
								case 12://CHECKBOX ()
									{
//										pWnd->ModifyStyle(0, BS_3STATE);
										break;
									}
								case 13://RADIO ()
									{
//										pWnd->ModifyStyle(0, BS_OWNERDRAW);
										break;
									}
								case 14://COMBOBOX (  )
									{
										break;
									}
								case 15://TABLE ()
									{
										break;
									}
								default: 
									{
									}
								};

								pWnd->SetFont(pFont);
							}
							LOGFONT lFont;
							GetObject((HFONT)hFont, sizeof(LOGFONT), (LPSTR)&lFont);
							pControlID->SetFont(&lFont);
						}
					}
				}
			}
			else if(pBrowse)
			{
				HINSTANCE hBr32=GetModuleHandle("br32.dll");
				BYTE* adr1;
				adr1=(BYTE*)GetProcAddress(hBr32,"?SetFont@CBrowse@@IAEJIJ@Z");
				prtconvFont.pV = adr1;
				(pBrowse->*prtconvFont.pSetFont)((UINT)hFont,0);
			}
			break;
		}
	case propBorder:
		{
			if(num != -2)
			{
				if(pControlID)
				{
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CWnd* pView = NULL;
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							CWnd* pWnd = pView->GetDlgItem(pGetField->m_ID);
							if(pWnd)
							{
								BOOL bBorder = (1L == vValue.GetNumeric());
								if(bBorder)
								{
									pWnd->ModifyStyle(0,WS_BORDER|WS_MINIMIZEBOX,SWP_DRAWFRAME);
									pWnd->ModifyStyleEx(0,WS_EX_CLIENTEDGE,SWP_DRAWFRAME);
								}
								else
								{
									pWnd->ModifyStyle(WS_BORDER|WS_MINIMIZEBOX,0,SWP_DRAWFRAME);
									pWnd->ModifyStyleEx(WS_EX_CLIENTEDGE,0,SWP_DRAWFRAME);
									CWnd* pWndCh = pWnd->GetNextWindow(GW_CHILD);
									if(pWndCh)
									{
										CRect rectCl;
										pWnd->GetWindowRect(rectCl);
										pWnd->ScreenToClient(rectCl);
										rectCl.InflateRect(1,2,1,2);
										pWndCh->MoveWindow(rectCl);
									}
								}
							}
						}
					}
				}
			}
			else if(pBrowse)
			{
				BOOL bBorder = (1L == vValue.GetNumeric());
				if(bBorder)
				{
					pBrowse->ModifyStyle(0,WS_BORDER|WS_MINIMIZEBOX,SWP_DRAWFRAME);
					pBrowse->ModifyStyleEx(0,WS_EX_CLIENTEDGE,SWP_DRAWFRAME);
				}
				else
				{
					pBrowse->ModifyStyle(WS_BORDER|WS_MINIMIZEBOX,0,SWP_DRAWFRAME);
					pBrowse->ModifyStyleEx(WS_EX_CLIENTEDGE,0,SWP_DRAWFRAME);
				}
			}
			break;
		}
	case propParentWindow:
		{
			if(num != -2)
			{
				if(pControlID)
				{
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CWnd* pView = NULL;
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							CWnd* pWnd = pDoc->GetFieldWnd(pGetField);
							if(pWnd)
							{
								CBLContext* pCont = vValue.GetContext();
								if(pCont)
								{
									if(CString("CFormCtrlContext") == pCont->GetRuntimeClass()->m_lpszClassName)
									{
										CGetField* pGetFieldParent = ((CFormCtrlContext*)pCont)->m_pGetField;
										if(pGetFieldParent)
										{
											CWnd* pWndParent = pView->GetDlgItem(pGetFieldParent->m_ID);
											CRect rectCl;
											pWnd->GetWindowRect(rectCl);
											//CBrowse
											pWnd->SetParent(pWndParent);
											pWndParent->ScreenToClient(rectCl);
											pWnd->MoveWindow(rectCl);
										}
									}
								}
								else
								{
									CRect rectCl;
									pWnd->GetWindowRect(rectCl);
									//CBrowse
									pWnd->SetParent(pView);
									pView->ScreenToClient(rectCl);
									pWnd->MoveWindow(rectCl);
								}
							}
						}
					}
				}
			}
			break;
		}
	case propStyle:
		{
			DWORD dwNewStyle = vValue.GetNumeric();
			if(num != -2)
			{
				if(pControlID)
				{
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CWnd* pView = NULL;
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							CWnd* pWnd = pView->GetDlgItem(pGetField->m_ID);
							if(pWnd)
							{
								pWnd->ModifyStyle(0xFFFFFFFF,dwNewStyle,SWP_DRAWFRAME);
								//pWnd->GetStyle();
							}
						}
					}
				}
			}
			else if(pBrowse)
			{
				pBrowse->ModifyStyle(0xFFFFFFFF,dwNewStyle,SWP_DRAWFRAME);
				//pBrowse->GetStyle();
			}
			break;
		}
	case propStyleEx:
		{
			DWORD dwNewStyle = vValue.GetNumeric();
			if(num != -2)
			{
				if(pControlID)
				{
					if (pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CWnd* pView = NULL;
						pView = ((CDocument*)pDoc)->GetNextView(aPOS);
						if(!pView)
							pView = pDoc->GetFrame();
						if(pView)
						{
							CWnd* pWnd = pView->GetDlgItem(pGetField->m_ID);
							if(pWnd)
							{
								pWnd->ModifyStyleEx(0xFFFFFFFF,dwNewStyle,SWP_DRAWFRAME);
								//pWnd->GetStyle();
							}
						}
					}
				}
			}
			else if(pBrowse)
			{
				pBrowse->ModifyStyleEx(0xFFFFFFFF,dwNewStyle,SWP_DRAWFRAME);
				//pBrowse->GetStyle();
			}
			break;
		}
	case propPicture:
		{
			if(num != -2)
			{
				if(pControlID)
				{
					if (pDoc->ExistWindow())
					{
						HBITMAP hBitmap = NULL;
						CGalleryHolder * pGalleryHolder = CGalleryHolder::GetGallery();
						if(pGalleryHolder)
						{
							ULONG picID = pGalleryHolder->FindByAlias(vValue.GetString());
							if(picID)
							{
								CPictureHolder7 * pic;
								pic = new CPictureHolder7(pGalleryHolder->GetPicture(picID));

								CDC dcMem;
								CDC* pDC = CWnd::GetDesktopWindow()->GetDC();

								if (dcMem.CreateCompatibleDC(pDC))
								{
									CSize hmSize = pic->GetSize();

									CBitmap bmMem;

									if (bmMem.CreateCompatibleBitmap(pDC, hmSize.cx, hmSize.cy))
									{
										CBitmap* pOldBM = dcMem.SelectObject(&bmMem);

										//dcMem.FillSolidRect(0, 0, hmSize.cx, hmSize.cy, RGB(0x00,0x80,0x80));
										RECT rect1;
										RECT rect2;
										rect1.top = rect1.left = 0;
										rect1.right = hmSize.cx;
										rect1.bottom = hmSize.cy;
											
										pic->Render(dcMem, rect1, 0, &rect2);

										hBitmap = (HBITMAP)bmMem.Detach();

										dcMem.SelectObject(pOldBM);
									}
								}

								CWnd::GetDesktopWindow()->ReleaseDC(pDC);

								delete pic;
							}
						}
						if(hBitmap)
						{
							POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
							CWnd* pView = NULL;
							pView = ((CDocument*)pDoc)->GetNextView(aPOS);
							if(!pView)
								pView = pDoc->GetFrame();
							if(pView)
							{
								CWnd* pWnd = pView->GetDlgItem(pGetField->m_ID);
								if(pWnd)
								{
									pWnd->SendMessage(BM_SETIMAGE, (WPARAM)IMAGE_BITMAP, (LPARAM)hBitmap);
								}
							}
						}
					}
				}
			}
			break;
		}
	case propFocus:
		{
			if(1 == vValue.GetNumeric())
			{
				if(num != -2)
				{
					if(pControlID)
					{
						if (pDoc->ExistWindow())
						{
							POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
							CWnd* pView = NULL;
							pView = ((CDocument*)pDoc)->GetNextView(aPOS);
							if(!pView)
								pView = pDoc->GetFrame();
							if(pView)
							{
								CWnd* pWnd = pView->GetDlgItem(pGetField->m_ID);
								if(pWnd)
								{
									pWnd->SetFocus();
								}
							}
						}
					}
				}
				else if(pBrowse)
				{
					pBrowse->SetFocus();
				}
			}
			break;
		}
	default:
		return S_FALSE;
        };
        return S_OK;
}

int  CAttribEx::FindProp(char const * lpPropName)const
{
	int i;
	for (i = 0;i<lastProp;i++)
	{
		if (!stricmp(lpPropName,defPropNames[i].Names[0]))
			return i;
		if (!stricmp(lpPropName,defPropNames[i].Names[1]))
			return i;
	}
	return S_FALSE;
}
