#ifndef __sp_oledbptr_h__
#define __sp_oledbptr_h__
#endif // __sp_oledbptr_h__

template <class T> class COLEDBMemPtr
{
public:
	COLEDBMemPtr() : p(NULL) {}
	
	COLEDBMemPtr(const int nSize)
	{
		p = new T[nSize];
	}
	
	~COLEDBMemPtr()
	{
		if(p)
			delete[] p;
	}

	void Alloc(const int nSize)
	{
		p = new T[nSize];
	}

	void Release()
	{
		if(p)
			delete[] p;
	}
	
	operator T*() const
	{
		return (T*)p;
	}
	
	T& operator*() const
	{
		return *p;
	}

	T** operator&()
	{
		return &p;
	}

	bool operator!() const
	{
		return (p == NULL);
	}

public:
	T* p;
};
