//______________________________________________________________________________
//
// -  CBLContext,   CValue
//______________________________________________________________________________
//
#ifndef __SAFE__CONTEXT__INCLUDED
#define __SAFE__CONTEXT__INCLUDED

class CSafeContext
{
private:

	CValue *m_pValue;
	BOOL m_bIsGroupContext;
	BOOL m_bFlagAutoDestroy;
private:

	//  
	inline BOOL debug() const;

	//  
	void Assign(const CBLContext *pCont);

	//  
	void Release();

public:

	// 
	CSafeContext(BOOL m_bFlagAutoDestroy = FALSE);
	CSafeContext(CBLContext *pCont, BOOL m_bFlagAutoDestroy = FALSE);
	CSafeContext(const CSafeContext& ref);

	//    
	CSafeContext(LPCSTR szName, BOOL m_bFlagAutoDestroy = FALSE);

	virtual ~CSafeContext();

	//   
	inline BOOL IsGroupContext() const;

	void IncrRef();
	void DecrRef();

	// 
	CSafeContext& operator =(const CBLContext* pCont);
	operator bool() const;
	operator !() const;
	operator CBLContext *() const;
};

#endif //#ifndef __SAFE__CONTEXT__INCLUDED
