//////////////////////////////////////////////////////////////////////
//
// :  Ը aka , mailto: alf@dorex.ru
//
//////////////////////////////////////////////////////////////////////
//
// TreeChoose.cpp : implementation file
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TreeChoose.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern HINSTANCE hDllInstance;
extern CBkEndUI * pBkEndUI;

/////////////////////////////////////////////////////////////////////////////
// CTreeChoose dialog


CTreeChoose::CTreeChoose(char* DialogName, CWnd* pParent)
	: CDialog(CTreeChoose::IDD, pParent)
{
	m_ImageList.Create(IDB_BITMAP,16,4,RGB(0x00,0x80,0x80));

	m_DialogName = DialogName;
}

void CTreeChoose::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTreeChoose)
    DDX_Control(pDX, IDC_TREE, m_TreeView);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTreeChoose, CDialog)
	//{{AFX_MSG_MAP(CTreeChoose)
	ON_NOTIFY(NM_DBLCLK, IDC_TREE, OnDblclkTree)
	ON_NOTIFY(TVN_ITEMEXPANDED, IDC_TREE, OnItemexpandedTree)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTreeChoose message handlers

int CTreeChoose::DoModal() 
{
	HRSRC hResource = ::FindResource(hDllInstance, m_lpszTemplateName, RT_DIALOG);
	m_hDialogTemplate = ::LoadResource(hDllInstance, hResource);
	m_lpszTemplateName = NULL;
	return CDialog::DoModal();
}

void CTreeChoose::OnCancel() 
{
	CDialog::OnCancel();
}

void CTreeChoose::OnDblclkTree(NMHDR* pNMHDR, LRESULT* pResult)
{
	OnOK();
}

void CTreeChoose::OnOK() 
{
	HTREEITEM selItem = m_TreeView.GetSelectedItem();
	if(m_SelGroup == 0)
		if(m_TreeView.ItemHasChildren(selItem)) return;
	m_Selected = m_TreeView.GetItemData(selItem);

	CDialog::OnOK();
}
void CTreeChoose::SetTreeArray(structVIA** pVIA, int count)
{
	m_pVIA = pVIA;
	m_VIACount = count;
}

void CTreeChoose::FillTree(structVIA** pVIA, int count, HTREEITEM hParentItem)
{
	for(int i = 0; i<count; i++)
	{
		HTREEITEM hItem = NULL; // AM - added
		if(pVIA[i]->Type == 1)
		{
			hItem = m_TreeView.InsertItem((LPCTSTR)*(pVIA[i]->Descr),0,0,hParentItem); // AM - changed
			m_TreeView.SetItemData(hItem,(DWORD)&(pVIA[i]->Value));
		}
		else
		{
			hItem = m_TreeView.InsertItem((LPCTSTR)*(pVIA[i]->Descr),3,3,hParentItem); // AM - changed
			m_TreeView.SetItemData(hItem,(DWORD)&(pVIA[i]->Value));
			FillTree((structVIA**)pVIA[i]->NextLevel, pVIA[i]->Count, hItem);
		}
		if(hItem && pVIA[i]->Selected == 1) // AM - added 4 lines
		{
			m_TreeView.SelectItem(hItem);
		}
	}
}

BOOL CTreeChoose::OnInitDialog()
{
	CDialog::OnInitDialog();
	SetWindowText(m_DialogName);
	
	m_TreeView.SetImageList(&m_ImageList,TVSIL_NORMAL);
	m_TreeView.SetImageList(&m_ImageList,TVSIL_STATE);

	FillTree(m_pVIA, m_VIACount);
	m_TreeView.SetFocus();

	m_Selected = NULL;

	return true;
}

void CTreeChoose::OnItemexpandedTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	
	if (pNMTreeView->action == TVE_EXPAND) m_TreeView.SetItemImage(pNMTreeView->itemNew.hItem, 1, 1);
	else m_TreeView.SetItemImage(pNMTreeView->itemNew.hItem, 3, 3);

	*pResult = 0;
}
