//////////////////////////////////////////////////////////////////////
//
// :  Ը aka , mailto: alf@dorex.ru
//
//////////////////////////////////////////////////////////////////////
//
// WrapAboutDlg.cpp : implementation file
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "addin.h"
#include "WrapAboutDlg.h"

class CWndTabBase : public CWnd
{
public:
	CWndTabBase()
	{
	};
	//{{AFX_VIRTUAL(CWndTabBase)
	public:
	void OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult);
	void OnSelchangingTab(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_VIRTUAL

public:
	virtual ~CWndTabBase()
	{
	};

protected:
	DECLARE_MESSAGE_MAP()
};

BEGIN_MESSAGE_MAP(CWndTabBase, CWnd)
	//{{AFX_MSG_MAP(CWndTabBase)
	ON_NOTIFY(TCN_SELCHANGE, 0x1100, OnSelchangeTab)
	ON_NOTIFY(TCN_SELCHANGING, 0x1100, OnSelchangingTab)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TOOLTIP_ID 1

extern CBkEndUI * pBkEndUI;

/////////////////////////////////////////////////////////////////////////////
// CWrapAboutDlg dialog
DWORD* CWrapAboutDlg::m_pMyVTable=NULL;
DWORD* CWrapAboutDlg::m_pRealVTable=NULL;
static CStatic picLogo;
static bool bLogoShowed = false;
static bool bEditShowed = false;
static CEdit cEdit;
extern HINSTANCE hDllInstance;
static CTabCtrl* pTabCtrl = NULL;
static CWnd* pPage1 = NULL;
static CWnd* pPage2 = NULL;
static CWndTabBase* pPageBase = NULL;
static CRichEditCtrl cRich;
static CImageList* pImageList = NULL;
static CHyperLink cHyperLink;

typedef int (CAboutDlg::*PF_ONINITDIALOG)(void);
static union PtrConvAboutDlg{
	void* pV;
	PF_ONINITDIALOG pOnInitDialog;
} prtconvAboutDlg;

LRESULT WINAPI AboutDlgProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	if(uMsg == WM_CLOSE)
	{
		HWND hWnd = ::GetParent(hDlg);
		if(hWnd)
		{
			hWnd = ::GetParent(hWnd);
			if(hWnd)
			{
				hWnd = ::GetParent(hWnd);
				if(hWnd)
					::SendMessage(hWnd, uMsg, wParam, lParam);
			}
		}
	}
	else if(uMsg == WM_INITDIALOG)
	{
		return TRUE;
	}
	return FALSE;
}

void CWndTabBase::OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult) 

{
	int iTab = pTabCtrl->GetCurSel();
	CWnd* pWnd = iTab == 0? pPage1: pPage2;
	if(pWnd) pWnd->ShowWindow(SW_SHOW); 
	*pResult = 0;
}

void CWndTabBase::OnSelchangingTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int iTab = pTabCtrl->GetCurSel();
	CWnd* pWnd = iTab == 0? pPage1: pPage2;
	if(pWnd) pWnd->ShowWindow(SW_HIDE); 
	*pResult = 0;
}

int  CWrapAboutDlg::OnInitDialog(void)
{
	CAboutDlg* This = (CAboutDlg*)this;
	DWORD Adr = m_pRealVTable[0x31];
	m_pRealVTable[0x31] = m_pMyVTable[0x31];
	prtconvAboutDlg.pV = (void*)m_pRealVTable[0x31];
	int iRet = (This->*prtconvAboutDlg.pOnInitDialog)();//pubOnInitDialog();
	m_pRealVTable[0x31] = Adr;

	CRect rect;
	This->GetWindowRect(&rect);
	//rect.InflateRect(6,6);
	rect.bottom += 6;
	rect.right += 31;
	This->MoveWindow(&rect);
	This->GetClientRect(&rect);

	pPageBase = new CWndTabBase;
	pPageBase->Create("STATIC","",WS_VISIBLE|WS_CHILDWINDOW,rect,This,0x000b);

	CRect PageRect = rect;
	PageRect.DeflateRect(2,2);
	//PageRect.bottom -= 25;
	PageRect.left += 25;
	CRect rectCh;

	pPage1 = new CWnd;
	if(pPage1->Create("STATIC","",WS_VISIBLE|WS_CHILDWINDOW,PageRect,pPageBase,0x2000))
	{
		CWnd* pWnd = This->GetNextWindow(GW_CHILD);
		while(pWnd)
		{
			if(pWnd->GetSafeHwnd() == pPageBase->GetSafeHwnd())
			{
				pWnd = pWnd->GetNextWindow(GW_HWNDNEXT);
				if(pWnd->GetSafeHwnd() == pPageBase->GetSafeHwnd())
					pWnd = NULL;
			}
			if(pWnd)
			{
				CWnd* pNextWnd = pWnd->GetNextWindow(GW_HWNDNEXT);
				pWnd->SetParent(pPage1);
				pWnd = pNextWnd;
			}
		}
		pWnd = pPage1->GetDlgItem(0x0001);
		if(pWnd)
		{
			pWnd->ShowWindow(SW_HIDE);
		}
	}

	pPage2 = new CWnd;
	if(pPage2->Create("STATIC","",WS_CHILDWINDOW,PageRect,pPageBase,0x3000))
	{
		if(!bLogoShowed)
		{
			AfxInitRichEdit();
			HWND hWnd = ::CreateDialog(hDllInstance,MAKEINTRESOURCE(IDD_ABOUT_1CPP), pPage2->GetSafeHwnd(), (DLGPROC)AboutDlgProc);
			if(hWnd)
			{
				CWnd* pWnd = CWnd::FromHandle(hWnd);
				CRect rect(11,11,77,77);
				picLogo.CreateEx(WS_EX_NOPARENTNOTIFY,"Static","",
								 WS_VISIBLE|WS_CHILDWINDOW|WS_TABSTOP|WS_BORDER|
								 SS_BITMAP|SS_CENTERIMAGE,
								 rect,pWnd,0x10FF);
				picLogo.SetBitmap(::LoadBitmap(hDllInstance,MAKEINTRESOURCE(IDB_LOGO)));

				CString text;
				
				pWnd->GetDlgItemText(IDC_ABOUT_STATIC, text.GetBufferSetLength(250), 250);
				text.ReleaseBuffer();
				CString sVersion = ::GetFullVersion();
				text.Replace("_VersionInfo_", sVersion);
				pWnd->SetDlgItemText(IDC_ABOUT_STATIC, text);

				//   
				cRich.SubclassDlgItem(IDC_ABOUT_RICHEDIT, pWnd);
				cRich.SetBackgroundColor(FALSE, ::GetSysColor(COLOR_BTNFACE));
				text = "{\\rtf1\\ansi\\deff0\\deftab720"
						"\\fs20\\b1\\ul1:\\b0\\ul0\\par\\fs10\\par"
						"\\b1 \\b0\\par   Rainbow,    1\\par"
						"\\b1Carlos Antollini\\b0\\par odbccore.cpp\\par"
						"\\b1  aka Deb\\b0\\par   1++   , , , , , MetaInfoClasses,       ODBC\\par"
						"\\b1 \\b0\\par  DynaValue, DynaCrypt\\par"
						"\\b1 Ը aka \\b0\\par  FormEx\\par"
						"\\b1 \\b0\\par  TurboBL, Visual1C++\\par"
						"\\b1  aka ToyPaul\\b0\\par         ODBC\\par"
						"\\b1  aka DmitrO\\b0\\par        ODBC,  ,  \\par"
						"\\b1  aka spock\\b0\\par       OLE DB\\par"
						"\\b1  aka ADirks\\b0\\par  \\par"
						"\\b1  aka fez\\b0\\par   \\par"
						"\\b1  aka artbear\\b0\\par     \\par"
						"\\b0     - 1++\\par"
						"\\fs20\\par\\b1\\ul1-:\\b0\\ul0\\par\\fs10\\par"
//****************************************************************************************
//   -
						"  aka ob36\\par"
						"  aka Varelchik\\par"
						"  aka marida\\par"
						" \\par"
						"  aka GavaH\\par"
						"\\par"
//   -
//****************************************************************************************
						" }";
				cRich.SetWindowText(text);
				cRich.SetTargetDevice(NULL, 0);
				//cRich.SetEventMask(ENM_KEYEVENTS|ENM_UPDATE);
				//pWnd->SetDlgItemText(IDC_ABOUT_RICHEDIT, text);

				cHyperLink.SubclassDlgItem(IDC_STATIC, pWnd);

				char buffer[MAX_PATH];
				::GetModuleFileName(hDllInstance,buffer,MAX_PATH);
				pWnd->SetDlgItemText(IDC_DLLPATH, buffer);

			}

			bLogoShowed = true;
		}
	}

	pTabCtrl = new CTabCtrl;
	if(pTabCtrl->Create(WS_VISIBLE|WS_CHILDWINDOW|WS_TABSTOP|TCS_FOCUSNEVER|TCS_VERTICAL,//TCS_BOTTOM,
					rect,pPageBase,0x1100))
	{
		pImageList = new CImageList;
		pImageList->Create(16, 16, ILC_MASK, 2, 0);
		HBITMAP hBitmap;
		hBitmap = ::LoadBitmap(hDllInstance,MAKEINTRESOURCE(IDB_ABOUTTAB));
		pImageList->Add(CBitmap::FromHandle(hBitmap), RGB(0x00,0x80,0x80));
		::DeleteObject(hBitmap);

		pTabCtrl->SetFont(This->GetFont());
		pTabCtrl->SetImageList(pImageList);
		pTabCtrl->InsertItem(0,"1:",0);
		pTabCtrl->InsertItem(1,"  1++",1);
	}


	return iRet;
}

void CWrapAboutDlg::DestrAboutDlg(void)
{
	CAboutDlg* This = (CAboutDlg*)this;
	if(bLogoShowed)
	{
		if(bEditShowed)
		{
			cEdit.DestroyWindow();
			bEditShowed = false;
		}
		picLogo.DestroyWindow();
		bLogoShowed = false;
	}

	DWORD Adr = m_pRealVTable[0x18];
	m_pRealVTable[0x18] = m_pMyVTable[0x18];
	This->DestroyWindow();
	m_pRealVTable[0x18] = Adr;

	if(pTabCtrl) delete pTabCtrl;
	if(pPage1) delete pPage1;
	if(pPage2) delete pPage2;
	if(pImageList) delete pImageList;
	pTabCtrl = NULL;
	pPage1 = NULL;
	pPage2 = NULL;
	pImageList = NULL;
	cRich.UnsubclassWindow();
	cHyperLink.UnsubclassWindow();
}

CWrapAboutDlg::~CWrapAboutDlg()
{
}

void CWrapAboutDlg::Wrap(CAboutDlg* pDlg)
{
	if(!m_pMyVTable)
	{
		m_pRealVTable = *(DWORD**)pDlg;
		CWrapAboutDlg* pWrap = new CWrapAboutDlg;
		DWORD* pMyVTable=*(DWORD**)pWrap;
		delete pWrap;
		m_pMyVTable=new DWORD[0x36];
		memcpy(m_pMyVTable,m_pRealVTable,0xD8);
		DWORD old;
		VirtualProtect(m_pRealVTable,0xD8,PAGE_EXECUTE_READWRITE,&old);
		m_pRealVTable[0x31]=pMyVTable[0];
		m_pRealVTable[0x18]=pMyVTable[1];
	}
}

typedef CWnd* (CColumn::*PM_EDIT)(class CRect & ,class CBrowse *);
DWORD* CWrapColumn::m_pMyVTable=NULL;
DWORD* CWrapColumn::m_pRealVTable=NULL;

CWnd * CWrapColumn::Edit(class CRect & a_Rect,class CBrowse * a_pBrowse)
{
	CColumn* This = (CColumn*)this;
	//DWORD Adr = m_pRealVTable[0x19];
	//m_pRealVTable[0x31] = m_pMyVTable[0x19];
	PM_EDIT real = NULL;
	memcpy(&real,&m_pMyVTable[0x19],4);
	CWnd * wndRet = (This->*real)(a_Rect,a_pBrowse);
	//m_pRealVTable[0x31] = Adr;

	pBkEndUI->DoMessageLine("CWrapColumn::Edit", mmNone);

	return wndRet;
}

void CWrapColumn::Wrap(CColumn* pColumn)
{
	if(!m_pMyVTable)
	{
		m_pRealVTable = *(DWORD**)pColumn;
		CWrapColumn* pWrap = new CWrapColumn;
		DWORD* pMyVTable=*(DWORD**)pWrap;
		delete pWrap;
		m_pMyVTable=new DWORD[0x1C];
		memcpy(m_pMyVTable,m_pRealVTable,0x70);
		DWORD old;
		VirtualProtect(m_pRealVTable,0x70,PAGE_EXECUTE_READWRITE,&old);
		m_pRealVTable[0x19]=pMyVTable[0];
	}
}

/////////////////////////////////////////////////////////////////////////////
// CHyperLink

CHyperLink::CHyperLink()
{
    m_hLinkCursor       = NULL;                 // No cursor as yet
    m_crLinkColour      = RGB(  0,   0, 238);   // Blue
    m_crVisitedColour   = RGB( 85,  26, 139);   // Purple
    m_crHoverColour     = RGB(255,   0,   0);   // Red
    m_bOverControl      = FALSE;                // Cursor not yet over control
    m_bVisited          = FALSE;                // Hasn't been visited yet.
    m_nUnderline        = ulHover;              // Underline the link?
    m_bAdjustToFit      = TRUE;                 // Resize the window to fit the text?
    m_strURL.Empty();
	m_strToolTip.Empty();						// (Leo Davidson 24/Nov/2000)
	m_bAltToolTips		= TRUE;					// (Leo Davidson 24/Nov/2000)
    m_nTimerID          = 100;
}

CHyperLink::~CHyperLink()
{
    m_UnderlineFont.DeleteObject();

	// 24/Nov/2000 -- Leo Davidson, fixes resource leak.
	if (NULL != m_hLinkCursor)
	{
		DestroyCursor(m_hLinkCursor);
		m_hLinkCursor = NULL;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CHyperLink overrides

BOOL CHyperLink::DestroyWindow() 
{
    KillTimer(m_nTimerID);
	
	return CStatic::DestroyWindow();
}

BOOL CHyperLink::PreTranslateMessage(MSG* pMsg) 
{
    m_ToolTip.RelayEvent(pMsg);
    return CStatic::PreTranslateMessage(pMsg);
}

void CHyperLink::PreSubclassWindow() 
{
    // We want to get mouse clicks via STN_CLICKED
    DWORD dwStyle = GetStyle();
    ::SetWindowLong(GetSafeHwnd(), GWL_STYLE, dwStyle | SS_NOTIFY);
    
    // Set the URL as the window text
    if (m_strURL.IsEmpty())
	{
        GetWindowText(m_strURL);
		if ( _tcsicmp(_T("www."), m_strURL.Left(4)) == 0 )
			m_strURL = "http://" + m_strURL;
	}

    // Check that the window text isn't empty. If it is, set it as the URL.
    CString strWndText;
    GetWindowText(strWndText);
    if (strWndText.IsEmpty()) 
    {
        ASSERT(!m_strURL.IsEmpty());    // Window and URL both NULL. DUH!
        SetWindowText(m_strURL);
    }

	CFont* pFont = GetFont();
	if (!pFont)
	{
		HFONT hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
		if (hFont == NULL)
			hFont = (HFONT) GetStockObject(ANSI_VAR_FONT);
		if (hFont)
			pFont = CFont::FromHandle(hFont);
	}
	ASSERT(pFont->GetSafeHandle());

    // Create the underline font
    LOGFONT lf;
    pFont->GetLogFont(&lf);
	m_StdFont.CreateFontIndirect(&lf);
    lf.lfUnderline = (BYTE) TRUE;
    m_UnderlineFont.CreateFontIndirect(&lf);

    PositionWindow();        // Adjust size of window to fit URL if necessary
    SetDefaultCursor();      // Try and load up a "hand" cursor
    SetUnderline();

    // Create the tooltip
	CreateToolTipText(m_strURL);

    CRect rect; 
    GetClientRect(rect);
    m_ToolTip.Create(this);
    m_ToolTip.AddTool(this, m_strToolTip, rect, TOOLTIP_ID);

    CStatic::PreSubclassWindow();
}

BEGIN_MESSAGE_MAP(CHyperLink, CStatic)
    //{{AFX_MSG_MAP(CHyperLink)
    ON_WM_CTLCOLOR_REFLECT()
    ON_WM_SETCURSOR()
    ON_WM_MOUSEMOVE()
	ON_WM_TIMER()
    //ON_CONTROL_REFLECT(STN_CLICKED, OnClicked)
	ON_WM_LBUTTONUP()
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHyperLink message handlers

void CHyperLink::OnClicked()
{
    m_bOverControl = FALSE;
    int result = (int)GotoURL(m_strURL, SW_SHOW);
    m_bVisited = (result > HINSTANCE_ERROR);
    if (!m_bVisited)
    {
        MessageBeep(MB_ICONEXCLAMATION);     // Unable to follow link
        ReportError(result);
    }
    else 
        SetVisited();                        // Repaint to show visited colour
}

void CHyperLink::OnLButtonUp(UINT nFlags, CPoint point)
{
	OnClicked();
}

HBRUSH CHyperLink::CtlColor(CDC* pDC, UINT nCtlColor) 
{
    ASSERT(nCtlColor == CTLCOLOR_STATIC);

    if (m_bOverControl)
        pDC->SetTextColor(m_crHoverColour);
    else if (m_bVisited)
        pDC->SetTextColor(m_crVisitedColour);
    else
        pDC->SetTextColor(m_crLinkColour);

    // transparent text.
    pDC->SetBkMode(TRANSPARENT);
    return (HBRUSH)GetStockObject(NULL_BRUSH);
}

void CHyperLink::OnMouseMove(UINT nFlags, CPoint point) 
{
    if (!m_bOverControl)        // Cursor has just moved over control
    {
        m_bOverControl = TRUE;

        if (m_nUnderline == ulHover)
            SetFont(&m_UnderlineFont);
        Invalidate();

        SetTimer(m_nTimerID, 100, NULL);
    }
    CStatic::OnMouseMove(nFlags, point);
}

void CHyperLink::OnTimer(UINT nIDEvent) 
{
    CPoint p(GetMessagePos());
    ScreenToClient(&p);

    CRect rect;
    GetClientRect(rect);
    if (!rect.PtInRect(p))
    {
        m_bOverControl = FALSE;
        KillTimer(m_nTimerID);

        if (m_nUnderline != ulAlways)
            SetFont(&m_StdFont);
        rect.bottom+=10;
        InvalidateRect(rect);
    }
    
	CStatic::OnTimer(nIDEvent);
}

BOOL CHyperLink::OnSetCursor(CWnd* /*pWnd*/, UINT /*nHitTest*/, UINT /*message*/) 
{
    if (m_hLinkCursor)
    {
        ::SetCursor(m_hLinkCursor);
        return TRUE;
    }
    return FALSE;
}

BOOL CHyperLink::OnEraseBkgnd(CDC* pDC) 
{
    CRect rect;
    GetClientRect(rect);
    pDC->FillSolidRect(rect, ::GetSysColor(COLOR_3DFACE));

    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CHyperLink operations

void CHyperLink::SetURL(CString strURL)
{
    m_strURL = strURL;

    if (::IsWindow(GetSafeHwnd()))
	{
        PositionWindow();
		CreateToolTipText(m_strURL);
		m_ToolTip.UpdateTipText(m_strToolTip, this, TOOLTIP_ID);
    }
}

CString CHyperLink::GetURL() const
{ 
    return m_strURL;   
}

void CHyperLink::SetColours(COLORREF crLinkColour, COLORREF crVisitedColour,
                            COLORREF crHoverColour /* = -1 */) 
{ 
    m_crLinkColour    = crLinkColour; 
    m_crVisitedColour = crVisitedColour;

	if (crHoverColour == -1)
		m_crHoverColour = ::GetSysColor(COLOR_HIGHLIGHT);
	else
		m_crHoverColour = crHoverColour;

    if (::IsWindow(m_hWnd))
        Invalidate(); 
}

COLORREF CHyperLink::GetLinkColour() const
{ 
    return m_crLinkColour; 
}

COLORREF CHyperLink::GetVisitedColour() const
{
    return m_crVisitedColour; 
}

COLORREF CHyperLink::GetHoverColour() const
{
    return m_crHoverColour;
}

void CHyperLink::SetVisited(BOOL bVisited /* = TRUE */) 
{ 
    m_bVisited = bVisited; 

    if (::IsWindow(GetSafeHwnd()))
        Invalidate(); 
}

BOOL CHyperLink::GetVisited() const
{ 
    return m_bVisited; 
}

void CHyperLink::SetLinkCursor(HCURSOR hCursor)
{
	// 24/Nov/2000 -- Leo Davidson, fixes resource leak.
	if (NULL != m_hLinkCursor)
	{
		DestroyCursor(m_hLinkCursor);
		m_hLinkCursor = NULL;
	}

    m_hLinkCursor = hCursor;

    if (m_hLinkCursor == NULL)
	{
        SetDefaultCursor();
	}
}

HCURSOR CHyperLink::GetLinkCursor() const
{
    return m_hLinkCursor;
}

void CHyperLink::SetUnderline(int nUnderline /*=ulHover*/)
{
    if (m_nUnderline == nUnderline)
        return;

    if (::IsWindow(GetSafeHwnd()))
    {
        if (nUnderline == ulAlways)
            SetFont(&m_UnderlineFont);
        else
            SetFont(&m_StdFont);

        Invalidate(); 
    }

    m_nUnderline = nUnderline;
}

int CHyperLink::GetUnderline() const
{ 
    return m_nUnderline; 
}

void CHyperLink::SetAutoSize(BOOL bAutoSize /* = TRUE */)
{
    m_bAdjustToFit = bAutoSize;

    if (::IsWindow(GetSafeHwnd()))
        PositionWindow();
}

BOOL CHyperLink::GetAutoSize() const
{ 
    return m_bAdjustToFit; 
}

void CHyperLink::SetAltToolTips(BOOL bAltToolTips /* = TRUE */)
{
	m_bAltToolTips = bAltToolTips;

	CreateToolTipText(m_strURL);

	CToolInfo toolInfo;

	if (m_ToolTip.GetToolInfo(toolInfo, this, TOOLTIP_ID))
	{
		m_ToolTip.UpdateTipText(m_strToolTip, this, TOOLTIP_ID);
	}
}

BOOL CHyperLink::GetAltToolTips() const
{
	return(m_bAltToolTips);
}


// Move and resize the window so that the window is the same size
// as the hyperlink text. This stops the hyperlink cursor being active
// when it is not directly over the text. If the text is left justified
// then the window is merely shrunk, but if it is centred or right
// justified then the window will have to be moved as well.
//
// Suggested by Pl K. Tnder 

void CHyperLink::PositionWindow()
{
    if (!::IsWindow(GetSafeHwnd()) || !m_bAdjustToFit) 
        return;

    // Get the current window position
    CRect WndRect, ClientRect;
    GetWindowRect(WndRect);
    GetClientRect(ClientRect);

    ClientToScreen(ClientRect);

    CWnd* pParent = GetParent();
    if (pParent)
    {
        pParent->ScreenToClient(WndRect);
        pParent->ScreenToClient(ClientRect);
    }

    // Get the size of the window text
    CString strWndText;
    GetWindowText(strWndText);

    CDC* pDC = GetDC();
    CFont* pOldFont = pDC->SelectObject(&m_UnderlineFont);
    CSize Extent = pDC->GetTextExtent(strWndText);
    pDC->SelectObject(pOldFont);
    ReleaseDC(pDC);

    // Adjust for window borders
    Extent.cx += WndRect.Width() - ClientRect.Width(); 
    Extent.cy += WndRect.Height() - ClientRect.Height(); 

    // Get the text justification via the window style
    DWORD dwStyle = GetStyle();

    // Recalc the window size and position based on the text justification
    if (dwStyle & SS_CENTERIMAGE)
        WndRect.DeflateRect(0, (WndRect.Height() - Extent.cy)/2);
    else
        WndRect.bottom = WndRect.top + Extent.cy;

    if (dwStyle & SS_CENTER)   
        WndRect.DeflateRect((WndRect.Width() - Extent.cx)/2, 0);
    else if (dwStyle & SS_RIGHT) 
        WndRect.left  = WndRect.right - Extent.cx;
    else // SS_LEFT = 0, so we can't test for it explicitly 
        WndRect.right = WndRect.left + Extent.cx;

    // Move the window
    SetWindowPos(NULL, WndRect.left, WndRect.top, WndRect.Width(), WndRect.Height(), SWP_NOZORDER);
}

/////////////////////////////////////////////////////////////////////////////
// CHyperLink implementation

// The following appeared in Paul DiLascia's Jan 1998 MSJ articles.
// It loads a "hand" cursor from the winhlp32.exe module
void CHyperLink::SetDefaultCursor()
{
    if (m_hLinkCursor == NULL)                // No cursor handle - load our own
    {
        // Get the windows directory
        CString strWndDir;
        GetWindowsDirectory(strWndDir.GetBuffer(MAX_PATH), MAX_PATH);
        strWndDir.ReleaseBuffer();

        strWndDir += _T("\\winhlp32.exe");
        // This retrieves cursor #106 from winhlp32.exe, which is a hand pointer
        HMODULE hModule = LoadLibrary(strWndDir);
        if (hModule) {
            HCURSOR hHandCursor = ::LoadCursor(hModule, MAKEINTRESOURCE(106));
            if (hHandCursor)
                m_hLinkCursor = CopyCursor(hHandCursor);
        }
        FreeLibrary(hModule);
    }
}

LONG CHyperLink::GetRegKey(HKEY key, LPCTSTR subkey, LPTSTR retdata)
{
    HKEY hkey;
    LONG retval = RegOpenKeyEx(key, subkey, 0, KEY_QUERY_VALUE, &hkey);

    if (retval == ERROR_SUCCESS) {
        long datasize = MAX_PATH;
        TCHAR data[MAX_PATH];
        RegQueryValue(hkey, NULL, data, &datasize);
        lstrcpy(retdata,data);
        RegCloseKey(hkey);
    }

    return retval;
}

void CHyperLink::ReportError(int nError)
{
    CString str;
    switch (nError) {
        case 0:                       str = "The operating system is out\nof memory or resources."; break;
        case SE_ERR_PNF:              str = "The specified path was not found."; break;
        case SE_ERR_FNF:              str = "The specified file was not found."; break;
        case ERROR_BAD_FORMAT:        str = "The .EXE file is invalid\n(non-Win32 .EXE or error in .EXE image)."; break;
        case SE_ERR_ACCESSDENIED:     str = "The operating system denied\naccess to the specified file."; break;
        case SE_ERR_ASSOCINCOMPLETE:  str = "The filename association is\nincomplete or invalid."; break;
        case SE_ERR_DDEBUSY:          str = "The DDE transaction could not\nbe completed because other DDE transactions\nwere being processed."; break;
        case SE_ERR_DDEFAIL:          str = "The DDE transaction failed."; break;
        case SE_ERR_DDETIMEOUT:       str = "The DDE transaction could not\nbe completed because the request timed out."; break;
        case SE_ERR_DLLNOTFOUND:      str = "The specified dynamic-link library was not found."; break;
        case SE_ERR_NOASSOC:          str = "There is no application associated\nwith the given filename extension."; break;
        case SE_ERR_OOM:              str = "There was not enough memory to complete the operation."; break;
        case SE_ERR_SHARE:            str = "A sharing violation occurred. ";
        default:                      str.Format(_T("Unknown Error (%d) occurred."), nError); break;
    }
    str = "Unable to open hyperlink:\n\n" + str;
    AfxMessageBox(str, MB_ICONEXCLAMATION | MB_OK);
}

HINSTANCE CHyperLink::GotoURL(LPCTSTR url, int showcmd)
{
	SetLinkCursor(NULL);

    TCHAR key[MAX_PATH + MAX_PATH];

    // First try ShellExecute()
    HINSTANCE result = ShellExecute(NULL, _T("open"), url, NULL,NULL, showcmd);

    // If it failed, get the .htm regkey and lookup the program
    if ((UINT)result <= HINSTANCE_ERROR) {

        if (GetRegKey(HKEY_CLASSES_ROOT, _T(".htm"), key) == ERROR_SUCCESS) {
            lstrcat(key, _T("\\shell\\open\\command"));

            if (GetRegKey(HKEY_CLASSES_ROOT,key,key) == ERROR_SUCCESS) {
                TCHAR *pos;
                pos = _tcsstr(key, _T("\"%1\""));
                if (pos == NULL) {                     // No quotes found
                    pos = _tcsstr(key, _T("%1"));      // Check for %1, without quotes 
                    if (pos == NULL)                   // No parameter at all...
                        pos = key+lstrlen(key)-1;
                    else
                        *pos = '\0';                   // Remove the parameter
                }
                else
                    *pos = '\0';                       // Remove the parameter

                lstrcat(pos, _T(" "));
                lstrcat(pos, url);

                USES_CONVERSION;
                result = (HINSTANCE) WinExec(T2A(key),showcmd);
            }
        }
    }

    return result;
}

// (Leo Davidson 24/Nov/2000)
void CHyperLink::CreateToolTipText(LPCTSTR url)
{
	m_strToolTip.Empty(); 

	if (m_bAltToolTips)
	{
		CString strURL(url);

		if ( _tcsicmp(_T("http://"), strURL.Left(7)) == 0 )
		{
			m_strToolTip = "   ";
			url += 7;
		}
		else if ( _tcsicmp(_T("mailto:"), strURL.Left(7)) == 0 )
		{
			m_strToolTip = "E-mail ";
			url += 7;
			m_strToolTip += url;
		}
	}

}
