#if !defined(AFX_MYSUPERGRID_H__09B964C4_953D_11D2_9B04_002018026B76__INCLUDED_)
#define AFX_MYSUPERGRID_H__09B964C4_953D_11D2_9B04_002018026B76__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// MySuperGrid.h : header file
//
#include "SuperGridCtrl.h"
/////////////////////////////////////////////////////////////////////////////
// CMySuperGrid window


class CMySuperGrid : public CSuperGridCtrl
{
	DECLARE_DYNAMIC(CMySuperGrid)
// Construction
public:
	CMySuperGrid();
	
// Attributes
public:
// Operations
public:
	//HOWTO:
	void InitializeGrid(void);
	void SortData(void);
	void _DeleteAll(void);
	CImageList *CreateDragImageEx(int nItem);
	BOOL m_bDrag;
	CValueTable* m_pTable;
	BOOL FillTable(CTreeItem * pRoot = NULL, CValueTable* pTable = NULL);
	BOOL FillColors(CTreeItem * pRoot, CValueTable* pTable, int y);
	CString GetCurrentItemIndex();
	//CString GetItemIndex(CTreeItem *pItem);
	long GetCurrentColumn();
	void GetValueByPath(CString stPath, int num, CValue& retValue);
	BOOL SetValueByPath(CString stPath, int num, CValue& setValue);
	CString GetColumnName(int num);
	int GetRealColumnNum(int num);
	void ExpandNodeByPath(CString stPath);
	void CollapseNodeByPath(CString stPath);
	BOOL IsGroupByPath(CString stPath);
	void SetCurrentByPath(CString stPath);
	void DeleteChildren(CTreeItem *pItem);
	void SetOptions(int ShowHGrid, int ShowVGrid, int ShowTGrid);

	//search item and subitems 
	//usage:
	//	CTreeItem *pResult = Search("Item 1","subitem x","Subitem y","subitem 0", NULL); //must finish with NULL terminator thank you
	//  if(pResult!=NULL) .....bla. bla. bla.
	// returns the pointer to node that matches the search criteria or NULL if not found
	CTreeItem *Search(CString strItem, ...);
	CTreeItem* SearchEx(CTreeItem *pStartPosition, CString strItem);
	//
	void GetSelRect(CRect& rect)
	{
		int s = GetSelectedItem();
		if(s >= 0)
		{
			GetItemRect(s, rect, LVIR_LABEL);
			
			if(m_CurSubItem == 0)
				return;
			else
			{
				LV_COLUMN lvc;
				lvc.mask = LVCF_FMT | LVCF_WIDTH;
				for(int nColumn=1; GetColumn(nColumn, &lvc); nColumn++)
				{
					rect.left=rect.right;
					rect.right+=lvc.cx;
					if(m_CurSubItem == nColumn)
						return;
				}
			}
		}
		rect.SetRectEmpty();
	};

	void GetCellRect(CRect& rect, CString sRow, int iCol)
	{
		int i = 0;
		i = atoi(sRow);
		CTreeItem* pTreeItem = NULL;
		if(i > 0)
		{
			int m = GetRootCount();
			for(int f = 0; f < m; f++)
			{
				pTreeItem = GetRootItem(f);
				if(pTreeItem->m_nIndexVT == i) break;
				pTreeItem = NULL;
			}
		}

		int n = 0;
		CValue val;
		CValue valNULL;
		while(i > 0)
		{
			n = sRow.Find("/",0);
			if(n >=0 )
			{
				sRow = sRow.Mid(n+1);
				i = atoi(sRow);
				if(pTreeItem) pTreeItem = pTreeItem->GetTreeItem(i);
			}
			else
			{
				i = 0;
			}
		}

		int s = NodeToIndex(pTreeItem);
		if(s >= 0)
		{
			GetItemRect(s, rect, LVIR_LABEL);
			
			LV_COLUMN lvc;
			lvc.mask = LVCF_FMT | LVCF_WIDTH;
			for(int nColumn=1; GetColumn(nColumn, &lvc); nColumn++)
			{
				rect.left=rect.right;
				rect.right+=lvc.cx;
				if(iCol == nColumn)
					return;
			}
		}
		rect.SetRectEmpty();
	};
	// Overrides OnUpdateCmdUI
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
	{
// TODO:   -     .  ,
//			,     .

		if(CN_COMMAND == nCode)
		{
			return (
					(nID == 0xE122) ||
					(nID == 0xE123) ||
					(nID == 0xE124) ||
					(nID == 0xE125) ||
					(nID == 0xE128) ||
					(nID == 0xE12B) ||

					(nID == 0x8041) ||
					(nID == 0x8042) ||
					(nID == 0x8043) ||
					(nID == 0x8044) ||
					(nID == 0x83AC) ||

					(nID == 32786) ||
					(nID == 32784) ||
					(nID == 32790) ||
					(nID == 32785) ||
					(nID == 24649) ||
					(nID == 33790) ||
					(nID == 33791) ||
					(nID == 32864) ||
					(nID == 32901) ||
// .
//       ,    c 
//   Shift + F4
//    1     .   .
//					(nID == 0x807C) ||

					FALSE);
		}
		if(CN_UPDATE_COMMAND_UI == nCode)
		{
			if(pExtra)
			{
				CCmdUI* pCmdUI = (CCmdUI*)pExtra;
				if(pCmdUI->m_pOther)
					if(
						(nID == 0xE122) ||
						(nID == 0xE123) ||
						(nID == 0xE124) ||
						(nID == 0xE125) ||
						(nID == 0xE128) ||
						(nID == 0xE12B) ||

						(nID == 0x8041) ||
						(nID == 0x8042) ||
						(nID == 0x8043) ||
						(nID == 0x8044) ||
						(nID == 0x83AC) ||

						(nID == 32786) ||
						(nID == 32784) ||
						(nID == 32790) ||
						(nID == 32785) ||
						(nID == 24649) ||
						(nID == 33790) ||
						(nID == 33791) ||
						(nID == 32864) ||
						(nID == 32901) ||

// .
//       ,    c 
//   Shift + F4
//    1     .   .
//						(nID == 0x807C) ||

						FALSE)
							pCmdUI->Enable(FALSE);
			}
			return TRUE;
		}

		return FALSE;
	};
	void OnControlLButtonDown(UINT nFlags, CPoint point, LVHITTESTINFO& ht);	
	void OnUpdateListViewItem(CTreeItem* lpItem, LV_ITEM *plvItem);

	CItemInfo* CopyData(CItemInfo* lpSrc);
	int GetIcon(const CTreeItem* pItem);
	COLORREF GetCellRGB(void);
	BOOL OnItemExpanding(CTreeItem *pItem, int iItem);
	BOOL OnItemExpanded(CTreeItem* pItem, int iItem);
	BOOL OnCollapsing(CTreeItem *pItem);
	BOOL OnItemCollapsed(CTreeItem *pItem);
	BOOL OnDeleteItem(CTreeItem* pItem, int nIndex);
	BOOL OnVkReturn(void);
	BOOL OnItemLButtonDown(LVHITTESTINFO& ht);
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMySuperGrid)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMySuperGrid();

protected:
	CImageList m_image;//Must provide an imagelist
	//positions and creates/initalize a combobox control
	CComboBox* ShowList(int nItem, int nCol, CStringList *lstItems);
	//helper function called from ShowList...calcs the lists max horz extent
	int CalcHorzExtent(CWnd* pWnd, CStringList *pList);
	// Generated message map functions
protected:
	//{{AFX_MSG(CMySuperGrid)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnNcDestroy(void);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MYSUPERGRID_H__09B964C4_953D_11D2_9B04_002018026B76__INCLUDED_)
