//   aka spock
// #163860836
// e-mail: spock@km.ru
//
#include "stdafx.h"
#include "sp_cooledb.h"
#include "DBPropSet.h"

//_____________________________________________________________________________
//
COLEDBFldsInf::COLEDBFldsInf():m_nType1C(CType(0))
{
	m_Index		 = 0;
	m_strName	 = _T("");
	m_bIsType1C	 = false;
	m_bIsLong	 = false;
}

extern CDataBase7* pDataBase7;
extern CMetaDataCont* pMetaDataCont;
extern CBkEndUI* pBkEndUI;

BEGIN_BL_METH_MAP(COLEDBCommand)
    BL_METH_FUNC_DEF_PARAM("ExecuteStatement",		"",		2, funcExecuteStatement, defsExecuteStatement)
    BL_METH_PROC("Close",		"",		0, procClose)
    BL_METH_FUNC_DEF_PARAM("Execute",		"",	1, funcExecute, defsExecute)

    BL_METH_PROC("Debug",		"",		1, procDebug)
    BL_METH_PROC("SetTextParam",		"",		2, procSetTextParam)
    BL_METH_PROC_DEF_PARAM("PutObjectList",		"",	3, procPutObjectList, defsPutObjectList)
    BL_METH_PROC("SetTempTablesDir",		"",		1, procSetTempTablesDir)
    BL_METH_PROC("SetExecTimeOut",		"",		1, procSetExecTimeOut)
END_BL_METH_MAP()

BEGIN_BL_PROP_MAP(COLEDBCommand)
END_BL_PROP_MAP()

IMPLEMENT_MY_NONCREATE_CONTEXT(COLEDBCommand, "OLEDBCommand", "OLEDBCommand");

extern char szMNPErrorPrefix[];

//_____________________________________________________________________________
//
static ULONG AddOffset(ULONG nCurrent, ULONG nAdd)
{
	struct foobar
	{
		char foo;
		long bar;
	};
	
	ULONG nAlign = offsetof(foobar, bar);
	
	return nCurrent + nAdd + (nAdd % nAlign);
}

//_____________________________________________________________________________
//
COLEDBCommand::COLEDBCommand(CComPtr<IDBCreateCommand> pIDBCreateCommand) : CMyContextBase(), m_IsDebugMode(false)
{
	HRESULT hr;

	m_bCreated	 = true;
	::UuidCreateNil(&m_GUID);
	m_szTempTablesDir.Empty();

	m_ExecTimeout = -1;

	hr = pIDBCreateCommand->CreateCommand(NULL, IID_ICommandText, (IUnknown**)&m_pICommandText);
	COLEDBData::Check_HRESULT(hr, "FAILED! IDBCreateCommand::CreateCommand()");

	m_TmpTblsList.RemoveAll();
}

//_____________________________________________________________________________
//
COLEDBCommand::~COLEDBCommand()
{
	procClose(NULL);
}

BOOL COLEDBCommand::funcExecute(CValue &rValue, CValue **ppValue)
{
	if (!m_bCreated)
		RuntimeError("    !");

	CString strSQL(ppValue[0]->GetString());
	
	HRESULT hr = COLEDBCommand::ParseQuery(strSQL);
	if (FAILED(hr))
	{
		rValue = 0L;
		return 0L;
	}
	
	long nRowsAffected = 0;
	
	hr = COLEDBCommand::Execute(strSQL, nRowsAffected);
	if (FAILED(hr))
	{
		rValue = 0L;
		return 0L;
	}

	rValue	 = nRowsAffected;

	return TRUE;
}

BOOL COLEDBCommand::defsExecute(int nParam, CValue* param) const
{
	*param = "";
	return TRUE;
}

BOOL COLEDBCommand::funcExecuteStatement(CValue &rValue, CValue **ppValue)
{
	USES_CONVERSION;

	//   -  .
	//  ...
	//
	rValue.CreateObject("");

	if (!m_bCreated)
		RuntimeError("    !");

	CString strSQL(ppValue[0]->GetString());
	
	HRESULT hr = COLEDBCommand::ParseQuery(strSQL);
	if (FAILED(hr))
	{
		return 0L;
	}
	
	long nRowsAffected = 0;

	CComPtr<IRowset> pIRowset;
	
	hr = COLEDBCommand::Execute(strSQL, nRowsAffected, (IUnknown**)&pIRowset);
	if (FAILED(hr))
	{
		return 0L;
	}

	//       rowset,     
	//   .     . ,   ,   
	//   drop table XXX -    RowsAffected
	//
	//if (pIRowset == NULL || nRowsAffected < 0)
	if (pIRowset == NULL)
	{
		//    SQLOLEDB   select * from XXX  
		// nRowsAffected   -1.
		//     VFPOLEDB,      
		//    . 
		//      ...  ,    
		//   <0 .
		//
		return 1L;
	}

	ULONG cCols					 = 0;
	ULONG cbMaxRowSize			 = 0;

	sh_array<DBBINDING> sh_array_DBBindings; //   
	sh_array<COLEDBFldsInf> sh_array_ColumnsInfo; //   
	sh_array<DBOBJECT> sh_array_DBObject; //   

	bool HasKindField			 = false; //  -         "_"  "XXX_kind",     true

	hr = COLEDBCommand::Binding(pIRowset, cCols, sh_array_DBBindings, sh_array_ColumnsInfo, sh_array_DBObject, cbMaxRowSize, HasKindField);
	if (FAILED(hr))
	{
		return 0L;
	}
	DBBINDING* pDBBindings = sh_array_DBBindings.get();
	COLEDBFldsInf* pColumnsInfo = sh_array_ColumnsInfo.get();
	DBOBJECT* pDBObject = sh_array_DBObject.get();

	HACCESSOR hAccessor = NULL;
	CComPtr<IAccessor> pIAccessor;

	hr = COLEDBCommand::CreateAccessor(pIAccessor, pIRowset, hAccessor, cCols, pDBBindings);
	if (FAILED(hr))
	{
		return 0L;
	}

	CValueTable* pVT = CValue2VT(rValue);
	//CVTExtended* pVT = CValue2VTExt(rValue);

	//   
	//
	CString strFormat;
	for (ULONG nCol = 0; nCol < cCols; nCol++)
	{
		CString szName(pColumnsInfo[nCol].m_strName);
		CType ColType(pColumnsInfo[nCol].m_nType1C);

		//  ,       (  ),
		//      (   1).
		//       
		//
		if((ENUM_TYPE_1C == ColType.GetTypeCode()) && (0 == ColType.GetTypeID()))
			pVT->AddColumn(szName, CType(0), szName, 0, strFormat, 0);
		else
			pVT->AddColumn(szName, ColType, szName, 0, strFormat, 0);
	}

	sh_array<BYTE> sh_array_RowValues(new BYTE[cbMaxRowSize]); //   
	BYTE* pRowValues = sh_array_RowValues.get();

	ULONG cRowsObtained = 0;

	HROW m_hRow[NUMROWS_CHUNK];
	HROW* phRow = &m_hRow[0];

	ULONG cRowNum = 0;
	CValue v;
	CMetaDataWork::TypeStringValue eType;

	wchar_t* wstrVal;
	CString strTemp;
	DBDATE* dbdateVal;
	DBTIMESTAMP* dbdtVal;
	CNumeric strNum;
	ULONG dwStatus;
	
	sh_array<BYTE> sh_array_RBuffer(new BYTE[BLOCK_SIZE]); //   
	BYTE* pRBuffer = sh_array_RBuffer.get();

	ULONG cRead;

	for(;;)
	{
		hr = pIRowset->GetNextRows(NULL, 0, NUMROWS_CHUNK, &cRowsObtained, &phRow);
		COLEDBData::Check_HRESULT(hr, "FAILED! IAccessor::GetNextRows()");
		
		if (cRowsObtained == 0)
		{
			break;
		}

		for (ULONG iRow = 0; iRow < cRowsObtained; iRow++)
		{
			hr = pIRowset->GetData(m_hRow[iRow], hAccessor, pRowValues);
			COLEDBData::Check_HRESULT(hr, "FAILED! IAccessor::GetData()");

			pVT->NewRow(cRowNum);

			for (ULONG nCol = 0; nCol < cCols; nCol++)
			{
				v.Reset();

				if (pColumnsInfo[nCol].m_bIsLong)
				{
					ISequentialStream* pISequentialStream = *((ISequentialStream**)(pRowValues + pDBBindings[nCol].obValue));

					strTemp = "";

					do
					{
						pISequentialStream->Read(pRBuffer, BLOCK_SIZE, &cRead);

						if (cRead > 0)
						{
							strTemp += (const char *)pRBuffer;
						}
					} while (cRead >= BLOCK_SIZE);

					pISequentialStream->Release();

					v.SetType(pColumnsInfo[nCol].m_nType1C);
					v = strTemp;
				}
				else
				{
					CType rt	 = pColumnsInfo[nCol].m_nType1C;
					dwStatus	 = (ULONG)pRowValues[pDBBindings[nCol].obStatus];
					
					switch(pColumnsInfo[nCol].m_wType)
					{
						case DBTYPE_NUMERIC:
						case DBTYPE_I2:
						case DBTYPE_I4:
						case DBTYPE_R4:
						case DBTYPE_R8:
						case DBTYPE_CY:
						case DBTYPE_DECIMAL:
						case DBTYPE_UI1:
						case DBTYPE_I1:
						case DBTYPE_UI2:
						case DBTYPE_UI4:
						case DBTYPE_I8:
						case DBTYPE_UI8:
						{
							// spock: 2005-12-15
							//   NULL-    :(
							//     
							// :    NULL.     
							//     DmitrO
							//      ,   2005-11-13
							//
							if (DBSTATUS_S_ISNULL == dwStatus)
							{
								v.SetType(pColumnsInfo[nCol].m_nType1C);
								v = 0L;
								break;
							}

							v.SetType(pColumnsInfo[nCol].m_nType1C);
							v = strNum.FromString((const char*)&pRowValues[pDBBindings[nCol].obValue], NULL);
							break;
						}

						case DBTYPE_BOOL:
						{
							char* strVal = (char*)&pRowValues[pDBBindings[nCol].obValue];
							
							// spock: 2005-11-13
							//   NULL-    :(
							//  :  NULL,   
							//   
							//
							if (DBSTATUS_S_ISNULL == dwStatus)
							{
								v.SetType(pColumnsInfo[nCol].m_nType1C);
								v = 0L;
								break;
							}
							
							strTemp.Format("%s", strVal);
							v.SetType(pColumnsInfo[nCol].m_nType1C);

							if (strTemp.Compare("False") == 0)
								v = 0L;
							else
								v = 1L;

							break;
						}
						
						case DBTYPE_DBDATE:
						{
							dbdateVal = (DBDATE*)&pRowValues[pDBBindings[nCol].obValue];

							// spock: 2005-11-13
							//   NULL-    :(
							//  :  NULL,   
							//    
							//
							if (DBSTATUS_S_ISNULL == dwStatus)
							{
								CDate dateVal(0, 0, 0);
								v = dateVal;
								break;
							}

							v.SetType(pColumnsInfo[nCol].m_nType1C);

							if (dbdateVal->year == 1753 && 
								dbdateVal->month == 1 && 
								dbdateVal->day == 1)
							{
								//  2
								//
								CDate dateVal(0, 0, 0);
								v = dateVal;
							}
							else if (dbdateVal->year == 1899 && 
								dbdateVal->month == 12 && 
								dbdateVal->day == 30)
							{
								//  
								//
								CDate dateVal(0, 0, 0);
								v = dateVal;
							}
							else
							{
								CDate dateVal(dbdateVal->year, dbdateVal->month, dbdateVal->day);
								v = dateVal;
							}
							break;
						}
						
						case DBTYPE_DBTIMESTAMP:
						{
							dbdtVal = (DBTIMESTAMP*)&pRowValues[pDBBindings[nCol].obValue];

							// spock: 2005-11-13
							//   NULL-    :(
							//  :  NULL,   
							//    
							//
							if (DBSTATUS_S_ISNULL == dwStatus)
							{
								CDate dateVal(0, 0, 0);
								v = dateVal;
								break;
							}

							v.SetType(pColumnsInfo[nCol].m_nType1C);

							if (dbdtVal->year == 1753 && 
								dbdtVal->month == 1 && 
								dbdtVal->day == 1)
							{
								//  2
								//
								CDate dateVal(0, 0, 0);
								v = dateVal;
							}
							else if (dbdtVal->year == 1899 && 
								dbdtVal->month == 12 && 
								dbdtVal->day == 30)
							{
								//  
								//
								CDate dateVal(0, 0, 0);
								v = dateVal;
							}
							else
							{
								CDate dateVal(dbdtVal->year, dbdtVal->month, dbdtVal->day);
								v = dateVal;
							}
							break;
						}
						
						case DBTYPE_WSTR:
						{
							wstrVal = (wchar_t*)&pRowValues[pDBBindings[nCol].obValue];

							// spock: 2005-11-13
							//   NULL-    :(
							//  :  NULL,   
							//    
							//
							if (DBSTATUS_S_ISNULL == dwStatus)
							{
								v.SetType(pColumnsInfo[nCol].m_nType1C);
								v = "";
								break;
							}

							v.SetType(pColumnsInfo[nCol].m_nType1C);
							v = OLE2T(wstrVal);
							break;
						}
						
						default:
						{
							// spock: 2005-11-13
							//   NULL-    :(
							//  :  NULL,   
							//    
							//
							if(DBSTATUS_S_ISNULL == dwStatus)
							{
								v = "";
								break;
							}

							if(true == pColumnsInfo[nCol].m_bIsType1C)
							{
								CString strVal;
								CType LocalType(0);
								
								if(0 == rt.GetTypeID())
								{
									int nTypeCode = rt.GetTypeCode();

									switch(nTypeCode)
									{
										case ENUM_TYPE_1C:
										case REFERENCE_TYPE_1C:
										case CALENDAR_TYPE_1C:
										case ACCOUNT_TYPE_1C:
											{
												strVal	 = (char*)&pRowValues[pDBBindings[nCol].obValue];
												eType	 = CMetaDataWork::LongString;

												LocalType = rt;
											}
											break;
										
										case DOCUMENT_TYPE_1C:
											{
												ULONG nKindCol = 0;
												
												if(HasKindField)
													
													nKindCol = FindKindCol(pColumnsInfo, cCols, pColumnsInfo[nCol].m_strName);

												if(!nKindCol)
												{
													strVal	 = (char*)&pRowValues[pDBBindings[nCol].obValue];
													eType	 = CMetaDataWork::LongString;
												}
												else
												{
													CString strValLoc	 = (char*)&pRowValues[pDBBindings[nCol].obValue];
													CString strKindVal	 = (char*)&pRowValues[pDBBindings[nKindCol - 1].obValue];

													strVal	 = strKindVal + strValLoc;
													eType	 = CMetaDataWork::LongString;
												}
												LocalType = rt;
											}
											break;
										
										default:
											strVal	 = (char*)&pRowValues[pDBBindings[nCol].obValue];
											eType	 = CMetaDataWork::ShortString;

											LocalType = rt;
											break;
									}
								}
								else
								{
									strVal	 = (char*)&pRowValues[pDBBindings[nCol].obValue];
									eType	 = CMetaDataWork::ShortString;

									LocalType = rt;
								}

								CMetaDataWork::Make1C_ValueFromString(v, LocalType, strVal, eType);
							}
							else
							{
								char* strVal = (char*)&pRowValues[pDBBindings[nCol].obValue];

								v.SetType(pColumnsInfo[nCol].m_nType1C);
								v = strVal;
							}
							break;
						}
					};
				}

				pVT->SetValue(v, nCol, cRowNum);
			}

			++cRowNum;
		}

		hr = pIRowset->ReleaseRows(cRowsObtained, m_hRow, NULL, NULL, NULL);
		COLEDBData::Check_HRESULT(hr, "FAILED! IAccessor::GetData()");
	}

	pIAccessor->ReleaseAccessor(hAccessor, NULL);

	return TRUE;
}

BOOL COLEDBCommand::defsExecuteStatement(int nParam, CValue* param) const
{
	switch(nParam)
	{
		case 0:
			*param	 = "";
		case 1:
			*param	 = CNumeric(0);
	};
	return TRUE;
}

BOOL COLEDBCommand::procSetExecTimeOut(CValue **ppValue)
{
	m_ExecTimeout = ppValue[0]->GetNumeric();
	return TRUE;
}

BOOL COLEDBCommand::procSetTempTablesDir(CValue **ppValue)
{
	m_szTempTablesDir.Empty();
	m_szTempTablesDir = ppValue[0]->GetString();

	if (m_szTempTablesDir.IsEmpty())
		RuntimeError("  !");

	if (m_szTempTablesDir.Right(1) != "\\")
		m_szTempTablesDir += "\\";

	//if (m_szTempTablesDir.Find(' ') > 0)
	if (m_szTempTablesDir.Find(' ') >= 0) // artbear
		RuntimeError("   !");

	return TRUE;
}

BOOL COLEDBCommand::procClose(CValue **ppValue)
{
	RemoveAllTmpTables();

	if(m_pICommandText)
	{
		m_pICommandText.Release();
	}

	m_bCreated = false;

	return TRUE;
}

BOOL COLEDBCommand::procDebug(CValue **ppValue)
{
	m_IsDebugMode = (0 == ppValue[0]->GetNumeric()) ? false : true;
	return TRUE;
}

BOOL COLEDBCommand::procSetTextParam(CValue **ppValue)
{
	m_MetaNameParser.SetParameter(ppValue[0]->GetString(), *ppValue[1]);
	return TRUE;
}

BOOL COLEDBCommand::procPutObjectList(CValue **ppValue)
{
	HRESULT hr = PutObjectsList(ppValue);
	return TRUE;
}

BOOL COLEDBCommand::defsPutObjectList(int nParam, CValue* param) const
{
	if (nParam == 2)
		*param = "";

	return TRUE;
}

//_____________________________________________________________________________
//
HRESULT COLEDBCommand::Binding(CComPtr<IRowset>& pIRowset, ULONG& pnCols, sh_array<DBBINDING>& sh_array_DBBindings, sh_array<COLEDBFldsInf>& sh_array_ColumnsInfo1C, sh_array<DBOBJECT>& sh_array_DBObject, ULONG& pcMaxRowSize, bool& HasKindField) const
{
	// OUT: [S_OK, S_FALSE]
	//
	USES_CONVERSION;

	CComPtr<IColumnsInfo> pIColumnsInfo;

	HRESULT hr = pIRowset->QueryInterface(&pIColumnsInfo);
	COLEDBData::Check_HRESULT(hr, "FAILED! IRowset::QueryInterface()");

	ULONG nCols = 0;
	CComBSTR ppColumnStrings;
	DBCOLUMNINFO* pColumnsInfo;

	hr = pIColumnsInfo->GetColumnInfo(&nCols, &pColumnsInfo, &ppColumnStrings);
	COLEDBData::Check_HRESULT(hr, "FAILED! IColumnsInfo::GetColumnInfo()");

	ULONG nDataOffset = 0;
	ULONG nLengthOffset;
	ULONG nStatusOffset;
	
	sh_array_DBBindings = sh_array<DBBINDING>(new DBBINDING[nCols]); //   
	DBBINDING* pDBBindings		 = sh_array_DBBindings.get();

	sh_array_ColumnsInfo1C = sh_array<COLEDBFldsInf>(new COLEDBFldsInf[nCols]); //   
	COLEDBFldsInf* pColInfo1C	 = sh_array_ColumnsInfo1C.get();

	sh_array_DBObject = sh_array<DBOBJECT>(new DBOBJECT[nCols]); //   
	DBOBJECT* pDBObject			 = sh_array_DBObject.get();

	for (ULONG nCol = 0; nCol < nCols; nCol++)
	{
		//
		//   BLOB   .
		// MSDN ,  "text" and "ntext" (its for mssql) - 
		//  DBCOLUMNFLAGS_ISLONG = true or Maximum column size > 4,000 characters
		//

		//   
		//
		pColInfo1C[nCol].m_Index	 = nCol;
		pColInfo1C[nCol].m_strName	 = OLE2T(pColumnsInfo[nCol].pwszName);
		pColInfo1C[nCol].m_wType	 = pColumnsInfo[nCol].wType;
		pColInfo1C[nCol].m_nType1C	 = GetType1C(&pColInfo1C[nCol]);

		//   :           "XXX_"/"XXX_kind"
		//
		if((pColInfo1C[nCol].m_strName.Find("_kind") >= 0) || (pColInfo1C[nCol].m_strName.Find("_") >= 0))
			HasKindField = true;

		if (pColumnsInfo[nCol].dwFlags & DBCOLUMNFLAGS_ISLONG)
		{
			pColInfo1C[nCol].m_bIsLong	 = true;

			pDBObject[nCol].dwFlags		 = STGM_READ;
			pDBObject[nCol].iid			 = IID_ISequentialStream;

			pDBBindings[nCol].pObject	 = &pDBObject[nCol];
			pDBBindings[nCol].wType		 = DBTYPE_IUNKNOWN;
			pDBBindings[nCol].cbMaxLen	 = 0;
		}
		else
		{
			pColInfo1C[nCol].m_bIsLong	 = false;
			
			pDBBindings[nCol].pObject	 = NULL;

			switch (pColumnsInfo[nCol].wType)
			{
				case DBTYPE_STR:
				case DBTYPE_WSTR:
					{
						pDBBindings[nCol].wType		 = pColumnsInfo[nCol].wType;
						pDBBindings[nCol].cbMaxLen	 = pColumnsInfo[nCol].ulColumnSize + sizeof(char);
					}
					break;
				
				case DBTYPE_DBDATE:
				case DBTYPE_DBTIMESTAMP:
					{
						pDBBindings[nCol].wType		 = pColumnsInfo[nCol].wType;
						pDBBindings[nCol].cbMaxLen	 = pColumnsInfo[nCol].ulColumnSize;
					}
					break;
				
				default:
					{
						pDBBindings[nCol].wType		 = DBTYPE_STR;
						pDBBindings[nCol].cbMaxLen	 = 100;
					}
					break;
			};

			nLengthOffset	 = AddOffset(nDataOffset, pDBBindings[nCol].cbMaxLen);
			nStatusOffset	 = AddOffset(nLengthOffset, sizeof(ULONG));
		}

		pDBBindings[nCol].iOrdinal	 = pColumnsInfo[nCol].iOrdinal;
		pDBBindings[nCol].obValue	 = nDataOffset;
		pDBBindings[nCol].obLength	 = nLengthOffset;
		pDBBindings[nCol].obStatus	 = nStatusOffset;
		pDBBindings[nCol].pTypeInfo	 = NULL;
		pDBBindings[nCol].pBindExt	 = NULL;
		pDBBindings[nCol].dwPart	 = DBPART_VALUE | DBPART_STATUS;
		pDBBindings[nCol].dwMemOwner = DBMEMOWNER_CLIENTOWNED;
		pDBBindings[nCol].eParamIO	 = DBPARAMIO_NOTPARAM;
		pDBBindings[nCol].dwFlags	 = 0;
		pDBBindings[nCol].bPrecision = pColumnsInfo[nCol].bPrecision;
		pDBBindings[nCol].bScale	 = pColumnsInfo[nCol].bScale;

		nDataOffset = AddOffset(nStatusOffset, sizeof(DBSTATUS));

		switch (pColInfo1C[nCol].m_nType1C.GetTypeCode())
		{
			case ENUM_TYPE_1C:
			case REFERENCE_TYPE_1C:
			case DOCUMENT_TYPE_1C:
			case CALENDAR_TYPE_1C:
			case CALCULATIONKIND_TYPE_1C:
			case ACCOUNT_TYPE_1C:
			case SUBCONTOKIND_TYPE_1C:
			case CHART_OF_ACC_TYPE_1C:
				pColInfo1C[nCol].m_bIsType1C = true;
				break;
			
			default:
				pColInfo1C[nCol].m_bIsType1C = false;
				break;
		}
	}
	
	pnCols			 = nCols;
// 	sh_array_DBBindings	 = pDBBindings;
// 	*sh_array_ColumnsInfo1C = pColInfo1C;
	pcMaxRowSize	 = nDataOffset;
// 	*sh_array_DBObject		 = pDBObject;
	
	return S_OK;
}

//_____________________________________________________________________________
//
CType COLEDBCommand::GetType1C(COLEDBFldsInf* fInfo) const
{
	if (pDataBase7->GetDataSourceType() == DATA_SOURCE_TYPE_DBF)
	{
		int nPos = -1;
		CType rt(0);
		CString strName = fInfo->m_strName;
		
		nPos = strName.Find(TypeNamePrefix);
		if (nPos >= 0)
		{
			CString Type1C(strName.operator LPCTSTR() + nPos + (sizeof(TypeNamePrefix) - 1));
			Type1C.Replace('_', '.');

			CMetaDataWork::SetTypeAndKind(rt, Type1C);

			strName				 = strName.Left(nPos);
			fInfo->m_strName	 = strName;
			
			return rt;
		}
	}

	switch(fInfo->m_wType)
	{
		case DBTYPE_STR:
		case DBTYPE_WSTR:
		case DBTYPE_DBTIME:
			return CType(2);
            break;

		case DBTYPE_NUMERIC:
		case DBTYPE_I2:
		case DBTYPE_I4:
		case DBTYPE_R4:
		case DBTYPE_R8:
		case DBTYPE_CY:
		case DBTYPE_DECIMAL:
		case DBTYPE_UI1:
		case DBTYPE_BOOL:
		case DBTYPE_I1:
		case DBTYPE_UI2:
		case DBTYPE_UI4:
		case DBTYPE_I8:
		case DBTYPE_UI8:
			return CType(1); // DmitrO ,     (0).(0) - 
            break;

		case DBTYPE_DBDATE:
		case DBTYPE_DBTIMESTAMP:
			return CType(3);
			break;
		
		default:
			return CType(0);
			break;
	};
}

//_____________________________________________________________________________
//
HRESULT COLEDBCommand::ParseQuery(CString& strQuery)
{
	// OUT: [S_OK, S_FALSE]
	//
	CString strErr;

	strQuery.TrimLeft();
	strQuery.TrimRight();

	if (strQuery.IsEmpty())
		RuntimeError("A SQL statement is empty!");

	m_MetaNameParser.SetQueryText(strQuery);
	
	try
	{
		m_MetaNameParser.Parse();
	}
	catch (CMNPException* MNPException)
	{
		strErr = szMNPErrorPrefix + MNPException->GetErrorDescr();
		RuntimeError(strErr);

		MNPException->Delete(); // TODO     
	};

	strQuery = m_MetaNameParser.GetQueryText();

	if (m_IsDebugMode)
		pBkEndUI->DoMessageLine(strQuery, mmNone);
	
	return S_OK;
}

//_____________________________________________________________________________
//
HRESULT COLEDBCommand::Execute(const CString& strSQL, long& nRowsAffected, IUnknown** pIRowset, bool quiet) const
{
	USES_CONVERSION;
	
	HRESULT hr;
	CString strErr;

	hr = m_pICommandText->SetCommandText(DBGUID_DEFAULT, T2OLE(strSQL));

	if (FAILED(hr))
		if (quiet)
			return S_FALSE;

	COLEDBData::Check_HRESULT(hr, "FAILED! ICommandText::SetCommandText()");
	

	if (m_ExecTimeout >= 0)
	{
		CComPtr<ICommandProperties> spCommProperties;

		hr = m_pICommandText->QueryInterface(&spCommProperties);
		COLEDBData::Check_HRESULT(hr, "FAILED! ICommandProperties::QueryInterface()");

		CDBPropSet PropSet(DBPROPSET_ROWSET);
		PropSet.AddProperty(DBPROP_COMMANDTIMEOUT, m_ExecTimeout);
		
		hr = spCommProperties->SetProperties(1, &PropSet);
		if (FAILED(hr))
			RuntimeError("FAILED! ICommandProperties::SetProperties():    property");
	}

	if (!pIRowset)
		hr = m_pICommandText->Execute(NULL, IID_NULL, NULL, &nRowsAffected, NULL);
	else
		hr = m_pICommandText->Execute(NULL, IID_IRowset, NULL, &nRowsAffected, pIRowset);

	if (FAILED(hr))
		if (quiet)
			return S_FALSE;

	COLEDBData::Check_HRESULT(hr, "FAILED! ICommandText::Execute()");

	return S_OK;
}

//_____________________________________________________________________________
//
HRESULT COLEDBCommand::CreateAccessor(CComPtr<IAccessor>& pIAccessor, CComPtr<IRowset>& pIRowset, HACCESSOR& hAccessor, ULONG& cCols, DBBINDING* pDBBindings) const
{
	// OUT: [S_FALSE, S_OK]
	//
	HRESULT hr;
	CString strErr;

	hr = pIRowset->QueryInterface(IID_IAccessor, (void**)&pIAccessor);
	COLEDBData::Check_HRESULT(hr, "FAILED! IRowset::QueryInterface()");
	
	sh_array<DBBINDSTATUS> sh_array_DBBindStatus(new DBBINDSTATUS[cCols]); //   
	DBBINDSTATUS* pDBBindStatus = sh_array_DBBindStatus.get();

	hr = pIAccessor->CreateAccessor(DBACCESSOR_ROWDATA, cCols, pDBBindings, 0, &hAccessor, pDBBindStatus);
	COLEDBData::Check_HRESULT(hr, "FAILED! IAccessor::CreateAccessor()");
	
	return S_OK;
}

//_____________________________________________________________________________
//
HRESULT COLEDBCommand::PutObjectsList(CValue** ppValue)
{
	CString strErr;
	HRESULT hr;

	//  ,    
	//
	CValue* pTableName = ppValue[1];
	pTableName->Reset();

	//   GUID
	//
	::UuidCreate(&m_GUID);
	
	unsigned char* strGUID;
	::UuidToString(&m_GUID, &strGUID);
	
	//    GUID
	//
	CString szTableName = strGUID;
	szTableName = m_szTempTablesDir + szTableName;
	::RpcStringFree(&strGUID);

	CString strSQL;
	
	//   
	//
	strSQL.Format("CREATE TABLE %s (VAL C(9), ISFOLDER N(1,0))", szTableName);

	long nRowsAffected = 0;
	hr = COLEDBCommand::Execute(strSQL, nRowsAffected);
	if (FAILED(hr))
		RuntimeError("    !");

	//  :  
	//
	m_TmpTblsList.AddTail(szTableName);

	CString RefName = ppValue[2]->GetString();

	bool ToDeleteFldr = false;

	if (ppValue[0]->GetTypeCode() == AGREGATE_TYPE_1C)
	{
		//    
		//
		CBLContext* pValCont = ppValue[0]->GetContext();

		if (pValCont && !strcmp(pValCont->GetRuntimeClass()->m_lpszClassName, "CValueListContext"))
		{
			CPtrArray* pVL = *(CPtrArray**) (((char*)pValCont) + 0x30);
			
			int nlistSize = pVL->GetSize();
			for(int i = 0; i < nlistSize; i++)
			{
				CValue* pValItem = (CValue*)pVL->GetAt(i);

				hr = PutAggregateObjects(pValItem, &szTableName, &RefName);
				if (FAILED(hr))
					return S_FALSE;
			}

			if (nlistSize > 0)
				ToDeleteFldr = true;
		}
		else
			RuntimeError("    !");
	}
	else if (ppValue[0]->GetTypeCode() > DATE_TYPE_1C)
	{
		//    
		//
		CValue* pAggregate	 = ppValue[0];

		hr = PutAggregateObjects(pAggregate, &szTableName, &RefName);
		if (FAILED(hr))
			return S_FALSE;

		ToDeleteFldr = true;
	}

	if (ToDeleteFldr)
	{
		//        -  (isfolder=1)
		//
		strSQL = "DELETE FROM %tmptblnm WHERE ISFOLDER = 1";
		strSQL.Replace("%tmptblnm", szTableName);

		nRowsAffected = 0;
		hr = COLEDBCommand::Execute(strSQL, nRowsAffected);
		if (FAILED(hr))
			RuntimeError("      !");

		strSQL = "USE";

		nRowsAffected = 0;
		hr = COLEDBCommand::Execute(strSQL, nRowsAffected);
		if (FAILED(hr))
			RuntimeError("     !");
	}

	// ,      
	//
	*pTableName	 = szTableName.operator LPCTSTR();
	
	return S_OK;
	}

//_____________________________________________________________________________
//
HRESULT COLEDBCommand::PutAggregateObjects(CValue* pValue, const CString* pszTableName, const CString* RefName)
{
	CString strErr;
	CString strSQL;
	HRESULT hr;

	CSbCntTypeDef* pSbCntTypeDef = NULL;

	if (!RefName->IsEmpty())
	{
		pSbCntTypeDef = pMetaDataCont->GetSTypeDef(*RefName);
		
		if (!pSbCntTypeDef)
			RuntimeError("    !");
	}

	int nLevelsCount = 1;
	int nIsFldr		 = 2;
	
	if (!pValue->IsEmpty() && !RefName->IsEmpty())
	{
		CValue arValue;
		arValue.Reset();

		pValue->LinkContext(FALSE);
		CBLContext* pValCont = pValue->GetContext();
		pValCont->CallAsFunc(pValCont->FindMethod("IsGroup"), arValue, NULL);
		nIsFldr = 0 == arValue.GetNumeric() ? 2 : 1;

		nLevelsCount = pSbCntTypeDef->GetLevelsLimit();
	}

	CString ObjStr = "'";
	ObjStr += CMetaDataWork::GetObjDBString(*pValue, CMetaDataWork::ShortString);
	ObjStr += "'";

	strSQL.Empty();
	strSQL.Format("INSERT INTO %s (VAL, ISFOLDER) VALUES (%s, %d)", (*pszTableName), ObjStr, nIsFldr);

	long nRowsAffected = 0;
	hr = COLEDBCommand::Execute(strSQL, nRowsAffected);
	if (FAILED(hr))
		RuntimeError("    !");

	//     ,    
	//
	if (RefName->IsEmpty() || nLevelsCount < 2)
	{
		return S_OK;
	}

	strSQL.Empty();

	strSQL = "INSERT INTO %tmptblnm (VAL, ISFOLDER)\r\n\
			SELECT SC.ID as VAL, SC.ISFOLDER as ISFOLDER\r\n\
			FROM %sctbl as SC\r\n\
			WHERE\r\n\
			(SC.PARENTID IN (SELECT T.VAL FROM %tmptblnm as T))\r\n\
			AND (SC.ID NOT IN (SELECT TT.VAL FROM %tmptblnm as TT))";

	strSQL.Replace("%tmptblnm", (*pszTableName));
	
	CString RefTable;
	RefTable.Format("sc%d", pSbCntTypeDef->GetID());
	strSQL.Replace("%sctbl", RefTable);

	//     ,  -   
	//
	do
	{
		nRowsAffected = 0;
		hr = COLEDBCommand::Execute(strSQL, nRowsAffected);
		if (FAILED(hr))
			RuntimeError("   !");
	}while (nRowsAffected > 0 && !FAILED(hr));
	
	return S_OK;
}

//_____________________________________________________________________________
//
void COLEDBCommand::RemoveTmpTable(CString& strTmpTblName)
{
	//    ,     
	//   ,  
	//
	if(!m_pICommandText)
		return;

	CString strErr;
	HRESULT hr;

	CString strSQL("DROP TABLE ");
	strSQL += strTmpTblName;

	long nRowsAffected = 0;
	hr = COLEDBCommand::Execute(strSQL, nRowsAffected, NULL, true);
}

//_____________________________________________________________________________
//
void COLEDBCommand::RemoveAllTmpTables(void)
{
	int nCountTmps = m_TmpTblsList.GetCount();
	if (nCountTmps > 0)
	{
		for(int i = 0; i < nCountTmps; ++i)
			RemoveTmpTable(m_TmpTblsList.GetAt(m_TmpTblsList.FindIndex(i)));

		m_TmpTblsList.RemoveAll();
	}
}

//_____________________________________________________________________________
//
ULONG COLEDBCommand::FindKindCol(const COLEDBFldsInf* pColumnsInfo, const ULONG& cMaxCols, const CString& strColName) const
{
	CString tmpNameRus(strColName);
	tmpNameRus += "_";
	
	CString tmpNameEng(strColName);
	tmpNameEng += "_kind";

	for(ULONG cCol = 0; cCol < cMaxCols; cCol++)
	{
		int nRus = tmpNameRus.Compare(pColumnsInfo[cCol].m_strName);
		int nEng = tmpNameEng.Compare(pColumnsInfo[cCol].m_strName);
		
		if((0 == nRus) || (0 == nEng))
			return cCol + 1;
	}

	return 0;
}