//   aka spock
// #163860836
// e-mail: spock@km.ru
//
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __oledb_h__
#include <oledb.h>
#endif // __oledb_h__

#include "..\\ODBC\\MetaNameParser.h"
#include "..\\SQL\\MetaDataWork.h"
#include "..\\GUID.h"
#include "sp_oledb.h"

#define NUMROWS_CHUNK 50
#define BLOCK_SIZE 1024

//_____________________________________________________________________________
//
struct COLEDBFldsInf
{
public:
	COLEDBFldsInf();

	ULONG	 m_Index;
	CString	 m_strName; 
	CType	 m_nType1C;
	DBTYPE	 m_wType;
	bool	 m_bIsType1C;
	bool	 m_bIsLong;
};

//_____________________________________________________________________________
//
class COLEDBCommand : public CMyContextBase // CBLContext
{
    DECLARE_DYNCREATE(COLEDBCommand);
public:
	//  -  !
	//   ,    (m_bCreated) 
	//
	COLEDBCommand() //    
	{ RuntimeError("   COLEDBCommand  "); }

	COLEDBCommand(CComPtr<IDBCreateCommand> pIDBCreateCommand);
	virtual ~COLEDBCommand();

//trad
	void SetIBProp(CMetaDataCont *pMDC, CIBSet *pIBSet) {m_MetaNameParser.SetIBProp(pMDC, pIBSet);};
	CBLPtr<COLEDBData> m_pOLEDBData;
//

	BOOL funcExecute(CValue &RetVal, CValue **ppValue);
	BOOL defsExecute(int nParam, CValue* param) const;
	
	BOOL funcExecuteStatement(CValue &RetVal, CValue **ppValue);
	BOOL defsExecuteStatement(int nParam, CValue* param) const;
	
	BOOL procSetExecTimeOut(CValue **ppValue);
	BOOL procSetTempTablesDir(CValue **ppValue);
	BOOL procClose(CValue **ppValue);
	BOOL procDebug(CValue **ppValue);
	
	BOOL procSetTextParam(CValue **ppValue);

	BOOL procPutObjectList(CValue **ppValue);
	BOOL defsPutObjectList(int nParam, CValue* param) const;

private:
	//static void GetErrorDescription(CString& strError);

	HRESULT COLEDBCommand::Binding(CComPtr<IRowset>& pIRowset, ULONG& pnCols, sh_array<DBBINDING>& sh_array_DBBindings, sh_array<COLEDBFldsInf>& sh_array_ColumnsInfo1C, sh_array<DBOBJECT>& sh_array_DBObject, ULONG& pcMaxRowSize, bool& HasKindField) const;
	
	CType GetType1C(COLEDBFldsInf* fInfo) const;
	HRESULT ParseQuery(CString& strQuery);
	HRESULT Execute(const CString& strSQL, long& nRowsAffected, IUnknown** pIRowset = NULL, bool quiet=false) const;
	HRESULT CreateAccessor(CComPtr<IAccessor>& pIAccessor, CComPtr<IRowset>& pIRowset, HACCESSOR& hAccessor, ULONG& cCols, DBBINDING* pDBBindings) const;
	HRESULT PutObjectsList(CValue** ppValue);
	HRESULT PutAggregateObjects(CValue* pValue, const CString* pszTableName, const CString* RefName);
	void RemoveTmpTable(CString& strTmpTblName);
	void RemoveAllTmpTables(void);
	ULONG FindKindCol(const COLEDBFldsInf* pColumnsInfo, const ULONG& cMaxCols, const CString& strColName) const;

	CMetaNameParser m_MetaNameParser;
	CComPtr<ICommandText> m_pICommandText;
	bool	 m_bCreated;
	bool	 m_IsDebugMode;
	GUID	 m_GUID;
	CString	 m_szTempTablesDir;
	long	 m_ExecTimeout;

	CList<CString, CString&> m_TmpTblsList;

    DECLARE_MY_CONTEXT()
};
