//   aka spock
// #163860836
// e-mail: spock@km.ru
//
#include "stdafx.h"
#include "sp_oledb.h"
#include "sp_cooledb.h"

extern CDataBase7* pDataBase7;
extern CMetaDataCont* pMetaDataCont;
extern CBkEndUI* pBkEndUI;

BEGIN_BL_METH_MAP(COLEDBData) 

    BL_METH_FUNC_DEF_PARAM("Connect",		"",		1, funcConnect, defsConnect)
    BL_METH_FUNC_DEF_PARAM("AttachIB",		"",	2, funcAttachIB, defsAttachIB)

    BL_METH_PROC("Close",		"",		0, procClose)
    BL_METH_FUNC("CreateCommand",		"",		0, funcCreateCommand)

END_BL_METH_MAP()

BEGIN_BL_PROP_MAP(COLEDBData)
END_BL_PROP_MAP()

IMPLEMENT_MY_CREATE_CONTEXT(COLEDBData, "OLEDBData", "OLEDBData");

//_____________________________________________________________________________
//
COLEDBData::COLEDBData() : CMyContextBase()
{
	m_bConnected = false;
	m_pInit		 = NULL;

//trad
    m_pMetaDataCont = pMetaDataCont;
//
}

//_____________________________________________________________________________
//
COLEDBData::~COLEDBData()
{
	m_bConnected = false;
//trad
    CMetaDataWork::UnloadMD(m_pMetaDataCont);
//
}

BOOL COLEDBData::funcConnect(CValue &rValue, CValue **ppValue)
{
 	USES_CONVERSION;

	HRESULT hr;
	CString strErr;

	CComPtr<IDataInitialize> pIDataInit;

	hr = CoCreateInstance(CLSID_MSDAINITIALIZE, NULL, CLSCTX_INPROC_SERVER, IID_IDataInitialize, (void**)&pIDataInit);
	
	COLEDBData::Check_HRESULT(hr, "FAILED! CoCreateInstance()");

	CString strConn(ppValue[0]->GetString());
	if (strConn.IsEmpty())
	{
		CString pathBase1C = ::CallMethodOfGlobalContexts0("IBDir");
		strConn = "Provider=VFPOLEDB.1;Deleted=Yes;Mode=ReadWrite;Collating Sequence=RUSSIAN;Data Source=" + pathBase1C;
	}

	hr = pIDataInit->GetDataSource(NULL, CLSCTX_INPROC_SERVER, T2OLE(strConn), IID_IDBInitialize, (IUnknown**)&m_pInit);
	COLEDBData::Check_HRESULT(hr, "FAILED! IDataInitialize::GetDataSource()");

	hr = m_pInit->Initialize();
	COLEDBData::Check_HRESULT(hr, "FAILED! IDBInitialize::Initialize()");

	CComPtr<IDBCreateSession> pIDBCreateSession;

	hr = m_pInit->QueryInterface(IID_IDBCreateSession, (void**)&pIDBCreateSession);
	COLEDBData::Check_HRESULT(hr, "FAILED! IDBCreateSession::QueryInterface()");

	hr = pIDBCreateSession->CreateSession(NULL, IID_IDBCreateCommand, (IUnknown**)&m_pIDBCreateCommand);
	COLEDBData::Check_HRESULT(hr, "FAILED! IDBCreateSession::CreateSession()");

	m_bConnected = true;
	rValue		 = 1L;

	return TRUE;
}

BOOL COLEDBData::defsConnect(int nParam, CValue* param) const
{
	*param	 = "";
	return TRUE;
}

BOOL COLEDBData::procClose(CValue **ppValue)
{
	m_bConnected = false;
	m_pIDBCreateCommand.Release();
	m_pInit.Release();

	return TRUE;
}

BOOL COLEDBData::funcCreateCommand(CValue &rValue, CValue **ppValue)
{
	if (!m_bConnected)
		RuntimeError("       !");
	
	/*CComPtr<ICommandText> pICommandText;
	hr = m_pIDBCreateCommand->CreateCommand(NULL, IID_ICommandText, (IUnknown**)&pICommandText);
	COLEDBData::Check_HRESULT(hr, "FAILED! IDBCreateCommand::CreateCommand()");

	COLEDBCommand* pCoOLEDB = new COLEDBCommand(pICommandText);
	*/

	try
	{
		COLEDBCommand* pCoOLEDB = new COLEDBCommand(m_pIDBCreateCommand);
//trad
		pCoOLEDB->m_pOLEDBData = this;
		pCoOLEDB->SetIBProp(m_pMetaDataCont, &m_OLEDBIBSet);
//
		rValue.AssignContext(pCoOLEDB);
		pCoOLEDB->DecrRef();
	}
	catch(...)
	{
		RuntimeError("FAILED! COLEDBCommand::COLEDBCommand():    !");
	}

	return TRUE;
}

BOOL COLEDBData::funcAttachIB(CValue &rValue, CValue **ppValue)
{
	if (ppValue[0]->GetTypeCode() != STRING_TYPE_1C ||
		ppValue[1]->GetTypeCode() != STRING_TYPE_1C)
	{
		RuntimeErrorRes(4712); //  
	}
	
	CString strFileName(ppValue[0]->GetString());
	strFileName.Format("%s%s", strFileName, "1cv7.md");

	if (!CMetaDataWork::LoadMD(strFileName, m_pMetaDataCont))
		RuntimeErrorRes(28771); //  .
	
	if (ppValue[1]->GetString().IsEmpty())
		*ppValue[1] = "Provider=VFPOLEDB.1;Deleted=Yes;Mode=ReadWrite;Collating Sequence=RUSSIAN;Data Source=" + ppValue[0]->GetString();

	return funcConnect(rValue, &ppValue[1]);
}

BOOL COLEDBData::defsAttachIB(int nParam, CValue* param) const
{
	*param	 = "";
	return TRUE;
}

void COLEDBData::Check_HRESULT(HRESULT hr, const CString& str)
{
	if (FAILED(hr))
	{
		CString strErr = str;
		GetErrorDescription(strErr);
		RuntimeError(strErr);
	}

}

//_____________________________________________________________________________
//
void COLEDBData::GetErrorDescription(CString& strError) //const
{
	HRESULT hr;
	
	CComPtr<IErrorInfo> pIErrorInfo;
	hr = ::GetErrorInfo(0, &pIErrorInfo);
	if (SUCCEEDED(hr))
	{
		CComBSTR errDescr;
		pIErrorInfo->GetDescription(&errDescr);

		strError += ": ";
		strError += errDescr.m_str;
	}
}

//trad
//_____________________________________________________________________________
//
// CDate CIBSetOLEDB::GetDateTimeTA(CEventTime &TimeTA)
// {
// 	return CIBSet::GetDateTimeTA(TimeTA);
// }
int CIBSetOLEDB::GetDataSourceType()
{
    return DATA_SOURCE_TYPE_DBF;
}
// enum PeriodType CIBSetOLEDB::GetRestsSnapShotPeriod()
// {
//     return CIBSet::GetRestsSnapShotPeriod();
// }
//