
#include "stdafx.h"
#include "..\\TurboBL\\gcboost.h"

#include "GroupContextWrap.h"

CGroupContextWrap wrapperForGroupContext;
CHookGroupContext hookInstaller;

bool CGroupContextWrap::Lookup(const CBLModule* pMod, GCWModuleData*& pModData) const
{
	return _Lookup(pMod, pModData, NULL);
}

//bool CGroupContextWrap::Lookup(const CBLModule* pMod, GCWModuleData*& pModData, const CBLContext*& pCont) const
bool CGroupContextWrap::Lookup(const CBLModule* pMod, GCWModuleData*& pModData, const CComponentClass*& pCont) const
{
	return _Lookup(pMod, pModData, &pCont);
}

const CComponentClass* CGroupContextWrap::GetWrapper(const CBLModule* pMod) const
{
	GCWModuleData* pModData = NULL;
	const CComponentClass* pCont = NULL;
	
	Lookup(pMod, pModData, pCont);
	return pCont;
}

////bool CGroupContextWrap::Lookup(const CBLModule* pMod, GCWModuleData*& pModData, const CBLContext** ppCont) const
//bool CGroupContextWrap::_Lookup(const CBLModule* pMod, GCWModuleData*& pModData, const CBLContext** ppCont) const
bool CGroupContextWrap::_Lookup(const CBLModule* pMod, GCWModuleData*& pModData, const CComponentClass** ppCont) const
{
	//if(!cModuleMap.Lookup((void*)pMod, (void *&)pModData))
	if(!cModuleMap.Lookup(pMod, pModData))
	{
//LogErr(" Lookup,    CBLModule* %d", pMod);
		return false;
	}
	else
	{
		if (NULL == pModData)
		{
//LogErr(" Lookup, ,    GCWModuleData* = NULL");
			return false;
		}

		if (ppCont != NULL)
		{
			if (!pModData->pHookCont)
			{
//LogErr(" Lookup, ,  -  ");
				return false;
			}
/*
			const CSafeContextPtr safeCont = pModData->pHookCont;
			if (!safeCont) //     - ,  
			{
//LogErr(" Lookup, ,  -  ");
				return false;
			}

			*ppCont = safeCont;
*/
			*ppCont = (CComponentClass*)(CBLContext*)pModData->pHookCont;
		}
		return true;
	}
	return false;
}

//bool CGroupContextWrap::LookupMethod(const CBLModule* pMod, GCWModuleData*& pModData, const CBLContext*& pCont, int iMethNumOfModule, int& iNumMethOfContext) const
bool CGroupContextWrap::LookupMethod(const CBLModule* pMod, GCWModuleData*& pModData, const CComponentClass*& pCont, int iMethNumOfModule, int& iNumMethOfContext) const
{
	//(!Lookup(pMod, pModData, &pCont))
	if(!_Lookup(pMod, pModData, &pCont))
		return false;

	if (!pModData->cMethodsNumMap.Lookup(iMethNumOfModule, iNumMethOfContext))
	{
//LogErr(" LookupMethod,          %d", iMethNumOfModule);
		return false;
	}

	return true;
}

void CGroupContextWrap::ValidateParamUserClass(const CValue& UserClassContValue) const
{
	CBLContext* pUserClassCont = UserClassContValue.GetContext();

	if (!IS_KINDOF_CComponentClass(pUserClassCont))
		RuntimeError(": -     1++");
}

void CGroupContextWrap::ValidateParamUserClass(const CComponentClass* pUserClassCont, bool bIsHookOfGlobalModule) const
{
	if (bIsHookOfGlobalModule)
		if (!pMainAddIn->Property[""])
			RuntimeError("  ''   ");

	if (!pUserClassCont)
		if (!bIsHookOfGlobalModule)
			RuntimeError(":   -");
		else
			RuntimeError(":   -");
}

void CGroupContextWrap::ValidateParam(const CGroupContext* pGroupCont, const CComponentClass* pUserClassCont) const
{
	if (!pMainAddIn->Property[""])
		RuntimeError("  ''   ");

	if (!pGroupCont)
		RuntimeError(":    ");

	ValidateParamUserClass(pUserClassCont);
}

// void CGroupContextWrap::ValidateParamGroupContext(const CValue& GroupContValue) const
// {
// // 	CBLContext* pGroupCont = GroupContValue.GetContext();
// // 
// // 	if (!IS_KINDOF_CGroupContext(pGroupCont))
// // 		RuntimeError(":     ");
// 	ValidateParamGroupContext(GroupContValue, ":     ");
// }

void CGroupContextWrap::ValidateParam(const CValue& GroupContValue, const CValue& UserClassContValue) const
{
	ValidateParamGroupContext(GroupContValue, ":     ");
	ValidateParamUserClass(UserClassContValue);
}

const CComponentClass* CGroupContextWrap::GetWrapper(const CGroupContext* pGroupCont) const
{
	CBLModule* pMod = GetModuleByContext(pGroupCont);
	if (!pMod)
		pMod = CBLModule::GetExecutedModule(); // TODO ,    ?
	
	return GetWrapper(pMod);
}

const CComponentClass* CGroupContextWrap::GetWrapper(const CValue& GroupContValue) const
{
	ValidateParamGroupContext(GroupContValue, ":     ");
	return GetWrapper((CGroupContext*)GroupContValue.GetContext());
}

const CComponentClass* CGroupContextWrap::GetWrapperForGlobalModule() const
{
	return GetWrapper(::GetGlobalModule());
}

void CGroupContextWrap::SetWrapperForGlobalModule(const CValue& UserClassContValue)
{
	ValidateParamUserClass(UserClassContValue);
	SetWrapperForGlobalModule((CComponentClass*)UserClassContValue.GetContext());
}

void CGroupContextWrap::SetWrapperForModule(const CBLModule* pMod, const CComponentClass* pUserClassCont, bool bIsHookOfGlobalModule)
{
/*
if (bIsHookOfGlobalModule)
	LogErr("   %s   (%d)", "SetWrapper", pMod);
else
	LogErr("   %s pMod = %d", "SetWrapper", pMod);
*/

	GCWModuleData* pModData = NULL;
	
	if(!Lookup(pMod, pModData))
	{
		pModData = new GCWModuleData(pUserClassCont);

		cModuleMap.SetAt(pMod, pModData);
/*if (bIsHookOfGlobalModule)
	LogErr("   %s   (%d)", "SetWrapper", pMod);
else
	LogErr("   %s pMod = %d", "SetWrapper", pMod);
*/
		
		bHaveSetHooks = true;

	}
	else
		if (bIsHookOfGlobalModule)
			RuntimeError("     !"); // TODO  
		//else
		//	RuntimeError("     !"); // TODO  
}

void CGroupContextWrap::SetWrapperForGlobalModule(const CComponentClass* pUserClassCont)
{
	ValidateParamUserClass(pUserClassCont);

	CBLModule* pMod = ::GetGlobalModule();
	SetWrapperForModule(pMod, pUserClassCont, true);
}

void CGroupContextWrap::SetWrapper(const CValue& GroupContValue, const CValue& UserClassContValue)
{
	ValidateParam(GroupContValue, UserClassContValue);
	SetWrapper((CGroupContext*)GroupContValue.GetContext(), (CComponentClass*)UserClassContValue.GetContext());
}

void CGroupContextWrap::SetWrapper(const CGroupContext* pGroupCont, const CComponentClass* pUserClassCont)
{
//LogErr("1    %s pGroupCont = %d", "SetWrapper", pGroupCont);
//LogErr("1    %s pCont->m_FlagAutoDestroy = %d", "SetWrapper", pGroupCont->m_FlagAutoDestroy);

	ValidateParam(pGroupCont, pUserClassCont);

	CBLModule* pMod = GetModuleByContext(pGroupCont);
	//if (!pMod)
	//	pMod = CBLModule::GetExecutedModule(); // TODO ,    ?

	SetWrapperForModule(pMod, pUserClassCont, false);
};

void CGroupContextWrap::DestroyWrapper(const CBLModule* pMod)
{
	if (!IsWrapEnable())
		return;

//LogErr("   %d", pMod);

	GCWModuleData* pModData = NULL;
	if(Lookup(pMod, pModData))
	{
//LogErr(" ");
		//cModuleMap.RemoveKey((void*)pMod);
		cModuleMap.RemoveKey(pMod);
		delete pModData;
	}
}

void CGroupContextWrap::DestroyWrapper(const CValue& GroupContValue)
{
	ValidateParamGroupContext(GroupContValue, "K:    ");
	CGroupContext* pGroupCont = (CGroupContext*)GroupContValue.GetContext();

	CBLModule* pMod = GetModuleByContext(pGroupCont);
	//if (!pMod)
	//	pMod = CBLModule::GetExecutedModule(); // TODO ,    ?

	DestroyWrapper(pMod);
}

int CGroupContextWrap::FindMethodOfContext(const CComponentClass* pCont, char const * sName) const
{
	int iNum = pCont->FindMethod(sName);
	if (-1 == iNum)
		iNum = pCont->FindMethod(CString("_")+sName);
	return iNum;
}

//int  CGroupContextWrap::FindWrapMethod(const CBLModule* pMod, char const * sRusName, char const * sEngName, const CBLContext*& pCont)const
int  CGroupContextWrap::FindWrapMethod(const CBLModule* pMod, char const * sRusName, char const * sEngName, const CComponentClass*& pCont)const
{
	if (!IsWrapEnable())
		return -1;

/*	GCWModuleData* pModData = NULL;
	//(Lookup(pMod, pModData, &pCont))
	if(Lookup(pMod, pModData, pCont))
*/
	pCont = GetWrapper(pMod);
	if (pCont)
	{
//LogErr("%s -    %s", "FindWrapMethod", sRusName);
		//int iNum = pCont->FindMethod(sRusName);
		int iNum = FindMethodOfContext(pCont, sRusName);
		if (-1 == iNum)
			//iNum = pCont->FindMethod(sEngName);
			iNum = FindMethodOfContext(pCont, sEngName);
//LogErr("%s -    %s,   %d", "FindWrapMethod", sRusName, iNum);

		return iNum;

	}

	return -1;
}

int  CGroupContextWrap::FindMethod(const CBLModule* pMod, bool bFuncFlag, char const * pName, int flag)const
{
	if (!IsWrapEnable())
		return -1;
//LogErr("%s:     %s %d", "FindMethod", pName, flag);

	GCWModuleData* pModData = NULL;
	//const CBLContext* pCont = NULL;
	const CComponentClass* pCont = NULL;
	//(Lookup(pMod, pModData, &pCont))
	if(Lookup(pMod, pModData, pCont))
	{
//LogErr("%s:    %s %d", "FindMethod", pName, flag);
		//int iNumInContext = pCont->FindMethod(pName); // TODO  ,    -      :(
		int iNumInContext = FindMethodOfContext(pCont, pName); // TODO  ,    -      :(
		if (-1 == iNumInContext)
		{
//LogErr("%s:      %s", "FindMethod", pName);
			return -1;
		}
		int iNumInMod = -1;
		
		//          -
		if (bFuncFlag)
			iNumInMod = pMod->FindFunc(pName);
		else
			iNumInMod = pMod->FindProc(pName, flag);

		if (-1 == iNumInMod)
		{
//LogErr("%s:       %s", "FindMethod", pName);
			//return -1;
			iNumInMod = pMod->GetNProcs() + iNumInContext;
		}
		
		pModData->cMethodsNumMap.SetAt(iNumInMod, iNumInContext);

//LogErr("   <%s>   <%d>,      <%d>", "FindMethod", iNumInMod, iNum);
		return iNumInMod;
	}
	return -1;
}

int  CGroupContextWrap::CallMethod(const CBLModule* pMod, bool bFuncFlag, int num,class CValue * pRetValue,int argNum,class CValue * * ppValue) const
{
	if (!IsWrapEnable())
		return 0;

	GCWModuleData* pModData = NULL;
	const CComponentClass* pCont = NULL;
	int iNumMethOfCont;
//LogErr("    <%s>   <%d>", "CallMethod", num);

	if (!LookupMethod(pMod, pModData, pCont, num, iNumMethOfCont))
		return 0;

//LogErr("   <%s>   <%d>", "CallMethod", iNumMethOfCont);

	return CallMethodOfContext(pCont, bFuncFlag, iNumMethOfCont, pRetValue, ppValue);

	return 0;
}

void CGroupContextWrap::CallOriginalEventOfGroupContext(CGroupContext* pCont, const CString& strEventName, CValueListContext* pValueListCont) const
{
	CBLPtr<CExecuteModule> pContExecModule("");
	pContExecModule->CallContextProcedure(pCont, strEventName, pValueListCont);
}

void CGroupContextWrap::CallOriginalEventOfGroupContext(const CValue& ValueGroupContext, const CValue& ValueOfEventName, const CValue& ValueArgList) const
{
	ValidateParamGroupContext(ValueGroupContext, ":    ");
	ValidateParamNotEmptyString(ValueOfEventName, ":      ");
	ValidateParamValueListContext(ValueArgList, ":        ");

	CallOriginalEventOfGroupContext((CGroupContext*)ValueGroupContext.GetContext(), ValueOfEventName.GetString(), (CValueListContext*)ValueArgList.GetContext());
}

int  CGroupContextWrap::GetProcInfo(const CBLModule* pMod, int nProc, class CBLProcInfo & cProcInfo) //const
{
	//       -    
	if (!IsWrapEnable())
		return 0;

	GCWModuleData* pModData = NULL;
	const CComponentClass* pCont = NULL;
	int iNum;
//LogErr("%s   %d   %d", "GetProcInfo", pMod, nProc);

	if (!LookupMethod(pMod, pModData, pCont, nProc, iNum))
	{
		// FormEx       FindFunc  FindProc
		//   .   
		class CBLProcInfo ProcInfo;
		if(!pMod->GetProcInfo(nProc, ProcInfo))
			return 0;

		if (-1 == FindMethod(pMod, ProcInfo.HasRetVal() ? true : false, ProcInfo.GetName(), 0))
			return 0;
	}

//LogErr(" %s   %d   %d", "GetProcInfo", pMod, nProc);

	cProcInfo.m_Module = const_cast<CBLModule*>(pMod);
	cProcInfo.m_ProcID = nProc; //iNum; //         !

	//int t = cProcInfo.GetType();
	m_pCBLProcInfo = &cProcInfo; 

	return 1;

}

void CGroupContextWrap::CBLProcInfo_CBLProcInfo(void)
{
	//       -    
	if (!IsWrapEnable())
		return;

	m_pCBLProcInfo = NULL;

}

int  CGroupContextWrap::CBLProcInfo_GetType(CBLProcInfo* pProcInfo)
{
	if (IsWrapEnable() && m_pCBLProcInfo && m_pCBLProcInfo == pProcInfo)
	{
		GCWModuleData* pModData = NULL;
		const CComponentClass* pCont = NULL;
		int iNum;
		//LogErr("%s   %d   %d", "GetProcInfo", pMod, nProc);

		if (LookupMethod(pProcInfo->m_Module, pModData, pCont, pProcInfo->m_ProcID, iNum))
			return !pCont->HasRetVal(iNum) ? 1 : 0 ;
	}

	m_pCBLProcInfo = NULL;

	return pProcInfo->GetType();

}

// int  CGroupContextWrap::CBLProcInfo_GetNParams(CBLProcInfo* pProcInfo)
// {
// 	if (IsWrapEnable() && m_pCBLProcInfo && m_pCBLProcInfo == pProcInfo)
// 	{
// 		GCWModuleData* pModData = NULL;
// 		const CComponentClass* pCont = NULL;
// 		int iNum;
// 		//LogErr("%s   %d   %d", "GetProcInfo", pMod, nProc);
// 
// 		if (LookupMethod(pProcInfo->m_Module, pModData, pCont, pProcInfo->m_ProcID, iNum))
// 			return !pCont->GetNParams(iNum);
// 	}
// 	
// 	m_pCBLProcInfo = NULL;
// 
// 	return pProcInfo->GetNParams();
// 
// }

void CGroupContextWrap::CallOriginalEventOfGlobalModule(int iMethodNum, CValueListContext* pValueListCont) const
{
	if (-1 == iMethodNum)
		return;

	// TODO      

	CBLModule* pMod = GetGlobalModule();

	CBLProcInfo ProcInfo;
	pMod->GetProcInfo(iMethodNum, ProcInfo);
	int iMethodParams = ProcInfo.GetNParams();

	CCallWithValueListGuard guard(iMethodParams, pValueListCont);

	int iRes = pMod->CallAsProc(iMethodNum, iMethodParams, guard.ppValues);
}

void CGroupContextWrap::CallOriginalEventOfGlobalModule(const CValue& ValueOfEventName, const CValue& ValueArgList) const
{
	ValidateParamNotEmptyString(ValueOfEventName, ":      ");
	ValidateParamValueListContext(ValueArgList, ":        ");

	int iMethodNum = CHookGroupContext::FindOriginalEventOfGlobalModule(ValueOfEventName.GetString());
	CallOriginalEventOfGlobalModule(iMethodNum, (CValueListContext*)ValueArgList.GetContext());

}

#ifndef VK_FormEx_Hooks

typedef int(CBLModule::*PF_FF)(char const * ); //const;
CDllMethodWrapper<PF_FF> wrapperFindFunc;

typedef int(CBLModule::*PF_FP)(char const * ,int ); //const;
CDllMethodWrapper<PF_FP> wrapperFindProc;


typedef int(CBLModule::*PF_CAP)(int,int,class CValue * *);
CDllMethodWrapper<PF_CAP> wrapperCallAsProc;

typedef int(CBLModule::*PF_CAF)(int,class CValue &,int,class CValue * *);
CDllMethodWrapper<PF_CAF> wrapperCallAsFunc;

typedef int(CBLModule::*PF_GPI)(int,class CBLProcInfo &); //const;
CDllMethodWrapper<PF_GPI> wrapperGetProcInfo;

typedef void (CGetDoc7::*PF_ONCD)(void);
CDllMethodWrapper<PF_ONCD> wrapperOnCloseDocument;

#endif

typedef void (CBLProcInfo::*PF_CBLProcInfo)(void);
CDllMethodWrapper<PF_CBLProcInfo> wrapperCBLProcInfo_CBLProcInfo;

typedef int  (CBLProcInfo::*PF_GetNParams)(void); //const;
CDllMethodWrapper<PF_GetNParams> wrapperCBLProcInfo_GetNParams;

typedef int  (CBLProcInfo::*PF_GetType)(void); //const;
CDllMethodWrapper<PF_GetType> wrapperCBLProcInfo_GetType;

typedef	int  (CBLModule7::*CBLModule7_PF_ExecProc)(unsigned int,int,class CValue *,int,class CValue * *,int,int);	//592
CDllMethodWrapper<CBLModule7_PF_ExecProc> wrapperCBLModule7_ExecProc;

void CHookGroupContext::DisableToFormClose(CBLContext* pCont)
{
	CBLModule* pMod = GetModuleByContext((CGroupContext*)pCont);
	hookInstaller.m_MapNotClosedModules[pMod] = NULL;
	hookInstaller.m_MapDisableOnCloseEvent[pMod] = NULL;

//LogErr("DisableToFormClose pCont = %d pMod = %d", pCont, pMod);
}

void CHookGroupContext::EnableToFormClose(CBLContext* pCont)
{
	CBLModule* pMod = GetModuleByContext((CGroupContext*)pCont);
	hookInstaller.m_MapNotClosedModules.RemoveKey(pMod);

//LogErr("EnableToFormClose pCont = %d pMod = %d", pCont, pMod);
}

int  CHookGroupContext::CBLModule7_ExecProc(unsigned int iStringResourceId,int bFlagNotShowErrorIfNotFoundProcFunc,class CValue *value1,int iParamsCount, class CValue * *params,int i4, int i5)	//592
{
	CDllMethodWrapperGuard<CBLModule7_PF_ExecProc> wrapper(wrapperCBLModule7_ExecProc);

	CBLModule7* pThisMod = (CBLModule7*)this;
	
	char resStr[255];
	HINSTANCE h1CResource = AfxGetResourceHandle();
	::LoadString(h1CResource, iStringResourceId, resStr, 255);

//LogErr("CBLModule7_ExecProc %s<%s(%d)> %d %s<%d> %d %d", "iStringResourceId", resStr, iStringResourceId, bFlagNotShowErrorIfNotFoundProcFunc, "iParamsCount", iParamsCount, i4, i5);
/*
LogErr("CBLModule7_ExecProc (pMod = %d) pCont = %d ", pThisMod, CBLModuleWrapper::GetContextFromModule(pThisMod));
/*
LogErr("GetStatusCode %d", pThisMod->GetStatusCode());
	int iStatusCode = pThisMod->GetStatusCode();
	int iIsCompiled = pThisMod->IsCompiled();
LogErr("iIsCompiled %d", iIsCompiled);
* /
*/
/*CString str = ResString(1082);
LogErr("ResString(1082=43Ah) %s", str);

str = ResString(1111);
LogErr("ResString(1111=457h) %s", str);
*/

	//    "OnOpen,"   
	char* sEngName; char* sRusName;
	sRusName = strchr(resStr, ',');
	sRusName[0] = '\0'; 
	sRusName++;
	sEngName = resStr;

	//bFlagNotShowErrorIfNotFoundProcFunc = 0; // ,        ,  
	//bFlagNotShowErrorIfNotFoundProcFunc = 1;
	
	//   0,     
	int ret = 1;
	CComponentClass* pCont = NULL;
	
	int iNum = wrapperForGroupContext.FindWrapMethod(pThisMod, sRusName, sEngName, pCont);

	if (-1 != iNum)
	{
//LogErr(" ");
		bool bFuncFlag = !pCont->HasRetVal(iNum) ? false : true;
		wrapperForGroupContext.CallMethodOfContext(pCont, bFuncFlag, iNum, value1, params);

		//((CBLModule7*)this)->SetStatusCode(0);
		return 1;
	}
	else
	{
//LogErr("  CBLModule7::ExecProc");
		ret = (pThisMod->*wrapper.GetOrigMethod())(iStringResourceId, bFlagNotShowErrorIfNotFoundProcFunc,value1,iParamsCount, params,i4, i5);
//LogErr(" CBLModule7::ExecProc  %d", ret);
	}
/*
//LogErr("CBLModule7_ExecProc ============================   %s", sRusName);
LogErr("GetStatusCode %d", pThisMod->GetStatusCode());
	iStatusCode = pThisMod->GetStatusCode();
	
	iIsCompiled = pThisMod->IsCompiled();
LogErr("iIsCompiled %d", iIsCompiled);

	if (2629 == iStringResourceId) // 
	{
/ *		pThisMod->SetStatusCode(1);
		iStatusCode = pThisMod->GetStatusCode();
LogErr("GetStatusCode %d", pThisMod->GetStatusCode());* /
		//ret = 1; // TODO
	}
	else */

	if (2946 == iStringResourceId) // 
	{
		void *p;
		if (hookInstaller.m_MapNotClosedModules.Lookup(pThisMod, p))
			pThisMod->SetStatusCode(0);

/*  ---------------------------------------------------
	TODO   -  
		  http://cvs.alterplast.ru/bugs/show_bug.cgi?id=2622

		 ,    ,    1

		,  
		   
		 ;
		 ()
				("1cpp.dll");
		//     
				 = (""); 
		//     ,      
		  //  

		      
		1     :(

		 ,      
		 ()
				 = 0;
		  // 
		       :(

		      - . ,    

  --------------------------------------------------- */		

	}

	return ret;
}

#ifndef VK_FormEx_Hooks

int  CHookGroupContext::CBLModule_GetProcInfo(int nProc, class CBLProcInfo & cProcInfo) //const
{
	int ret = 0;
	CDllMethodWrapperGuard<PF_GPI> wrapper(wrapperGetProcInfo);
//LogErr("%s c  %d, %s = %d", "CBLModule_GetProcInfo", nProc, "pMod", (CBLModule*)this);

	ret = wrapperForGroupContext.GetProcInfo((CBLModule*)this, nProc, cProcInfo);
//LogErr("   %d", ret);
//LogErr("  cProcInfo.GetName() %s", cProcInfo.GetName());
	if (!ret)
		ret = ((CBLModule*)this)->GetProcInfo(nProc, cProcInfo);

	CString szName = cProcInfo.GetName();
//LogErr("  cProcInfo.GetName() %s", cProcInfo.GetName());

//LogErr("   %d", ret);
	return ret;
}

int  CHookGroupContext::CBLModule_FindFunc(char const * fName) //const
{
	int ret = -1;
	CDllMethodWrapperGuard<PF_FF> wrapper(wrapperFindFunc);

	CBLModule* pThisMod = (CBLModule*)this;
//LogErr("%s  %s", "WrapFindFunc", fName);

	int ret1 = wrapperForGroupContext.FindFunc(pThisMod, fName);
	if (-1 != ret1)
	{
		return ret1;
	}
	else
		//ret = (((CBLModule*)this)->*wrapper.GetOrigMethod())(fName);
		if (-1 == ret)
			ret = (pThisMod->*wrapper.GetOrigMethod())(fName);

	return ret;
}

int CHookGroupContext::FindOriginalEventOfGlobalModule(const CString& sEventName)
{
	CDllMethodWrapperGuard<PF_FP> wrapper(wrapperFindProc);
	CBLModule* pMod = ::GetGlobalModule();
	int ret = pMod->FindProc(sEventName, 1);
	if (-1 == ret)
		ret = pMod->FindProc(sEventName, 0);

	return ret;
}

int  CHookGroupContext::CBLModule_FindProc(char const * pName,int flag) //const
{
	int ret = -1;
	CBLModule* pThisMod = (CBLModule*)this;

	CDllMethodWrapperGuard<PF_FP> wrapper(wrapperFindProc);

// LogErr("%s  %s c  %d", "WrapFindProc", pName, flag);

	void* p;
	if (hookInstaller.m_MapDisableOnCloseEvent.Lookup(pThisMod, p))
	{
		if (!strcmp("", pName) || !strcmp("OnClose", pName))
		{
//LogErr("%s  %s c  %d -   <%d>", "WrapFindProc", pName, flag, -1);
			hookInstaller.m_MapDisableOnCloseEvent.RemoveKey(pThisMod);
			return -1;
		}
	}

	int ret1 = wrapperForGroupContext.FindProc(pThisMod, pName,flag);
	if (-1 != ret1)
	{
//LogErr("%s  %s c  %d -   %d", "WrapFindProc", pName, flag, ret1);
		return ret1;
	}
	else
		if (-1 == ret)
			ret = ((CBLModule*)this)->FindProc(pName,flag);

//LogErr("%s  %s c  %d -    <%d>", "WrapFindProc", pName, flag, ret);
	return ret;
}

int CHookGroupContext::CBLModule_CallAsFunc(int num,class CValue & retValue,int argNum,class CValue * * ppValue)
{
	int ret = 0;
	CDllMethodWrapperGuard<PF_CAF> wrapper(wrapperCallAsFunc);

//LogErr("%s c  %d, %s = %d", "WrapCallAsFunc", num, "pMod", (CBLModule*)this);

	int ret1 = wrapperForGroupContext.CallAsFunc((CBLModule*)this, num,retValue,argNum,ppValue);
	if (ret1)
	{
		return ret1;
	}
	else
		ret = ((CBLModule*)this)->CallAsFunc(num,retValue,argNum,ppValue);

	return ret;
}

int CHookGroupContext::CBLModule_CallAsProc(int num,int argNum,class CValue * * ppValue)
{
	int ret = 0;
	CDllMethodWrapperGuard<PF_CAP> wrapper(wrapperCallAsProc);

//LogErr("%s c  %d, %s = %d", "WrapCallAsProc", num, "pMod", (CBLModule*)this);

	int ret1 = wrapperForGroupContext.CallAsProc((CBLModule*)this, num,argNum,ppValue);
	if (ret1)
	{
		return ret1;
	}
	else
		ret = ((CBLModule*)this)->CallAsProc(num,argNum,ppValue);

	return ret;
}

//CGetDoc7::OnCloseDocument
void CHookGroupContext::CGetDoc7_OnCloseDocument(void)
{
	CGetDoc7* ThisDoc = (CGetDoc7*)this;
	
	{ //      
		CDllMethodWrapperGuard<PF_ONCD> wrapper(wrapperOnCloseDocument);

		wrapperForGroupContext.DestroyWrapper(ThisDoc->m_pBLModule);

		hookInstaller.m_MapNotClosedModules.RemoveKey(ThisDoc->m_pBLModule);

		(ThisDoc->*wrapper.GetOrigMethod())();
	}

	//_CallModuleProc(This,"","OnClosed",0,NULL);

/*	wrapperForGroupContext.DestroyWrapper(ThisDoc->m_pBLModule);

	hookInstaller.m_MapNotClosedModules.RemoveKey(ThisDoc->m_pBLModule);
*/
}

#endif // VK_FormEx_Hooks

//  3      FormEx,     
// TODO  FormEx      .
//   CBLProcInfo
//  (    !)   - GetType  GetNParams
//
// TODO ..      :(
//      :(
//
//
CBLProcInfo* CHookGroupContext::CBLProcInfo_CBLProcInfo(void)
{
	CBLProcInfo* ThisProcInfo = (CBLProcInfo*)this;
	CDllMethodWrapperGuard<PF_CBLProcInfo> wrapper(wrapperCBLProcInfo_CBLProcInfo);

	(ThisProcInfo->*wrapper.GetOrigMethod())();
	
	wrapperForGroupContext.CBLProcInfo_CBLProcInfo();
	return ThisProcInfo;
}

int  CHookGroupContext::CBLProcInfo_GetType(void)
{
	CBLProcInfo* ThisProcInfo = (CBLProcInfo*)this;
	CDllMethodWrapperGuard<PF_GetType> wrapper(wrapperCBLProcInfo_GetType);

	return 	wrapperForGroupContext.CBLProcInfo_GetType(ThisProcInfo);
}

// int  CHookGroupContext::CBLProcInfo_GetNParams(void)
// {
// 	CBLProcInfo* ThisProcInfo = (CBLProcInfo*)this;
// 	CDllMethodWrapperGuard<PF_GetNParams> wrapper(wrapperCBLProcInfo_GetNParams);
// 
// 	return 	wrapperForGroupContext.CBLProcInfo_GetNParams(ThisProcInfo);
// }

void CHookGroupContext::InitHooks(void)
{
// TODO   ,    1   
//	"   !   ?"

	hookInstaller.SetHook(); 
}

void CHookGroupContext::SetHook(void)
{
	HINSTANCE hBl=GetModuleHandle("blang.dll");
	HINSTANCE hSev=GetModuleHandle("seven.dll");
	HINSTANCE hBas=GetModuleHandle("basic.dll");

#ifndef VK_FormEx_Hooks
	wrapperCallAsFunc.DoWrap(hBl, "?CallAsFunc@CBLModule@@QAEHHAAVCValue@@HPAPAV2@@Z", (PF_CAF)CBLModule_CallAsFunc);

	wrapperCallAsProc.DoWrap(hBl, "?CallAsProc@CBLModule@@QAEHHHPAPAVCValue@@@Z", (PF_CAP)CBLModule_CallAsProc);

	wrapperFindProc.DoWrap(hBl, "?FindProc@CBLModule@@QBEHPBDH@Z", (PF_FP)CBLModule_FindProc);

	wrapperFindFunc.DoWrap(hBl,"?FindFunc@CBLModule@@QBEHPBD@Z", (PF_FF)CBLModule_FindFunc);

	wrapperGetProcInfo.DoWrap(hBl, "?GetProcInfo@CBLModule@@QBEHHAAVCBLProcInfo@@@Z", (PF_GPI)CBLModule_GetProcInfo);

	wrapperOnCloseDocument.DoWrap(hBas, "?OnCloseDocument@CGetDoc7@@UAEXXZ", (PF_ONCD)CGetDoc7_OnCloseDocument);

#endif // VK_FormEx_Hooks

	wrapperCBLProcInfo_CBLProcInfo.DoWrap(hBl, "??0CBLProcInfo@@QAE@XZ", (PF_CBLProcInfo)CBLProcInfo_CBLProcInfo);

	//wrapperCBLProcInfo_GetNParams.DoWrap(hBl, "?GetNParams@CBLProcInfo@@QBEHXZ", (PF_GetNParams)CBLProcInfo_GetNParams);

	wrapperCBLProcInfo_GetType.DoWrap(hBl, "?GetType@CBLProcInfo@@QBEHXZ", (PF_GetType)CBLProcInfo_GetType);

	wrapperCBLModule7_ExecProc.DoWrap(hSev, "?ExecProc@CBLModule7@@QAEHIHPAVCValue@@HPAPAV2@HH@Z", (CBLModule7_PF_ExecProc)CBLModule7_ExecProc);

}

void CHookGroupContext::DestroyHooks(void)
{
	hookInstaller.DestroyHook(); 
}

void CHookGroupContext::DestroyHook(void)
{
	wrapperForGroupContext.DestroyWrapper(::GetGlobalModule());
	wrapperForGroupContext.~CGroupContextWrap();

/*	HINSTANCE hBl=GetModuleHandle("blang.dll");
	HINSTANCE hSev=GetModuleHandle("seven.dll");
	HINSTANCE hBas=GetModuleHandle("basic.dll");
*/
#ifndef VK_FormEx_Hooks
	wrapperCallAsFunc.RestoreOrigAddress();

	wrapperCallAsProc.RestoreOrigAddress();

	wrapperFindProc.RestoreOrigAddress();

	wrapperFindFunc.RestoreOrigAddress();

	wrapperGetProcInfo.RestoreOrigAddress();

	wrapperOnCloseDocument.RestoreOrigAddress();
#endif // VK_FormEx_Hooks

	wrapperCBLModule7_ExecProc.RestoreOrigAddress();
}