#if !defined(GROUPCONTEXTWRAP_H_INCLUDED)
#define GROUPCONTEXTWRAP_H_INCLUDED

#pragma once

#include "..\MethodsWrapper.h"

class CGroupContextWrap
{

	class GCWModuleData
	{
	public:
// 		const CSafeContextPtr pHookCont;
// 		const CSafeContextPtr<CBLContext> pHookCont;
		const CSafeContextPtr<CComponentClass> pHookCont;
		CMap<int,int,int,int> cMethodsNumMap;

// 		GCWModuleData(const CBLContext* pHookContA) : pHookCont(pHookContA)
		GCWModuleData(const CComponentClass* pHookContA) : pHookCont(pHookContA)
		{
		}
	};

private:
	//CMapPtrToPtr cModuleMap;
	CMap<const CBLModule*, const CBLModule*, const GCWModuleData*, const GCWModuleData*> cModuleMap;
	bool bHaveSetHooks;

	//bool Lookup(const CBLModule* pMod, GCWModuleData*& pModData, const CBLContext** ppCont = NULL) const;
/*	bool _Lookup(const CBLModule* pMod, GCWModuleData*& pModData, const CBLContext** ppCont) const;
	bool Lookup(const CBLModule* pMod, GCWModuleData*& pModData) const;
	bool Lookup(const CBLModule* pMod, GCWModuleData*& pModData, const CBLContext*& pCont) const;
*/
	bool _Lookup(const CBLModule* pMod, GCWModuleData*& pModData, const CComponentClass** ppCont) const;
	bool Lookup(const CBLModule* pMod, GCWModuleData*& pModData) const;
	bool Lookup(const CBLModule* pMod, GCWModuleData*& pModData, const CComponentClass*& pCont) const;
	bool LookupMethod(const CBLModule* pMod, GCWModuleData*& pModData, const CComponentClass*& pCont, int iMethNumOfModule, int& iNumMethOfContext) const;

	//void ValidateParamGroupContext(const CValue& GroupContValue) const;
	void ValidateParamUserClass(const CValue& UserClassContValue) const;
	void ValidateParamUserClass(const CComponentClass* pUserClassCont, bool bIsHookOfGlobalModule = false) const;
	void ValidateParam(const CGroupContext* pGroupCont, const CComponentClass* pUserClassCont) const;
	void ValidateParam(const CValue& GroupContValue, const CValue& UserClassContValue) const;

	void SetWrapperForModule(const CBLModule* pMod, const CComponentClass* pUserClassCont, bool bIsHookOfGlobalModule);

	const CComponentClass* GetWrapper(const CBLModule* pMod) const;

	int  FindMethodOfContext(const CComponentClass* pCont, char const * sName)const;
	int  FindMethod(const CBLModule* pMod, bool bFuncFlag, char const * pName, int flag = 0)const;

	int  CallMethod(const CBLModule* pMod, bool bFuncFlag, int num,class CValue * pRetValue,int argNum,class CValue * * ppValue) const;

public:
	CGroupContextWrap() : bHaveSetHooks(false)
	{};

	virtual ~CGroupContextWrap()
	{
		cModuleMap.RemoveAll();
	};

	bool IsWrapEnable(void)const
	{ return bHaveSetHooks ;}

	void SetWrapper(const CGroupContext* pGroupCont, const CComponentClass* pUserClassCont);
	void SetWrapper(const CValue& GroupContValue, const CValue& UserClassContValue);

	void SetWrapperForGlobalModule(const CValue& UserClassContValue);
	void SetWrapperForGlobalModule(const CComponentClass* pUserClassCont);

	const CComponentClass* GetWrapper(const CGroupContext* pGroupCont) const;
	const CComponentClass* GetWrapper(const CValue& GroupContValue) const;
	const CComponentClass* GetWrapperForGlobalModule() const;

	void DestroyWrapper(const CBLModule* pMod);
	void DestroyWrapper(const CValue& GroupContValue);

	//int  FindMethodOfContext(const CBLModule* pMod, char const * sRusName, char const * sEngName, const CBLContext*& pCont)const;
	int  FindWrapMethod(const CBLModule* pMod, char const * sRusName, char const * sEngName, const CComponentClass*& pCont)const;

	inline int  FindFunc(const CBLModule* pMod, char const * fName)const
	{
		return FindMethod(pMod, true, fName);
	}
	inline int  FindProc(const CBLModule* pMod, char const * pName,int flag)const
	{
		return FindMethod(pMod, false, pName, flag);
	}

	inline int  CallMethodOfContext(const CBLContext* pCont, bool bFuncFlag, int num,class CValue * pRetValue, class CValue * * ppValue) const
	{
		if (bFuncFlag)
			return const_cast<CBLContext*>(pCont)->CallAsFunc(num, *pRetValue, ppValue);
		else
			return const_cast<CBLContext*>(pCont)->CallAsProc(num, ppValue);
	}

	inline int  CallAsFunc(const CBLModule* pMod, int num,class CValue & retValue,int argNum,class CValue * * ppValue) const
	{	
		return CallMethod(pMod, true, num, &retValue, argNum, ppValue);
	};

	inline int  CallAsProc(const CBLModule* pMod, int num,int argNum,class CValue * * ppValue) const
	{
		return CallMethod(pMod, false, num, NULL, argNum, ppValue);
	}

	int  GetProcInfo(const CBLModule* pMod, int nProc, class CBLProcInfo & cProcInfo); //const;

	void CallOriginalEventOfGlobalModule(const CValue& ValueOfEventName, const CValue& ValueArgList) const;

	void CallOriginalEventOfGlobalModule(int iMethodNum, CValueListContext* pValueListCont) const;

	void CallOriginalEventOfGroupContext(const CValue& ValueGroupContext, const CValue& ValueOfEventName, const CValue& ValueArgList) const;
	void CallOriginalEventOfGroupContext(CGroupContext* pCont, const CString& strEventName, CValueListContext* pValueListCont) const;

	void CBLProcInfo_CBLProcInfo(void);
	int  CBLProcInfo_GetType(CBLProcInfo* pProcInfo); //const;
	//int  CBLProcInfo_GetNParams(CBLProcInfo* pProcInfo); //const;
	CBLProcInfo* m_pCBLProcInfo; //    

};

extern CGroupContextWrap wrapperForGroupContext;

class CHookGroupContext
{
private:

public:
	static void InitHooks(void);
	static void DestroyHooks(void);

	void SetHook(void);
	void DestroyHook(void);

	static void DisableToFormClose(CBLContext* pCont);
	static void EnableToFormClose(CBLContext* pCont);

	static int FindOriginalEventOfGlobalModule(const CString& sEventName);

private:
#ifndef VK_FormEx_Hooks
	int  CBLModule_FindFunc(char const * fName); //const;
	int  CBLModule_FindProc(char const * pName,int flag); //const;
	int  CBLModule_CallAsFunc(int num,class CValue & retValue,int argNum,class CValue * * ppValue);
	int  CBLModule_CallAsProc(int num,int argNum,class CValue * * ppValue);
	int  CBLModule_GetProcInfo(int nProc, class CBLProcInfo & cProcInfo); //const;

	void  CGetDoc7_OnCloseDocument(void);
#endif

	CBLProcInfo* CBLProcInfo_CBLProcInfo(void);
	int  CBLProcInfo_GetType(void); //const;
	//int  CBLProcInfo_GetNParams(void); //const;

	int  CBLModule7_ExecProc(unsigned int i1,int i2,class CValue *value1,int i3, class CValue * *params,int i4, int i5);	//592
	int  CBLProcInfo_GetType(void)const;	//98
	int  CBLProcInfo_GetNParams(void)const;	//65

	//  ,    (,   )
	CMapPtrToPtr m_MapNotClosedModules;

	//  ,        (,   )
	CMapPtrToPtr m_MapDisableOnCloseEvent;

};

#endif // !defined(GROUPCONTEXTWRAP_H_INCLUDED)