// Hooker.cpp: implementation of the CHooker class.
// develop by artbear
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "Hooker.h"

#include "GroupContextWrap.h"


//_____________________________________________________________________________
//
// CHooker Maps
//_____________________________________________________________________________
//
BEGIN_BL_METH_MAP(CHooker) 
    BL_METH_PROC("HookEventsOfGroupContext", "", 2, procHookEventsOfGroupContext)
	BL_METH_PROC("CallOriginalEventOfGroupContext", "", 3, procCallOriginalEventOfGroupContext)
    BL_METH_FUNC("GetHookObjectForEventsOfGroupContext", "", 1, funcGetHookObjectForEventsOfGroupContext)
	BL_METH_PROC("UnHookEventsOfGroupContext", "K", 1, procUnHookEventsOfGroupContext)

    BL_METH_PROC("HookEventsOfGlobalModule", "", 1, procHookEventsOfGlobalModule)
	BL_METH_PROC("CallOriginalEventOfGlobalModule", "", 2, procCallOriginalEventOfGlobalModule)
    BL_METH_FUNC("GetHookObjectForEventsOfGlobalModule", "", 0, funcGetHookObjectForEventsOfGlobalModule)
	BL_METH_PROC("UnHookEventsOfGlobalModule", "", 0, procUnHookOriginalEventOfGlobalModule)

    //BL_METH_PROC("HookAllMethodsOfContext",		"", 2, procHookAllMethodsOfContext)
    //BL_METH_PROC("HookMethodOfContext",		"", 4, procHookMethodOfContext)


END_BL_METH_MAP() 

BEGIN_BL_PROP_MAP(CHooker)
END_BL_PROP_MAP()

IMPLEMENT_MY_CREATE_CONTEXT(CHooker, "Hooker", "");

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BOOL CHooker::procHookEventsOfGroupContext(CValue **ppValue)
{
	wrapperForGroupContext.SetWrapper(*ppValue[0], *ppValue[1]);

	return TRUE;
}

BOOL CHooker::procHookEventsOfGlobalModule(CValue **ppValue)
{
	wrapperForGroupContext.SetWrapperForGlobalModule(*ppValue[0]);

	return TRUE;
}

BOOL CHooker::funcGetHookObjectForEventsOfGroupContext(CValue &RetVal, CValue **ppValue)
{
	const CComponentClass* pCont = wrapperForGroupContext.GetWrapper(*ppValue[0]);
	RetVal.AssignContext((CBLContext*)pCont);
	
	return TRUE;
}

BOOL CHooker::funcGetHookObjectForEventsOfGlobalModule(CValue &RetVal, CValue **ppValue)
{
	const CComponentClass* pCont = wrapperForGroupContext.GetWrapperForGlobalModule();
	RetVal.AssignContext((CBLContext*)pCont);
	
	return TRUE;
}

BOOL CHooker::procCallOriginalEventOfGlobalModule(CValue **ppValue)
{
	wrapperForGroupContext.CallOriginalEventOfGlobalModule(*ppValue[0], *ppValue[1]);

	return TRUE;
}

BOOL CHooker::procCallOriginalEventOfGroupContext(CValue **ppValue)
{
	wrapperForGroupContext.CallOriginalEventOfGroupContext(*ppValue[0], *ppValue[1], *ppValue[2]);

	return TRUE;
}

BOOL CHooker::procUnHookEventsOfGroupContext(CValue **ppValue)
{
	wrapperForGroupContext.DestroyWrapper(*ppValue[0]);

	return TRUE;
}

BOOL CHooker::procUnHookOriginalEventOfGlobalModule(CValue **ppValue)
{
	wrapperForGroupContext.DestroyWrapper(::GetGlobalModule());

	return TRUE;
}
