/*
 * Copyright (C) Sergey P. Derevyago, 2003-2004.
 *
 * Permission to copy, use, modify, sell and distribute this software is granted
 * provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied warranty, and
 * with no claim as to its suitability for any purpose.
 *
 */

/** @file
 *   fixed_alloc.
 */

#ifndef __FIX_ALLOC_HPP__
 #define __FIX_ALLOC_HPP__

#include <stddef.h>

/**     fixed_alloc,    */
namespace fixed_alloc_private {

 /**
  *      () CHUNK_SIZE    
  *      type_sz.   
  *   head.      
  * : type_sz>=sizeof(void*).     
  * std::bad_alloc.  CHUNK_SIZE   -.
  */
 void get_mem(void*& head, size_t type_sz);

 /**
  *     fixed_alloc.    
  *     SIZE,      T
  *  (   sizeof(void*))   
  *       .
  */
 template <size_t SIZE>
 class void_alloc {
       /**       SIZE */
       static void* head;

  public:
       /**    SIZE */
       static void* alloc()
       {
        if (!head) get_mem(head, SIZE);

        void* ret=head;
        head=*(void**)head;

        return ret;
       }

       /**     */
       static void free(void* ptr)
       {
        *(void**)ptr=head;
        head=ptr;
       }
 };

 /**    void_alloc::head */
 template <size_t SIZE>
 void* void_alloc<SIZE>::head;

}

/**
 *  fixed_alloc<T>     
 *     T.     () CHUNK_SIZE 
 *      SIZE.      
 *  ,     /
 *  T.  CHUNK_SIZE   -.
 */
template <class T>
class fixed_alloc {
 public:
      /**
       *    T .  sizeof(T)  sizeof(void*)
       *    .
       */
      enum { SIZE=(sizeof(T)+sizeof(void*)-1)/sizeof(void*)*sizeof(void*) };

      /**
       *   ( SIZE)   T.    
       *  std::bad_alloc.
       */
      static T* alloc()
      {
       return (T*)fixed_alloc_private::void_alloc<SIZE>::alloc();
      }

      /**
       *    .  ,   
       * ,      .
       *
       *  free(0)   ( 
       *  0).         ..
       *    free()  X::operator delete(),  
       * delete (X*)0     free(0) --   .
       *        X::operator
       * delete(0),       ,  
       *   0      ( 
       * ,   0    
       *   X::operator delete(ptr)     X::operator
       * delete()).
       */
      static void free(void* ptr)
      {
       fixed_alloc_private::void_alloc<SIZE>::free(ptr);
      }
};

/**
 *  sized_alloc      .
 *     fixed_alloc   ,   
 *       alloc()  free(),     
 * fixed_alloc     , , 
 *  (  fixed_alloc   ). 
 * sized_alloc       
 *  (   ),  
 *  .   ,     ,
 *  , ,       
 *       size_t,   
 *   alloc()  free().
 */
class sized_alloc {
  public:
      /**
       *       std::bad_alloc.
       *       fixed_alloc, 
       *  ,    size>MAX_SIZE    
       *  operator new().  MAX_SIZE  
       * -.
       */
      static void* alloc(size_t size);

      /**
       *    .   
       *    fixed_alloc,   ,  
       *  size>MAX_SIZE    (
       *  operator delete(ptr)).  MAX_SIZE  
       * -.
       */
      static void free(void* ptr, size_t size);
};

#endif
