// AddIn.cpp

#include "stdafx.h"
#include "AddIn.h"
#include "ExecuteModule.h"
#include "WorkAsRegister.h"
#include "TemplateClass.h"
#include "EventManager.h"
#include "ComponentClass.h"
#include "HashMap.h"
#include "Delegate.h"
#include "Struct.h"
#include "DynaValue.h"
#include "DynaValueList.h"
#include "MySQL_Query.h"
#include "CreateMetaInfoClasses.h"

//{OAS
#include ".\\TurboBL\\gcboost.h"
//#include "loader.h"
//OAS}


#include "Service.h"
#include "FormEx.h"
#include "AttribEx.h"
#include "PaintHook.h"
#include "MDIClientWnd.h"

#include ".\\SQL\\MetaDataWork.h"
#include ".\\ODBC\\1CPP_ODBCDatabase.h"
#include ".\\ODBC\\1CPP_ODBCRecordSet.h"

  // This global interface is for timer implementation only

class CDataBase7 * pDataBase7;
class CMetaDataCont * pMetaDataCont;
class CBkEndUI * pBkEndUI;
class CAddIn * pMainAddIn;

// FORMEX:BEGIN
HHOOK MouseHookHandle = 0;
HHOOK HookHandle = 0;
HHOOK WndHookHandle = 0;
HHOOK WndPreHookHandle = 0;

BOOL m_bEnabledColor = FALSE;
BOOL m_bLocalColor = FALSE;
BOOL m_bShowKL = FALSE;
UINT StatusTimer = 0;
CWnd* pWndSpl = NULL;

AFX_PMSG pWrappedFN = NULL;
DWORD myPlatformId;
CMDIClientWnd * wndMDIClient = NULL;
bool CreateInPlace = false;
// FORMEX:END

//DMS:BEGIN
char buf[4096];
char **pst = 0;
//DMS:END

/////////////////////////////////////////////////////////////////////////////
// CAddIn

BOOL CAddIn::LoadProperties()
{  
    HRESULT hRes;
    CString csProperty; 
    VARIANT varEnabled;
      // Load flag switching component activity on or off
    csProperty = "EnabledCheckType:0";

    VariantInit(&varEnabled);
    V_VT(&varEnabled) = VT_I4;
    hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
    if (hRes == S_OK)
    {
      if (V_I4(&varEnabled) == 2)
        m_EnabledCheckType = TRUE;
      else if (V_I4(&varEnabled) == 1)
        m_EnabledCheckType = FALSE;
    }
    
    csProperty = "EnableOptimizate:0";

    VariantInit(&varEnabled);
    V_VT(&varEnabled) = VT_I4;    
    hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
    if (hRes == S_OK) 
    {
      if (V_I4(&varEnabled) == 2)
        m_EnableOptimizate = TRUE;
      else if (V_I4(&varEnabled) == 1)
        m_EnableOptimizate = FALSE;

    }
    
    csProperty = "EnableDebugging:0";

    VariantInit(&varEnabled);
    V_VT(&varEnabled) = VT_I4;    
    hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
    if (hRes == S_OK) 
    {
      if (V_I4(&varEnabled) == 2)
        m_EnableDebugging = TRUE;
      else if (V_I4(&varEnabled) == 1)
        m_EnableDebugging = FALSE;

    }
    
    
    csProperty = "EnabledColor:0";
	  hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
	  if (hRes != S_OK) return FALSE;
	  m_bEnabledColor = V_I4(&varEnabled)?TRUE:FALSE;

	  csProperty = "LocalColor:0";
	  hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
	  if (hRes != S_OK) return FALSE;
	  m_bLocalColor = V_I4(&varEnabled)?TRUE:FALSE;

	  csProperty = "ShowKeyboardLayout:0";
	  hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
	  if (hRes != S_OK) return FALSE;
	  m_bShowKL = V_I4(&varEnabled)?TRUE:FALSE;

    /*csProperty = "FileNameOfDefineClasses:0";
    VariantInit(&varEnabled);
    V_VT(&varEnabled) = VT_BSTR;
    hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
    
    if (hRes == S_OK) 
    {    
      BSTR pBSTR = (BSTR)(&varEnabled);
      m_StrFileNameOfDefClass.Empty();
      m_StrFileNameOfDefClass.SetSysString(&pBSTR);    
    }       */
    return TRUE;
}   
  
void CAddIn::SaveProperties()
{
    CString csProperty; 
    VARIANT varEnabled;

      // Save flag switching component activity on or off
    csProperty = "EnabledCheckType";

    VariantInit(&varEnabled);
    V_VT(&varEnabled) = VT_I4;
    V_I4(&varEnabled) = m_EnabledCheckType?2:1;
    m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);

    csProperty = "EnableOptimizate";
    V_I4(&varEnabled) = m_EnableOptimizate?2:1;
    m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);
    
    csProperty = "EnableDebugging";
    V_I4(&varEnabled) = m_EnableDebugging?2:1;
    m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);

    csProperty = "EnabledColor";
	  V_I4(&varEnabled) = m_bEnabledColor?1:0;
	  m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);

	  csProperty = "LocalColor";
	  V_I4(&varEnabled) = m_bLocalColor?1:0;
	  m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);

	  csProperty = "ShowKeyboardLayout";
	  V_I4(&varEnabled) = m_bShowKL?1:0;
	  m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);

    /*csProperty = "FileNameOfDefineClasses";
    VariantInit(&varEnabled);
    V_VT(&varEnabled) = VT_BSTR;
    V_BSTR(&varEnabled) = m_StrFileNameOfDefClass.AllocSysString();
    m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);*/
}

  /* 
     These two methods is convenient way to access function 
     parameters from SAFEARRAY vector of variants
  */

/////////////////////////////////////////////////////////////////////////////
// IInitDone

STDMETHODIMP CAddIn::Init(IDispatch *pConnection)
{
	{
	
	if(pBkEndUI = GetBkEndUI())
	{
#ifdef _DEBUG
		pBkEndUI->DoMessageLine("1C++ service successfuly initialized",mmInformation);
#endif
	}
    pConnection->QueryInterface(IID_IErrorLog,(void **)&m_iErrorLog);

    
    pConnection->QueryInterface(IID_IAsyncEvent,(void **)&m_iAsyncEvent);
    
    
    pConnection->QueryInterface(IID_IStatusLine,(void **)&m_iStatusLine);

    CString csProfileName = "1C++ Components & Class";
    
    pConnection->QueryInterface(IID_IPropertyProfile,(void **)&m_iProfile);

    
	  pConnection->QueryInterface(IID_IExtWndsSupport,(void **)&m_iExtWndsSupport);
	  
	
	if (m_iProfile) 
      {
        m_iProfile->RegisterProfileAs(csProfileName.AllocSysString());
        if (LoadProperties() == FALSE) return E_FAIL;
      }

	}
	
	pDataBase7			= CDataBase7::GetDefault();
	pMetaDataCont		= pDataBase7->GetMD();
  

	CBLContext::RegisterContextClass(RUNTIME_CLASS(CExecuteModule) ,"ExecuteModule",CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CExecuteModule) ,"",CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CWorkAsRegister), "WorkAsRegisterWin", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CWorkAsRegister), "Win", CType(100));
  CBLContext::RegisterContextClass(RUNTIME_CLASS(CComponentClass), "CComponentClass", CType(100));
  CBLContext::RegisterContextClass(RUNTIME_CLASS(CEventManager), "EventManager", CType(100));
  CBLContext::RegisterContextClass(RUNTIME_CLASS(CEventManager), "", CType(100));
  CBLContext::RegisterContextClass(RUNTIME_CLASS(CDelegate), "Delegate", CType(100));  
  CBLContext::RegisterContextClass(RUNTIME_CLASS(CDelegate), "", CType(100));  
  CBLContext::RegisterContextClass(RUNTIME_CLASS(CHashMap), "HashMap", CType(100));  
  CBLContext::RegisterContextClass(RUNTIME_CLASS(CStruct), "Struct", CType(100));    
  CBLContext::RegisterContextClass(RUNTIME_CLASS(CStruct), "", CType(100));    
  CBLContext::RegisterContextClass(RUNTIME_CLASS(CDynaValueList), "DynaValueList", CType(100));    
  CBLContext::RegisterContextClass(RUNTIME_CLASS(CDynaValue), "DynaValue", CType(100));
  CBLContext::RegisterContextClass(RUNTIME_CLASS(CDynaCrypt), "DynaCrypt", CType(100));
  CBLContext::RegisterContextClass(RUNTIME_CLASS(CMySQL_Query), "SQL_Query", CType(100));
  CBLContext::RegisterContextClass(RUNTIME_CLASS(CCreateMetaInfoClasses), "MetaInfoClasses", CType(100));

  CBLContext::RegisterContextClass(RUNTIME_CLASS(CService) ,"ServiceFormEx", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CService) ,"", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CFormEx) ,"FormEx", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CFormEx) ,"", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CAttribEx) ,"AttribEx", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CAttribEx) ,"", CType(100));
  

	CBLContext::RegisterContextClass(RUNTIME_CLASS(CMetaDataWork) ,"MetaDataWork",CType(100));
  CBLContext::RegisterContextClass(RUNTIME_CLASS(C1CPP_ODBCRecordSet) ,"ODBCRecordSet",CType(100));
  CBLContext::RegisterContextClass(RUNTIME_CLASS(C1CPP_ODBCDatabase) ,"ODBCDatabase",CType(100));
  
  //CBLContext::RegisterContextClass(RUNTIME_CLASS(CLoader) ,"Loader",CType(100));
  //CBLContext::RegisterContextClass(RUNTIME_CLASS(CLoader) ,"",CType(100));
  //CAttachedContext::Init();

  InitAllBoost();
  //OAS}

  hLibBasic = GetModuleHandle("Basic.dll");
  if (hLibBasic == NULL)  
    pBkEndUI->DoMessageLine("     Basic.dll",mmInformation);  
 
	//   
	OSVERSIONINFO osvi;
	ZeroMemory(&osvi, sizeof(OSVERSIONINFO));
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx((OSVERSIONINFO*)&osvi);
	myPlatformId = osvi.dwPlatformId;

  CSetOfHierarchy *pHierarchy = CSetOfHierarchy::GetHierarchy();
  
  pHierarchy->Init();
  pHierarchy->ProcessDefines();
  
  pHierarchy->RegistersContextClasses();
  
  pMainAddIn = this;
  
  CComponentClass::ExeptionValue = new CValue;
  

  #ifndef _DEBUG
	  MouseHookHandle = SetWindowsHookEx(WH_MOUSE, Mouse_Hook, AfxGetApp()->m_hInstance, AfxGetApp()->m_nThreadID);
	  HookHandle = SetWindowsHookEx(WH_KEYBOARD, Key_Hook, AfxGetApp()->m_hInstance, AfxGetApp()->m_nThreadID);
	  WndHookHandle = SetWindowsHookEx(WH_CALLWNDPROCRET, Wnd_Hook, AfxGetApp()->m_hInstance, AfxGetApp()->m_nThreadID);
  	WndPreHookHandle = SetWindowsHookEx(WH_CALLWNDPROC, WndPre_Hook, AfxGetApp()->m_hInstance, AfxGetApp()->m_nThreadID);	

	if(m_bEnabledColor)
	{
		CBrowse::SetWrap();
	}
	if(m_bShowKL)
	{
		SECStatusBar* pStatus = (SECStatusBar*)AfxGetApp()->m_pMainWnd->GetDescendantWindow(AFX_IDW_STATUS_BAR);
		if(pStatus)
		{
			int count = pStatus->GetCount();
			UINT* nIDs;
			UINT* nStyles;
			int* cxWidths;
			nIDs = (UINT*)malloc(count*sizeof(UINT));
			nStyles = (UINT*)malloc(count*sizeof(UINT));
			cxWidths = (int*)malloc(count*sizeof(int));
			for(int i = 0; i<count; i++)
				pStatus->GetPaneInfo(i,nIDs[i],nStyles[i],cxWidths[i]);
			pStatus->AllocElements(count+2,100);
			pStatus->SetPaneInfo(count+1,NULL,SBPS_NORMAL, 43);
			pStatus->SetPaneInfo(count,NULL,SBPS_NORMAL, 20);
			char KLName[KL_NAMELENGTH]; 
			if(GetLocaleInfo((LCID)((WORD)GetKeyboardLayout(AfxGetApp()->m_nThreadID)),LOCALE_SABBREVLANGNAME,KLName,KL_NAMELENGTH))
				pStatus->SetPaneText(count,KLName,KL_NAMELENGTH);
			StatusTimer = pStatus->SetTimer(500,100,(TIMERPROC)TimerProc);
			for(i = 0; i<count; i++)
				pStatus->SetPaneInfo(i,nIDs[i],nStyles[i],cxWidths[i]);
			free(nIDs);
			free(nStyles);
			free(cxWidths);
		}
	}
  #endif //_DEBUG

	CMDIFrameWnd * pMainFrame = GetMainFrame();
	if(pMainFrame)
	{
		wndMDIClient = new CMDIClientWnd;
		if(!wndMDIClient->SubclassWindow(pMainFrame->m_hWndMDIClient))
		{
			pBkEndUI->DoMessageLine("Failed to subclass MDI client window", mmRedErr);
			delete wndMDIClient;
			wndMDIClient = NULL;
		}
		else
		{
			CGalleryHolder * pGalleryHolder = CGalleryHolder::GetGallery();
			if(pGalleryHolder)
			{
				ULONG picID = pGalleryHolder->FindByAlias("Wallpaper");
				if(picID)
				{
					CPictureHolder7 * pic;
					pic = new CPictureHolder7(pGalleryHolder->GetPicture(picID));

					CDC dcMem;
					CDC* pDC = CWnd::GetDesktopWindow()->GetDC();

					if (dcMem.CreateCompatibleDC(pDC))
					{
						CSize hmSize = pic->GetSize();

						CBitmap bmMem;

						if (bmMem.CreateCompatibleBitmap(pDC, hmSize.cx, hmSize.cy))
						{
							CBitmap* pOldBM = dcMem.SelectObject(&bmMem);

							dcMem.FillSolidRect(0, 0, hmSize.cx, hmSize.cy, RGB(0x100,0x100,0x100));
							RECT rect1;
							RECT rect2;
							rect1.top = rect1.left = 0;
							rect1.right = hmSize.cx;
							rect1.bottom = hmSize.cy;
							
							pic->Render(dcMem, rect1, 0, &rect2);

							wndMDIClient->m_Bitmap.Attach(bmMem.Detach());

							dcMem.SelectObject(pOldBM);
						}
					}
					CWnd::GetDesktopWindow()->ReleaseDC(pDC);
					delete pic;
					wndMDIClient->CreateGrayBitmap();
				}
			}

			wndMDIClient->RedrawWindow();
		}

	}

	CWrapModule WrapModule;

	return S_OK;
}

STDMETHODIMP CAddIn::Done()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
//    if (m_uiTimer != 0) ::KillTimer(NULL,m_uiTimer);
  SaveProperties();

  if (m_iStatusLine) m_iStatusLine->Release();
  if (m_iProfile) m_iProfile->Release();
  if (m_iAsyncEvent) m_iAsyncEvent->Release();
  if (m_iErrorLog) m_iErrorLog->Release();
  if (m_iExtWndsSupport) m_iExtWndsSupport->Release();

	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CExecuteModule));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CExecuteModule));	
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CWorkAsRegister));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CWorkAsRegister));	
  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CComponentClass));
  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CEventManager));
  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CEventManager));
  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CDelegate));
  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CDelegate));  
  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CStruct));    
  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CStruct));    
  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CDynaValueList));    
  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CDynaValue));    
  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CDynaCrypt));      
  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CMySQL_Query));
  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CCreateMetaInfoClasses));  
  
  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CAttribEx));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CAttribEx));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CFormEx));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CFormEx));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CService));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CService));

	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CMetaDataWork));

  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(C1CPP_ODBCRecordSet));
  CBLContext::UnRegisterContextClass(RUNTIME_CLASS(C1CPP_ODBCDatabase));

  if (hLibBasic != NULL)  
    FreeLibrary(hLibBasic);
  
  CSetOfHierarchy::DeInitHierarchy();

  pMainAddIn = NULL;

	if(MouseHookHandle != 0) UnhookWindowsHookEx(MouseHookHandle);
  if(HookHandle != 0) UnhookWindowsHookEx(HookHandle);
	if(WndHookHandle != 0) UnhookWindowsHookEx(WndHookHandle);
	if(WndPreHookHandle != 0) UnhookWindowsHookEx(WndPreHookHandle);
  
	if(wndMDIClient != NULL)
	{
		CMDIFrameWnd * pMainFrame = GetMainFrame();
		if(pMainFrame)
		{
			wndMDIClient->RedrawWindow();
			if(!wndMDIClient->UnsubclassWindow())
				pBkEndUI->DoMessageLine("Failed to unsubclass MDI client window", mmRedErr);
			delete wndMDIClient;
		}
	}

	return S_OK;
}

STDMETHODIMP CAddIn::GetInfo(SAFEARRAY **pInfo)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

      // Component should put supported component technology version 
      // in VARIANT at index 0     
    long lInd = 0;
    VARIANT varVersion;
    V_VT(&varVersion) = VT_I4;
      // This component supports 1.0 version
    V_I4(&varVersion) = 2000;
    SafeArrayPutElement(*pInfo,&lInd,&varVersion);
    
	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////
// ILanguageExtender

STDMETHODIMP CAddIn::RegisterExtensionAs(BSTR *bstrExtensionName)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// You may delete next lines and add your own implementation code here

      // Name of extension should be changed avoiding conflicts 
    CString csExtenderName = "1C++";
    *bstrExtensionName = csExtenderName.AllocSysString();

	return NULL;
}





/////////////////////////////////////////////////////////////////////////////
// IPropertyPage

/*STDMETHODIMP CAddIn::SetPageSite(IPropertyPageSite *pPageSite)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
  m_pPageSite = pPageSite;
	// TODO: Add your implementation code here

	return S_OK;
}*/

/*STDMETHODIMP CAddIn::Activate(HWND hWndParent,LPCRECT prc,BOOL bModal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

    return IPropertyPageImpl<CAddIn>::Activate(hWndParent,prc,bModal);
}*/

STDMETHODIMP CAddIn::Deactivate()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
    
  IPropertyPageImpl<CAddIn>::Deactivate();
  
    // Don't forget to detach controls!
  m_boxEnabledCheckType.Detach();
  m_boxOptimizate.Detach();
  m_boxEnableDebugging.Detach();  
  m_boxEnabledColor.Detach();
  m_boxLocalColor.Detach();
  m_boxShowKL.Detach();

	return S_OK;
}

/*STDMETHODIMP CAddIn::GetPageInfo(PROPPAGEINFO *pPageInfo)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

	return S_OK;
}

STDMETHODIMP CAddIn::SetObjects(ULONG cObjects,IUnknown **ppUnk)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here
    
    return IPropertyPageImpl<CAddIn>::SetObjects(cObjects,ppUnk);
}

/*STDMETHODIMP CAddIn::Show(UINT nCmdShow)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

	return S_OK;
}

STDMETHODIMP CAddIn::Move(LPCRECT prc)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

	return S_OK;
}

STDMETHODIMP CAddIn::IsPageDirty()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

	return S_OK;
}*/

STDMETHODIMP CAddIn::Apply()
{	
  BOOL boolShowLast = m_bShowKL;
  {
    AFX_MANAGE_STATE(AfxGetStaticModuleState())
    BOOL boolEnabled;    
    IPropertyLink *pLink = NULL;    
    m_ppUnk[0]->QueryInterface(IID_IPropertyLink,(LPVOID *)&pLink);
    if (pLink != NULL)
      {
        boolEnabled = m_boxEnabledCheckType.GetCheck()?TRUE:FALSE;
        pLink->put_Enabled((unsigned char *)&boolEnabled, IDC_CHECK_TYPE);
        boolEnabled = m_boxOptimizate.GetCheck()?TRUE:FALSE;
        pLink->put_Enabled((unsigned char *)&boolEnabled, IDC_OPTIMIZATE);
      
        boolEnabled = m_boxEnableDebugging.GetCheck()?TRUE:FALSE;
        pLink->put_Enabled((unsigned char *)&boolEnabled, IDC_ENABLE_DEBUGGING);
      
        boolEnabled = m_boxEnabledColor.GetCheck()?TRUE:FALSE;
        pLink->put_Enabled((unsigned char *)&boolEnabled, IDC_ENCOLOR);

			  boolEnabled = m_boxLocalColor.GetCheck()?TRUE:FALSE;
        pLink->put_Enabled((unsigned char *)&boolEnabled, IDC_LOCALCOLOR);

			  boolEnabled = m_boxShowKL.GetCheck()?TRUE:FALSE;
        pLink->put_Enabled((unsigned char *)&boolEnabled, IDC_SHOWKL);

        pLink->Release();
      }
    SetDirty(FALSE);
  }
  if(m_bEnabledColor)
	{
		CBrowse::SetWrap();
	}
	else
	{
		m_bLocalColor = FALSE;
		CBrowse::OffWrap();
	};
	SECStatusBar* pStatus = (SECStatusBar*)AfxGetApp()->m_pMainWnd->GetDescendantWindow(AFX_IDW_STATUS_BAR);
  
	if(pStatus)
	{
		int count = pStatus->GetCount();
		UINT* nIDs;
		UINT* nStyles;
		int* cxWidths;
		nIDs = (UINT*)malloc(count*sizeof(UINT));
		nStyles = (UINT*)malloc(count*sizeof(UINT));
		cxWidths = (int*)malloc(count*sizeof(int));
		for(int i = 0; i<count; i++)
			pStatus->GetPaneInfo(i,nIDs[i],nStyles[i],cxWidths[i]);
		if((m_bShowKL == TRUE) && (boolShowLast == FALSE))
		{
			pStatus->AllocElements(count+2,100);
			pStatus->SetPaneInfo(count+1,NULL,SBPS_NORMAL, 43);
			pStatus->SetPaneInfo(count,NULL,SBPS_NORMAL, 20);
			char KLName[KL_NAMELENGTH]; 
			if(GetLocaleInfo((LCID)((WORD)GetKeyboardLayout(AfxGetApp()->m_nThreadID)),LOCALE_SABBREVLANGNAME,KLName,KL_NAMELENGTH))
				pStatus->SetPaneText(count,KLName,KL_NAMELENGTH);
			StatusTimer = pStatus->SetTimer(500,100,(TIMERPROC)TimerProc);
		}
		else if((m_bShowKL == FALSE) & (boolShowLast == TRUE))
		{
			count -= 2;
			pStatus->AllocElements(count,100);
			if(StatusTimer)
			{
				pStatus->KillTimer(StatusTimer);
				StatusTimer = 0;
			}
		}
		for(i = 0; i<count; i++)
			pStatus->SetPaneInfo(i,nIDs[i],nStyles[i],cxWidths[i]);
		free(nIDs);
		free(nStyles);
		free(cxWidths);
	}
	return S_OK;
}

/*STDMETHODIMP CAddIn::Help(LPCOLESTR pszHelpDir)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

	return S_OK;
}

STDMETHODIMP CAddIn::TranslateAccelerator(LPMSG pMsg)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here
    
	return S_OK;
}*/


LRESULT CAddIn::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
  IPropertyLink *pLink = NULL;
  m_ppUnk[0]->QueryInterface(IID_IPropertyLink,(LPVOID *)&pLink);
  m_boxEnabledCheckType.Attach(GetDlgItem(IDC_CHECK_TYPE));
  m_boxOptimizate.Attach(GetDlgItem(IDC_OPTIMIZATE));
  m_boxEnableDebugging.Attach(GetDlgItem(IDC_ENABLE_DEBUGGING));

  if (pLink != NULL)
  {
    pLink->get_Enabled((unsigned char *)&m_EnabledCheckType, IDC_CHECK_TYPE);        
    pLink->get_Enabled((unsigned char *)&m_EnableOptimizate, IDC_OPTIMIZATE);                
    pLink->get_Enabled((unsigned char *)&m_EnableDebugging, IDC_ENABLE_DEBUGGING);
    
    pLink->get_Enabled((unsigned char *)&m_bEnabledColor, IDC_ENCOLOR);        
    pLink->get_Enabled((unsigned char *)&m_bLocalColor, IDC_LOCALCOLOR);                
    pLink->get_Enabled((unsigned char *)&m_bShowKL, IDC_SHOWKL);

    pLink->Release();
    
  }
  
  
  m_boxEnabledCheckType.SetCheck(m_EnabledCheckType?1:0);    
  m_boxOptimizate.SetCheck(m_EnableOptimizate?1:0);
  m_boxEnableDebugging.SetCheck(m_EnableDebugging?1:0);
  
  m_boxEnabledCheckType.EnableWindow(m_AccessCheckType);
  m_boxOptimizate.EnableWindow(m_AccessOptimizate);
  m_boxEnableDebugging.EnableWindow(m_AccessEnableDebugging);

  m_boxEnabledColor.Attach(GetDlgItem(IDC_ENCOLOR));
  m_boxEnabledColor.SetCheck(m_bEnabledColor?1:0);

  m_boxLocalColor.Attach(GetDlgItem(IDC_LOCALCOLOR));
  m_boxLocalColor.SetCheck(m_bLocalColor?1:0);

  m_boxShowKL.Attach(GetDlgItem(IDC_SHOWKL));
  m_boxShowKL.SetCheck(m_bShowKL?1:0);


  CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();
  CString text;
  if (pHierarchy)
    text.Format("  : %d\r\n  : %d\r\n  :\r\n%s\r\n :\r\n%s\r\n  :\r\n%s\r\n    :\r\n%s",pHierarchy->GetCountClasses(), pHierarchy->GetCountMethods(), pHierarchy->GetDefSymbolOfPreproc(),pHierarchy->GetLoadIncludeFiles(),pHierarchy->GetAllClassesNames(), pHierarchy->GetAllAliasAndPath());

	SetDlgItemText(IDC_EDIT1,text);
  
  SetDirty(FALSE);
  m_pPageSite->OnStatusChange(0);
  bHandled = FALSE;

  return 0; 
}

LRESULT CAddIn::OnCommand(WORD wNotifyCode, WORD nID, HWND hWndCtl, BOOL& bHandled)
{
  SetDirty(TRUE);
  
  /*switch(nID)
  {
    case IDC_OPTIMIZATE:
      {        
        EnableWindow(IDC_ENABLE_DEBUGGING,m_EnableDebugging);
      }
      break;
     default:
     break;
  }*/
  bHandled = FALSE;
  return 0;
}

/////////////////////////////////////////////////////////////////////////////
// IPropertyLink

STDMETHODIMP CAddIn::get_Enabled(unsigned char* pData, int Id)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
  switch(Id)
  {
    case IDC_CHECK_TYPE:
      {
        BOOL* boolEnabled = (BOOL*)pData;
        *boolEnabled = m_EnabledCheckType;        
      }    
      break;
    case IDC_OPTIMIZATE:
      {
        BOOL* boolEnabled = (BOOL*)pData;
        *boolEnabled = m_EnableOptimizate;        
      }
      break;
    case IDC_ENABLE_DEBUGGING:
      {
        BOOL* boolEnabled = (BOOL*)pData;
        *boolEnabled = m_EnableDebugging;        
      }
      break;      
    case IDC_ENCOLOR:
      {
        BOOL* boolEnabled = (BOOL*)pData;
        *boolEnabled = m_bEnabledColor;        
      }
      break;      
    case IDC_LOCALCOLOR:
      {
        BOOL* boolEnabled = (BOOL*)pData;
        *boolEnabled = m_bLocalColor;        
      }
      break;      
    case IDC_SHOWKL:
      {
        BOOL* boolEnabled = (BOOL*)pData;
        *boolEnabled = m_bShowKL;
      }
      break;      
    /*case IDC_EDIT_NAME_FILE_DEF:
      {
        CString* p_str = (CString*)pData;
        *p_str = m_StrFileNameOfDefClass;
        
      }
      break;*/
    default:
    break;
  }
	return S_OK;
}

STDMETHODIMP CAddIn::put_Enabled(unsigned char* pData, int Id)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
  switch(Id)
  {
    case IDC_CHECK_TYPE:
      {
        BOOL* boolEnabled = (BOOL*)pData;
        m_EnabledCheckType = *boolEnabled;
        break;
      }
    case IDC_OPTIMIZATE:
      {
        BOOL* boolEnabled = (BOOL*)pData;
        m_EnableOptimizate = *boolEnabled;
        break;
      }
    case IDC_ENABLE_DEBUGGING:
      {
        BOOL* boolEnabled = (BOOL*)pData;
        m_EnableDebugging = *boolEnabled;
        break;
      }
    case IDC_ENCOLOR:
      {
        BOOL* boolEnabled = (BOOL*)pData;
        m_bEnabledColor = *boolEnabled;
        break;      
      }      
    case IDC_LOCALCOLOR:
      {
        BOOL* boolEnabled = (BOOL*)pData;
        m_bLocalColor = *boolEnabled;
        break;      
      }      
    case IDC_SHOWKL:
      {
        BOOL* boolEnabled = (BOOL*)pData;
        m_bShowKL = *boolEnabled;
        break;      
      }      
    /*case IDC_EDIT_NAME_FILE_DEF:
      {
        CString* pStr = (CString*)pData;
        m_StrFileNameOfDefClass = pStr->operator LPCTSTR();
        
        break;
      }*/
    default:
    break;
  }
	return S_OK;
}


STDMETHODIMP CAddIn::CallAsFunc(long,struct tagVARIANT *,struct tagSAFEARRAY * *)
{
	return S_OK;
}

STDMETHODIMP CAddIn::CallAsProc(long,struct tagSAFEARRAY * *)
{
	return S_OK;
}

STDMETHODIMP CAddIn::HasRetVal(long,int * ipRes)
{
	*ipRes	= 0;

	return S_OK;
}

STDMETHODIMP CAddIn::GetParamDefValue(long,long,struct tagVARIANT *)
{
	return S_OK;
}

STDMETHODIMP CAddIn::GetNParams(long,long * lpParams)
{
	*lpParams	= 0;
	return S_OK;
}

STDMETHODIMP CAddIn::GetMethodName(long,long,unsigned short * *)
{
	return S_OK;
}

STDMETHODIMP CAddIn::FindMethod(unsigned short *,long *)
{
	return S_OK;
}

STDMETHODIMP CAddIn::GetNMethods(long * lpRes)
{
	*lpRes = 0;
	return S_OK;
}

STDMETHODIMP CAddIn::IsPropWritable(long,int *)
{
	return S_OK;
}
STDMETHODIMP CAddIn::IsPropReadable(long,int *)
{
	return S_OK;
}
STDMETHODIMP CAddIn::SetPropVal(long,struct tagVARIANT *)
{
	return S_OK;
}
STDMETHODIMP CAddIn::GetPropVal(long,struct tagVARIANT *)
{
	return S_OK;
}
STDMETHODIMP CAddIn::GetPropName(long,long,unsigned short * *)
{
	return S_OK;
}
STDMETHODIMP CAddIn::FindProp(unsigned short *,long *)
{
	return S_OK;
}
STDMETHODIMP CAddIn::GetNProps(long * lpNum)
{
	*lpNum = 0;
	return S_OK;
}

//custom funcs
int IsDMSContext(const char *name)
{
	return cFeatureList.FindName(name) ? 1 : 0;
}