// AttribEx.cpp: implementation of the CEnviromentContext class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "Service.h"
#include "AttribEx.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

extern CMetaDataCont * pMetaDataCont;
extern CBkEndUI * pBkEndUI;

IMPLEMENT_DYNCREATE_OXY(CAttribEx)

class CObjID CAttribEx::ObjID;

struct CAttribEx::paramdefs CAttribEx::defFnNames[] = {
	{{"AssignAttrib",""}, FALSE, 2},
	{{"GetForm",""}, TRUE, 0},
	{{"SetCoordinates",""}, FALSE, 4},
	{{"GetCoordinates",""}, FALSE, 4},
	{{"ValueTypeStr",""}, TRUE, 0},
	{NULL,0,0}
};

struct CAttribEx::parampropdefs CAttribEx::defPropNames[] = {
	{{"Caption",""}, TRUE, TRUE, NULL},
	{{"Hint",""}, TRUE, TRUE, NULL},
	{{"Description",""}, TRUE, TRUE, NULL},
	{{"Formula",""}, TRUE, TRUE, NULL},
	{{"Visible",""}, TRUE, TRUE, NULL},
	{{"ReadOnly",""}, TRUE, TRUE, NULL},
	{{"Layer",""}, TRUE, TRUE, NULL},
	{{"Value",""}, TRUE, TRUE, NULL},
	{{"AttribID",""}, TRUE, FALSE, NULL},
	{{"Type",""}, TRUE, FALSE, NULL},
	{NULL,0,0, NULL}
};


CAttribEx::CAttribEx():CBLContext()
{
	m_Form = NULL;
	num = 0;
}

CAttribEx::CAttribEx(int param):CBLContext(param)
{
	m_Form = NULL;
	num = 0;
}

CAttribEx::~CAttribEx()
{
	if(m_Form) m_Form->DecrRef();
	m_Form = NULL;
	num = 0;
}

int  CAttribEx::CallAsFunc(int iMethNum,class CValue & rValue,class CValue * *ppValue)
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}

	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
	CGetFieldsArray* pGetFieldsArray = NULL;
	CGetField* pGetField = NULL;
	CControlID* pControlID = NULL;
	CBrowse* pBrowse = NULL;
	if(num == -2)
	{
		if(pDoc->ExistWindow())
			pBrowse = ((CGetDoc*)pDoc)->GetBrowse();
	}
	else
	{
		pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
		pGetField = pGetFieldsArray->GetAt(num);
		pControlID = pGetField->GetCtrlInfo();
	}

	switch (iMethNum) {
	case methgetForm:
		{
			rValue.AssignContext(m_Form);
			break;
		}
	case methValueTypeStr:
		{
			if(num == -2)
			{
				rValue = CString("");
			}
			else
			{
			CValue* ctrlPValue = pGetField->GetPValue();
			if(ctrlPValue)
				rValue = ctrlPValue->GetTypeString();
			}
			break;
		}
	default:
		return 0;
	};
	return 1;
}

int  CAttribEx::CallAsProc(int iMethNum,class CValue * * ppValue)
{
	if(iMethNum == methAssignAttrib)
	{
		CBLContext* pBLCont = ppValue[0]->GetContext();
		if (pBLCont)
		{
			if(!strcmp(pBLCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
			{
				if(m_Form) m_Form->DecrRef();

				m_Form = (CFormAllCtrlsContext*)pBLCont;
				m_Form->IncrRef();
				CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
				CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
				num = -1;
				if(ppValue[1]->buf0[2] == 2)
				{
					if((ppValue[1]->GetString().CompareNoCase("") == 0) ||
						(ppValue[1]->GetString().CompareNoCase("MULTYCOLUMN") == 0))
					{
						num = -2;
					}
					else
					{
					char* str = (char*)(LPCSTR)ppValue[1]->GetString();
					for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
					{
						CGetField* pGetField = pGetFieldsArray->GetAt(i);
						char* pCodeName = (char*)pGetField->GetCtrlInfo()->GetCodeName();
						if(!strcmp(str,pCodeName)) num = i;
					}
					if(num<0)
					{
						num = 0;
						if(m_Form) m_Form->DecrRef();
						m_Form = NULL;
						CBLModule::RaiseExtRuntimeError("  ",0);
						return S_FALSE;
					}
				}
				}
				else if(ppValue[1]->buf0[2] == 1)
				{
					num = ppValue[1]->GetNumeric();
				}
				if(((pGetFieldsArray->GetSize() <= num) || (num<0)) && (num != -2))
				{
					num = 0;
					if(m_Form) m_Form->DecrRef();
					m_Form = NULL;
					CBLModule::RaiseExtRuntimeError("  ",0);
					return S_FALSE;
				}
			}
			else
			{
				CBLModule::RaiseExtRuntimeError("     ",0);
				return S_FALSE;
			}
		}
		return S_OK;
	}
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}

	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
	CGetFieldsArray* pGetFieldsArray = NULL;
	CGetField* pGetField = NULL;
	CControlID* pControlID = NULL;
	CBrowse* pBrowse = NULL;
	if(num == -2)
	{
		if(pDoc->ExistWindow())
			pBrowse = ((CGetDoc*)m_Form->m_GetDoc)->GetBrowse();
	}
	else
	{
		pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
		pGetField = pGetFieldsArray->GetAt(num);
		pControlID = pGetField->GetCtrlInfo();
	}

	switch (iMethNum) {
	case methGetCoordinates:
		{
			CRect mRect(0,0,0,0);
			if(num == -2)
			{
				if(pBrowse)
				{
					pBrowse->GetWindowRect(&mRect);
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
					if(pView)
						pView->ScreenToClient(&mRect);
					else
					{
						CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
						if(pGetDlg)
						{
							pGetDlg->ScreenToClient(&mRect);
						}
					}
				}
			}
			else
			{
			mRect = pControlID->GetPlace();
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
					if(pWnd)
					{
						pWnd->GetWindowRect(&mRect);
						pView->ScreenToClient(&mRect);
					}
				}
				else
				{
					CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
					if(pGetDlg)
					{
						CWnd* pWnd = pGetDlg->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							pWnd->GetWindowRect(&mRect);
							pGetDlg->ScreenToClient(&mRect);
						}
					}
				}
			}
			}
			(*ppValue[0]) = mRect.left;
			(*ppValue[1]) = mRect.top;
			(*ppValue[2]) = mRect.right - mRect.left;
			(*ppValue[3]) = mRect.bottom - mRect.top;
			break;
		}
	case methSetCoordinates:
		{
			CRect mRect(0,0,0,0);

			if(num == -2)
			{
				if(pBrowse)
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
					if(pView)
					{
						pBrowse->GetWindowRect(&mRect);
						pView->ScreenToClient(&mRect);
						if(ppValue[0]->GetNumeric()>=0)
						{
							int oldLeft = mRect.left;
							mRect.left = ppValue[0]->GetNumeric();
							if(ppValue[2]->GetNumeric()<=0)
								mRect.right = mRect.right + mRect.left - oldLeft;
						}
						if(ppValue[1]->GetNumeric()>=0)
						{
							int oldTop = mRect.top;
							mRect.top = ppValue[1]->GetNumeric();
							if(ppValue[3]->GetNumeric()<=0)
								mRect.bottom = mRect.bottom + mRect.top - oldTop;
						}
						if(ppValue[2]->GetNumeric()>0)
							mRect.right = mRect.left + ppValue[2]->GetNumeric();
						if(ppValue[3]->GetNumeric()>0)
							mRect.bottom = mRect.top + ppValue[3]->GetNumeric();

						pBrowse->MoveWindow(mRect);

						pBrowse->RedrawWindow();
					}
					else
					{
						CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
						if(pGetDlg)
						{
							pBrowse->GetWindowRect(&mRect);
							pGetDlg->ScreenToClient(&mRect);
							if(ppValue[0]->GetNumeric()>=0)
							{
								int oldLeft = mRect.left;
								mRect.left = ppValue[0]->GetNumeric();
								if(ppValue[2]->GetNumeric()<=0)
									mRect.right = mRect.right + mRect.left - oldLeft;
							}
							if(ppValue[1]->GetNumeric()>=0)
							{
								int oldTop = mRect.top;
								mRect.top = ppValue[1]->GetNumeric();
								if(ppValue[3]->GetNumeric()<=0)
									mRect.bottom = mRect.bottom + mRect.top - oldTop;
							}
							if(ppValue[2]->GetNumeric()>0)
								mRect.right = mRect.left + ppValue[2]->GetNumeric();
							if(ppValue[3]->GetNumeric()>0)
								mRect.bottom = mRect.top + ppValue[3]->GetNumeric();

							pBrowse->MoveWindow(mRect);

							pBrowse->RedrawWindow();
						}
					}
				}
			}
			else
			{
			mRect = pControlID->GetPlace();

			if(ppValue[0]->GetNumeric()>=0)
			{
				int oldLeft = mRect.left;
				mRect.left = ppValue[0]->GetNumeric();
				if(ppValue[2]->GetNumeric()<=0)
					mRect.right = mRect.right + mRect.left - oldLeft;
			}
			if(ppValue[1]->GetNumeric()>=0)
			{
				int oldTop = mRect.top;
				mRect.top = ppValue[1]->GetNumeric();
				if(ppValue[3]->GetNumeric()<=0)
					mRect.bottom = mRect.bottom + mRect.top - oldTop;
			}
			if(ppValue[2]->GetNumeric()>0)
				mRect.right = mRect.left + ppValue[2]->GetNumeric();
			if(ppValue[3]->GetNumeric()>0)
				mRect.bottom = mRect.top + ppValue[3]->GetNumeric();

			pControlID->SetPlace(mRect);

			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
					if(pWnd)
					{
						pWnd->GetWindowRect(&mRect);
						pView->ScreenToClient(&mRect);
						if(ppValue[0]->GetNumeric()>=0)
						{
							int oldLeft = mRect.left;
							mRect.left = ppValue[0]->GetNumeric();
							if(ppValue[2]->GetNumeric()<=0)
								mRect.right = mRect.right + mRect.left - oldLeft;
						}
						if(ppValue[1]->GetNumeric()>=0)
						{
							int oldTop = mRect.top;
							mRect.top = ppValue[1]->GetNumeric();
							if(ppValue[3]->GetNumeric()<=0)
								mRect.bottom = mRect.bottom + mRect.top - oldTop;
						}
						if(ppValue[2]->GetNumeric()>0)
							mRect.right = mRect.left + ppValue[2]->GetNumeric();
						if(ppValue[3]->GetNumeric()>0)
							mRect.bottom = mRect.top + ppValue[3]->GetNumeric();

						pWnd->MoveWindow(mRect);

						pWnd->RedrawWindow();
					}
				}
				else
				{
					CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
					if(pGetDlg)
					{
						CWnd* pWnd = pGetDlg->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							pWnd->GetWindowRect(&mRect);
							pGetDlg->ScreenToClient(&mRect);
							if(ppValue[0]->GetNumeric()>=0)
							{
								int oldLeft = mRect.left;
								mRect.left = ppValue[0]->GetNumeric();
								if(ppValue[2]->GetNumeric()<=0)
									mRect.right = mRect.right + mRect.left - oldLeft;
							}
							if(ppValue[1]->GetNumeric()>=0)
							{
								int oldTop = mRect.top;
								mRect.top = ppValue[1]->GetNumeric();
								if(ppValue[3]->GetNumeric()<=0)
									mRect.bottom = mRect.bottom + mRect.top - oldTop;
							}
							if(ppValue[2]->GetNumeric()>0)
								mRect.right = mRect.left + ppValue[2]->GetNumeric();
							if(ppValue[3]->GetNumeric()>0)
								mRect.bottom = mRect.top + ppValue[3]->GetNumeric();

							pWnd->MoveWindow(mRect);

							pWnd->RedrawWindow();
						}
					}
				}
			}
			}
			break;
		}
	default:
		return S_FALSE;
	};
	return S_OK;
}


int  CAttribEx::FindMethod(char const * lpMethodName)const
{
	int i;
	for (i = 0;i<lastMethod;i++){
		if (!stricmp(lpMethodName,defFnNames[i].Names[0]))
			return i;
		if (!stricmp(lpMethodName,defFnNames[i].Names[1]))
			return i;
	}
	return -1;
}

char const *  CAttribEx::GetMethodName(int iMethodNum,int iMethodAlias)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].Names[iMethodAlias];
	return 0;
}

int  CAttribEx::GetNMethods(void)const
{
	return lastMethod;
}

int  CAttribEx::HasRetVal(int iMethodNum)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].HasReturnValue;
	return 0;
}

int CAttribEx::GetNParams(int iMethodNum)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].NumberOfParams;
	return 0;
}

int  CAttribEx::GetParamDefValue(int iMethodNum,int iParamNum,class CValue * pDefValue)const
{
	switch (iMethodNum) {
	case methGetCoordinates:
		{
			*pDefValue = -1;
			break;
		}
	case methSetCoordinates:
		{
			*pDefValue = -1;
			break;
		}
	default:
		return 0;
	};
	return 1;
}

void  CAttribEx::DecrRef(void)
{
	CBLContext::DecrRef();
}

char const *  CAttribEx::GetCode(void)const
{
	return 0;
}

int  CAttribEx::GetDestroyUnRefd(void)const
{
	return 1;
}

void  CAttribEx::GetExactValue(class CValue & vParam)
{
	CBLContext::GetExactValue(vParam);
}

class CObjID   CAttribEx::GetID(void)const
{
	return ObjID;
}

class CBLContextInternalData *  CAttribEx::GetInternalData(void)
{

	return CBLContext::GetInternalData();

}

long  CAttribEx::GetTypeID(void)const
{
	return 100;
}

char const *  CAttribEx::GetTypeString(void)const
{
	return "";
}

class CType   CAttribEx::GetValueType(void)const
{
	CType tType(100);
	
	return tType;
}

void  CAttribEx::IncrRef(void)
{
	CBLContext::IncrRef();
}

void  CAttribEx::InitObject(class CType const & tType)
{
	CBLContext::InitObject(tType);
}

void  CAttribEx::InitObject(char const * strName)
{
	CBLContext::InitObject(strName);
}

int  CAttribEx::IsExactValue(void)const
{
	return 0;
}

int  CAttribEx::IsOleContext(void)const
{
	return 0;
}

int  CAttribEx::IsPropReadable(int iPropNum)const
{
	if ((iPropNum>=0) && (iPropNum<lastProp))
		return defPropNames[iPropNum].IsReadable;
	return 0;
}

int  CAttribEx::IsPropWritable(int iPropNum)const
{
	if ((iPropNum>=0) && (iPropNum<lastProp))
		return defPropNames[iPropNum].IsWritable;
	return 0;
}

int  CAttribEx::IsSerializable(void)
{
	return 0;
}

int  CAttribEx::SaveToString(class CString & csStr)
{
	csStr = "";
	return 1;
}

void  CAttribEx::SelectByID(class CObjID cID,long lNum)
{
	CBLContext::SelectByID(cID,lNum);
}

int  CAttribEx::GetNProps(void)const
{
	return lastProp;
}

char const *  CAttribEx::GetPropName(int iPropNum,int iPropAlias)const
{
	if ((iPropNum>=0) && (iPropNum<lastProp))
		return defPropNames[iPropNum].Names[iPropAlias];
	return NULL;
}

int  CAttribEx::GetPropVal(int iPropNum,class CValue & rValue)const
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}

	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
	CGetFieldsArray* pGetFieldsArray = NULL;
	CGetField* pGetField = NULL;
	CControlID* pControlID = NULL;
	CBrowse* pBrowse = NULL;
	if(num == -2)
	{
		if(pDoc->ExistWindow())
			pBrowse = ((CGetDoc*)m_Form->m_GetDoc)->GetBrowse();
	}
	else
	{
		pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
		pGetField = pGetFieldsArray->GetAt(num);
		pControlID = pGetField->GetCtrlInfo();
	}

	switch (iPropNum) {
	case propCaption:
		{
			if(num != -2)
			rValue = pControlID->GetTitle();
			break;
		}
	case propHint:
		{
			if(num != -2)
			rValue = pControlID->GetToolTip();
			break;
		}
	case propDescription:
		{
			if(num != -2)
			rValue = pControlID->GetHelpString();
			break;
		}
	case propFormula:
		{
			if(num != -2)
			rValue = pControlID->GetFormul();
			break;
		}
	case propVisible:
		{
			if(num == -2)
			{
				if(pBrowse) rValue = pBrowse->IsWindowVisible();
			}
			else
			{
			if(((CFormCtrl*)pGetField)->m_RefFlag==0)
			{
				unsigned long lStyleEx = pControlID->GetExStyle();
				rValue = (lStyleEx & CS_EX_VISIBLE);
			}
			else
				rValue = ((CFormCtrl*)pGetField)->m_Visible;
			}
			break;
		}
	case propReadOnly:
		{
			if(num != -2)
			rValue = pGetField->GetReadOnly();
			break;
		}
	case propLayer:
		{
			if(num != -2)
			rValue = pControlID->GetLayerName();
			break;
		}
	case propValue:
		{
			if(num != -2)
			{
			CValue* pValue = pGetField->GetPValue();
			if(pValue) rValue = *pValue;
			}
			break;
		}
	case propAttribID:
		{
			if(num != -2)
			rValue = pControlID->GetCodeName();
			else
				rValue = CString("");
			break;
		}
	case propType:
		{
			if(num != -2)
			rValue = pControlID->GetCtrlType();
			break;
		}
	default:
		return S_FALSE;
	};
	return S_OK;
}

int  CAttribEx::SetPropVal(int iPropNum,class CValue const & vValue)
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}

	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
	CGetFieldsArray* pGetFieldsArray = NULL;
	CGetField* pGetField = NULL;
	CControlID* pControlID = NULL;
	CBrowse* pBrowse = NULL;
	if(num == -2)
	{
		if(pDoc->ExistWindow())
			pBrowse = ((CGetDoc*)pDoc)->GetBrowse();
	}
	else
	{
		pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
		pGetField = pGetFieldsArray->GetAt(num);
		pControlID = pGetField->GetCtrlInfo();
	}

	switch (iPropNum) {
	case propCaption:
		{
			if(num != -2)
			{
			pControlID->SetTitle(vValue.GetString());

			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
					pView->SetDlgItemText(((CFormCtrl*)pGetField)->m_ID,(LPCSTR)vValue.GetString());
			}
			}
			break;
		}
	case propHint:
		{
			if(num != -2)
			{
			pControlID->SetToolTip((LPCSTR)vValue.GetString());

			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
					if(pWnd)
					{
						CToolTip7 * pToolTipCtrl = &(pDoc->GetToolTipCtrl());
						if(pToolTipCtrl)
						{
							TOOLINFO ti;
							ZeroMemory(&ti,sizeof(TOOLINFO));
							ti.cbSize = sizeof(TOOLINFO);
							ti.hwnd = pView->GetSafeHwnd();
							ti.uFlags = TTF_IDISHWND;
							ti.uId = (UINT)(pWnd->GetSafeHwnd());
							LPCTSTR szText = (LPCSTR)vValue.GetString();
							ti.lpszText = LPSTR( szText ? szText : LPSTR_TEXTCALLBACK);
							SendMessage(pToolTipCtrl->m_ToolTipCtrl, TTM_UPDATETIPTEXT, 0, (LPARAM)&ti);
						}
					}
				}
				else
				{
					CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
					if(pGetDlg)
					{
						CWnd* pWnd = pGetDlg->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							CToolTip7 * pToolTipCtrl = &(pDoc->GetToolTipCtrl());
							if(pToolTipCtrl)
							{
								TOOLINFO ti;
								ZeroMemory(&ti,sizeof(TOOLINFO));
								ti.cbSize = sizeof(TOOLINFO);
								ti.hwnd = pView->GetSafeHwnd();
								ti.uFlags = TTF_IDISHWND;
								ti.uId = (UINT)(pWnd->GetSafeHwnd());
								LPCTSTR szText = (LPCSTR)vValue.GetString();
								ti.lpszText = LPSTR( szText ? szText : LPSTR_TEXTCALLBACK);
								SendMessage(pToolTipCtrl->m_ToolTipCtrl, TTM_UPDATETIPTEXT, 0, (LPARAM)&ti);
							}
						}
					}
				}
			}
			}
			break;
		}
	case propDescription:
		{
			if(num != -2)
			pControlID->SetHelpString((LPCSTR)vValue.GetString());
			break;
		}
	case propFormula:
		{
			if(num != -2)
			pControlID->SetFormul(vValue.GetString());
			break;
		}
	case propVisible:
		{
			if(num == -2)
			{
				pDoc->SetBrowseVisible(vValue.GetNumeric(), 0);
			}
			else
			{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);

					if(pWnd)
					{
						if(vValue.GetNumeric()==0)
							pWnd->ShowWindow(SW_HIDE);
						else
							pWnd->ShowWindow(SW_SHOW);
						}
					}
				else
				{
					CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
					if(pGetDlg)
					{
						CWnd* pWnd = pGetDlg->GetDlgItem(((CFormCtrl*)pGetField)->m_ID);
						if(pWnd)
						{
							if(vValue.GetNumeric()==0)
								pWnd->ShowWindow(SW_HIDE);
							else
								pWnd->ShowWindow(SW_SHOW);
							}
						}
					}
				}
			((CFormCtrl*)pGetField)->m_RefFlag = 1;
			((CFormCtrl*)pGetField)->m_Visible = vValue.GetNumeric();
			}
			break;
		}
	case propReadOnly:
		{
			if(num != -2)
				pGetField->SetReadOnly(vValue.GetNumeric()==0);
			break;
		}
	case propLayer:
		{
			if(num != -2)
			pControlID->SetLayerName((LPCSTR)vValue.GetString());
			break;
		}
	case propValue:
		{
			if(num != -2)
			{
				CValue* pValue = pGetField->GetPValue();
				if(pValue)
				{
					*pValue = vValue;
			pGetField->SetPValue(pValue);
				}
			}
			break;
		}
	default:
		return S_FALSE;
	};
	return S_OK;
}

int  CAttribEx::FindProp(char const * lpPropName)const
{
	int i;
	for (i = 0;i<lastProp;i++)
	{
		if (!stricmp(lpPropName,defPropNames[i].Names[0]))
			return i;
		if (!stricmp(lpPropName,defPropNames[i].Names[1]))
			return i;
	}
	return S_FALSE;
}
