// ComponentClass.cpp: implementation of the CComponentClass class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "addin.h"
#include "ComponentClass.h"

extern CMetaDataCont * pMetaDataCont;
extern CBkEndUI * pBkEndUI;

class CObjID CComponentClass::ObjID;

class CMapDefMethod CComponentClass::MapDef;

CComponentClass* CComponentClass::m_CurDebugObject = NULL;

bool CComponentClass::isExeptionStatus = false;
CString CComponentClass::strTextExeption;
CValue* CComponentClass::ExeptionValue = NULL;


IMPLEMENT_DYNCREATE_OXY(CComponentClass)
		
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
//CStdOleBLContext(1)
CComponentClass::CComponentClass() : CBLContext(1), pDebugContext(NULL)
{
  
  AFX_MANAGE_STATE(AfxGetStaticModuleState());
  pMod = NULL;
  defFnNames = NULL;
  pCurModule = CBLModule::GetExecutedModule();
  m_MethParamsDef.nNumberOfMeth = -1;
  m_MethParamsDef.nRealNumberOfMeth = -1;
  m_MethParamsDef.pContext = NULL;
  m_isCreateOptimizeMode = pMainAddIn->m_EnableOptimizate==0 ? false : true;
//  pPoint = NULL;  
#ifdef _DEBUG
  //pBkEndUI->DoMessageLine("  CComponentClass!", mmExclamation);	
#endif
}

CComponentClass::~CComponentClass()
{      
  if (pDebugContext != NULL)
  {    
    int n = pDebugContext->FindProp("Form");
    if (n != -1)
    {            
      CValue cont1;
      pDebugContext->GetPropVal(n, cont1);
      CBLContext *pCont = cont1.GetContext();
      if (pCont)
      {
        n = pCont->FindMethod("Close");
        if (n != -1)
        {
          CValue par1(1);
          CValue *massPar[1];
          massPar[0] = &par1;
          pCont->CallAsProc(n, massPar);
          
        }
      }  
    }
    pDebugContext->DecrRef();
  }
  
  POSITION pos;
  CString pkey;
  CSetOfHierarchy::InfoUnlimitsParams *pInfo = NULL;

  for( pos = m_BindInstaceValueList.GetStartPosition(); pos != NULL; )
  {
    m_BindInstaceValueList.GetNextAssoc( pos, pkey, (void*&)pInfo );
    pInfo->cont_ValueList->DecrRef();
    delete pInfo;    
  }
  

  if (pMod != NULL)
  {
    /*if (pMainAddIn->m_EnableOptimizate)
    {
      int nStaticVars = pMod->GetNStaticVars();
      for (int i = 0; i < nStaticVars; i ++)
      {        
        CValue val;                
        pMod->GetStaticVarValue(i, val, 0);
      
        CBLContext *p = val.GetContext();
        if (p != NULL)
          p->DecrRef();
      }
    }*/

    CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();
    pHierarchy->DeInitInstanceComp(pMod);

    if (pDebugContext == NULL)
    {      
      if (!pMainAddIn->m_EnableOptimizate && NULL != MapDef.GetModule(m_NameOfInstance))      
        MapDef.DelModule(m_NameOfInstance);                      
      
      delete pMod;
      
    }

//    pBkEndUI->DoMessageLine("CComponentClass::~CComponentClass delete pMod;", mmBlackErr);	
  }
    
  if(!pMainAddIn->m_EnableOptimizate && defFnNames) 
  {        
    if (NULL != MapDef.GetDefs(m_NameOfInstance))
    {
      MapDef.DelDefParam(m_NameOfInstance);
      //delete defFnNames;
    }
    else
      if (!m_isCreateOptimizeMode)
        delete defFnNames;
  }  
  
#ifdef _DEBUG
  //pBkEndUI->DoMessageLine("  CComponentClass!", mmExclamation);	
#endif
}

inline int CComponentClass::CallAsMethod(int iMethNum, CValue **ppValue, bool bHasRetVal, CValue *pRetValue)
{
  int res = 0;  
  int iMet = defFnNames->Size();

  if (iMethNum >= iMet)
  {    
	  for (ITER_CONT iter = vecOfBaseCont.begin(); iter != vecOfBaseCont.end(); ++iter)
    {
      CBLContext *pCont = *iter;        
      
      int nNMethods = pCont->GetNMethods();
      if (iMethNum <= iMet+nNMethods) 
      {
        int nMeth = iMethNum - iMet;        
        if (bHasRetVal)        
          res = pCont->CallAsFunc(nMeth, *pRetValue, ppValue);          
        else        
          res = pCont->CallAsProc(nMeth, ppValue);                   
        break;
      }
      iMet += nNMethods;
    }	
  }
  else
  {
    if (pMod)
    {            
      int iProc = (*defFnNames)[iMethNum].nProcPos; 
  
      CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();        
      assert(pHierarchy!=NULL);
      assert(pMainAddIn!=NULL);
      
      if (pMainAddIn->m_EnabledCheckType)
      {
        //    
        CBLProcInfo ProcInfo;
        pMod->GetProcInfo(iProc, ProcInfo);
        CString strTemp = pHierarchy->m_strClassAndMethCurrent;          
        pHierarchy->CheckTypeOfParam(this, iMethNum, ppValue, &ProcInfo);
        pHierarchy->m_strClassAndMethCurrent = strTemp;
      }
  

      bool bResOfImpParam = false;
      bool result = false;
          
      //           
      CArray<COXY_Value*, COXY_Value*> arrParamValOfMeth;        
  
      CString strClassAndMeth;
      bool isUnLimParMethod = (*defFnNames)[iMethNum].isUnLimParMethod;

      if (iMethNum >= lastMethod)
      {
        if (isUnLimParMethod)
        {
          bResOfImpParam = pHierarchy->GetImplicitParams(this, ppValue, iMethNum);
          if (bResOfImpParam)
            strClassAndMeth = pHierarchy->m_strClassAndMethImplicit;
        }

        if ((*defFnNames)[iMethNum].bMethHaveVal)
          pHierarchy->SaveValParam(this, iMethNum, ppValue, &arrParamValOfMeth);
      }
      int nCountParams = pHierarchy->m_CountParametersInCallMethod;
          
      if (bHasRetVal)
      {
        CValue locVal;
			  res = pMod->CallAsFunc(iProc, locVal, (*defFnNames)[iMethNum].NumberOfParams, ppValue);                        
        *pRetValue = locVal;                
      }
      else
      {
        //CTrapModule* pTrap=(CTrapModule*)pMod;
		    //res=pTrap->CallAsProcReal(iProc, (*defFnNames)[iMethNum].NumberOfParams, ppValue);
        res = pMod->CallAsProc(iProc, (*defFnNames)[iMethNum].NumberOfParams, ppValue);
      }
       
      pHierarchy->m_CountParametersInCallMethod = nCountParams;

      if (bResOfImpParam)
        pHierarchy->m_strClassAndMethImplicit = strClassAndMeth;

      if ((*defFnNames)[iMethNum].bMethHaveVal) 
        pHierarchy->RestoreValParam(this, iMethNum, ppValue, &arrParamValOfMeth);        
         
      if (isExeptionStatus)
        ThrowExeption();

      if (bHasRetVal && pMainAddIn && pMainAddIn->m_EnabledCheckType && res == 1)
      {
        //     
        CBLProcInfo ProcInfo;
        pMod->GetProcInfo(iProc, ProcInfo);          
        pHierarchy->CheckTypeOfParam(this, iMethNum, ppValue, &ProcInfo, pRetValue);
      }
    
    }
  }  
  return res;      
}

void CComponentClass::GetFullTypeName(CBLContext *pCont, CString& rus, CString& eng)
{
  
  CString strClassName(pCont->GetRuntimeClass()->m_lpszClassName);  
  rus.Empty();
  eng.Empty();

  rus = pCont->GetTypeString();
  
  if (rus.IsEmpty() || strClassName == "CRegActContext" || strClassName == "CAllRegsContext") 
  {     
    //    1    ""  ""    
    int meth = pCont->FindMethod("Kind");
    if (meth != -1) //   
    {
      //  
      CValue value;
      CValue ValueParam;
      CValue *pMassVal[1] = {&ValueParam};
    
      pCont->CallAsFunc(meth, value, pMassVal);
    

      
      if (strClassName == "CDocContext")
      {
        rus = "";
        eng = "Document";
      }
      else if (strClassName == "CSubcContext")
      {
        rus = "";
        eng = "Reference";
      }
      else if (strClassName == "CRegActContext")
      {
        rus = "";  
        eng = "Register";
      }

      CString sKind = value.GetString();
      if (!sKind.IsEmpty())
      {
        rus += "."; 
        rus += sKind;
        eng += "."; 
        eng += sKind;
      }                 
    }
    else
    {
      if (strClassName == "CAllRegsContext")
      {
        rus = "";
        eng = "Registers";
      }
    }
  }
  else
  {
    eng = rus;
  }
  if (rus.IsEmpty())
  {
    CString info;
    info.Format(" : %s         CComponentClass::GetFullTypeName!     .", strClassName);
    CBLModule::RaiseExtRuntimeError(info,0);    
  }  
}

int CComponentClass::GetBaseClass(const CValue &NameClass, CValue &rValue) const
{
  int res = 0; 
  CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();
  assert(pHierarchy!=NULL);
  
  if (NameClass.IsEmpty())
  {
    CComponentClass* pCompClass = pHierarchy->GetComponentClassCurExModule();
    
    if (pCompClass != NULL && pCompClass != this 
      && CBLModuleWrapper::GetContextFromModule(CBLModule::GetExecutedModule()) == (CBLContext*)this)
    {      
      res = pCompClass->GetBaseClass(NameClass, rValue);
    }
    else
    {
      if (!vecOfBaseCont.empty())
      {
        CBLContext *p = *vecOfBaseCont.begin();
        rValue.AssignContext(p);
      }
      else          
        rValue = CNumeric(0);          
      res = 1;
    }        
  }
  else
  {    
    if (NameClass.GetString() == m_NameOfInstance)
    {
      rValue.AssignContext(const_cast<CComponentClass*>(this));
      res = 1;
    }
    else
    {
      CComponentClass* pCompClass = pHierarchy->GetComponentClassCurExModule();
      if (pCompClass != NULL && pCompClass != this && 
          CBLModuleWrapper::GetContextFromModule(CBLModule::GetExecutedModule()) == (CBLContext*)this)
      {        
        if (pCompClass->GetBaseClass(NameClass, rValue) == 1)
        {
          res = 1;          
        }         
      }
      else
      {
        for (CONST_ITER_CONT iter = vecOfBaseCont.begin(); iter != vecOfBaseCont.end(); ++iter)
        {
          CBLContext *pCBLContext = *iter;      
          CString strRus;
          CString strEng;
          GetFullTypeName(pCBLContext, strRus, strEng);

          if (strRus.CompareNoCase(NameClass.GetString()) == 0 || strEng.CompareNoCase(NameClass.GetString()) == 0)
          {
            rValue.AssignContext(pCBLContext);
            res = 1;
            break;
          }
          else if(pCBLContext->GetRuntimeClass()==&classCComponentClass)
          {
            CValue* params[1] = {const_cast<CValue*>(&NameClass)};
            if (pCBLContext->CallAsFunc(fuctGetBaseClass, rValue, params) == 1)
            {
              res = 1;
              break;
            }         
          }        
        }
      }
    }    
  }
  return res;
}

int CComponentClass::ReplaceInstBaseClasses(const CValue &NameClass, const CValue &Instance, CValue &rValue)
{
  int res = 0;
  if (Instance.GetContext() == NULL)
  {
    CBLModule::RaiseExtRuntimeError("            !",0);    
  }
  if (NameClass.GetString().GetLength() == 0)
  {
    CBLModule::RaiseExtRuntimeError("      !",0);    
  }
  if (NameClass.GetString() == m_NameOfInstance)
  {
    //      
    rValue = CNumeric(0);        
    res = 1;
  }
  else
  {
    CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();
    assert(pHierarchy!=NULL);

    CComponentClass* pCompClass = pHierarchy->GetComponentClassCurExModule();
    if (pCompClass != NULL && pCompClass != this && 
        CBLModuleWrapper::GetContextFromModule(CBLModule::GetExecutedModule()) == (CBLContext*)this)
    {        
      if (pCompClass->ReplaceInstBaseClasses(NameClass, Instance, rValue) == 1)
      {
        res = 1;          
      }         
    }
    else
    {
      for (ITER_CONT iter = vecOfBaseCont.begin(); iter != vecOfBaseCont.end(); ++iter)
      {
        CBLContext *pCBLContext = *iter;        
        CString strRus;
        CString strEng;
        GetFullTypeName(pCBLContext, strRus, strEng);
      
        if (strRus.CompareNoCase(NameClass.GetString()) == 0 && strEng.CompareNoCase(NameClass.GetString()) == 0)
        {
          pCBLContext->DecrRef();
          pCBLContext = Instance.GetContext();
          *iter = pCBLContext;
          pCBLContext->IncrRef();
          rValue = CNumeric(1);
          res = 1;
          break;
        }
        else
        {               
          CValue* params[2] = {const_cast<CValue*>(&NameClass), const_cast<CValue*>(&Instance)};
          if (pCBLContext->CallAsFunc(funcReplaceInstBaseClasses, rValue, params) == 1)
          {
            rValue = CNumeric(1);
            res = 1;
            break;
          }      
        }      
      }      
    }
  }
  return res;
}

int  CComponentClass::CallAsFunc(int iMethNum,class CValue & rValue,class CValue * *ppValue)
{
  int res = 0;
  switch(iMethNum)
	{    
    

    case fuctGetBaseClass: // (< >) :     
    {
      res = GetBaseClass(*ppValue[0], rValue); 
    }
    break;   
    

    case funcReplaceInstBaseClasses:
    {      
      res = ReplaceInstBaseClasses(*ppValue[0], *ppValue[1], rValue);
    }
    break;
    case funcSendMessageOwnMod:
    {
      /*ULONG first = CBLContext::GetFirstLoadedContextID();      
      for (ULONG ind = first; ind != 0; ind = CBLContext::GetNextLoadedContextID(ind))
      {
        CBLContext* pContLoaded = CBLContext::GetLoadedContext(ind);
        int nContMeth = pContLoaded->GetNMethods();
        for (int nM = 0; nM < nContMeth; nM++)
        {
          CString strMethodName = pContLoaded->GetPresentMethodName(nM);
          pBkEndUI->DoMessageLine(strMethodName, mmExclamation);	
        }
      }*/
      if (pCurModule)
      {
        int iProc = pCurModule->FindProc("", 1);
        if (iProc != -1)
        {          
          res = pCurModule->CallAsFunc(iProc, rValue, (*defFnNames)[iMethNum].NumberOfParams, ppValue);
        }        
        else
          pBkEndUI->DoMessageLine("     ()", mmBlackErr);	
      }
      break;
    }
    case funcGetPathName:
      {
        CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();        
        CString str = pHierarchy->GetNameOfFile(m_NameOfInstance);
        CSetOfHierarchy::MakeFullFileName(&str);        
        rValue = str;
        res = 1;
      }
      break;
    case funcGetEnvContext:
      {         
        CBLContext *pCont  = CBLModuleWrapper::GetContextFromModule(pCurModule);        
        if (pCont)
          rValue.AssignContext(pCont);
        else
          rValue = CNumeric(0);
        res = 1;
      }
      break;
    case funcGetParamsList:
      {
        CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();

        CBLContext *pContOfList = pHierarchy->GetImplicitParamsList(this, ppValue[0]->GetString());
        if (pContOfList)
          rValue.AssignContext(pContOfList);
        else
          CBLModule::RaiseExtRuntimeError("   GetParamsList       (...)!",0);
        res = 1;
      }
      break;
    case funcSetOnIndexParams:
      {        
        CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();
        res = pHierarchy->SetImplicitParamOfInd(this, ppValue[0]->GetString(), ppValue[1]->GetNumeric().operator long(), ppValue[2]);
        rValue = CNumeric(res);        
      }
      break;
	default:    
    res = CallAsMethod(iMethNum, ppValue, true, &rValue);	
	};
	return res; 
}

int  CComponentClass::CallAsProc(int iMethNum,class CValue * * ppValue)
{
  
  int res = 0;
  switch(iMethNum)
	{		
  /*
  case procAssignFriendModule:
    {
      if (pMod)
        pMod->AssignFriendModule(CBLModule::GetExecutedModule());
    }
    break;
  */
  case procAddBaseClass:
    {
      CBLContext *pCont = NULL;
      if (strlen(ppValue[0]->GetString()) != 0)
        pCont = CBLContext::CreateInstance(ppValue[0]->GetString());
      else
      {
        pCont = ppValue[0]->GetContext();
        if (pCont) 
        {
          pCont->IncrRef();          
        }
      }
      
      if (pCont) 
      {
        CBLContext *pBase = pCont;
        SetNestedObj(pBase);
      }
      res = 1;
    }
    break;
  case procOnOpen:
    {            
      if (pMainAddIn->m_EnableDebugging && pDebugContext == NULL)
      {
        if (pMod!=NULL) delete pMod;
        
        pMod = CBLModule::GetExecutedModule();        
        pDebugContext = CBLModuleWrapper::GetContextFromModule(pMod);
        pDebugContext->IncrRef();                        
        //m_CurDebugObject
        pMod->AssignContext(this);
        //m_CurDebugObject->DecrRef();
        //m_CurDebugObject = NULL;         
        DecrRef();
      }
      res = 1;
    }
    break;  
  case procThrow:
    {
      *ExeptionValue = *ppValue[0];
      CBLModule7::RaiseExtRuntimeError(strTextExeption, 0);      
    }
    break;
	default:
    res = CallAsMethod(iMethNum, ppValue);	
	};
	return res;
}


int  CComponentClass::FindMethod(char const * lpMethodName)const
{
  int res = defFnNames->GetIndexByName(lpMethodName);	  

  if (-1 != res)
  {
    if ((*defFnNames)[res].isUnLimParMethod || (*defFnNames)[res].bMethHaveVal)
    {
      CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();
      pHierarchy->m_strClassAndMethCurrent = m_NameOfInstance;
      pHierarchy->m_strClassAndMethCurrent += ":";  
      pHierarchy->m_strClassAndMethCurrent += lpMethodName;
    }    
  }
  else
  {    
    int nCountMeth = defFnNames->Size();
    for (CONST_ITER_CONT iter = vecOfBaseCont.begin(); iter != vecOfBaseCont.end(); ++iter)
    {  
      CBLContext *pCont = *iter;
    
      //res = pCont->Is1C_BaseContext() ? pCont->FastFindMeth(lpMethodName) :
      //                                  pCont->FindMethod(lpMethodName);
      res = pCont->FindMethod(lpMethodName);

      if (res != -1)
      {
        res += nCountMeth;
        break;
      }
      nCountMeth += pCont->GetNMethods();
    }
  }
  return res;
}


char const *  CComponentClass::GetMethodName(int iMethodNum,int iMethodAlias)const
{
  int iMet = 0;
	if (iMethodNum >= defFnNames->Size()) 
  {
    iMet = defFnNames->Size();
    CONST_ITER_CONT iEnd(vecOfBaseCont.end());
	  for (CONST_ITER_CONT iter = vecOfBaseCont.begin(); iter != iEnd; ++iter)
    {
      CBLContext *pCont = *iter;
      int nNMethods = pCont->GetNMethods();      
      if (iMethodNum < iMet + nNMethods) 
      {
        int nMeth = iMethodNum - iMet;
        return pCont->GetMethodName(nMeth, iMethodAlias);
      }
      iMet += nNMethods;
    }	
    return NULL;
  }
	else
		return (*defFnNames)[iMethodNum].Names[iMethodAlias];
}

int  CComponentClass::GetNMethods(void)const
{
  int nCountMeth = 0;
  if (defFnNames)
    nCountMeth = defFnNames->Size();
  
  CONST_ITER_CONT iEnd(vecOfBaseCont.end());
  for (CONST_ITER_CONT iter = vecOfBaseCont.begin(); iter != iEnd; ++iter)
  {  
    CBLContext *pCont = *iter;
    nCountMeth += pCont->GetNMethods();
  }
	return nCountMeth;
}

int  CComponentClass::HasRetVal(int iMethodNum)const
{
  int iMet = 0;
  if (iMethodNum >= defFnNames->Size()) 
  {
    iMet = defFnNames->Size();
    CONST_ITER_CONT iEnd(vecOfBaseCont.end());
	  for (CONST_ITER_CONT iter = vecOfBaseCont.begin(); iter != iEnd; ++iter)
    {
      CBLContext *pCont = *iter;
      int nNMethods = pCont->GetNMethods();
      if (iMethodNum < iMet+nNMethods) 
      {
        int nMeth = iMethodNum - iMet;
        return pCont->HasRetVal(nMeth);
      }
      iMet += nNMethods;
    }	
    return 0;
  }
  else
    return (*defFnNames)[iMethodNum].HasReturnValue;
}

int CComponentClass::GetNParams(int iMethodNum)const
{
  int iMet = 0;
  if (iMethodNum >= defFnNames->Size()) 
  {
    iMet = defFnNames->Size();
    CONST_ITER_CONT iEnd(vecOfBaseCont.end());
	  for (CONST_ITER_CONT iter = vecOfBaseCont.begin(); iter != iEnd; ++iter)
    {
      CBLContext *pCont = *iter;      
      int nNMethods = pCont->GetNMethods();
      if (iMethodNum < iMet+nNMethods) 
      {
        int nMeth = iMethodNum - iMet;
        return pCont->GetNParams(nMeth);
      }
      iMet += nNMethods;
    }	
    return 0;
  }
  else
  {
        
    CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();
    if (pHierarchy && iMethodNum >= lastMethod)
    {
      if ((*defFnNames)[iMethodNum].isUnLimParMethod)
        return pHierarchy->GetNParams(this, iMethodNum, (*defFnNames)[iMethodNum].NumberOfParams);
      else
        return (*defFnNames)[iMethodNum].NumberOfParams;
    }
    else if (iMethodNum <= lastMethod)
      return (*defFnNames)[iMethodNum].NumberOfParams;
    else
      return -1;
    //return (*defFnNames)[iMethodNum].NumberOfParams;
  }  
}

int  CComponentClass::GetParamDefValue(int iMethodNum,int iParamNum,class CValue * pDefValue)const
{
  //      CallAsFunc  CallAsProc  
  //      pDefValue  

	if (iMethodNum >= defFnNames->Size())
  {    
    bool bFind = false;
    int  nMeth = -1;
    CBLContext *pCont = NULL;
    if (m_MethParamsDef.nNumberOfMeth == iMethodNum && m_MethParamsDef.pContext != NULL)
    {
      nMeth = m_MethParamsDef.nRealNumberOfMeth; 
      pCont = m_MethParamsDef.pContext;
      bFind = true;
    }
    else
    {
      int  iMet = defFnNames->Size();
      CONST_ITER_CONT iEnd(vecOfBaseCont.end());
      for (CONST_ITER_CONT iter = vecOfBaseCont.begin(); iter != iEnd; ++iter)
      {
        pCont = *iter;
        int nNMethods = pCont->GetNMethods();
    
        if (iMethodNum < iMet + nNMethods) 
        {
          nMeth = iMethodNum - iMet;
          bFind = true;

          break;
        }
        iMet += nNMethods;
      }	
    }
    if (bFind && pCont)
    {      
      m_MethParamsDef.nNumberOfMeth = iMethodNum;
      m_MethParamsDef.nRealNumberOfMeth = nMeth;
      m_MethParamsDef.pContext = pCont;
      //return 1;
      return pCont->GetParamDefValue(nMeth, iParamNum, pDefValue);
    }
		return 0;
  }
  else
  {
    if (fuctGetBaseClass == iMethodNum && iParamNum == 0)
    {
      pDefValue->Reset();
      return 1;
    }
    else if (fuctGetBaseClass == procThrow)
    {
      if      (iParamNum == 0)
        pDefValue->Reset();
      else if (iParamNum == 1)
        *pDefValue = "";
      else
        return 0;

      return 1;
    }
    else
    {      
      CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();        
      return pHierarchy->GetParamDefValue(iMethodNum, iParamNum, pDefValue, this);            
    }
  }  
	return 0; //      
}


void  CComponentClass::IncrRef(void)
{
  /*if (m_NameOfInstance == "2")
  {
    CString mess;
    mess.Format("%s [+m_RefCount=%d]",m_NameOfInstance, m_RefCount);
    pBkEndUI->DoMessageLine(mess, mmInformation);	 
  }*/
  ++m_RefCount;
}

void  CComponentClass::DecrRef(void)
{  
  /*if (m_NameOfInstance == "2")
  {
    CString mess;
    if (m_isLocCreate)
      mess.Format("!! %s [-m_RefCount=%d]",m_NameOfInstance, m_RefCount);
    else
      mess.Format("%s [-m_RefCount=%d]",m_NameOfInstance, m_RefCount);

    pBkEndUI->DoMessageLine(mess, mmInformation);	
  }*/
  if (m_RefCount == 1)
  {
    if (pMod)
    {          
      if (defFnNames->nPosDestructor != -1)
      {
        CValue ValueParam;
        CValue *pMassVal[1] = {0};
        pMassVal[0] = &ValueParam;
        int res = pMod->CallAsProc(defFnNames->nPosDestructor, 0, pMassVal);        
      }      
    }
    if (!vecOfBaseCont.empty())
    {
      ITER_CONT iEnd(vecOfBaseCont.end());
      for (ITER_CONT iter = vecOfBaseCont.begin(); iter != iEnd;)
      {                         
        (*iter)->DecrRef();
        //delete *iter;
        *iter = NULL;        
        vecOfBaseCont.erase(iter++);
        //pBkEndUI->DoMessageLine("CComponentClass::~CComponentClass (*iter)->DecrRef();", mmBlackErr);	
      }      
    }    
  }
  if(--m_RefCount == 0)
  {    
    delete this;  
  }
}



char const *  CComponentClass::GetCode(void)const
{  
  int nPosCode = -1;
  const char * pRet = NULL;
  if (pMod)
  {
    if (-1 == (nPosCode = pMod->FindFunc("_GetCode")))
      nPosCode = pMod->FindFunc("_");

    if (nPosCode != -1)
    {
      CValue ret;
      pMod->CallAsFunc(nPosCode, ret, 0, NULL);
      pRet = ret.GetString().operator LPCTSTR();
    }
  }  
  return pRet;
}

int  CComponentClass::GetDestroyUnRefd(void)const
{
	return CBLContext::GetDestroyUnRefd();
}

void  CComponentClass::GetExactValue(class CValue & vParam)
{   
	CBLContext::GetExactValue(vParam);
}

class CObjID   CComponentClass::GetID(void)const
{ 
	return ObjID;
}

class CBLContextInternalData *  CComponentClass::GetInternalData(void)
{ 
	return CBLContext::GetInternalData();
}




long  CComponentClass::GetTypeID(void)const
{ 
	return 100;
}

char const *  CComponentClass::GetTypeString(void)const
{ 
	return m_NameOfInstance;
}

class CType   CComponentClass::GetValueType(void)const
{
	CType tType(100);
	return tType;
}


void  CComponentClass::InitObject(char const * strName)
{  
  CBLContext::InitObject(strName);
}

int  CComponentClass::IsExactValue(void)const
{    
	return 1;
}

int  CComponentClass::IsOleContext(void)const
{  
  int regEBX = 0;
  __asm {
    mov regEBX, ebx //    1      
  }
  CSetOfHierarchy::GetHierarchy()->m_CountParametersInCallMethod = regEBX; //     
	return 0;
}

int  CComponentClass::IsPropReadable(int iPropNum)const
{
	return 1;
}

int  CComponentClass::IsPropWritable(int iPropNum)const
{  
	return 1;
}

int  CComponentClass::IsSerializable(void)
{
  int iProc = pMod->FindFunc("");
  iProc = iProc == -1 ? pMod->FindFunc("IsSerializable") : iProc;
  if (iProc != -1)
  {
    CValue ValueParam;
    CValue *pMassVal[1] = {0};
    pMassVal[0] = &ValueParam;
    CValue retVal;
    int res = pMod->CallAsFunc(iProc, retVal, 0,pMassVal);
    if (isExeptionStatus)
        ThrowExeption();
    return retVal.GetNumeric();
  }
  else
    return 0;	
}

int  CComponentClass::SaveToString(class CString & csStr)
{     
#ifndef _DEBUG
  if (pMod)
  {
    int iProc = pMod->FindFunc("");
    iProc = iProc == -1 ? pMod->FindFunc("SaveToString") : iProc;
    if (iProc != -1)
    {
      CValue ValueParam;
      CValue *pMassVal[1] = {0};
      pMassVal[0] = &ValueParam;
      CValue retVal;
      int res = pMod->CallAsFunc(iProc, retVal, 0,pMassVal);
      if (isExeptionStatus)
        ThrowExeption();
      csStr = retVal.GetString();            
    }
  }
#else
  pBkEndUI->DoMessageLine(" _DEBUG    SaveToString  ,    1 !!!",mmInformation);
#endif
	return 1;
}

void  CComponentClass::SelectByID(class CObjID cID,long lNum)
{ 
	//CBLContext::SelectByID(cID,lNum);
}


int  CComponentClass::GetNProps(void)const
{
  if (defFnNames->nPosOnReadFreeProp != -1 && defFnNames->nPosOnWriteFreeProp != -1)
  {
    static int nPosNProps = -1;
    if (-1 == (nPosNProps = pMod->FindFunc("_GetNDynamicProps")))
      nPosNProps = pMod->FindFunc("_");
    if (nPosNProps != -1)
    {
      CValue rValue;
      //CComponentClass *pClass = const_cast<CComponentClass *>(this);
      pMod->CallAsFunc(nPosNProps, rValue, 0, NULL);
      if (isExeptionStatus)
        ThrowExeption();
      return rValue.GetNumeric();
    }    
  }
  else
  {
    int nCountProps = pMod->GetNStaticVars();
    for (CONST_ITER_CONT iter = vecOfBaseCont.begin(); iter != vecOfBaseCont.end(); ++iter)
    {      
      CBLContext *pCont = *iter;    
      nCountProps += pCont->GetNProps();
    }
	  return nCountProps;
  }
  return 0;
}

char const *  CComponentClass::GetPropName(int A,int B)const
{  
  if (defFnNames->nPosOnReadFreeProp != -1 && defFnNames->nPosOnWriteFreeProp != -1)
  {
    static int nPosGetPropName = -1;
    if (-1 == (nPosGetPropName = pMod->FindFunc("_GetPropDynamicName")))
      nPosGetPropName = pMod->FindFunc("_");
    if (nPosGetPropName != -1)
    { 
      CValue par1 = A+1;
      CValue* mas[1] = {&par1};
      CValue rValue;
      //CComponentClass *pClass = const_cast<CComponentClass *>(this);
      pMod->CallAsFunc(nPosGetPropName, rValue, 1, mas);
      if (isExeptionStatus)
        ThrowExeption();
      return rValue.GetString();
    }
  }
  else
  {
    int nCountProps = pMod->GetNStaticVars();
    if (nCountProps > A)
    {
      CBLVarInfo VarInfo;
	    pMod->GetStaticVarDescr(A,VarInfo);
	    return VarInfo.GetName();
    }
    else
    {
      CONST_ITER_CONT iEnd(vecOfBaseCont.end());
      for (CONST_ITER_CONT iter = vecOfBaseCont.begin(); iter != iEnd; ++iter)
      {  
        CBLContext *pCont = *iter;    
        int nNProps = pCont->GetNProps();
        if (A < nCountProps + nNProps)
        {
          return pCont->GetPropName(A-nCountProps , B);
        }
        else
          nCountProps += nNProps;
      }    
    }    
  }
  return NULL;
}

int  CComponentClass::GetPropVal(int iPropNum,class CValue & rValue)const
{
  if (iPropNum > 65536)
  {
    POSITION pos;
    CString key;
    int *val = NULL;
    for (pos = defFnNames->mapNamesFreeProp.GetStartPosition(); pos != NULL;)
    {
      defFnNames->mapNamesFreeProp.GetNextAssoc( pos, key, (void*&)val );
      if ((int)val == iPropNum - 65536)
      {
        CValue* pParams[1] = {0};
        CValue par0(key);
        pParams[0] = &par0;
        int ret = pMod->CallAsFunc(defFnNames->nPosOnReadFreeProp, rValue, 1, pParams);    
        if (isExeptionStatus)
          ThrowExeption();
        return ret;
      }
    }    
    
  }

  int nCountProps = pMod->GetNStaticVars();
  
  if (nCountProps > iPropNum)
  {
    int res = pMod->GetStaticVarValue(iPropNum,rValue,0);
    /*    
    CString strNameProp = GetPropName(iPropNum, 0);
    CString strNamePropRus = "_";
    strNamePropRus += strNameProp;    

    int iProc = pMod->FindProc(strNamePropRus, 0);    
    if (iProc == -1)
    {
      CString strNamePropEng = "OnGet_";
      strNamePropEng += strNameProp;
      iProc = pMod->FindProc(strNamePropEng, 1);
    }*/
    int iProc = -1;
    if (defFnNames)
      iProc = defFnNames->GetIndexPropetry(GetPropName(iPropNum, 0), pMod, false);    
    
    if (iProc != -1)
    {      
      CValue *pMassVal[1] = {0};
      pMassVal[0] = &rValue;      
      int res = pMod->CallAsProc(iProc, 1, pMassVal);
      if (isExeptionStatus)
          ThrowExeption();
      return res;
    }    
    return res;
  }
	else
  {
    CONST_ITER_CONT iEnd(vecOfBaseCont.end());
    for (CONST_ITER_CONT iter = vecOfBaseCont.begin(); iter != iEnd; ++iter)
    {  
      CBLContext *pCont = *iter;    
      int nNProps = pCont->GetNProps();
      if (iPropNum < nCountProps + nNProps)
      {
        return pCont->GetPropVal(iPropNum - nCountProps, rValue);
      }
      else
        nCountProps += nNProps;
    }
    return 0;
  }  
}

int  CComponentClass::SetPropVal(int iPropNum,class CValue const & vValue)
{  
  if (iPropNum > 65536)
  {
    POSITION pos;
    CString key;
    int *val = NULL;
    for (pos = defFnNames->mapNamesFreeProp.GetStartPosition(); pos != NULL;)
    {
      defFnNames->mapNamesFreeProp.GetNextAssoc( pos, key, (void*&)val );
      if ((int)val == iPropNum - 65536)
      {
        CValue* pParams[2] = {0};
        CValue par0(key);
        CValue par1(vValue);
        pParams[0] = &par0;
        pParams[1] = &par1;
        //pBkEndUI->DoMessageLine(key, mmBlueTriangle);    
        int ret = pMod->CallAsProc(defFnNames->nPosOnWriteFreeProp, 2, &pParams[0]);        
        if (isExeptionStatus)
          ThrowExeption();
        return ret;
      }
    }    
  }

  int nCountProps = pMod->GetNStaticVars();

  if (nCountProps > iPropNum)
  {                
    /*CString strNameProp = GetPropName(iPropNum, 0);
    CString strNamePropRus = "_";    
    strNamePropRus += strNameProp;
    
    
    int iProc = pMod->FindProc(strNamePropRus, 0);
    if (iProc == -1)
    {
      CString strNamePropEng = "OnWrite_";
      strNamePropEng += strNameProp;
      iProc = pMod->FindProc(strNamePropEng, 1);
    }*/
    
    int iProc = -1;
    if (defFnNames)
      iProc = defFnNames->GetIndexPropetry(GetPropName(iPropNum, 0), pMod, true);    

    if (iProc != -1)
    {
      CValue par(vValue);
      CValue *pMassVal[1] = {0};
      pMassVal[0] = &par;      
      int ret = pMod->CallAsProc(iProc, 1, pMassVal);            
      if (isExeptionStatus)
          ThrowExeption();
      return ret;      
    }    
    return pMod->SetStaticVarValue(iPropNum,vValue,0);    
  }
	else
  {   
    CONST_ITER_CONT iEnd(vecOfBaseCont.end());
    for (CONST_ITER_CONT iter = vecOfBaseCont.begin(); iter != iEnd; ++iter)
    {  
      CBLContext *pCont = *iter;    
      if (iPropNum >= nCountProps && iPropNum < nCountProps + pCont->GetNProps())
      {
        return pCont->SetPropVal(iPropNum - nCountProps, vValue);
      }
      else
        nCountProps += pCont->GetNProps();
    }
    return 0;
  }
}

int  CComponentClass::FindProp(char const * Name)const
{
  if (defFnNames->nPosOnReadFreeProp != -1 && defFnNames->nPosOnWriteFreeProp != -1)
  {
    int *i = NULL;
    int nCount = 0;
    if (!defFnNames->mapNamesFreeProp.Lookup(Name, (void*&)i))
    {
      nCount = defFnNames->mapNamesFreeProp.GetCount() + 1;
      defFnNames->mapNamesFreeProp[Name] = (int *)nCount;            
    }    
    else
      nCount = (int)i;
    return 65536 + nCount;
  }
    
  int nNumProp = pMod->FindStaticVar(Name);
  if (nNumProp == -1)
  {
    int nCountProps = pMod->GetNStaticVars();
    
    CONST_ITER_CONT iEnd(vecOfBaseCont.end());
    for (CONST_ITER_CONT iter = vecOfBaseCont.begin(); iter != iEnd; ++iter)
    {  
      CBLContext *pCont = *iter;
      int res = pCont->FindProp(Name);
      if (res != -1)
        return nCountProps + res;
      nCountProps += pCont->GetNProps();
    }
  }
  else
  {
    CBLVarInfo VarInfo;
	  pMod->GetStaticVarDescr(nNumProp,VarInfo);
    if (VarInfo.IsExported() == 0)      
      nNumProp = -1;
  }
  
	return nNumProp;
}

void CComponentClass::ShowError(const char *err)
{
	if (pCurModule) {
		CString str(32,500);
		char buf[100];
		int nLine = pCurModule->GetExecutedLineNum();
		pCurModule->GetCurSourceLine(nLine, str);
		sprintf(buf, "   : %d", nLine);
		pBkEndUI->DoMessageLine(buf, mmExclamation);
		str.TrimLeft();
		pBkEndUI->DoMessageLine(str, mmExclamation);
	}
	pBkEndUI->DoMessageLine((LPCTSTR)err, mmExclamation);
}

void  CComponentClass::InitObject(class CType const & tType)
{  
  CBLContext::InitObject(tType);
  //     !
  const CType *pType = &tType;
  const char* str = reinterpret_cast<const char*> (pType);
  m_NameOfInstance = str; 
  CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();
  if (!pHierarchy->InitInstanceComp(this))
  {
    CONST_ITER_CONT iEnd(vecOfBaseCont.end());
    for (CONST_ITER_CONT iter = vecOfBaseCont.begin(); iter != iEnd; ++iter)    
    {
      (*iter)->DecrRef();
      delete *iter;
    }
    
    vecOfBaseCont.clear();
  }
}


//CBLModuleWrapper* CComponentClass::Init(const char *file, CComponentClass* pCreatedCompModule)
CBLModule* CComponentClass::Init(const char *file, CComponentClass* pCreatedCompModule)
{  
  // file -  ,     
 
  //       MapDef    
  //       ,
  // ..     (, ,  ) 
  //      .  ,
  //          .
  //        
  try 
  {        
    CBLModule* pModLocale = NULL;

    CParamDefs *pParDefs = NULL;
    if (pMainAddIn->m_EnableOptimizate && NULL != (pParDefs = MapDef.GetDefs(m_NameOfInstance))) {
      defFnNames = pParDefs; 
      pModLocale = MapDef.GetModule(m_NameOfInstance);      
    }
    else
    {
      //pBkEndUI->DoMessageLine(" ", mmExclamation);	
      //   ,      

      //////////////////////////////////////////////////////////////////////
      //       1 
      // {{<"English_description">,<"_">},<0- , 1- >,< >}
      //////////////////////////////////////////////////////////////////////
      defFnNames = new CParamDefs();
//      pBkEndUI->DoMessageLine("CComponentClass::Init defFnNames = new CParamDefs();", mmBlackErr);	
      
      if(pMainAddIn->m_EnableOptimizate)
        MapDef.AddDefParam(m_NameOfInstance, defFnNames);        
      
      
      CString FullFileName(file);
      CSetOfHierarchy::MakeFullFileName(&FullFileName);
      
      CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();
            
      CModuleString str;
      if (!str.LoadModule(FullFileName))
      {
        pBkEndUI->DoMessageLine(FullFileName, mmBlackErr);	
        return NULL;
      }
      try 
      {
        //      include             
        CMapStringToString mapLoadedIncludeFiles;
        pHierarchy->m_SymbolOfPreprocessor["_NOW_PREPARE_CLASS"] = NULL;
        CPreprocessor preproc(str, pHierarchy->m_SymbolOfPreprocessor, mapLoadedIncludeFiles, FullFileName);        
        preproc.Start();
        pHierarchy->m_SymbolOfPreprocessor.RemoveKey("_NOW_PREPARE_CLASS");
      }
      catch (CPreprocessor::ExeptionPreprocessor &ex)
      {
        CString strErr;
        strErr.Format("  : %s (%s)", m_NameOfInstance, FullFileName);
        pBkEndUI->DoMessageLine(strErr, mmBlackErr);	
        strErr = ex.GetErrorString();        
        pBkEndUI->DoMessageLine(strErr, mmBlackErr);	
        strErr.Empty();
        if (!ex.GetCodeString().IsEmpty())
        {
          strErr.Format("(%d) %s",ex.GetNumString(),ex.GetCodeString());
          pBkEndUI->DoMessageLine(strErr, mmBlackErr);
        }
        return NULL;
      }

      if (str.IsEmpty()) 
      {
        CString strErr;
        strErr.Format(": %s    (%s)   !", m_NameOfInstance, FullFileName);
			  pBkEndUI->DoMessageLine(strErr, mmBlackErr);	
        return NULL;
		  }
      pModLocale = new CBLModuleWrapper(NULL, str, FullFileName);
//        pBkEndUI->DoMessageLine("CComponentClass::Init pModLocale = new CBLModuleWrapper(NULL, str, FullFileName);", mmBlackErr);				
			int nComp = pModLocale->Compile();
    
			//int nExec = pModLocale->Execute();
    
      if (nComp != 1) {
        CString strErr;
        strErr.Format(": %s : %s   !", m_NameOfInstance, FullFileName);
        pBkEndUI->DoMessageLine(strErr, mmBlackErr);	
        return NULL;
      }

      //_()  " "
      //_OnReadProperty()
      //_(, _)
      //_OnWriteProperty()
      int nPosRead = -1;
      if (-1 == (nPosRead = pModLocale->FindFunc("_")))
        nPosRead = pModLocale->FindFunc("_OnReadProperty");
      if (nPosRead != -1)
      {
        int nPosWrite = -1;
        if (-1 == (nPosWrite = pModLocale->FindProc("_", 0)))
          nPosWrite = pModLocale->FindProc("_OnWriteProperty", 1);
        if (nPosWrite != -1 && nPosRead != -1)
        {
          defFnNames->nPosOnReadFreeProp  = nPosRead;
          defFnNames->nPosOnWriteFreeProp = nPosWrite;
        }
      }

      int iProc = pModLocale->FindProc("", 0);
      iProc = (iProc == -1) ? pModLocale->FindProc("Constructor", 1) : iProc;
      defFnNames->nPosConstructor = iProc;
      iProc = pModLocale->FindProc("", 0);            
      iProc = (iProc == -1) ? pModLocale->FindProc("Destructor", 1) : iProc;                  
      defFnNames->nPosDestructor = iProc;

      if(pMainAddIn->m_EnableOptimizate) //        
        MapDef.AddModule(m_NameOfInstance, pModLocale);
    
      int nProc = pModLocale->GetNProcs(); //      
      
      if (pHierarchy) //         ,   
        pHierarchy->InitParamDefsClass(defFnNames, m_NameOfInstance);

      
      
      defFnNames->SetPoolSize(nProc + lastMethod + 1, pModLocale->GetNStaticVars());

      defFnNames->AddParam("GetBaseClass", "", fuctGetBaseClass, 1, 1);
      defFnNames->AddParam("AssignFriendModule", "",procAssignFriendModule, 0, 0);
      defFnNames->AddParam("AssignBaseClass", "", procAddBaseClass, 0, 1);
      defFnNames->AddParam("SendMessageOwnMod", "", funcSendMessageOwnMod, 1, 3);
      defFnNames->AddParam("GetPathName", "", funcGetPathName, 1, 0);
      defFnNames->AddParam("GetEnvContext", "", funcGetEnvContext, 1, 0);
      defFnNames->AddParam("GetParamsList", "", funcGetParamsList, 1, 1);
      defFnNames->AddParam("ReplaceInstBaseClasses", "", funcReplaceInstBaseClasses, 1, 2);
      defFnNames->AddParam("SetOnIndexParams", "", funcSetOnIndexParams, 1, 3);                
      defFnNames->AddParam("_OnOpen", "_", procOnOpen, 0, 0);
      defFnNames->AddParam("_Throw", "_", procThrow, 0, 1);

      for (int count = 1; count < nProc; count++) 
      {
        char nameProc[255] = {0};
        CBLProcInfo procInfo;
        pModLocale->GetProcInfo(count, procInfo); //   .    
        strcpy(nameProc, procInfo.GetName());
        int nParamas   = procInfo.GetNParams();
        int nVars      = procInfo.GetNVars();
        int hasRetVal  = procInfo.HasRetVal();
        int procPos    = procInfo.GetProcPos();  
      
        if (procInfo.IsExported() == 1)
        {
          CString strNamesClassAndMeth = m_NameOfInstance;
          strNamesClassAndMeth +=":";
          strNamesClassAndMeth +=nameProc;            
          defFnNames->AddParam(NULL,nameProc, procPos, hasRetVal, nParamas, 
            pHierarchy->ThisIsUnLimMethod(strNamesClassAndMeth), //     
            pHierarchy->isMethHaveParVal(strNamesClassAndMeth)); //       
        }
      }       
    }
    if (pModLocale) 
    {
      if (pMod) 
      {
        delete pMod;
//        pBkEndUI->DoMessageLine("CComponentClass::Init delete pMod;", mmBlackErr);	
        pMod = NULL;
      }            
//      pBkEndUI->DoMessageLine("CComponentClass::Init pMod = new CBLModuleWrapper(this, NULL);", mmBlackErr);	      
      if(pMainAddIn->m_EnableDebugging) 
      {
        m_CurDebugObject = pCreatedCompModule;
        ULONG first = CBLContext::GetFirstLoadedContextID();        
        for (ULONG ind = first; ind != 0; ind = CBLContext::GetNextLoadedContextID(ind))
        {
          CBLContext* pContLoaded = CBLContext::GetLoadedContext(ind);          
          
          int nMethNum = pContLoaded->FindMethod("OpenForm");
          if (nMethNum != -1)
          { 
            CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();        
            CString str = pHierarchy->GetNameOfFile(m_NameOfInstance);            
            CSetOfHierarchy::MakeFullFileName(&str);          
            CString strPar1;
            int npos = str.Find("@MD");
            if (npos != -1)
            {
              strPar1 = ".";
              strPar1 += str.Left(npos);
              strPar1 += "#";
            }
            else            
            {
              strPar1 = "#";
            }
            CValue retval;            
            CValue Par1 = strPar1;
            CValue Par2;
            Par2.SetValTypeID(100);
            Par2.AssignContext(this);                          
            
            
            CValue Par3 = str;            

            CValue* MasPar[6] = {&Par1, &Par2, &Par3, 0, 0, 0};

            try
            {              
              pContLoaded->CallAsFunc(nMethNum, retval, &MasPar[0]);            
            }
            catch(...)
            {
              CString strErr;
              strErr.Format("    : %s", m_NameOfInstance);
              pBkEndUI->DoMessageLine(strErr, mmBlackErr);
            }
            break;              
          }                        
        }              
      }
      if (pMod==NULL)       		    
			pMod = new CBLModuleWrapper(pCreatedCompModule,NULL);
           
      pMod->AssignCompiled(*pModLocale);      

      if(!pMainAddIn->m_EnableOptimizate) 
      {
        MapDef.DelModule(m_NameOfInstance);
        delete pModLocale;
//        pBkEndUI->DoMessageLine("CComponentClass::Init delete pModLocale;", mmBlackErr);	2A049C00
      }      
      
      if (pCurModule != NULL)
		    pMod->AssignFriendModule(pCurModule);

      int res = pMod->Execute();
      if (res != 1)
      {
        CString strErr;
        strErr.Format("  : %s  !", m_NameOfInstance);
        pBkEndUI->DoMessageLine(strErr, mmBlackErr);	
        return NULL;
      }      
    }    
    return pMod;
  }
  catch (...)
  {
    CString strErr;
    strErr.Format(" !   : %s!", m_NameOfInstance);
    pBkEndUI->DoMessageLine(strErr, mmBlackErr);	
    return NULL;
  }
}

void CComponentClass::SetNestedObj(CBLContext* pCont)
{
	/*
	     
	    
	 
	*/
  if (pCont)
    vecOfBaseCont.push_back(pCont);
}

void CComponentClass::InvokeConstructor()
{  
  CONST_ITER_CONT iEnd(vecOfBaseCont.end());
  for (CONST_ITER_CONT iter = vecOfBaseCont.begin(); iter != iEnd; ++iter)
  {
    CBLContext *pCBLContext = *iter;        
    CString strClassName(pCBLContext->GetRuntimeClass()->m_lpszClassName);
    if (strClassName == "CComponentClass")
    {
      static_cast<CComponentClass*>(pCBLContext)->InvokeConstructor();
    }
  }
  if (pMod)
  {            
    if (defFnNames->nPosConstructor != -1)
    {
      CValue ValueParam;
      CValue *pMassVal[1] = {0};
      pMassVal[0] = &ValueParam;
      int res = pMod->CallAsProc(defFnNames->nPosConstructor, 0, pMassVal);
      if (isExeptionStatus)
        ThrowExeption();
    }        
  }     
}

CBLModule * CComponentClass::GetPrevModule() const
{
  return pCurModule;
}

CBLModule * CComponentClass::GetModule() const
{
  return pMod;
}

void CComponentClass::ThrowExeption(bool isThrow)
{
  //pBkEndUI->DoMessageLine("void CComponentClass::ThrowExeption(bool isThrow)", mmRedErr);	
  isExeptionStatus = false;
  CString copy(strTextExeption);
  strTextExeption.Empty();        
  if (isThrow)
    CBLModule7::RaiseExtRuntimeError(copy, 0) ;        
  else
    pBkEndUI->DoMessageLine(copy, mmExclamation);	
}
