// Delegate.cpp: implementation of the CDelegate class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "addin.h"
#include "Delegate.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


extern CMetaDataCont * pMetaDataCont;
extern CBkEndUI * pBkEndUI;

IMPLEMENT_DYNCREATE_OXY(CDelegate);

class CObjID CDelegate::ObjID;


//////////////////////////////////////////////////////////////////////
//       1 
// {{<"English_description">,<"_">},<0- , 1- >,< >}
//////////////////////////////////////////////////////////////////////
struct CDelegate::paramdefs CDelegate::defFnNames[] = {  
  {"DefineType","",0,2},
  {"AddMethod","",1,3},
  {"RemMethod","",1,2},
  {"RemMethodByKey","",0,1},
  {"Invoke","",1,0},
  {"InvokeByKey","",1,0},
  {"Erase","",0,0},
  {"IsEmpty","",1,0},
	{NULL,NULL,0,0}
};
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDelegate::CDelegate() : m_nCountParams(-1), m_IsFunc(-1)
{
  AFX_MANAGE_STATE(AfxGetStaticModuleState());	
}

CDelegate::~CDelegate()
{  
  EraseDelegate();
  //pBkEndUI->DoMessageLine("CDelegate::~CDelegate()", mmBlueTriangle);
}

void CDelegate::SetTypeOfDelegate(CValue **ppParams)
{  
  m_nCountParams = ppParams[0]->GetNumeric().operator long();
  m_IsFunc       = (ppParams[1]->GetNumeric().operator long()) > 0 ? 1 : 0;
}

bool CDelegate::AddMethodForDelegate(CValue &RetVal, CValue **ppParams, bool isKeyMapped)
{
 
  if (m_nCountParams == -1)
    CBLModule::RaiseExtRuntimeError("        ",0);
  
  CString strNameMeth = ppParams[1]->GetString();
  if (strNameMeth.IsEmpty())      
    CBLModule::RaiseExtRuntimeError("   ()    !" ,0);
  CBLContext *pCont = ppParams[0]->GetContext();
  if (!pCont)
    CBLModule::RaiseExtRuntimeError("   ()     1 (: CreateObject())!" ,0);
  int nMeth = pCont->FindMethod(strNameMeth);
  if (nMeth == -1)
  {
    CString strError;
    strError += " : ";
    strError += pCont->GetTypeString();
    strError += "   : ";
    strError += strNameMeth;
    CBLModule::RaiseExtRuntimeError(strError, 0);
  }
  if (pCont->HasRetVal(nMeth) != m_IsFunc)
  {
    CString strError;
    strError += " : ";
    strError += pCont->GetTypeString();
    strError += "   : ";
    strError += strNameMeth;
    
    strError += "   ";
    strError += m_IsFunc == 1 ? ",  " : ",  ";
    CBLModule::RaiseExtRuntimeError(strError, 0);
  }
  if (pCont->GetNParams(nMeth) != m_nCountParams)
  {
    CString strError;
    CString strParam;
    if (m_nCountParams == 0 || m_nCountParams > 4)
      strParam = "";
    else if (m_nCountParams == 1)
      strParam = "";   
    else
      strParam = "";   

    strError.Format(" : %s : %s    %d %s!", pCont->GetTypeString(), strNameMeth, m_nCountParams, strParam);
    CBLModule::RaiseExtRuntimeError(strError, 0);
  }
  pCont->IncrRef();
  InfoEventHandlers info(pCont, nMeth);
  if (find(m_ListOfHandlers.begin(), m_ListOfHandlers.end(), info) != m_ListOfHandlers.end())
  {
    RetVal = CNumeric(0);
    return false;
  }
  else
  {
    RetVal = CNumeric(1);
    ITER_LIST iter = m_ListOfHandlers.insert(m_ListOfHandlers.end(), info);
    if (isKeyMapped && !ppParams[2]->IsEmpty())    
      m_map[ppParams[2]->GetString()] = &*iter;    
    return true;
  }      
}

void CDelegate::DeleteMethodsByKey(CValue **ppParams)
{
  CString strKey = ppParams[0]->GetString();
  if (strKey.IsEmpty())      
    CBLModule::RaiseExtRuntimeError("   ()   !" ,0);
  
  void* p = NULL;
  if(m_map.Lookup(strKey, (void*&)p))
  {
    if (p != NULL)
    {
      m_map.RemoveKey(strKey);
      InfoEventHandlers* pInfo = static_cast<InfoEventHandlers*>(p);
      ITER_LIST find_iter = find(m_ListOfHandlers.begin(), m_ListOfHandlers.end(), *pInfo);
      if (find_iter != m_ListOfHandlers.end())
        m_ListOfHandlers.erase(find_iter);      
    }
  }
}

bool CDelegate::DeleteMethodsFromDelegate(CValue &RetVal, CValue **ppParams)
{
  if (m_nCountParams == -1)
    CBLModule::RaiseExtRuntimeError("        ",0);
  
  CString strNameMeth = ppParams[1]->GetString();  
  if (strNameMeth.IsEmpty())      
    CBLModule::RaiseExtRuntimeError("   ()    !" ,0);
  
  CBLContext *pCont = ppParams[0]->GetContext();
  if (!pCont)
    CBLModule::RaiseExtRuntimeError("   ()     1 (: CreateObject())!" ,0);
  
  int nMeth = pCont->FindMethod(strNameMeth);
  if (nMeth == -1)
  {
    RetVal = CNumeric(0);          
  }   
  ITER_LIST find_iter = find(m_ListOfHandlers.begin(), m_ListOfHandlers.end(), InfoEventHandlers(pCont, nMeth));
  if (find_iter != m_ListOfHandlers.end())
  {    
    if (!m_map.IsEmpty())
    {
      POSITION pos;
      CString key;
      void* p = NULL;
      for( pos = m_map.GetStartPosition(); pos != NULL; )
      {
         m_map.GetNextAssoc( pos, key, (void*&)p );
         InfoEventHandlers* pInfo = static_cast<InfoEventHandlers*>(p);

         if (pInfo != NULL && pInfo == &*find_iter)
         {
           m_map.RemoveKey(key);
           break;
         }
      }
    }
    m_ListOfHandlers.erase(find_iter);
    
    RetVal = CNumeric(1);    
  }
  else
  {
    RetVal = CNumeric(0);          
  }
  return true;
}

bool CDelegate::InvokeByKey(CValue &RetVal, CValue **ppParams)
{
  if (m_nCountParams == -1)
    CBLModule::RaiseExtRuntimeError("        ",0);
  
  
  InfoEventHandlers* pInfo = static_cast<InfoEventHandlers*>(m_map[ppParams[0]->GetString()]);
  if (pInfo == NULL)
  {
    RetVal == CValue(0L);
    return false;
  }
  CBLContext *pBLCont = pInfo->pBLCont;
  int nMet = pInfo->nNumMethOfCall;
  ASSERT(pBLCont != NULL);
  ASSERT(nMet != -1);
  if (m_IsFunc)
  {
    pBLCont->CallAsFunc(nMet, RetVal, ++ppParams);      
  }
  else
  {      
    pBLCont->CallAsProc(nMet, ++ppParams);
    RetVal = CNumeric(1);  
  }    
  return true;
}

bool CDelegate::Invoke(CValue &RetVal, CValue **ppParams, bool IsBreakest)
{
  if (m_nCountParams == -1)
    CBLModule::RaiseExtRuntimeError("        ",0);
  
  for (CONST_ITER_LIST iter = m_ListOfHandlers.begin(); iter != m_ListOfHandlers.end(); iter++ )
  {
    CBLContext *pBLCont = (*iter).pBLCont;
    int nMet = (*iter).nNumMethOfCall;
    ASSERT(pBLCont != NULL);
    ASSERT(nMet != -1);
    if (m_IsFunc)
    {      
      pBLCont->CallAsFunc(nMet, RetVal, ppParams);
      if (IsBreakest)
        if (RetVal == CValue(0L))                  
          return true;        
    }
    else
    {      
      pBLCont->CallAsProc(nMet, ppParams);
      RetVal = CNumeric(1);  
    }    
  }  
  return true;
}

void CDelegate::EraseDelegate(bool bFullErase)
{
  for (CONST_ITER_LIST iter = m_ListOfHandlers.begin(); iter != m_ListOfHandlers.end(); iter++ )
  {
    (*iter).pBLCont->DecrRef();
  }
  m_ListOfHandlers.clear();
  m_map.RemoveAll();
  if (bFullErase)
  {
    m_nCountParams = -1;
    m_IsFunc = -1;
  }
}

int  CDelegate::CallAsFunc(int iMethNum,class CValue & rValue,class CValue * *ppValue)
{
  switch(iMethNum)
  {    
    case methAddMethod:
    { 
      if (AddMethodForDelegate(rValue, ppValue))
        return 1;
      else
        return -1;
    }
    break;    
    case methRemMethod:
    { 
      if (DeleteMethodsFromDelegate(rValue, ppValue))
        return 1;
      else
        return -1;
    }
    break;    
    case methInvoke:
    {       
      if (Invoke(rValue, ppValue))
        return 1;
      else
        return -1;
    }
    case funcInvokeByKey:
    {       
      if (InvokeByKey(rValue, ppValue))
        return 1;
      else
        return -1;
    }
    break;    
    case funcIsEmpty:
    { 
      rValue =  CNumeric(IsEmpty() ? 1 : 0);
      return 1;
    }
    break;
  default:
    {
    }
  };
  return -1;
}

int  CDelegate::CallAsProc(int iMethNum,class CValue * * ppValue)
{
  switch(iMethNum)
  {
    case procErase:
    { 
      EraseDelegate();
    }
    break;    
    case methDefineType:
    { 
      SetTypeOfDelegate(ppValue);
    }
    break;
    case methRemMethodByKey:
    {
      DeleteMethodsByKey(ppValue);
    }
    break;        
  default:
    {     
    }
  };
  return -1;
}


int  CDelegate::FindMethod(char const * lpMethodName)const
{
	int i;
	for (i = 0;i<lastMethod;i++){
		if (!stricmp(lpMethodName,defFnNames[i].Names[0]))
			return i;
		if (!stricmp(lpMethodName,defFnNames[i].Names[1]))
			return i;
	}
  return -1;
}

char const *  CDelegate::GetMethodName(int iMethodNum,int iMethodAlias)const
{
	if (iMethodNum >= lastMethod) 
		return "mError";
	else
		return defFnNames[iMethodNum].Names[iMethodAlias];
}

int  CDelegate::GetNMethods(void)const
{
	return lastMethod;
}

int  CDelegate::HasRetVal(int iMethodNum)const
{	
	return defFnNames[iMethodNum].HasReturnValue ;
}

int CDelegate::GetNParams(int iMethodNum)const
{	
  if (iMethodNum == methInvoke)
    return m_nCountParams;
  else if (funcInvokeByKey == iMethodNum)
    return m_nCountParams + 1;
  else
    return defFnNames[iMethodNum].NumberOfParams;
}

int  CDelegate::GetParamDefValue(int iMethodNum,int iParamNum,class CValue * pDefValue)const
{	
  if (iMethodNum == methAddMethod)
  {  
    pDefValue->Reset();
    return 1;
  }
  else
	  return 0;
}

void  CDelegate::DecrRef(void)
{
	CBLContext::DecrRef();
}



char const *  CDelegate::GetCode(void)const
{
	return 0;
}

int  CDelegate::GetDestroyUnRefd(void)const
{
	return 1;
}

void  CDelegate::GetExactValue(class CValue & vParam)
{
	CBLContext::GetExactValue(vParam);
}

class CObjID   CDelegate::GetID(void)const
{
	return ObjID;
}

class CBLContextInternalData *  CDelegate::GetInternalData(void)
{
	return CBLContext::GetInternalData();
}




long  CDelegate::GetTypeID(void)const
{
	return 100;
}

char const *  CDelegate::GetTypeString(void)const
{
	return "Delegate";
}

class CType   CDelegate::GetValueType(void)const
{
	CType tType(100);
	
	return tType;
}


void  CDelegate::IncrRef(void)
{
	CBLContext::IncrRef();
}

void  CDelegate::InitObject(class CType const & tType)
{
	CBLContext::InitObject(tType);
}

void  CDelegate::InitObject(char const * strName)
{
	CBLContext::InitObject(strName);
}

int  CDelegate::IsExactValue(void)const
{
	return 0;
}

int  CDelegate::IsOleContext(void)const
{
	return 0;
}

int  CDelegate::IsPropReadable(int iPropNum)const
{
	return 1;
}

int  CDelegate::IsPropWritable(int iPropNum)const
{
	return 1;
}

int  CDelegate::IsSerializable(void)
{
	return 0;
}

int  CDelegate::SaveToString(class CString & csStr)
{
	csStr = "DJK";
	return 1;
}

void  CDelegate::SelectByID(class CObjID cID,long lNum)
{
	CBLContext::SelectByID(cID,lNum);
}


int  CDelegate::GetNProps(void)const
{
	return 0;
}

char const *  CDelegate::GetPropName(int A,int B)const
{
	return NULL;
}

int  CDelegate::GetPropVal(int iPropNum,class CValue & rValue)const
{
	return -1;
}

int  CDelegate::SetPropVal(int iPropNum,class CValue const & vValue)
{
	return -1;
}

int  CDelegate::FindProp(char const * Name)const
{
	return -1;
}

int CDelegate::GetNParamsOfDelegate()
{
  return m_nCountParams;
}

int CDelegate::IsDelagateRetVal()
{
  return m_IsFunc;
}

bool CDelegate::IsEmpty()
{
  return m_ListOfHandlers.empty();
}

