// FormEx.cpp: implementation of the CEnviromentContext class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Service.h"
#include "AttribEx.h"
#include "FormEx.h"
#include "FormExFormView.h"
#include ".\\TurboBL\\gcboost.h"

#define HIMETRIC_INCH 2540

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction TCS_VERTICAL 
//////////////////////////////////////////////////////////////////////

extern CMetaDataCont * pMetaDataCont;
extern CBkEndUI * pBkEndUI;

IMPLEMENT_DYNCREATE_OXY(CFormEx);
extern bool CreateInPlace;
extern CWnd* pWndSpl;

class CObjID CFormEx::ObjID;

struct CFormEx::paramdefs CFormEx::defFnNames[] = {
	{{"AssignForm",""}, FALSE, 1},
	{{"GetForm",""}, TRUE, 0},
	{{"GetNumAttrib",""}, TRUE, 0},
	{{"GetAttrib",""}, TRUE, 1},
	{{"ObjectType",""}, TRUE, 0},
	{{"FullObjectType",""}, TRUE, 0},
	{{"FullPath",""}, TRUE, 0},
	{{"FixMultiLine",""}, FALSE, 1},
	{{"AddAttrib",""}, TRUE, 1},
	{{"GetAttribAtPos",""}, TRUE, 2},
	{{"AddToolBarsButton",""}, FALSE, 0},
	{{"FindAttrib",""}, TRUE, 2},
	{{"GetNextAttrib",""}, TRUE, 0},
	{{"CurrentAttrib",""}, TRUE, 0},
	{{"GetPicture",""}, TRUE, 4},
	{{"HighlightTabItem",""}, FALSE, 2},
	{{"AddTabImages",""}, TRUE, 1},
	{{"RefreshTabImages",""}, FALSE, 0},
	{{"DisableCloseFormByButton",""}, TRUE, 1},
	{{"Refresh",""}, FALSE, 0},
	{{"ColourTable",""}, FALSE, 1},
	{{"AttachForm",""}, TRUE, 7},
	{{"DetachForm",""}, FALSE, 0},
	{{"TableColumnPosition",""}, FALSE, 3},
	{{"SetAutoAdjustTable",""}, FALSE, 2},
	{{"AttachFormToAttrib",""}, TRUE, 7},
	{{"AddFormTab",""}, FALSE, 0},
	{{"BeginDirectEnter",""}, FALSE, 3},
	{{"EndDirectEnter",""}, FALSE, 1},
	{{"Test",""}, TRUE, 2},
	{NULL,0,0}
};

struct CFormEx::parampropdefs CFormEx::defPropNames[] = {
	{{"Height",""}, TRUE, TRUE, NULL},
	{{"Width",""}, TRUE, TRUE, NULL},
	{{"Maximize",""}, TRUE, TRUE, NULL},
	{NULL,0,0, NULL}
};

CFormEx::CFormEx():CBLContext()
{
	m_pTableCtrl = NULL;
	m_pWorkCtrl = NULL;
	m_pWorkField = NULL;
	m_pTable = NULL;
	m_curCol = 0;
	m_curRow = 0;

	CurrentAtr = -1;
	KindOfSelection = -1;
	m_Form = NULL;

	CBLModule* pMod = CBLModule::GetExecutedModule();
  CGroupContext * pCont = (CGroupContext*)CBLModuleWrapper::GetContextFromModule(pMod);
	if(pCont)
	{
		int n = pCont->FindProp("");
		if(n>=0)
		{
			CValue valForm;
			pCont->GetPropVal(n,valForm);
			CBLContext* pFormCont = valForm.GetContext();
			if(pFormCont) if(!strcmp(pFormCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
			{
				m_Form = (CFormAllCtrlsContext*)pFormCont;
				m_Form->IncrRef();
			}
		}
	}
}

CFormEx::~CFormEx()
{
	m_pTableCtrl = NULL;
	m_pWorkCtrl = NULL;
	m_pWorkField = NULL;
	m_pTable = NULL;
	m_curCol = 0;
	m_curRow = 0;

	if(m_Form) m_Form->DecrRef();
	m_Form = NULL;
}

int  CFormEx::CallAsFunc(int iMethNum,class CValue & rValue,class CValue **ppValue)
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}

	switch (iMethNum) {
	case methGetForm:
		{
			rValue.AssignContext(m_Form);
			break;
		}
	case methGetNumAttrib:
		{
			rValue = (long)m_Form->m_GetDoc->m_Array.GetSize();
			break;
		}
	case methGetAttrib:
		{
			int n;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
			n = -1;
			if(ppValue[0]->buf0[2] == 2)
			{
				if((ppValue[0]->GetString().CompareNoCase("") == 0) ||
					(ppValue[0]->GetString().CompareNoCase("MULTYCOLUMN") == 0))
				{
					n = -2;
				}
				else
				{
				char* str = (char*)(LPCSTR)ppValue[0]->GetString();
				for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
				{
					CGetField* pGetField = pGetFieldsArray->GetAt(i);
					char* pCodeName = (char*)pGetField->GetCtrlInfo()->GetCodeName();
					if(!strcmp(str,pCodeName)) n = i;
				}
				if(n<0)
				{
					CBLModule::RaiseExtRuntimeError("  ",0);
					return S_FALSE;
				}
			}
			}
			else if(ppValue[0]->buf0[2] == 1)
			{
				n = ppValue[0]->GetNumeric();
			}
			if(((pGetFieldsArray->GetSize() <= n) || (n<0)) && (n != -2))
			{
				CBLModule::RaiseExtRuntimeError("  ",0);
				return S_FALSE;
			}
			CAttribEx* pAttrExCont;
			pAttrExCont = new CAttribEx;
			pAttrExCont->m_Form = m_Form;
			m_Form->IncrRef();
			pAttrExCont->num = n;

			rValue.AssignContext(pAttrExCont);
			pAttrExCont->DecrRef();
			break;
		}
		case methAddAttrib:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;

			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
			UINT CtrlID = 0;
			int n = pGetFieldsArray->GetSize();
			for(int i = 0;i<n;i++) if(CtrlID < pGetFieldsArray->GetAt(i)->GetCtrlID())
				CtrlID = pGetFieldsArray->GetAt(i)->GetCtrlID();
			CtrlID++;
			CGetField* pGetField = pGetFieldsArray->NewItem();
			CControlID* pControlID;
			pControlID = new CControlID(*pGetField->GetCtrlInfo());

			pGetField->SetDoc(pDoc);
			pGetField->SetCtrlID(CtrlID);
			
			pGetField->SetCtrlInfo(pControlID);
			UINT CtrlType = ppValue[0]->GetNumeric();
			pControlID->SetCtrlType(CtrlType);
			pControlID->SetCtrlID(CtrlID);
			pControlID->SetExStyle(0);

			switch(CtrlType)
			{
			case 1://STATIC ()
				{
					pControlID->SetStyle(0x50020201);
					break;
				}
			case 2://1CEDIT ( )
				{
					pControlID->SetStyle(0x50820000);
					pControlID->SetExStyle(0x220);
					break;
				}
			case 3://BUTTON ()
				{
					pControlID->SetStyle(0x5002000B);
					break;
				}
			case 4://1CGROUPBOX ( )
				{
					pControlID->SetStyle(0x50020007);
					break;
				}
			case 5://1CEDIT (   )
				{
					pControlID->SetStyle(0x50000000);
					break;
				}
			case 8://  !!! //SysTreeView32 ( )
				{
					pControlID->SetStyle(0x50A20007);
					break;
				}
			case 9://  !!! //STATIC (       )
				{
					pControlID->SetStyle(0x50000000);
					pControlID->SetExStyle(0x10004000);
					break;
				}
			case 10://PICTURE ()
				{
					pControlID->SetStyle(0x5002800B);
					pControlID->SetExStyle(0x800);
					break;
				}
			case 11://LISTBOX ()
				{
					pControlID->SetStyle(0x50A20101);
					break;
				}
			case 12://CHECKBOX ()
				{
					pControlID->SetStyle(0x50020003);
					break;
				}
			case 13://RADIO ()
				{
					pControlID->SetStyle(0x50020009);
					break;
				}
			case 14://COMBOBOX (  )
				{
					pControlID->SetStyle(0x50A20043);
					break;
				}
			case 15://TABLE ()
				{
					pControlID->SetStyle(0x50A20000);
					break;
				}
			default: 
				{
					pControlID->SetStyle(0x5002000b);
				}
			};
			pControlID->SetLongID(-1);
			pControlID = NULL;
			CRect rect(0,0,20,10);
			//pControlID->SetPlace(rect);

			if(pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				pDoc->CreateControl(pGetField,CtrlType,rect,pView,pControlID->GetStyle(),pControlID->GetExStyle());
				//pDoc->LayoutControl(pView,pGetField);
			}
			pDoc->LinkAllFormEdits();

			CAttribEx* pAttrExCont;
			pAttrExCont = new CAttribEx;
			pAttrExCont->m_Form = m_Form;
			m_Form->IncrRef();
			pAttrExCont->num = n;

			rValue.AssignContext(pAttrExCont);
			pAttrExCont->DecrRef();
			break;
		}
	case methObjectType:
		{
			CGetDoc77* pDoc = (CGetDoc77*)m_Form->m_GetDoc;
			if(pDoc->buf2[70])
			{
				char* str = (char*)(*((BYTE**)(*((BYTE**)(pDoc->buf2[70])+21))+2));
				int ObjNum = CConfigCont::PathToID(str);
				str = (char*)pMetaDataCont->GetFullName(ObjNum,0,1);
				char* str0 = str;
				while((*str0!='.') && (*str0!=0)) *str0++;
				strcpy(str0,"\0");
				rValue = str;
			}
			else
			{
				rValue = "";
			};
			break;
		}
	case methFullObjectType:
		{
			CGetDoc77* pDoc = (CGetDoc77*)m_Form->m_GetDoc;
			if(pDoc->buf2[70])
			{
				char* str = (char*)(*((BYTE**)(*((BYTE**)(pDoc->buf2[70])+21))+2));
				int ObjNum = CConfigCont::PathToID(str);
				rValue = (char*)pMetaDataCont->GetFullName(ObjNum,0,1);
			}
			else
			{
				rValue = "";
			}
			break;
		}
	case methFullPath:
		{
			CGetDoc77* pDoc = (CGetDoc77*)m_Form->m_GetDoc;
			if(pDoc->buf2[70])
			{
				rValue = (char*)(*((BYTE**)(*((BYTE**)(pDoc->buf2[70])+21))+2));
			}
			else
			{
				rValue = "";
			}
			break;
		}
	case methGetAttribAtPos:
		{
			rValue = 0L;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if(pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CWnd* pView = (/*CFormView*/CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView == NULL)
					pView = pDoc->GetFrame();

				if(pView)
				{
					POINT point;
					point.x = ppValue[0]->GetNumeric();
					point.y = ppValue[1]->GetNumeric();
					CWnd* pWnd = pView->ChildWindowFromPoint(point, CWP_SKIPINVISIBLE | CWP_SKIPTRANSPARENT);
					if((pWnd != NULL)
						&& (strcmp(pWnd->GetRuntimeClass()->m_pfnGetBaseClass()->m_lpszClassName,"CBrowseView7")))
					{
						CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
						if(pGetFieldsArray)
						{
							UINT DlgCtrlID = pWnd->GetDlgCtrlID();
							int n = -1;
							for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
							{
								CGetField* pGetField = pGetFieldsArray->GetAt(i);
								if(pGetField->GetCtrlID() == DlgCtrlID) n = i;
							}
							if(n >= 0)
							{
								CAttribEx* pAttrExCont;
								pAttrExCont = new CAttribEx;
								pAttrExCont->m_Form = m_Form;
								m_Form->IncrRef();
								pAttrExCont->num = n;

								rValue.AssignContext(pAttrExCont);
								pAttrExCont->DecrRef();
							}
						}
					}
				}
			}
			break;
		}
	case methFindAttrib:
		{
			rValue = 0L;
			KindOfSelection = ppValue[0]->GetNumeric();
			Selection = *ppValue[1];
			CurrentAtr = 0;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
			if(pGetFieldsArray)
			{
				for(int i = CurrentAtr; i<pGetFieldsArray->GetSize(); i++)
				{
					CGetField* pGetField = pGetFieldsArray->GetAt(i);
					CControlID* pControlID = pGetField->GetCtrlInfo();
					switch (KindOfSelection)
					{
					case selType:
						{
							if(pControlID->GetCtrlType() == Selection.GetNumeric())
							{
								rValue = 1L;
								CurrentAtr = i;
							}
							break;
						}
					case selCaption:
						{
							if(!strcmp(pControlID->GetTitle(),Selection.GetString()))
							{
								rValue = 1L;
								CurrentAtr = i;
							}
							break;
						}
					case selVisible:
						{
							int IsVis = 0;
							if(((CFormCtrl*)pGetField)->m_RefFlag==0)
							{
								unsigned long lStyleEx = pControlID->GetExStyle();
								IsVis = (lStyleEx & CS_EX_VISIBLE);
							}
							else
							{
								IsVis = ((CFormCtrl*)pGetField)->m_Visible;
							}
							if(IsVis == Selection.GetNumeric())
							{
								rValue = 1L;
								CurrentAtr = i;
							}
							break;
						}
					case selReadOnly:
						{
							if(pGetField->GetReadOnly() == !Selection.GetNumeric())
							{
								rValue = 1L;
								CurrentAtr = i;
							}
							break;
						}
					case selLayer:
						{
							if(!strcmp(pControlID->GetLayerName(),Selection.GetString()))
							{
								rValue = 1L;
								CurrentAtr = i;
							}
							break;
						}
					};
					if(rValue == 1L)
						break;
				}
			}
			if(rValue == 0L)
			{
				KindOfSelection = -1;
				CurrentAtr = -1;
			}
			break;
		}
	case methGetNextAttrib:
		{
			rValue = 0L;
			if(KindOfSelection>0)
			{
				CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
				CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
				if(pGetFieldsArray)
				{
					if(CurrentAtr<0) CurrentAtr = 0;
					else CurrentAtr++;
					for(int i = CurrentAtr; i<pGetFieldsArray->GetSize(); i++)
					{
						CGetField* pGetField = pGetFieldsArray->GetAt(i);
						CControlID* pControlID = pGetField->GetCtrlInfo();
						switch (KindOfSelection)
						{
						case selType:
							{
								if(pControlID->GetCtrlType() == Selection.GetNumeric())
								{
									rValue = 1L;
									CurrentAtr = i;
								}
								break;
							}
						case selCaption:
							{
								if(!strcmp(pControlID->GetTitle(),Selection.GetString()))
								{
									rValue = 1L;
									CurrentAtr = i;
								}
								break;
							}
						case selVisible:
							{
								int IsVis = 0;
								if(((CFormCtrl*)pGetField)->m_RefFlag==0)
								{
									unsigned long lStyleEx = pControlID->GetExStyle();
									IsVis = (lStyleEx & CS_EX_VISIBLE);
								}
								else
								{
									IsVis = ((CFormCtrl*)pGetField)->m_Visible;
								}
								if(IsVis == Selection.GetNumeric())
								{
									rValue = 1L;
									CurrentAtr = i;
								}
								break;
							}
						case selReadOnly:
							{
								if(pGetField->GetReadOnly() == !Selection.GetNumeric())
								{
									rValue = 1L;
									CurrentAtr = i;
								}
								break;
							}
						case selLayer:
							{
								if(!strcmp(pControlID->GetLayerName(),Selection.GetString()))
								{
									rValue = 1L;
									CurrentAtr = i;
								}
								break;
							}
//						default:
//							return S_FALSE;
						};
						if(rValue == 1L)
							break;
					}
				}
				if(rValue == 0L)
				{
					KindOfSelection = -1;
					CurrentAtr = -1;
				}
			}
			break;
		}
	case methCurrentAttrib:
		{
			if(CurrentAtr>=0)
			{
				CAttribEx* pAttrExCont;
				pAttrExCont = new CAttribEx;
				pAttrExCont->m_Form = m_Form;
				m_Form->IncrRef();
				pAttrExCont->num = CurrentAtr;

				rValue.AssignContext(pAttrExCont);
				pAttrExCont->DecrRef();
			}
			break;
		}
	case methGetPicture:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;

			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);

				if(pView)
				{
					CBitmap 	bitmap;
					CWindowDC	dc(pView);
					CDC 		memDC;
					CRect		rect;

					memDC.CreateCompatibleDC(&dc);
					rect.left = ppValue[0]->GetNumeric();
					rect.top = ppValue[1]->GetNumeric();
					rect.right = rect.left + ppValue[2]->GetNumeric();
					rect.bottom = rect.top + ppValue[3]->GetNumeric();
					rect.left += 2;
					rect.top +=2;

					bitmap.CreateCompatibleBitmap(&dc, rect.Width(),rect.Height() );
					
					CBitmap* pOldBitmap = memDC.SelectObject(&bitmap);
					memDC.BitBlt(0, 0, rect.Width(),rect.Height(), &dc, rect.left, rect.top, SRCCOPY); 

					IPictureDisp *pPic=NULL;
					PICTDESC pd;
					pd.cbSizeofstruct = sizeof(PICTDESC);
					pd.picType = PICTYPE_BITMAP;
					pd.bmp.hbitmap = HBITMAP(bitmap);
					::OleCreatePictureIndirect(&pd, IID_IPictureDisp, TRUE, (VOID**)&pPic);
					char TMPbuf[_MAX_PATH];
					int res = ::GetEnvironmentVariable("TEMP", TMPbuf, _MAX_PATH);
					strcpy(TMPbuf+res,"\\piFormEx.bmp\0");
					CString TMPstr = TMPbuf;

					if(pPic != NULL)
					{
						::OleSavePictureFile(pPic, TMPstr.AllocSysString());
						pPic->Release();
					};

					CBLContext* rCont = CBLContext::CreateInstance("Picture");
					int nMeth = rCont->FindMethod("Load");
					CValue** lArray = new PValueT[1];
					lArray[0] = (CValue*)malloc(sizeof(CValue));
					lArray[0]->CValue::CValue();
					*lArray[0] = TMPstr;
					if( nMeth >=0 ) rCont->CallAsProc(nMeth,lArray);
					lArray[0]->CValue::~CValue();
					free(lArray[0]);
					delete[] lArray;


					rValue.AssignContext(rCont);
					CFile::Remove(TMPstr);

					memDC.SelectObject(pOldBitmap);
				}
			}
			break;
		}
	case methAddTabImages:
		{
			rValue = 0L;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd * pView = pDoc->GetFrame();
				if(pView)
				{
					CWnd * pWnd = pView->GetWindow(GW_CHILD);
					while(pWnd)
					{
						if(!strcmp(pWnd->GetRuntimeClass()->m_lpszClassName,"CTabCtrl"))
							break;
						pWnd = pWnd->GetNextWindow();
					}
					if(pWnd)
					{
						CGalleryHolder * pGalleryHolder = CGalleryHolder::GetGallery();
						if(pGalleryHolder)
						{
							ULONG picID = pGalleryHolder->FindByAlias(ppValue[0]->GetString());
							if(picID)
							{
								CPictureHolder7 * pic;
								pic = new CPictureHolder7(pGalleryHolder->GetPicture(picID));

								CBitmap bitmap;
								BOOL bResult = FALSE;
								CDC dcMem;
								CDC* pDC = CWnd::GetDesktopWindow()->GetDC();

								if (dcMem.CreateCompatibleDC(pDC))
								{
									CSize hmSize = pic->GetSize();

									CBitmap bmMem;

									if (bmMem.CreateCompatibleBitmap(pDC, hmSize.cx, 16))
									{
										CBitmap* pOldBM = dcMem.SelectObject(&bmMem);

										dcMem.FillSolidRect(0, 0, hmSize.cx, 16, RGB(0x00,0x80,0x80));
										RECT rect1;
										RECT rect2;
										rect1.top = rect1.left = 0;
										rect1.right = hmSize.cx;
										if(hmSize.cy<16) rect1.bottom = hmSize.cy;
										else rect1.bottom = 16;
										
										pic->Render(dcMem, rect1, 0, &rect2);

										bResult = bitmap.Attach(bmMem.Detach());

										dcMem.SelectObject(pOldBM);
									}
								}

								CWnd::GetDesktopWindow()->ReleaseDC(pDC);
								if(bResult)
								{
									CTabCtrl* pTabCtrl = (CTabCtrl*)pWnd;
									CImageList* pImageList;
									pImageList = pTabCtrl->GetImageList();
									if(pImageList == NULL)
									{
										pImageList = new CImageList;
										pImageList->Create(16, 16, ILC_MASK, 6, 0);
										pTabCtrl->SetImageList(pImageList);
									}
									pImageList->Add(&bitmap, RGB(0x00,0x80,0x80));
									
									TCITEM TabCtrlItem;
									TabCtrlItem.pszText = (char*)malloc(200);
									TabCtrlItem.cchTextMax = 200;
									TabCtrlItem.mask = TCIF_IMAGE | TCIF_TEXT;
									for(int it = 0; it < pTabCtrl->GetItemCount(); it ++)
									{
										if(it < pImageList->GetImageCount())
										{
											pTabCtrl->GetItem(it, &TabCtrlItem);
											TabCtrlItem.iImage = it;
											TabCtrlItem.mask = TCIF_IMAGE | TCIF_TEXT;
											pTabCtrl->SetItem(it, &TabCtrlItem);
										}
									}
									free(TabCtrlItem.pszText);

									rValue = 1L;
								}
								delete pic;
							}
						}
					}
				}
			}
			break;
		}		
	case methDisableCloseForm:
		{
			rValue = 0L;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd * pView = pDoc->GetFrame();
				if(pView)
				{
					HMENU hMenu = ::GetSystemMenu(pView->GetSafeHwnd(),FALSE);
					if(hMenu)
					{
						if(::GetMenuState(hMenu, SC_CLOSE, MF_BYCOMMAND) == 0xFFFFFFFF)
							rValue = 1L;
						if((ppValue[0]->GetNumeric() == 0) && (rValue.GetNumeric() == 1))
							::GetSystemMenu(pView->GetSafeHwnd(),TRUE);
						else
						if((ppValue[0]->GetNumeric() == 1) && (rValue.GetNumeric() == 0))
							::DeleteMenu(hMenu, SC_CLOSE, MF_BYCOMMAND);
					}
				}
			}
			break;
		}
	case methAttachForm:
		{
			rValue = 0L;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd* pView = pDoc->GetFrame();

				if(pView)
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CFormView* pFView0 = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
					if(pFView0)
					{
						if(!strcmp(pFView0->GetParent()->GetRuntimeClass()->m_lpszClassName,"CFormExFormView"));
						else
						{
							CSplitterWnd* pSWnd;
							pSWnd = new CSplitterWnd();
							BOOL bResult = FALSE;
							int n = ppValue[0]->GetNumeric();
							int DlgCtrlID0;
							int DlgCtrlIDex;
							SIZE sizeInit;
							sizeInit.cx = 200;
							sizeInit.cy = 200;

							CFormExFormView* pPane0 = NULL;
							CFormExFormView* pPane1 = NULL;
							if(n & 1)
							{
								if(bResult = pSWnd->CreateStatic(pView,2,1,WS_CHILD | WS_VISIBLE | SPLS_DYNAMIC_SPLIT))
								{
									pSWnd->CreateView(0,0,RUNTIME_CLASS(CFormExFormView), sizeInit,NULL);
									pSWnd->CreateView(1,0,RUNTIME_CLASS(CFormExFormView), sizeInit,NULL);
									if(n & 2)
									{
										DlgCtrlID0 = 0xE910;
										DlgCtrlIDex = 0xE900;
										pPane0 = (CFormExFormView*)pSWnd->GetPane(1,0);
										pPane1 = (CFormExFormView*)pSWnd->GetPane(0,0);
									}
									else
									{
										DlgCtrlID0 = 0xE900;
										DlgCtrlIDex = 0xE910;
										pPane0 = (CFormExFormView*)pSWnd->GetPane(0,0);
										pPane1 = (CFormExFormView*)pSWnd->GetPane(1,0);
									}
								}
							}
							else
							{
								if(bResult = pSWnd->CreateStatic(pView,1,2,WS_CHILD | WS_VISIBLE | SPLS_DYNAMIC_SPLIT))
								{
									pSWnd->CreateView(0,0,RUNTIME_CLASS(CFormExFormView), sizeInit,NULL);
									pSWnd->CreateView(0,1,RUNTIME_CLASS(CFormExFormView), sizeInit,NULL);
									if(n & 2)
									{
										DlgCtrlID0 = 0xE901;
										DlgCtrlIDex = 0xE900;
										pPane0 = (CFormExFormView*)pSWnd->GetPane(0,1);
										pPane1 = (CFormExFormView*)pSWnd->GetPane(0,0);
									}
									else
									{
										DlgCtrlID0 = 0xE900;
										DlgCtrlIDex = 0xE901;
										pPane0 = (CFormExFormView*)pSWnd->GetPane(0,0);
										pPane1 = (CFormExFormView*)pSWnd->GetPane(0,1);
									}
								}
							}
							if(bResult)
							{
								pPane0->m_tabctrl = ((CTabFrame*)pView)->GetTabControl();
								pPane0->m_ctrlbar = ((CTabFrame*)pView)->GetControlBar(0);
								CWnd* pWnd = pView->GetWindow(GW_CHILD);
								while(pWnd)
								{
									if(CString("CToolBar7") == pWnd->GetRuntimeClass()->m_lpszClassName)
										pPane0->m_ctrlbar = pWnd;
									pWnd->SetParent(pPane0);
									pWnd = pView->GetWindow(GW_CHILD);
									if(pWnd == pSWnd)
										pWnd = pWnd->GetNextWindow();
								}
								pPane0->m_frame = (CFrameWnd*)pView;
								pPane0->m_parentframe = (CFrameWnd*)pView;
								pPane1->m_parentframe = (CFrameWnd*)pView;
								pPane0->m_doc = (CDocument*)pDoc;
								pPane0->m_view = pFView0;
								pPane0->m_bAttached = false;
								pFView0->SetOwner(pView);

								pWndSpl = NULL;

								CBLContext* pCont2 = ppValue[1]->GetContext();
								bool bNeedOpen = true;
								if(pCont2)
								if(CString("CFormAllCtrlsContext") == pCont2->GetRuntimeClass()->m_lpszClassName)
								{
									bNeedOpen = false;
									CGetDoc7* pDoc2 = (CGetDoc7*)((CFormAllCtrlsContext*)pCont2)->m_GetDoc;
									if(pDoc2)
									if (pDoc2->ExistWindow())
										pWndSpl = pDoc2->GetFrame();
								}

								if(bNeedOpen)
								{
									CreateInPlace=true;
									CBLContext* pGlobal=CBLContext::GetLoadedContext(1);
									int iOF=pGlobal->FindMethod("");
									int colParam=pGlobal->GetNParams(iOF);
									CValue retVal;
									CValue *paramVal[6];
									for(int num=0;num<colParam;num++)
										paramVal[num]=ppValue[num+1];

									pGlobal->CallAsFunc(iOF,retVal,paramVal);
									rValue = retVal;
								}

								if(pWndSpl)
								{
									CDocument* pDoc1 = ((CFrameWnd*)pWndSpl)->GetActiveDocument();
									CFormView* pFView1 = NULL;
									if(pDoc1)
									{
										POSITION aPOS1 = pDoc1->GetFirstViewPosition();
										pFView1 = (CFormView*)pDoc1->GetNextView(aPOS1);
										pPane1->m_doc = pDoc1;
									}

									pPane1->m_tabctrl = ((CTabFrame*)pWndSpl)->GetTabControl();
									pPane1->m_ctrlbar = ((CTabFrame*)pWndSpl)->GetControlBar(0);

									CWnd* pWnd = pWndSpl->GetWindow(GW_CHILD);

									while(pWnd)
									{
										if(CString("CToolBar7") == pWnd->GetRuntimeClass()->m_lpszClassName)
											pPane1->m_ctrlbar = pWnd;
										pWnd->SetParent(pPane1);
										pWnd = pWndSpl->GetWindow(GW_CHILD);
									}
									pPane1->m_frame = (CFrameWnd*)pWndSpl;
									pPane1->m_view = pFView1;
									pPane1->m_bAttached = true;

									if(pFView1)
										pFView1->SetOwner(pWndSpl);
											
									pWndSpl->ShowWindow(SW_HIDE);
									pWndSpl->SetParent(pSWnd);

									pWndSpl = NULL;
									
									if(n & 1)
									{
										pSWnd->SetRowInfo(0, 200, 0);
										pSWnd->SetRowInfo(1, 200, 0);
									}
									else
									{
										pSWnd->SetColumnInfo(0, 200, 0);
										pSWnd->SetColumnInfo(1, 200, 0);
									}
									pSWnd->SetActivePane((DlgCtrlID0&0x00F0)>>4,DlgCtrlID0&0x000F);
									pSWnd->ShowCaret();

									pSWnd->RecalcLayout();
									((CTabFrame*)pView)->RecalcLayout(1);
								}
							}

						}
					}
				}
			}
			break;
		}
	case methAttachFormToAttrib:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));

			CString str = ppValue[0]->GetString();
			bool f = false;
			int ID = 0;
			for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
			{
				CGetField* pGetField = pGetFieldsArray->GetAt(i);
				char* pCodeName = (char*)pGetField->GetCtrlInfo()->GetCodeName();
				if(!str.CompareNoCase(pCodeName)) {f = true; ID = ((CFormCtrl*)pGetField)->m_ID; break;};
			}
			if(f)
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				CWnd* pWnd = NULL;
				CWnd* pFrame = pDoc->GetFrame();
				if(pView)
					pWnd = pView->GetDlgItem(ID);
				else
				{
					CGetDlg* pGetDlg = (CGetDlg*)pFrame;
					if(pGetDlg) pWnd = pGetDlg->GetDlgItem(ID);
				}
				if(pWnd)
				{
					
					CFormExFormView* pPane;
					CRuntimeClass* pRC = RUNTIME_CLASS(CFormExFormView);
					
					pPane = (CFormExFormView*)pRC->CreateObject();
					RECT rect;
					pWnd->GetClientRect(&rect);
					if(pPane->Create(NULL,"",WS_CHILD | WS_VISIBLE | WS_BORDER,rect,pWnd,0xF0F0))
					{
						CreateInPlace=true;
						CBLContext* pGlobal=CBLContext::GetLoadedContext(1);
						int iOF=pGlobal->FindMethod("");
						int colParam=pGlobal->GetNParams(iOF);
						CValue retVal;
						CValue *paramVal[6];
						for(int num=0;num<colParam;num++)
							paramVal[num]=ppValue[num+1];

						pGlobal->CallAsFunc(iOF,retVal,paramVal);
						rValue = retVal;
						if(pWndSpl)
						{
							CDocument* pDoc1 = ((CFrameWnd*)pWndSpl)->GetActiveDocument();
							CFormView* pFView1 = NULL;
							if(pDoc1)
					{
								POSITION aPOS1 = pDoc1->GetFirstViewPosition();
								pFView1 = (CFormView*)pDoc1->GetNextView(aPOS1);
								pPane->m_doc = pDoc1;
							}

							pPane->m_tabctrl = ((CTabFrame*)pWndSpl)->GetTabControl();
							pPane->m_ctrlbar = ((CTabFrame*)pWndSpl)->GetControlBar(0);
							pPane->m_parentframe = (CFrameWnd*)pFrame;
							pPane->m_bToAttrib = true;

							CWnd* pWnd0 = pWndSpl->GetWindow(GW_CHILD);

							while(pWnd0)
							{
								if(CString("CToolBar7") == pWnd0->GetRuntimeClass()->m_lpszClassName)
									pPane->m_ctrlbar = pWnd0;
								pWnd0->SetParent(pPane);
								pWnd0 = pWndSpl->GetWindow(GW_CHILD);
							}
							pPane->m_frame = (CFrameWnd*)pWndSpl;
							pPane->m_view = pFView1;
							pPane->m_bAttached = true;

							if(pFView1) pFView1->SetOwner(pWndSpl);
									
							pWndSpl->ShowWindow(SW_HIDE);
							pWndSpl->SetParent(pPane);

							pPane->MoveWindow(&rect);

							((CTabFrame*)pFrame)->RecalcLayout(1);
						}
					}
				}
			}

			break;
		}
	case methTest:
		{
			break;
		}
	default:
		return S_FALSE;
	};
	return S_OK;
}

int  CFormEx::CallAsProc(int iMethNum,class CValue * * ppValue)
{
	if(!m_Form && iMethNum != methAssignForm)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}
	switch (iMethNum) {
		case methAssignForm:
		{
			CBLContext* pBLCont = ppValue[0]->GetContext();
			if (pBLCont)
			{
				if(!strcmp(pBLCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
				{
					if(m_Form) m_Form->DecrRef();
					m_Form = (CFormAllCtrlsContext*)pBLCont;
					m_Form->IncrRef();
				}
				else
				{
					CBLModule::RaiseExtRuntimeError(" ",0);
					return S_FALSE;
				}
			}
			break;
		}
		case methFixBrowse:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if(pDoc->HasBrowse())
			{
				CBrowse *pBrowse = ((CGetDoc*)pDoc)->GetBrowse();
				if(pBrowse) pBrowse->FixHorz(ppValue[0]->GetNumeric());
				else pBkEndUI->DoMessageLine("     .",mmRedErr);
			}
			else
				pBkEndUI->DoMessageLine("    .",mmRedErr);

			break;
		}
		case methAddTBButton:
		{
			//CTokeniseBox CBLModule7
			//CBLModule * pBLModule = CBLModule::GetExecutedModule();
			//pBLModule->ResetCompiled();
			//pBLModule->Compile();
/*
			int i = 54;
			CString st;
			CString st_res;
			CBLModule::TokenizeSourceLine(" ;  () .();   = (\"\");",
				i,&st);
			st_res.Format("%d :: %d",i, st.GetLength());
			pBkEndUI->DoMessageLine(st_res, mmNone);
			pBkEndUI->DoMessageLine(st, mmNone);
*/
			break;

			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd * pView = pDoc->GetFrame();;
				CWnd * pWnd = pView->GetWindow(GW_CHILD);
				CToolBar7* pTB = NULL;
				while(pWnd)
				{
					if(!strcmp(pWnd->GetRuntimeClass()->m_lpszClassName,"CToolBar7"))
						pTB = (CToolBar7*)pWnd;
					pWnd = pWnd->GetNextWindow();
				}

				if(pTB)
				{
					/*
					CToolBar7
					SECCustomToolBar
					SECControlBar
					CControlBar
					*/
					//CToolBar7* pTB = (CToolBar7*)pWnd;

					CString st;
					CRect rc(0,0,0,0);
					CPtrArray * mPtrArray = NULL;
					mPtrArray = (CPtrArray*)((int*)pTB+101);
					int count = mPtrArray->GetSize();
					pTB->GetItemRect(count - 1, rc);
					CRect rcBtn(rc.right,rc.top,2*rc.right - rc.left,rc.bottom);

					/*
					CBitmapButton * pBtn;
					pBtn = new CBitmapButton;
					pBtn->Create("Test",WS_CHILD | WS_VISIBLE,rcBtn, pTB, 0xF0F0);
					pBtn->EnableWindow();
					*/

					SECStdBtn * pStdBtn = SECStdBtn::CreateButton();
					if(pStdBtn)
					{
						pStdBtn->SetToolBar(pTB);
						mPtrArray->Add(pStdBtn);
					}
					else
						pBkEndUI->DoMessageLine("ERROR!", mmNone);

//					st.Format("%d,%d - %d,%d", rc.left, rc.top, rc.right, rc.bottom);
//					pBkEndUI->DoMessageLine(st, mmNone);

					//rc.bottom += 100;
					//rc.left += 100;
/*
					rc.bottom = 100;
					rc.right = 200;
					rc.left = 150;
					rc.top = 5;
					CComboBox * m_ComboBox;

					m_ComboBox = new CComboBox;
					m_ComboBox->Create( WS_CHILD | WS_VISIBLE | WS_TABSTOP | 
									 WS_VSCROLL | CBS_AUTOHSCROLL | CBS_DROPDOWN, 
									 rc, pTB, 3001);

					//  
					m_ComboBox->AddString( " 1" ); 
					m_ComboBox->AddString( " 2" );
					m_ComboBox->SetCurSel(0);
*/

 				}
			}

			break;
		}
		case methHighlightTabItem:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd * pView = pDoc->GetFrame();
				if(pView)
				{
					bool f = false;
					CWnd * pWnd = pView->GetWindow(GW_CHILD);
					while(pWnd)
					{
						if(!strcmp(pWnd->GetRuntimeClass()->m_lpszClassName,"CTabCtrl"))
						{
							f = true;
							break;
						}
						pWnd = pWnd->GetNextWindow();
					}
					if(f)
					{
						CTabCtrl* pTabCtrl = (CTabCtrl*)pWnd;
						if((pTabCtrl->GetItemCount() >= ppValue[0]->GetNumeric()) &&
							(ppValue[0]->GetNumeric() > 0))
						{
							pTabCtrl->HighlightItem(int(ppValue[0]->GetNumeric()) - 1, ppValue[1]->GetNumeric() == 1);
						}
					}
				}
			}
			break;
		}
		case methRefreshTabImages:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				CWnd * pView = pDoc->GetFrame();
				if(pView)
				{
					bool f = false;
					CWnd * pWnd = pView->GetWindow(GW_CHILD);
					while(pWnd)
					{
						if(!strcmp(pWnd->GetRuntimeClass()->m_lpszClassName,"CTabCtrl"))
						{
							f = true;
							break;
						}
						pWnd = pWnd->GetNextWindow();
					}
					if(f)
					{
						CTabCtrl* pTabCtrl = (CTabCtrl*)pWnd;
						CImageList* pImageList;
						pImageList = pTabCtrl->GetImageList();
						if(pImageList)
						{
							TCITEM TabCtrlItem;
							for(int it = 0; it < pTabCtrl->GetItemCount(); it ++)
							{
								if(it < pImageList->GetImageCount())
								{
									pTabCtrl->GetItem(it, &TabCtrlItem);
									TabCtrlItem.iImage = it;
									TabCtrlItem.mask |= TCIF_IMAGE;
									pTabCtrl->SetItem(it, &TabCtrlItem);
								}
							}
						}
					}
				}
			}
			break;
		}
		case methRefresh:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
					pView->RedrawWindow();
				else
				{
					CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
					if(pGetDlg)
						pGetDlg->RedrawWindow();
				}
			}
			break;
		}
		case methColourTable:
		{
			if(ppValue[0]->buf0[2] == 2)
			{
				if((ppValue[0]->GetString().CompareNoCase("") == 0) ||
					(ppValue[0]->GetString().CompareNoCase("MultiColumn") == 0))
				{
					CGetDoc* pDoc = (CGetDoc*)m_Form->m_GetDoc;
					if(pDoc)
					{
						CBrowse* pBrowse = pDoc->GetBrowse();
						if(pBrowse)
						{
							CDocument* pDocBr = (CDocument*)*((int*)pBrowse+0x10);
							if(pDocBr)
								((int)pDocBr->m_bAutoDelete) = 2;
						}
					}
				}
			}
			else
			{
				CBLContext* pContT = ppValue[0]->GetContext();
				if(pContT)
				{
          if(pContT->m_FlagAutoDestroy > 100) 
          {
            CGCBoost::SGCInfo* pInfo = (CGCBoost::SGCInfo*)pContT->m_FlagAutoDestroy;
            pInfo->m_nTableSkipper = 2;
          }
          else
          {
            pContT->m_FlagAutoDestroy = 2;
          }
				}
			}
			break;
		}
		case methDetachForm:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			if(pDoc->ExistWindow())
				{
				CWnd* pFrame = pDoc->GetFrame();
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pFView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pFView)
					{
					CWnd* pParent1 = pFView->GetParent();
					if(pParent1)
					if(CString("CFormExFormView") == pParent1->GetRuntimeClass()->m_lpszClassName)
						{
						CWnd* pAFrame = NULL;
						CWnd* pParent0 = pParent1->GetParent();
						CWnd* pWnd = NULL;
						if(pParent0)
							{
							pWnd = pParent0->GetWindow(GW_CHILD);
							while(pWnd)
									{
								if(CString("CFormExFormView") != pWnd->GetRuntimeClass()->m_lpszClassName)
										{
									pAFrame = pWnd;
									pWnd = NULL;
											}
											else
									pWnd = pWnd->GetNextWindow();
											}
										}
						if(pAFrame)
						{
							CSplitterWnd* pSWnd = (CSplitterWnd*)pParent0;
							CFormExFormView* pPane0 = (CFormExFormView*)pSWnd->GetPane(0,0);
							CFormExFormView* pPane1 = (CFormExFormView*)pSWnd->GetPane((pSWnd->GetRowCount())-1, (pSWnd->GetColumnCount())-1);
							if(pPane0->m_bAttached)
										{
								pWnd = pPane0->GetWindow(GW_CHILD);
								while(pWnd)
											{
									pWnd->SetParent(pAFrame);
									pWnd = pPane0->GetWindow(GW_CHILD);
											}
								pWnd = pPane1->GetWindow(GW_CHILD);
								while(pWnd)
											{
									pWnd->SetParent(pFrame);
									pWnd = pPane1->GetWindow(GW_CHILD);
											}
										}
							else
										{
								pWnd = pPane1->GetWindow(GW_CHILD);
								while(pWnd)
											{
									pWnd->SetParent(pAFrame);
									pWnd = pPane1->GetWindow(GW_CHILD);
											}
								pWnd = pPane0->GetWindow(GW_CHILD);
								while(pWnd)
											{
									pWnd->SetParent(pFrame);
									pWnd = pPane0->GetWindow(GW_CHILD);
								}
							}
							pAFrame->SetParent(pFrame->GetParent());
							delete pSWnd;
							pAFrame->SendMessage(WM_CLOSE);
							((CTabFrame*)pFrame)->RecalcLayout(1);
						}
					}
				}
			}
			break;
		}
		case methTableColumnPosition:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));

			CString str = ppValue[0]->GetString();
			bool f = false;
			int ID = 0;
			for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
			{
				CGetField* pGetField = pGetFieldsArray->GetAt(i);
				char* pCodeName = (char*)pGetField->GetCtrlInfo()->GetCodeName();
				if(str == pCodeName) {f = true; ID = ((CFormCtrl*)pGetField)->m_ID;};
			}
			if(f)
			{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd* pWnd = NULL;
					if(pView)
						pWnd = pView->GetDlgItem(ID);
					else
					{
						CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
						if(pGetDlg) pWnd = pGetDlg->GetDlgItem(ID);
					}
					if(pWnd)
					{
					if(CString("CBrowse") == pWnd->GetRuntimeClass()->m_lpszClassName)
					{
						CColumn &col = ((CBrowse*)pWnd)->GetColumnN(ppValue[1]->GetNumeric());
						int* adr = (int*)(&col)+0x0f;
						(*adr) = ppValue[2]->GetNumeric();
						if((*adr) == 2)
						{
							int MHL = ((CBrowse*)pWnd)->GetMaxHeadLines();
							((CBrowse*)pWnd)->SetMaxHeadLines(MHL+1);
						}
						CTabFrame* pView0 = (CTabFrame*)pDoc->GetFrame();
						if(pView0) pView0->RecalcLayout(1);
						pWnd->RedrawWindow();
						}
					}
			}
			break;
		}
		case methSetAutoAdjustTable:
		{
			CString str = ppValue[0]->GetString();
			if((str.CompareNoCase("") == 0) ||
				(str.CompareNoCase("MULTYCOLUMN") == 0))
			{
				CGetDoc* pDoc = (CGetDoc*)m_Form->m_GetDoc;
				CBrowse * pBrowse = pDoc->GetBrowse();
				if(pBrowse) pBrowse->SetAutoAdjust(ppValue[1]->GetNumeric());
			}
			else
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
			bool f = false;
			int ID = 0;
			for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
			{
				CGetField* pGetField = pGetFieldsArray->GetAt(i);
//					char* pCodeName = (char*)pGetField->GetCtrlInfo()->GetCodeName();
					if(str.CompareNoCase(pGetField->GetCtrlInfo()->GetCodeName()) == 0) {f = true; ID = ((CFormCtrl*)pGetField)->m_ID;};
			}
			if(f)
			{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd* pWnd = NULL;
					if(pView)
						pWnd = pView->GetDlgItem(ID);
					else
					{
						CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
						if(pGetDlg) pWnd = pGetDlg->GetDlgItem(ID);
					}
					if(pWnd)
						if(CString("CBrowse") == pWnd->GetRuntimeClass()->m_lpszClassName)
							((CBrowse*)pWnd)->SetAutoAdjust(ppValue[1]->GetNumeric());
				}
			}
			break;
		}
		case methAddFormTab:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
			CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
			if(pView)
			{
				if (pDoc->ExistWindow())
				{
					CWnd * pView0 = pDoc->GetFrame();
					if(pView0)
					{
						RECT rect;
						pView0->GetClientRect(&rect);
						//pView0->ScreenToClient(&rect);
						TabCtrl.Create(WS_VISIBLE | WS_CHILD,rect,pView0,0x3021);

						CWnd * pWnd;
						while(pWnd = pView0->GetWindow(GW_CHILD))
					{
							if(pWnd->GetSafeHwnd() == TabCtrl.GetSafeHwnd())
								break;
							pWnd->SetParent(&TabCtrl);
						}
						
						TC_ITEM tc;
						tc.mask=TCIF_TEXT;
						CString str1="Nomer 1";
						tc.pszText=(LPSTR)(LPCTSTR)str1;
						tc.cchTextMax=str1.GetLength();
						TabCtrl.InsertItem(0,&tc);
						tc.mask=TCIF_TEXT;
						str1="Nomer 2";
						tc.pszText=(LPSTR)(LPCTSTR)str1;
						tc.cchTextMax=str1.GetLength();
						TabCtrl.InsertItem(0,&tc);
					}
				}
			}
			break;
		}
	case methStopDirectEnter:
		{
			if(m_pTableCtrl)
			{
				m_pWorkCtrl->SetDlgCtrlID(m_pTableCtrl->GetDlgCtrlID());
				CValue* pValue;
				pValue = m_pWorkField->GetPValue();
				if(pValue)
				{
					//m_pTable->SetValue(*pValue, m_curCol, m_curRow);
				}
				m_pTableCtrl->DestroyWindow();
				CControlID* pControlID = m_pWorkField->GetCtrlInfo();
				pControlID->SetCodeName(m_WorkCodeName);
			}
			m_pTableCtrl = NULL;
			m_pWorkCtrl = NULL;
			m_pWorkField = NULL;
			m_pTable = NULL;
			m_curCol = 0;
			m_curRow = 0;
			break;
		}
	case methStartDirectEnter:
		{
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CBLContext* pValTableCtrlCont = ppValue[0]->GetContext();
			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));

			if(pValTableCtrlCont)
			{
				CBLContext* pValTableCont = (CBLContext*)*((DWORD*)*((DWORD*)*((DWORD*)pValTableCtrlCont+8)+1)+18);
				DWORD ID = *((DWORD*)*((DWORD*)pValTableCtrlCont+8)+5);
				if(!strcmp(pValTableCont->GetRuntimeClass()->m_lpszClassName,"CValueTableContext"))
				{
					if(pDoc->ExistWindow())
					{
						POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
						CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
						CWnd* pWnd = NULL;
						if(pView)
							pWnd = pView->GetDlgItem(ID);
						else
						{
							CGetDlg* pGetDlg = (CGetDlg*)pDoc->GetFrame();
							if(pGetDlg) pWnd = pGetDlg->GetDlgItem(ID);
						}
						if(pWnd)
						if(CString("CBrowse") == pWnd->GetRuntimeClass()->m_lpszClassName)
						{
							CBrowse* pBrowse = (CBrowse*)pWnd;

							CRect rcItem(0,0,0,0);
							int curCol = (int)*((int*)pBrowse+0x31);
							int curRow = (int)*((int*)pBrowse+0x30);
							if((*((int*)pBrowse+0x23) == 0) && (*((int*)pBrowse+0x2A) >= 0))
								curRow =  (int)*((int*)pBrowse+0x2A);
							pBrowse->GetCellRect(LPRECT(rcItem), curRow,curCol);

							CString str = ppValue[1]->GetString();
							bool f = false;
							CGetField* pGetField;
							for(int i = 0; i<pGetFieldsArray->GetSize(); i++)
							{
								pGetField = pGetFieldsArray->GetAt(i);
								char* pCodeName = (char*)pGetField->GetCtrlInfo()->GetCodeName();
								if(!str.CompareNoCase(pCodeName)) {f = true; ID = ((CFormCtrl*)pGetField)->m_ID; break;};
							}
							if(f)
							{
								pWnd = NULL;
								CWnd* pFrame = pDoc->GetFrame();
								if(pView)
									pWnd = pView->GetDlgItem(ID);
								else
								{
									CGetDlg* pGetDlg = (CGetDlg*)pFrame;
									if(pGetDlg) pWnd = pGetDlg->GetDlgItem(ID);
								}
								if(pWnd)
							{
									CSkipper* pDocBr = pBrowse->pDoc;
									CBLContext* pTblCont = (CBLContext*)*((int**)pDocBr+5);
									CValueTable* pTable = ((CValueTableContextData*)pTblCont->GetInternalData())->GetValueTable();

									//CEditDoc* pEditDoc = (CEditDoc*)m_Form->m_GetDoc->buf5[0x4b];
									//pEditDoc->ScreenToDialog(rcItem);

									CValue value = pTable->GetValue(curCol, curRow);

									CVTColumn* pVTCol = pTable->GetColumn(curCol);
									CType type = pVTCol->GetType();

									pGetField->SetCtrlType(type);
									pGetField->SetPValue(&value);
									pGetField->SetInternalValue(type);

									CControlID* pControlID = pGetField->GetCtrlInfo();
									pControlID->SetValType(type);
									pControlID->SetStyle(0x50000000);
									pControlID->SetExStyle(0);
									pControlID->SetPlace(rcItem);
									pControlID->SetCtrlType(5);

									CString formula;
									formula.Format(".(%d)",ID);
									formula = ppValue[2]->GetString()+formula;

									pControlID->SetFormul(formula);

									CString codename;
									codename = CString((char*)*((int*)*((int*)*((int*)pValTableCtrlCont+8)+6)+11))+"."+pVTCol->GetCode();
									pControlID->SetCodeName(codename);

									pWnd->SetDlgCtrlID(0xF0FF);
									pWnd->ShowWindow(SW_HIDE);

									pGetField->UpdateState();
									CWnd* pNewWnd = pDoc->CreateControl(pGetField,ID,rcItem,pBrowse,0x50000000,0);

									m_pTableCtrl = pNewWnd;
									m_pWorkCtrl = pWnd;
									m_pWorkField = pGetField;
									m_pTable = pTable;
									m_curCol = curCol;
									m_curRow = curRow;
									m_WorkCodeName = str;

								}
							}
							}
						}
					}
				else pBkEndUI->DoMessageLine(" ",mmRedErr);
			}
			break;
		}
		default:
			return S_FALSE;
	};
	return S_OK;
}


int  CFormEx::FindMethod(char const * lpMethodName)const
{
	int i;
	for (i = 0;i<lastMethod;i++){
		if (!stricmp(lpMethodName,defFnNames[i].Names[0]))
			return i;
		if (!stricmp(lpMethodName,defFnNames[i].Names[1]))
			return i;
	}
	return -1;
}

char const *  CFormEx::GetMethodName(int iMethodNum,int iMethodAlias)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].Names[iMethodAlias];
	return 0;
}

int  CFormEx::GetNMethods(void)const
{
	return lastMethod;
}

int  CFormEx::HasRetVal(int iMethodNum)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
	{
		return defFnNames[iMethodNum].HasReturnValue;
	}
	return 0;
}

int CFormEx::GetNParams(int iMethodNum)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].NumberOfParams;
	return 0;
}

int  CFormEx::GetParamDefValue(int iMethodNum,int iParamNum,class CValue * pDefValue)const
{
	switch (iMethodNum) {
	case methDisableCloseForm:
		{
			*pDefValue = -1;
			break;
		}
	case methAttachForm:
		{
			if(iParamNum == 0)
				*pDefValue = 1;
			else
			{
				CBLContext* pGlobal=CBLContext::GetLoadedContext(1);
				int iOF=pGlobal->FindMethod("");
				int colParam=pGlobal->GetNParams(iOF);
				int num = iParamNum-1;
				if(iParamNum <= colParam) pGlobal->GetParamDefValue(iOF,num,pDefValue);
			}
				break;
			}
	case methAttachFormToAttrib:
		{
			if(iParamNum != 0)
			{
				CBLContext* pGlobal=CBLContext::GetLoadedContext(1);
				int iOF=pGlobal->FindMethod("");
				int colParam=pGlobal->GetNParams(iOF);
				int num = iParamNum-1;
				if(iParamNum <= colParam) pGlobal->GetParamDefValue(iOF,num,pDefValue);
			}
			break;
		}
	default:
	return 0;
	};
	return 1;
}

void  CFormEx::DecrRef(void)
{
	CBLContext::DecrRef();
}

char const *  CFormEx::GetCode(void)const
{
	return NULL;
}

int  CFormEx::GetDestroyUnRefd(void)const
{
	return 1;
}

void  CFormEx::GetExactValue(class CValue & vParam)
{
	CBLContext::GetExactValue(vParam);
}

class CObjID   CFormEx::GetID(void)const
{
	return ObjID;
}

class CBLContextInternalData *  CFormEx::GetInternalData(void)
{

	return CBLContext::GetInternalData();

}

long  CFormEx::GetTypeID(void)const
{
	return 100;
}

char const *  CFormEx::GetTypeString(void)const
{
	return "";
}

class CType   CFormEx::GetValueType(void)const
{
	CType tType(100);
	
	return tType;
}

void  CFormEx::IncrRef(void)
{
	CBLContext::IncrRef();
}

void  CFormEx::InitObject(class CType const & tType)
{
	CBLContext::InitObject(tType);
}

void  CFormEx::InitObject(char const * strName)
{
	CBLContext::InitObject(strName);
}

int  CFormEx::IsExactValue(void)const
{
	return 0;
}

int  CFormEx::IsOleContext(void)const
{
	return 0;
}

int  CFormEx::IsPropReadable(int iPropNum)const
{
	if ((iPropNum>=0) && (iPropNum<lastProp))
		return defPropNames[iPropNum].IsReadable;
	return TRUE;
}

int  CFormEx::IsPropWritable(int iPropNum)const
{
	if ((iPropNum>=0) && (iPropNum<lastProp))
		return defPropNames[iPropNum].IsWritable;
	return FALSE;
}

int  CFormEx::IsSerializable(void)
{
	return 0;
}

int  CFormEx::SaveToString(class CString & csStr)
{
	CBLContext::SaveToString(csStr);
	//csStr = "";
	return 1;
}

void  CFormEx::SelectByID(class CObjID cID,long lNum)
{
	CBLContext::SelectByID(cID,lNum);
}

int  CFormEx::GetNProps(void)const
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return 0;
	}
	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
	CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
	return lastProp + pGetFieldsArray->GetSize();
}

char const *  CFormEx::GetPropName(int iPropNum,int iPropAlias)const
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return NULL;
	}

	if ((iPropNum>=0) && (iPropNum<lastProp))
	{
		pBkEndUI->DoMessageLine(defPropNames[iPropNum].Names[iPropAlias], mmNone);
		return defPropNames[iPropNum].Names[iPropAlias];
	}
	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
	CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
	if (iPropNum < (lastProp + pGetFieldsArray->GetSize()))
	{
		CGetField* pGetField = pGetFieldsArray->GetAt(iPropNum - lastProp);
		return pGetField->GetCtrlInfo()->GetCodeName();
	}
	return NULL;
}

int  CFormEx::GetPropVal(int iPropNum,class CValue & rValue)const
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}

	if(iPropNum < 0) return S_FALSE;

	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;

	switch (iPropNum) {
	case propHeight:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CRect wndRect(0,0,0,0);
					pView->GetClientRect(&wndRect);

					rValue = wndRect.bottom - wndRect.top;
				}
			}
			else
			{
				rValue = m_Form->m_GetDoc->m_Height;
			}
			break;
		}
	case propWidth:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CRect wndRect(0,0,0,0);
					pView->GetClientRect(&wndRect);
					rValue = wndRect.right - wndRect.left;
				}
			}
			else
			{
				rValue = m_Form->m_GetDoc->m_Width;
			}
			break;
		}
	case propMaximize:
		{
			rValue = 0L;
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CWnd * pWnd = pView->GetParent();
					if(pWnd)
						rValue = pWnd->IsZoomed();
				}
			}
			break;
		}
	default:
		{
			int n = -1;
			CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
			CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
			if(pGetFieldsArray->GetSize() == iPropNum - lastProp)
				n = -2;
			else
			{
				n = iPropNum - lastProp;
				if(n<0)
		return S_FALSE;
			}
			if(((pGetFieldsArray->GetSize() <= n) || (n<0)) && (n != -2))
				return S_FALSE;

			CAttribEx* pAttrExCont;
			pAttrExCont = new CAttribEx;
			pAttrExCont->m_Form = m_Form;
			m_Form->IncrRef();
			pAttrExCont->num = n;

			rValue.AssignContext(pAttrExCont);
			pAttrExCont->DecrRef();
		}
		//return S_FALSE;
	};
	return S_OK;
}

int  CFormEx::SetPropVal(int iPropNum,class CValue const & vValue)
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return S_FALSE;
	}

	if(iPropNum < 0) return S_FALSE;

	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;

	switch (iPropNum) {
	case propHeight:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CWnd * pWnd = pView->GetParent();
					if(pWnd)
					{
						WINDOWPLACEMENT wp;
						wp.length = sizeof(WINDOWPLACEMENT);
						if(pWnd->GetWindowPlacement(&wp))
						{
							if(wp.showCmd == SW_SHOWNORMAL)
							{
								CRect wndRect(0,0,0,0);
								pView->GetClientRect(&wndRect);
								int fH = (wp.rcNormalPosition.bottom - wp.rcNormalPosition.top) -
									(wndRect.bottom - wndRect.top);

								pWnd->MoveWindow(wp.rcNormalPosition.left,wp.rcNormalPosition.top,
													wp.rcNormalPosition.right - wp.rcNormalPosition.left,
													fH + vValue.GetNumeric());
							}
						}
					}
				}
			}
			else
			{
				m_Form->m_GetDoc->m_Height = vValue.GetNumeric();
			}
			break;
		}
	case propWidth:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CWnd * pWnd = pView->GetParent();
					if(pWnd)
					{
						WINDOWPLACEMENT wp;
						wp.length = sizeof(WINDOWPLACEMENT);
						if(pWnd->GetWindowPlacement(&wp))
						{
							if(wp.showCmd == SW_SHOWNORMAL)
							{
								CRect wndRect(0,0,0,0);
								pView->GetClientRect(&wndRect);
								int fW = (wp.rcNormalPosition.right - wp.rcNormalPosition.left) -
									(wndRect.right - wndRect.left);
								pWnd->MoveWindow(wp.rcNormalPosition.left,wp.rcNormalPosition.top,
													fW + vValue.GetNumeric(),
													wp.rcNormalPosition.bottom - wp.rcNormalPosition.top);
							}
						}
					}
				}
			}
			else
			{
				m_Form->m_GetDoc->m_Width = vValue.GetNumeric();
			}
			break;
		}
	case propMaximize:
		{
			if (pDoc->ExistWindow())
			{
				POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
				CFormView* pView = (CFormView*)((CDocument*)pDoc)->GetNextView(aPOS);
				if(pView)
				{
					CWnd * pWnd = pView->GetParent();

					if(pWnd)
					{
						WINDOWPLACEMENT wp;
						wp.length = sizeof(WINDOWPLACEMENT);
						if(pWnd->GetWindowPlacement(&wp))
						{
							if(vValue.GetNumeric())
								wp.showCmd = SW_SHOWMAXIMIZED;
							else
								wp.showCmd = SW_SHOWNORMAL;
							pWnd->SetWindowPlacement(&wp);
						}
					}
				}
			}
			break;
		}
	default:
		return S_FALSE;
	};
	return S_OK;
}

int  CFormEx::FindProp(char const * lpPropName)const
{
	if(!m_Form)
	{
		CBLModule::RaiseExtRuntimeError("   ",0);
		return -1;
	}
	int i;
	for (i = 0;i<lastProp;i++)
	{
		if (!stricmp(lpPropName,defPropNames[i].Names[0]))
			return i;
		if (!stricmp(lpPropName,defPropNames[i].Names[1]))
			return i;
	}
	CGetDoc7* pDoc = (CGetDoc7*)m_Form->m_GetDoc;
	CGetFieldsArray* pGetFieldsArray = (CGetFieldsArray*)(&(((CGetDoc77*)pDoc)->m_Array));
	CString m_AttribName(lpPropName);
	for (i = 0;i<pGetFieldsArray->GetSize();i++)
	{
		CGetField* pGetField = pGetFieldsArray->GetAt(i);
		char* pCodeName = (char*)pGetField->GetCtrlInfo()->GetCodeName();
		if(m_AttribName.CompareNoCase(pCodeName) == 0)
			return i+lastProp;
	}
	if((m_AttribName.CompareNoCase("") == 0) ||
		(m_AttribName.CompareNoCase("MULTYCOLUMN") == 0))
	{
		return lastProp+pGetFieldsArray->GetSize();
	}
	return -1;//lastProp;//S_FALSE;
}

