// MDIClientWnd.cpp: implementation of the CMDIClientWnd class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MDIClientWnd.h"

#define CO_GRAY 0x00C0C0C0L

extern CBkEndUI * pBkEndUI;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMDIClientWnd::CMDIClientWnd():CWnd()
{
	m_nType = 0;
	m_bGray = false;
}

CMDIClientWnd::~CMDIClientWnd()
{

}

COLORREF CMDIClientWnd::LightenColor(COLORREF col,double factor)
{
	if(factor>0.0&&factor<=1.0){
		BYTE red,green,blue,lightred,lightgreen,lightblue;
		red = GetRValue(col);
		green = GetGValue(col);
		blue = GetBValue(col);
		lightred = (BYTE)((factor*(255-red))+red);
		lightgreen = (BYTE)((factor*(255-green))+green);
		lightblue = (BYTE)((factor*(255-blue))+blue);
		col = RGB(lightred,lightgreen,lightblue);
	}
	return(col);
}

void CMDIClientWnd::CreateGrayBitmap(void)
{
	CDC* pDC = GetDC();

	BITMAP Bitmap;
	m_Bitmap.GetBitmap(&Bitmap);

	CDC m_MemDC_d,m_MemDC_s;
	m_MemDC_d.CreateCompatibleDC(pDC);
	m_MemDC_s.CreateCompatibleDC(pDC);

	CBitmap bmpMem;
	bmpMem.CreateCompatibleBitmap(pDC,Bitmap.bmWidth,Bitmap.bmHeight);

	CBitmap *pOld_s = m_MemDC_s.SelectObject(&m_Bitmap);
	CBitmap *pOld_d = m_MemDC_d.SelectObject(&bmpMem);
	m_MemDC_d.BitBlt(0,0,Bitmap.bmWidth,Bitmap.bmHeight,&m_MemDC_s,0,0,SRCCOPY);

	COLORREF col,discol;
	discol=GetSysColor(COLOR_BTNSHADOW);
	for(int i=0;i<Bitmap.bmWidth;++i){
		for(int j=0;j<Bitmap.bmHeight;++j){
			col=m_MemDC_d.GetPixel(i,j);
			BYTE r = GetRValue(col);
			BYTE g = GetGValue(col);
			BYTE b = GetBValue(col);
			int avgcol = (r+g+b)/3;
			double factor = avgcol/255.0;
			m_MemDC_d.SetPixel(i,j,LightenColor(discol,factor));
		}
	}
	m_BitmapGray.Attach(bmpMem.Detach());
	m_MemDC_d.SelectObject(pOld_d);
	m_MemDC_s.SelectObject(pOld_s);
	m_MemDC_d.DeleteDC();
	m_MemDC_s.DeleteDC();
	ReleaseDC(pDC);
}

BOOL CMDIClientWnd::OnEraseBkgnd(CDC* pDC)
{
	CWnd::OnEraseBkgnd(pDC);

	CDC m_MemDC;
	m_MemDC.CreateCompatibleDC(pDC);

	BITMAP Bitmap;
	m_Bitmap.GetBitmap(&Bitmap);
	if(m_bGray)
		m_MemDC.SelectObject(&m_BitmapGray);
	else
		m_MemDC.SelectObject(&m_Bitmap);

	RECT rect;
	GetClientRect(&rect);

	switch (m_nType)
	{
	case 1://-
		{
			pDC->BitBlt(0,0,Bitmap.bmWidth,Bitmap.bmHeight,&m_MemDC,0,0,SRCCOPY);
			break;
		}
	case 2://-
		{
			pDC->BitBlt(rect.right - Bitmap.bmWidth,
				0,Bitmap.bmWidth,Bitmap.bmHeight,&m_MemDC,0,0,SRCCOPY);
			break;
		}
	case 3://-
		{
			pDC->BitBlt(0,
				rect.bottom - Bitmap.bmHeight,
				Bitmap.bmWidth,Bitmap.bmHeight,&m_MemDC,0,0,SRCCOPY);
			break;
		}
	case 4://-
		{
			pDC->BitBlt(rect.right - Bitmap.bmWidth,
				rect.bottom - Bitmap.bmHeight,
				Bitmap.bmWidth,Bitmap.bmHeight,&m_MemDC,0,0,SRCCOPY);
			break;
		}
	case 5:// 
		{
			pDC->BitBlt((rect.right-rect.left - Bitmap.bmWidth)/2,
				(rect.bottom-rect.top - Bitmap.bmHeight)/2,
				Bitmap.bmWidth,Bitmap.bmHeight,&m_MemDC,0,0,SRCCOPY);
			break;
		}
	case 6://
		{
			pDC->StretchBlt(0,0,rect.right-rect.left,rect.bottom-rect.top,
				&m_MemDC,0,0,Bitmap.bmWidth,Bitmap.bmHeight,SRCCOPY);
			break;
		}
	case 7://
		{
			for(int i = 0; i<rect.right; i += Bitmap.bmWidth)
				for(int j = 0; j<rect.bottom; j += Bitmap.bmHeight)
					pDC->BitBlt(i,j,Bitmap.bmWidth,Bitmap.bmHeight,&m_MemDC,0,0,SRCCOPY);
			break;
		}
	default:// 
		break;
	}
	m_MemDC.DeleteDC();

	return TRUE;
}

void CMDIClientWnd::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType, cx, cy);
	RedrawWindow();
}

BEGIN_MESSAGE_MAP(CMDIClientWnd, CWnd)
	//{{AFX_MSG_MAP(CMDIClientWnd)
	ON_WM_ERASEBKGND()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

