// ModuleString.cpp: implementation of the CModuleString class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "addin.h"
#include "ModuleString.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif
#import "C:\\Program Files\\1Cv77\\BIN\\zlibeng.dll" no_namespace
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
//CBLModule7

bool CModuleString::LoadModule(const CString& strFileName)
{
  if (strFileName.Find(".ert") != -1) //       
  {    
    IStoragePtr pStgRoot;
    IStorage* pStorage = NULL;
    HRESULT hr;
    USES_CONVERSION;
    hr = ::StgOpenStorage(
            T2COLE(strFileName),
            NULL,
            STGM_READ | STGM_SHARE_DENY_WRITE,
            //STGM_READ,
            NULL,
            0,
            &pStorage);

    if (FAILED(hr))
    {	//
      CString StrError;
      StrError = "   : ";
      StrError += strFileName;
      pBkEndUI->DoMessageLine(StrError, mmBlackErr);	
      return false;
    }              
    pStgRoot.Attach(pStorage, false);

    IStreamPtr pStream;
    IStream *pIStr = NULL;
    hr = pStgRoot->OpenStream(T2COLE("MD Programm text"),0,STGM_READ | STGM_SHARE_EXCLUSIVE,0,&pIStr);
    if( FAILED(hr) ) 
    {
      pBkEndUI->DoMessageLine("failed IStorage::OpenStream", mmBlackErr);	            
      return false;        
    }
    pStream.Attach(pIStr, false);    

    IStreamPtr pStreamOut;
    pIStr = NULL;
    if (S_OK == CreateStreamOnHGlobal(NULL, TRUE, &pIStr))
    {     
      pStreamOut.Attach(pIStr, false);
      try 
      {
        IzlibEnginePtr iLibEngine;
        iLibEngine.CreateInstance(L"V75.zlibEngine");
        
        hr = iLibEngine->pkDecompress(pStream, pStreamOut);            
        
        if (FAILED(hr))
        {
          pBkEndUI->DoMessageLine("error iLibEngine->pkDecompress", mmBlackErr);          
          return false;
        }          
        else
        {          
          STATSTG St;
          pStreamOut->Stat(&St, STATFLAG_NONAME);
          ULONG cbStreamSizeOut = St.cbSize.LowPart;                               
          LPTSTR lpStr = GetBufferSetLength(cbStreamSizeOut);
          if (lpStr != NULL)
          {
            LARGE_INTEGER __zero;
            __zero.QuadPart = __int64(0);
            if (pStreamOut->Seek(__zero, 0, NULL) == S_OK)
            {
              ULONG pcbRead = 0;
              if (pStreamOut->Read(&lpStr[0], cbStreamSizeOut, &pcbRead) != S_OK)
              {
                pBkEndUI->DoMessageLine("pStreamOut->Read(&lpStr[0], cbStreamSizeOut, &pcbRead) != S_OK", mmBlackErr);	                            
                return false;
              }              
            }
            else
            {
              pBkEndUI->DoMessageLine("pStreamOut->Seek(__zero, 0, NULL) != S_OK", mmBlackErr);	                            
              return false;
            }
          }
          else
          {
            pBkEndUI->DoMessageLine("lpStr == NULL", mmBlackErr);	                            
            return false;
          }
                     
        }

      } 
      catch (_com_error& err) 
      {
        CString str;
        str.Format("V75.zlibEngine Error:%s", err.ErrorMessage());
        pBkEndUI->DoMessageLine(str, mmBlackErr);
        return false;
      }                  
    }
    else
    {
      pBkEndUI->DoMessageLine("error in CreateStreamOnHGlobal", mmBlackErr);    
      return false; 
    }        
    return true;    
  }
  else
  {
    int npos = strFileName.Find("@MD");
    if (npos != -1)
    {
      CString nameRep = strFileName.Left(npos);
      CMetaDataCont *pMD = GetMetaData();  
      
      CMetaDataObj* pObj=(CMetaDataObj*)pMD->GetCalcVarDef(nameRep);
      if (pObj)
      {      
        long id=pObj->GetID();
        CTypedCont* pCont=NULL;
        CString text;
	      CConfigCont::IDToPath(id,"CalcVar",text,&pCont,FALSE);

	      if(pCont)
        {
	        CTxtModuleReader* pText = (CTxtModuleReader*)pCont->GetTextDocument();        
          pText->GetText(*this);        
        }
        return true;
      }
      else
      {
        return false;
      }      
    }
    else
    {
      CFile ComponentFile;
      if (ComponentFile.Open(strFileName, CFile::modeRead))
      {  
        DWORD dwLength = ComponentFile.GetLength();
        LPTSTR buff = GetBuffer(dwLength);
        ComponentFile.Read(buff, dwLength);
        ReleaseBuffer(dwLength);
        ComponentFile.Close();
        return true;
      }
      else
      {
        CString StrError;
        StrError = "   : ";
        StrError += strFileName;
        pBkEndUI->DoMessageLine(StrError, mmBlackErr);	
        return false;
      }
    }
  }
}
