// 1CPP_ODBCRecordSet.cpp: implementation of the C1CPP_ODBCRecordSet class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "1CPP_ODBCRecordSet.h"

const char DocKindSuffixEng[] = "_kind";
const char DocKindSuffixRus[] = "_";

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

enum {    
  procSetDatabase,
  funcExecute,
  funcGetLastError,
  procClose,
  funcBuildParams,
  funcPrepare,
  funcAddParam,
  funcGetParam,
  procSetParam,
  funcParamCount,
  procClearParams,
  procDeleteParam,
  procSetDatabase1C,
  funcOpen,
  funcIsOpen,
  funcMoveNext,
  funcMovePrevious,
  funcMoveFirst,
  funcMoveLast,
  funcGetFieldCount,
  funcIsBof,
  funcIsEof,
  funcGetRowsAffected,
  funcGetValues,
  funcGetInTablesValues,
  procDebug,
  funcGetFieldIndex,
  funcGetValue,
  procSetRowsetSize,
  procSetPropertyCursor,
  procSetTypeColumn1C,
  funcGetValuesInSV,
  funcExeSQL_FromTV,
  procSetTextParam,
  funcGetFieldDefs,
  procAutoTypification,
  procPutObjectList,
	lastMethod
	};

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
extern CDataBase7 * pDataBase7;
extern CMetaDataCont * pMetaDataCont;
extern CBkEndUI * pBkEndUI;

class CObjID C1CPP_ODBCRecordSet::ObjID;
class CParamDefs C1CPP_ODBCRecordSet::defFnNames;
class CMetaDataWork* C1CPP_ODBCRecordSet::m_pMetaData = NULL;

//class CODBCDatabase C1CPP_ODBCRecordSet::m_db;
int C1CPP_ODBCRecordSet::n_nCountUnlimitPars(0);
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
IMPLEMENT_DYNCREATE_OXY(C1CPP_ODBCRecordSet);



C1CPP_ODBCRecordSet::C1CPP_ODBCRecordSet() :
    CBLContext(), m_pOtherDB(NULL), m_IsDebugMode(FALSE), m_nCurIndex(0),
    m_MetaNameParser(&m_db)
{
  //AFX_MANAGE_STATE(AfxGetStaticModuleState());	
  
  static bool staticBOOLisSQL = "CODBCDB7" == CString(pDataBase7->GetRuntimeClass()->m_lpszClassName);
  if (staticBOOLisSQL)            
  {
    if (!m_db.IsConnected())
    {        
      m_db.Attach(*(SQLHDBC*)(long(pDataBase7->CanBeCommited())+0x4c));   
    }
    if (m_db.IsConnected())
    {
      AttachRecordset(&m_db);
    }
  }
  
  if (m_pMetaData == NULL)
  {      
    m_pMetaData = new CMetaDataWork;      
    if (m_pMetaData == NULL)      
    {
      AfxMessageBox("      CMetaDataWork!");
    }
  }
   
  

  if (defFnNames.Empty())
  {     
    defFnNames.SetPoolSize(lastMethod + 1, 0);        
    defFnNames.AddParam("SetDatabase", "", procSetDatabase, 0, 1);        
    defFnNames.AddParam("Execute", "", funcExecute, 1, 2);
    defFnNames.AddParam("GetLastError", "", funcGetLastError, 1, 0);    
    defFnNames.AddParam("Close", "", procClose, 0, 1);
    defFnNames.AddParam("BuildParams", "", funcBuildParams, 1, 0);
    defFnNames.AddParam("Prepare", "", funcPrepare, 1, 1);     
    defFnNames.AddParam("AddParam", "", funcAddParam, 1, 5);    
    defFnNames.AddParam("GetParam", "", funcGetParam, 1, 2);    
    defFnNames.AddParam("SetParam", "", procSetParam, 0, 3);    
    defFnNames.AddParam("ParamCount", "", funcParamCount, 1, 0);        
    defFnNames.AddParam("ClearParams", "", procClearParams, 0, 0);    
    defFnNames.AddParam("DeleteParam", "", procDeleteParam, 0, 1);        
    defFnNames.AddParam("SetDatabase1C", "1", procSetDatabase1C, 0, 0);        
    defFnNames.AddParam("Open", "", funcOpen, 1, 3);
    defFnNames.AddParam("IsOpen", "", funcIsOpen, 1, 0);
    defFnNames.AddParam("MoveNext", "",     funcMoveNext, 1, 0);
    defFnNames.AddParam("MovePrevious", "", funcMovePrevious, 1, 0);
    defFnNames.AddParam("MoveFirst", "",  funcMoveFirst, 1, 0);
    defFnNames.AddParam("MoveLast", "",  funcMoveLast, 1, 0);    
    defFnNames.AddParam("GetFieldCount", "",  funcGetFieldCount, 1, 0);
    defFnNames.AddParam("IsBof", "",  funcIsBof, 1, 0);
    defFnNames.AddParam("IsEof", "",  funcIsEof, 1, 0);
    defFnNames.AddParam("GetRowsAffected", "",  funcGetRowsAffected, 1, 0);        
    defFnNames.AddParam("GetValues", "", funcGetValues, 1, 0);    
    defFnNames.AddParam("GetResultsInVT", "_", funcGetInTablesValues, 1, 2);    
    defFnNames.AddParam("Debug", "", procDebug, 0, 1);
    defFnNames.AddParam("GetFieldIndex", "", funcGetFieldIndex, 1, 1);
    defFnNames.AddParam("GetValue", "", funcGetValue, 1, 1);
    defFnNames.AddParam("SetRowsetSize", "", procSetRowsetSize, 0, 1);    
    defFnNames.AddParam("SetPropertyCursor", "", procSetPropertyCursor, 0, 4);
    defFnNames.AddParam("SetTypeColumn1C", "1", procSetTypeColumn1C, 0, 1);            
    defFnNames.AddParam("GetValuesInSV", "", funcGetValuesInSV, 1, 1);
    defFnNames.AddParam("ExeSQL_FromTV","SQL_",funcExeSQL_FromTV, 1, 2);
	  defFnNames.AddParam("SetTextParam","", procSetTextParam, 0, 2);
	  defFnNames.AddParam("GetFieldDefs","", funcGetFieldDefs, 1, 8);
	  defFnNames.AddParam("AutoTypification","", procAutoTypification, 0, 1);
	  defFnNames.AddParam("PutObjectList","", procPutObjectList, 0, 3);
  }
#ifdef _DEBUG
  //pBkEndUI->DoMessageLine("  C1CPP_ODBCRecordSet!", mmExclamation);	
#endif
}

C1CPP_ODBCRecordSet::~C1CPP_ODBCRecordSet()
{    
  Close(TRUE);
  if (m_pOtherDB!=NULL)
    m_pOtherDB->DecrRef();

#ifdef _DEBUG
  //pBkEndUI->DoMessageLine("  C1CPP_ODBCRecordSet!", mmExclamation);	
#endif
}

int  C1CPP_ODBCRecordSet::CallAsFunc(int iMethNum,class CValue & rValue,class CValue * *ppValue)
{
  int ret = 1;
	switch(iMethNum)
  {    
    case funcExeSQL_FromTV:
      {
        CBLContext *pCont = ppValue[0]->GetContext();
        if (pCont == NULL)
          CBLModule::RaiseExtRuntimeError("    !", 0);
        
        

#ifndef DMITRO_ENV
        if (m_IsDebugMode)
        {
          CString strClassName(pCont->GetRuntimeClass()->m_lpszClassName);
          if (strClassName != "CValueTableContext")
          {
            CSetOfHierarchy *pH = CSetOfHierarchy::GetHierarchy();
            if (!pH->TheClassIsDerive(pCont->GetTypeString(), "") && 
                !pH->TheClassIsDerive(pCont->GetTypeString(), "ValueTable"))
            {
              CBLModule::RaiseExtRuntimeError("    ,         ", 0);
            }
          }
        }
#endif
        
        CValue par1;        
        CValue *ppPs[1] = {&par1};
        CValue arValue;
        
        CValueTable* pTable = ((CValueTableContextData*)pCont->GetInternalData())->GetValueTable();
        //int staticColumnCount = pCont->FindMethod("ColumnCount");
        //int staticLinesCnt = pCont->FindMethod("LinesCnt");

        /*pCont->CallAsFunc(staticColumnCount,arValue, ppPs);
        int nNumColTV = arValue.GetNumeric();
        pCont->CallAsFunc(staticLinesCnt,arValue, ppPs);
        int nLinesCnt = arValue.GetNumeric();*/
        int nNumColTV = pTable->GetColumnCount();
        int nLinesCnt = pTable->GetRowCount();
        
        if (nNumColTV != 0 && nLinesCnt != 0)
        {          
          int nRowsetSize = ppValue[1]->GetNumeric();
          
          if (nRowsetSize == 0)          
            nRowsetSize = static_cast<int>(nLinesCnt*0.1 == 0 ? nLinesCnt : nLinesCnt*0.1);

          nRowsetSize = nRowsetSize == 0 ? 1 : nRowsetSize;
          
          nRowsetSize = min(nLinesCnt, nRowsetSize);

          SetRowsetSizeForParams(nRowsetSize);
          if (ParamCount() == 0)
            if (BuildParams() == FALSE)
            {
              CString err;
              err.Format("     .\
                \r\n      ! \r\n %s", GetLastError());
              Close();
              CBLModule::RaiseExtRuntimeError(err, 0);
            }
          int nCountParams = m_aParams.GetSize();
          int nColumns = min(nCountParams, nNumColTV);

          int staticGetColumnParameters = pCont->FindMethod("GetColumnParameters");
          vector<CMetaDataWork::TypeStringValue> vecTypesOfColumn;
          CValue Ident, Type, Lenght, Scale, Caption, Width, Format, Position;
          CValue *Params[8] = {&Ident, &Type, &Lenght, &Scale, &Caption, &Width, &Format, &Position};
          for (int id = 0; id < nColumns; ++id) 
          {            
            Ident = id+1;
            if (pCont->CallAsFunc(staticGetColumnParameters,arValue, Params)==1)
            {
              CMetaDataWork::TypeStringValue type = CMetaDataWork::ShortString;

              CString nameCol = Caption.GetString();
              nameCol.TrimRight();
              
              int pPosQuest = nameCol.Find("?");
              int res = 0;
              if (pPosQuest != -1)
              {
                res = atoi(nameCol.operator LPCTSTR() + pPosQuest + 1);
              }
              
              switch(res)
              {
               case 1:
                 type = CMetaDataWork::ShortString;
                 break;
               case 2:                  
                 type = CMetaDataWork::LongString;
                 break;
               case 3:                  
                 type = CMetaDataWork::VeryLongString;
                 break;
               default:
                 type = CMetaDataWork::ShortString;
                 break;                  
              }              
              vecTypesOfColumn.push_back(type);
            }            
          }

          //int staticGetValue = pCont->FindMethod("GetValue");          
          CValue vRetTV;
          //CValue vNumStroke, vNumColumn, vRetTV;
          //CValue *mPars[2] = {&vNumStroke, &vNumColumn};
          int nNumCurRow = 1;
          for (int i=1; i <= nLinesCnt; ++i)
          {        
            for (int j=1; j <= nColumns; ++j)
            {
              //vNumStroke = i;
              //vNumColumn = j;
              //if (pCont->CallAsFunc(staticGetValue,vRetTV, mPars) == 1)
              {

                void *pData = NULL;
                vRetTV = pTable->GetValue(j-1, i-1);
                SetValueOfParam(j-1, vRetTV, vecTypesOfColumn[j-1]);

                int size = 0;
                if (GetParam(j-1).GetBufferAndSize(&pData, size))
                  SetParamOfRow(nNumCurRow, j, size, pData);
              }
            }
            ++nNumCurRow;
            if (nRowsetSize < nNumCurRow || (i) == nLinesCnt)
            {
              if (!Execute(NULL, TRUE))
              {                
                CString err;
                err.Format("    .\
                  \r\n %s", GetLastError());
                Close();
                CBLModule::RaiseExtRuntimeError(err, 0);               
              }
              if ((nLinesCnt - i) < nRowsetSize && nLinesCnt != i)
              {
                nRowsetSize = nLinesCnt - i;
                ResizeRowsetSizeForParams(nRowsetSize);
              }
              nNumCurRow = 1;            
            }
          }  
          //Close();
        }
        else
        {
          rValue = 0L;
        }        
        
      }
    case funcGetValuesInSV:
      {
        int nCount = 0;
        int c = GetFieldCount();        
        if (c == 0)
        {
          rValue = CNumeric(0);
        }
        else
        {
          
          switch(ppValue[0]->buf0[2])
          {
            case STRING_TYPE_1C:
              {
                CMapWordToPtr NumOfColumn;

                const CString &str = ppValue[0]->GetString();      
              
                char *token = NULL;
                char *dest = (char*)malloc(str.GetLength()+1);          
                const char *sep = ",";
                int i = 0;
                if (dest)
                {
                  strcpy(dest, str);
                  
                  CBLContext *pContStruct = NULL;
                  int staticInsert = 0;

                  token = strtok( dest, sep );
                  while( token != NULL  && i < c)
                  {         
                    if (pContStruct == NULL)
                    {
                      rValue.CreateObject("Struct");                      
                      pContStruct = rValue.GetContext();
                      staticInsert = pContStruct->FindMethod("Insert");                  
                    }

                    CString s(token);
                    s.Replace(" ", "");
                    WORD pos = static_cast<WORD>(GetFieldIndex(s));
                    if (pos == -1)
                    {
                      CString err;
                      err.Format("   : %s    !", s);
                      free(dest);
                      CBLModule::RaiseExtRuntimeError(err, 0);
                    }
                    
                    CValue par1;
                    CValue par2;
                    CValue par3;
                    par1 = s;
                    par2.CreateObject("ValueList");
                    
                    par3 = CNumeric(1);
                    CValue *params[3] = {&par1, &par2, &par3};
                    NumOfColumn[pos] = (void*)(par2.GetContext());
                    pContStruct->CallAsProc(staticInsert, params);                    
                    ++i;                    
                    token = strtok( NULL, sep );
                  }
                  free(dest);
                  
                  
                  int n = min(GetFieldCount(), i);
                  if (n > 0)
                  {                   
                    CValue ValueList;
                    ValueList.CreateObject("ValueList");

                    int nAddValue = ValueList.GetContext()->FindMethod("AddValue");

                    if (m_nRowsetSize > 0)            
                    {                    
                      for( ; ! IsEof(); MoveNext() )
                      {
                        for (m_nCurIndex = 0; m_nCurIndex < GetRowFetched(); ++m_nCurIndex)
                        {                      
                          BYTE* Rowset = GetRowset() + GetRowSize()*m_nCurIndex;
                          POSITION pos;
                          WORD key;
                          CBLContext* pa;
                          for( pos = NumOfColumn.GetStartPosition(); pos != NULL; )
                          {
                            NumOfColumn.GetNextAssoc( pos, key, (void*&)pa );                          

                            CValue v;
                            CValue v2;
                            CDBField& f = operator [](key);
                            SetValueOfRow(Rowset, f, key, v, true);
                            CValue *params[2] = {&v, &v2};                          
                            pa->CallAsProc(nAddValue, params);                          
                          }
                        }
                      }
                    }
                    else
                    {            
                      for( ; ! IsEof(); MoveNext() )
                      {                                                        
                        POSITION pos;
                        WORD key;
                        CBLContext* pa;
                        for( pos = NumOfColumn.GetStartPosition(); pos != NULL; )
                        {               
                          NumOfColumn.GetNextAssoc( pos, key, (void*&)pa );                          
                
                          CValue v;
                          CValue v2;
                          CDBField& f = operator [](key);
                          SetValueOnDBField(f, v, true);                                                
                          CValue *params[2] = {&v, &v2};                        
                          pa->CallAsProc(nAddValue, params);                        
                        }                
                      }
                    }
                  }
                  
                }
              }
            break;
            case NUMBER_TYPE_1C:
              {
                int pos = ppValue[0]->GetNumeric();
                if (pos > c || 1 > c)
                  CBLModule::RaiseExtRuntimeError("   ", 0);
                
                --pos;
                rValue.CreateObject("ValueList");
                CBLContext *pCont = rValue.GetContext();
                int staticAddValue = pCont->FindMethod("AddValue");

                if (m_nRowsetSize > 0 && pCont != NULL)            
                {                  
                  for( ; ! IsEof(); MoveNext() )
                  {
                    for (m_nCurIndex = 0; m_nCurIndex < GetRowFetched(); ++m_nCurIndex)
                    {                      
                      BYTE* Rowset = GetRowset() + GetRowSize()*m_nCurIndex;                                            
                      CValue v;
                      CValue v2;
                      CDBField& f = operator [](pos);
                      SetValueOfRow(Rowset, f, pos, v, true);
                      CValue *params[2] = {&v, &v2};
                      pCont->CallAsProc(staticAddValue, params);                      
                    }
                  }
                }
                else
                {            
                  for( ; ! IsEof(); MoveNext() )
                  {                                                                   
                    CValue v;
                    CValue v2;
                    CDBField& f = operator [](pos);
                    SetValueOnDBField(f, v, true);
                    CValue *params[2] = {&v, &v2};
                    pCont->CallAsProc(staticAddValue, params);                    
                  }
                }
              }
              break;
            default:
              {
                CBLModule::RaiseExtRuntimeError("  ", 0);
              }
          }          
        }
      } // if (c == 0)
      break;
    case funcGetFieldIndex:
      {
        rValue = GetFieldIndex(ppValue[0]->GetString());
      }
      break;
    case funcGetLastError:
      {
        rValue = GetLastError();
      }
      break;
    case funcPrepare:
      {
        int r = TRUE;
        m_MetaNameParser.SetQueryText(ppValue[0]->GetString());

        try 
        {
          m_MetaNameParser.Parse();
        } 
        catch (CMNPException * MNPException) 
        {
          m_sLastError = "Meta name parser error: " + MNPException->GetErrorDescr();
          MNPException->Delete();
          r = FALSE;
		};
      if (m_IsDebugMode)
      {
        pBkEndUI->DoMessageLine(m_MetaNameParser.GetQueryText(), mmNone);
      }        

		  if (r)
		    rValue = Prepare(m_MetaNameParser.GetQueryText());
          else
            rValue = 0L;
        //pBkEndUI->DoMessageLine(m_MetaNameParser.GetQueryText(), mmExclamation);	
      }
      break;
    case funcAddParam:
      {
        long IOType = ppValue[0]->GetNumeric().operator long();        
        if (IOType < 1 && IOType > 3)
          CBLModule::RaiseExtRuntimeError("  :  IO ", 0);
        switch(IOType)
        {        
          case 1:
            IOType = SQL_PARAM_INPUT;
            break;
          case 2:
            IOType = SQL_PARAM_OUTPUT;
            break;
          case 3:
            IOType = SQL_PARAM_INPUT_OUTPUT;
            break;
        }

        SWORD nSQLType = static_cast<SWORD>(ppValue[1]->GetNumeric().operator long());
        switch(nSQLType)
        {          
          case 1:
            nSQLType = SQL_BIT;
            break;
          case 2:
            nSQLType = SQL_TINYINT;
            break;
          case 3:
            nSQLType = SQL_SMALLINT;
            break;
          case 4:
            nSQLType = SQL_INTEGER;
            break;
          case 5:
            nSQLType = SQL_REAL;
            break;
          case 6:
            nSQLType = SQL_FLOAT;
            break;
          case 7:
            nSQLType = SQL_DOUBLE;
            break;
          case 8:
            nSQLType = SQL_TYPE_DATE;
            break;
          case 9:
            nSQLType = SQL_TYPE_TIME;
            break;
          case 10:
            nSQLType = SQL_TYPE_TIMESTAMP;
            break;
          case 11:
            nSQLType = SQL_NUMERIC;
            break;
          case 12:
            nSQLType = SQL_DECIMAL;
            break;
          case 13:
            nSQLType = SQL_BIGINT;
            break;
          case 14:
            nSQLType = SQL_CHAR;
            break;
          case 15:
            nSQLType = SQL_VARCHAR;
            break;          
          case 16:
            nSQLType = SQL_LONGVARCHAR;
            break;
          case 17:
            nSQLType = SQL_BINARY;
            break;
          case 18:
            nSQLType = SQL_VARBINARY;
            break;
          case 19:
            nSQLType = SQL_LONGVARBINARY;
            break;
          default:
            {
              CBLModule::RaiseExtRuntimeError("  :  SQL ", 0);
            }
            break;
        }
        int nLen = ppValue[2]->GetNumeric();
        int nDec = ppValue[3]->GetNumeric();
        CType type(1);
        BOOL ret = AddParam(ppValue[4]->GetString(), IOType, nSQLType, type, nLen, nDec);
        if (ret)
            m_aParams[m_aParams.GetSize() - 1].m_Modificator = m_MetaNameParser.GetSQLParamModifikator(m_aParams.GetSize());
        rValue = ret;
      }
      break;
    case funcGetParam:
      {
        long nPar = m_MetaNameParser.GetSQLParamNumber(*ppValue[0]);
        if (nPar < 1 || nPar > ParamCount())
          CBLModule::RaiseExtRuntimeError("   ", 0);
        CDBField& qp = static_cast<CDBField&>(GetParam(nPar-1));
        
        if(qp.AsChar() || qp.AsString())
        {          
          CString str = ppValue[1]->GetString();
          if (str.IsEmpty())
            rValue = qp.operator CString();
          else
          {
            CType t(0);
            CMetaDataWork::SetTypeAndKind(t, str);
            rValue.SetType(t);
            CMetaDataWork::TypeStringValue eType;            
            if (t.GetTypeCode() == 0)
              eType = CMetaDataWork::VeryLongString;
            else
              eType = t.GetTypeID() == 0 ? CMetaDataWork::LongString: CMetaDataWork::ShortString;

            CMetaDataWork::Make1C_ValueFromString(rValue, t, qp.operator CString(), eType);
          }
        }
        else if(qp.AsDate())
        {
          const COleDateTime &date = qp.operator COleDateTime();          
          rValue = CDate(date.GetYear(),date.GetMonth(),date.GetDay());
        }
        else if (qp.AsFloat())
          rValue = CNumeric(qp.operator float());
        else if (qp.AsInt())
          rValue = CNumeric(qp.operator int());
        else if (qp.AsDouble())
          rValue = CNumeric(qp.operator double());
        else if (qp.AsLong())
          rValue = CNumeric(qp.operator long());
        else if (qp.AsShort())
          rValue = CNumeric(qp.operator short());
        else if (qp.AsBool())
          rValue = CNumeric(qp.operator bool());
      }
      break;
    case funcParamCount:
      {
        rValue = ParamCount();
      }
      break;
    case procClearParams:
      {
        ClearParams();
      }
      break;
    //      
    case procDeleteParam:
      {
        int i = ppValue[1]->GetNumeric();
        if (i > ParamCount())
          CBLModule::RaiseExtRuntimeError("   ", 0);
        DeleteParam(i-1); 
      }
      break;
    case funcBuildParams:
      {
        int ret = BuildParams();
        if (ret)
          m_MetaNameParser.SetSQLParamsModifikators(m_aParams);
        rValue = ret;
      }
      break;
    case funcOpen:
      {
        CString strSQL(ppValue[0]->GetString());        
        BOOL bScroll = ppValue[1]->GetNumeric();
        BOOL bPrep   = ppValue[2]->GetNumeric();
        if (strSQL.IsEmpty())
          bPrep = TRUE;
        else {
          m_MetaNameParser.SetQueryText(strSQL);
          try {
            m_MetaNameParser.Parse();
          } catch (CMNPException * MNPException) {
            m_sLastError = "Meta name parser error: " + MNPException->GetErrorDescr();
            MNPException->Delete();
            rValue = 0L;
            break;
          };
          strSQL = m_MetaNameParser.GetQueryText();
        };

        if (bPrep)
          bScroll = FALSE;
        
        if (m_IsDebugMode)
        {
            pBkEndUI->DoMessageLine(strSQL, mmNone);
        }        
        rValue = Open(strSQL, bScroll, bPrep);
        if (m_nRowsetSize > 0)
          m_nCurIndex = 0;      
      }
      break;
    case funcIsOpen:
      rValue = IsOpen();
      break;
    case funcMoveNext:
      {
        if (m_nRowsetSize > 0)
        {
          ++m_nCurIndex;
          if (m_nCurIndex == GetRowFetched())
          {
            m_nCurIndex = 0;
            rValue = MoveNext();
          }
          else
            rValue = TRUE;
        }
        else
          rValue = MoveNext();        
      }
      break;
    case funcMovePrevious:
      rValue = MovePrevious();
      break;
    case funcMoveFirst:
      rValue = MoveFirst();
      break;
    case funcMoveLast:
      rValue = MoveLast();
      break;
    case funcGetFieldCount:
      rValue = GetFieldCount();
      break;
    case funcIsBof:
      rValue = IsBof();
      break;
    case funcIsEof:
      rValue = IsEof();
      break;
    case funcGetRowsAffected:
      rValue = GetRowsAffected();
      break;
    case funcGetValues:
      {        
        int n = min(GetFieldCount(), n_nCountUnlimitPars);
        n_nCountUnlimitPars = 0;
        if (IsBof() || IsEof() || n == 0)
        {
          rValue = CNumeric(0);          
        }
        else
        {
          if (m_nRowsetSize > 0)
          {
            BYTE* Rowset = GetRowset() + GetRowSize()*m_nCurIndex;
            for (int i = 0; i < n; ++i)
            {              
              SetValueOfRow(Rowset, operator [](i), i, *ppValue[i], true);
            }
          }
          else
          {
            for (int i = 0; i < n; ++i)
            {                            
              SetValueOnDBField(operator [](i), *ppValue[i], true);
            }
          }
          rValue = CNumeric(1);
        }
      }
      break;
    case funcGetValue:
      {
        int i = -1;
        if (ppValue[0]->buf0[2] == NUMBER_TYPE_1C)
        {
          i = ppValue[0]->GetNumeric();
          if (i > GetFieldCount() || i < 1)
          {
            CString err;
            err.Format("    (%d)!", i);
            CBLModule::RaiseExtRuntimeError(err, 0);
          }
          --i;
        }
        else if(ppValue[0]->buf0[2] == STRING_TYPE_1C)
        {
          i = GetFieldIndex(ppValue[0]->GetString());
          if (i == -1)
          {
            CString err;
            err.Format("   (%s)   !", ppValue[0]->GetString());
            CBLModule::RaiseExtRuntimeError(err, 0);
          }
        }
        else
          CBLModule::RaiseExtRuntimeError("    !", 0);

        if (m_nRowsetSize > 0)          
        {
          BYTE* Rowset = GetRowset() + GetRowSize()*m_nCurIndex;
          SetValueOfRow(Rowset, operator [](i), i, rValue, true);
        }          
        else
        {
          SetValueOnDBField(operator [](i), rValue, true);
        }
      }
      break;
    case funcGetInTablesValues:
      {
        bool res = false;
        /*CString field =  "     0   ";
        const CString& st1 = field.Left(6);
        const CString& st2 = field.Mid(6);*/
		    if (GetFieldCount() == 0)
        {
          res = false;
        }
        else
        {
          CBLContext *pCont = ppValue[0]->GetContext();
          if (pCont == NULL)
            CBLModule::RaiseExtRuntimeError("    !", 0);

#ifndef DMITRO_ENV
          if (m_IsDebugMode)
          {
            CString strClassName(pCont->GetRuntimeClass()->m_lpszClassName);
            if (strClassName != "CValueTableContext")
            {
              CSetOfHierarchy *pH = CSetOfHierarchy::GetHierarchy();
              if (!pH->TheClassIsDerive(pCont->GetTypeString(), "") && 
                  !pH->TheClassIsDerive(pCont->GetTypeString(), "ValueTable"))
              {
                CBLModule::RaiseExtRuntimeError("    ,         ", 0);
              }
            }
          }
#endif
        
          CValue arValue;        
          CValue par1;        
          CValue *ppPs[1] = {&par1};
          BOOL bCreate = ppValue[1]->GetNumeric();
          int n = 0;
          if (bCreate)
          {
            int staticClear = pCont->FindMethod("Clear");
            int staticNewColumn = pCont->FindMethod("NewColumn");
            pCont->CallAsProc(staticClear, NULL);
            CValue Ident;
					  CValue Type;
					  CValue Length;
					  CValue Scale;
					  CValue Caption;
					  CValue Width;
					  CValue Format;
					  CValue Position;
            CValue *Params[8] = {&Ident, &Type, &Length, &Scale, &Caption, &Width, &Format, &Position};
            n = GetFieldCount();
            for (int i = 0; i < n; ++i) 
            {
              CDBField& f = operator [](i);              
              Ident  = f.m_strName;
              
              int Len, Scal;
              Type = GetField_1CType(f, Len, Scal);
              Length = Len;
              Scale = Scal;
              pCont->CallAsFunc(staticNewColumn,arValue, Params);
            }            
          }
          else
          {
            int staticColumnCount = pCont->FindMethod("ColumnCount");
            pCont->CallAsFunc(staticColumnCount,arValue, ppPs);
            n = min(GetFieldCount(),arValue.GetNumeric());            
          }

          int staticNewLine     = pCont->FindMethod("NewLine");
          //CValueTable * pVT =((CValueTableContextData*)ppValue[0]->GetContext()->GetInternalData())->GetValueTable();

          if (n > 0)
          {
            res = true;            
            if (m_nRowsetSize > 0)            
            {
              for( ; ! IsEof(); MoveNext() )
              {
                for (m_nCurIndex = 0; m_nCurIndex < GetRowFetched(); ++m_nCurIndex)
                {
                  pCont->CallAsFunc(staticNewLine ,arValue, ppPs);                  
                  //pVT->CValueTable::NewRow(-1); 
                  BYTE* Rowset = GetRowset() + GetRowSize()*m_nCurIndex;
                  for (int i = 0; i < n; ++i)                                  
                  {
                    CValue v;                                        
                    CDBField& f = operator [](i);
                    SetValueOfRow(Rowset, f, i, v, true);
                    //pVT->CValueTable::SetValue(v,i,ind);
                    pCont->SetPropVal(i+1, v);
                    /*CString str;                    
                    str.Format("SetPropVal = %f", v.GetNumeric().GetDouble());
                    
                    pCont->GetPropVal(i+1, v);                    
                    str.Format("v = %f\r\n====================================", v.GetNumeric().GetDouble());
                    pBkEndUI->DoMessageLine(str, mmInformation);*/
                  }
                }
              }
            }
            else
            {            
              for( ; ! IsEof(); MoveNext() )
              {            
                //pBkEndUI->DoMessageLine("NewLine", mmExclamation);
                pCont->CallAsFunc(staticNewLine ,arValue, ppPs);
                //pVT->CValueTable::NewRow(-1); 
                for (int i = 0; i < n; ++i) 
                {               
                  CValue v;                  
                  CDBField& f = operator [](i);
                  SetValueOnDBField(f, v, true);
                  pCont->SetPropVal(i+1, v);
                  //pVT->CValueTable::SetValue(v,i,ind);
                  /*
                  CString str;
                  str.Format("SetPropVal = %f", v.GetNumeric().GetDouble());
                  
                  pCont->GetPropVal(i+1, v);                  
                  str.Format("GetPropVal = %f\r\n====================================", v.GetNumeric().GetDouble());
                  pBkEndUI->DoMessageLine(str, mmInformation);*/
                }                
              }
            }
          }
        }
        rValue = res;        
      }
      break;
	case funcGetFieldDefs:
      {
        int i;
        if (ppValue[0]->buf0[2] == NUMBER_TYPE_1C)
        {
          i = ppValue[0]->GetNumeric();
          if (i > GetFieldCount() || i < 1)
          {
			rValue = "";
			break;
          }
          --i;
          rValue = operator [](i).m_strName;
        }
        else if(ppValue[0]->buf0[2] == STRING_TYPE_1C)
        {
          i = GetFieldIndex(ppValue[0]->GetString());
          rValue = i;
        }
        else
          CBLModule::RaiseExtRuntimeError("    !", 0);
        CDBField& f = operator [](i);

        //1C defs
        int Len, Scal;
        *ppValue[1] = GetField_1CType(f, Len, Scal);
        *ppValue[2] = Len;
        *ppValue[3] = Scal;
        //SQL defs
        *ppValue[4] = f.m_nSQLType;
        *ppValue[5] = f.m_nPrecision;
        *ppValue[6] = f.m_nScale;
        *ppValue[7] = f.m_nNullability;
      }
      break;
    case funcExecute:
      {
        int r = true;
        if (ppValue[0]->buf0[2] == STRING_TYPE_1C)
		{
          m_MetaNameParser.SetQueryText(ppValue[0]->GetString());
          try {
            m_MetaNameParser.Parse();
          } catch (CMNPException * MNPException) {
            m_sLastError = "Meta name parser error: " + MNPException->GetErrorDescr();
            MNPException->Delete();
            r = FALSE;
          };
          if (m_IsDebugMode)
          {
            pBkEndUI->DoMessageLine(m_MetaNameParser.GetQueryText(), mmNone);
          };        
		  if (r)
            r = Execute(m_MetaNameParser.GetQueryText(), ppValue[1]->GetNumeric().operator long());
		}
        else
          r = Execute(NULL, TRUE);
        rValue = r;
        //if (r == FALSE)
        //  CBLModule::RaiseExtRuntimeError(GetLastError(), 0);
      }
      break;
    default:
      {
        CString err;
        err.Format("    : %d)", iMethNum);
        CBLModule::RaiseExtRuntimeError(err, 0);
      }      
  }
  

  return ret;
}

int  C1CPP_ODBCRecordSet::CallAsProc(int iMethNum,class CValue * * ppValue)
{
  switch(iMethNum)
  {    
    case procSetTypeColumn1C:
    {
      int c = GetFieldCount();
      if (c == 0)
        CBLModule::RaiseExtRuntimeError("          ", 0);
      if (ppValue[0]->buf0[2] !=  STRING_TYPE_1C)
        CBLModule::RaiseExtRuntimeError("      !", 0);
      
      const CString &str = ppValue[0]->GetString();
      
      char *token = NULL;
      char *dest = (char*)malloc(str.GetLength()+1);          
      const char *sep = ",";
      int i = 0;
      if (dest)
      {
        strcpy(dest, str);
        token = strtok( dest, sep );
        while( token != NULL  && i < c)
        {         
          CString s(token);
          s.Replace(" ", "");
          CDBField& f = operator [](i++);          
          CMetaDataWork::SetTypeAndKind(f.m_rt, s);

          token = strtok( NULL, sep );
        }
        free(dest);
      }
    }
    break;
    case procSetPropertyCursor:
    {
      int nCurType = ppValue[0]->GetNumeric();
      int nCurScrollable = ppValue[1]->GetNumeric();
      int nCurSensitivity = ppValue[2]->GetNumeric();
      int nCurConcurrency = ppValue[3]->GetNumeric();
      
      if (nCurType < 0 && nCurType > 4)
        CBLModule::RaiseExtRuntimeError("  : SQL_ATTR_CURSOR_TYPE", 0);
      if (nCurScrollable < 0 && nCurScrollable > 2)
        CBLModule::RaiseExtRuntimeError("  : SQL_ATTR_CURSOR_SCROLLABLE", 0);
      if (nCurSensitivity < 0 && nCurSensitivity > 3)
        CBLModule::RaiseExtRuntimeError("  : SQL_ATTR_CURSOR_SENSITIVITY", 0);
      if (nCurConcurrency < 0 && nCurConcurrency > 4)
        CBLModule::RaiseExtRuntimeError("  : SQL_ATTR_CONCURRENCY", 0);

      BOOL ret = FALSE;
      if (nCurType > 0)
      {
        switch(nCurType)
        {
          case 1:
            nCurType = SQL_CURSOR_FORWARD_ONLY;
            break;
          case 2:
            nCurType = SQL_CURSOR_STATIC;
            break;
          case 3:
            nCurType = SQL_CURSOR_KEYSET_DRIVEN;
            break;
          case 4:
            nCurType = SQL_CURSOR_DYNAMIC;
            break;
        }
        SetCursorsTypes(nCurType);
      }
      if (nCurScrollable > 0)
      {
        switch(nCurScrollable)
        {
          case 1:
            nCurScrollable = SQL_NONSCROLLABLE;
            break;
          case 2:
            nCurScrollable = SQL_SCROLLABLE;
            break;          
        }
        SetCursorsScrollable(nCurScrollable);
      }
      if (nCurSensitivity > 0)
      {
        switch(nCurSensitivity)
        {
          case 1:
            nCurSensitivity = SQL_UNSPECIFIED;
            break;
          case 2:
            nCurSensitivity = SQL_INSENSITIVE;
            break;
          case 3:
            nCurSensitivity = SQL_SENSITIVE;
            break;
        }
        SetCursorsSensitivity(nCurSensitivity);
      }      
      if (nCurConcurrency > 0)
      {
        switch(nCurConcurrency)
        {
          case 1:
            nCurConcurrency = SQL_CONCUR_READ_ONLY;
            break;
          case 2:
            nCurConcurrency = SQL_CONCUR_LOCK;
            break;
          case 3:
            nCurConcurrency = SQL_CONCUR_ROWVER;
            break;
          case 4:
            nCurConcurrency = SQL_CONCUR_VALUES;          
            break;          
        }
        SetCursorConcurrency(nCurConcurrency);
      }
    }
    break;
    case procSetRowsetSize:
      {
        SetRowsetSize(ppValue[0]->GetNumeric());
      }
      break;
    case procSetDatabase:
      {
        CBLContext* pCont = ppValue[0]->GetContext();
        bool err = true;
        if (pCont != NULL)
        {
          CString strClassName(pCont->GetRuntimeClass()->m_lpszClassName);
          if ("C1CPP_ODBCDatabase" == strClassName)
          { 
            err = false;
            C1CPP_ODBCDatabase* db = static_cast<C1CPP_ODBCDatabase*>(pCont);
            if (m_pOtherDB!=NULL)
              m_pOtherDB->DecrRef();
            else
            {
              if (m_db.IsConnected())
                m_db.ResetCurrent();
            }

            m_pOtherDB = db;
            
            SetDatabase(db);
            m_pOtherDB->IncrRef();

          }
        }
        if (err)
          CBLModule::RaiseExtRuntimeError("  SetDatabase/   !", 0);
      }
      break;
    case procClose:
      {
        m_MetaNameParser.OnClose();
        Close(ppValue[0]->GetNumeric().operator long());
      }
      break;
    case procSetParam:
      {
        long nPar = m_MetaNameParser.GetSQLParamNumber(*ppValue[0]);
        
        
        if (nPar < 1 || nPar > ParamCount())
          CBLModule::RaiseExtRuntimeError("   ", 0);
        
        int Modifikator;
        if (ppValue[2]->buf0[2] == UNDEFINE_TYPE_1C)
          Modifikator = m_aParams[nPar-1].m_Modificator;
        else
          Modifikator = ppValue[2]->GetNumeric();

        if (!SetValueOfParam(nPar-1, *ppValue[1], Modifikator))
        {
          CBLModule::RaiseExtRuntimeError("     !", 0);
        }                          
      }
      break;
    case procSetDatabase1C:
      {
        
        Close(TRUE);
        if (m_pOtherDB!=NULL)
        {
          m_pOtherDB->DecrRef();
          m_pOtherDB = NULL;
        }
        AttachRecordset(&m_db);
      }
      break;
    case procDebug:
      {
        m_IsDebugMode = ppValue[0]->GetNumeric();
      }
      break;
	case procSetTextParam:
		m_MetaNameParser.SetParameter(ppValue[0]->GetString(), *ppValue[1]);
    break;
	case procAutoTypification:
      SetAutoTypification(ppValue[0]->GetNumeric());
      break;
  case procPutObjectList:
      {
        const char* sType = ppValue[0]->GetTypeString();
        CString TableName = ppValue[1]->GetString();
        CString Query = "if exists(select * from tempdb..sysobjects where id = object_id('tempdb..%tmp'))\r\n\
            drop table %tmp\r\n\
            create table %tmp (val char(9), primary key clustered (val))";
        Query.Replace("%tmp", TableName);
        Execute(Query);

        Query.Format("insert %s values (?)", TableName);
        Prepare(Query);
        AddParam("", SQL_PARAM_INPUT, SQL_CHAR, CType(0), 9, 0);
        CQueryParam & qp = GetParam(0);

      if (!strcmp(sType, "") || !strcmp(sType, "ValueList"))
      {
        CBLContext *pCont = ppValue[0]->GetContext();
        
        int staticGetValue = pCont->FindMethod("GetValue");
        int staticGetListSize = pCont->FindMethod("GetListSize");
        
        CValue ret, par1, par2;
        CValue *params[2] = {&par1, &par2};
        pCont->CallAsFunc(staticGetListSize, ret, NULL);
        int Count = ret.GetNumeric();
        
        for (int i = 1; i <= Count; i++)
        {
            par1 = i;
            pCont->CallAsFunc(staticGetValue, ret, params);
            static_cast<CDBField&>(qp) = m_pMetaData->ToDBString(ret);
            Execute(NULL, TRUE);
        };
      } 
      else if (ppValue[0]->buf0[2] > 3)
      {
        static_cast<CDBField&>(qp) = m_pMetaData->ToDBString(*ppValue[0]);
        Execute(NULL, TRUE);
      } 
      else
      {
          CBLModule::RaiseExtRuntimeError("    !", 0);
          return 0;
      }

        CString RefName = ppValue[2]->GetString();
        if (!RefName.IsEmpty())
        {
            CSbCntTypeDef* SbCntTypeDef = pMetaDataCont->GetSTypeDef(RefName);
            if (SbCntTypeDef->GetLevelsLimit() > 1)
            {
                CString RefTable;
                RefTable.Format("sc%d", SbCntTypeDef->GetID());
                Query = "set nocount on;\
                declare @val char(9)\r\n\
                while 1=1 begin\r\n\
                select @val=max(val) from %tmp left join %sc (nolock) on id = val where isfolder = 1\r\n\
                if @val is null break\r\n\
                insert into %tmp select id from %sc (nolock) where parentid=@val and id not in (select val from %tmp)\r\n\
                delete from %tmp where val=@val\r\n\
                end\r\n\
                set nocount off;";
                Query.Replace("%tmp", TableName);
                Query.Replace("%sc", RefTable);
                Execute(Query);
            };
        };
      };
      break;
    default:
      {
        CString err;
        err.Format("    : %d)", iMethNum);
        CBLModule::RaiseExtRuntimeError(err, 0);
      }
  };
	return 1;
}

int  C1CPP_ODBCRecordSet::GetParamDefValue(int iMethodNum,int iParamNum,class CValue * pDefValue)const
{	
	int ret = 0;
  switch(iMethodNum)
  {
    case funcExeSQL_FromTV:
      {
        if (iParamNum == 1)
        {
          ret = 1;
          *pDefValue = 0L;
        }
      }
    case funcGetParam:
      {
        if (iParamNum == 1)
        {
          ret = 1;
          *pDefValue = "";
        }
      }
      break;
    case procSetPropertyCursor:
      {
        ret = 1;
        switch (iParamNum)
        {
          case 0:            
          case 1:
          case 2:
          case 3:          
            *pDefValue = CNumeric(0);
            break;
        }        
      }
      break;
    case funcExecute:
    {
      if (iParamNum == 1)
      {
        ret = 1;
        *pDefValue = CNumeric(0);
      }
      else if (iParamNum == 0)
      {
        ret = 1;
        *pDefValue = CNumeric(0);
      }
    }
    break;
   case procClose:
    {
      if (iParamNum == 0)
      {
         ret = 1;
        *pDefValue = CNumeric(0);
      }
    }
    break;
    case funcAddParam:
      {
        if (iParamNum == 4)
        {
          ret = 1;
          *pDefValue = "";
        }
      }
      break;
    case funcOpen:
      {
        ret = 1;
        switch (iParamNum)
        {
          case 0:
            *pDefValue = "";
            break;
          case 1:
          case 2:
            *pDefValue = CNumeric(0);
            break;
        }        
      }
      break;
    case funcGetInTablesValues:
      {
        if (iParamNum == 1)
        {
          ret = 1;
          *pDefValue = CNumeric(0);
        }
      }
      break;
    case procDebug:
      {
        if (iParamNum == 0)
        {
          ret = 1;
          *pDefValue = CNumeric(1);
        }
      }
      break;
    case procSetParam:
      {
        if (iParamNum == 2)
        {
          ret = 1;
          *pDefValue = CNumeric(0);
        }
      }
      break;
    case funcGetFieldDefs:
      { 
        if (iParamNum >= 1 && iParamNum <= 7)
        {
          ret = 1;
          *pDefValue = CNumeric(0);
        }
      }
      break;
    case procAutoTypification:
      { 
        if (iParamNum == 0)
        {
          ret = 1;
          *pDefValue = CNumeric(1);
        }
      }
      break;
    case procPutObjectList:
      {
        if (iParamNum == 2)
        {
          ret = 1;
          *pDefValue = CString("");
        }
      }
  }
	return ret;
}

int  C1CPP_ODBCRecordSet::FindMethod(char const * lpMethodName) const
{	
	return defFnNames.GetIndexByName(lpMethodName);
}

char const *  C1CPP_ODBCRecordSet::GetMethodName(int iMethodNum,int iMethodAlias)const
{
	return defFnNames[iMethodNum].Names[iMethodAlias];
}

int  C1CPP_ODBCRecordSet::GetNMethods(void)const
{
	return defFnNames.Size();
}

int  C1CPP_ODBCRecordSet::HasRetVal(int iMethodNum)const
{	
	return defFnNames[iMethodNum].HasReturnValue ;
}

int C1CPP_ODBCRecordSet::GetNParams(int iMethodNum)const
{	
  int ret;
  if (iMethodNum == funcGetValues)
    ret = n_nCountUnlimitPars;
  else
	  ret = defFnNames[iMethodNum].NumberOfParams;

  return ret;
}





void  C1CPP_ODBCRecordSet::DecrRef(void)
{
	CBLContext::DecrRef();
}



char const *  C1CPP_ODBCRecordSet::GetCode(void)const
{
	return 0;
}

int  C1CPP_ODBCRecordSet::GetDestroyUnRefd(void)const
{
	return 1;
}

void  C1CPP_ODBCRecordSet::GetExactValue(class CValue & vParam)
{
	CBLContext::GetExactValue(vParam);
}

class CObjID   C1CPP_ODBCRecordSet::GetID(void)const
{
	return ObjID;
}

class CBLContextInternalData *  C1CPP_ODBCRecordSet::GetInternalData(void)
{

	return CBLContext::GetInternalData();

}




long  C1CPP_ODBCRecordSet::GetTypeID(void)const
{
	return 100;
}

char const *  C1CPP_ODBCRecordSet::GetTypeString(void)const
{
	return "ODBCRecordSet";
}

class CType   C1CPP_ODBCRecordSet::GetValueType(void)const
{
	CType tType(100);
	
	return tType;
}


void  C1CPP_ODBCRecordSet::IncrRef(void)
{
	CBLContext::IncrRef();
}

void  C1CPP_ODBCRecordSet::InitObject(class CType const & tType)
{
	CBLContext::InitObject(tType);
}

void  C1CPP_ODBCRecordSet::InitObject(char const * strName)
{
	CBLContext::InitObject(strName);
}

int  C1CPP_ODBCRecordSet::IsExactValue(void)const
{
	return 0;
}

int  C1CPP_ODBCRecordSet::IsOleContext(void)const
{  
  int regEBX = 0;
  __asm {
    mov regEBX, ebx //    1      
  }
  n_nCountUnlimitPars= regEBX; //     
	return 0;
}

int  C1CPP_ODBCRecordSet::IsPropReadable(int iPropNum)const
{
  if (iPropNum == 1)
    return 1;
	return 0;
}

int  C1CPP_ODBCRecordSet::IsPropWritable(int iPropNum)const
{
	return 0;
}

int  C1CPP_ODBCRecordSet::IsSerializable(void)
{
	return 0;
}

int  C1CPP_ODBCRecordSet::SaveToString(class CString & csStr)
{
	csStr = "";
	return 1;
}

void  C1CPP_ODBCRecordSet::SelectByID(class CObjID cID,long lNum)
{
	CBLContext::SelectByID(cID,lNum);
}


int  C1CPP_ODBCRecordSet::GetNProps(void)const
{
	return 1;
}

char const *  C1CPP_ODBCRecordSet::GetPropName(int A,int B)const
{
  if (A == 0)
    return "md";

	return NULL;
}

int  C1CPP_ODBCRecordSet::GetPropVal(int iPropNum,class CValue & rValue)const
{
  if (iPropNum == 0)
  {    
    rValue.AssignContext(m_pMetaData);
    return 1;
  }
	return -1;
}

int  C1CPP_ODBCRecordSet::SetPropVal(int iPropNum,class CValue const & vValue)
{
	return -1;
}

int  C1CPP_ODBCRecordSet::FindProp(char const * Name)const
{
  if (!stricmp(Name,"md"))
    return 0;
  if (!stricmp(Name,""))
    return 0;

	return -1;
}

void C1CPP_ODBCRecordSet::SetValueOnDBField(CDBField &field, CValue &val, bool bAgg)
{
  CType& rt = field.m_rt;  
  switch( field.m_nCType ) 
  {		        
    case	SQL_C_BIT:
			  val= field.AsBool();
			  break;
	  case	SQL_C_UTINYINT:
			  val = field.AsChar();
			  break;
	  case	SQL_C_SSHORT:
			  val = field.AsShort();
			  break;
	  case	SQL_C_SLONG:
          {
            if (rt.GetTypeCode() == CALCULATIONKIND_TYPE_1C)
            { //Specially for sql database format
              val.SetType(rt);    		
	          val.SetObjID(CObjID(field.AsLong(),CDBSign("   ")));
            }
            else
			  val = field.AsLong();
          }
			  break;
	  case	SQL_C_FLOAT:
		  {	
        val.SetType(CType(1));
			  val = CNumeric(field.AsFloat());
			  break;
		  }
	  case	SQL_C_DOUBLE:		  
      {				                
        val.SetType(CType(1));
			  val = CNumeric(field.AsDouble());        
			  break;
		  }
	  case	SQL_C_TIMESTAMP:
		  {				        
        COleDateTime date = field.AsDate();        
        CDate d(date.GetYear(),date.GetMonth(),date.GetDay());
        val = d;
		  }
      break;
	  case	SQL_C_CHAR:
		  {
        int nType = rt.GetTypeCode();
				if (nType == WORD(-1))
				{
					nType = 2;
				}	

				if (!bAgg || (nType > 0 && nType < 10))
				{
			    val = field.AsString();
        }
        else
        {   
          CMetaDataWork::TypeStringValue eType;
                CString str = field.AsString();

                if (rt.GetTypeCode() == CALCULATIONKIND_TYPE_1C && str.GetLength() == 4)
                { //Specially for dbf database format
                    val.SetType(rt);    		
	                val.SetObjID(CObjID(strtol(str, NULL, 36),CDBSign("   ")));
                    break;
                }
                else if (rt.GetTypeCode() == DOCUMENT_TYPE_1C && rt.GetTypeID() == 0 && str.GetLength() == 9)
                {
                    CString sKindField;
                    int nKindField;

                    sKindField = field.m_strName;
                    sKindField += DocKindSuffixEng;
                    nKindField = GetFieldIndex(sKindField);
                    if (nKindField == -1)
                    {
                        sKindField = field.m_strName;
                        sKindField += DocKindSuffixRus;
                        nKindField = GetFieldIndex(sKindField);

                    };

                    if (nKindField == -1)
                        val = str;
                    else
                    {
                        CDBField &KindField = operator[](nKindField);
                        CType t(12);

                        if (pDataBase7->GetDataSourceType() == DATA_SOURCE_TYPE_SQL)
                            t.SetTypeID(KindField.AsInt());
                        else
                            t.SetTypeID(strtol(KindField.AsString(), NULL, 36));

                        CMetaDataWork::Make1C_ValueFromString(val, t, str, CMetaDataWork::ShortString);
                    }
                    break;
                }
                else
                {
          if (nType == 0)
            eType = CMetaDataWork::VeryLongString;
          else
            eType = rt.GetTypeID() == 0 ? CMetaDataWork::LongString: CMetaDataWork::ShortString;
                }

                CMetaDataWork::Make1C_ValueFromString(val, rt, str, eType);
            }
        }
			  break;
	  case	SQL_C_BINARY:
      {
			  val.Reset();
			  break;
      }
	  default:
		  ASSERT( FALSE );
	}            
}

void C1CPP_ODBCRecordSet::SetValueOfRow(BYTE *Rowset, CDBField &dbf, int Index, CValue &rVal, bool bAgg)
{
  BYTE* pData = &Rowset[GetOffset(Index)];    
  BYTE* p = pData + dbf.m_nBufSize;  
  CType& rt = dbf.m_rt;

  if (*(SQLINTEGER*)p != SQL_NULL_DATA)
  {    		
    
		switch( dbf.m_nCType ) {
		case	SQL_C_BIT:
      {      
			  rVal = *(bool*)pData;
      }
			break;
		case	SQL_C_UTINYINT:
      {      
			  rVal = *(UCHAR*)pData;
      }
			break;

		case	SQL_C_SSHORT:
      {      
			  rVal = *(short*)pData;
      }
			break;

		case	SQL_C_SLONG:
      {        
			  rVal = *(long*)pData;
      }
			break;
		case	SQL_C_FLOAT:
			{      
			  
        rVal.SetType(CType(1));
			  rVal = CNumeric(*(float*)pData);       
				break;
			}

		case	SQL_C_DOUBLE:
			{                 
        rVal.SetType(CType(1));
	  		rVal = CNumeric(*(long double*)pData);        
				break;
			}

		case	SQL_C_TIMESTAMP:
			{				                             
        TIMESTAMP_STRUCT* pdate = (TIMESTAMP_STRUCT*)pData;                
        CDate date(pdate->year,pdate->month,pdate->day);
        rVal = date;        
			}
      break;

		case	SQL_C_CHAR:
			{			        
        {
          int nType = rt.GetTypeCode();
				  if (nType == WORD(-1))
				  {
					  nType = 2;
				  }	
        
				  if (!bAgg || (nType > 0 && nType < 10))
				  {
					  rVal = (const char*)pData;
				  }
				  else
				  {
            CMetaDataWork::TypeStringValue eType;
            if (nType == 0)
              eType = CMetaDataWork::VeryLongString;
            else
              eType = rt.GetTypeID() == 0 ? CMetaDataWork::LongString: CMetaDataWork::ShortString;

					  CMetaDataWork::Make1C_ValueFromString(rVal, rt, (char*)pData, eType);					
				  }   
        }        
				break;
			}
		case	SQL_C_BINARY:
				rVal.Reset();
				break;
		default:
			ASSERT( FALSE );
		}
	}
  else
  { 
    switch( dbf.m_nCType ) 
    {
      case	SQL_C_BIT:
      case	SQL_C_UTINYINT:      
		  case	SQL_C_SSHORT:    
		  case	SQL_C_SLONG:      
		  case	SQL_C_FLOAT:			
		  case	SQL_C_DOUBLE:
			  {                 			
          rVal = 0L; 				
			  }
      break;
      case	SQL_C_TIMESTAMP:
        {
          rVal.SetType(CType(3));
        }
      break;
      case SQL_C_CHAR:
        {
          
          int nType = rt.GetTypeCode();
				  if (nType == WORD(-1))
				  {
					  rVal.SetType(CType(2));
				  }	
          else
            rVal.SetType(dbf.m_rt);
        }      
    }    
  }
}

bool C1CPP_ODBCRecordSet::SetValueOfParam(int nParam, const CValue &vSource, const int Modificator)
{
  CDBField& qp = static_cast<CDBField&>(GetParam(nParam));
  bool ret = true;
    
  switch(vSource.buf0[2])
  {
    case NUMBER_TYPE_1C:
      {
        qp = (double)vSource.GetNumeric().GetDouble();
      }
      break;
    case DATE_TYPE_1C:
      {
        const CDate &date = vSource.GetDate();
			  qp = COleDateTime(date.GetYear(),date.GetMonth(),date.GetMonthDay(),0,0,0);
      }
      break;
    default:
      {
        CString Str;
        bool IsStrLit;
        ret = CMetaNameParser::CValueToDBValue(vSource, Modificator, Str, IsStrLit);
        if (IsStrLit)
          qp = Str;
      }
  }                   

  return ret;
}

CString C1CPP_ODBCRecordSet::GetField_1CType(CDBField & Field, int & Length, int & Scale)
{
    Length = 0;
    Scale = 0;
    CType & t = Field.m_rt;
    int i = t.GetTypeCode();

    if (t.GetTypeCode() < 0 || t.GetTypeCode() > 15) {
        switch(Field.m_nSQLType) {
        case SQL_BIT:
            Length = 1;
            return "";
            break;

        case SQL_TINYINT:
            Length = 3;
            return "";
            break;

        case SQL_SMALLINT:
            Length = 5;
            return "";
            break;

        case SQL_INTEGER:
            Length = 10;
            return "";
            break;

        case SQL_REAL:
        case SQL_FLOAT:
        case SQL_DOUBLE:
            return "";
            break;
        case SQL_NUMERIC:
            if (Field.m_nScale)
                Length = Field.m_nPrecision + 1;
            else
                Length = Field.m_nPrecision;
            Scale = Field.m_nScale;
            return "";
            break;

        case SQL_DATE:
        case SQL_TIME:
        case SQL_TIMESTAMP:
        case SQL_TYPE_DATE:
        case SQL_TYPE_TIME:
        case SQL_TYPE_TIMESTAMP:
            return "";
            break;

        case SQL_DECIMAL:
            if (Field.m_nScale)
                Length = Field.m_nPrecision + 1;
            else
                Length = Field.m_nPrecision;
            Scale = Field.m_nScale;
            return "";
            break;

        case SQL_BIGINT:
        case SQL_CHAR:
            Length = Field.m_nPrecision;
            return "";
            break;
        case SQL_VARCHAR:
        case SQL_LONGVARCHAR:
        case SQL_WCHAR:
        case SQL_WVARCHAR:
        case SQL_WLONGVARCHAR:
        case SQL_BINARY:
        case SQL_VARBINARY:
        case SQL_LONGVARBINARY:
        default:
            return "";
        }
    }
    else
    {
        int TypeCode = t.GetTypeCode();
        CString Type;
#ifdef _DEBUG
        switch(TypeCode)
        {
        case 1: Type = ""; break;
        case 2: Type = ""; break;
        case 3: Type = ""; break;
        case 10: Type = ""; break;
        case 11: Type = ""; break;
        case 12: Type = ""; break;
        case 13: Type = ""; break;
        case 14: Type = ""; break;
        case 15: Type = ""; break;
        default: Type = ""; break;
        }
#else
        Type = t.GetTypeTitle();
#endif
        if (TypeCode > 10) {
          CMetaDataObj* Obj = pMetaDataCont->FindObject(t.GetTypeID());
          if (Obj)
          {
            Type += '.';
            Type += Obj->GetCode();
            //pBkEndUI->DoMessageLine(Type, mmExclamation);	
          }
        }

        Length = t.GetLength();
        Scale = t.GetPrecision();
        return Type;
    }
};
