#include "stdafx.h"
#include "Service.h"
#include "TreeChoose.h"
#include "MDIClientWnd.h"
#include ".\\TurboBL\\gcboost.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

extern CBkEndUI * pBkEndUI;
extern BOOL m_bEnabledColor;
extern BOOL m_bLocalColor;
extern BOOL m_bShowKL;
extern UINT StatusTimer;
extern CMDIClientWnd * wndMDIClient;

IMPLEMENT_DYNCREATE_OXY(CService);

class CObjID CService::ObjID;

struct CService::paramdefs CService::defFnNames[] = {
	{{"ColourBrowse",""}, FALSE, 1},
	{{"UnColourBrowse",""}, FALSE, 0},
	{{"ActiveContext",""}, TRUE, 1},
	{{"LoadModule",""}, TRUE, 1},
	{{"UnLoadModule",""}, TRUE, 0},
	{{"CallAsProcedure",""}, TRUE, 3},
	{{"CallAsFunction",""}, TRUE, 4},
	{{"GetContextVar",""}, TRUE, 3},
	{{"SetContextVar",""}, TRUE, 3},
	{{"ChooseValue",""}, TRUE, 5},
	{{"AddGlobalModule",""}, TRUE, 1},
	{{"DeleteGlobalModule",""}, TRUE, 1},
	{{"ShowKeyboardIndicator",""}, FALSE, 1},
	{{"SetWallpaper",""}, FALSE, 3},
	{{"HeightTableString",""}, TRUE, 3},
	{{"HideTable",""}, FALSE, 2},
	{{"GetTableNames",""}, TRUE, 1},
	{{"Test",""}, FALSE, 1},
	{NULL,0,0}
	};

CBLModule* GetModuleByContext(CGroupContext* pCont)
{
  CBLModule * pMod = NULL;  
	if(pCont->m_FlagAutoDestroy > 100) 
  {              
    pMod = ((CGCBoost::SGCInfo*)pCont->m_FlagAutoDestroy)->m_pMod;
  }
  return pMod;
}

CService::CService():CBLContext()
{
}

CService::CService(int param):CBLContext(param)
{
}

CService::~CService()
{
}

int GetFromVL(structVIA** pVIA, PValueItemArrayT* pValItAr, int count, ULONG* index, CPtrArray* AllValues, CPtrArray* AllValuesArray)
{
	for(int i=0; i<count; i++)
	{
		(*index)++;
		CValue* val = (CValue*)pValItAr->GetAt(i);
		CBLContext* pVLCont = val->GetContext();
		pVIA[i] = (structVIA*)malloc(sizeof(structVIA));
		pVIA[i]->Value = val;
		AllValues->Add(val);
		AllValuesArray->Add(pVIA[i]);
		pVIA[i]->Index = (DWORD)(*index);
		pVIA[i]->Checked = ((CValueItem*)val)->GetCheck();
		pVIA[i]->ValueItem = (CValueItem*)val;
		CString str = ((CValueItem*)val)->GetPresent();
		pVIA[i]->Descr = new CString;
		pVIA[i]->Type  = 1;
		pVIA[i]->Count = 0;
		*(pVIA[i]->Descr) = str;
		if(pVLCont) 
		{
			if(!strcmp(pVLCont->GetRuntimeClass()->m_lpszClassName,"CValueListContext"))
			{
				pVIA[i]->Type  = 0;

				CValueListContextData* pVLCD = ((CValueListContextData*)pVLCont->GetInternalData());
				PValueItemArrayT *pValItArNew = (PValueItemArrayT*)pVLCD->GetValueList();
				int s = pValItArNew->GetSize();
				pVIA[i]->NextLevel = new PstructVIA[s];
				pVIA[i]->Count = GetFromVL(pVIA[i]->NextLevel, pValItArNew, s, index, AllValues, AllValuesArray);
			}
		}
	}
	return count;
}

UINT GetMenuFromVL(CMenu* pMenuChoose,structVIA** pVIA,int count, BOOL WithCheck)
{
	for(int i = 0; i<count; i++)
	{
		if(*(pVIA[i]->Descr) == "-")
		{
			pMenuChoose->AppendMenu(MF_SEPARATOR);
		}
		else if(pVIA[i]->Type == 1)
		{
			UINT nFlags = MF_STRING; // | MF_POPUP
			if(WithCheck && pVIA[i]->Checked) nFlags |= MF_CHECKED;

			pMenuChoose->AppendMenu(nFlags,pVIA[i]->Index,(LPCTSTR)*(pVIA[i]->Descr));
		}
		else
		{
			CMenu *SubMenu;
			SubMenu = new CMenu;
			SubMenu->CreatePopupMenu();
			GetMenuFromVL(SubMenu,pVIA[i]->NextLevel, pVIA[i]->Count, WithCheck);
			pMenuChoose->InsertMenu(i,MF_BYPOSITION | MF_STRING | MF_POPUP | MF_INSERT,
				(UINT)SubMenu->Detach(),
				(LPCTSTR)*(pVIA[i]->Descr));
			SubMenu->DestroyMenu();
			delete SubMenu;
		}
	}
	return 0;
}


void FreeVL(structVIA** pVIA, int count)
{
	for(int i=0; i<count; i++)
	{
		if(pVIA[i]->Type == 0) FreeVL(pVIA[i]->NextLevel, pVIA[i]->Count);
		delete pVIA[i]->Descr;
		free(pVIA[i]);
	}
	delete [] pVIA;
}

int  CService::CallAsFunc(int iMethNum,class CValue & rValue,class CValue * *ppValue)
{
	try{
	switch (iMethNum)
	{
	case methActiveContext:
		{
			rValue = 0L;
			CMDIFrameWnd * pMainFrame = GetMainFrame();
			if(pMainFrame)
			{
				CMDIChildWnd * pChild = pMainFrame->MDIGetActive();
								
				if(pChild)
				{
					CDocument* pDoc = pChild->GetActiveDocument();
					if(pDoc)
					{
						if(!strcmp(pDoc->GetRuntimeClass()->m_pfnGetBaseClass()->m_lpszClassName,"CGetDoc7"))
						{
							CGroupContext *pCont = ((CGetDoc7*)pDoc)->GetGroupContext();
							if(pCont)
							{
								rValue = 1L;
								pCont->IncrRef();
								ppValue[0]->AssignContext(pCont);
							}
						}
					}
				}
			}
			break;
		}
	case methLoadModule:
		{
      rValue = 0L;
			CBLModule * pMod = CBLModule::GetExecutedModule();
      CBLContext* pCont = CBLModuleWrapper::GetContextFromModule(pMod);
      if (pCont)      
      {
        if (!(pCont->m_FlagAutoDestroy > 100))        
          pCont->m_FlagAutoDestroy = (int)new CGCBoost::SGCInfo(pMod,NULL);

        rValue = 1L;
      }
			break;
		}
	case methUnLoadModule:
		{      
      rValue = 0L;
			CBLModule * pMod = CBLModule::GetExecutedModule();
      CBLContext* pCont = CBLModuleWrapper::GetContextFromModule(pMod);
      if (pCont)      
      {
        rValue = 1L;
        if (((CGCBoost::SGCInfo*)pCont)->m_pData == NULL)
          delete (CGCBoost::SGCInfo*)pCont->m_FlagAutoDestroy;
      }			
			break;
		}
	case methCallAsProcedure:
		{
			rValue = 0L;
			CGroupContext * pCont = (CGroupContext*)ppValue[0]->GetContext();
			CBLModule * pMod;
			if(pCont)
			{
				pMod = GetModuleByContext(pCont);
			}
			else
			{
				pMod = CBLModule::GetExecutedModule();
			}
			if(pMod)
			{
				int r = pMod->FindProc(ppValue[1]->GetString(),0);
				if(r<0) r = pMod->FindFunc(ppValue[1]->GetString());
				if(r>=0)
				{
					CBLProcInfo * pProcInfo;
					pProcInfo = new CBLProcInfo();
					pMod->GetProcInfo(r,*pProcInfo);
					int nParams = pProcInfo->GetNParams();
					int s = 0;
					int i;

					CValue** lArray = new PValueT[nParams];
    
					CBLContext* pValListCont = ppValue[2]->GetContext();
					if(pValListCont)
					{
						if(!strcmp(pValListCont->GetRuntimeClass()->m_lpszClassName,"CValueListContext"))
						{
							CValueListContextData* pVLCD = ((CValueListContextData*)pValListCont->GetInternalData());
							PValueItemArrayT *pValItAr = (PValueItemArrayT*)pVLCD->GetValueList();
							if(nParams>=pValItAr->GetSize()) s = pValItAr->GetSize();
							else s = nParams;

							for(i=0; i<s; i++) lArray[i] = (CValue*)pValItAr->GetAt(i);
						}
					}

					for(i=s; i<nParams; i++)
					{
						lArray[i] = (CValue*)malloc(sizeof(CValue));
						lArray[i]->CValue::CValue();
					}

					rValue = pMod->CallAsProc(r,nParams,lArray);
					if(rValue.GetNumeric() == 0)
					{
						CValue arValue;
						rValue = pMod->CallAsFunc(r,arValue,nParams,lArray);
					}

					for(i=s; i<nParams; i++)
					{
						lArray[i]->CValue::~CValue();
						free(lArray[i]);
					}
					delete pProcInfo;
				}
			};
			break;
		}
	case methCallAsFunction:
		{
			rValue = 0L;
			CGroupContext * pCont = (CGroupContext*)ppValue[0]->GetContext();
			CBLModule * pMod;
			if(pCont)
			{
				pMod = GetModuleByContext(pCont);
			}
			else
			{
				pMod = CBLModule::GetExecutedModule();
			}
			if(pMod)
			{
				int r = pMod->FindFunc(ppValue[1]->GetString());
				if(r>=0)
				{
					CBLProcInfo * pProcInfo;
					pProcInfo = new CBLProcInfo();
					pMod->GetProcInfo(r,*pProcInfo);
					int nParams = pProcInfo->GetNParams();
					int s = 0;
					int i;
					CValue** lArray = new PValueT[nParams];

					CBLContext* pValListCont = ppValue[2]->GetContext();
					if(pValListCont)
					{
						if(!strcmp(pValListCont->GetRuntimeClass()->m_lpszClassName,"CValueListContext"))
						{
							CValueListContextData* pVLCD = ((CValueListContextData*)pValListCont->GetInternalData());
							PValueItemArrayT *pValItAr = (PValueItemArrayT*)pVLCD->GetValueList();
							if(nParams>=pValItAr->GetSize()) s = pValItAr->GetSize();
							else s = nParams;

							for(i=0; i<s; i++) lArray[i] = (CValue*)pValItAr->GetAt(i);
						}
					}

					for(i=s; i<nParams; i++)
					{
						lArray[i] = (CValue*)malloc(sizeof(CValue));
						lArray[i]->CValue::CValue();
					}

					CValue arValue;

					rValue = pMod->CallAsFunc(r,arValue,nParams,lArray);
					if(rValue.GetNumeric()) *ppValue[3] = arValue;

					for(i=s; i<nParams; i++)
					{
						lArray[i]->CValue::~CValue();
						free(lArray[i]);
					}
					delete pProcInfo;
				}
			}
			break;
		}
	case methGetContextVar:
		{
			rValue = 0L;
			CGroupContext * pCont = (CGroupContext*)ppValue[0]->GetContext();
			CBLModule * pMod;
			if(pCont)
			{
				pMod = GetModuleByContext(pCont);
			}
			else
			{
				pMod = CBLModule::GetExecutedModule();
			}
			if(pMod)
			{
				int r = pMod->FindStaticVar(ppValue[1]->GetString());
				if(r>=0)
					rValue = pMod->GetStaticVarValue(r,*ppValue[2],0);
			}
			break;
		}
	case methSetContextVar:
		{
			rValue = 0L;
			CGroupContext * pCont = (CGroupContext*)ppValue[0]->GetContext();
			CBLModule * pMod;
			if(pCont)
			{
				pMod = GetModuleByContext(pCont);
			}
			else
			{
				pMod = CBLModule::GetExecutedModule();
			}
			if(pMod)
			{
				int r = pMod->FindStaticVar(ppValue[1]->GetString());
				if(r>=0) rValue = pMod->SetStaticVarValue(r,*ppValue[2],0);
			}
			break;
		}
	case methChooseValue:
		{
			pBkEndUI->DoStatusLine(" ");
			rValue = 0L;
			CBLContext* pValListCont = ppValue[0]->GetContext();
			if(pValListCont)
			{
				if(!strcmp(pValListCont->GetRuntimeClass()->m_lpszClassName,"CValueListContext"))
				{
					CValueListContextData* pVLCD = ((CValueListContextData*)pValListCont->GetInternalData());
					PValueItemArrayT *pValItAr = (PValueItemArrayT*)pVLCD->GetValueList();

					int s = pValItAr->GetSize();
					structVIA** pVIA = new PstructVIA[s];
					CPtrArray AllValues;
					CPtrArray AllValuesArray;
					ULONG index = 0;
					GetFromVL(pVIA, pValItAr, s, &index, &AllValues, &AllValuesArray);

					if(ppValue[3]->GetNumeric() == 1)
					{
            AFX_MANAGE_STATE(AfxGetStaticModuleState())
            CTreeChoose* pTreeChoose;
						pTreeChoose = new CTreeChoose((char*)(LPCSTR)ppValue[2]->GetString(), GetMainFrame());
						pTreeChoose->SetTreeArray(pVIA, s);
						pTreeChoose->m_SelGroup = (ppValue[4]->GetNumeric() !=  0);
						int nRet = -1;
						nRet = pTreeChoose->DoModal();

						switch ( nRet )
						{
							case IDOK:
								if(pTreeChoose->m_Selected)
								{
									rValue = 1L;
									*ppValue[1] = *((CValue*)(pTreeChoose->m_Selected));
								}
								break;
							case -1:
								pBkEndUI->DoMessageLine("ERROR!", mmNone);
								break;
							default:
								break;
						};

						delete pTreeChoose;
					}
					else
					{
						POINT pos;
						pos.x = 0;
						pos.y = 0;
						::GetCursorPos(&pos);
						BOOL CheckItem = ((ppValue[4]->GetNumeric() == 1) || (ppValue[4]->GetNumeric() == 3));
						CGetDoc7* pDoc7 = CGetDlg::GetTopmostDocunent();
						CWnd* pParent = NULL;
						if(pDoc7)
						{
							CGetDlg* pGetDlg = (CGetDlg*)pDoc7->GetFrame();
							if(pGetDlg)
							{
								pParent = (CWnd*)pGetDlg;
								if(ppValue[4]->GetNumeric() < 2)
								{
									CGetField * pField = ((CGetDoc7*)pDoc7)->GetActiveField();
									if(pField)
									{
										CBrowse* pBr = ((CGetDoc*)pDoc7)->GetBrowse();
										int ColIndex = -1;
										if(pBr)
											ColIndex = pBr->GetColumnIndex(((CFormCtrl*)pField)->m_ID);
										if(ColIndex < 0)
										{
										CWnd* pWnd = pGetDlg->GetDlgItem(((CFormCtrl*)pField)->m_ID);
										if(pWnd)
										{
											RECT rcItem = {0,0,0,0};
												if(CString("CBrowse") == pWnd->GetRuntimeClass()->m_lpszClassName)
												{
													int curCol = (int)*((int*)pWnd+0x31);
													int curRow = (int)*((int*)pWnd+0x30);
													if((*((int*)pWnd+0x23) == 0) && (*((int*)pWnd+0x2A) >= 0))
														curRow =  (int)*((int*)pWnd+0x2A);
													((CBrowse*)pWnd)->GetCellRect(&rcItem, curRow,curCol);
													pWnd->ClientToScreen(&rcItem);
												}
												else
												{
											pWnd->GetWindowRect(&rcItem);
												}
												pos.x = rcItem.left;
												pos.y = rcItem.bottom;
											}
										}
										else
										{
											RECT rcItem = {0,0,0,0};
											int curCol = (int)*((int*)pBr+0x31);
											int curRow = (int)*((int*)pBr+0x30);
											if((*((int*)pBr+0x23) == 0) && (*((int*)pBr+0x2A) >= 0))
												curRow =  (int)*((int*)pBr+0x2A);
											pBr->GetCellRect(&rcItem, curRow,curCol);
											pBr->ClientToScreen(&rcItem);
											pos.x = rcItem.left;
											pos.y = rcItem.bottom;
										}
									}
								}
							}
						}
						else
						{
							CMDIFrameWnd * pMainFrame = GetMainFrame();
							if(pMainFrame)
							{
								CMDIChildWnd * pChild = pMainFrame->MDIGetActive();
								if(pChild)
								{
									CView* pView = pChild->GetActiveView();
									if(pView)
									{
										pParent = (CWnd*)pView;
										if(ppValue[4]->GetNumeric() < 2)
										{
											CDocument* pDoc = pView->GetDocument();
											if(pDoc)
											{
												CGetField * pField = ((CGetDoc7*)pDoc)->GetActiveField();
												if(pField)
												{
													CBrowse* pBr = ((CGetDoc*)pDoc)->GetBrowse();
													int ColIndex = -1;
													if(pBr)
														ColIndex = pBr->GetColumnIndex(((CFormCtrl*)pField)->m_ID);
													if(ColIndex < 0)
													{
													CWnd* pWnd = pView->GetDlgItem(((CFormCtrl*)pField)->m_ID);
													if(pWnd)
													{
														RECT rcItem = {0,0,0,0};
															if(CString("CBrowse") == pWnd->GetRuntimeClass()->m_lpszClassName)
															{
																int curCol = (int)*((int*)pWnd+0x31);
																int curRow = (int)*((int*)pWnd+0x30);
																if((*((int*)pWnd+0x23) == 0) && (*((int*)pWnd+0x2A) >= 0))
																	curRow =  (int)*((int*)pWnd+0x2A);
																((CBrowse*)pWnd)->GetCellRect(&rcItem, curRow,curCol);
																pWnd->ClientToScreen(&rcItem);
															}
															else
															{
														pWnd->GetWindowRect(&rcItem);
															}
															pos.x = rcItem.left;
															pos.y = rcItem.bottom;
														}
													}
													else
													{
														RECT rcItem = {0,0,0,0};
														int curCol = (int)*((int*)pBr+0x31);
														int curRow = (int)*((int*)pBr+0x30);
														if((*((int*)pBr+0x23) == 0) && (*((int*)pBr+0x2A) >= 0))
															curRow =  (int)*((int*)pBr+0x2A);
														pBr->GetCellRect(&rcItem, curRow,curCol);
														pBr->ClientToScreen(&rcItem);
														pos.x = rcItem.left;
														pos.y = rcItem.bottom;
													}
												}
											}
										}
									}
								}
							}
						}
						CMenu* pMenuChoose;
						pMenuChoose = new CMenu;
						pMenuChoose->CreatePopupMenu();
						GetMenuFromVL(pMenuChoose,pVIA,s, CheckItem);
						UINT nRet = pMenuChoose->TrackPopupMenu(TPM_RETURNCMD | TPM_NONOTIFY | TPM_LEFTALIGN | TPM_LEFTBUTTON,pos.x,pos.y,pParent);
						if(nRet)
						{
							rValue = 1L;
							if(CheckItem)
							{
								structVIA* pVIAres = (structVIA*)AllValuesArray.GetAt(nRet-1);
								pVIAres->ValueItem->SetCheck(!(pVIAres->Checked));
								*ppValue[1] = *((CValue*)(pVIAres->Value));
							}
							else
								*ppValue[1] = *((CValue*)(AllValues.GetAt(nRet-1)));
						}
						pMenuChoose->DestroyMenu();
						delete pMenuChoose;

					}

					AllValues.RemoveAll();
					AllValuesArray.RemoveAll();
					FreeVL(pVIA, s);

				}
				else pBkEndUI->DoMessageLine(" ",mmRedErr);
			}
			else pBkEndUI->DoMessageLine(" ",mmRedErr);
			break;
		}
	case methAddGlobalModule:
		{
			rValue = 0L;
			CBLModule7* pNewMod;
			pNewMod = new CBLModule7(CBLContext::GetLoadedContext(CBLContext::GetFirstLoadedContextID()), ppValue[0]->GetString());
			if(pNewMod->Compile())
			{
				if(pNewMod->PrepareToLoad())
				{
					if(pNewMod->Load())
					{
						CBLModule7 * pGlobMod = GetGlobalModule();
						pGlobMod->AssignFriendModule(pNewMod);
						if(pNewMod->Execute() != 0) rValue = pNewMod->GetLoadedID();
					}
				}
			}

			break;
		}
	case methDeleteGlobalModule:
		{
			rValue = 0L;
			CBLModule* pGlobMod = GetGlobalModule();
			ULONG id = ppValue[0]->GetNumeric();

			bool f = true;
			if(pGlobMod) f = (id != pGlobMod->GetLoadedID());
			if((id != 0) && f)
			{
				CBLModule* pNewMod;
				pNewMod = CBLModule::GetLoadedModule(id);
				if(pNewMod)
				{
					pNewMod->Unload();
					pNewMod->~CBLModule();
					rValue = 1L;
				}
			}

			break;
		}
	case methHeightTableString:
		{
			CBLContext* pCont = ppValue[0]->GetContext();//CTableOutputContext
			
//			CSheet* pSheet0 = (CSheet*)(*((DWORD*)pCont+14));
//			CSheetDoc* pSheetDoc0 = (CSheetDoc*)(*((DWORD*)pCont+11));
//			CSheet* pSheet = (CSheet*)(*((DWORD*)pCont+10));

			CSheetDoc* pSheetDoc = (CSheetDoc*)(*((DWORD*)pCont+8));
			POSITION aPOS = pSheetDoc->GetFirstViewPosition();
			CSheetView* pSheetView = (CSheetView*)pSheetDoc->GetNextView(aPOS);
			rValue = 0L;
			if(pSheetView)
			{
				int row = ppValue[1]->GetNumeric();
				if(row>0)
				{
					CRect rect = pSheetView->GetCellRect(row - 1,0);
					if(ppValue[2]->GetNumeric() == 1)
					{
						rValue = pSheetView->YPixelToMillimeters(rect.Height());
						rValue = rValue.GetNumeric()/CNumeric(100);
					}
					else if(ppValue[2]->GetNumeric() == 2)
						rValue = rect.Height();
					else
						rValue = pSheetView->YPixelToUnit(rect.Height());
				}
			}
			break;
		}
	case methGetTableNames:
		{
			CBLContext* pCont = ppValue[0]->GetContext();//CTableOutputContext
			
//			CSheetDoc* pSheetDoc = (CSheetDoc*)(*((DWORD*)pCont+8));
//			POSITION aPOS = pSheetDoc->GetFirstViewPosition();
//			CSheetView* pSheetView = (CSheetView*)pSheetDoc->GetNextView(aPOS);

			CSheet* pSheet = (CSheet*)(*((DWORD*)pCont+10));
			if(pSheet)
			{
				CBLContext* pVLCont = CBLContext::CreateInstance("ValueTable");
				if(pVLCont)
				{
					int numNC = pVLCont->FindMethod("NewColumn");
					if(numNC >= 0)
					{
						CValue v1;
						CValue v2;
						CValue v3;
						CValue v4;
						CValue v5;
						CValue v6;
						CValue v7;
						CValue v8;
						CValue *pParam[8] = {&v1, &v2, &v3, &v4, &v5, &v6, &v7, &v8};
						for(int i = 0; i < 8; i++)
							pVLCont->GetParamDefValue(numNC, i, pParam[i]);

						CValue retVal;
						v1 = "";
						pVLCont->CallAsFunc(numNC, retVal, pParam);
						v1 = "";
						pVLCont->CallAsFunc(numNC, retVal, pParam);
						v1 = "";
						pVLCont->CallAsFunc(numNC, retVal, pParam);
						v1 = "";
						pVLCont->CallAsFunc(numNC, retVal, pParam);
						v1 = "";
						pVLCont->CallAsFunc(numNC, retVal, pParam);
						v1 = "";
						pVLCont->CallAsFunc(numNC, retVal, pParam);

						rValue.AssignContext(pVLCont);
						int numNL = pVLCont->FindMethod("NewLine");
						int numSV = pVLCont->FindMethod("SetValue");
						if((numNL >= 0) && (numSV >= 0))
						{
							v1 = "";
							v2 = "";
							v3 = "";
							CSheetNames SheetNames;
							SheetNames = pSheet->GetNames();

							CNamedArrayItem** pNamedArray = (CNamedArrayItem**)SheetNames.buf[1];
							int count = (SheetNames.buf[2] - SheetNames.buf[1])/4;
							CString str;
							long countLine = 0;
							for(i = 0; i < count; i++)
								if(pNamedArray[i] != NULL)
								{
									v1 = "";
									pVLCont->CallAsFunc(numNL, retVal, pParam);
									countLine++;
									v1 = countLine;

									v2 = 1;
									CString str;
									str.Format("R%dC%d:R%dC%d",pNamedArray[i]->SheetNamedItem.buf[5]+1,
										pNamedArray[i]->SheetNamedItem.buf[4]+1,
										pNamedArray[i]->SheetNamedItem.buf[7]+1,
										pNamedArray[i]->SheetNamedItem.buf[6]+1);
									v3 = str;
									if(!pVLCont->CallAsFunc(numSV, retVal, pParam))
										pVLCont->CallAsProc(numSV, pParam);

									v2 = 2;
									v3 = pNamedArray[i]->Name;
									if(!pVLCont->CallAsFunc(numSV, retVal, pParam))
										pVLCont->CallAsProc(numSV, pParam);

									v2 = 3;
									v3 = pNamedArray[i]->SheetNamedItem.buf[4]+1;
									if(!pVLCont->CallAsFunc(numSV, retVal, pParam))
										pVLCont->CallAsProc(numSV, pParam);

									v2 = 4;
									v3 = pNamedArray[i]->SheetNamedItem.buf[5]+1;
									if(!pVLCont->CallAsFunc(numSV, retVal, pParam))
										pVLCont->CallAsProc(numSV, pParam);

									v2 = 5;
									v3 = pNamedArray[i]->SheetNamedItem.buf[6]+1;
									if(!pVLCont->CallAsFunc(numSV, retVal, pParam))
										pVLCont->CallAsProc(numSV, pParam);

									v2 = 6;
									v3 = pNamedArray[i]->SheetNamedItem.buf[7]+1;
									if(!pVLCont->CallAsFunc(numSV, retVal, pParam))
										pVLCont->CallAsProc(numSV, pParam);
								}

						}
						
					}
				}
			}
			break;
		}
	default:
		return S_FALSE;
	}
	}catch(...) {
		CBLModule::RaiseExtRuntimeError("Error: exception",0);
		return S_FALSE;
	};
	return S_OK;
}

int  CService::CallAsProc(int iMethNum,class CValue * * ppValue)
{
	try{
	switch (iMethNum)
	{
	case methTest:
		{
			//CDB7Info * pDB7Info; CValueTableContext CBrowse
			pBkEndUI->DoMessageLine(ppValue[0]->GetContext()->GetRuntimeClass()->m_lpszClassName, mmNone);
			pBkEndUI->DoMessageLine(ppValue[0]->GetContext()->GetRuntimeClass()->m_pfnGetBaseClass()->m_lpszClassName, mmNone);
			break;
		}
	case methColorBrowse:
		{
			m_bLocalColor = (ppValue[0]->GetNumeric() == 1);
			m_bEnabledColor = TRUE;
			CBrowse::SetWrap();
			break;
		}
	case methUnColorBrowse:
		{
			m_bLocalColor = FALSE;
			m_bEnabledColor = FALSE;
			CBrowse::OffWrap();
			break;
		}
	case methShowKeyboardIndicator:
		{
			SECStatusBar* pStatus = (SECStatusBar*)AfxGetApp()->m_pMainWnd->GetDescendantWindow(AFX_IDW_STATUS_BAR);
			if(pStatus)
			{
				int count = pStatus->GetCount();
				UINT* nIDs;
				UINT* nStyles;
				int* cxWidths;
				nIDs = (UINT*)malloc(count*sizeof(UINT));
				nStyles = (UINT*)malloc(count*sizeof(UINT));
				cxWidths = (int*)malloc(count*sizeof(int));
				for(int i = 0; i<count; i++)
					pStatus->GetPaneInfo(i,nIDs[i],nStyles[i],cxWidths[i]);
				if((!m_bShowKL) & (ppValue[0]->GetNumeric() == 1))
				{
					m_bShowKL = TRUE;
					pStatus->AllocElements(count+2,100);
					pStatus->SetPaneInfo(count+1,NULL,SBPS_NORMAL, 43);
					pStatus->SetPaneInfo(count,NULL,SBPS_NORMAL, 20);
					char KLName[KL_NAMELENGTH]; 
					if(GetLocaleInfo((LCID)((WORD)GetKeyboardLayout(AfxGetApp()->m_nThreadID)),LOCALE_SABBREVLANGNAME,KLName,KL_NAMELENGTH))
						pStatus->SetPaneText(count,KLName,KL_NAMELENGTH);
					StatusTimer = pStatus->SetTimer(500,100,(TIMERPROC)TimerProc);
				}
				else if(m_bShowKL & (ppValue[0]->GetNumeric() == 0))
				{
					m_bShowKL = FALSE;
					count -= 2;
					pStatus->AllocElements(count,100);
					if(StatusTimer)
					{
						pStatus->KillTimer(StatusTimer);
						StatusTimer = 0;
					}
				}
				for(i = 0; i<count; i++)
					pStatus->SetPaneInfo(i,nIDs[i],nStyles[i],cxWidths[i]);
				free(nIDs);
				free(nStyles);
				free(cxWidths);
			}
			break;
		}
	case methSetWallpaper:
		{
			if(wndMDIClient == NULL) break;

			if(!ppValue[0]->GetString().IsEmpty())
			{
				CGalleryHolder * pGalleryHolder = CGalleryHolder::GetGallery();
				if(pGalleryHolder)
				{
					ULONG picID = pGalleryHolder->FindByAlias(ppValue[0]->GetString());
					if(picID)
					{
						CPictureHolder7 * pic;
						pic = new CPictureHolder7(pGalleryHolder->GetPicture(picID));

						CDC dcMem;
						CDC* pDC = CWnd::GetDesktopWindow()->GetDC();

						if (dcMem.CreateCompatibleDC(pDC))
						{
							CSize hmSize = pic->GetSize();

							CBitmap bmMem;

							if (bmMem.CreateCompatibleBitmap(pDC, hmSize.cx, hmSize.cy))
							{
								CBitmap* pOldBM = dcMem.SelectObject(&bmMem);

								dcMem.FillSolidRect(0, 0, hmSize.cx, hmSize.cy, RGB(0x100,0x100,0x100));
								RECT rect1;
								RECT rect2;
								rect1.top = 0;
								rect1.left = 0;
								rect1.right = hmSize.cx;
								rect1.bottom = hmSize.cy;
								
								pic->Render(dcMem, rect1, 0, &rect2);

								wndMDIClient->m_Bitmap.Attach(bmMem.Detach());

								dcMem.SelectObject(pOldBM);
							}
						}
						CWnd::GetDesktopWindow()->ReleaseDC(pDC);
						delete pic;
					}
					else
					{
						HBITMAP hBitmap = (HBITMAP)LoadImage(NULL, ppValue[0]->GetString(), IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE);
						wndMDIClient->m_Bitmap.Attach(hBitmap);
					}
					wndMDIClient->CreateGrayBitmap();
				}

			}
			wndMDIClient->m_nType = ppValue[1]->GetNumeric();
			wndMDIClient->m_bGray = (ppValue[2]->GetNumeric() == 1);
			wndMDIClient->RedrawWindow();

			break;
		}
	case methHideTable:
		{
			CBLContext* pCont = ppValue[0]->GetContext();//CTableOutputContext

			CSheetDoc* pSheetDoc = (CSheetDoc*)(*((DWORD*)pCont+8));
			POSITION aPOS = pSheetDoc->GetFirstViewPosition();
			CSheetView* pSheetView = (CSheetView*)pSheetDoc->GetNextView(aPOS);
			if(pSheetView)
			{
				if(ppValue[1]->GetNumeric() == 1)
					pSheetView->GetParent()->GetParent()->ShowWindow(SW_HIDE);
				else if(ppValue[1]->GetNumeric() == 0)
					pSheetView->GetParent()->GetParent()->ShowWindow(SW_SHOW);
			}
			break;
		}
	default:
		return S_FALSE;
	}
	}catch(...) {
		CBLModule::RaiseExtRuntimeError("Error: exception",0);
		return S_FALSE;
	};
	return S_OK;
}


int  CService::FindMethod(char const * lpMethodName)const
{
	int i;
	for (i = 0;i<lastMethod;i++){
		if (!stricmp(lpMethodName,defFnNames[i].Names[0]))
			return i;
		if (!stricmp(lpMethodName,defFnNames[i].Names[1]))
			return i;
	}
	return -1;
}

char const * CService::GetMethodName(int iMethodNum,int iMethodAlias)const
{
	if (iMethodNum >= lastMethod) 
		return "mError";
	else
		return defFnNames[iMethodNum].Names[iMethodAlias];
}

int  CService::GetNMethods(void)const
{
	return lastMethod;
}

int  CService::HasRetVal(int iMethodNum)const
{
	return defFnNames[iMethodNum].HasReturnValue ;
}

int CService::GetNParams(int iMethodNum)const
{
	return defFnNames[iMethodNum].NumberOfParams;
}

int  CService::GetParamDefValue(int iMethodNum,int iParamNum,class CValue * pDefValue)const
{
	switch (iMethodNum)
	{
	case methChooseValue:
		{
			switch (iParamNum)
			{
			case 4:
				*pDefValue = 0L;
				break;
			case 5:
			case 6:
				*pDefValue = -1L;
			break;
			default:
				return 0;
		}
			break;
		}
	case methColorBrowse:
		{
			*pDefValue = 0L;
			break;
		}
  case methLoadModule:
		{
			*pDefValue = 0L;
			break;
		}
  
	case methSetWallpaper:
		{
			if(iParamNum == 2)
			{
				*pDefValue = 0L;
				break;
			}
		}
	case methCallAsProcedure:
	case methCallAsFunction:
		{
			if(iParamNum == 2)
			{
				*pDefValue = 0L;
				break;
			}
		}
	default:
		return 0;
	}
	return 1;
}

void  CService::DecrRef(void)
{
	CBLContext::DecrRef();
}

char const *  CService::GetCode(void)const
{
	return 0;
}

int  CService::GetDestroyUnRefd(void)const
{
	return 1;
}

void  CService::GetExactValue(class CValue & vParam)
{
	CBLContext::GetExactValue(vParam);
}

class CObjID  CService::GetID(void)const
{
	return ObjID;
}

class CBLContextInternalData *  CService::GetInternalData(void)
{

	return CBLContext::GetInternalData();

}

long  CService::GetTypeID(void)const
{
	return 100;
}

char const *  CService::GetTypeString(void)const
{
	return "";
}

class CType CService::GetValueType(void)const
{
	CType tType(100);
	
	return tType;
}

void  CService::IncrRef(void)
{
	CBLContext::IncrRef();
}

void  CService::InitObject(class CType const & tType)
{
	CBLContext::InitObject(tType);
}

void  CService::InitObject(char const * strName)
{
	CBLContext::InitObject(strName);
}

int  CService::IsExactValue(void)const
{
	return FALSE;
}

int  CService::IsOleContext(void)const
{
	return FALSE;
}

int  CService::IsPropReadable(int iPropNum)const
{
	return FALSE;
}

int  CService::IsPropWritable(int iPropNum)const
{
	return FALSE;
}

int  CService::IsSerializable(void)
{
	return FALSE;
}

int  CService::SaveToString(class CString & csStr)
{
	csStr = "ServiceFormEx";
	return TRUE;
}

void  CService::SelectByID(class CObjID cID,long lNum)
{
	CBLContext::SelectByID(cID,lNum);
}

int  CService::GetNProps(void)const
{
	return 0;
}

char const * CService::GetPropName(int A,int B)const
{
	return NULL;
}

int  CService::GetPropVal(int iPropNum,class CValue & rValue)const
{
	return -1;
}

int  CService::SetPropVal(int iPropNum,class CValue const & vValue)
{
	return -1;
}

int  CService::FindProp(char const * Name)const
{
	return -1;
}

