// allboost.cpp
#include "stdafx.h"
#include "allboost.h"
#include "docrefboost.h"
#include "gcboost.h"

CMetaDataCont *pMD=NULL;

static struct{
	const char *strName;
	bool BoostProp;
	int MaxNumProps;
}defEmbedded[]={
	{"CGeneralContext",true,99},
	{"CAllConstsContext",true,-1},

	{"CAccountContext",true,99},
	{"CAllSbKindsContext",true,1},
	{"CSbKindContext",false,-1},
	{"CAllPlanKindsContext",true,1},
	{"CPlanKindContext",false,-1},

	{"CCalcContext",true,99},
	{"CAllAlgorithmContext",true,1},
	{"CAlgorithmContext",true,-1},
	{"CAllGroupContext",true,1},
	{"CGrContext",true,-1},
	{"CAllRecalcRulesContext",true,1},
	{"CRecalcRuleContext",true,-1},
	{"CAllCalendarsContext",true,1},
	{"CLayerContext",true,-1},
	{NULL,false,false}
	};


static void BoostObject(const char* name,bool boostProp=false)
{
	try{
		CBLContext* pCont=CBLContext::CreateInstance(name);
		if(pCont)
		{
			new CAllBoost(pCont,boostProp);
			delete pCont;
		}
	}catch(...){}
}

static void BoostContAndProps(CBLContext* pCont)
{
	if(!pCont)
		return;
	CString rtc=pCont->GetRuntimeClass()->m_lpszClassName;
	for(int i=0;defEmbedded[i].strName;i++)
	{
		if(rtc==defEmbedded[i].strName)
			break;
	}
	if(!defEmbedded[i].strName)
		return;
	new CAllBoost(pCont,defEmbedded[i].BoostProp);
	if(defEmbedded[i].MaxNumProps<0)
		return;
	int nProps=pCont->GetNProps();
	if(nProps>defEmbedded[i].MaxNumProps)
		nProps=defEmbedded[i].MaxNumProps;
	CValue val;
	CBLContext *pProp;
	for(i=0;i<nProps;i++)
	{
		try{
		pCont->GetPropVal(i,val);
		pProp=val.GetContext();
		}catch(...){return;}
		if(!pProp)
		{
			val.LinkContext(TRUE);
			pProp=val.GetContext();
		}
		if(pProp)
		{
			CString name=pCont->GetPropName(i,0);
			BoostContAndProps(pProp);
		}
	}
}

static void InitGeneralContext(CBLContext *pCont)
{
	BoostContAndProps(pCont);
	CValue val;
	int num=pCont->FindProp("");
	if(num!=-1)
	{
		try{
			pCont->GetPropVal(num,val);
		}catch(...){}
		CBLContext* pBoost=val.GetContext();
		if(pBoost)
			CEnumBoost::Init(pBoost);
	}
}

static void InitTradeContext(CBLContext *pCont)
{
	new CAllBoost(pCont,true);
	CRegBoost::Init();
}

static void InitAccContext(CBLContext *pCont)
{
	BoostContAndProps(pCont);
	BoostObject("",true);
	BoostObject("",true);
	BoostObject("");
}

static void InitCalcContext(CBLContext *pCont)
{
	BoostContAndProps(pCont);
	BoostObject("",true);
	CCalcBoost::Init();
}

void InitAllBoost()
{
	if(pMD)
		return;
	pMD=GetMetaData();
	CGCBoost::Init();
	CDocBoost::Init();				// 
	CRefBoost::Init();				// 
	CVTBoost::Init();
	CQueryBoost::Init();
	BoostObject("");	// 
	BoostObject("");			// 
	BoostObject("");		// 
	BoostObject("XBase");			// XBase
	BoostObject("");				// 
	BoostObject("");			// 
	//   
	CString name;
	for(DWORD id=CBLContext::GetFirstLoadedContextID();id;id=CBLContext::GetNextLoadedContextID(id))
	{
		CBLContext* pCont=CBLContext::GetLoadedContext(id);
		name=pCont->GetRuntimeClass()->m_lpszClassName;
		if(name=="CGeneralContext")
			InitGeneralContext(pCont);
		else if(name=="CTradeContext")
			InitTradeContext(pCont);
		else if(name=="CAccountContext")
			InitAccContext(pCont);
		else if(name=="CCalcContext")
			InitCalcContext(pCont);
	}
}