// blmap.h
#ifndef BLMAP_H
#define BLMAP_H

class CBLMap{
	struct Assoc{	//       -
		Assoc():pos(-1),next(NULL),strKey(NULL){}
		Assoc(DWORD h,char* buf,int p):hash(h),strKey(buf),pos(p),next(NULL){}
		DWORD hash;
		char *strKey;
		int pos;
		Assoc *next;
	};
	Assoc** m_ppHashTable;	// -.       
	int m_HashSize;			//  
	int m_Count;			//    
	
	//         
	DWORD GetHash(const char* key,DWORD& hash,char *buf) const
	{
		hash=0;
		while(*key)
			//hash=(hash<<5)+hash+(*buf++=m_LowerTable[(BYTE)*key++]);
			hash=(hash<<1)^(*buf++=m_LowerTable[(BYTE)*key++]);
		*buf=0;
		return hash%m_HashSize;
	}
public:
	void ShowInfo()
	{
		int empty=0,coll=0;
		for(int i=0;i<m_HashSize;i++)
		{
			Assoc* pAssoc=m_ppHashTable[i];
			if(pAssoc)
			{
				while(pAssoc->next)
				{
					coll++;
					pAssoc=pAssoc->next;
				}
			}
			else
				empty++;
		}
		ShowMsg("Size=%i, Count=%i, Empty=%i, Collision=%i",mmNone,m_HashSize,m_Count,empty,coll);
	}
	CBLMap():m_HashSize(0),m_ppHashTable(NULL),m_Count(0){SetHashSize(7);}
	~CBLMap(){RemoveAll();}
	void InsertKey(const char* key,int pos);	//  -  -
	int  GetKey(const char* key)const;				//    
	int	 GetHashSize(){return m_HashSize;}
	int  GetCount(){return m_Count;}

	//   -.    ,  
	void SetHashSize(int size);
	void RemoveAll();
	void Optimize();
	void MakePropMapFromContext(CBLContext* pCont)
	{
		RemoveAll();
		int nProps=pCont->GetNProps();
		SetHashSize(nProps);
		for(int i=0;i<nProps;i++)
		{
			InsertKey(pCont->GetPropName(i,0),i);
			InsertKey(pCont->GetPropName(i,1),i);
		}
		Optimize();
	}
	void MakeMethMapFromContext(CBLContext* pCont)
	{
		RemoveAll();
		int nMeth=pCont->GetNMethods();
		SetHashSize(nMeth);
		for(int i=0;i<nMeth;i++)
		{
			InsertKey(pCont->GetMethodName(i,0),i);
			InsertKey(pCont->GetMethodName(i,1),i);
		}
		Optimize();
	}
	static char m_LowerTable[257]; //        
};

#endif