// attachedcontext.cpp
#include "stdafx.h"
#include "gcboost.h"

DWORD* CGCBoost::m_pMyVTable=NULL;
DWORD* CGCBoost::m_pRealVTable=NULL;
CMapStringToPtr CGCBoost::SGCData::m_DataMap;

BYTE* CGCBoost::adrWrapCompile=NULL;
CGCBoost::PF_Comp CGCBoost::jmpWrapCompile=NULL;
BYTE CGCBoost::origWrapCompile[6];
BYTE CGCBoost::wrapWrapCompile[6];
bool CGCBoost::optimize=true;

CGCBoost::~CGCBoost(void)
{

}

int	CGCBoost::FindProp(char const *name)const
{
	return GetData()->FindProp(name);
}

int	CGCBoost::GetPropVal(int iPropNum,class CValue &PropVal)const
{
	return GetData()->GetPropVal(this,iPropNum,PropVal);
}
int	CGCBoost::SetPropVal(int iPropNum,CValue const &PropVal)
{
	return GetData()->SetPropVal(this,iPropNum,PropVal);
}
int	CGCBoost::IsPropReadable(int iPropNum)const
{
	return GetData()->IsPropReadable(this,iPropNum);
}
int	CGCBoost::IsPropWritable(int iPropNum)const
{
	return GetData()->IsPropWritable(this,iPropNum);
}
int	CGCBoost::FindMethod(char const *strMethodName)const
{
	return GetData()->FindMethod(strMethodName);
}
int	CGCBoost::GetNParams(int iMethNum)const
{
	return GetData()->GetNParams(iMethNum);
}
int	CGCBoost::GetParamDefValue(int iMethNum,int iParamNum,class CValue *pDefVal)const
{
	return GetData()->GetParamDefValue(this,iMethNum,iParamNum,pDefVal);
}
int	CGCBoost::HasRetVal(int iMethNum)const
{
	return GetData()->HasRetVal(iMethNum);
}
int	CGCBoost::CallAsProc(int iMethNum,class CValue **ppParam)
{  
	return GetData()->CallAsProc(this,iMethNum,ppParam);
}
int	CGCBoost::CallAsFunc(int iMethNum,class CValue& retVal,class CValue **ppParam)
{ 
	return GetData()->CallAsFunc(this,iMethNum,retVal,ppParam);
}

bool CGCBoost::Boost(CBLModule7 *pMod,bool optimize)
{
	CBLContext* pCont=CBLModuleWrapper::GetContextFromModule(pMod);
	if(!pCont)
		return false;
	if(CString("CGroupContext")!=pCont->GetRuntimeClass()->m_lpszClassName)
		return false;
	if(*(DWORD**)pCont==m_pMyVTable)
		return true;
	SGCData* pData=SGCData::GetData(pMod,pCont,optimize);
	SGCInfo* pInfo=new SGCInfo(pMod,pData);
	pCont->m_FlagAutoDestroy=(int)pInfo;
	if(!m_pMyVTable)
	{
		m_pRealVTable=*(DWORD**)pCont;
		CGCBoost* pBoost=new CGCBoost;
		DWORD* pMyVTable=*(DWORD**)pBoost;
		delete pBoost;
		m_pMyVTable=new DWORD[64];
		memcpy(m_pMyVTable,m_pRealVTable,256);
		m_pMyVTable[19]=pMyVTable[19];	// FindProp
		m_pMyVTable[21]=pMyVTable[21];	// GetPropVal
		m_pMyVTable[22]=pMyVTable[22];	// SetPropVal
		m_pMyVTable[23]=pMyVTable[23];	// IsPropReadable
		m_pMyVTable[24]=pMyVTable[24];	// IsPropWritable
		m_pMyVTable[26]=pMyVTable[26];	// FindMethod
		m_pMyVTable[28]=pMyVTable[28];	// GetNParams
		m_pMyVTable[29]=pMyVTable[29];	// GetParamDefValue
		m_pMyVTable[30]=pMyVTable[30];	// HasRetVal
		m_pMyVTable[31]=pMyVTable[31];	// CallAsProc
		m_pMyVTable[32]=pMyVTable[32];	// CallAsProc
	}
	*(DWORD**)pCont=m_pMyVTable;
	return true;
}

int CGCBoost::AssignAndCompile(CBLModule7* pMod)
{
	int ret = 0;
  CBLModule &pPreCompileModule = ((CTxtModuleReader*)this)->pPreCompileModule;
  CString txt = ((CTxtModuleReader*)this)->module;
  optimize=true;

  if ((pPreCompileModule.IsCompiled() == 1) && txt[0]!='#')
  {
    pMod->AssignCompiled(pPreCompileModule);
    ret = 1;
  }
  else
  {       
    if(txt[0]=='#')
			optimize=false;

    OnLoadSource(&txt);          
    pMod->AssignSource(txt);        
    ret = pMod->Compile();

    if (ret == 1)
      pPreCompileModule.AssignCompiled(*pMod);      
  }  
  if (ret == 1)
    Boost(reinterpret_cast<CBLModule7*>(pMod), optimize);

  return ret;
}

int CGCBoost::WrapCompile()
{
  int ret = 0;
  BYTE* adr1 = adrWrapCompile;
  for(int i = 0; i<6;i++) *adr1++ = origWrapCompile[i];
  
  if (7 == ((CBLModule*)this)->GetKind())
  {
  
    CString* txt = (CString*)((DWORD*)(*((DWORD*)this+1))+5); //   
    CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();
  
    bool bIsNoClass = false;
    if (!pHierarchy->StillInitInstanceComp())
    {
      bIsNoClass = true;
      #ifdef _DEBUG
        CString FullFileName = "";            
      #else
        CString FullFileName = ((CBLModule7*)this)->GetFullName(); 
      #endif
      try 
      {
        //      include             
        CMapStringToString mapLoadedIncludeFiles;      
            
        CPreprocessor preproc(*txt, pHierarchy->m_SymbolOfPreprocessor, mapLoadedIncludeFiles, FullFileName);
        preproc.Start();
      }
      catch (CPreprocessor::ExeptionPreprocessor &ex)
      {
        CString strErr;
        strErr.Format(" : %s", FullFileName);
        pBkEndUI->DoMessageLine(strErr, mmBlackErr);	
        strErr = ex.GetErrorString();        
        pBkEndUI->DoMessageLine(strErr, mmBlackErr);	
        strErr.Empty();
        if (!ex.GetCodeString().IsEmpty())
        {
          strErr.Format("(%d) %s",ex.GetNumString(),ex.GetCodeString());
          pBkEndUI->DoMessageLine(strErr, mmBlackErr);
        }
    
      }    
      //pBkEndUI->DoMessageLine(*txt, mmInformation);
    }  
    //    
    //CString* txt = (CString*)((DWORD*)(*((DWORD*)this+1))+5); //   
    //   
  
    ret= ((CBLModule*)this)->Compile();    
  }
  else
  {
    ret= ((CBLModule*)this)->Compile();        
  }
  adr1 = adrWrapCompile;
  for(i = 0; i<6;i++) *adr1++ = wrapWrapCompile[i];

  return ret;
}

BYTE TrapCode[6];
CGCBoost::PF_V_V jmpDestr;
CGCBoost::PF_V_V realDestr;
static inline void SwapCode()
{
	BYTE *read,*write=TrapCode,symb;
	read=*(BYTE**)&realDestr;
	for(int i=0;i<6;i++)
		symb=*read,*read++=*write,*write++=symb;
}

void CGCBoost::GroupDestruct()
{
	SGCInfo* pInfo=NULL;
	if(*(DWORD**)this==m_pMyVTable)
		pInfo=GetInfo();
	SwapCode();
	(this->*realDestr)();
	SwapCode();
	if(pInfo)
		delete pInfo;
}
typedef int(CGCBoost::*PF_ASS)(CBLModule7*);

PF_ASS jmpAss;

void CGCBoost::Init()
{
  DWORD old;
	HINSTANCE h7=GetModuleHandle("seven.dll");
	BYTE* adr=(BYTE*)GetProcAddress(h7,"?AssignAndCompile@CTxtModuleReader@@QAEHPAVCBLModule@@@Z");
	
	VirtualProtect(adr,6,PAGE_EXECUTE_READWRITE,&old);
	jmpAss=AssignAndCompile;
	*adr++=0xFF;
	*adr++=0x25;
	*(DWORD*)adr=(DWORD)&jmpAss;

	h7=GetModuleHandle("bkend.dll");
	adr=(BYTE*)GetProcAddress(h7,"??1CGroupContext@@UAE@XZ");
	realDestr=*(PF_V_V*)&adr;
	for(int i=0;i<6;i++)
		TrapCode[i]=adr[i];
	VirtualProtect(adr,6,PAGE_EXECUTE_READWRITE,&old);
	jmpDestr=GroupDestruct;
	*adr++=0xFF;
	*adr++=0x25;
	*(DWORD*)adr=(DWORD)&jmpDestr;


  HINSTANCE hBl=GetModuleHandle("blang.dll");
  BYTE* adr1;

  adr1=(BYTE*)GetProcAddress(hBl,"?Compile@CBLModule@@QAEHXZ");
  VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

  jmpWrapCompile=(PF_Comp)WrapCompile;
  adrWrapCompile = adr1;
  for(i = 0; i<6;i++) origWrapCompile[i] = *adr1++;
  adr1 = adrWrapCompile;
  *adr1++=0xFF;
  *adr1++=0x25;
  *(DWORD*)adr1=(DWORD)&jmpWrapCompile;
  adr1 = adrWrapCompile;
  for(i = 0; i<6;i++) wrapWrapCompile[i] = *adr1++;

}
