// gcboost.h
#ifndef GCBOOST_H
#define GCBOOST_H
#include "blmap.h"

class CGCBoost:public CBLContext
{
public:
	typedef void	(CGCBoost::*PF_V_V)();						// IncrRef,DecrRef
	typedef int		(CGCBoost::*PF_I_V)();						// GetDestroyUnRefd,IsOleContext,IsExactValue,GetNProps,GetNMethods,IsSerializable
	typedef CType	(CGCBoost::*PF_T_V)();						// GetValueType
	typedef void	(CGCBoost::*PF_L_V)();						// GetTypeID
	typedef CObjID	(CGCBoost::*PF_O_V)();						// GetID
	typedef void	(CGCBoost::*PF_V_T)(CType const&);			// InitObject
	typedef void	(CGCBoost::*PF_V_C)(char const *);			// InitObject
	typedef void	(CGCBoost::*PF_V_OL)(CObjID,long);			// SelectByID
	typedef int		(CGCBoost::*PF_I_C)(char const *);			// FindProp,FindMethod
	typedef int		(CGCBoost::*PF_I_IV)(int,CValue&);			// GetPropVal,SetPropVal
	typedef int		(CGCBoost::*PF_I_I) (int);					// IsPropReadable,IsPropWritable,GetNParams,HasRetVal
	typedef int		(CGCBoost::*PF_I_IIV)(int,int,CValue *);	// GetParamDefValue
	typedef int		(CGCBoost::*PF_CAP)(int,CValue **);			// CallAsProc
	typedef int		(CGCBoost::*PF_CAF)(int,CValue&,CValue**);	// CallAsFunc
	typedef int		(CGCBoost::*PF_I_S)(CString&);				// SaveToString
	typedef void	(CGCBoost::*PF_V_VAL)(CValue&);				// GetExactValue
	typedef char const*(CGCBoost::*PF_C_V)(void);				// GetTypeString,GetCode
	typedef char const*(CGCBoost::*PF_C_II)(int,int);			// GetPropName,GetMethodName
	typedef CBLContextInternalData*(CGCBoost::*PF_IN_V)();		// GetInternalData
  typedef int(CBLModule::*PF_Comp)(void);

	struct SMethInfo{
		int HasRetVal;
		int NumberOfParam;
	};
	struct SGCData{
		SGCData(CBLModule7* pMod,CBLContext* pCont,bool optimize)
		{
			m_nMethInCtx=pCont->GetNMethods();
			int nMethInMod=pMod->GetNProcs();
			m_MethInfo=NULL;
			if(m_nMethInCtx+nMethInMod)
				m_MethInfo=new SMethInfo[m_nMethInCtx+nMethInMod];
			for(int i=0;i<m_nMethInCtx;i++)
			{
				m_MethMap.InsertKey(pCont->GetMethodName(i,0),i);
				m_MethMap.InsertKey(pCont->GetMethodName(i,1),i);
				m_MethInfo[i].NumberOfParam=pCont->GetNParams(i);
				m_MethInfo[i].HasRetVal=pCont->HasRetVal(i);
			}
			for(int j=0;j<nMethInMod;j++,i++)
			{
				CBLProcInfo info;
				pMod->GetProcInfo(j,info);
				m_MethMap.InsertKey(info.GetName(),i);
				m_MethInfo[i].NumberOfParam=info.GetNParams();
				m_MethInfo[i].HasRetVal=info.HasRetVal();
			}
			m_MethMap.Optimize();
			//   
			m_nPropInCtx=pCont->GetNProps();
			for(i=0;i<m_nPropInCtx;i++)
			{
				m_PropMap.InsertKey(pCont->GetPropName(i,0),i);
				m_PropMap.InsertKey(pCont->GetPropName(i,1),i);
			}
			int nPropInMod=pMod->GetNStaticVars();
			for(j=0;j<nPropInMod;j++,i++)
			{
				CBLVarInfo info;
				pMod->GetStaticVarDescr(j,info);
				m_PropMap.InsertKey(info.GetName(),i);
			}
			m_PropMap.Optimize();
			m_Destroy=!optimize;
			if(optimize)
				m_DataMap[pMod->GetFullName()]=this;
		}
		~SGCData()
		{
			if(m_MethInfo)
				delete m_MethInfo;
		}
		void Remove()
		{
			if(m_Destroy)
				delete this;
		}
		static SGCData* GetData(CBLModule7* pMod,CBLContext* pCont,bool optimize)
		{
			SGCData* pRet=NULL;
			if(optimize)
				pRet=(SGCData*)m_DataMap[pMod->GetFullName()];
			if(!pRet)
				pRet=new SGCData(pMod,pCont,optimize);
			return pRet;
		}

		int	FindProp(char const*name)const
		{
			return m_PropMap.GetKey(name);
		}
		int GetPropVal(const CGCBoost* pCont,int iPropNum,class CValue &val)
		{
			if(iPropNum>=m_nPropInCtx)
				return pCont->GetModule()->GetStaticVarValue(iPropNum-m_nPropInCtx,val,0);
			else
				return (pCont->*(*(PF_I_IV*)&m_pRealVTable[21]))(iPropNum,val);
		}
		int SetPropVal(CGCBoost* pCont,int iPropNum,class CValue const &val)
		{
			if(iPropNum>=m_nPropInCtx)
				return pCont->GetModule()->SetStaticVarValue(iPropNum-m_nPropInCtx,val,0);
			else
				return (pCont->*(*(PF_I_IV*)&m_pRealVTable[22]))(iPropNum,(CValue&)val);
		}
		int IsPropReadable(const CGCBoost* pCont,int iPropNum)
		{
			if(iPropNum>=m_nPropInCtx)
				return 1;
			else
				return (pCont->*(*(PF_I_I*)&m_pRealVTable[23]))(iPropNum);
		}
		int IsPropWritable(const CGCBoost* pCont,int iPropNum)
		{
			if(iPropNum >= m_nPropInCtx)
				return 1;
			else
				return (pCont->*(*(PF_I_I*)&m_pRealVTable[24]))(iPropNum);
		}
		int FindMethod(char const *name)
		{
			return m_MethMap.GetKey(name);
		}
		int GetNParams(int iMethNum)
		{
			return m_MethInfo[iMethNum].NumberOfParam;
		}
		int GetParamDefValue(const CGCBoost* pCont,int iMethNum,int iParamNum,class CValue *pVal)
		{
			if(iMethNum >= m_nMethInCtx)
				return 1;
			return (pCont->*(*(PF_I_IIV*)&m_pRealVTable[29]))(iMethNum,iParamNum,pVal);
		}
		int HasRetVal(int iMethNum)
		{
			return m_MethInfo[iMethNum].HasRetVal;
		}
		int CallAsProc(CGCBoost* pCont,int iMethNum,CValue **ppParam)
		{
			if(iMethNum >= m_nMethInCtx)
				return pCont->GetModule()->CallAsProc(iMethNum-m_nMethInCtx,m_MethInfo[iMethNum].NumberOfParam,ppParam);
			return (pCont->*(*(PF_CAP*)&m_pRealVTable[31]))(iMethNum,ppParam);
		}
		int CallAsFunc(CGCBoost* pCont,int iMethNum,CValue& retVal,CValue **ppParam)
		{
			if(iMethNum >= m_nMethInCtx)
			{
				CValue locVal;
				int ret=pCont->GetModule()->CallAsFunc(iMethNum-m_nMethInCtx,locVal,m_MethInfo[iMethNum].NumberOfParam,ppParam);
				retVal=locVal;
				return ret;
			}
			return (pCont->*(*(PF_CAF*)&m_pRealVTable[32]))(iMethNum,retVal,ppParam);
		}

		bool	m_Destroy;
		CBLMap	m_MethMap;
		int		m_nMethInCtx;
		CBLMap	m_PropMap;
		int		m_nPropInCtx;
		SMethInfo* m_MethInfo;
		static CMapStringToPtr m_DataMap;
	};
	struct SGCInfo{
		SGCInfo(CBLModule* pMod,SGCData* pData):m_pMod(pMod),m_pData(pData), m_nTableSkipper(2)
    {      
    };
		~SGCInfo()
    {
      if (m_pData)
        m_pData->Remove();      
    }
    int m_nTableSkipper;
		CBLModule* m_pMod;				// -      
		SGCData* m_pData;
  } *PSGCInfo; 
	// virtual functions
	// CObject::GetRuntimeClass												//0
	virtual  ~CGCBoost(void);												//1
	// CObject::Serialize													//2
	// CObject::AssertValid													//3
	// CObject::Dump														//4
	//virtual void			IncrRef(void);									//5
	//virtual void			DecrRef(void);									//6
	//virtual int			GetDestroyUnRefd(void)const;					//7
	//virtual int			IsOleContext(void)const;						//8
	//virtual class CType	GetValueType(void)const;						//9
	//virtual long			GetTypeID(void)const;							//10
	//virtual class CObjID	GetID(void)const;								//11
	//virtual char const *	GetCode(void)const;								//12
	//virtual int			IsExactValue(void)const;						//13
	//virtual void			InitObject(class CType const &);				//14
	//virtual void			InitObject(char const *);						//15
	//virtual void			SelectByID(class CObjID,long);					//16
	//virtual char const *	GetTypeString(void)const;						//17

	//virtual int			GetNProps(void)const;							//18
	virtual int				FindProp(char const *)const;					//19
	//virtual char const *	GetPropName(int,int)const;						//20
	virtual int				GetPropVal(int,class CValue &)const;			//21
	virtual int				SetPropVal(int,class CValue const &);			//22
	virtual int				IsPropReadable(int)const;						//23
	virtual int				IsPropWritable(int)const;						//24
	//virtual int			GetNMethods(void)const;							//25
	virtual int				FindMethod(char const *)const;					//26
	//virtual char const *	GetMethodName(int,int)const;					//27
	virtual int				GetNParams(int)const;							//28
	virtual int				GetParamDefValue(int,int,class CValue *)const;	//29
	virtual int				HasRetVal(int)const;							//30
	virtual int				CallAsProc(int,class CValue * *); 				//31
	virtual int				CallAsFunc(int,class CValue &,class CValue * *);//32

	//virtual int			IsSerializable(void);							//33
	//virtual int			SaveToString(class CString &);					//34
	//virtual class			CBLContextInternalData *  GetInternalData(void);//35
	//virtual void			GetExactValue(class CValue &);					//36
	static void Init();
	static bool Boost(CBLModule7 *pMod,bool optimize);
	int AssignAndCompile(CBLModule7*);
  int WrapCompile();
	void GroupDestruct();
	SGCInfo* GetInfo()const		{return (SGCInfo*)m_FlagAutoDestroy;}
	CBLModule* GetModule()const	{return GetInfo()->m_pMod;}
	SGCData* GetData()const		{return GetInfo()->m_pData;}
	static DWORD* m_pMyVTable;
	static DWORD* m_pRealVTable;

  static BYTE*   adrWrapCompile;
  static PF_Comp jmpWrapCompile;
  static BYTE    origWrapCompile[6];
  static BYTE    wrapWrapCompile[6];
  static bool optimize;

};

#endif