// mycontextbase.cpp
#include "stdafx.h"
#include "mycontextbase.h"
CMyContextBase::_ImplRuntimeClass CMyContextBase::m_ImplRuntimeClass;

CMyContextBaseInfo::CMyContextBaseInfo(_S_MethDef* pmd,_S_PropDef* ppd,
	const char* ts,const char** RegNames,CRuntimeClass* pRTC,void (*pInitFunc)())
		:pMethodDef(pmd),pPropDef(ppd),TypeString(ts)
{
	methCount=0;
	while(pmd->Names[0])
	{
		MethMap.InsertKey(pmd->Names[0],methCount);
		MethMap.InsertKey(pmd->Names[1],methCount++);
		pmd++;
	}
	MethMap.Optimize();
	propCount=0;
	while(ppd->Names[0])
	{
		PropMap.InsertKey(ppd->Names[0],propCount);
		PropMap.InsertKey(ppd->Names[1],propCount++);
		ppd++;
	}
	PropMap.Optimize();
	while(*RegNames)
		CBLContext::RegisterContextClass(pRTC,*RegNames++,CType(100));
	if(pInitFunc)
		(*pInitFunc)();
}

CMyContextBase::CMyContextBase()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState());	
}

CMyContextBase::~CMyContextBase()
{
}

int CMyContextBase::CallAsFunc(int iMethNum,CValue& rValue,CValue **ppValue)
{
	return (this->*(PF_CTX_CALL_AS_FUNC)GetBaseInfo()->pMethodDef[iMethNum].pDoProc)(iMethNum,rValue,ppValue);
}

int CMyContextBase::CallAsProc(int iMethNum,CValue **ppValue)
{
	return (this->*(PF_CTX_CALL_AS_PROC)GetBaseInfo()->pMethodDef[iMethNum].pDoProc)(iMethNum,ppValue);
}


int CMyContextBase::FindMethod(char const * lpMethodName)const
{
	return GetBaseInfo()->MethMap.GetKey(lpMethodName);
}

char const* CMyContextBase::GetMethodName(int iMethodNum,int iMethodAlias)const
{
	return GetBaseInfo()->pMethodDef[iMethodNum].Names[iMethodAlias];
}

int CMyContextBase::GetNMethods(void)const
{
	return GetBaseInfo()->methCount;
}

int CMyContextBase::HasRetVal(int iMethodNum)const
{
	return GetBaseInfo()->pMethodDef[iMethodNum].HasRetVal;
}

int CMyContextBase::GetNParams(int iMethodNum)const
{
	return GetBaseInfo()->pMethodDef[iMethodNum].NumberOfParam;
}

int CMyContextBase::GetParamDefValue(int iMethodNum,int iParamNum,CValue *pDefValue)const
{
	PF_CTX_GET_PARAM_DEF pFunc=(PF_CTX_GET_PARAM_DEF)GetBaseInfo()->pMethodDef[iMethodNum].pDefValProc;
	if(pFunc)
		return (this->*pFunc)(iMethodNum,iParamNum,pDefValue);
	return 1;
}

char const* CMyContextBase::GetCode(void)const
{
	return 0;
}

int CMyContextBase::GetDestroyUnRefd(void)const
{
	return 1;
}

CObjID CMyContextBase::GetID(void)const
{
	return GetBaseInfo()->objID;
}

long  CMyContextBase::GetTypeID(void)const
{
	return 100;
}

char const*  CMyContextBase::GetTypeString(void)const
{
	return GetBaseInfo()->TypeString;
}

CType CMyContextBase::GetValueType(void)const
{
	CType tType(100);	
	return tType;
}

int CMyContextBase::IsExactValue(void)const
{
	return 1;
}

int CMyContextBase::IsOleContext(void)const
{
	return 0;
}

int CMyContextBase::IsPropReadable(int iPropNum)const
{
	return GetBaseInfo()->pPropDef[iPropNum].IsReadable;
}

int CMyContextBase::IsPropWritable(int iPropNum)const
{
	return GetBaseInfo()->pPropDef[iPropNum].IsWritabe;
}

int CMyContextBase::IsSerializable(void)
{
	return 0;
}

int CMyContextBase::SaveToString(CString &csStr)
{	
	return 0;
}

int CMyContextBase::GetNProps(void)const
{
	return GetBaseInfo()->propCount;
}

char const* CMyContextBase::GetPropName(int A,int B)const
{	
	return GetBaseInfo()->pPropDef[A].Names[B];
}

int CMyContextBase::GetPropVal(int iPropNum,CValue &rValue)const
{
	return (this->*(PF_CTX_GET_PROP)GetBaseInfo()->pPropDef[iPropNum].pGetProp)(iPropNum,rValue);
}

int CMyContextBase::SetPropVal(int iPropNum,CValue const &vValue)
{
	return (this->*(PF_CTX_SET_PROP)GetBaseInfo()->pPropDef[iPropNum].pSetProp)(iPropNum,vValue);
}

int  CMyContextBase::FindProp(char const * Name)const
{
	return GetBaseInfo()->PropMap.GetKey(Name);
}
