// mycontextbase.h
#ifndef MYCONTEXTBASE_H
#define MYCONTEXTBASE_H
#include "blmap.h"

typedef int (CBLContext::*PF_CTX)();
typedef int (CBLContext::*PF_CTX_CALL_AS_PROC)(int,CValue**);
typedef int (CBLContext::*PF_CTX_CALL_AS_FUNC)(int,CValue&,CValue**);
typedef int (CBLContext::*PF_CTX_GET_PARAM_DEF)(int,int,CValue*)const;
typedef int (CBLContext::*PF_CTX_GET_PROP)(int,CValue&)const;
typedef int (CBLContext::*PF_CTX_SET_PROP)(int,CValue const&);

struct _S_MethDef{
	const char *Names[2];
	bool HasRetVal;
	int NumberOfParam;
	PF_CTX pDoProc;
	PF_CTX pDefValProc;
};

struct _S_PropDef{
	const char *Names[2];
	bool IsReadable;
	bool IsWritabe;
	PF_CTX pGetProp;
	PF_CTX pSetProp;
};

class CMyContextBaseInfo{
public:
	CMyContextBaseInfo(_S_MethDef* pmd,_S_PropDef* ppd,const char* ts,const char** RegNames,CRuntimeClass* pRTC,void (*pInitFunc)());
	_S_MethDef* pMethodDef;
	int methCount;
	_S_PropDef* pPropDef;
	int propCount;
	CBLMap MethMap;
	CBLMap PropMap;
	CObjID objID;
	const char* TypeString;
};

#define DECLARE_MY_CONTEXT() \
	static CMyContextBaseInfo m_myCtxBaseInfo; \
	static _S_MethDef m_MethDef[];\
	static _S_PropDef m_PropDef[];\
	static const char *m_RegNames[];\
	virtual CMyContextBaseInfo* GetBaseInfo()const{return &m_myCtxBaseInfo;}

#define IMPLEMENT_MY_CONTEXT(parClassName,parTypeString,parInitFunc) \
	CMyContextBaseInfo parClassName::m_myCtxBaseInfo(parClassName::m_MethDef, \
		parClassName::m_PropDef,#parTypeString,parClassName::m_RegNames,\
		RUNTIME_CLASS(parClassName),parInitFunc);\
	CObject* PASCAL parClassName::CreateObject() \
		{ return new parClassName; } \
	CRuntimeClass* PASCAL parClassName::_GetBaseClass()\
		{return CMyContextBase::m_ImplRuntimeClass.pBLRuntime;}  \
	AFX_COMDAT const AFX_DATADEF CRuntimeClass parClassName::class##parClassName= { \
		  #parClassName,sizeof(class parClassName),0xFFFF,parClassName::CreateObject, \
			&parClassName::_GetBaseClass,NULL }; \
	CRuntimeClass* parClassName::GetRuntimeClass() const \
		{ return RUNTIME_CLASS(parClassName); } \

#define BEGIN_BL_METH_MAP(parClassName) \
	_S_MethDef parClassName::m_MethDef[]={

#define BL_PROC(parNameEng,parNameRus,parNumberOfParam,parDoProc,parDefValProc) \
	{{#parNameEng,#parNameRus},0,parNumberOfParam,(PF_CTX)parDoProc,(PF_CTX)parDefValProc},

#define BL_FUNC(parNameEng,parNameRus,parNumberOfParam,parDoProc,parDefValProc) \
	{{#parNameEng,#parNameRus},1,parNumberOfParam,(PF_CTX)parDoProc,(PF_CTX)parDefValProc},

#define END_BL_METH_MAP() {{NULL,NULL},0,0,NULL,NULL}};


#define BEGIN_BL_PROP_MAP(parClassName) \
	_S_PropDef parClassName::m_PropDef[]={

#define BL_PROP(parNameEng,parNameRus,parIsRead,parIsWrite,parGet,parSet) \
	{{#parNameEng,#parNameRus},parIsRead,parIsWrite,(PF_CTX)parGet,(PF_CTX)parSet},

#define END_BL_PROP_MAP() {{NULL,NULL},false,false,NULL,NULL}};


#define BEGIN_REG_NAMES(parClassName) const char* parClassName::m_RegNames[]={
#define END_REG_NAMES() ,NULL};

class CMyContextBase : public CBLContext  
{
public:
	CMyContextBase();
	virtual ~CMyContextBase();  
	virtual int  CallAsFunc(int,CValue&,CValue**);
	virtual int  CallAsProc(int,CValue**);
	virtual int  FindMethod(char const *)const;
	virtual int  FindProp(char const *)const;
	virtual char const*  GetCode(void)const;
	virtual int  GetDestroyUnRefd(void)const;
	virtual CObjID GetID(void)const;
	virtual char const*  GetMethodName(int,int)const;
	virtual int  GetNMethods(void)const;
	virtual int  GetNParams(int)const;
	virtual int  GetNProps(void)const;
	virtual int  GetParamDefValue(int,int,CValue*)const;
	virtual char const* GetPropName(int,int)const;
	virtual int  GetPropVal(int,CValue&)const;
	virtual long  GetTypeID(void)const;
	virtual char const* GetTypeString(void)const;
	virtual CType GetValueType(void)const;
	virtual int  HasRetVal(int)const;
	virtual int  IsExactValue(void)const;
	virtual int  IsOleContext(void)const;
	virtual int  IsPropReadable(int)const;
	virtual int  IsPropWritable(int)const;
	virtual int  IsSerializable(void);
	virtual int  SaveToString(CString &);
	virtual int  SetPropVal(int,CValue const&);

	virtual CMyContextBaseInfo* GetBaseInfo()const=0;
	static struct _ImplRuntimeClass{
		_ImplRuntimeClass()
		{
			HINSTANCE hbe=GetModuleHandle("bkend.dll");
			pBLRuntime=(CRuntimeClass*)GetProcAddress(hbe,"?classCBLContext@CBLContext@@2UCRuntimeClass@@B");
		}
		CRuntimeClass* pBLRuntime;
	}m_ImplRuntimeClass;
};

#endif