#include "stdafx.h"

extern CBkEndUI * pBkEndUI;
extern DWORD myPlatformId;
extern HHOOK MouseHookHandle;
extern HHOOK HookHandle;
extern HHOOK WndHookHandle;
extern HHOOK WndPreHookHandle;
extern bool CreateInPlace;
extern CWnd* pWndSpl;

void _CallFromGlobalModules(CGroupContext *pCont, CBLModule *pMod, const char* nameProc0, const char* nameProc1, int argNum, CValue** vArray)
{
	ULONG id = CBLModule::GetFirstLoadedModuleID();
	bool f = (id != 0);

	int r = -1;

	while(f)
	{
		pMod = CBLModule::GetLoadedModule(id);
		if(pMod)
		{
			r = pMod->FindProc(nameProc0,0);
			if(r<0)
			{
				r = pMod->FindProc(nameProc1,0);
				if(r<0)
				{
					r = pMod->FindFunc(nameProc0);
					if(r<0)
					{
						r = pMod->FindFunc(nameProc1);
					}
				}
			}
		}
		if(r<0)
		{
			id = CBLModule::GetNextLoadedModuleID(id);
			f = (id != 0);
		}
		else f = false;
	}
	if(r>=0)
	{
		CValue p1, p2, p3, p4, p5, p6, p7, p8, p9, p10;
		CValue *vArrayGl[10] = {&p1, &p2, &p3, &p4, &p5, &p6, &p7, &p8, &p9, &p10};
		vArrayGl[0]->AssignContext(pCont);
		for(int i = 0; i<argNum; i++)
			*vArrayGl[i+1] = *vArray[i];
		argNum++;
		int nRes = pMod->CallAsProc(r,argNum,vArrayGl);
		if(nRes == 0)
		{
			CValue arValue;
			nRes = pMod->CallAsFunc(r,arValue,argNum,vArrayGl);
		}
	}
}

void _CallModuleProc(class CGetDoc7* pDoc, const char* nameProc0,const  char* nameProc1, int argNum, CValue** vArray)
{
	CGroupContext *pCont = pDoc->GetGroupContext();
	if(pCont)
	{        
		CBLContext *pCont0;
		for(int i = 0; i<pCont->GetSize(); i++)
		{
			pCont0 = pCont->GetContext(i);
			if(!strcmp(pCont0->GetRuntimeClass()->m_lpszClassName,"CDocContext"))
				((CDocContext*)pCont0)->SetEnableNewLine(1);
		}    
		CBLModule * pMod = GetModuleByContext(pCont);

		int r = -1;
		if(pMod)
		{      
			r = pMod->FindProc(nameProc0,0);
			if(r<0)
			{
				r = pMod->FindProc(nameProc1,0);
				if(r<0)
				{
					r = pMod->FindFunc(nameProc0);
					if(r<0)
					{
						r = pMod->FindFunc(nameProc1);
					}
				}
			}
		}
		if(r>=0)
		{
			int nRes = pMod->CallAsProc(r,argNum,vArray);
			if(nRes == 0)
			{
				CValue arValue;
				nRes = pMod->CallAsFunc(r,arValue,argNum,vArray);
			}
		}
		else
			_CallFromGlobalModules(pCont, pMod, nameProc0, nameProc1, argNum, vArray);
    }
	}

void CallModuleProc(const char* nameProc0,const  char* nameProc1, int argNum, CValue** vArray)
{
	CGetDoc7* pDoc7 = CGetDlg::GetTopmostDocunent();
	if(pDoc7)
		_CallModuleProc(pDoc7,nameProc0,nameProc1,argNum,vArray);
	else
	{
		CMDIFrameWnd * pMainFrame = GetMainFrame();
		if(pMainFrame)
		{
			CMDIChildWnd * pChild = pMainFrame->MDIGetActive();
			if(pChild)
			{
				CDocument* pDoc = pChild->GetActiveDocument();
				if(pDoc)
					if(!strcmp(pDoc->GetRuntimeClass()->m_pfnGetBaseClass()->m_lpszClassName,"CGetDoc7"))
						_CallModuleProc((CGetDoc7*)pDoc,nameProc0,nameProc1,argNum,vArray);
			}
		}
	}
}

LRESULT __stdcall Wnd_Hook(int code, WPARAM wParam, LPARAM lParam)
{
	if(code>=0)
	{
		CMDIFrameWnd * pMainFrame = GetMainFrame();
		if(pMainFrame)
		{
			PCWPRETSTRUCT pRetStruct = (PCWPRETSTRUCT) lParam;
			CWnd* pWnd = CWnd::FromHandle(pRetStruct->hwnd);
			if(pWnd)
			{
				switch (pRetStruct->message)
				{
				case WM_SHOWWINDOW:
					{            
						if((pRetStruct->lResult == 0) &&
							(((BOOL)pRetStruct->wParam) == TRUE))
						{

							if(!strcmp(pWnd->GetRuntimeClass()->m_lpszClassName,"CGetDlg"))
							{
								CGetDoc7* pDoc7 = ((CGetDlg*)pWnd)->GetTopmostDocunent();
								if(pDoc7)
									_CallModuleProc(pDoc7,"","OnActivate",0,NULL);
							}
							else if(!strcmp(pWnd->GetRuntimeClass()->m_lpszClassName,"CTabFrame"))
							{
								CGetDoc7* pDoc7 = (CGetDoc7*)((CTabFrame*)pWnd)->GetActiveDocument();
								if(pDoc7)
									_CallModuleProc(pDoc7,"","OnActivate",0,NULL);
								if(CreateInPlace)
								{
									CreateInPlace = false;
									pWndSpl = pWnd;
								}
							}
						}
						break;
					}
				case WM_SIZE:
					{
						if(!strcmp(pWnd->GetRuntimeClass()->m_lpszClassName,"CTabFrame"))//CBrowseView7
						{
							CValue fwSizeType = DWORD(pRetStruct->wParam);
							CValue nWidth = LOWORD(pRetStruct->lParam);
							CValue nHeight = HIWORD(pRetStruct->lParam);
							CValue *lArray[3] = {&fwSizeType, &nWidth, &nHeight};
							CDocument* pDoc7 = ((CTabFrame*)pWnd)->GetActiveDocument();
							if(pDoc7)
								if(!strcmp(pDoc7->GetRuntimeClass()->m_pfnGetBaseClass()->m_lpszClassName,"CGetDoc7"))
									_CallModuleProc((CGetDoc7*)pDoc7,"","OnSize",3,lArray);
						}
						break;
					}
				}
			}
		}
	}
		return CallNextHookEx(WndHookHandle, code, wParam, lParam);
}

LRESULT __stdcall WndPre_Hook(int code, WPARAM wParam, LPARAM lParam)
{
	if(code>=0)
	{
		CMDIFrameWnd * pMainFrame = GetMainFrame();
		if(pMainFrame)
		{
			PCWPSTRUCT pStruct = (PCWPSTRUCT) lParam;
			CWnd* pWnd = CWnd::FromHandle(pStruct->hwnd);
			if(pWnd)
			{
				switch (pStruct->message)
				{
					case WM_CLOSE:
						{
							if(pStruct->hwnd == (HWND)pMainFrame->GetSafeHwnd())
							{
								CWnd* pAWnd = NULL;
//								pAWnd = pMainFrame->GetWindow(GW_CHILD);
//								while(pAWnd)
//								{
//									pBkEndUI->DoMessageLine(pAWnd->GetRuntimeClass()->m_lpszClassName, mmNone);
//									pAWnd = pAWnd->GetNextWindow();
//								}
								while(pAWnd = pMainFrame->MDIGetActive())
								{
									pAWnd->SendMessage(WM_CLOSE);
								}
							}
							break;
						}
				}
			}
		}
	}
		return CallNextHookEx(WndPreHookHandle, code, wParam, lParam);
}

LRESULT __stdcall Key_Hook(int code, WPARAM wParam, LPARAM lParam)
{  
	LRESULT ret = 0;
	if(code>=0)
	{
		if((lParam & 0x40000000) == 0)
		{
			CValue KeyCode;
			CValue AltPressFlag;
			CValue ShiftPressFlag;
			CValue CtrlPressFlag;
			CValue r = 1;

			KeyCode = wParam;
			AltPressFlag = 0L;
			ShiftPressFlag = 0L;
			CtrlPressFlag = 0L;

			if(GetKeyState(VK_SHIFT) & 0x80) ShiftPressFlag = 1;
			if(GetKeyState(VK_CONTROL) & 0x80) CtrlPressFlag = 1;
			if(lParam & 0x20000000) AltPressFlag = 1;

			CValue *lArray[5] = {&KeyCode, &AltPressFlag, &ShiftPressFlag, &CtrlPressFlag, &r};      
			CallModuleProc("","OnChar", 5, lArray);
			if(r.GetNumeric() == 0) ret = 1;
		}
	}
	if(ret == 1) CallNextHookEx(HookHandle, code, wParam, lParam);
	else ret = CallNextHookEx(HookHandle, code, wParam, lParam);
	return ret;
}

LRESULT __stdcall Mouse_Hook(int code, WPARAM wParam, LPARAM lParam)
{
	LRESULT ret = 0;
	if(code>=0)
	{
		PMOUSEHOOKSTRUCT mStruct;
		mStruct = (PMOUSEHOOKSTRUCT)lParam;
		CWnd* pWnd = CWnd::FromHandle(mStruct->hwnd);
		if(pWnd)
		{
			CGetDoc7* pDoc7 = NULL;
			if(CString("CGetDlg") == pWnd->GetRuntimeClass()->m_lpszClassName)
			{
				pDoc7 = CGetDlg::GetTopmostDocunent();
				if(pDoc7->GetFrame() != pWnd)
					pDoc7 = NULL;

			}
			else if(CString("CTabFrame") != pWnd->GetRuntimeClass()->m_lpszClassName)
			{
				CWnd* pPWnd = pWnd->GetParent();
				bool f = true;
				while(pPWnd && f)
				{
					if((CString("CTabFrame") != pPWnd->GetRuntimeClass()->m_lpszClassName) &&
						(CString("CGetDlg") != pPWnd->GetRuntimeClass()->m_lpszClassName))
						pPWnd = pPWnd->GetParent();
					else
						f = false;
				}
				if(pPWnd)
				{
					if(CString("CTabFrame") == pPWnd->GetRuntimeClass()->m_lpszClassName)
						pDoc7 = (CGetDoc7*)((CTabFrame*)pPWnd)->GetActiveDocument();
					else if(CString("CGetDlg") == pPWnd->GetRuntimeClass()->m_lpszClassName)
					{
						pDoc7 = CGetDlg::GetTopmostDocunent();
						if(pDoc7->GetFrame() != pPWnd)
							pDoc7 = NULL;
					}
				}
			}
			else
				pDoc7 = (CGetDoc7*)((CTabFrame*)pWnd)->GetActiveDocument();

			if(pDoc7)
			if(!strcmp(pDoc7->GetRuntimeClass()->m_pfnGetBaseClass()->m_lpszClassName,"CGetDoc7"))
			{
				UINT nKeyState = 0;
				short sKeyState = GetKeyState(VK_SHIFT);
				if(sKeyState & 0x80) nKeyState |= MK_SHIFT;

				sKeyState = GetKeyState(VK_LBUTTON);
				if(sKeyState & 0x80) nKeyState |= MK_LBUTTON;

				sKeyState = GetKeyState(VK_RBUTTON);
				if(sKeyState & 0x80) nKeyState |= MK_RBUTTON;

				sKeyState = GetKeyState(VK_MBUTTON);
				if(sKeyState & 0x80) nKeyState |= MK_MBUTTON;

				sKeyState = GetKeyState(VK_CONTROL);
				if(sKeyState & 0x80) nKeyState |= MK_CONTROL;

				POINT pt;
				pt.x = mStruct->pt.x;
				pt.y = mStruct->pt.y;

				POSITION aPOS = ((CDocument*)pDoc7)->GetFirstViewPosition();
				CWnd* pView = (CWnd*)((CDocument*)pDoc7)->GetNextView(aPOS);
				if(pView == NULL)
					pView = pDoc7->GetFrame();

				if(pView)
					pView->ScreenToClient(&pt);

				CValue Flags = nKeyState;
				CValue x = pt.x;
				CValue y = pt.y;
				CValue r = 1;
				CValue *lArray[4] = {&Flags, &x, &y, &r};

				switch (wParam)
				{
					case WM_MOUSEMOVE:
						{
							_CallModuleProc(pDoc7,"","OnMouseMove", 3, lArray);
							break;
						}
					case WM_RBUTTONDOWN:
						{
							_CallModuleProc(pDoc7,"","OnRButtonDown", 4, lArray);
							break;
						}
					case WM_LBUTTONDOWN:
						{
							_CallModuleProc(pDoc7,"","OnLButtonDown", 4, lArray);
							break;
						}
					case WM_RBUTTONUP:
						{
							_CallModuleProc(pDoc7,"","OnRButtonUp", 4, lArray);
							break;
						}
					case WM_LBUTTONUP:
						{
							_CallModuleProc(pDoc7,"","OnLButtonUp", 4, lArray);
							break;
						}
					case WM_LBUTTONDBLCLK:
						{
							_CallModuleProc(pDoc7,"","OnLButtonDblClk", 4, lArray);
							break;
						}
					case WM_RBUTTONDBLCLK:
						{
							_CallModuleProc(pDoc7,"","OnRButtonDblClk", 4, lArray);
							break;
						}
				}
				if(r.GetNumeric() == 0) ret = 1;
			}
		}
	}
	if(ret == 1) CallNextHookEx(MouseHookHandle, code, wParam, lParam);
	else ret = CallNextHookEx(MouseHookHandle, code, wParam, lParam);
	return ret;
}
