// AddIn.cpp

#include "stdafx.h"
#include "mycontextbase.h"
#include "AddIn.h"
#include "ExecuteModule.h"
#include "WorkAsRegister.h"
#include "TemplateClass.h"
#include "EventManager.h"
#include "ComponentClass.h"
#include "HashMap.h"
#include "Delegate.h"
#include "Struct.h"
#include "DynaValue.h"
#include "DynaValueList.h"
#include "MySQL_Query.h"
#include "CreateMetaInfoClasses.h"

//{OAS
#include ".\\TurboBL\\gcboost.h"
//#include "loader.h"
//OAS}


#include "Service.h"
#include "FormEx.h"
#include "AttribEx.h"
#include "TableEx.h"
#include "PaintHook.h"
#include "MDIClientWnd.h"
#include "WrapAboutDlg.h"
#include "v7Windows.h"

#include ".\\SQL\\MetaDataWork.h"
#include ".\\ODBC\\1CPP_ODBCDatabase.h"
#include ".\\ODBC\\1CPP_ODBCRecordSet.h"
#include ".\\ODBC\\SQLLock.h"
#include "BinaryData.h"
#include "GUID.h"
#include "istrmap.h"
#include "Factory.h"
#include ".\\OLEDB\\sp_oledb.h"// Kirill
#include ".\\OLEDB\\sp_cooledb.h"// Kirill

// This global interface is for timer implementation only

class CDataBase7 * pDataBase7;
class CMetaDataCont * pMetaDataCont;
class CBkEndUI * pBkEndUI;
class CAddIn * pMainAddIn;
CRuntimeClass* pCBLContextRuntimeClass;

// FORMEX:BEGIN
extern HINSTANCE hDllInstance;
class CMDIFrameWnd * pMainWindow = NULL;
class CWinApp* pApp = NULL; //CApp7

HHOOK MouseHookHandle = 0;
HHOOK HookHandle = 0;
HHOOK WndHookHandle = 0;
HHOOK WndPreHookHandle = 0;

BOOL m_bEnabledColor = FALSE;
BOOL m_bLocalColor = FALSE;
BOOL m_bShowKL = FALSE;
UINT StatusTimer = 0;
CWnd* pWndSpl = NULL;

DWORD myPlatformId;
CMDIClientWnd * wndMDIClient = NULL;
bool CreateInPlace = false;
LONG hMainWndProc = 0;
CDWordArray glColContArray;
CString strTimerName = "";
UINT uTimer = 0;

UINT uMainWindowStyle = 0;
UINT uChildWindowStyle = 0;
UINT uChildModalWindowStyle = 0;
BOOL bModalState = FALSE;
CDWordArray srcMenus;
CDWordArray tempMenus;
CStringArray unvisibleMenus;
CStringArray unenableMenus;

CDWordArray glCursorArray;
CDWordArray glCursorWindowsArray;

bool bMinimizeToTray = false;
NOTIFYICONDATA	nidIconData;

IDispatch *pGlobalConnection = NULL;

//-------------------------------------------------------------------------------------
LRESULT FormEx_OnSetCursor(WORD nHittest)
{
	CWnd* pWnd = NULL;
	POINT curPoint;
	if(::GetCursorPos(&curPoint))
	{
		CMDIFrameWnd * pMain1CFrame = GetMainFrame();
		if(pMain1CFrame)
		{
			int szArr = glCursorWindowsArray.GetSize();
			if(szArr > 0)
			{
				CWnd* pWndT = pMain1CFrame;
				CGetDoc7* pDoc7 = CGetDlg::GetTopmostDocunent();
				if(pDoc7)
				{
					CGetDlg* pGetDlg = (CGetDlg*)pDoc7->GetFrame();
					if(pGetDlg)
					{
						pGetDlg->ScreenToClient(&curPoint);
						pWnd = pGetDlg->ChildWindowFromPoint(curPoint,CWP_SKIPINVISIBLE);//CWP_ALL);
						if(pWnd)
						{
							if((CString("CButton") == pWnd->GetRuntimeClass()->m_lpszClassName) && ((pWnd->GetStyle() & BS_GROUPBOX) == BS_GROUPBOX))
							{
								if(::SetWindowPos(pWnd->GetSafeHwnd(),HWND_BOTTOM,0,0,0,0,
													SWP_NOMOVE|
													SWP_NOACTIVATE|
													SWP_NOREDRAW|
													SWP_NOOWNERZORDER|
													SWP_NOSIZE|
													SWP_NOSENDCHANGING))
								{
									pWnd = pGetDlg->ChildWindowFromPoint(curPoint,CWP_ALL);
								}
							}
							else
							if((CString("CTabCtrl") == pWnd->GetRuntimeClass()->m_lpszClassName))
							{
								if(::SetWindowPos(pWnd->GetSafeHwnd(),HWND_BOTTOM,0,0,0,0,
													SWP_NOMOVE|
													SWP_NOACTIVATE|
													SWP_NOREDRAW|
													SWP_NOOWNERZORDER|
													SWP_NOSIZE|
													SWP_NOSENDCHANGING))
								{
									pWnd = pGetDlg->ChildWindowFromPoint(curPoint,CWP_ALL);
								}
							}
						}
					}
				}
				else
				{
					pMain1CFrame->ScreenToClient(&curPoint);
					pWnd = pMain1CFrame->ChildWindowFromPoint(curPoint,CWP_ALL);
				}
				if(pWnd == NULL) pWnd = pWndT;
				while(pWnd != pWndT)
				{
					pWndT->ClientToScreen(&curPoint);
					pWndT = pWnd;
					pWnd->ScreenToClient(&curPoint);
					pWnd = pWnd->ChildWindowFromPoint(curPoint,CWP_ALL);
					if(pWnd == NULL) pWnd = pWndT;
					else
					{
						if((CString("CButton") == pWnd->GetRuntimeClass()->m_lpszClassName) && ((pWnd->GetStyle() & BS_GROUPBOX) == BS_GROUPBOX))
						{
							if(::SetWindowPos(pWnd->GetSafeHwnd(),HWND_BOTTOM,0,0,0,0,
												SWP_NOMOVE|
												SWP_NOACTIVATE|
												SWP_NOREDRAW|
												SWP_NOOWNERZORDER|
												SWP_NOSIZE|
												SWP_NOSENDCHANGING))
							{
								pWnd = pWndT->ChildWindowFromPoint(curPoint,CWP_ALL);
								if(pWnd == NULL) pWnd = pWndT;
							}
						}
						else
						if((CString("CTabCtrl") == pWnd->GetRuntimeClass()->m_lpszClassName))
						{
							if(::SetWindowPos(pWnd->GetSafeHwnd(),HWND_BOTTOM,0,0,0,0,
												SWP_NOMOVE|
												SWP_NOACTIVATE|
												SWP_NOREDRAW|
												SWP_NOOWNERZORDER|
												SWP_NOSIZE|
												SWP_NOSENDCHANGING))
							{
								pWnd = pWndT->ChildWindowFromPoint(curPoint,CWP_ALL);
								if(pWnd == NULL) pWnd = pWndT;
							}
						}
					}
				}
				pWnd = pWndT;
				while(pWnd)
				{
					DWORD dwHWnd = (DWORD)pWnd->GetSafeHwnd();
					int iContAr = -1;
					for(iContAr = 0; iContAr < szArr; iContAr++)
						if(glCursorWindowsArray.GetAt(iContAr) == dwHWnd)
							break;

					if((iContAr >= 0) && (iContAr < szArr))
					{
						HCURSOR hCur = (HCURSOR)glCursorArray.GetAt(iContAr);
						::SetCursor(hCur);
						return 1;
					}
					else if(pWnd == pMain1CFrame)
						pWnd = NULL;
					else
						pWnd = pWnd->GetParent();
				}
			}
		}
	}
	return 0;
}

LRESULT CALLBACK newMainWndProc(HWND hWnd, UINT nMessage, WPARAM wParam, LPARAM lParam)
{
	if(nMessage == WM_SETCURSOR)
	{
		if(FormEx_OnSetCursor(LOWORD(lParam))) return 1;
	}
	return ((WNDPROC)hMainWndProc)(hWnd, nMessage, wParam, lParam);
}

LRESULT WINAPI DlgProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch( uMsg ) {
	case WM_INITDIALOG:
		return TRUE;
	case WM_COMMAND:
		switch( wParam ) {
		case IDOK:
			EndDialog( hDlg, TRUE );
			return TRUE;
		}
		break;
	}
	
	return FALSE;
}
// FORMEX:END

//DMS:BEGIN
char buf[4096];
char **pst = 0;
//DMS:END

/////////////////////////////////////////////////////////////////////////////
// CAddIn

BOOL CAddIn::LoadProperties()
{  
    HRESULT hRes;
    CString csProperty; 
    VARIANT varEnabled;
	// Load flag switching component activity on or off
    csProperty = "EnabledCheckType:0";
	
    VariantInit(&varEnabled);
    V_VT(&varEnabled) = VT_I4;
    hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
    if (hRes == S_OK)
    {
		if (V_I4(&varEnabled) == 2)
			m_EnabledCheckType = TRUE;
		else if (V_I4(&varEnabled) == 1)
			m_EnabledCheckType = FALSE;
    }
    
    csProperty = "EnableOptimizate:0";
	
    VariantInit(&varEnabled);
    V_VT(&varEnabled) = VT_I4;    
    hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
    if (hRes == S_OK) 
    {
		if (V_I4(&varEnabled) == 2)
			m_EnableOptimizate = TRUE;
		else if (V_I4(&varEnabled) == 1)
			m_EnableOptimizate = FALSE;
		
    }
    
    csProperty = "EnableDebugging:0";
	
    VariantInit(&varEnabled);
    V_VT(&varEnabled) = VT_I4;    
    hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
    if (hRes == S_OK) 
    {
		if (V_I4(&varEnabled) == 2)
			m_EnableDebugging = TRUE;
		else if (V_I4(&varEnabled) == 1)
			m_EnableDebugging = FALSE;
		
    }
    
    
    csProperty = "EnabledColor:0";
	hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
	if (hRes != S_OK) return FALSE;
	m_bEnabledColor = V_I4(&varEnabled)?TRUE:FALSE;
	
	csProperty = "LocalColor:0";
	hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
	if (hRes != S_OK) return FALSE;
	m_bLocalColor = V_I4(&varEnabled)?TRUE:FALSE;
	
	csProperty = "ShowKeyboardLayout:0";
	hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
	if (hRes != S_OK) return FALSE;
	m_bShowKL = V_I4(&varEnabled)?TRUE:FALSE;
	
    /*csProperty = "FileNameOfDefineClasses:0";
    VariantInit(&varEnabled);
    V_VT(&varEnabled) = VT_BSTR;
    hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
    
	  if (hRes == S_OK) 
	  {    
      BSTR pBSTR = (BSTR)(&varEnabled);
      m_StrFileNameOfDefClass.Empty();
      m_StrFileNameOfDefClass.SetSysString(&pBSTR);    
}       */
    return TRUE;
}   

void CAddIn::SaveProperties()
{
    CString csProperty; 
    VARIANT varEnabled;
	
	// Save flag switching component activity on or off
    csProperty = "EnabledCheckType";
	
    VariantInit(&varEnabled);
    V_VT(&varEnabled) = VT_I4;
    V_I4(&varEnabled) = m_EnabledCheckType?2:1;
    m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);
	
    csProperty = "EnableOptimizate";
    V_I4(&varEnabled) = m_EnableOptimizate?2:1;
    m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);
    
    csProperty = "EnableDebugging";
    V_I4(&varEnabled) = m_EnableDebugging?2:1;
    m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);
	
    csProperty = "EnabledColor";
	V_I4(&varEnabled) = m_bEnabledColor?1:0;
	m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);
	
	csProperty = "LocalColor";
	V_I4(&varEnabled) = m_bLocalColor?1:0;
	m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);
	
	csProperty = "ShowKeyboardLayout";
	V_I4(&varEnabled) = m_bShowKL?1:0;
	m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);
	
    /*csProperty = "FileNameOfDefineClasses";
    VariantInit(&varEnabled);
    V_VT(&varEnabled) = VT_BSTR;
    V_BSTR(&varEnabled) = m_StrFileNameOfDefClass.AllocSysString();
    m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);*/
}

/* 
These two methods is convenient way to access function 
parameters from SAFEARRAY vector of variants
*/

/////////////////////////////////////////////////////////////////////////////
// IInitDone

#define COPY6(FromPtr, ToPtr) \
    BYTE* fp = (BYTE*)FromPtr; \
    BYTE* tp = (BYTE*)ToPtr; \
    for (int i = 0; i < 6; i++) *tp++ = *fp++;

#define SetWrapJmp(NativeFuncAdr, NewFuncAdr) \
    BYTE* p = NativeFuncAdr; \
    *p++ = 0xFF; \
    *p++ = 0x25; \
	*(DWORD*)p = (DWORD)&NewFuncAdr;

typedef CBLContext* (*PF_CreateInstance)(char const *);
static BYTE* adrNativeCreateInstance;
static PF_CreateInstance NewCreateInstance;
static BYTE NativeCreateInstanceBody[6];

CIStringMapToOb* pClassNameHash;

void RegisterCBLContext(CRuntimeClass* pRuntimeClass, LPCSTR szClassName, BOOL bNativeRegistration /*= TRUE*/)
{
    if (pClassNameHash->GetCount() * 1.2 > pClassNameHash->GetHashTableSize())
    {
        CIStringMapToOb* pNewHash = new CIStringMapToOb();
        pNewHash->InitHashTable((pClassNameHash->GetCount() + 11) * 1.2);
        POSITION pos = pClassNameHash->GetStartPosition();
        CString strCurName;
        CObject* pObject;
        while (pos)
        {
            pClassNameHash->GetNextAssoc(pos, strCurName, pObject);
            pNewHash->operator[](strCurName) = pObject;
        }
        delete pClassNameHash;
        pClassNameHash = pNewHash;

        /*
        CString s;
        s.Format("Class names hash table is grown to: %d", pClassNameHash->GetHashTableSize());
        pBkEndUI->DoMessageLine(s);
        */
    }
    if (bNativeRegistration)
        CBLContext::RegisterContextClass(pRuntimeClass, szClassName, CType(100));
    pClassNameHash->operator[](szClassName) = (CObject*)pRuntimeClass;
    /*
    CString s;
    s.Format("%s : %d", szClassName, pClassNameHash->GetCount());
    pBkEndUI->DoMessageLine(s);
    */
}

CBLContext* CreateInstanceBoosted(char const * szClassName)
{
    CBLContext* pBLContext;
    CRuntimeClass* pRuntimeClass;
    if (pClassNameHash->Lookup(szClassName, (CObject*&)pRuntimeClass))
    {
        pBLContext = (CBLContext*)pRuntimeClass->CreateObject();
        pBLContext->InitObject(szClassName);
    }
    else
    {
        COPY6(NativeCreateInstanceBody, adrNativeCreateInstance);
        pBLContext = CBLContext::CreateInstance(szClassName);
        SetWrapJmp(adrNativeCreateInstance, NewCreateInstance);
        if (pBLContext)
        {
            if (!pBLContext->IsOleContext())
                RegisterCBLContext(pBLContext->GetRuntimeClass(), szClassName, FALSE);
        }
    }
    return pBLContext;
}

STDMETHODIMP CAddIn::Init(IDispatch *pConnection)
{
	{
		
		if(pBkEndUI = GetBkEndUI())
		{
#ifdef _DEBUG
			pBkEndUI->DoMessageLine("1C++ service successfuly initialized",mmInformation);
#endif
		}
		pConnection->QueryInterface(IID_IErrorLog,(void **)&m_iErrorLog);
		
		
		pConnection->QueryInterface(IID_IAsyncEvent,(void **)&m_iAsyncEvent);
		
		
		pConnection->QueryInterface(IID_IStatusLine,(void **)&m_iStatusLine);
		
		CString csProfileName = "1C++ Components & Class";
		
		pConnection->QueryInterface(IID_IPropertyProfile,(void **)&m_iProfile);
		
		
		pConnection->QueryInterface(IID_IExtWndsSupport,(void **)&m_iExtWndsSupport);
		
		
		if (m_iProfile) 
		{
			m_iProfile->RegisterProfileAs(csProfileName.AllocSysString());
			if (LoadProperties() == FALSE) return E_FAIL;
		}
		
		pGlobalConnection = pConnection;

	}
	
	pDataBase7			= CDataBase7::GetDefault();
	pMetaDataCont		= pDataBase7->GetMD();

    //  
    pClassNameHash = new CIStringMapToOb();
    //pClassNameHash->InitHashTable(5 * 1.2); //just for debug
    DWORD oldProtect;
    adrNativeCreateInstance = (BYTE*)GetProcAddress(::GetModuleHandle("bkend.dll"), "?CreateInstance@CBLContext@@SAPAV1@PBD@Z");
	VirtualProtect(adrNativeCreateInstance, 6, PAGE_EXECUTE_READWRITE, &oldProtect);
    COPY6(adrNativeCreateInstance, NativeCreateInstanceBody);
	NewCreateInstance = (PF_CreateInstance)CreateInstanceBoosted;
    SetWrapJmp(adrNativeCreateInstance, NewCreateInstance);
	//

	CBLContext::RegisterContextClass(RUNTIME_CLASS(CExecuteModule) ,"ExecuteModule",CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CExecuteModule) ,"",CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CWorkAsRegister), "WorkAsRegisterWin", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CWorkAsRegister), "Win", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CComponentClass), "CComponentClass", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CEventManager), "EventManager", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CEventManager), "", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CDelegate), "Delegate", CType(100));  
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CDelegate), "", CType(100));  
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CHashMap), "HashMap", CType(100));  
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CStruct), "Struct", CType(100));    
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CStruct), "", CType(100));    
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CDynaValueList), "DynaValueList", CType(100));    
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CDynaValue), "DynaValue", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CDynaCrypt), "DynaCrypt", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CMySQL_Query), "SQL_Query", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CCreateMetaInfoClasses), "MetaInfoClasses", CType(100));
	
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CService) ,"ServiceFormEx", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CService) ,"", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CService) ,"Service", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CService) ,"", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CFormEx) ,"FormEx", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CFormEx) ,"", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CAttribEx) ,"AttribEx", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CAttribEx) ,"", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CTableEx)	,"TableEx"	, CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CTableEx)	,"", CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(Cv7Windows)	,""		,CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(Cv7Windows)	,"Windows"	,CType(100));
	
	
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CMetaDataWork) ,"MetaDataWork",CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(C1CPP_ODBCRecordSet) ,"ODBCRecordSet",CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(C1CPP_ODBCDatabase) ,"ODBCDatabase",CType(100));
	
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CSQLLock) ,"SQLLock",CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CBinaryData) ,"BinaryData",CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CGUID) ,"GUID",CType(100));
	CBLContext::RegisterContextClass(RUNTIME_CLASS(CObjectFactory) ,"",CType(100));

	CBLContext::RegisterContextClass(RUNTIME_CLASS(COLEDBData), "OLEDBData", CType(100));// Kirill

	//CAttachedContext::Init();
	
    CMyContextBase::InitAllContextClasses();
	InitAllBoost();
	//OAS}
	
	hLibBasic = GetModuleHandle("Basic.dll");
	if (hLibBasic == NULL)  
		pBkEndUI->DoMessageLine("     Basic.dll",mmInformation);  
	
	//   
	OSVERSIONINFO osvi;
	ZeroMemory(&osvi, sizeof(OSVERSIONINFO));
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx((OSVERSIONINFO*)&osvi);
	myPlatformId = osvi.dwPlatformId;
	
	pMainWindow = GetMainFrame();
	if(!pMainWindow) return E_FAIL;

	pApp = AfxGetApp();

	CSetOfHierarchy *pHierarchy = CSetOfHierarchy::GetHierarchy();
	
	pHierarchy->Init();
	pHierarchy->ProcessDefines();
	
	pHierarchy->RegistersContextClasses();
	
	pMainAddIn = this;
	
	CComponentClass::ExeptionValue = new CValue;
	
	if(pApp)
	{
		MouseHookHandle = SetWindowsHookEx(WH_MOUSE, Mouse_Hook, pApp->m_hInstance, pApp->m_nThreadID);
		HookHandle = SetWindowsHookEx(WH_KEYBOARD, Key_Hook, pApp->m_hInstance, pApp->m_nThreadID);
		WndHookHandle = SetWindowsHookEx(WH_CALLWNDPROCRET, Wnd_Hook, pApp->m_hInstance, pApp->m_nThreadID);
		WndPreHookHandle = SetWindowsHookEx(WH_CALLWNDPROC, WndPre_Hook, pApp->m_hInstance, pApp->m_nThreadID);

		if(m_bEnabledColor)
		{
			CBrowseWrapper::SetWrap();
		}
		if(m_bShowKL)
		{
			SECStatusBar* pStatus = (SECStatusBar*)AfxGetApp()->m_pMainWnd->GetDescendantWindow(AFX_IDW_STATUS_BAR);
			if(pStatus)
			{
				int count = pStatus->GetCount();
				UINT* nIDs;
				UINT* nStyles;
				int* cxWidths;
				nIDs = (UINT*)malloc(count*sizeof(UINT));
				nStyles = (UINT*)malloc(count*sizeof(UINT));
				cxWidths = (int*)malloc(count*sizeof(int));
				for(int i = 0; i<count; i++)
					pStatus->GetPaneInfo(i,nIDs[i],nStyles[i],cxWidths[i]);
				pStatus->AllocElements(count+2,100);
				pStatus->SetPaneInfo(count+1,NULL,SBPS_NORMAL, 43);
				pStatus->SetPaneInfo(count,NULL,SBPS_NORMAL, 20);
				char KLName[KL_NAMELENGTH]; 
				if(GetLocaleInfo((LCID)((WORD)GetKeyboardLayout(AfxGetApp()->m_nThreadID)),LOCALE_SABBREVLANGNAME,KLName,KL_NAMELENGTH))
					pStatus->SetPaneText(count,KLName,KL_NAMELENGTH);
				StatusTimer = pStatus->SetTimer(500,100,(TIMERPROC)TimerProc);
				for(i = 0; i<count; i++)
					pStatus->SetPaneInfo(i,nIDs[i],nStyles[i],cxWidths[i]);
				free(nIDs);
				free(nStyles);
				free(cxWidths);
			}
		}
	}

	hMainWndProc = ::GetWindowLong(pMainWindow->GetSafeHwnd(),GWL_WNDPROC);
	::SetWindowLong(pMainWindow->GetSafeHwnd(),GWL_WNDPROC,(LONG)newMainWndProc);
	wndMDIClient = new CMDIClientWnd;
	if(!wndMDIClient->SubclassWindow(pMainWindow->m_hWndMDIClient))
	{
		pBkEndUI->DoMessageLine("Failed to subclass MDI client window", mmRedErr);
		delete wndMDIClient;
		wndMDIClient = NULL;
	}
	else
	{
		CGalleryHolder * pGalleryHolder = CGalleryHolder::GetGallery();
		if(pGalleryHolder)
		{
			ULONG picID = pGalleryHolder->FindByAlias("Wallpaper");
			if(picID)
			{
				CPictureHolder7 * pic;
				pic = new CPictureHolder7(pGalleryHolder->GetPicture(picID));

				CDC dcMem;
				CDC* pDC = CWnd::GetDesktopWindow()->GetDC();

				if (dcMem.CreateCompatibleDC(pDC))
				{
					CSize hmSize = pic->GetSize();

					CBitmap bmMem;

					if (bmMem.CreateCompatibleBitmap(pDC, hmSize.cx, hmSize.cy))
					{
						CBitmap* pOldBM = dcMem.SelectObject(&bmMem);

						dcMem.FillSolidRect(0, 0, hmSize.cx, hmSize.cy, RGB(0x100,0x100,0x100));
						RECT rect1;
						RECT rect2;
						rect1.top = 0;
						rect1.left = 0;
						rect1.right = hmSize.cx;
						rect1.bottom = hmSize.cy;
						
						pic->Render(dcMem, rect1, 0, &rect2);

						wndMDIClient->m_Bitmap.Attach(bmMem.Detach());
						wndMDIClient->m_nType = 1;
						wndMDIClient->CreateGrayBitmap();

						dcMem.SelectObject(pOldBM);
					}
				}
				CWnd::GetDesktopWindow()->ReleaseDC(pDC);
				delete pic;
			}
		}

		wndMDIClient->m_nBkColor = -1;
		wndMDIClient->m_bGray = false;
		wndMDIClient->RedrawWindow();
	}

	nidIconData.cbSize				= sizeof(NOTIFYICONDATA);
	
	nidIconData.hWnd				= pMainWindow->GetSafeHwnd();
	nidIconData.uID					= 1;

	nidIconData.uCallbackMessage	= WM_TRAY_ICON_NOTIFY_MESSAGE;

	nidIconData.hIcon				= ::LoadIcon(hDllInstance,MAKEINTRESOURCE(IDI_ICONMAIN));//pMainFrame->GetIcon(TRUE);
	nidIconData.szTip[0]			= 0;
	nidIconData.uFlags				= NIF_MESSAGE | NIF_ICON | NIF_TIP;

	CString lpszToolTip = "";
	pMainWindow->GetWindowText(lpszToolTip);
	strcpy(nidIconData.szTip, lpszToolTip.Left(63));

	CWrapModule WrapModule;
	CGetDlgWrapped::SetWrap();

	CAboutDlg AboutDlg(0);
	CWrapAboutDlg::Wrap(&AboutDlg);
	
	return S_OK;
}

STDMETHODIMP CAddIn::Done()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
		//    if (m_uiTimer != 0) ::KillTimer(NULL,m_uiTimer);
		SaveProperties();
	
	if (m_iStatusLine) m_iStatusLine->Release();
	if (m_iProfile) m_iProfile->Release();
	if (m_iAsyncEvent) m_iAsyncEvent->Release();
	if (m_iErrorLog) m_iErrorLog->Release();
	if (m_iExtWndsSupport) m_iExtWndsSupport->Release();
	
    //   
    delete pClassNameHash;
    COPY6(NativeCreateInstanceBody, adrNativeCreateInstance);
    //
    
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CExecuteModule));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CExecuteModule));	
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CWorkAsRegister));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CWorkAsRegister));	
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CComponentClass));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CEventManager));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CEventManager));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CDelegate));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CDelegate));  
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CStruct));    
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CStruct));    
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CDynaValueList));    
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CDynaValue));    
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CDynaCrypt));      
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CMySQL_Query));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CCreateMetaInfoClasses));  
	
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(Cv7Windows));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(Cv7Windows));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CTableEx));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CTableEx));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CAttribEx));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CAttribEx));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CFormEx));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CFormEx));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CService));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CService));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CService));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CService));
	
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CMetaDataWork));
	
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(C1CPP_ODBCRecordSet));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(C1CPP_ODBCDatabase));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CSQLLock));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CBinaryData));
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(CGUID));
	
	CBLContext::UnRegisterContextClass(RUNTIME_CLASS(COLEDBData));// Kirill
	
	if (hLibBasic != NULL)  
		FreeLibrary(hLibBasic);
	
	CSetOfHierarchy::DeInitHierarchy();
	
	pMainAddIn = NULL;
	
	int n = tempMenus.GetSize();
	for(i = 0; i < n; i++)
	{
		CMenu *pMenuT = CMenu::FromHandle((HMENU)tempMenus.GetAt(i));
		if(pMenuT) pMenuT->DestroyMenu();
	}
	srcMenus.RemoveAll();
	tempMenus.RemoveAll();
	unvisibleMenus.RemoveAll();
	unenableMenus.RemoveAll();

	if(MouseHookHandle != 0) UnhookWindowsHookEx(MouseHookHandle);
	if(HookHandle != 0) UnhookWindowsHookEx(HookHandle);
	if(WndHookHandle != 0) UnhookWindowsHookEx(WndHookHandle);
	if(WndPreHookHandle != 0) UnhookWindowsHookEx(WndPreHookHandle);
	
	if(wndMDIClient != NULL)
	{
		CMDIFrameWnd * pMainFrame = GetMainFrame();
		if(pMainFrame)
		{
			wndMDIClient->RedrawWindow();
			if(!wndMDIClient->UnsubclassWindow())
				pBkEndUI->DoMessageLine("Failed to unsubclass MDI client window", mmRedErr);
			delete wndMDIClient;
		}
	}
	
	if(uTimer)
	{
		CWnd* pMainWnd = GetMainFrame();
		if(pMainWnd) pMainWnd->KillTimer(uTimer);
	}

	glColContArray.RemoveAll();
	glCursorArray.RemoveAll();
	glCursorWindowsArray.RemoveAll();
	
	if(bModalState)
	{
		bModalState = FALSE;
		HWND hwnd;

		if(hwnd=::FindWindowEx(GetDesktopWindow(),NULL,"Progman",NULL))
			if(hwnd=::FindWindowEx(hwnd,NULL,"SHELLDLL_DefView",NULL))
				::EnableWindow(hwnd, TRUE);
		if(hwnd=::FindWindowEx(::GetDesktopWindow(),NULL,"Shell_TrayWnd",NULL))
			::EnableWindow(hwnd, TRUE);

		::SetWindowPos(pMainWindow->GetSafeHwnd(),HWND_NOTOPMOST,0,0,0,0, SWP_DRAWFRAME | SWP_NOSIZE);
	}

	Shell_NotifyIcon(NIM_DELETE,&nidIconData);

	return S_OK;
}

STDMETHODIMP CAddIn::GetInfo(SAFEARRAY **pInfo)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
		
		// Component should put supported component technology version 
		// in VARIANT at index 0     
		long lInd = 0;
    VARIANT varVersion;
    V_VT(&varVersion) = VT_I4;
	// This component supports 1.0 version
    V_I4(&varVersion) = 2000;
    SafeArrayPutElement(*pInfo,&lInd,&varVersion);
    
	return S_OK;
}

/////////////////////////////////////////////////////////////////////////////
// ILanguageExtender

STDMETHODIMP CAddIn::RegisterExtensionAs(BSTR *bstrExtensionName)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
		
		// You may delete next lines and add your own implementation code here
		
		// Name of extension should be changed avoiding conflicts 
		CString csExtenderName = "1C++";
    *bstrExtensionName = csExtenderName.AllocSysString();
	
	return NULL;
}





/////////////////////////////////////////////////////////////////////////////
// IPropertyPage

/*STDMETHODIMP CAddIn::SetPageSite(IPropertyPageSite *pPageSite)
{
AFX_MANAGE_STATE(AfxGetStaticModuleState())
m_pPageSite = pPageSite;
// TODO: Add your implementation code here

  return S_OK;
}*/

/*STDMETHODIMP CAddIn::Activate(HWND hWndParent,LPCRECT prc,BOOL bModal)
{
AFX_MANAGE_STATE(AfxGetStaticModuleState())

  // TODO: Add your implementation code here
  
    return IPropertyPageImpl<CAddIn>::Activate(hWndParent,prc,bModal);
}*/

STDMETHODIMP CAddIn::Deactivate()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
		
		IPropertyPageImpl<CAddIn>::Deactivate();
	
    // Don't forget to detach controls!
	m_boxEnabledCheckType.Detach();
	m_boxOptimizate.Detach();
	m_boxEnableDebugging.Detach();  
	m_boxEnabledColor.Detach();
	m_boxLocalColor.Detach();
	m_boxShowKL.Detach();
	
	return S_OK;
}

/*STDMETHODIMP CAddIn::GetPageInfo(PROPPAGEINFO *pPageInfo)
{
AFX_MANAGE_STATE(AfxGetStaticModuleState())

  // TODO: Add your implementation code here
  
	return S_OK;
	}
	
	  STDMETHODIMP CAddIn::SetObjects(ULONG cObjects,IUnknown **ppUnk)
	  {
	  AFX_MANAGE_STATE(AfxGetStaticModuleState())
	  
		// TODO: Add your implementation code here
		
		  return IPropertyPageImpl<CAddIn>::SetObjects(cObjects,ppUnk);
		  }
		  
			/*STDMETHODIMP CAddIn::Show(UINT nCmdShow)
			{
			AFX_MANAGE_STATE(AfxGetStaticModuleState())
			
			  // TODO: Add your implementation code here
			  
				return S_OK;
				}
				
				  STDMETHODIMP CAddIn::Move(LPCRECT prc)
				  {
				  AFX_MANAGE_STATE(AfxGetStaticModuleState())
				  
					// TODO: Add your implementation code here
					
					  return S_OK;
					  }
					  
						STDMETHODIMP CAddIn::IsPageDirty()
						{
						AFX_MANAGE_STATE(AfxGetStaticModuleState())
						
						  // TODO: Add your implementation code here
						  
							return S_OK;
}*/

STDMETHODIMP CAddIn::Apply()
{	
	BOOL boolShowLast = m_bShowKL;
	{
		AFX_MANAGE_STATE(AfxGetStaticModuleState())
			BOOL boolEnabled;    
		IPropertyLink *pLink = NULL;    
		m_ppUnk[0]->QueryInterface(IID_IPropertyLink,(LPVOID *)&pLink);
		if (pLink != NULL)
		{
			boolEnabled = m_boxEnabledCheckType.GetCheck()?TRUE:FALSE;
			pLink->put_Enabled((unsigned char *)&boolEnabled, IDC_CHECK_TYPE);
			boolEnabled = m_boxOptimizate.GetCheck()?TRUE:FALSE;
			pLink->put_Enabled((unsigned char *)&boolEnabled, IDC_OPTIMIZATE);
			
			boolEnabled = m_boxEnableDebugging.GetCheck()?TRUE:FALSE;
			pLink->put_Enabled((unsigned char *)&boolEnabled, IDC_ENABLE_DEBUGGING);
			
			boolEnabled = m_boxEnabledColor.GetCheck()?TRUE:FALSE;
			pLink->put_Enabled((unsigned char *)&boolEnabled, IDC_ENCOLOR);
			
			boolEnabled = m_boxLocalColor.GetCheck()?TRUE:FALSE;
			pLink->put_Enabled((unsigned char *)&boolEnabled, IDC_LOCALCOLOR);
			
			boolEnabled = m_boxShowKL.GetCheck()?TRUE:FALSE;
			pLink->put_Enabled((unsigned char *)&boolEnabled, IDC_SHOWKL);
			
			pLink->Release();
		}
		SetDirty(FALSE);
	}
	if(m_bEnabledColor)
	{
		CBrowseWrapper::SetWrap();
	}
	else
	{
		m_bLocalColor = FALSE;
		CBrowseWrapper::OffWrap();
	};
	SECStatusBar* pStatus = (SECStatusBar*)AfxGetApp()->m_pMainWnd->GetDescendantWindow(AFX_IDW_STATUS_BAR);
	
	if(pStatus)
	{
		int count = pStatus->GetCount();
		UINT* nIDs;
		UINT* nStyles;
		int* cxWidths;
		nIDs = (UINT*)malloc(count*sizeof(UINT));
		nStyles = (UINT*)malloc(count*sizeof(UINT));
		cxWidths = (int*)malloc(count*sizeof(int));
		for(int i = 0; i<count; i++)
			pStatus->GetPaneInfo(i,nIDs[i],nStyles[i],cxWidths[i]);
		if((m_bShowKL == TRUE) && (boolShowLast == FALSE))
		{
			pStatus->AllocElements(count+2,100);
			pStatus->SetPaneInfo(count+1,NULL,SBPS_NORMAL, 43);
			pStatus->SetPaneInfo(count,NULL,SBPS_NORMAL, 20);
			char KLName[KL_NAMELENGTH]; 
			if(GetLocaleInfo((LCID)((WORD)GetKeyboardLayout(AfxGetApp()->m_nThreadID)),LOCALE_SABBREVLANGNAME,KLName,KL_NAMELENGTH))
				pStatus->SetPaneText(count,KLName,KL_NAMELENGTH);
			StatusTimer = pStatus->SetTimer(500,100,(TIMERPROC)TimerProc);
		}
		else if((m_bShowKL == FALSE) & (boolShowLast == TRUE))
		{
			count -= 2;
			pStatus->AllocElements(count,100);
			if(StatusTimer)
			{
				pStatus->KillTimer(StatusTimer);
				StatusTimer = 0;
			}
		}
		for(i = 0; i<count; i++)
			pStatus->SetPaneInfo(i,nIDs[i],nStyles[i],cxWidths[i]);
		free(nIDs);
		free(nStyles);
		free(cxWidths);
	}
	return S_OK;
}

/*STDMETHODIMP CAddIn::Help(LPCOLESTR pszHelpDir)
{
AFX_MANAGE_STATE(AfxGetStaticModuleState())

  // TODO: Add your implementation code here
  
	return S_OK;
	}
	
	  STDMETHODIMP CAddIn::TranslateAccelerator(LPMSG pMsg)
	  {
	  AFX_MANAGE_STATE(AfxGetStaticModuleState())
	  
		// TODO: Add your implementation code here
		
		  return S_OK;
}*/


LRESULT CAddIn::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
		IPropertyLink *pLink = NULL;
	m_ppUnk[0]->QueryInterface(IID_IPropertyLink,(LPVOID *)&pLink);
	m_boxEnabledCheckType.Attach(GetDlgItem(IDC_CHECK_TYPE));
	m_boxOptimizate.Attach(GetDlgItem(IDC_OPTIMIZATE));
	m_boxEnableDebugging.Attach(GetDlgItem(IDC_ENABLE_DEBUGGING));
	
	if (pLink != NULL)
	{
		pLink->get_Enabled((unsigned char *)&m_EnabledCheckType, IDC_CHECK_TYPE);        
		pLink->get_Enabled((unsigned char *)&m_EnableOptimizate, IDC_OPTIMIZATE);                
		pLink->get_Enabled((unsigned char *)&m_EnableDebugging, IDC_ENABLE_DEBUGGING);
		
		pLink->get_Enabled((unsigned char *)&m_bEnabledColor, IDC_ENCOLOR);        
		pLink->get_Enabled((unsigned char *)&m_bLocalColor, IDC_LOCALCOLOR);                
		pLink->get_Enabled((unsigned char *)&m_bShowKL, IDC_SHOWKL);
		
		pLink->Release();
		
	}
	
	
	m_boxEnabledCheckType.SetCheck(m_EnabledCheckType?1:0);    
	m_boxOptimizate.SetCheck(m_EnableOptimizate?1:0);
	m_boxEnableDebugging.SetCheck(m_EnableDebugging?1:0);
	
	m_boxEnabledCheckType.EnableWindow(m_AccessCheckType);
	m_boxOptimizate.EnableWindow(m_AccessOptimizate);
	m_boxEnableDebugging.EnableWindow(m_AccessEnableDebugging);
	
	m_boxEnabledColor.Attach(GetDlgItem(IDC_ENCOLOR));
	m_boxEnabledColor.SetCheck(m_bEnabledColor?1:0);
	
	m_boxLocalColor.Attach(GetDlgItem(IDC_LOCALCOLOR));
	m_boxLocalColor.SetCheck(m_bLocalColor?1:0);
	
	m_boxShowKL.Attach(GetDlgItem(IDC_SHOWKL));
	m_boxShowKL.SetCheck(m_bShowKL?1:0);
	
	
	CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy();
	CString text;
	if (pHierarchy)
		text.Format("  : %d\r\n  : %d\r\n  :\r\n%s\r\n :\r\n%s\r\n  :\r\n%s\r\n    :\r\n%s",pHierarchy->GetCountClasses(), pHierarchy->GetCountMethods(), pHierarchy->GetDefSymbolOfPreproc(),pHierarchy->GetLoadIncludeFiles(),pHierarchy->GetAllClassesNames(), pHierarchy->GetAllAliasAndPath());
	
	SetDlgItemText(IDC_EDIT1,text);
	
	SetDirty(FALSE);
	m_pPageSite->OnStatusChange(0);
	bHandled = FALSE;
	
	GetDlgItemText(IDC_ABOUT_STATIC, text.GetBufferSetLength(250), 250);
    text.ReleaseBuffer();
    CString sVersion = GetVersionField("FileVersion");
    sVersion.Replace(" ", "");
    sVersion.Replace(',', '.');
    CString sPrivateBuild = GetVersionField("PrivateBuild");
    if (!sPrivateBuild.IsEmpty())
    {
        sVersion += ' ';
        sVersion += sPrivateBuild;
    }
    CString sSpecialBuild = GetVersionField("SpecialBuild");
    if (!sSpecialBuild.IsEmpty())
    {
        sVersion += ' ';
        sVersion += sSpecialBuild;
    }
    text.Replace("_VersionInfo_", sVersion);
    SetDlgItemText(IDC_ABOUT_STATIC, text);

	return 0; 
}

LRESULT CAddIn::OnCommand(WORD wNotifyCode, WORD nID, HWND hWndCtl, BOOL& bHandled)
{
	SetDirty(TRUE);
	
	/*switch(nID)
	{
    case IDC_OPTIMIZATE:
	{        
	EnableWindow(IDC_ENABLE_DEBUGGING,m_EnableDebugging);
	}
	break;
	default:
	break;
}*/
	bHandled = FALSE;
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// IPropertyLink

STDMETHODIMP CAddIn::get_Enabled(unsigned char* pData, int Id)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
		switch(Id)
	{
    case IDC_CHECK_TYPE:
		{
			BOOL* boolEnabled = (BOOL*)pData;
			*boolEnabled = m_EnabledCheckType;        
		}    
		break;
    case IDC_OPTIMIZATE:
		{
			BOOL* boolEnabled = (BOOL*)pData;
			*boolEnabled = m_EnableOptimizate;        
		}
		break;
    case IDC_ENABLE_DEBUGGING:
		{
			BOOL* boolEnabled = (BOOL*)pData;
			*boolEnabled = m_EnableDebugging;        
		}
		break;      
    case IDC_ENCOLOR:
		{
			BOOL* boolEnabled = (BOOL*)pData;
			*boolEnabled = m_bEnabledColor;        
		}
		break;      
    case IDC_LOCALCOLOR:
		{
			BOOL* boolEnabled = (BOOL*)pData;
			*boolEnabled = m_bLocalColor;        
		}
		break;      
    case IDC_SHOWKL:
		{
			BOOL* boolEnabled = (BOOL*)pData;
			*boolEnabled = m_bShowKL;
		}
		break;      
		/*case IDC_EDIT_NAME_FILE_DEF:
		{
        CString* p_str = (CString*)pData;
        *p_str = m_StrFileNameOfDefClass;
        
		  }
		break;*/
    default:
		break;
	}
	return S_OK;
}

STDMETHODIMP CAddIn::put_Enabled(unsigned char* pData, int Id)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())
		switch(Id)
	{
    case IDC_CHECK_TYPE:
		{
			BOOL* boolEnabled = (BOOL*)pData;
			m_EnabledCheckType = *boolEnabled;
			break;
		}
    case IDC_OPTIMIZATE:
		{
			BOOL* boolEnabled = (BOOL*)pData;
			m_EnableOptimizate = *boolEnabled;
			break;
		}
    case IDC_ENABLE_DEBUGGING:
		{
			BOOL* boolEnabled = (BOOL*)pData;
			m_EnableDebugging = *boolEnabled;
			break;
		}
    case IDC_ENCOLOR:
		{
			BOOL* boolEnabled = (BOOL*)pData;
			m_bEnabledColor = *boolEnabled;
			break;      
		}      
    case IDC_LOCALCOLOR:
		{
			BOOL* boolEnabled = (BOOL*)pData;
			m_bLocalColor = *boolEnabled;
			break;      
		}      
    case IDC_SHOWKL:
		{
			BOOL* boolEnabled = (BOOL*)pData;
			m_bShowKL = *boolEnabled;
			break;      
		}      
		/*case IDC_EDIT_NAME_FILE_DEF:
		{
        CString* pStr = (CString*)pData;
        m_StrFileNameOfDefClass = pStr->operator LPCTSTR();
        
		  break;
	}*/
    default:
		break;
	}
	return S_OK;
}


STDMETHODIMP CAddIn::CallAsFunc(long,struct tagVARIANT *,struct tagSAFEARRAY * *)
{
	return S_OK;
}

STDMETHODIMP CAddIn::CallAsProc(long,struct tagSAFEARRAY * *)
{
	return S_OK;
}

STDMETHODIMP CAddIn::HasRetVal(long,int * ipRes)
{
	*ipRes	= 0;
	
	return S_OK;
}

STDMETHODIMP CAddIn::GetParamDefValue(long,long,struct tagVARIANT *)
{
	return S_OK;
}

STDMETHODIMP CAddIn::GetNParams(long,long * lpParams)
{
	*lpParams	= 0;
	return S_OK;
}

STDMETHODIMP CAddIn::GetMethodName(long,long,unsigned short * *)
{
	return S_OK;
}

STDMETHODIMP CAddIn::FindMethod(unsigned short *,long *)
{
	return S_OK;
}

STDMETHODIMP CAddIn::GetNMethods(long * lpRes)
{
	*lpRes = 0;
	return S_OK;
}

STDMETHODIMP CAddIn::IsPropWritable(long,int *)
{
	return S_OK;
}
STDMETHODIMP CAddIn::IsPropReadable(long,int *)
{
	return S_OK;
}
STDMETHODIMP CAddIn::SetPropVal(long,struct tagVARIANT *)
{
	return S_OK;
}
STDMETHODIMP CAddIn::GetPropVal(long,struct tagVARIANT *)
{
	return S_OK;
}
STDMETHODIMP CAddIn::GetPropName(long,long,unsigned short * *)
{
	return S_OK;
}
STDMETHODIMP CAddIn::FindProp(unsigned short *,long *)
{
	return S_OK;
}
STDMETHODIMP CAddIn::GetNProps(long * lpNum)
{
	*lpNum = 0;
	return S_OK;
}

//custom funcs
int IsDMSContext(const char *name)
{
	return cFeatureList.FindName(name) ? 1 : 0;
}

CString GetVersionField(LPCSTR szField)
{
    CString sRet;
    char BufFileName[256];
    GetModuleFileName(_Module.m_hInst, BufFileName, 256);
    
    DWORD z,size;
    size = GetFileVersionInfoSize(BufFileName, &z);
    if(size)
    {
        char* pVersion = new char[size];
        GetFileVersionInfo(BufFileName, 0, size, pVersion);
        DWORD* translate;
        UINT len;
        VerQueryValue(pVersion, "\\VarFileInfo\\Translation", (void**)&translate, &len);
        CString blockName;
        blockName.Format("\\StringFileInfo\\%04x%04x\\", LOWORD(translate[0]), HIWORD(translate[0]));
        LPCTSTR valuebuf;
        CString fdName = blockName + szField;
        VerQueryValue(pVersion, (char*)(LPCTSTR)fdName, (void**)&valuebuf, &len);
        sRet = valuebuf;
        delete pVersion;
    }
    return sRet;
}
