// BLModuleWrapper.cpp: implementation of the CBLModuleWrapper class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "addin.h"
#include "BLModuleWrapper.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBLModuleWrapper::CBLModuleWrapper(class CBLModule7 const & Module):CBLModule7(Module)
{
  //CTraceInterface::SendCommandToTracer();
  //OnStartExecution();
  //CTraceInterface::GetBreakPoints(this);
}

CBLModuleWrapper::CBLModuleWrapper(class CBLContext * pContext, char const *pStrconst, const char* pStrNameFile):CBLModule7(pContext,pStrconst)
{
  if (pStrNameFile)
    m_strFileName = pStrNameFile;
}


CBLModuleWrapper::~CBLModuleWrapper()
{
  //OnStopExecution();
}

int CBLModuleWrapper::OnSyntaxError(void)	
{  
  
  int ret = CBLModule::OnSyntaxError();
  if (!m_strFileName.IsEmpty())    
    pBkEndUI->DoMessageLine(m_strFileName, mmRedErr);	
  
  return ret;
}

int CBLModuleWrapper::OnRuntimeError(void)	
{  
  CComponentClass::strTextExeption.Empty();
#ifdef _DEBUG 
  CString strRuntimeErrSourceLine("", 1000);
  CString strGetRuntimeErrDescr("", 500);
#else
  CString strRuntimeErrSourceLine;
  CString strGetRuntimeErrDescr;
#endif
  
  GetRuntimeErrSourceLine(strRuntimeErrSourceLine);
  strRuntimeErrSourceLine.TrimLeft();    
  
  GetRuntimeErrDescr(GetRuntimeErrCode(),strGetRuntimeErrDescr);
 
  CSetOfHierarchy* pHierarchy = CSetOfHierarchy::GetHierarchy(); 
  
  //pBkEndUI->DoMessageLine("int CBLModuleWrapper::OnRuntimeError(void)", mmInformation);	  
 
  CComponentClass* pContInter = pHierarchy->GetComponentClassCurExModule(this);
  
  if (pContInter)
  {
    CString strError;    

    CString strNameOfComp = pContInter->GetTypeString();        
    strGetRuntimeErrDescr += "\r\n\r\n===========================================================================";
    strError += strNameOfComp;
    strError += "::";
    strError += CExecuteModule::GetExecuteMethInfo(this);
    
    strError += "\r\n";
    strError += strRuntimeErrSourceLine;  

    strError += "\r\n{";     
    CString strNameOfFile = pHierarchy->GetNameOfFile(strNameOfComp);
    CSetOfHierarchy::MakeFullFileName(&strNameOfFile);
    //strNameOfFile.MakeUpper();
    strError += strNameOfFile;
    char buffer[20];
    _itoa( GetRuntimeErrLineNum(), buffer, 10 );
    strError += "(";
    strError += buffer;
    strError += ")";
    strError += " }";     
    strGetRuntimeErrDescr += "\r\n";
    strGetRuntimeErrDescr += strError;    
    strGetRuntimeErrDescr += "\r\n";
    strGetRuntimeErrDescr += "===========================================================================";
    //pBkEndUI->DoMessageLine(strError, mmRedErr);	
  }
  

  CComponentClass::isExeptionStatus = true;
  CComponentClass::strTextExeption  = strGetRuntimeErrDescr;
  //CBLModule7::OnRuntimeError();

	return GetRuntimeErrLineNum();
}

int CBLModuleWrapper::OnStartExecution(void)
{
	//return CBLModule7::OnStartExecution();
  return 1;
}

int CBLModuleWrapper::OnNextLine(void)	
{
  //pBkEndUI->DoMessageLine("CBLModuleWrapper::OnNextLine", mmInformation);	  
	//return CBLModule7::OnNextLine();
  return 1;
}

void CBLModuleWrapper::OnEnterProc(int n)
{
  //CArray<CBLModule*,CBLModule*> *rModArr = (CArray<CBLModule*,CBLModule*>*)0x22132C98;        
  //int nPosArr = rModArr->Add(this);
  
  //CBLModule7::OnEnterProc(n);  
}

void CBLModuleWrapper::OnExitProc(int n)
{
  //CBLModule7::OnExitProc(n);
  //rModArr->RemoveAt(nPosArr);
}

void CBLModuleWrapper::OnStopExecution(void)
{
  //CBLModule7::OnStopExecution();
}
enum EventType
{
  EventType_one,
  EventType_two
};

void CBLModuleWrapper::OnErrorMessage(char const *pStr)
{    
  CString strSyntaxErrDescr("",1000);
  CBLModule::GetSyntaxErrDescr(GetSyntaxErrCode(),strSyntaxErrDescr);
  
  char buffer[20];
  _itoa(GetSyntaxErrLineNum(), buffer, 10 );
  
  CString strSyntaxErrMarkedLine = "(";
  strSyntaxErrMarkedLine += buffer;
  strSyntaxErrMarkedLine += ")";
  strSyntaxErrMarkedLine += GetSyntaxErrMarkedLine();
  strSyntaxErrMarkedLine += "\t";
  strSyntaxErrMarkedLine += strSyntaxErrDescr;
  
  pBkEndUI->DoMessageLine(strSyntaxErrMarkedLine, mmRedErr);	    
  //CBLModule7::OnErrorMessage(pStr);
}

void CBLModuleWrapper::OnSetSpeller(class CValue const & val)
{
  CBLModule7::OnSetSpeller(val);
}

int CBLModuleWrapper::OnDoMessageBox(char const *pStr,unsigned int n1)
{
	return CBLModule7::OnDoMessageBox(pStr, n1);
}

void CBLModuleWrapper::OnGetErrorDescription(class CString &str)	
{  
  CBLModule7::OnGetErrorDescription(str);
}

CBLContext* CBLModuleWrapper::GetContextFromModule(CBLModule *pMod)
{
  CBLContext *pCont  = NULL;        
  if(!pMod->IsLoaded())
  {
	pCont = pMod->pIntInfo->pGeneralContext;
//    char *buff = (char*)pMod->buff;
//    int  *pAdress = reinterpret_cast<int*> (buff);
//    pAdress = reinterpret_cast<int*> ((*pAdress));      
//    pCont = reinterpret_cast<CBLContext*>(*pAdress); 
  }
  return pCont;
}
