//////////////////////////////////////////////////////////////////////
// V7CursorGridCtrl.h: interfaces for CursorGrid control for V7
// (the Table field) classes.
// Written by Dmitriy Oshchepkov aka DmitrO, mailto: dmitro@russian.ru
// Version: 1.0
//////////////////////////////////////////////////////////////////////

#pragma once

#include "CursorGridCtrl.h"
#include "../mycontextbase.h"
#include "../BLCollection.h"
#include "V7DataProvider.h"
#include "../Font.h"

class CV7GridColumns;
class CV7CursorGridCtrl;
class CV7RowAppearance;
class CCellAppearance;
class CGridCells;
class CV7RowData;
class CV7TableField;

#define GET_V7_COLOR(crColor) (crColor == CLR_DEFAULT ? -1 : crColor)
#define SET_V7_COLOR(vValue) (vValue == -1 ? CLR_DEFAULT : vValue.GetNumeric())

class CV7GridColumn : public CMyContextBase, public CGridColumn
{
    friend class CV7GridColumns;
    friend class CGridCells;
    DECLARE_DYNCREATE(CV7GridColumn);
public:
    CV7GridColumn();
    virtual ~CV7GridColumn();

    BOOL MethSetRowsPictures(CValue** ppValue);
    BOOL DefSetRowsPictures(int nParam, CValue* pValue)const;

    BOOL GetPropName(CValue& Value)const {Value = GetName(); return TRUE;};
    BOOL SetPropName(CValue const& Value) {SetName(Value.GetString()); return TRUE;};

    BOOL GetPropCaption(CValue& Value)const {Value = GetCaption(); return TRUE;};
    BOOL SetPropCaption(CValue const& Value) {SetCaption(Value.GetString()); return TRUE;};

    BOOL GetPropVisible(CValue& Value)const {Value = GetVisible(); return TRUE;};
    BOOL SetPropVisible(CValue const& Value) {SetVisible(Value.GetNumeric()); return TRUE;};

    BOOL GetPropWidth(CValue& Value)const {Value = GetWidth(); return TRUE;};
    BOOL SetPropWidth(CValue const& Value) {SetWidth(Value.GetNumeric()); return TRUE;};

    BOOL GetPropHorizontalAlignment(CValue& Value)const {Value = GetHTextAlignment(); return TRUE;};
    BOOL SetPropHorizontalAlignment(CValue const& Value);

    BOOL GetPropTextColor(CValue& Value)const {Value = GET_V7_COLOR(GetTextColor()); return TRUE;};
    BOOL SetPropTextColor(CValue const& Value) {SetTextColor(SET_V7_COLOR(Value)); return TRUE;};

    BOOL GetPropBackColor(CValue& Value)const {Value = GET_V7_COLOR(GetBackColor()); return TRUE;};
    BOOL SetPropBackColor(CValue const& Value) {SetBackColor(SET_V7_COLOR(Value)); return TRUE;};

    BOOL GetPropFont(CValue& Value)const {Value.AssignContext(m_pFont); return TRUE;};
    BOOL SetPropFont(CValue const& Value);

    BOOL GetPropHeaderFont(CValue& Value)const {Value.AssignContext(m_pHeaderFont); return TRUE;};
    BOOL SetPropHeaderFont(CValue const& Value);

    BOOL GetPropFixedWidth(CValue& Value)const {Value = !GetFixedWidth(); return TRUE;};
    BOOL SetPropFixedWidth(CValue const& Value) {SetFixedWidth(Value.GetNumeric() == 0); return TRUE;};

    BOOL GetPropHeaderTextColor(CValue& Value)const {Value = GET_V7_COLOR(GetHeaderTextColor()); return TRUE;};
    BOOL SetPropHeaderTextColor(CValue const& Value) {SetHeaderTextColor(SET_V7_COLOR(Value)); return TRUE;};

    BOOL GetPropHeaderBackColor(CValue& Value)const {Value = GET_V7_COLOR(GetHeaderBackColor()); return TRUE;};
    BOOL SetPropHeaderBackColor(CValue const& Value) {SetHeaderBackColor(SET_V7_COLOR(Value)); return TRUE;};

    BOOL GetPropDataField(CValue& Value)const {Value = GetDataField(); return TRUE;};
    BOOL SetPropDataField(CValue const& Value) {SetDataField(Value.GetString()); return TRUE;};

    BOOL GetPropOrderMarker(CValue& Value)const {Value = GetOrderMarker(); return TRUE;};
    BOOL SetPropOrderMarker(CValue const& Value);

    BOOL GetPropChangeVisible(CValue& Value)const {Value = GetChangeVisible(); return TRUE;};
    BOOL SetPropChangeVisible(CValue const& Value) {SetChangeVisible(Value.GetNumeric()); return TRUE;};

protected:
    virtual void Release() {DecrRef();};

	DECLARE_MY_CONTEXT()
private:
    CBLPtr<CBLFont> m_pFont;
    CBLPtr<CBLFont> m_pHeaderFont;
    CBLPtr<CCellAppearance> m_pCellAppearance;
    CImageList m_RowsImages;
};

class CV7GridColumns : public CBLCollection<CGridColumns, CV7GridColumn, RUNTIME_CLASS(CV7GridColumn),
 BLC_MODIFED | BLC_INSERT | BLC_MOVE>
{
    DECLARE_DYNAMIC(CV7GridColumns);
public:
    CV7GridColumns();
    virtual ~CV7GridColumns();
protected:
    virtual void Release();
    virtual CGridColumn* NewColumn();
public:
    virtual char const* 	GetTypeString(void)const {return "";};
};

class CV7GridItem : public CGridItem
{
    friend class CCellAppearance;
public:
    CV7GridItem(CGridColumn* pGridColumn);
    virtual ~CV7GridItem();
protected:
    virtual BOOL DrawImage(CDC* pDC, CRect& rect);
private:
    CBLPtr<CBLFont> m_pFont;
    CBLPtr<CPictureContext> m_pPicture;
};

class CV7GridRow : public CGridRow
{
    friend class CV7RowAppearance;
public:
    CV7GridRow(CGridColumns* pColumns, CDataRow* pDataRow);
    virtual ~CV7GridRow();
protected:
    virtual CGridItem* NewItem(CGridColumn* pGridColumn);
    virtual void OnFillItems();
private:
    CBLPtr<CBLFont> m_pFont;
};

class CV7CursorGridCtrl : public CCursorGridCtrl
{
    friend class CV7GridColumns;
    friend class CV7GridRow;
    DECLARE_DYNCREATE(CV7CursorGridCtrl);
public:
    CV7CursorGridCtrl();
    virtual ~CV7CursorGridCtrl();

    BOOL Init(CV7TableField* pCtrlObject, CControlID* pControlID, CBLModule* pBLModule);

    CBLContext* GetBLDataProvider() const;
    void SetBLDataProvider(CBLContext* pProvider);

    CBLFont* GetBLFont() const;
    void SetBLFont(CBLFont* pFont);

    CV7RowData* GetRowData() const;

protected:
    virtual CGridColumns* NewColumns();
    virtual CGridRow* NewGridRow(CGridColumns* pColumns, CDataRow* pDataRow);

    //Events
    virtual void OnChangeCurrentData(CDataRow* pDataRow);
    virtual void OnSelection();
    virtual void OnActivateRow();
    virtual void OnActivateColumn();
    virtual void OnActivateCell();
    virtual void OnHeaderSelection(CGridColumn* pColumn);
    virtual void OnShowContextMenu();
    virtual void OnClickCheckBox();
    
private:
    CBLPtr<CV7RowAppearance> m_pV7RowAppearance;
    CBLPtr<CV7RowData> m_pCurrentData;

    void OnFillItems(CV7GridRow* pV7GridRow);
    BOOL SetEvent(LPCSTR szEventName, int nParamCount, int& nEventProcID);

    CControlID* m_pControlID;
    CBLModule* m_pBLModule;
    
    CBLPtr<CV7TableField> m_pCtrlObject;
    CBLPtr<CBLContext> m_pProvider;
    CBLPtr<CBLFont> m_pFont;

    //entryes of module events
    int m_nOnRowOutProc;
    int m_nOnSelection;
    int m_nOnActivateRow;
    int m_nOnActivateColumn;
    int m_nOnActivateCell;
    int m_nOnHeaderSelection;
    int m_nOnContextMenu;
    int m_nOnClickCheckBox;
};

class CV7TableField : public CMyContextBase
{
    friend class CV7CursorGridCtrl;
    DECLARE_DYNCREATE(CV7TableField);
public:
    CV7TableField();
    virtual ~CV7TableField();
    BOOL CreateControl(CWnd* pParent, CGetDoc7* pDoc, CGetField* pGetField);

    BOOL MethRefreshRows(CValue** ppValues);

    BOOL GetPropColumns(CValue& Value)const;

    BOOL GetPropProvider(CValue& Value)const;
    BOOL SetPropProvider(CValue const& Value);

    BOOL GetPropVScroller(CValue& Value)const;
    BOOL SetPropVScroller(CValue const& Value);

    BOOL GetPropStartView(CValue& Value)const;
    BOOL SetPropStartView(CValue const& Value);

    BOOL GetPropRowSelectMode(CValue& Value)const;
    BOOL SetPropRowSelectMode(CValue const& Value);

    BOOL GetPropVerticalLines(CValue& Value)const;
    BOOL SetPropVerticalLines(CValue const& Value);

    BOOL GetPropHorizontalLines(CValue& Value)const;
    BOOL SetPropHorizontalLines(CValue const& Value);

    BOOL GetPropHeadersStyle(CValue& Value)const;
    BOOL SetPropHeadersStyle(CValue const& Value);

    BOOL GetPropCurrentColumn(CValue& Value)const;
    BOOL SetPropCurrentColumn(CValue const& Value);

    BOOL GetPropCurrentData(CValue& Value)const;

    BOOL GetPropFont(CValue& Value)const;
    BOOL SetPropFont(CValue const& Value);

    BOOL GetPropRefreshTimeout(CValue& Value)const;
    BOOL SetPropRefreshTimeout(CValue const& Value);

    BOOL GetPropQuickSearchTimeout(CValue& Value)const;
    BOOL SetPropQuickSearchTimeout(CValue const& Value);

    BOOL GetPropChangePositionOfColumns(CValue& Value)const;
    BOOL SetPropChangePositionOfColumns(CValue const& Value);

    BOOL GetPropLinesColor(CValue& Value)const;
    BOOL SetPropLinesColor(CValue const& Value);

    BOOL GetPropSelectionTextColor(CValue& Value)const;
    BOOL SetPropSelectionTextColor(CValue const& Value);

    BOOL GetPropSelectionBackColor(CValue& Value)const;
    BOOL SetPropSelectionBackColor(CValue const& Value);

    BOOL GetPropAlternationRowBackColor(CValue& Value)const;
    BOOL SetPropAlternationRowBackColor(CValue const& Value);

    BOOL GetPropUseAlternationRowColor(CValue& Value)const;
    BOOL SetPropUseAlternationRowColor(CValue const& Value);

    DECLARE_MY_CONTEXT()
private:
    CV7CursorGridCtrl* m_pGrid;
};

class CV7RowData : public CMyContextBase
{
    friend class CV7RowAppearance;
    friend class CV7CursorGridCtrl;
    DECLARE_DYNCREATE(CV7RowData);
public:
    CV7RowData();
    virtual ~CV7RowData();

    BOOL MethCount(CValue& rValue, CValue** ppValue);
    BOOL MethGet(CValue& rValue, CValue** ppValue);
public:
	virtual int				GetNProps(void)const;
	virtual int				FindProp(char const* szName)const;
	virtual char const* 	GetPropName(int nPropIndex, int nAlias)const;
	virtual int				GetPropVal(int nPropIndex, class CValue& Value)const;
	virtual int				SetPropVal(int nPropIndex, class CValue const& Value);
	virtual int				IsPropReadable(int nPropIndex)const;
	virtual int				IsPropWritable(int nPropIndex)const;
    
    DECLARE_MY_CONTEXT()
private:
    CDataRow* m_pDataRow;
    CV7DataRow* m_pV7DataRow;
};

class CCellAppearance : public CMyContextBase
{
    friend class CV7RowAppearance;
    friend class CV7GridColumns;
    friend class CGridCells;
    DECLARE_DYNCREATE(CCellAppearance);
public:
    CCellAppearance();
    virtual ~CCellAppearance();

    LPCSTR GetName() const;

    BOOL GetPropName(CValue& Value)const;

    BOOL MethSetText(CValue** ppValue);
    BOOL MethSetImage(CValue** ppValue);
    BOOL MethSetCheckValue(CValue** ppValue);

    BOOL GetPropShowText(CValue& Value)const;
    BOOL SetPropShowText(CValue const& Value);

    BOOL GetPropShowImage(CValue& Value)const;
    BOOL SetPropShowImage(CValue const& Value);

    BOOL GetPropShowCheckBox(CValue& Value)const;
    BOOL SetPropShowCheckBox(CValue const& Value);

    BOOL GetPropHorizontalAlignment(CValue& Value)const;
    BOOL SetPropHorizontalAlignment(CValue const& Value);

    BOOL GetPropImageIndex(CValue& Value)const;
    BOOL SetPropImageIndex(CValue const& Value);

    BOOL GetPropCheckValue(CValue& Value)const;
    BOOL SetPropCheckValue(CValue const& Value);

    BOOL GetPropText(CValue& Value)const;
    BOOL SetPropText(CValue const& Value);

    BOOL GetPropTextColor(CValue& Value)const;
    BOOL SetPropTextColor(CValue const& Value);

    BOOL GetPropBackColor(CValue& Value)const;
    BOOL SetPropBackColor(CValue const& Value);

    BOOL GetPropFont(CValue& Value)const;
    BOOL SetPropFont(CValue const& Value);

    DECLARE_MY_CONTEXT()
private:
    CV7GridItem* m_pGridItem;
};

class CGridCells
{
    friend class CV7RowAppearance;
    friend class CV7CursorGridCtrl;
public:
    CGridCells();
    ~CGridCells();
public:
    int GetSize() const;
    CCellAppearance* Add(LPCSTR szName) {return NULL;};
    CCellAppearance* Insert(int nIndex, LPCSTR szName) {return NULL;};
    CCellAppearance* GetAt(int nIndex) const;
    CCellAppearance* GetAt(LPCSTR szName) const;
    int IndexOf(LPCSTR szName) const;
    int IndexOf(CCellAppearance* pItemType) const;
    BOOL Remove(int nIndex) {return FALSE;};
    BOOL Move(int nIndex, int nOffset) {return FALSE;};
    void RemoveAll() {};

private:
    CGridColumns* m_pColumns;
    void Attach(CV7GridRow* pV7GridRow);
    void Detach();
};

class CV7GridCells : public CBLCollection<CGridCells, CCellAppearance, RUNTIME_CLASS(CCellAppearance), BLC_READONLY>
{
    DECLARE_DYNAMIC(CV7GridCells);
public:
    CV7GridCells() {};
    virtual ~CV7GridCells() {};
};

class CV7RowAppearance : public CMyContextBase
{
    friend class CV7CursorGridCtrl;
    DECLARE_DYNCREATE(CV7RowAppearance);
public:
    CV7RowAppearance();
    virtual ~CV7RowAppearance();
    void Attach(CV7GridRow* pV7GridRow);
    void Detach();

    BOOL GetPropRowData(CValue& Value)const;

    BOOL GetPropCells(CValue& Value)const;

    BOOL GetPropTextColor(CValue& Value)const;
    BOOL SetPropTextColor(CValue const& Value);

    BOOL GetPropBackColor(CValue& Value)const;
    BOOL SetPropBackColor(CValue const& Value);

    BOOL GetPropFont(CValue& Value)const;
    BOOL SetPropFont(CValue const& Value);


    DECLARE_MY_CONTEXT()
private:
    CV7DataProvider* m_pV7DataProvider;
    CV7GridRow* m_pV7GridRow;

    CBLPtr<CV7RowData> m_pV7RowData;
    CBLPtr<CV7GridCells> m_pV7GridCells;
};
