
#include "StdAfx.h"
#include "VTProvider.h"

//////////////////////////////////////////////////////////////////////////
// class CVTRow
//////////////////////////////////////////////////////////////////////////

CVTRow::CVTRow(CValueTable* pVT, UINT nRowIndex): m_pVT(pVT), m_nRowIndex(nRowIndex)
{
    m_vRowIndex = nRowIndex + 1;
}

CVTRow::~CVTRow()
{
}

//CDataRow
int CVTRow::GetFieldCount()
{
    return m_pVT->GetColumnCount() + 1;
}

int CVTRow::GetFieldIndexOf(LPCSTR szFieldName)
{
    if (!stricmp(szFieldName, ""))
        return 0;
    else
    {
        int nIndex = m_pVT->GetColumnIdx(szFieldName);
        if (nIndex != -1)
            nIndex++;
        return nIndex;
    }
}

LPCSTR CVTRow::GetFieldName(int nIndex)
{
    if (nIndex)
        return m_pVT->GetColumnCode(nIndex - 1);
    else
        return "";
}

DataType CVTRow::GetFieldType(int nIndex)
{
    return dtText;
}

void CVTRow::FormatField(int nIndex, CString& strValue)
{
    if (nIndex)
        FormatValue(m_pVT->GetValue(nIndex - 1, m_nRowIndex), strValue);
    else
        strValue = m_vRowIndex.Format();
}

UINT CVTRow::GetRowIndex()
{
    return m_nRowIndex;
}

//CV7DataRow
const CValue& CVTRow::GetValue(int nIndex) const
{
    if (nIndex)
        return m_pVT->GetValue(nIndex - 1, m_nRowIndex);
    else
        return m_vRowIndex;
}

//////////////////////////////////////////////////////////////////////////
// class CVTProvider
//////////////////////////////////////////////////////////////////////////

BEGIN_BL_METH_MAP(CVTProvider)
    BL_METH("SetValueTable", "", 1, MethSetValueTable, NULL, NULL)
    BL_METH("SetCurrentRow", "", 1, MethSetCurrentRow, NULL, NULL)
END_BL_METH_MAP()

BEGIN_BL_PROP_MAP(CVTProvider)
END_BL_PROP_MAP()

BEGIN_REG_NAMES(CVTProvider)
    "VTProvider", "",
END_REG_NAMES()

IMPLEMENT_MY_CONTEXT(CVTProvider, "", NULL, NULL, -1);

CVTProvider::CVTProvider()
{
    m_pVTContextData = NULL;
    m_nCurrentRow = ULONG_MAX;
}

CVTProvider::~CVTProvider()
{
}

BOOL CVTProvider::MethSetValueTable(CValue** ppValue)
{
    m_pBLVT = NULL;
    m_pVTContextData = NULL;

    if (ppValue[0]->GetTypeCode() == AGREGATE_TYPE_1C)
    {
        CBLContext* pBLContext = ppValue[0]->GetContext();
        if (pBLContext->GetInternalData()->GetRuntimeClass() == RUNTIME_CLASS(CValueTableContextData))
        {
            m_pBLVT = pBLContext;
            m_pVTContextData = static_cast<CValueTableContextData*>(pBLContext->GetInternalData());
        }
    }
    ResetData();
    return TRUE;
}

BOOL CVTProvider::MethSetCurrentRow(CValue** ppValue)
{
    if (ppValue[0]->GetTypeCode() == NUMBER_TYPE_1C)
    {
        int nRowIndex = ppValue[0]->GetNumeric();
        CValueTable* pVT = NULL;
        if (m_pVTContextData)
        {
            pVT = m_pVTContextData->GetValueTable();
            if (nRowIndex < 0 || nRowIndex >= pVT->GetRowCount())
            {
                CBLModule::RaiseExtRuntimeError("  .", 0);
                return FALSE;
            }
        }
        m_nCurrentRow = nRowIndex;

        HWND hWnd = GetControl();
        if (hWnd && pVT)
        {
            CVTRow Row(pVT, m_nCurrentRow);
            SetCurrentRow(&Row);
        }
    }
    else
        m_nCurrentRow = ULONG_MAX;

    return TRUE;
}

//CDataProvider
void CVTProvider::QueryRows(CDataRow* pRowFrom, int nRowsCount, int nPageSizeHint)
{
    m_nQueryRowsCount = nRowsCount;
    if (pRowFrom)
        m_nQueryRowIndex = static_cast<CVTRow*>(pRowFrom)->m_nRowIndex;
    else
        m_nQueryRowIndex = ULONG_MAX;
}

CDataRow* CVTProvider::Fetch()
{
    if (m_nQueryRowsCount == 0 || !m_pVTContextData)
        return NULL;

    CValueTable* pVT = m_pVTContextData->GetValueTable();
    if (!pVT->GetRowCount())
        return NULL;

    if (m_nQueryRowsCount > 0)
    {
        if (m_nQueryRowIndex == ULONG_MAX)
            m_nQueryRowIndex = 0;
        else if (m_nQueryRowIndex < pVT->GetRowCount() - 1)
            m_nQueryRowIndex++;
        else
            return NULL;

        m_nQueryRowsCount--;
    }
    else
    {
        if (m_nQueryRowIndex == ULONG_MAX)
            m_nQueryRowIndex = pVT->GetRowCount() - 1;
        else if (m_nQueryRowIndex > 0)
            m_nQueryRowIndex--;
        else
            return NULL;

        m_nQueryRowsCount++;
    }

    return new CVTRow(pVT, m_nQueryRowIndex);
}

BOOL CVTProvider::RefreshRow(CDataRow* pRowFrom)
{
    return static_cast<CVTRow*>(pRowFrom)->m_nRowIndex < m_pVTContextData->GetValueTable()->GetRowCount();
}

BOOL CVTProvider::CompareRows(CDataRow* pRow1, CDataRow* pRow2) const
{
    return static_cast<CVTRow*>(pRow1)->m_nRowIndex == static_cast<CVTRow*>(pRow2)->m_nRowIndex;
}

BOOL CVTProvider::GetRowCount(UINT* pCount)
{
    if (pCount)
    {
        if (m_pVTContextData)
            *pCount = m_pVTContextData->GetValueTable()->GetRowCount();
        else
            *pCount = 0;
    }
    return TRUE;
}

void CVTProvider::OnAttach()
{
    if (m_nCurrentRow != ULONG_MAX && m_pVTContextData)
    {
        CValueTable* pVT = m_pVTContextData->GetValueTable();
        CVTRow Row(pVT, m_nCurrentRow);
        ResetData(&Row);
    }
    else
        ResetData();
}

//CV7DataProvider
CV7DataRow* CVTProvider::GetV7DataRow(CDataRow* pDataRow)  const
{
    return static_cast<CVTRow*>(pDataRow);
}
