//   aka spock
// #163860836
// e-mail: spock@km.ru
//
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <oledb.h>
#include "..\\ODBC\\MetaNameParser.h"
#include "..\\SQL\\MetaDataWork.h"

#define NUMROWS_CHUNK 50
#define BLOCK_SIZE 1024
#define ROUND_UP(Size, Amount) (((DWORD)(Size) +  ((Amount) - 1)) & ~((Amount) - 1))
#define COLUMN_ALIGNVAL 8

//_____________________________________________________________________________
//
struct COLEDBFldsInf
{
public:
	COLEDBFldsInf();

	ULONG m_Index;
	CString m_strName; 
	CType m_nType1C;
	DBTYPE m_wType;
	bool m_bIsType1C;
	bool m_bIsLong;
};

//_____________________________________________________________________________
//
class COLEDBCommand : public CBLContext
{
public:
	//  -  !
	//   ,    (m_bCreated) 
	//
	COLEDBCommand(CComPtr<ICommandText> spCommandText);
	virtual ~COLEDBCommand();

	virtual int	 CallAsFunc(int, class CValue&, class CValue**);
	virtual int	 CallAsProc(int, class CValue**);
	virtual int	 FindMethod(char const *) const;
	virtual char const * GetMethodName(int, int) const;
	virtual int	 GetNMethods(void) const;
	virtual int	 GetNParams(int) const;
	virtual int	 GetParamDefValue(int, int, class CValue*) const;
	virtual int	 HasRetVal(int) const;
	virtual char const * GetTypeString(void) const;

	virtual int	 FindProp(char const *) const;
	virtual char const * GetCode(void) const;
	virtual int	 GetDestroyUnRefd(void) const;
	virtual class CObjID GetID(void) const;
	virtual int	 GetNProps(void) const;
	virtual char const * GetPropName(int, int) const;
	virtual int	 GetPropVal(int, class CValue&) const;
	virtual long GetTypeID(void) const;
	virtual class CType GetValueType(void) const;
	virtual int	 IsExactValue(void) const;
	virtual int	 IsOleContext(void) const;
	virtual int	 IsPropReadable(int) const;
	virtual int	 IsPropWritable(int) const;
	virtual int	 IsSerializable(void);
	virtual int	 SaveToString(class CString&);
	virtual int	 SetPropVal(int, class CValue const &);

	static class CObjID ObjID;

private:
	void GetErrorDescription(CString& strError) const;
	HRESULT Binding(CComPtr<IRowset>& pIRowset, ULONG* pnCols, DBBINDING** ppDBBindings, COLEDBFldsInf** ppColumnsInfo1C, DBOBJECT** ppDBObject, ULONG* pcMaxRowSize) const;
	CType GetType1C(COLEDBFldsInf* fInfo) const;
	HRESULT ParseQuery(CString& strQuery);
	HRESULT Execute(CString& strSQL, long* nRowsAffected, IUnknown** pIRowset) const;
	HRESULT CreateAccessor(CComPtr<IAccessor>& pIAccessor, CComPtr<IRowset>& pIRowset, HACCESSOR* hAccessor, ULONG& cCols, DBBINDING* pDBBindings) const;

	static CParamDefs defFnNames;
	
	CMetaNameParser m_MetaNameParser;
	CComPtr<ICommandText> m_pICommandText;
	bool m_bCreated;
	bool m_IsDebugMode;
};
