//////////////////////////////////////////////////////////////////////
//         CVTExtended
//
// :   aka ADirks
// : e-mail: adirks@ngs.ru, ICQ: 13472890
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "VTExtended.h"
#include "../StringArrayEx.h"

/////////////////////////////////////////////////////////////
////  CVTIndexRecord  ///////////////////////////////////////
/////////////////////////////////////////////////////////////
int numeric_compare(int a, int b)
{
	if( a < b ) return -1;
	else if( a > b ) return 1;
	return 0;
}

int string_compare(CString const& left, CString const& right, TVTIndexDescrRecord const& IdxRec)
{
	if( IdxRec.TrimStrings )
	{
		CString lstr = (LPCSTR)left;
		lstr.TrimRight();
		lstr.TrimLeft();
		CString rstr = (LPCSTR)right;
		rstr.TrimRight();
		rstr.TrimLeft();
		if( IdxRec.NoCaseStringCompare )
			return lstr.CollateNoCase(rstr);
		else
			return strcmp(lstr, rstr);
	}
	else if( IdxRec.NoCaseStringCompare )
		return left.CollateNoCase(right);

	return strcmp(left, right);
}

int date_compare(CDate const& d1, CDate const& d2)
{
	int comp_res = numeric_compare(d1.GetYear(), d2.GetYear());
	if( comp_res ) return comp_res;
	comp_res = numeric_compare(d1.GetMonth(), d2.GetMonth());
	if( comp_res ) return comp_res;
	comp_res = numeric_compare(d1.GetMonthDay(), d2.GetMonthDay());
	return comp_res;
}

int time_compare(CEventTime const& t1, CEventTime const& t2)
{
	if( t1 < t2 ) return -1;
	else if( t1 > t2 ) return 1;
	return 0;
}

int inner_compare(CValue &left, CValue &right)
{
	CString l_str, r_str;
	left.SaveToString(l_str);
	right.SaveToString(r_str);
	return strcmp(l_str, r_str);
}

int CValue_compare(CValue &left, CValue &right, TVTIndexDescrRecord const& IdxRec)
{
	if( left.GetTypeCode() == right.GetTypeCode() )
	{
		switch( left.GetTypeCode() )
		{
		case 1:
			return left.GetNumeric().Compare(right.GetNumeric());
			break;
		case 2:
			return string_compare(left.GetString(), right.GetString(), IdxRec);
			break;
		case 3:
			{
			CDate &d1 = left.GetDate(), &d2 = right.GetDate();
			return date_compare(d1, d2);
			}
			break;
		case 11:
			{
			if( IdxRec.CompareType == CmpByInnerRepr )
				return inner_compare(left, right);
			int comp_res = string_compare(left.Format(), right.Format(), IdxRec);
			if( comp_res == 0 )
				comp_res = inner_compare(left, right);
			return comp_res;
			}
			break;
		case 12:
			if( IdxRec.CompareType == CmpByInnerRepr )
			{
				return inner_compare(left, right);
			}
			else
			{
				CDate d1(0,0,0), d2(0,0,0);
				CEventTime t1, t2;
				GetDateTimeFromValue(left, d1, t1);
				GetDateTimeFromValue(right, d2, t2);
				int comp_res = date_compare(d1, d2);
				if( comp_res == 0 ) comp_res = time_compare(t1, t2);
				return comp_res;
			}
			break;
		default:
			if( IdxRec.CompareType == CmpByInnerRepr )
				return inner_compare(left, right);
			else
				return string_compare(left.Format(), right.Format(), IdxRec);
		}
	}
	else
	{
		return numeric_compare(left.GetTypeCode(), right.GetTypeCode());
	}
}

int CVTIndexRecord::compare(CVTIndexRecord& RightRecord)
{
	int sz = IndexFields->size();
	int comp_res;
	for( int i = 0; i < sz; i++ )
	{
		TVTIndexDescrRecord &IdxRec = IndexFields->at(i);

		try{

		CValue &left = Row->GetValue(IdxRec.ColumnNumber);
		CValue &right = RightRecord.Row->GetValue(IdxRec.ColumnNumber);

		comp_res = CValue_compare(left, right, IdxRec);
		} catch(...) { RuntimeError("      . %x vs %x", Row, RightRecord.Row); }

		if( comp_res != 0 ) return comp_res * IdxRec.Direction;
	}

	return 0;
}


/////////////////////////////////////////////////////////////
////  CVTExtPosition  ///////////////////////////////////////
/////////////////////////////////////////////////////////////
CVTExtPosition& CVTExtPosition::operator= (CVTExtIndex& Index)
{
	CurrentRow = Index.CurrentRow;
	pCurrentRow = Index.pCurrentRow;
	CurrentNode = Index.CurrentNode;
	IndexInNode = Index.IndexInNode;
	SelStarted = Index.SelStarted;
	return *this;
}

CVTExtIndex& CVTExtIndex::operator= (CVTExtPosition& Pos)
{
	CurrentRow = Pos.CurrentRow;
	pCurrentRow = Pos.pCurrentRow;
	CurrentNode = Pos.CurrentNode;
	IndexInNode = Pos.IndexInNode;
	SelStarted = Pos.SelStarted;
	return *this;
}

/////////////////////////////////////////////////////////////
////  CVTExtIndex  //////////////////////////////////////////
/////////////////////////////////////////////////////////////
CVTExtIndex::CVTExtIndex(LPCSTR Name, CString const& IndexExpression, bool bUnique, CVTExtended* vt)
:KeyRow(vt->GetColumnsCount())
{
	SetName(Name);
	pVT = vt;
	pFilter = NULL;

	BuildIndexFields(IndexExpression, IndexFields, "");
	NoRepeat = bUnique;
	Reindex();
	SelStarted = false;
}

CVTExtIndex::CVTExtIndex(LPCSTR Name, CVTExtended* vt)
:KeyRow(vt->GetColumnsCount())
{
	SetName(Name);
	pVT = vt;
	pFilter = NULL;
	ResetPosition();
	SelStarted = false;
}

CVTExtIndex::~CVTExtIndex()
{
	if( pFilter != NULL ) delete pFilter;
}

void CVTExtIndex::ResetPosition()
{
	CurrentRow = -1;
	pCurrentRow = NULL;
	CurrentNode = Nil;
}

CVTExtIndex& CVTExtIndex::operator= (CVTExtIndex& SrcIndex)
{
	NoRepeat = SrcIndex.NoRepeat;
	IndexFields = SrcIndex.IndexFields;
	Reindex();
	if( SrcIndex.pFilter )
	{
		pFilter = new CVTExtFilter(KeyRow.Values.GetUpperBound()+1, &IndexFields);
		*pFilter = *(SrcIndex.pFilter);
	}
	return *this;
}

bool CVTExtIndex::BuildIndexFields(CString IndexExpr, TVTExtIndexFields& IndexFields, LPCSTR strInfo)
{
	IndexFields.clear();

	CStringArrayEx Fields;
	Fields.FillSeparateString(IndexExpr, ",");
	int nFields = Fields.GetSize();

	if( nFields == 0 )
	{
		return true; //  "" , ..     
		//RuntimeError("    %s", strInfo);
	}

	IndexFields.resize(nFields);

	for( int i = 0; i < nFields; i++ )
	{
		CString& ColName = Fields[i];
		int direction = 1;
		TCompareType CompareType = CmpByStringRepr;
		bool TrimStrings = false, NoCaseStringCompare = false;
		
		IndexFields[i].CompareType = ColName.Find('*') < 0 ? CmpByStringRepr : CmpByInnerRepr;
		IndexFields[i].Direction = ColName.Find('-') < 0 ? 1 : -1;
		IndexFields[i].TrimStrings = ColName.Find('#') >= 0;
		IndexFields[i].NoCaseStringCompare = ColName.Find('^') >= 0;
		
		ColName.Replace("-", "");
		ColName.Replace("*", "");
		ColName.Replace("#", "");
		ColName.Replace("^", "");

		int col_num = pVT->ColumnNumber(ColName, false);
		if( col_num < 0 )
			RuntimeError(" '%s'  !", ColName);

		IndexFields[i].ColumnNumber = col_num;
	}

	return true;
}

void CVTExtIndex::Reindex()
{
	RemoveAll();
	if( IndexFields.size() == 0 )
		return;
	
	CVTIndexRecord idx_rec;
	idx_rec.IndexFields = &IndexFields;

	int num_rows = pVT->GetRowsCount();
	for( int i = 0; i < num_rows; i++ )
	{
		CVTExtRow *row = pVT->GetRow(i);
		idx_rec.Row = row;
		Insert(idx_rec, i);
	}

	ResetPosition();
	SelStarted = false;
}

void CVTExtIndex::Reindex(CString& IndexExpr)
{
	DropFilter();
	BuildIndexFields(IndexExpr, IndexFields, "");
	Reindex();
}

bool CVTExtIndex::ColumnIndexed(int col_num)
{
	for( int i = IndexFields.size() - 1; i >= 0; i-- )
	{
		if( IndexFields[i].ColumnNumber == col_num ) return true;
	}
	return false;
}

void CVTExtIndex::RemoveRowFromTree(int row_num, int delta)
{
	if( IsEmpty() ) return;

	CVTExtIndexTreeNode *node_to_delete = NULL;
	CVTExtIndexTreeNode *node = Min(Root);
	while( node != Nil )
	{
		if( node->ArrayEqualIDs && !node->ArrayEqualIDs->empty() )
		{
			vector<int> &Vector = *(node->ArrayEqualIDs);
			vector<int>::iterator Iterator, End = Vector.end();

			bool vector_erased = false;
			for( Iterator = Vector.begin(); Iterator != End; Iterator++ )
			{
				if( *Iterator == row_num )
				{
					Vector.erase(Iterator); //     .   .
					vector_erased = true;
					node->Count--;
				}
				else if( *Iterator > row_num )
				{
					*Iterator += delta;
				}
			}

			if( node->ID == row_num && !Vector.empty())
			{
				//    ,       -  .
				//     .
				node->ID = Vector[Vector.size()-1];
				node->Key.Row = pVT->GetRow(node->ID);
				Vector.pop_back();
			}

			if( vector_erased )
			{
				if( Vector.empty() )
				{
					delete node->ArrayEqualIDs;
					node->ArrayEqualIDs = NULL;
					UniqueCount++;
				}
				if( delta == 0 ) break; //     ,      
			}
		}
		else if( node->ID == row_num )
		{
			node_to_delete = node;
			if( delta == 0 ) break; //     ,      
		}
		else if( node->ID > row_num )
		{
			node->ID += delta;
		}
		node = Successor(node);
	}

	if( node_to_delete ) Delete(node_to_delete);
}

void CVTExtIndex::RemoveRow(int row_num)
{
	RemoveRowFromTree(row_num, -1);
	//  ,     ,   
	if( row_num == CurrentRow && CurrentNode )
	{
		Next();
	}
}

void CVTExtIndex::RemoveAllRows()
{
	RemoveAll();
	ResetPosition();
}

void CVTExtIndex::InsertRow(CVTExtRow* row, int row_num)
{
	CurrentRow = row_num;
	pCurrentRow = row;

	if( IndexFields.size() == 0 ) return;

	CVTIndexRecord idx_rec;
	idx_rec.IndexFields = &IndexFields;
	idx_rec.Row = row;
	CurrentNode = Insert(idx_rec, row_num);
	IndexInNode = 0;
}

void CVTExtIndex::OnChangeValue(int row_num, int col_num)
{
	if( IsEmpty() ) return;
	if( !ColumnIndexed(col_num) ) return;

	RemoveRowFromTree(row_num, 0);
	InsertRow(pVT->GetRow(row_num), row_num);
}

void CVTExtIndex::NewColumn()
{
	KeyRow.NewColumn();

	if( pFilter )
		pFilter->NewColumn();
}

void CVTExtIndex::RemoveColumn(int col_num)
{
	for( int i = IndexFields.size() - 1; i >= 0; i-- )
		if( IndexFields[i].ColumnNumber > col_num ) IndexFields[i].ColumnNumber--;

	KeyRow.RemoveColumn(col_num);

	if( pFilter )
		pFilter->RemoveColumn(col_num);
}

void FillSearchKey(CPtrArray* ppValues, TVTExtIndexFields *pIndexFields, CVTExtRow& KeyRow, CVTIndexRecord& IdxRec)
{
	if( ppValues->GetSize() < pIndexFields->size())
		RuntimeError("   !    %i,   %i", pIndexFields->size(), ppValues->GetSize());

	IdxRec.IndexFields = pIndexFields;
	IdxRec.Row = &KeyRow;
	for( int i = pIndexFields->size() - 1; i >= 0; i-- )
	{
		int col_num = pIndexFields->at(i).ColumnNumber;
		CValue* val = (CValue*)(ppValues->GetAt(i));
		KeyRow.SetValue(col_num, *val);
	}
}

void FillSearchKey(CValue const& What, TVTExtIndexFields *pIndexFields, CVTExtRow& KeyRow, CVTIndexRecord& IdxRec)
{
	CPValueArray* ppVLArray = CValue2VL(&What);
	if( ppVLArray == NULL && pIndexFields->size() > 1 )
		RuntimeError("       !");

	if( ppVLArray == NULL && pIndexFields->size() == 1 )
	{
		IdxRec.IndexFields = pIndexFields;
		IdxRec.Row = &KeyRow;
		int col_num = pIndexFields->at(0).ColumnNumber;
		KeyRow.SetValue(col_num, What);
	}
	else
	{
		FillSearchKey((CPtrArray*)ppVLArray, pIndexFields, KeyRow, IdxRec);
	}
}

int CVTExtIndex::PositioningOnNode(CVTExtIndexTreeNode* node, bool FindLastRow, bool ChangePosition)
{
	if( node )
	{
		int FoundRow, FoundIndexInNode;

		if( FindLastRow && node->ArrayEqualIDs )
		{
			FoundIndexInNode = node->ArrayEqualIDs->size() - 1;
			FoundRow = node->ArrayEqualIDs->at(FoundIndexInNode);
		}
		else
		{
			FoundRow = node->ID;
		}

		if( ChangePosition )
		{
			CurrentNode = node;
			IndexInNode = FoundIndexInNode;
			CurrentRow = FoundRow;
			pCurrentRow = pVT->GetRow(CurrentRow);
		}

		return FoundRow;
	}
	return -1;
}

int CVTExtIndex::Find(CValue const& What, bool FindLastRow, bool ChangePosition)
{
	if( IsEmpty() ) RuntimeError("  !");

	CVTIndexRecord IdxRec;
	FillSearchKey(What, &IndexFields, KeyRow, IdxRec);

	CVTExtIndexTreeNode* node = Search(IdxRec);
	return PositioningOnNode(node, FindLastRow, ChangePosition);
}

CVTExtIndexTreeNode* CVTExtIndex::Find(CPtrArray* pKeyValues)
{
	if( IsEmpty() ) RuntimeError("  !");

	CVTIndexRecord IdxRec;
	FillSearchKey(pKeyValues, &IndexFields, KeyRow, IdxRec);
	return Search(IdxRec);
}

int CVTExtIndex::FindNearestGE(CValue const& What, bool ChangePosition)
{
	if( IsEmpty() ) RuntimeError("  !");

	CVTIndexRecord IdxRec;
	FillSearchKey(What, &IndexFields, KeyRow, IdxRec);

	CVTExtIndexTreeNode* node = SearchNearestGE(IdxRec);
	return PositioningOnNode(node, false, ChangePosition);
}

int CVTExtIndex::FindNearestLE(CValue const& What, bool ChangePosition)
{
	if( IsEmpty() ) RuntimeError("  !");

	CVTIndexRecord IdxRec;
	FillSearchKey(What, &IndexFields, KeyRow, IdxRec);

	CVTExtIndexTreeNode* node = SearchNearestLE(IdxRec);
	return PositioningOnNode(node, true, ChangePosition);
}

int CVTExtIndex::KeyCount(CValue const& What)
{
	if( IsEmpty() ) RuntimeError("  !");

	CVTIndexRecord IdxRec;
	FillSearchKey(What, &IndexFields, KeyRow, IdxRec);
	CVTExtIndexTreeNode *node = Search(IdxRec);
	if( node )
		return node->Count;
	else
		return -1;
}

CVTExtFilter::CVTExtFilter(int ColumnsCount, TVTExtIndexFields *pIndexFields)
:Row_min(ColumnsCount), Row_max(ColumnsCount)
{
	Rec_min.IndexFields = Rec_max.IndexFields = pIndexFields;
	Rec_min.Row = &Row_min;
	Rec_max.Row = &Row_max;
}

CVTExtFilter::CVTExtFilter(int ColumnsCount, TVTExtIndexFields *pIndexFields, CValue const& Min, CValue const& Max)
:Row_min(ColumnsCount), Row_max(ColumnsCount)
{
	Rec_min.IndexFields = Rec_max.IndexFields = pIndexFields;
	Set(Min, Max);
}

void CVTExtFilter::Set(CValue const& Min, CValue const& Max)
{
	FillSearchKey(Min, Rec_min.IndexFields, Row_min, Rec_min);
	FillSearchKey(Max, Rec_max.IndexFields, Row_max, Rec_max);
}

CVTExtFilter& CVTExtFilter::operator= (CVTExtFilter& SrcFilter)
{
	Row_min = SrcFilter.Row_min;
	Row_max = SrcFilter.Row_max;
	return *this;
}

void CVTExtIndex::SetFilter(CValue const& Min, CValue const& Max)
{
	if( IsEmpty() )
		RuntimeError("      !");

	if( pFilter )
		pFilter->Set(Min, Max);
	else
		pFilter = new CVTExtFilter(pVT->GetColumnsCount(), &IndexFields, Min, Max);
}

void CVTExtIndex::SetFilter(CValue const& SubSet, int nCols)
{
	if( IsEmpty() )
		RuntimeError("      !");

	CPtrArray* ppVLArray = (CPtrArray*)CValue2VL(&SubSet);
	if( ppVLArray == NULL )
		RuntimeError("       !");

	int nMaxIndex;
	if( nCols >= 0 )
		nMaxIndex = nCols - 1;
	else
		nMaxIndex = min(ppVLArray->GetUpperBound(), IndexFields.size() - 1);
	if( nMaxIndex > ppVLArray->GetUpperBound() )
		RuntimeError("   !");
	if( nMaxIndex >= IndexFields.size() )
		RuntimeError("   ,   !");

	if( pFilter == NULL )
		pFilter = new CVTExtFilter(pVT->GetColumnsCount(), &IndexFields);


	//   ,       .
	for( int i = 0; i <= pFilter->Row_min.Values.GetUpperBound(); i++ )
	{
		pFilter->Row_min.GetValue(i).type = 0;
		pFilter->Row_max.GetValue(i).type = USHRT_MAX;
	}

	//     
	for( i = 0; i <= nMaxIndex; i++ )
	{
		int col_num = IndexFields.at(i).ColumnNumber;
		CValue* val = (CValue*)(ppVLArray->GetAt(i));
		pFilter->Row_min.SetValue(col_num, *val);
		pFilter->Row_max.SetValue(col_num, *val);
	}
}

void CVTExtIndex::DropFilter()
{
	if( pFilter )
	{
		delete pFilter;
		pFilter = NULL;
	}
}

int CVTExtIndex::GetRowsCount()
{
	if( !pFilter ) return Count;

	CVTExtIndexTreeNode *node = SearchNearestGE(pFilter->Rec_min);

	CVTIndexRecord rec;
	rec.IndexFields = &IndexFields;

	int nRows = 0;
	while( node != Nil && node != NULL )
	{
		rec.Row = pVT->GetRow(node->ID);
		if( rec.compare(pFilter->Rec_max) > 0 )
			node = NULL;
		else
		{
			nRows += node->Count;
			node = Successor(node);
		}
	}

	return nRows;
}

bool CVTExtIndex::First()
{
	ResetPosition();
	SelStarted = false;

	if( IsEmpty() )
	{
		if( pVT->GetRowsCount() <= 0 ) return false;
	}
	else
	{
		if( pFilter == NULL )
			CurrentNode = Min(Root);
		else
			CurrentNode = SearchNearestGE(pFilter->Rec_min);

		if( CurrentNode == Nil ) return false;
	}

	SelStarted = true;
	return true;
}

bool CVTExtIndex::Next(bool bUnique)
{
	if( IsEmpty() )
	{
		//   
		if( SelStarted )
		{
			SelStarted = false;
			CurrentRow = 0;
		}
		else
		{
			CurrentRow++;
		}

		if( CurrentRow > pVT->Rows.GetUpperBound() )
			CurrentRow = -1;
	}
	else
	{
		if( CurrentNode == Nil )
		{
			CurrentRow = -1;
			SelStarted = false;
		}
		else if( SelStarted )
		{
			SelStarted = false;
			CurrentRow = CurrentNode->ID;
			IndexInNode = 0;
		}
		else
		{
			if( !bUnique && CurrentNode->ArrayEqualIDs && IndexInNode < CurrentNode->ArrayEqualIDs->size() )
			{
				CurrentRow = CurrentNode->ArrayEqualIDs->at(IndexInNode++);
			}
			else
			{
				CurrentNode = Successor(CurrentNode);
				if( CurrentNode == Nil )
				{
					CurrentRow = -1;
				}
				else
				{
					CurrentRow = CurrentNode->ID;
					IndexInNode = 0;
				}
			}
		}
	}

	if( CurrentRow < 0 )
	{
		ResetPosition();
		return false;
	}

	pCurrentRow = pVT->GetRow(CurrentRow);

	if( pFilter != NULL )
	{
		CVTIndexRecord rec;
		rec.Row = pCurrentRow;
		rec.IndexFields = &IndexFields;
		if( rec.compare(pFilter->Rec_max) > 0 )
		{
			ResetPosition();
			return false;
		}
	}

	return true;
}

bool CVTExtIndex::Last()
{
	ResetPosition();
	SelStarted = false;

	if( IsEmpty() )
	{
		if( pVT->Rows.GetUpperBound() < 0 ) return false;
	}
	else
	{
		if( pFilter == NULL )
			CurrentNode = Max(Root);
		else
			CurrentNode = SearchNearestLE(pFilter->Rec_max);
		if( CurrentNode == Nil ) return false;
	}

	SelStarted = true;
	return true;
}

void CVTExtIndex::GoToNode_Backward(bool bUnique)
{
	if( CurrentNode->ArrayEqualIDs && !bUnique )
	{
		IndexInNode = CurrentNode->ArrayEqualIDs->size() - 1;
		CurrentRow = CurrentNode->ArrayEqualIDs->at(IndexInNode);
	}
	else
	{
		CurrentRow = CurrentNode->ID;
		IndexInNode = -1;
	}
}

bool CVTExtIndex::Prev(bool bUnique)
{
	if( IsEmpty() )
	{
		//   
		if( SelStarted )
		{
			SelStarted = false;
			CurrentRow = pVT->Rows.GetUpperBound();
		}
		else
		{
			CurrentRow--;
		}
	}
	else
	{
		if( CurrentNode == Nil )
		{
			SelStarted = false;
			CurrentRow = -1;
		}
		else if( SelStarted )
		{
			SelStarted = false;
			GoToNode_Backward(bUnique);
		}
		else
		{
			if( CurrentNode->ArrayEqualIDs && !bUnique && IndexInNode >= 0 )
			{
				if( IndexInNode > 0 )
				{
					CurrentRow = CurrentNode->ArrayEqualIDs->at(--IndexInNode);
				}
				else
				{
					IndexInNode--;
					CurrentRow = CurrentNode->ID;
				}
			}
			else
			{
				CurrentNode = Predecessor(CurrentNode);
				if( CurrentNode == Nil )
					CurrentRow = -1;
				else
					GoToNode_Backward(bUnique);
			}
		}
	}
	

	if( CurrentRow < 0 )
	{
		ResetPosition();
		return false;
	}

	pCurrentRow = pVT->GetRow(CurrentRow);

	if( pFilter != NULL )
	{
		CVTIndexRecord rec;
		rec.Row = pCurrentRow;
		rec.IndexFields = &IndexFields;
		if( rec.compare(pFilter->Rec_min) < 0 )
		{
			ResetPosition();
			return false;
		}
	}

	return true;
}

void CVTExtIndex::SetCurrentRow(int row_num)
{
	if( SelStarted )
		return; // ,   ,  

	if( row_num < 0 )
	{
		ResetPosition();
		return;
	}

	CurrentRow = row_num;
	pCurrentRow = pVT->GetRow(row_num);

	if( !IsEmpty() )
	{
		CVTExtIndexTreeNode *node = Min(Root);
		CVTExtIndexTreeNode *found_node = NULL;
		while( node != Nil )
		{
			if( node->ID == CurrentRow )
			{
				found_node = node;
				IndexInNode = 0;
				break;
			}
			else if( node->ArrayEqualIDs && !node->ArrayEqualIDs->empty() )
			{
				vector<int> &Vector = *(node->ArrayEqualIDs);
				for( int i = Vector.size(); i >= 0; i-- )
				{
					if( Vector[i] == CurrentRow )
					{
						found_node = node;
						IndexInNode = i;
						break;
					}
				}
				if( found_node ) break;
			}
			node = Successor(node);
		}
		CurrentNode = found_node;
	}
}

void CVTExtIndex::SetCurrentValue(int col_num, CValue const& NewVal)
{
	if( pCurrentRow != NULL )
	{
		pCurrentRow->GetValue(col_num) = NewVal;
	}
}

void CVTExtIndex::GetCurrentValue(int col_num, CValue& RetVal)
{
	if( pCurrentRow != NULL )
		RetVal = pCurrentRow->GetValue(col_num);
}

void CVTExtIndex::GroupBy(CString Columns)
{
	TVTExtIndexFields SumFields;
	if( !BuildIndexFields(Columns, SumFields, "") ) return;

	int nColumns = SumFields.size(), i;
	CNumeric* Sums = new CNumeric[nColumns];
	CVTExtRow *pRow, *pSumRow;
	bool *DeletedRows = new bool[pVT->GetRowsCount()];
	memset((void*)DeletedRows, 0, sizeof(bool) * pVT->GetRowsCount());

	CVTExtIndexTreeNode *node = Min(Root);
	while( node != Nil )
	{
		if( node->ArrayEqualIDs )
		{
			pSumRow = pVT->GetRow(node->ID);
			for( i = 0; i < nColumns; i++ )
				Sums[i] = pSumRow->GetValue(SumFields[i].ColumnNumber).GetNumeric();

			for( int nRow = node->ArrayEqualIDs->size() - 1; nRow >= 0; nRow-- )
			{
				int nRealRowNum = node->ArrayEqualIDs->at(nRow);
				//Message("sum %i row", node->ArrayEqualIDs->at(nRow));
				pRow = pVT->GetRow(nRealRowNum);
				for( i = 0; i < nColumns; i++ )
				{
					Sums[i] = Sums[i] + pRow->GetValue(SumFields[i].ColumnNumber).GetNumeric();
				}
				DeletedRows[nRealRowNum] = true;
			}

			delete node->ArrayEqualIDs;
			node->ArrayEqualIDs = NULL;

			for( i = 0; i < nColumns; i++ )
				pSumRow->GetValue(SumFields[i].ColumnNumber) = Sums[i];
		}

		node = Successor(node);
	}

	for( i = pVT->GetRowsCount() - 1; i >= 0; i-- )
	{
		if( DeletedRows[i] )
		{
			delete pVT->GetRow(i);
			pVT->Rows.RemoveAt(i);
		}
	}

	delete[] DeletedRows;
	delete[] Sums;
}

void CVTExtIndex::Sum(int col_num, CValue& RetVal)
{
	CNumeric sum(0);
	RetVal = 0L;

	if( IsEmpty() || pFilter == NULL )
	{
		for( int i = pVT->GetRowsCount() - 1; i >= 0; i-- )
			sum = sum + pVT->GetRow(i)->GetValue(col_num).GetNumeric();
		RetVal = sum;
		return;
	}

	//Sum by filter
	CVTExtIndexTreeNode *node;
	CVTExtIndexTreeNode *last_node = NULL;
	node = SearchNearestGE(pFilter->Rec_min);
	last_node = SearchNearestLE(pFilter->Rec_max);
	if( node == Nil || last_node == Nil ) return; // -  

	while( node != Nil )
	{
		sum = sum + pVT->GetRow(node->ID)->GetValue(col_num).GetNumeric();
		if( node->ArrayEqualIDs )
		{
			for( int i = node->ArrayEqualIDs->size() - 1; i >= 0; i-- )
				sum = sum + pVT->GetRow(node->ArrayEqualIDs->at(i))->GetValue(col_num).GetNumeric();
		}

		if( node == last_node )
			node = Nil;
		else
			node = Successor(node);
	}

	RetVal = sum;
}

void CVTExtIndex::NodeSum(int nCol, CValue& RetVal)
{
	CNumeric sum(0);
	RetVal = 0L;
	if( CurrentNode != NULL )
	{
		sum = sum + pVT->GetRow(CurrentNode->ID)->GetValue(nCol).GetNumeric();
		if( CurrentNode->ArrayEqualIDs )
		{
			for( int i = CurrentNode->ArrayEqualIDs->size() - 1; i >= 0; i-- )
				sum = sum + pVT->GetRow(CurrentNode->ArrayEqualIDs->at(i))->GetValue(nCol).GetNumeric();
		}
	}

	RetVal = sum;
}

///////////////////////////////////////////////////////////////////////////
////  CVTExtIndexCollection  //////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
CVTExtIndex* CVTExtIndexCollection::operator [](int nIndex) const
{
	return (CVTExtIndex*)(CCollection::operator [](nIndex));
}

CVTExtIndex* CVTExtIndexCollection::operator [](LPCSTR szName) const
{
	return (CVTExtIndex*)(CCollection::operator [](szName));
}

CVTExtIndex* CVTExtIndexCollection::operator [](CValue* Index) const
{
	CVTExtIndex* pVTIndex = NULL;
	switch( Index->GetTypeCode() )
	{
	case 1:
		{
			int nIndex = (int)(Index->GetNumeric());
			pVTIndex = operator [](nIndex - 1);
			if( pVTIndex == NULL )
				RuntimeError("   %i   !", nIndex);
		}
		break;
	case 2:
		{
			LPCSTR szIndex = Index->GetString();
			pVTIndex = operator [](szIndex);
			if( pVTIndex == NULL )
				RuntimeError("   %s   !", szIndex);
		}
		break;
	default:
		RuntimeError("       !  (%i)", Index->GetTypeCode());
	}

	return pVTIndex;
}


int CVTExtIndexCollection::AddIndex(CVTExtIndex* pIndex)
{
	Add(pIndex);
	return GetCount() - 1;
}

int CVTExtIndexCollection::AddIndex(CString& IndexName, CString& IndexExpr, bool bUnique, CVTExtended* pVT)
{
	if( IndexName.IsEmpty() )
		RuntimeError("   !");
	if( GetItem(IndexName) != NULL )
		RuntimeError(" %s  !", IndexName);

	CVTExtIndex* Index = new CVTExtIndex(IndexName, IndexExpr, bUnique, pVT);
	return AddIndex(Index);
}


void CVTExtIndexCollection::RemoveIndex(int nIndex)
{
	CVTExtIndex* Index = operator[](nIndex);
	Remove(nIndex);
	delete Index;
}

void CVTExtIndexCollection::RemoveIndex(CVTExtIndex* Index)
{
	int nIndex = GetIndex(Index);
	Remove(nIndex);
	delete Index;
}

void CVTExtIndexCollection::RemoveAll()
{
	for( int i = GetUpperBound(); i >= 0; i-- )
	{
		RemoveIndex(i);
	}
}

void CVTExtIndexCollection::Reindex()
{
	for( int i = GetUpperBound(); i >= 0; i-- )
	{
		operator[](i)->Reindex();
	}
}

bool CVTExtIndexCollection::ColumnIndexed(int col_num)
{
	for( int i = GetUpperBound(); i >= 0; i-- )
	{
		if( operator[](i)->ColumnIndexed(col_num) ) return true;
	}
	return false;
}

void CVTExtIndexCollection::NewColumn()
{
	for( int i = GetUpperBound(); i >= 0; i-- )
	{
		operator[](i)->NewColumn();
	}
}

void CVTExtIndexCollection::RemoveColumn(int col_num)
{
	if( ColumnIndexed(col_num) )
		RuntimeError("  ,    !");

	for( int i = GetUpperBound(); i >= 0; i-- )
	{
		operator[](i)->RemoveColumn(col_num);
	}
}


void CVTExtIndexCollection::InsertRow(CVTExtRow* row, int row_num)
{
	for( int i = GetUpperBound(); i >= 0; i-- )
	{
		operator[](i)->InsertRow(row, row_num);
	}
}

void CVTExtIndexCollection::RemoveRow(int row_num)
{
	for( int i = GetUpperBound(); i >= 0; i-- )
	{
		operator[](i)->RemoveRow(row_num);
	}
}

void CVTExtIndexCollection::RemoveAllRows()
{
	for( int i = GetUpperBound(); i >= 0; i-- )
	{
		operator[](i)->RemoveAllRows();
	}
}

void CVTExtIndexCollection::OnChangeValue(int row_num, int col_num)
{
	for( int i = GetUpperBound(); i >= 0; i-- )
	{
		operator[](i)->OnChangeValue(row_num, col_num);
	}
}

void CVTExtIndexCollection::OnChangeRow(int row_num, int nColumns)
{
	for( int i = GetUpperBound(); i >= 0; i-- )
	{
		for( int col_num = 0; col_num < nColumns; col_num++ )
			operator[](i)->OnChangeValue(row_num, col_num);
	}
}
