
#include "StdAfx.h"
#include "ValueCollection.h"

CParamDefs CValueCollection::m_ParamDefs;

enum
{
    methCount,
    methGet,
    methIndexOf,
    methSet,
    LastMethod
};

CValueCollection::CValueCollection(BOOL bIsWitable /*= FALSE*/)
{
    if (m_ParamDefs.Empty())
    {
        m_ParamDefs.SetPoolSize(LastMethod, 0);
        m_ParamDefs.AddParam("Count", "", methCount, 1, 0);
        m_ParamDefs.AddParam("Get", "", methGet, 1, 1);
        m_ParamDefs.AddParam("IndexOf", "", methIndexOf, 1, 1);
        if (bIsWitable)
            m_ParamDefs.AddParam("Set", "", methSet, 0, 2);
    }
}

CValueCollection::~CValueCollection()
{
}

int	CValueCollection::IsPropReadable(int nPropIndex)const
{
    return TRUE;
}

int	CValueCollection::IsPropWritable(int nPropIndex)const
{
    return m_ParamDefs.Size() == LastMethod;
}

int	CValueCollection::GetNMethods(void)const
{
    return m_ParamDefs.Size();
}

int	CValueCollection::FindMethod(char const* szName)const
{
    return m_ParamDefs.GetIndexByName(szName);
}

char const* CValueCollection::GetMethodName(int nMethIndex, int nAlias)const
{
    return m_ParamDefs[nMethIndex].Names[nAlias];
}

int	CValueCollection::GetNParams(int nMethIndex)const
{
    return m_ParamDefs[nMethIndex].NumberOfParams;
}

int	CValueCollection::GetParamDefValue(int nMethIndex, int nParamIndex, class CValue* pDefValue)const
{
    return FALSE;
}

int	CValueCollection::HasRetVal(int nMethIndex)const
{
    return m_ParamDefs[nMethIndex].HasReturnValue;
}

int	CValueCollection::CallAsProc(int nMethIndex, class CValue** ppValue)
{
    int nType = ppValue[0]->GetTypeCode();
    if (nType == NUMBER_TYPE_1C)
    {
        int nIndex = ppValue[0]->GetNumeric();
        if (nIndex >= 0 && nIndex < GetNProps())
            return SetPropVal(nIndex, *ppValue[1]);
    }
    else if (nType == STRING_TYPE_1C)
    {
        int nIndex = FindProp(ppValue[0]->GetString());
        if (nIndex != -1)
            return SetPropVal(nIndex, *ppValue[1]);
    }
    CBLModule::RaiseExtRuntimeError("   .", 0);
    return FALSE;
}

int	CValueCollection::CallAsFunc(int nMethIndex, class CValue& RetValue, class CValue** ppValue)
{
    switch (nMethIndex)
    {
    case methCount:
        RetValue = GetNProps();
        break;
    case methGet:
        {
            int nType = ppValue[0]->GetTypeCode();
            if (nType == NUMBER_TYPE_1C)
            {
                int nIndex = ppValue[0]->GetNumeric();
                if (nIndex >= 0 && nIndex < GetNProps())
                    return GetPropVal(nIndex, RetValue);
            }
            else if (nType == STRING_TYPE_1C)
            {
                int nIndex = FindProp(ppValue[0]->GetString());
                if (nIndex != -1)
                    return GetPropVal(nIndex, RetValue);
            }
            CBLModule::RaiseExtRuntimeError("   .", 0);
            return FALSE;
        }
        break;
    case methIndexOf:
        RetValue = FindProp(ppValue[0]->GetString());
        break;
    }
    return TRUE;
}
