/////////////////////////////////////////////////////////////////////
// CursorGrid.h : interface for CursorGrid control.
//
// Written by Dmitriy Oshchepkov aka DmitrO, mailto: dmitro@russian.ru
// Copyright (c) 2005-2008. All Rights Reserved.
// Based on CVirtualGridCtrl class written by Uri Mellshior, (c) 2002-2003.
// Version: 1.0
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CURSORGRIDCTRL_H__0F1BED66_89DD_46FC_860E_1C863A61C957__INCLUDED_)
#define AFX_CURSORGRIDCTRL_H__0F1BED66_89DD_46FC_860E_1C863A61C957__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <afxtempl.h>
#include "commons.h"
#include "DataProvider.h"

#define IS_SHIFT_PRESSED()	((GetKeyState(VK_SHIFT) & (1 << (sizeof(SHORT) * 8 - 1))) != 0)
#define IS_CTRL_PRESSED()	((GetKeyState(VK_CONTROL) & (1 << (sizeof(SHORT) * 8 - 1))) != 0)
#define IS_TAB_PRESSED()	((GetKeyState(VK_TAB) & (1 << (sizeof(SHORT) * 8 - 1))) != 0)

#define CURSOR_GRID_CLASS_NAME			_T("CursorGrid")

enum RowSelectMode {rsmCell, rsmRow};
enum ScrollerPresent {spAuto, spAlways, spNever};
enum StartView {svFromBegin, svFromEnd};
enum HorizTextAlignment {htaAuto, htaLeft, htaRight, htaCenter};
enum HeadersStyle {hs3D, hsFlat};
enum InternalImages
{
    iiCheckBoxUnchecked, iiCheckBoxChecked, iiCheckBoxUndefined,
    iiOrderAsc, iiOrderDesc, iiOrderAsc2, iiOrderDesc2, iiOrderAsc3, iiOrderDesc3,
    iiBottomReposArrow, iiTopReposArrow, iiHelperIcon,
};
enum OrderMarker {omNone, omAsc, omDesc, omAsc2, omDesc2, omAsc3, omDesc3};

class CGridColumn;
class CGridColumns;
class CGridItem;
class CGridRow;
class CCursorGridCtrl;
class CReposColumnWnd;
class CReposPlaceWnd;

/////////////////////////////////////////////////////////////////////////////
// CGridColumn
/////////////////////////////////////////////////////////////////////////////

class CGridColumn : public CCollectionItem
{
    friend class CCursorGridCtrl;
    friend class CGridColumns;
    friend class CGridRow;
    friend class CGridItem;
    friend class CReposColumnWnd;
    friend class CReposPlaceWnd;
    friend class CColumnHelper;
public:
    CGridColumn();
    virtual ~CGridColumn();
    
    int GetWidth() const;
    void SetWidth(int nWidth);

    CString GetCaption() const;
    void SetCaption(LPCTSTR szCaption);
    
    BOOL GetVisible() const;
    void SetVisible(BOOL bVisible = TRUE);

    BOOL GetFixedWidth() const;
    void SetFixedWidth(BOOL bFixedWidth = TRUE);

    CFont* GetHeaderFont() const;
    void SetHeaderFont(CFont* pFont);
    
    COLORREF GetHeaderTextColor() const;
    void SetHeaderTextColor(COLORREF crTextColor);

    COLORREF GetHeaderBackColor() const;
    void SetHeaderBackColor(COLORREF crBackColor);

    HorizTextAlignment GetHTextAlignment() const;
    void SetHTextAlignment(HorizTextAlignment textAlignment);

    COLORREF GetTextColor() const;
    void SetTextColor(COLORREF crTextColor);

    COLORREF GetBackColor() const;
    void SetBackColor(COLORREF crBackColor);

    CFont* GetFont() const;
    void SetFont(CFont* pFont);
    
    CImageList* GetRowsImages() const;
    void SetRowsImages(CImageList* pRowsImages);
    
    LPCSTR GetDataField() const;
    void SetDataField(LPCSTR szDataField);
    
    OrderMarker GetOrderMarker() const;
    void SetOrderMarker(OrderMarker orderMarker);

    BOOL GetChangeVisible() const;
    void SetChangeVisible(BOOL bChangeVisible = TRUE);

protected:
    virtual void Release() {delete this;};
private:
    //Common
    int m_nMinWidth;
    CString m_strCaption;
    BOOL m_bVisible;
    BOOL m_bChangeVisible;

    //Internal
    CRect m_rect;
    CString m_strDataField;

    //Header
    COLORREF m_crHeaderText;
    COLORREF m_crHeaderBack;
    CFont* m_pHeaderFont;
    OrderMarker m_OrderMarker;

    //Cells
    HorizTextAlignment m_HTextAlignment;
    BOOL m_bFixedWidth;
    COLORREF m_crText;
    COLORREF m_crBack;
    CFont* m_pFont;
    CImageList* m_pRowsImages;
    int m_nImageWidth;

    CRect GetBoundsRect();
    void RedrawHeader();
    void RedrawGrid();
    void UpdateColumns(BOOL bRefill = FALSE);
};

/////////////////////////////////////////////////////////////////////////////
// CGridColumns
/////////////////////////////////////////////////////////////////////////////

class CGridColumns : private CCollection
{
    friend class CCursorGridCtrl;
    friend class CGridColumn;
    friend class CGridRow;
public:
    CGridColumns();
    virtual ~CGridColumns();

    int GetSize() const;
    CGridColumn* Add(LPCSTR szName);
    CGridColumn* Insert(int nIndex, LPCSTR szName);
    CGridColumn* GetAt(int nIndex) const;
    CGridColumn* GetAt(LPCSTR szName) const;
    int IndexOf(LPCSTR szName) const;
    int IndexOf(CGridColumn* pColumn) const;
    BOOL Remove(int nIndex);
    void RemoveAll();
    BOOL Move(int nIndex, int nOffset);
protected:
    virtual void Release() {delete this;};
    virtual CGridColumn* NewColumn() {return new CGridColumn();};
    virtual void OnAdd(CCollectionItem* pItem);
    virtual void OnRemove(CCollectionItem* pItem, int nIndexWas);
    virtual void OnRename(CCollectionItem* pItem);

private:
    CCursorGridCtrl* m_pGrid;
    int m_nMinWidth;
    int m_nResizableMinWidth;

    void RecalcVisibles();
    void QueryDataField(CGridColumn* pColumn);
    void ReleaseDataField(CGridColumn* pColumn);
};

/////////////////////////////////////////////////////////////////////////////
// CGridItem
/////////////////////////////////////////////////////////////////////////////

class CGridItem
{
    friend class CCursorGridCtrl;
    friend class CGridRow;
public:
    CGridItem(CGridColumn* pGridColumn);
    virtual ~CGridItem();
    
    CGridColumn* GetColumn() const;

    BOOL GetShowText() const;
    void SetShowText(BOOL bEnable = TRUE);

    BOOL GetShowImage() const;
    void SetShowImage(BOOL bEnable = TRUE);

    BOOL GetShowCheckBox() const;
    void SetShowCheckBox(BOOL bEnable = TRUE);

    LPCSTR GetText() const;
    void SetText(LPCSTR szText);

    HorizTextAlignment GetTextHAlign() const;
    void SetTextHAlign(HorizTextAlignment horizTextAlignment);

    int GetImageIndex() const;
    void SetImageIndex(int nImageIndex);

    int GetCheckValue() const;
    void SetCheckValue(int nCheckValue);

    COLORREF GetTextColor() const;
    void SetTextColor(COLORREF crTextColor);

    COLORREF GetBackColor() const;
    void SetBackColor(COLORREF crBackColor);

    CFont* GetFont() const;
    void SetFont(CFont* pFont);
protected:
    virtual BOOL DrawImage(CDC* pDC, CRect& rect) {return FALSE;};
private:
    CGridColumn* m_pGridColumn;
    WORD m_wFlagsMask;
    short m_nImageNumber;
    CString m_strText;
    COLORREF m_crText;
    COLORREF m_crBack;
    CFont* m_pFont;
};

/////////////////////////////////////////////////////////////////////////////
// CGridRow
/////////////////////////////////////////////////////////////////////////////

class CGridRow
{
    friend class CGridColumns;
    friend class CCursorGridCtrl;
public:
    CGridRow(CGridColumns* pColumns, CDataRow* pDataRow);
    virtual ~CGridRow();

    COLORREF GetTextColor() const;
    void SetTextColor(COLORREF crTextColor);

    COLORREF GetBackColor() const;
    void SetBackColor(COLORREF crBackColor);

    CFont* GetFont() const;
    void SetFont(CFont* pFont);
    
    CCursorGridCtrl* GetGrid() const;
    CDataRow* GetDataRow() const;
    CGridItem* GetGridItem(int nIndex) const;

protected:
    virtual CGridItem* NewItem(CGridColumn* pGridColumn) {return new CGridItem(pGridColumn);};
    virtual void OnFillItems() {};

private:
    void FillItems();
    void Move(int nIndex, int nOffset);

    BOOL CleanUp();
    CGridColumns* m_pColumns;
    CTypedPtrArray<CPtrArray, CGridItem*> m_cells;
    CDataRow* m_pDataRow;
    bool m_bIsCurrent;
    bool m_bIsSelected;
    
    COLORREF m_crText;
    COLORREF m_crBack;
    CFont* m_pFont;
};

/////////////////////////////////////////////////////////////////////////////
// CSelectedRows
/////////////////////////////////////////////////////////////////////////////

class CSelectedRows
{
    friend class CCursorGridCtrl;
public:
    CSelectedRows();
    virtual ~CSelectedRows();

    void Add(CDataRow* pDataRow);
    void Remove(CDataRow* pDataRow);
protected:
    virtual void Release() {delete this;};
private:
    CTypedPtrArray<CPtrArray, CDataRow*> m_rows;
};

/////////////////////////////////////////////////////////////////////////////
// CGridTip window
/////////////////////////////////////////////////////////////////////////////

#define GRIDTIP_CLASSNAME _T("CursorGridTip")

class CGridTip : public CWnd
{
    friend class CCursorGridCtrl;
public:
    CGridTip(CCursorGridCtrl* pGrid);
    virtual ~CGridTip();

    void Show(const CString& strText, LPRECT pTextRect, DWORD dwTipID,
        CFont* pFont, BOOL bByCursor);
    void Hide();
    
	//{{AFX_VIRTUAL(CGridTip)
    protected:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual BOOL DestroyWindow();
	//}}AFX_VIRTUAL

private:
    CCursorGridCtrl* m_pGrid;
    COLORREF m_crTextColor;
    COLORREF m_crBackColor;
    BOOL m_bCreated;
    CRect m_rectHover;
    DWORD m_dwTipedID;
    
protected:
	//{{AFX_MSG(CGridTip)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CQSEdit window
/////////////////////////////////////////////////////////////////////////////

class CQSEdit : public CEdit
{
public:
    CQSEdit();
    virtual ~CQSEdit();

	//{{AFX_VIRTUAL(CQSEdit)
    protected:
    virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL
protected:
	//{{AFX_MSG(CQSEdit)
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////
// CQuickSearch window
/////////////////////////////////////////////////////////////////////////////

#define QUICKSEARCH_CLASSNAME _T("QuickSearch")

class CQuickSearch : public CWnd
{
    friend class CCursorGridCtrl;
    friend class CQSEdit;
public:
    CQuickSearch(CCursorGridCtrl* pGrid);
    virtual ~CQuickSearch();

    BOOL IsWorking() const;
    void Show(LPRECT pRect, LPCSTR szFieldName, LPCSTR szInitStr);
    void Hide();
    void Search();

	//{{AFX_VIRTUAL(CQuickSearch)
    protected:
    virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL

protected:
	//{{AFX_MSG(CQuickSearch)
	afx_msg void OnPaint();
    afx_msg void OnTimer(UINT nIDEvent);
    afx_msg BOOL OnNcActivate(BOOL bActive);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
    CCursorGridCtrl* m_pGrid;
    BOOL m_bIsWorking;
    CQSEdit m_edit;
    CString m_strFieldName;
    USHORT m_nTimeout;
};

/////////////////////////////////////////////////////////////////////////////
// CReposColumnWnd window
/////////////////////////////////////////////////////////////////////////////

#define REPOSCOLUMN_CLASSNAME _T("ReposColumn")

class CReposColumnWnd : public CWnd
{
    friend class CReposPlaceWnd;
public:
    CReposColumnWnd(CCursorGridCtrl* pGrid);
    virtual ~CReposColumnWnd();

    void Show(CGridColumn* pColumn, CSize& Offset);

	//{{AFX_VIRTUAL(CReposColumnWnd)
    protected:
	//}}AFX_VIRTUAL
protected:
	//{{AFX_MSG(CReposColumnWnd)
    afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    afx_msg void OnMouseMove(UINT nFlags, CPoint point);
    afx_msg void OnPaint();
    afx_msg BOOL OnNcActivate(BOOL bActive);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
    CCursorGridCtrl* m_pGrid;
    CSize m_Offset;
    CGridColumn* m_pCapturedColumn;
    int m_nCapturedIndex;
    int m_nShift;
    BOOL m_bChangeVisible;
    BOOL m_bArrowsAreDrawn;
    CPoint m_ptLastArrows;

    void DrawArrows(int nShift, BOOL bChangeVisible);
    void HideArrows();
};

/////////////////////////////////////////////////////////////////////////////
// CColumnHelper window
/////////////////////////////////////////////////////////////////////////////

#define COLUMNHELPER_CLASSNAME _T("ColumnHelper")

class CColumnHelper : public CWnd
{
public:
    CColumnHelper(CCursorGridCtrl* pGrid);
    ~CColumnHelper();

    BOOL IsDisplay();
    void Show();
    void Hide();
	//{{AFX_VIRTUAL(CColumnHelper)
    protected:
	//}}AFX_VIRTUAL
protected:
	//{{AFX_MSG(CColumnHelper)
    afx_msg void OnNcCalcSize(BOOL bCalcValidRects, NCCALCSIZE_PARAMS* lpncsp);
    afx_msg void OnNcPaint();
    afx_msg void OnPaint();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
    int GetColumnWidth(CGridColumn* pColumn);

    CCursorGridCtrl* m_pGrid;
    BOOL m_bDisplay;
    CTypedPtrArray<CPtrArray, CGridColumn*> m_columns;
};

/////////////////////////////////////////////////////////////////////////////
// CCursorGridCtrl window
/////////////////////////////////////////////////////////////////////////////

class CCursorGridCtrl : public CWnd
{
    friend class CGridColumn;
    friend class CGridColumns;
    friend class CGridRow;
    friend class CGridTip;
    friend class CQuickSearch;
    friend class CReposColumnWnd;
    friend class CReposPlaceWnd;
    friend class CColumnHelper;
    DECLARE_DYNCREATE(CCursorGridCtrl)
public:
	CCursorGridCtrl();
	virtual ~CCursorGridCtrl();

    BOOL Create(const RECT& rect, CWnd *pParentWnd, UINT nID, BOOL bAutoDelete = FALSE);

    CGridColumns* GetColumns() const;
    void RefreshRows();

    CGridColumn* GetCurrentColumn() const;
    void SetCurrentColumn(CGridColumn* pColumn);
    
    CDataProvider* GetDataProvider() const;
    virtual void SetDataProvider(CDataProvider* pProvider);

    ScrollerPresent GetVScroller() const;
    void SetVScroller(ScrollerPresent scrollerPresent);

    StartView GetStartView() const;
    void SetStartView(StartView startView);

    RowSelectMode GetRowSelectMode() const;
    void SetRowSelectMode(RowSelectMode rowSelectMode);

    BOOL GetVerticalLines() const;
    void SetVerticalLines(BOOL bVerticalLines = TRUE);

    BOOL GetHorizontalLines() const;
    void SetHorizontalLines(BOOL bHorizontalLines = TRUE);

    HeadersStyle GetHeadersStyle() const;
    void SetHeadersStyle(HeadersStyle headersStyle);

    USHORT GetRefreshTimeout() const;
    void SetRefreshTimeout(USHORT nTimeout);

    USHORT GetQuickSearchTimeout() const;
    void SetQuickSearchTimeout(USHORT nTimeout);

    BOOL GetChangePositionOfColumns() const;
    void SetChangePositionOfColumns(BOOL bChangePositionOfColumns = TRUE);

    COLORREF GetGridLinesColor() const;
    void SetGridLinesColor(COLORREF crGridLines);

    COLORREF GetSelectionTextColor() const;
    void SetSelectionTextColor(COLORREF crTextColor);

    COLORREF GetSelectionBackColor() const;
    void SetSelectionBackColor(COLORREF crBackColor);

    COLORREF GetAlternationRowBackColor() const;
    void SetAlternationRowBackColor(COLORREF crBackColor);

    BOOL GetUseAlternationRowColor() const;
    void SetUseAlternationRowColor(BOOL bUse = TRUE);
    
protected:
    virtual CGridColumns* NewColumns() {return new CGridColumns;};
    virtual CGridRow* NewGridRow(CGridColumns* pColumns, CDataRow* pDataRow) {return new CGridRow(pColumns, pDataRow);};

    //Events
    virtual void OnChangeCurrentData(CDataRow* pDataRow) {};
    virtual void OnSelection() {};
    virtual void OnActivateRow() {};
    virtual void OnActivateColumn() {};
    virtual void OnActivateCell() {};
    virtual void OnHeaderSelection(CGridColumn* pColumn) {};
    virtual void OnShowContextMenu() {};
    virtual void OnClickCheckBox() {};
// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCursorGridCtrl)
	protected:
	virtual void PreSubclassWindow();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL

	// Generated message map functions
protected:
	//{{AFX_MSG(CCursorGridCtrl)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnPaint();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg UINT OnNcHitTest(CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg UINT OnGetDlgCode();
	afx_msg void OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnNcDestroy();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
    afx_msg LRESULT OnGetFont(WPARAM wparam, LPARAM lparam);
    afx_msg LRESULT OnSetFont(WPARAM wparam, LPARAM lparam);
    afx_msg LRESULT OnDataChange(WPARAM wparam, LPARAM lparam);
    afx_msg void OnTimer(UINT nIDEvent);
    afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
    BOOL m_bAutoDelete;
    void InitFont(CFont* pFont);
    void Paint(CDC *pDC);
    CRect GetHeaderRect();
    CRect GetGridRect();
    int GetHeaderHeight();
    void PaintHeaders(CDC *pDC);
    void PaintGridLines(CDC *pDC);
    void PaintCells(CDC *pDC);
    void Paint3DFrame(CDC *pDC, LPRECT lpRect, UINT nSideFlags);
    void DrawHeader(CDC *pDC, CGridColumn* pColumn, LPRECT pRect);
    void DrawCell(CDC* pDC, LPRECT pRect, CGridItem* pGridItem, CGridRow* pGridRow, BOOL bSelected, BOOL bAlterBack);
    void RecalcColumsWidth();
    void SetHScrollInfo();
    CGridColumn* GetResizeHeaderAt(CPoint point);
    void StepColResize(int x);
    void CalcRowsParams();
    void Update();
    void ClearRows();
    void SetVScrollInfo();
    void GetRowsUp(int nCount);
    void GetRowsDown(int nCount);
    void ScrollDown(int nPageSize);
    void ScrollUp(int nPageSize);
    int HitTestHeader(CPoint point);
    void SetCurrentCell(int nRowIndex, int nColumnIndex);
    CGridRow* NewGridRow(CDataRow* pDataRow, int nNewRowIndex);
    int GetNextColumn(int nIndex, int nDirection);
    int GetPageSize();
    void ActivateRow(CDataRow* pDataRow);
    void ToHome();
    void ToEnd();
    BOOL IsFocused();
    int GetOrigin();
    void ColumnsChanged();
    void PaintError(CDC* pDC);
    void ShowHint(CPoint point);
    void SetupCurrent(CPoint point);
    void FillRows(int nFirst, int nCount);
    void Reset(CDataRow* pActRow = NULL);
    BOOL DisplayColumn(CGridColumn* pColumn);
    BOOL IsClickCheckBox(CPoint point);
    BOOL ShowColumnHelper(CPoint point);
    COLORREF GetLinesColor();

    CFont m_font;
    COLORREF m_crGridLines;
    CGridColumns* m_pColumns;
    BOOL m_bShowHeader;
    int m_nFontHeight;
    CPoint m_hitTest;
    CGridColumn* m_pCapturedColumn;
    enum {ctNone, ctResize, ctClick, ctMove} m_CaptureType;
    ScrollerPresent m_VScrollerPresent;
    CDataProvider* m_pProvider;
    int m_nVisibleRows;
    BOOL m_bLastRowNotFull;
    int m_nRowHeight;
	CGridTip m_Tip;
    CTypedPtrArray<CPtrArray, CGridRow*> m_rows;
    int m_nTopRowIndex;
    BOOL m_bIsBOF;
    BOOL m_bIsEOF;
    int m_nCurrentColumn;
    RowSelectMode m_RowSelectMode;
    int m_nCurrentDataRowIndex;
    CDataRow* m_pCurrentDataRowOutOfWindow;
    BOOL m_bHorizontalLines;
    BOOL m_bVerticalLines;
    HeadersStyle m_HeadersStyle;
    CImageList m_ilInternalImages;
    StartView m_StartView;
    DWORD m_dwLastTickCount;
    LPARAM m_nLastLParam;
    BOOL m_bLockDrawing;
    USHORT m_nRefreshTimeout;
    CQuickSearch m_QuickSearch;
    CPoint m_hitLButton;
    CReposColumnWnd m_ReposColumnWnd;
    CColumnHelper m_ColumnHelper;
    BOOL m_bChangePositionOfColumns;
    COLORREF m_crSelectionText;
    COLORREF m_crSelectionBack;
    COLORREF m_crAlternationRowBack;
    BOOL m_bUseAlternationRowColor;
    BOOL m_bEvenRow;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CURSORGRIDCTRL_H__0F1BED66_89DD_46FC_860E_1C863A61C957__INCLUDED_)
