
#include "StdAfx.h"
#include "V7CursorGridCtrl.h"


//////////////////////////////////////////////////////////////////////////
// class CV7GridColumn
//////////////////////////////////////////////////////////////////////////

BEGIN_BL_METH_MAP(CV7GridColumn)
    BL_METH("SetRowsPictures", "", 2, MethSetRowsPictures, NULL, DefSetRowsPictures)
END_BL_METH_MAP()

BEGIN_BL_PROP_MAP(CV7GridColumn)
    BL_PROP("Name", "", GetPropName, SetPropName)
    BL_PROP("Caption", "", GetPropCaption, SetPropCaption)
    BL_PROP("Visible", "", GetPropVisible, SetPropVisible)
    BL_PROP("Width", "", GetPropWidth, SetPropWidth)
    BL_PROP("HorizontalAlignment", "", GetPropHorizontalAlignment, SetPropHorizontalAlignment)
    BL_PROP("", "SizeChange", GetPropFixedWidth, SetPropFixedWidth)
    BL_PROP("TextColor", "", GetPropTextColor, SetPropTextColor)
    BL_PROP("BackColor", "", GetPropBackColor, SetPropBackColor)
    BL_PROP("Font", "", GetPropFont, SetPropFont)
    BL_PROP("HeaderFont", "", GetPropHeaderFont, SetPropHeaderFont)
    BL_PROP("HeaderTextColor", "", GetPropHeaderTextColor, SetPropHeaderTextColor)
    BL_PROP("HeaderBackColor", "", GetPropHeaderBackColor, SetPropHeaderBackColor)
    BL_PROP("DataField", "", GetPropDataField, SetPropDataField)
    BL_PROP("OrderMarker", "", GetPropOrderMarker, SetPropOrderMarker)
    BL_PROP("ChangeVisible", "", GetPropChangeVisible, SetPropChangeVisible)
END_BL_PROP_MAP()

BEGIN_REG_NAMES(CV7GridColumn)
END_REG_NAMES()

IMPLEMENT_MY_CONTEXT(CV7GridColumn, "", NULL, NULL, -1);

CV7GridColumn::CV7GridColumn()
{
    m_pCellAppearance.Create();
    m_pFont.Create();
    m_pHeaderFont.Create();
}

CV7GridColumn::~CV7GridColumn()
{
}

BOOL CV7GridColumn::SetPropHorizontalAlignment(CValue const& Value)
{
    GET_ENUM_PROP(HorizTextAlignment, htaAuto, htaCenter);
    SetHTextAlignment(_enum);
    return TRUE;
}

BOOL CV7GridColumn::SetPropFont(CValue const& Value)
{
    CHECK_BLTYPE(Value, CBLFont);
    m_pFont = static_cast<CBLFont*>(Value.GetContext());
    SetFont(*m_pFont);
    return TRUE;
}

BOOL CV7GridColumn::SetPropHeaderFont(CValue const& Value)
{
    CHECK_BLTYPE(Value, CBLFont);
    m_pHeaderFont = static_cast<CBLFont*>(Value.GetContext());
    SetHeaderFont(*m_pHeaderFont);
    return TRUE;
}

BOOL CV7GridColumn::MethSetRowsPictures(CValue** ppValue)
{
    if (ppValue[0]->GetTypeCode() != AGREGATE_TYPE_1C || strcmp(ppValue[0]->GetContext()->GetRuntimeClass()->m_lpszClassName,"CPictureContext"))
    {
        CBLModule::RaiseExtRuntimeError("   .", 0);
        return FALSE;
    }
    CPictureHolder7& PictureHolder7 = static_cast<CPictureContext*>(ppValue[0]->GetContext())->m_PictureHolder7;

    BOOL bSuccess = FALSE;
    CDC dc;
    CDC DesktopDC;
    DesktopDC.Attach(::GetDC(NULL));
    if (dc.CreateCompatibleDC(&DesktopDC))
    {
        CSize size = PictureHolder7.GetSize();
        if (ppValue[1]->GetTypeCode() != UNDEFINE_TYPE_1C)
            size.cy = ppValue[1]->GetNumeric();
        CBitmap bitmap;
        if (bitmap.CreateCompatibleBitmap(&DesktopDC, size.cx, size.cy))
        {
            CBitmap* pOldbitmap = dc.SelectObject(&bitmap);
            CRect rect(CPoint(0,0), PictureHolder7.GetSize());
            dc.FillSolidRect(0,0, size.cx, size.cy, RGB(0x00, 0x80, 0x80));
            PictureHolder7.Render(dc, rect, 0, NULL);
            dc.SelectObject(pOldbitmap);
            if (m_RowsImages.Create(size.cy, size.cy, ILC_MASK, 2, 0))
            {
                bSuccess = m_RowsImages.Add(&bitmap, RGB(0x00, 0x80, 0x80)) == 0;
                int i = m_RowsImages.GetImageCount();
                if (bSuccess)
                    SetRowsImages(&m_RowsImages);
            }

        }
    }
    return bSuccess;
}

BOOL CV7GridColumn::DefSetRowsPictures(int nParam, CValue* pValue)const
{
    if (nParam == 1)
    {
        pValue->Reset();
        return TRUE;
    }
    else
        return FALSE;
}

BOOL CV7GridColumn::SetPropOrderMarker(CValue const& Value)
{
    GET_ENUM_PROP(OrderMarker, omNone, omDesc3);
    SetOrderMarker(_enum);
    return TRUE;
}

//////////////////////////////////////////////////////////////////////////
// class CV7GridColumns
//////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC(CV7GridColumns, CBLContext);

CV7GridColumns::CV7GridColumns()
{
}

CV7GridColumns::~CV7GridColumns()
{
}

void CV7GridColumns::Release()
{
    DecrRef();
}

CGridColumn* CV7GridColumns::NewColumn()
{
    return new CV7GridColumn;
}

//////////////////////////////////////////////////////////////////////////
// class CV7GridItem
//////////////////////////////////////////////////////////////////////////

CV7GridItem::CV7GridItem(CGridColumn* pGridColumn) : CGridItem(pGridColumn)
{
    m_pFont.Create();
}

CV7GridItem::~CV7GridItem()
{
}

BOOL CV7GridItem::DrawImage(CDC* pDC, CRect& rect)
{
    if (!m_pPicture)
        return FALSE;
    //CPictureHolder7 CBLContext
    CSize size = m_pPicture->m_PictureHolder7.GetSize();
    switch (m_pPicture->m_PictureHolder7.m_DrawMode)
    {
    case CPictureHolder7::dmStretch:
        if (size.cy > rect.Height())
            rect.right = rect.left + MulDiv(rect.Height(), size.cx, size.cy);
        else if (size.cx > rect.Width())
            rect.bottom = rect.top + MulDiv(rect.Width(), size.cy, size.cx);
        else
        {
            rect.bottom = rect.top + size.cy;
            rect.right = rect.left + size.cx;
        }
        break;
    case CPictureHolder7::dmOriginalSize:
        rect.right = rect.left + size.cx;
        rect.bottom = rect.top + size.cy;
        break;
    case CPictureHolder7::dmKeepingOriginalParity:
        if (size.cx > size.cy)
        {
            int nWidth = MulDiv(rect.Height(), size.cx, size.cy);
            if (nWidth < rect.Width())
                rect.right = rect.left + nWidth;
        }
        else
        {
            int nHeight = MulDiv(rect.Width(), size.cy, size.cx);
            if (nHeight < rect.Height())
                rect.bottom = rect.top + nHeight;
        }
        break;
    default:
        return FALSE;
    }
    m_pPicture->m_PictureHolder7.Render(*pDC, rect, 0, NULL);
    return TRUE;
}

//////////////////////////////////////////////////////////////////////////
// class CV7GridRow
//////////////////////////////////////////////////////////////////////////

CV7GridRow::CV7GridRow(CGridColumns* pColumns, CDataRow* pDataRow)
    : CGridRow(pColumns, pDataRow)
{
    m_pFont.Create();
}

CV7GridRow::~CV7GridRow()
{
}

CGridItem* CV7GridRow::NewItem(CGridColumn* pGridColumn)
{
    return new CV7GridItem(pGridColumn);
}

void CV7GridRow::OnFillItems()
{
    static_cast<CV7CursorGridCtrl*>(GetGrid())->OnFillItems(this);
}

//////////////////////////////////////////////////////////////////////////
// class CV7CursorGridCtrl
//////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNCREATE(CV7CursorGridCtrl, CCursorGridCtrl);

CV7CursorGridCtrl::CV7CursorGridCtrl()
{
    m_pFont.Create();
    m_pV7RowAppearance.Create();
    m_pCurrentData.Create();

    m_pBLModule = NULL;
    m_nOnRowOutProc = -1;
    m_nOnSelection = -1;
    m_nOnActivateRow = -1;
    m_nOnActivateColumn = -1;
    m_nOnActivateCell = -1;
    m_nOnHeaderSelection = -1;
    m_nOnContextMenu = -1;
    m_nOnClickCheckBox = -1;
}

CV7CursorGridCtrl::~CV7CursorGridCtrl()
{
    if (m_pCtrlObject)
        m_pCtrlObject->m_pGrid = NULL;
    if (m_pProvider)
        SetDataProvider(NULL);
}

CGridColumns* CV7CursorGridCtrl::NewColumns()
{
    CV7GridColumns* pV7GridColumns = new CV7GridColumns;
    m_pV7RowAppearance->m_pV7GridCells->m_pColumns = pV7GridColumns;
    return pV7GridColumns;
}

CBLFont* CV7CursorGridCtrl::GetBLFont() const
{
    return m_pFont;
}

void CV7CursorGridCtrl::SetBLFont(CBLFont* pFont)
{
    m_pFont = pFont;
}

CBLContext* CV7CursorGridCtrl::GetBLDataProvider() const
{
    return m_pProvider;
}

void CV7CursorGridCtrl::SetBLDataProvider(CBLContext* pProvider)
{
    CDataProvider* pDataProvider = NULL;
    try
    {
        pDataProvider = dynamic_cast<CDataProvider*>(pProvider);
    }
    catch (...)
    {
    }

    m_pProvider = pProvider;

    CV7DataProvider* pV7DataProvider = NULL;
    try
    {
        pV7DataProvider = dynamic_cast<CV7DataProvider*>(pProvider);
    }
    catch (...)
    {
    }

    m_pV7RowAppearance->m_pV7DataProvider = pV7DataProvider;

    SetDataProvider(pDataProvider);
}

CGridRow* CV7CursorGridCtrl::NewGridRow(CGridColumns* pColumns, CDataRow* pDataRow)
{
    return new CV7GridRow(pColumns, pDataRow);
}

void CV7CursorGridCtrl::OnFillItems(CV7GridRow* pV7GridRow)
{
    if (m_nOnRowOutProc != -1)
    {
        m_pV7RowAppearance->Attach(pV7GridRow);

        CValue vCtrl, vRowAppearance, vRowData;
        vCtrl.AssignContext(m_pCtrlObject);
        vRowAppearance.AssignContext(m_pV7RowAppearance);
        vRowData.AssignContext(m_pV7RowAppearance->m_pV7RowData);

        CValue* arParams[3] = {&vCtrl, &vRowAppearance, &vRowData};
        m_pBLModule->CallAsProc(m_nOnRowOutProc, 3, arParams);

        m_pV7RowAppearance->Detach();
    }
}

BOOL CV7CursorGridCtrl::Init(CV7TableField* pCtrlObject, CControlID* pControlID, CBLModule* pBLModule)
{
    m_pCtrlObject = pCtrlObject;
    m_pControlID = pControlID;
    m_pCtrlObject->m_pGrid = this;
    
    if (!pBLModule)
        return TRUE;
    
    m_pBLModule = pBLModule;
    BOOL bSuccess = TRUE;

    bSuccess &= SetEvent("", 3, m_nOnRowOutProc);
    bSuccess &= SetEvent("", 1, m_nOnSelection);
    bSuccess &= SetEvent("", 1, m_nOnActivateRow);
    bSuccess &= SetEvent("", 1, m_nOnActivateColumn);
    bSuccess &= SetEvent("", 1, m_nOnActivateCell);
    bSuccess &= SetEvent("", 2, m_nOnHeaderSelection);
    bSuccess &= SetEvent("", 1, m_nOnContextMenu);
    bSuccess &= SetEvent("", 1, m_nOnClickCheckBox);

    if (!bSuccess)
        CBLModule::RaiseExtRuntimeError("  .", 0);
    return bSuccess;
}

BOOL CV7CursorGridCtrl::SetEvent(LPCSTR szEventName, int nParamCount, int& nEventProcID)
{
    CBLProcInfo BLProcInfo;
    CString strProcName(m_pControlID->m_CodeName);
    strProcName += szEventName;
    int nProcID = m_pBLModule->FindProc(strProcName, 0);
    if (nProcID != -1)
    {
        m_pBLModule->GetProcInfo(nProcID, BLProcInfo);
        if (BLProcInfo.GetNParams() > nParamCount)
        {
            CString str;
            str.Format("    '%s'      %u.", strProcName, nParamCount);
            pBkEndUI->DoMessageLine(str, mmBlackErr);
            return FALSE;
        }
        nEventProcID = nProcID;
    }
    return TRUE;
}

CV7RowData* CV7CursorGridCtrl::GetRowData() const
{
    if (m_pCurrentData->m_pDataRow)
        return m_pCurrentData;
    else
        return NULL;
}

//Events
void CV7CursorGridCtrl::OnChangeCurrentData(CDataRow* pDataRow)
{
    m_pCurrentData->m_pDataRow = pDataRow;
    if (m_pV7RowAppearance->m_pV7DataProvider)
        m_pCurrentData->m_pV7DataRow = m_pV7RowAppearance->m_pV7DataProvider->GetV7DataRow(pDataRow);
}

void CV7CursorGridCtrl::OnSelection()
{
    if (m_nOnSelection != -1)
    {
        CValue vCtrl, *pvCtrl = &vCtrl;
        vCtrl.AssignContext(m_pCtrlObject);
        m_pBLModule->CallAsProc(m_nOnSelection, 1, &pvCtrl);
    }
}

void CV7CursorGridCtrl::OnActivateRow()
{
    if (m_nOnActivateRow != -1)
    {
        CValue vCtrl, *pvCtrl = &vCtrl;
        vCtrl.AssignContext(m_pCtrlObject);
        m_pBLModule->CallAsProc(m_nOnActivateRow, 1, &pvCtrl);
    }
}

void CV7CursorGridCtrl::OnActivateColumn()
{
    if (m_nOnActivateColumn != -1)
    {
        CValue vCtrl, *pvCtrl = &vCtrl;
        vCtrl.AssignContext(m_pCtrlObject);
        m_pBLModule->CallAsProc(m_nOnActivateColumn, 1, &pvCtrl);
    }
}

void CV7CursorGridCtrl::OnActivateCell()
{
    if (m_nOnActivateCell != -1)
    {
        CValue vCtrl, *pvCtrl = &vCtrl;
        vCtrl.AssignContext(m_pCtrlObject);
        m_pBLModule->CallAsProc(m_nOnActivateCell, 1, &pvCtrl);
    }
}

void CV7CursorGridCtrl::OnHeaderSelection(CGridColumn* pColumn)
{
    if (m_nOnHeaderSelection != -1)
    {
        CValue vCtrl, vColumn;
        vCtrl.AssignContext(m_pCtrlObject);
        vColumn.AssignContext(static_cast<CV7GridColumn*>(pColumn));
        CValue* arParams[2] = {&vCtrl, &vColumn};
        m_pBLModule->CallAsProc(m_nOnHeaderSelection, 2, arParams);
    }
}

void CV7CursorGridCtrl::OnShowContextMenu()
{
    if (m_nOnContextMenu != -1)
    {
        CValue vCtrl, *pvCtrl = &vCtrl;
        vCtrl.AssignContext(m_pCtrlObject);
        m_pBLModule->CallAsProc(m_nOnContextMenu, 1, &pvCtrl);
    }
}

void CV7CursorGridCtrl::OnClickCheckBox()
{
    if (m_nOnClickCheckBox != -1)
    {
        CValue vCtrl, *pvCtrl = &vCtrl;
        vCtrl.AssignContext(m_pCtrlObject);
        m_pBLModule->CallAsProc(m_nOnClickCheckBox, 1, &pvCtrl);
    }
}

//////////////////////////////////////////////////////////////////////////
// class CV7TableField
//////////////////////////////////////////////////////////////////////////

BEGIN_BL_METH_MAP(CV7TableField)
    BL_METH("RefreshRows", "", 0, MethRefreshRows, NULL, NULL)
END_BL_METH_MAP()

BEGIN_BL_PROP_MAP(CV7TableField)
    BL_PROP("Columns", "", GetPropColumns, NULL)
    BL_PROP("DataProvider", "", GetPropProvider, SetPropProvider)
    BL_PROP("VScroller", "", GetPropVScroller, SetPropVScroller)
    BL_PROP("StartView", "", GetPropStartView, SetPropStartView)
    BL_PROP("RowSelectMode", "", GetPropRowSelectMode, SetPropRowSelectMode)
    BL_PROP("VerticalLines", "", GetPropVerticalLines, SetPropVerticalLines)
    BL_PROP("HorizontalLines", "", GetPropHorizontalLines, SetPropHorizontalLines)
    BL_PROP("HeadersStyle", "", GetPropHeadersStyle, SetPropHeadersStyle)
    BL_PROP("CurrentColumn", "", GetPropCurrentColumn, SetPropCurrentColumn)
    BL_PROP("CurrentData", "", GetPropCurrentData, NULL)
    BL_PROP("Font", "", GetPropFont, SetPropFont)
    BL_PROP("RefreshTimeout", "", GetPropRefreshTimeout, SetPropRefreshTimeout)
    BL_PROP("QuickSearchTimeout", "", GetPropQuickSearchTimeout, SetPropQuickSearchTimeout)
    BL_PROP("ChangePositionOfColumns", "", GetPropChangePositionOfColumns, SetPropChangePositionOfColumns)
    BL_PROP("LinesColor", "", GetPropLinesColor, SetPropLinesColor)
    BL_PROP("SelectionTextColor", "", GetPropSelectionTextColor, SetPropSelectionTextColor)
    BL_PROP("SelectionBackColor", "", GetPropSelectionBackColor, SetPropSelectionBackColor)
    BL_PROP("AlternationRowBackColor", "", GetPropAlternationRowBackColor, SetPropAlternationRowBackColor)
    BL_PROP("UseAlternationRowColor", "", GetPropUseAlternationRowColor, SetPropUseAlternationRowColor)
END_BL_PROP_MAP()

BEGIN_REG_NAMES(CV7TableField)
END_REG_NAMES()

IMPLEMENT_MY_CONTEXT(CV7TableField, "", NULL, NULL, -1);

CV7TableField::CV7TableField()
{
    m_pGrid = NULL;
}

CV7TableField::~CV7TableField()
{
}

BOOL CV7TableField::CreateControl(CWnd* pParent, CGetDoc7* pDoc, CGetField* pGetField)
{
    if (pGetField == NULL || pGetField->GetCtrlInfo()->m_CtrlType != 3)
    {
        CBLModule::RaiseExtRuntimeError("   .", 0);
        return 0;
    }
    CControlID* pControlID = pGetField->GetCtrlInfo();
    
    CRect rect;
    const CWnd* pPrevWnd;

    CWnd* pControlWnd = pDoc->GetFieldWnd(pGetField);
    pControlWnd->GetWindowRect(&rect);
    pParent->ScreenToClient(rect);
    pPrevWnd = pControlWnd->GetNextWindow(GW_HWNDPREV);
    if (!pPrevWnd)
        pPrevWnd = &CWnd::wndTop;
    delete pControlWnd;

    CV7CursorGridCtrl* pV7CursorGridCtrl = new CV7CursorGridCtrl();
    BOOL bSuccess = pV7CursorGridCtrl->Create(rect, pParent, pControlID->m_CtrlID, TRUE);
    if (bSuccess)
    {
        bSuccess = pV7CursorGridCtrl->SetWindowPos(pPrevWnd, 0, 0, 0, 0, SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE);
        bSuccess = pV7CursorGridCtrl->Init(this, pControlID, (CBLModule7*)(((char*)pDoc) + 0x4E0));
    }
    return bSuccess;
}

BOOL CV7TableField::MethRefreshRows(CValue** ppValues)
{
    if (m_pGrid)
        m_pGrid->RefreshRows();
    return TRUE;
}

BOOL CV7TableField::GetPropColumns(CValue& Value)const
{
    if (m_pGrid)
        Value.AssignContext(static_cast<CV7GridColumns*>(m_pGrid->GetColumns()));
    return TRUE;
}

BOOL CV7TableField::GetPropProvider(CValue& Value)const
{
    if (m_pGrid)
    {
        if (m_pGrid->GetBLDataProvider())
            Value.AssignContext(m_pGrid->GetBLDataProvider());
        else
            Value.Reset();
    }
    return TRUE;
}

BOOL CV7TableField::SetPropProvider(CValue const& Value)
{
    if (m_pGrid)
    {
        if (Value.GetTypeCode() == AGREGATE_TYPE_1C)
            m_pGrid->SetBLDataProvider(Value.GetContext());
        else
            m_pGrid->SetBLDataProvider(NULL);
    }
    return TRUE;
}

BOOL CV7TableField::GetPropVScroller(CValue& Value)const
{
    if (m_pGrid)
        Value = m_pGrid->GetVScroller();
    return TRUE;
}

BOOL CV7TableField::SetPropVScroller(CValue const& Value)
{
    if (m_pGrid)
    {
        GET_ENUM_PROP(ScrollerPresent, spAuto, spNever);
        m_pGrid->SetVScroller(_enum);
    }
    return TRUE;
}

BOOL CV7TableField::GetPropStartView(CValue& Value)const
{
    if (m_pGrid)
        Value = m_pGrid->GetStartView();
    return TRUE;
}

BOOL CV7TableField::SetPropStartView(CValue const& Value)
{
    if (m_pGrid)
    {
        GET_ENUM_PROP(StartView, svFromBegin, svFromEnd);
        m_pGrid->SetStartView(_enum);
    }
    return TRUE;
}

BOOL CV7TableField::GetPropRowSelectMode(CValue& Value)const
{
    if (m_pGrid)
        Value = m_pGrid->GetRowSelectMode();
    return TRUE;
}

BOOL CV7TableField::SetPropRowSelectMode(CValue const& Value)
{
    if (m_pGrid)
    {
        GET_ENUM_PROP(RowSelectMode, rsmCell, rsmRow);
        m_pGrid->SetRowSelectMode(_enum);
    }
    return TRUE;
}

BOOL CV7TableField::GetPropVerticalLines(CValue& Value)const
{
    if (m_pGrid)
        Value = m_pGrid->GetVerticalLines();
    return TRUE;
}

BOOL CV7TableField::SetPropVerticalLines(CValue const& Value)
{
    if (m_pGrid)
        m_pGrid->SetVerticalLines(Value.GetNumeric());
    return TRUE;
}

BOOL CV7TableField::GetPropHorizontalLines(CValue& Value)const
{
    if (m_pGrid)
        Value = m_pGrid->GetHorizontalLines();
    return TRUE;
}

BOOL CV7TableField::SetPropHorizontalLines(CValue const& Value)
{
    if (m_pGrid)
        m_pGrid->SetHorizontalLines(Value.GetNumeric());
    return TRUE;
}

BOOL CV7TableField::GetPropHeadersStyle(CValue& Value)const
{
    if (m_pGrid)
        Value = m_pGrid->GetHeadersStyle();
    return TRUE;
}

BOOL CV7TableField::SetPropHeadersStyle(CValue const& Value)
{
    if (m_pGrid)
    {
        GET_ENUM_PROP(HeadersStyle, hs3D, hsFlat);
        m_pGrid->SetHeadersStyle(_enum);
    }
    return TRUE;
}

BOOL CV7TableField::GetPropCurrentColumn(CValue& Value)const
{
    if (m_pGrid)
    {
        CGridColumn* pGridColumn = m_pGrid->GetCurrentColumn();
        if (pGridColumn)
            Value.AssignContext(static_cast<CV7GridColumn*>(pGridColumn));
    }
    return TRUE;
}

BOOL CV7TableField::SetPropCurrentColumn(CValue const& Value)
{
    if (m_pGrid)
    {
        CHECK_BLTYPE(Value, CV7GridColumn);
        m_pGrid->SetCurrentColumn(static_cast<CV7GridColumn*>(Value.GetContext()));
    }
    return TRUE;
}

BOOL CV7TableField::GetPropCurrentData(CValue& Value)const
{
    if (m_pGrid)
    {
        CV7RowData* pV7RowData = m_pGrid->GetRowData();
        if (pV7RowData)
            Value.AssignContext(pV7RowData);
    }
    return TRUE;
}

BOOL CV7TableField::GetPropFont(CValue& Value)const
{
    if (m_pGrid)
        Value.AssignContext(m_pGrid->GetBLFont());
    return TRUE;
}

BOOL CV7TableField::SetPropFont(CValue const& Value)
{
    CHECK_BLTYPE(Value, CBLFont);
    if (m_pGrid)
        m_pGrid->SetBLFont(static_cast<CBLFont*>(Value.GetContext()));
    return TRUE;
}

BOOL CV7TableField::GetPropRefreshTimeout(CValue& Value)const
{
    if (m_pGrid)
        Value = m_pGrid->GetRefreshTimeout();
    return TRUE;
}

BOOL CV7TableField::SetPropRefreshTimeout(CValue const& Value)
{
    if (m_pGrid)
        m_pGrid->SetRefreshTimeout(Value.GetNumeric());
    return TRUE;
}

BOOL CV7TableField::GetPropQuickSearchTimeout(CValue& Value)const
{
    if (m_pGrid)
        Value = m_pGrid->GetQuickSearchTimeout();
    return TRUE;
}

BOOL CV7TableField::SetPropQuickSearchTimeout(CValue const& Value)
{
    if (m_pGrid)
        m_pGrid->SetQuickSearchTimeout(Value.GetNumeric());
    return TRUE;
}

BOOL CV7TableField::GetPropChangePositionOfColumns(CValue& Value)const
{
    if (m_pGrid)
        Value = m_pGrid->GetChangePositionOfColumns();
    return TRUE;
}

BOOL CV7TableField::SetPropChangePositionOfColumns(CValue const& Value)
{
    if (m_pGrid)
        m_pGrid->SetChangePositionOfColumns(Value.GetNumeric());
    return TRUE;
}

BOOL CV7TableField::GetPropLinesColor(CValue& Value)const
{
    if (m_pGrid)
        Value = GET_V7_COLOR(m_pGrid->GetGridLinesColor());
    return TRUE;
}

BOOL CV7TableField::SetPropLinesColor(CValue const& Value)
{
    if (m_pGrid)
        m_pGrid->SetGridLinesColor(SET_V7_COLOR(Value));
    return TRUE;
}

BOOL CV7TableField::GetPropSelectionTextColor(CValue& Value)const
{
    if (m_pGrid)
        Value = GET_V7_COLOR(m_pGrid->GetSelectionTextColor());
    return TRUE;
}

BOOL CV7TableField::SetPropSelectionTextColor(CValue const& Value)
{
    if (m_pGrid)
        m_pGrid->SetSelectionTextColor(SET_V7_COLOR(Value));
    return TRUE;
}

BOOL CV7TableField::GetPropSelectionBackColor(CValue& Value)const
{
    if (m_pGrid)
        Value = GET_V7_COLOR(m_pGrid->GetSelectionBackColor());
    return TRUE;
}

BOOL CV7TableField::SetPropSelectionBackColor(CValue const& Value)
{
    if (m_pGrid)
        m_pGrid->SetSelectionBackColor(SET_V7_COLOR(Value));
    return TRUE;
}

BOOL CV7TableField::GetPropAlternationRowBackColor(CValue& Value)const
{
    if (m_pGrid)
        Value = GET_V7_COLOR(m_pGrid->GetAlternationRowBackColor());
    return TRUE;
}

BOOL CV7TableField::SetPropAlternationRowBackColor(CValue const& Value)
{
    if (m_pGrid)
        m_pGrid->SetAlternationRowBackColor(SET_V7_COLOR(Value));
    return TRUE;
}

BOOL CV7TableField::GetPropUseAlternationRowColor(CValue& Value)const
{
    if (m_pGrid)
        Value = m_pGrid->GetUseAlternationRowColor();
    return TRUE;
}

BOOL CV7TableField::SetPropUseAlternationRowColor(CValue const& Value)
{
    if (m_pGrid)
        m_pGrid->SetUseAlternationRowColor(Value.GetNumeric());
    return TRUE;
}

//////////////////////////////////////////////////////////////////////////
// class CV7RowData
//////////////////////////////////////////////////////////////////////////

BEGIN_BL_METH_MAP(CV7RowData)
    BL_METH("Count", "", 0, NULL, MethCount, NULL)
    BL_METH("Get", "", 1, NULL, MethGet, NULL)
END_BL_METH_MAP()

BEGIN_BL_PROP_MAP(CV7RowData)
END_BL_PROP_MAP()

BEGIN_REG_NAMES(CV7RowData)
END_REG_NAMES()

IMPLEMENT_MY_CONTEXT(CV7RowData, "", NULL, NULL, -1);

CV7RowData::CV7RowData() : m_pDataRow(NULL)//, m_pV7DataRow(NULL)
{
}

CV7RowData::~CV7RowData()
{
}

BOOL CV7RowData::MethCount(CValue& rValue, CValue** ppValues)
{
    if (m_pDataRow)
        rValue = m_pDataRow->GetFieldCount();
    else
        rValue = 0L;
    return TRUE;
}

BOOL CV7RowData::MethGet(CValue& rValue, CValue** ppValue)
{
    if (!m_pDataRow)
    {
        CBLModule::RaiseExtRuntimeError("  ", 0);
        return FALSE;
    }
        
    if (ppValue[0]->GetTypeCode() == NUMBER_TYPE_1C)
    {
        int nIndex = ppValue[0]->GetNumeric();
        if (nIndex < 0 || nIndex >= m_pDataRow->GetFieldCount())
        {
            CBLModule::RaiseExtRuntimeError(" ", 0);
            return FALSE;
        }
        rValue = m_pV7DataRow->GetValue(nIndex);
    }
    else if (ppValue[0]->GetTypeCode() == STRING_TYPE_1C)
    {
        int nIndex = m_pDataRow->GetFieldIndexOf(ppValue[0]->GetString());
        if (nIndex == -1)
        {
            CBLModule::RaiseExtRuntimeError("  ", 0);
            return FALSE;
        }
        rValue = m_pV7DataRow->GetValue(nIndex);
    }
    else
    {
        CBLModule::RaiseExtRuntimeError("  ", 0);
        return FALSE;
    }
    return TRUE;
}

int	CV7RowData::GetNProps(void)const
{
    if (m_pDataRow)
        return m_pDataRow->GetFieldCount();
    else
        return 0;
}

int	CV7RowData::FindProp(char const* szName)const
{
    if (m_pDataRow)
        return m_pDataRow->GetFieldIndexOf(szName);
    else
        return -1;
}

char const* CV7RowData::GetPropName(int nPropIndex, int nAlias)const
{
    return m_pDataRow->GetFieldName(nPropIndex);
}

int	CV7RowData::GetPropVal(int nPropIndex, class CValue& Value)const
{
    if (m_pV7DataRow)
        Value = m_pV7DataRow->GetValue(nPropIndex);
    return 1;
}

int	CV7RowData::SetPropVal(int nPropIndex, class CValue const& Value)
{
    return 0;
}

int	CV7RowData::IsPropReadable(int nPropIndex)const
{
    return TRUE;
}

int	CV7RowData::IsPropWritable(int nPropIndex)const
{
    return FALSE;
}

//////////////////////////////////////////////////////////////////////////
// class CCellAppearance
//////////////////////////////////////////////////////////////////////////

BEGIN_BL_METH_MAP(CCellAppearance)
    BL_METH("SetText", "", 1, MethSetText, NULL, NULL)
    BL_METH("SetPicture", "", 1, MethSetImage, NULL, NULL)
    BL_METH("SetCheck", "", 1, MethSetCheckValue, NULL, NULL)
END_BL_METH_MAP()

BEGIN_BL_PROP_MAP(CCellAppearance)
    BL_PROP("Name", "", GetPropName, NULL)
    BL_PROP("ShowText", "", GetPropShowText, SetPropShowText)
    BL_PROP("ShowPicture", "", GetPropShowImage, SetPropShowImage)
    BL_PROP("ShowCheck", "", GetPropShowCheckBox, SetPropShowCheckBox)
    BL_PROP("HorizontalAlignment", "", GetPropHorizontalAlignment, SetPropHorizontalAlignment)
    BL_PROP("PictureIndex", "", GetPropImageIndex, SetPropImageIndex)
    BL_PROP("CheckValue", "", GetPropCheckValue, SetPropCheckValue)
    BL_PROP("Text", "", GetPropText, SetPropText)
    BL_PROP("TextColor", "", GetPropTextColor, SetPropTextColor)
    BL_PROP("BackColor", "", GetPropBackColor, SetPropBackColor)
    BL_PROP("Font", "", GetPropFont, SetPropFont)
END_BL_PROP_MAP()

BEGIN_REG_NAMES(CCellAppearance)
END_REG_NAMES()

IMPLEMENT_MY_CONTEXT(CCellAppearance, "", NULL, NULL, -1);

CCellAppearance::CCellAppearance() : m_pGridItem(NULL)
{
}

CCellAppearance::~CCellAppearance()
{
}

LPCSTR CCellAppearance::GetName() const
{
    if (m_pGridItem)
        return m_pGridItem->GetColumn()->GetName();
    else
        return "";
}

BOOL CCellAppearance::MethSetText(CValue** ppValue)
{
    if (m_pGridItem)
    {
        m_pGridItem->SetShowText();
        m_pGridItem->SetText(ppValue[0]->GetString());
    }
    return TRUE;
}

BOOL CCellAppearance::MethSetImage(CValue** ppValue)
{
    if (m_pGridItem)
    {
        m_pGridItem->SetShowImage();
        if (ppValue[0]->GetTypeCode() == NUMBER_TYPE_1C)
            m_pGridItem->SetImageIndex(ppValue[0]->GetNumeric());
        else if (ppValue[0]->GetTypeCode() == AGREGATE_TYPE_1C && !strcmp(ppValue[0]->GetContext()->GetRuntimeClass()->m_lpszClassName,"CPictureContext"))
        {
            m_pGridItem->m_pPicture = static_cast<CPictureContext*>(ppValue[0]->GetContext());
            m_pGridItem->SetImageIndex(-1);
        }
        else
        {
            CBLModule::RaiseExtRuntimeError("   .", 0);
            return FALSE;
        }
    }
    return TRUE;
}

BOOL CCellAppearance::MethSetCheckValue(CValue** ppValue)
{
    if (m_pGridItem)
    {
        m_pGridItem->SetShowCheckBox();
        m_pGridItem->SetCheckValue(ppValue[0]->GetNumeric());
    }
    return TRUE;
}

BOOL CCellAppearance::GetPropName(CValue& Value)const
{
    Value = GetName();
    return TRUE;
}

BOOL CCellAppearance::GetPropShowText(CValue& Value)const
{
    if (m_pGridItem)
        Value = m_pGridItem->GetShowText();
    return TRUE;
}

BOOL CCellAppearance::SetPropShowText(CValue const& Value)
{
    if (m_pGridItem)
        m_pGridItem->SetShowText(Value.GetNumeric());
    return TRUE;
}

BOOL CCellAppearance::GetPropShowImage(CValue& Value)const
{
    if (m_pGridItem)
        Value = m_pGridItem->GetShowImage();
    return TRUE;
}

BOOL CCellAppearance::SetPropShowImage(CValue const& Value)
{
    if (m_pGridItem)
        m_pGridItem->SetShowImage(Value.GetNumeric());
    return TRUE;
}

BOOL CCellAppearance::GetPropShowCheckBox(CValue& Value)const
{
    if (m_pGridItem)
        Value = m_pGridItem->GetShowCheckBox();
    return TRUE;
}

BOOL CCellAppearance::SetPropShowCheckBox(CValue const& Value)
{
    if (m_pGridItem)
        m_pGridItem->SetShowCheckBox(Value.GetNumeric());
    return TRUE;
}

BOOL CCellAppearance::GetPropHorizontalAlignment(CValue& Value)const
{
    if (m_pGridItem)
        Value = m_pGridItem->GetTextHAlign();
    return TRUE;
}

BOOL CCellAppearance::SetPropHorizontalAlignment(CValue const& Value)
{
    if (m_pGridItem)
    {
        GET_ENUM_PROP(HorizTextAlignment, htaAuto, htaCenter);
        m_pGridItem->SetTextHAlign(_enum);
    }
    return TRUE;
}

BOOL CCellAppearance::GetPropImageIndex(CValue& Value)const
{
    if (m_pGridItem)
        Value = m_pGridItem->GetImageIndex();
    return TRUE;
}

BOOL CCellAppearance::SetPropImageIndex(CValue const& Value)
{
    if (m_pGridItem)
        m_pGridItem->SetImageIndex(Value.GetNumeric());
    return TRUE;
}

BOOL CCellAppearance::GetPropCheckValue(CValue& Value)const
{
    if (m_pGridItem)
        Value = m_pGridItem->GetCheckValue();
    return TRUE;
}

BOOL CCellAppearance::SetPropCheckValue(CValue const& Value)
{
    int nCheckValue = Value.GetNumeric();
    if (nCheckValue < 0 || nCheckValue > 2)
    {
        CBLModule::RaiseExtRuntimeError("  .", 0);
        return FALSE;
    }
    if (m_pGridItem)
        m_pGridItem->SetCheckValue(nCheckValue);
    return TRUE;
}

BOOL CCellAppearance::GetPropText(CValue& Value)const
{
    if (m_pGridItem)
        m_pGridItem->GetText();
    return TRUE;
}

BOOL CCellAppearance::SetPropText(CValue const& Value)
{
    if (m_pGridItem)
        m_pGridItem->SetText(Value.GetString());
    return TRUE;
}

BOOL CCellAppearance::GetPropTextColor(CValue& Value)const
{
    if (m_pGridItem)
        Value = GET_V7_COLOR(m_pGridItem->GetTextColor());
    return TRUE;
}

BOOL CCellAppearance::SetPropTextColor(CValue const& Value)
{
    if (m_pGridItem)
        m_pGridItem->SetTextColor(SET_V7_COLOR(Value));
    return TRUE;
}

BOOL CCellAppearance::GetPropBackColor(CValue& Value)const
{
    if (m_pGridItem)
        Value = GET_V7_COLOR(m_pGridItem->GetBackColor());
    return TRUE;
}

BOOL CCellAppearance::SetPropBackColor(CValue const& Value)
{
    if (m_pGridItem)
        m_pGridItem->SetBackColor(SET_V7_COLOR(Value));
    return TRUE;
}

BOOL CCellAppearance::GetPropFont(CValue& Value)const
{
    if (m_pGridItem)
        Value.AssignContext(m_pGridItem->m_pFont);
    return TRUE;
}

BOOL CCellAppearance::SetPropFont(CValue const& Value)
{
    if (m_pGridItem)
    {
        CHECK_BLTYPE(Value, CBLFont);
        m_pGridItem->m_pFont = static_cast<CBLFont*>(Value.GetContext());
        m_pGridItem->SetFont(*m_pGridItem->m_pFont);
    }
    return TRUE;
}

//////////////////////////////////////////////////////////////////////////
// class CGridCells
//////////////////////////////////////////////////////////////////////////

CGridCells::CGridCells()
{
}

CGridCells::~CGridCells()
{
}

int CGridCells::GetSize() const
{
    if (m_pColumns)
        return m_pColumns->GetSize();
    else
        return 0;
}

CCellAppearance* CGridCells::GetAt(int nIndex) const
{
    CGridColumn* pGridColumn = m_pColumns->GetAt(nIndex);
    if (pGridColumn)
        return static_cast<CV7GridColumn*>(pGridColumn)->m_pCellAppearance;
    else
        return NULL;
}

CCellAppearance* CGridCells::GetAt(LPCSTR szName) const
{
    CGridColumn* pGridColumn = m_pColumns->GetAt(szName);
    if (pGridColumn)
        return static_cast<CV7GridColumn*>(pGridColumn)->m_pCellAppearance;
    else
        return NULL;
}

int CGridCells::IndexOf(LPCSTR szName) const
{
    return m_pColumns->IndexOf(szName);
}

int CGridCells::IndexOf(CCellAppearance* pItemType) const
{
    return m_pColumns->IndexOf(pItemType->GetName());
}

void CGridCells::Attach(CV7GridRow* pV7GridRow)
{
    for (int i = 0; i < m_pColumns->GetSize(); i++)
        static_cast<CV7GridColumn*>(m_pColumns->GetAt(i))->m_pCellAppearance->m_pGridItem = static_cast<CV7GridItem*>(pV7GridRow->GetGridItem(i));
}

void CGridCells::Detach()
{
    for (int i = 0; i < m_pColumns->GetSize(); i++)
        static_cast<CV7GridColumn*>(m_pColumns->GetAt(i))->m_pCellAppearance->m_pGridItem = NULL;
}

//////////////////////////////////////////////////////////////////////////
// class CV7GridCells
//////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC(CV7GridCells, CBLContext);

//////////////////////////////////////////////////////////////////////////
// class CV7RowAppearance
//////////////////////////////////////////////////////////////////////////

BEGIN_BL_METH_MAP(CV7RowAppearance)
END_BL_METH_MAP()

BEGIN_BL_PROP_MAP(CV7RowAppearance)
    BL_PROP("RowData", "", GetPropRowData, NULL)
    BL_PROP("Cells", "", GetPropCells, NULL)
    BL_PROP("TextColor", "", GetPropTextColor, SetPropTextColor)
    BL_PROP("BackColor", "", GetPropBackColor, SetPropBackColor)
    BL_PROP("Font", "", GetPropFont, SetPropFont)
END_BL_PROP_MAP()

BEGIN_REG_NAMES(CV7RowAppearance)
END_REG_NAMES()

IMPLEMENT_MY_CONTEXT(CV7RowAppearance, "", NULL, NULL, -1);

CV7RowAppearance::CV7RowAppearance() : m_pV7DataProvider(NULL)
{
    m_pV7GridRow = NULL;
    m_pV7RowData.Create();
    m_pV7GridCells.Create();
}

CV7RowAppearance::~CV7RowAppearance()
{
    m_pV7GridCells->m_pColumns = NULL;
}

void CV7RowAppearance::Attach(CV7GridRow* pV7GridRow)
{
    if (m_pV7GridRow)
        Detach();

    m_pV7GridRow = pV7GridRow;
    m_pV7RowData->m_pDataRow = pV7GridRow->GetDataRow();
    if (m_pV7DataProvider)
        m_pV7RowData->m_pV7DataRow = m_pV7DataProvider->GetV7DataRow(pV7GridRow->GetDataRow());
    else
        m_pV7RowData->m_pV7DataRow = NULL;
    m_pV7GridCells->Attach(pV7GridRow);
}

void CV7RowAppearance::Detach()
{
    m_pV7GridCells->Detach();
    m_pV7RowData->m_pDataRow = NULL;
    m_pV7RowData->m_pV7DataRow = NULL;
    m_pV7GridRow = NULL;
}

BOOL CV7RowAppearance::GetPropRowData(CValue& Value)const
{
    Value.AssignContext(m_pV7RowData);
    return TRUE;
}

BOOL CV7RowAppearance::GetPropCells(CValue& Value)const
{
    Value.AssignContext(m_pV7GridCells);
    return TRUE;
}

BOOL CV7RowAppearance::GetPropTextColor(CValue& Value)const
{
    if (m_pV7GridRow)
        Value = GET_V7_COLOR(m_pV7GridRow->GetTextColor());
    return TRUE;
}

BOOL CV7RowAppearance::SetPropTextColor(CValue const& Value)
{
    if (m_pV7GridRow)
        m_pV7GridRow->SetTextColor(SET_V7_COLOR(Value));
    return TRUE;
}

BOOL CV7RowAppearance::GetPropBackColor(CValue& Value)const
{
    if (m_pV7GridRow)
        Value = GET_V7_COLOR(m_pV7GridRow->GetBackColor());
    return TRUE;
}

BOOL CV7RowAppearance::SetPropBackColor(CValue const& Value)
{
    if (m_pV7GridRow)
        m_pV7GridRow->SetBackColor(SET_V7_COLOR(Value));
    return TRUE;
}

BOOL CV7RowAppearance::GetPropFont(CValue& Value)const
{
    if (m_pV7GridRow)
        Value.AssignContext(m_pV7GridRow->m_pFont);
    return TRUE;
}

BOOL CV7RowAppearance::SetPropFont(CValue const& Value)
{
    if (m_pV7GridRow)
    {
        CHECK_BLTYPE(Value, CBLFont);
        m_pV7GridRow->m_pFont = static_cast<CBLFont*>(Value.GetContext());
        m_pV7GridRow->SetFont(*m_pV7GridRow->m_pFont);
    }
    return TRUE;
}
