
#include "StdAfx.h"
#include "V7ODBCProvider.h"
#include "../ODBC/MetaNameParser.h"

#define MIN_ROWCOUNT 20

extern CDataBase7* pDataBase7;
LPCSTR szClassNameEng = "ODBCDataProvider";
LPCSTR szClassNameRus = "ODBC";
LPCSTR ExtTypeNames[] =
{
    "MSSQL",
    "VFP",
    "MySQL",
    "Oracle",
};

//////////////////////////////////////////////////////////////////////////
// class CV7SelectListItem
//////////////////////////////////////////////////////////////////////////

BEGIN_BL_METH_MAP(CV7SelectListItem)
END_BL_METH_MAP()

BEGIN_BL_PROP_MAP(CV7SelectListItem)
    BL_PROP("Name", "", GetPropName, NULL)
    BL_PROP("AutoDelete", "", GetPropAutoDelete, SetPropAutoDelete)
END_BL_PROP_MAP()

BEGIN_REG_NAMES(CV7SelectListItem)
END_REG_NAMES()

IMPLEMENT_MY_CONTEXT(CV7SelectListItem, "ODBC", NULL, NULL, -1);

CV7SelectListItem::CV7SelectListItem(): m_rt(-1)
{
    m_AddType = eStandart;
}

CV7SelectListItem::~CV7SelectListItem()
{
}

BOOL CV7SelectListItem::GetPropName(CValue& Value) const
{
    Value = GetName();
    return TRUE;
}

BOOL CV7SelectListItem::GetPropAutoDelete(CValue& Value) const
{
    Value = GetAutoDelete();
    return TRUE;
}

BOOL CV7SelectListItem::SetPropAutoDelete(CValue const& Value)
{
    SetAutoDelete(Value.GetNumeric());
    return TRUE;
}

//////////////////////////////////////////////////////////////////////////
// class CV7SelectList
//////////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC(CV7SelectList, CBLContext);

//////////////////////////////////////////////////////////////////////////
// class CV7ODBCDataRow
//////////////////////////////////////////////////////////////////////////

CV7ODBCDataRow::CV7ODBCDataRow(CV7ODBCProvider* pV7ODBCProvider) : CSQLRow(pV7ODBCProvider)
{
    int nCount = CSQLRow::GetFieldCount();
    m_values.SetSize(nCount);
    for (int i = 0; i < nCount; i++)
        m_values[i] = new CValue;
}

CV7ODBCDataRow::~CV7ODBCDataRow()
{
    for (int i = 0; i < m_values.GetSize(); i++)
        delete m_values[i];
}

//CDataRow
DataType CV7ODBCDataRow::GetFieldType(int nIndex)
{
    switch (m_values[nIndex]->GetTypeCode())
    {
    case NUMBER_TYPE_1C:
        return dtNumeric;
    case DATE_TYPE_1C:
        return dtDate;
    }
    return dtText;
}

void CV7ODBCDataRow::FormatField(int nIndex, CString& strValue)
{
    FormatValue(*m_values[nIndex], strValue);
}

//CSQLRow

void CV7ODBCDataRow::SQLFormatField(int nIndex, CString& strValue)
{
    bool bIsStrLiteral;
    CString strSQLType;
    CValue* pVal = m_values[nIndex];

    int nModificator;
    switch (pVal->GetTypeCode())
    {
    case DATE_TYPE_1C:
        nModificator = 2;
        break;
    default:
        nModificator = 0;
    }

    CMetaNameParser::CValueToDBValue(*pVal, nModificator, strValue, bIsStrLiteral, strSQLType);
    
    if (pVal->GetTypeCode() == STRING_TYPE_1C)
        strValue.Replace("'", "''");

    if (bIsStrLiteral)
    {
        strValue.Insert(0, '\'');
        strValue += '\'';
    }
}

BOOL CV7ODBCDataRow::CompareFields(int nIndex, CSQLRow* pRow) const
{
    return *m_values[nIndex] == *static_cast<CV7ODBCDataRow*>(pRow)->m_values[nIndex];
}

//CV7DataRow

const CValue& CV7ODBCDataRow::GetValue(int nIndex) const
{
    return *m_values[nIndex];
};

//////////////////////////////////////////////////////////////////////////
// class CV7ODBCProvider
//////////////////////////////////////////////////////////////////////////

BEGIN_BL_METH_MAP(CV7ODBCProvider)
    BL_METH("SetOrderKey", "", 1, MethSetOrderKey, NULL, NULL)
    BL_METH("SetQueryText", "", 1, MethSetQueryText, NULL, NULL)
    BL_METH("SetCurrentRow", "", 1, MethSetCurrentRow, NULL, NULL)
END_BL_METH_MAP()

BEGIN_BL_PROP_MAP(CV7ODBCProvider)
    BL_PROP("Fields", "", GetPropFields, NULL)
    BL_PROP("Database", "", GetPropDatabase, SetPropDatabase)
    BL_PROP("QuickSearchType", "", GetPropQuickSearchType, SetPropQuickSearchType)
END_BL_PROP_MAP()

BEGIN_REG_NAMES(CV7ODBCProvider)
END_REG_NAMES()

IMPLEMENT_MY_CONTEXT(CV7ODBCProvider, NULL, InitTypes, NULL, -1);

CV7ODBCProvider::CV7ODBCProvider()
{
    m_RS.SetResultMode(rmFast);
    m_QuickSearchType = dtUndefined;
}

CV7ODBCProvider::~CV7ODBCProvider()
{
    ClearCurrentRow();
}

//Query rows interface
void CV7ODBCProvider::QueryRows(CDataRow* pRowFrom, int nRowsCount, int nPageSizeHint)
{
    if (!m_pDatabase)
    {
        m_strLastError = "   .";
        return;
    }

    int nCount = max(nPageSizeHint, MIN_ROWCOUNT);
    if (nRowsCount < 0)
        nCount = -nCount;

    CString strQT;
    if (!BuildQuery(strQT, static_cast<CSQLRow*>(pRowFrom), nCount))
        return;

    BOOL res = m_RS.Open(strQT);
    if (!res)
    {
        m_strLastError = m_RS.GetLastError();
        if (m_strLastError.GetLength())
            return;
    }
    else
        m_strLastError.Empty();
    SetV7Types();
}

CDataRow* CV7ODBCProvider::Fetch()
{
    if (!m_RS.m_sLastError.IsEmpty())
        return NULL;

    if (!m_RS.IsOpen() || m_RS.IsEof())
        return NULL;

    CV7ODBCDataRow* pV7ODBCDataRow = new CV7ODBCDataRow(this);
    for (int i = 0; i < GetSelectList()->GetSize(); i++)
        m_RS.SetValueOnDBField(m_RS[i], *pV7ODBCDataRow->m_values[i], true);

    m_RS.MoveNext();
    
    return static_cast<CSQLRow*>(pV7ODBCDataRow);
}

BOOL CV7ODBCProvider::RefreshRow(CDataRow* pRowFrom)
{
    if (!m_pDatabase)
    {
        m_strLastError = "   .";
        return FALSE;
    }

    CV7ODBCDataRow* pV7ODBCDataRow = static_cast<CV7ODBCDataRow*>(pRowFrom);
    
    CString strQT;
    if (!BuildQuery(strQT, pV7ODBCDataRow, 0))
        return FALSE;

    BOOL res = m_RS.Open(strQT);
    if (!res)
    {
        m_strLastError = m_RS.GetLastError();
        if (m_strLastError.GetLength())
            return FALSE;
    }
    else
        m_strLastError.Empty();
    
    if (m_RS.IsEof())
        return FALSE;

    SetV7Types();
    
    int i;
    for (i = 0; i < pV7ODBCDataRow->m_values.GetSize(); i++)
        delete pV7ODBCDataRow->m_values[i];

    pV7ODBCDataRow->m_values.SetSize(GetSelectList()->GetSize());
    for (i = 0; i < GetSelectList()->GetSize(); i++)
    {
        CValue* pValue = new CValue;
        m_RS.SetValueOnDBField(m_RS[i], *pValue, true);
        pV7ODBCDataRow->m_values[i] = pValue;
    }

    return TRUE;
}

void CV7ODBCProvider::OnAttach()
{
    if (m_CurrentRow.GetSize())
    {
        CV7ODBCDataRow Row(this);
        FillCurrentRow(&Row);
        ResetData(&Row);
    }
    else
        ResetData();
}

//CSQLProvider
BOOL CV7ODBCProvider::SetQuery(LPCSTR szQueryText)
{
    CMetaNameParser Parser;
    Parser.SetQueryText(szQueryText);
    try
    {
        Parser.Parse();
    }
    catch (CMNPException* pMNPException)
    {
        m_strLastError = "Meta name parser: " + pMNPException->GetErrorDescr();
        pMNPException->Delete();
        return FALSE;
    }

    return CSQLProvider::SetQuery(Parser.GetQueryText());
}

//CV7DataProvider
CV7DataRow* CV7ODBCProvider::GetV7DataRow(CDataRow* pDataRow) const
{
    return static_cast<CV7ODBCDataRow*>(pDataRow);
}

//CBLContext
void CV7ODBCProvider::InitTypes()
{
    CString str;
    for (int i = 0; i < qsLastStyle; i++)
    {
        str = szClassNameEng;
        str += '.';
        str += ExtTypeNames[i];
    	CBLContext::RegisterContextClass(RUNTIME_CLASS(CV7ODBCProvider), str, CType(100));
        str = szClassNameRus;
        str += '.';
        str += ExtTypeNames[i];
    	CBLContext::RegisterContextClass(RUNTIME_CLASS(CV7ODBCProvider), str, CType(100));
    }
}

void CV7ODBCProvider::InitObject(char const* szName)
{
    LPSTR szType = strchr(szName, '.');
    szType++;
    for (int i = 0; i < qsLastStyle; i++)
    {
        if (!stricmp(szType, ExtTypeNames[i]))
        {
            Init((QueryStyle)i);
            m_strType = szClassNameRus;
            m_strType += '.';
            m_strType += ExtTypeNames[i];
            break;
        }
    }
}

char const* CV7ODBCProvider::GetTypeString(void)const
{
    return m_strType;
}

BOOL CV7ODBCProvider::MethSetQueryText(CValue** ppValue)
{
    ClearCurrentRow();
    BOOL bSuccess = SetQuery(ppValue[0]->GetString());
    if (!bSuccess)
        CBLModule::RaiseExtRuntimeError(CSQLProvider::GetLastError(), 0);
    ResetData();
    return bSuccess;
}

BOOL CV7ODBCProvider::MethSetOrderKey(CValue** ppValue)
{
    ClearCurrentRow();
    BOOL bSuccess = SetOrderKey(ppValue[0]->GetString());
    if (!bSuccess)
        CBLModule::RaiseExtRuntimeError(CSQLProvider::GetLastError(), 0);
    ResetData();
    return bSuccess;
}

BOOL CV7ODBCProvider::MethSetCurrentRow(CValue** ppValue)
{
    if (ppValue[0]->GetTypeCode() != AGREGATE_TYPE_1C)
    {
        CBLModule::RaiseExtRuntimeError("  .", 0);
        return FALSE;
    }
    CBLContext* pBLObj = ppValue[0]->GetContext();
    ClearCurrentRow();

    BOOL bSuccess = TRUE;

    for (int i = 0; i < GetOrderKeyFieldCount(); i++)
    {
        CV7SelectListItem* pField = static_cast<CV7SelectListItem*>(GetOrderKeyField(i));

        int nPropIndex = pBLObj->FindProp(pField->GetName());
        if (nPropIndex == -1)
        {
            CString s;
            s.Format("     ""%s"".", pField->GetName());
            CBLModule::RaiseExtRuntimeError(s, 0);
            bSuccess = FALSE;
            break;
        }
        
        CValue* pValue = new CValue;
        m_CurrentRow.Add(pValue);

        if (!pBLObj->IsPropReadable(nPropIndex) || !pBLObj->GetPropVal(nPropIndex, *pValue))
        {
            CString s;
            s.Format("   ""%s"" .", pField->GetName());
            CBLModule::RaiseExtRuntimeError(s, 0);
            bSuccess = FALSE;
            break;
        }
    }

    if (!i)
    {
        CBLModule::RaiseExtRuntimeError("   .", 0);
        bSuccess = FALSE;
    }
    
    if (bSuccess)
    {
        HWND hWnd = GetControl();
        if (hWnd)
        {
            CV7ODBCDataRow Row(this);
            FillCurrentRow(&Row);
            SetCurrentRow(&Row);
        }
    }
    else
        ClearCurrentRow();

    return bSuccess;
}

BOOL CV7ODBCProvider::GetPropFields(CValue& Value) const
{
    Value.AssignContext(static_cast<CV7SelectList*>(GetSelectList()));
    return TRUE;
}

BOOL CV7ODBCProvider::GetPropDatabase(CValue& Value) const
{
    if (m_pDatabase)
        Value.AssignContext(m_pDatabase);
    return TRUE;
}

BOOL CV7ODBCProvider::SetPropDatabase(CValue const& Value)
{
    CHECK_BLTYPE(Value, C1CPP_ODBCDatabase);
    m_pDatabase = static_cast<C1CPP_ODBCDatabase*>(Value.GetContext());
    m_RS.SetDatabase(m_pDatabase);
    return TRUE;
}

BOOL CV7ODBCProvider::GetPropQuickSearchType(CValue& Value) const
{
    Value = m_QuickSearchType;
    return TRUE;
}

BOOL CV7ODBCProvider::SetPropQuickSearchType(CValue const& Value)
{
    GET_ENUM_PROP(DataType, dtUndefined, dtText);
    m_QuickSearchType = _enum;
    return TRUE;
}

void CV7ODBCProvider::ClearCurrentRow()
{
    for (int i = 0; i < m_CurrentRow.GetSize(); i++)
        delete m_CurrentRow[i];
    m_CurrentRow.RemoveAll();
}

void CV7ODBCProvider::FillCurrentRow(CV7ODBCDataRow* pV7ODBCDataRow)
{
    for (int i = 0; i < m_CurrentRow.GetSize(); i++)
        *pV7ODBCDataRow->m_values[i] = *m_CurrentRow[i];
}

void CV7ODBCProvider::OnFieldsChanged()
{
    CV7SelectList* pV7SelectList = static_cast<CV7SelectList*>(GetSelectList());
    for (int i = 0; i < pV7SelectList->GetSize(); i++)
    {
        CV7SelectListItem* pItem = static_cast<CV7SelectListItem*>(pV7SelectList->GetAt(i));
        if (pItem->m_AddType != eStandart)
        {
            CString strName(pItem->GetName());
            int AddFieldIndex = pV7SelectList->IndexOf(strName + KindSuffixEng);
            if (AddFieldIndex >= 0)
                pItem->m_AddFieldIndex = AddFieldIndex;
            else
                pItem->m_AddFieldIndex = pV7SelectList->IndexOf(strName + KindSuffixRus);

            if (pItem->m_AddType == eSbKind)
                static_cast<CV7SelectListItem*>(pV7SelectList->GetAt(pItem->m_AddFieldIndex))->m_rt.SetTypeCode(SUBCONTOKIND_TYPE_1C);
        }
    }

    CSQLProvider::OnFieldsChanged();
}

BOOL CV7ODBCProvider::OnAddToSelectList(CSelectListItem* pSelectListItem)
{
    if (*pSelectListItem->GetName() == '[')
    {
        CV7SelectListItem* pItem = static_cast<CV7SelectListItem*>(pSelectListItem);
        CString strName(pItem->GetName());
        strName.TrimLeft('[');
        strName.TrimRight(']');
        
        if (pDataBase7->GetDataSourceType() == DATA_SOURCE_TYPE_DBF)
            if (strName.Replace(TypeNamePrefix, "$"))
                strName.Replace('_', '.');

        if (!CODBCRecordset::ParseV7FieldType(strName, -1, pItem->m_rt, pItem->m_AddType, pItem->m_BLCTypeName))
        {
            m_strLastError.Format("    %s.", strName);
            return FALSE;
        }
        pItem->SetName(strName);
    }

    return TRUE;
}

DataType CV7ODBCProvider::GetQuickSearchType(LPCSTR szFieldName, LPCSTR* pszSearchField)
{
    if (!GetOrderKeyFieldCount())
        return dtUndefined;
    
    *pszSearchField = GetOrderKeyField(0)->GetName();
    return m_QuickSearchType;
}

void CV7ODBCProvider::QuickSearch(LPCSTR szFieldName, CString& strData)
{
    if (strData.IsEmpty())
        return;

    BOOL bSuccess;

    CString strQT;
    if (!BuildQuickSearchQuery(strQT, GetOrderKeyField(0)))
        return;

    bSuccess = m_RS.Prepare(strQT);

    if (!bSuccess)
    {
        strData.Empty();
        return;
    }

    bSuccess = m_RS.AddParam("", SQL_PARAM_INPUT, SQL_VARCHAR, CType(0), 100, 0);
    if (!bSuccess)
    {
        strData.Empty();
        return;
    }

    CDBField& param = m_RS.GetParam(0);
    int nBegin = 0, nCount = strData.GetLength(), nEnd;
    nEnd = nCount;
    bSuccess = FALSE;
    while (nCount && nBegin != nEnd)
    {
        CString strLike = strData.Left(nBegin + nCount);
        strLike += '%';
        param = strLike;
        bSuccess = m_RS.Open(NULL, FALSE, TRUE);
        LPCSTR err = m_RS.GetLastError();
        if (err[0])
        {
            m_strLastError = err;
            break;
        }

        if (bSuccess)
        {
            bSuccess = TRUE;
            nBegin += nCount;
            nCount = nEnd - nBegin;
        }
        else
            nEnd = nBegin + nCount;

        nCount /= 2;
    }
    
    strData = strData.Left(nBegin);

    if (bSuccess)
    {
        CV7ODBCDataRow Row(this);
        for (int i = 0; i < GetOrderKeyFieldCount(); i++)
        {
            CV7SelectListItem* pItem = static_cast<CV7SelectListItem*>(GetOrderKeyField(i));
            m_RS.SetValueOnDBField(m_RS[i], *Row.m_values[pItem->GetFieldIndex()]);
        }
        SetCurrentRow(&Row);
    }

    m_RS.Close();
}

void CV7ODBCProvider::SetV7Types()
{
    CDBField* pField = m_RS.GetFields();
    CV7SelectList* pV7SelectList = static_cast<CV7SelectList*>(GetSelectList());
    for (int i = 0; i < pV7SelectList->GetSize(); i++, pField++)
    {
        CV7SelectListItem* pItem = static_cast<CV7SelectListItem*>(pV7SelectList->GetAt(i));
        pField->m_rt = pItem->m_rt;
        pField->m_AddType = pItem->m_AddType;
        pField->m_AddFieldIndex = pItem->m_AddFieldIndex;
        pField->m_BLCTypeName = pItem->m_BLCTypeName;
    }
}
