//////////////////////////////////////////////////////////////////////
// V7ODBCProvider.h: interface for ODBC data provider for CursorGrid
// control for V7.
// Written by Dmitriy Oshchepkov aka DmitrO, mailto: dmitro@russian.ru
// Version: 1.0
//////////////////////////////////////////////////////////////////////

#pragma once

#include <afxcoll.h>
#include "SQLProvider.h"
#include "V7DataProvider.h"
#include "../mycontextbase.h"
#include "../BLCollection.h"
#include "../ODBC/1CPP_ODBCDatabase.h"
#include "../ODBC/1CPP_ODBCRecordset.h"

class CV7ODBCProvider;

class CV7SelectListItem : public CMyContextBase, public CSelectListItem
{
    friend class CV7ODBCProvider;
    DECLARE_DYNCREATE(CV7SelectListItem);
public:
    CV7SelectListItem();
    virtual ~CV7SelectListItem();

    BOOL GetPropName(CValue& Value) const;

    BOOL GetPropAutoDelete(CValue& Value) const;
    BOOL SetPropAutoDelete(CValue const& Value);

protected:
    virtual void Release() {DecrRef();};

	DECLARE_MY_CONTEXT()

private:
	CType m_rt;
    e1CAddType m_AddType;
    int m_AddFieldIndex;
    CString m_BLCTypeName;
};

class CV7SelectList : public CBLCollection<CSelectList, CV7SelectListItem, RUNTIME_CLASS(CV7SelectListItem), BLC_MODIFED>
{
    DECLARE_DYNAMIC(CV7SelectList);
public:
    CV7SelectList() {};
    virtual ~CV7SelectList() {};
protected:
    virtual void Release() {DecrRef();};
    virtual CSelectListItem* NewSelectListItem() {return new CV7SelectListItem;};
public:
    virtual char const* 	GetTypeString(void)const {return "ODBC";};
};

class CV7ODBCDataRow : public CSQLRow, public CV7DataRow
{
    friend class CV7ODBCProvider;
public:
    CV7ODBCDataRow(CV7ODBCProvider* pV7ODBCProvider);
    virtual ~CV7ODBCDataRow();

    //CDataRow
    virtual DataType GetFieldType(int nIndex);
    virtual void FormatField(int nIndex, CString& strValue);

    //CSQLRow
    virtual void SQLFormatField(int nIndex, CString& strValue);
    virtual BOOL CompareFields(int nIndex, CSQLRow* pRow) const;
    
    //CV7DataRow
    virtual const CValue& GetValue(int nIndex) const;
    
private:
    CTypedPtrArray<CPtrArray, CValue*> m_values;
};

class CV7ODBCProvider : public CMyContextBase, public CSQLProvider, public CV7DataProvider
{
    DECLARE_DYNCREATE(CV7ODBCProvider);
public:
    CV7ODBCProvider();
    virtual ~CV7ODBCProvider();
    
    //CDataProvider
    virtual void QueryRows(CDataRow* pRowFrom, int nRowsCount, int nPageSizeHint);
    virtual CDataRow* Fetch();
    virtual BOOL RefreshRow(CDataRow* pRowFrom);
    virtual void OnFieldsChanged();

    virtual DataType GetQuickSearchType(LPCSTR szFieldName, LPCSTR* pszSearchField);
    virtual void QuickSearch(LPCSTR szFieldName, CString& strData);
protected:
    virtual void OnAttach();

public:
    //CSQLProvider
    virtual BOOL SetQuery(LPCSTR szQueryText);

    //CV7DataProvider
    virtual CV7DataRow* GetV7DataRow(CDataRow* pDataRow) const;

    //CBLContext
    virtual void InitObject(char const* szName);
    virtual char const* GetTypeString(void) const;

    BOOL MethSetOrderKey(CValue** ppValue);
    BOOL MethSetQueryText(CValue** ppValue);
    BOOL MethSetCurrentRow(CValue** ppValue);

    BOOL GetPropFields(CValue& Value) const;

    BOOL GetPropDatabase(CValue& Value) const;
    BOOL SetPropDatabase(CValue const& Value);
    
    BOOL GetPropQuickSearchType(CValue& Value) const;
    BOOL SetPropQuickSearchType(CValue const& Value);

protected:
    virtual CSelectList* NewSelectList() {return new CV7SelectList;};
    virtual BOOL OnAddToSelectList(CSelectListItem* pSelectListItem);

    DECLARE_MY_CONTEXT()
private:
    CString m_strType;
    static void InitTypes();

    CBLPtr<C1CPP_ODBCDatabase> m_pDatabase;
    C1CPP_ODBCRecordSet m_RS;
    CTypedPtrArray<CPtrArray, CValue*> m_CurrentRow;
    void ClearCurrentRow();
    void FillCurrentRow(CV7ODBCDataRow* pV7ODBCDataRow);
    void SetV7Types();
    DataType m_QuickSearchType;
};
