# -*- coding: cp1251 -*-

import xml.parsers.expat



class xml2als:
	_isItem = 0

	def getHeader(self):
		return '{"Shell",'
	def getBottom(self):
		return '}\n'

	def getFolderHeader(self, Name):
		return '{"Folder","AST","'+Name+'","'+Name+'",\n'
	def getFolderBottom(self):
		return '},\n'
	def getItemHeader(self, Name):
		Result  = '{"Item","AST","'+Name+'","'+Name+'",\n' #    
		Result += '"'+Name+'","'+Name+'",\n' #     
		return Result
	def getItemBottom(self):
		return '},\n'
	def getItemContent(self, fName):
		t = file(fName, 'r')
		Result = '"'+t.read()+'",\n'
		t.close()
		return Result

	def StartElementHandler(self, name, attrs):
		if name == 'item':
			self._isItem = 1
			self._f.write(self.getItemHeader(attrs['name']))
		elif name == 'folder':
			self._f.write(self.getFolderHeader(attrs['name']))

		else:
			print 'Start unknown element:', name, attrs

	def EndElementHandler(self, name):
		if name == 'item':
			self._f.write(self.getItemBottom())
			self._isItem = 0
  
		elif name == 'folder':
			self._f.write(self.getFolderBottom())
		
		else:
			print 'End unknown element:', name

	def CharacterDataHandler(self, data):
		if self._isItem:
			self._f.write(self.getItemContent(data))

	def Init(self):
		self._f = file('index.als', 'w')
		self._f.write(self.getHeader())

	def Close(self):
		self._f.write(self.getBottom())
		self._f.close()

		

my = xml2als()
p = xml.parsers.expat.ParserCreate()
p.StartElementHandler = my.StartElementHandler
p.EndElementHandler = my.EndElementHandler
p.CharacterDataHandler = my.CharacterDataHandler


my.Init()
xml = file('index.xml', 'r')
p.ParseFile(xml)
xml.close()
my.Close()
