#include "stdafx.h"

#include "painthook.h"

extern CBkEndUI * pBkEndUI;
extern bool CreateInPlace;
extern CWnd* pWndSpl;

typedef int(CBLModule::*PF_FF)(char const * )const;
static BYTE* adrWrapFindFunc;
static PF_FF jmpWrapFindFunc;
static BYTE  origWrapFindFunc[6];
static BYTE  wrapWrapFindFunc[6];

typedef int(CBLModule::*PF_FP)(char const * ,int )const;
static BYTE* adrWrapFindProc;
static PF_FP jmpWrapFindProc;
static BYTE  origWrapFindProc[6];
static BYTE  wrapWrapFindProc[6];

typedef int(CBLModule::*PF_CAP)(int,int,class CValue * *);
static BYTE*  adrWrapCallAsProc;
static PF_CAP jmpWrapCallAsProc;
static BYTE   origWrapCallAsProc[6];
static BYTE   wrapWrapCallAsProc[6];

typedef int(CBLModule::*PF_CAF)(int,class CValue &,int,class CValue * *);
static BYTE*  adrWrapCallAsFunc;
static PF_CAF jmpWrapCallAsFunc;
static BYTE   origWrapCallAsFunc[6];
static BYTE   wrapWrapCallAsFunc[6];

#ifdef FORMEX_DLL

typedef int(CBLModule::*PF_Comp)(void);
static BYTE*   adrWrapCompile;
static PF_Comp jmpWrapCompile;
static BYTE    origWrapCompile[6];
static BYTE    wrapWrapCompile[6];

typedef void(CBLModule::*PF_AsComp)(class CBLModule const &);
static BYTE*   adrWrapAssignCompiled;
static PF_AsComp jmpWrapAssignCompiled;
static BYTE    origWrapAssignCompiled[6];
static BYTE    wrapWrapAssignCompiled[6];

typedef void(CBLModule::*PF_AsCont)(class CBLContext *);
static BYTE*   adrWrapAssignContext;
static PF_AsCont jmpWrapAssignContext;
static BYTE    origWrapAssignContext[6];
static BYTE    wrapWrapAssignContext[6];

#endif

typedef int(CGetDoc7::*PF_LF)(class CFrameWnd *,struct CCreateContext *);
static BYTE*   adrWrapOnCreateFrame;
static PF_LF jmpWrapOnCreateFrame;
static BYTE    origWrapOnCreateFrame[6];
static BYTE    wrapWrapOnCreateFrame[6];

typedef int(SECStatusBar::*PF_SI)(unsigned int const *,int);
static BYTE*   adrWrapSetIndicators;
static PF_SI jmpWrapSetIndicators;
static BYTE    origWrapSetIndicators[6];
static BYTE    wrapWrapSetIndicators[6];

typedef void(CGetDoc7::*PF_IFS)(void);
static BYTE*   adrInitFieldsState;
static PF_IFS jmpInitFieldsState;
static BYTE    origInitFieldsState[6];
static BYTE    wrapInitFieldsState[6];

typedef int(*PF_LWP)(CWnd *, char const*, int);
static BYTE*   adrLoadWindowPosition;
static PF_LWP jmpLoadWindowPosition;
//static DWORD jmpLoadWindowPosition;
static BYTE    origLoadWindowPosition[6];
static BYTE    wrapLoadWindowPosition[6];

typedef int(CGetDoc7::*PF_LayF)(class CFormView *);
static BYTE*   adrLayoutForm;
static PF_LayF jmpLayoutForm;
static BYTE    origLayoutForm[6];
static BYTE    wrapLayoutForm[6];

typedef int(CBrowse::*PF_GHTB)(int);
static BYTE*   adrGetHiTrackBound;
static PF_GHTB jmpGetHiTrackBound;
static BYTE    origGetHiTrackBound[6];
static BYTE    wrapGetHiTrackBound[6];

typedef int(CBrowse::*PF_GLTB)(int);
static BYTE*   adrGetLoTrackBound;
static PF_GLTB jmpGetLoTrackBound;
static BYTE    origGetLoTrackBound[6];
static BYTE    wrapGetLoTrackBound[6];

typedef class CWnd * (CGetDoc7::*PF_GDCC)(class CGetField *,unsigned int,class CRect const &,class CWnd *,unsigned long,unsigned long);
static BYTE*   adrCreateControl;
static PF_GDCC jmpCreateControl;
static BYTE    origCreateControl[6];
static BYTE    wrapCreateControl[6];

typedef int(CBLModule::*PF_GPI)(int,class CBLProcInfo &)const;
static BYTE* adrGetProcInfo;
static PF_GPI jmpGetProcInfo;
static BYTE  origGetProcInfo[6];
static BYTE  wrapGetProcInfo[6];

typedef int(CBLProcInfo::*PF_GNP)(void)const;
static BYTE* adrGetNParams;
static PF_GNP jmpGetNParams;
static BYTE  origGetNParams[6];
static BYTE  wrapGetNParams[6];

typedef struct HBRUSH__ *  (CDrawStatic::*PF_CC)(class CDC *,unsigned int);
static BYTE*   adrCtlColor;
static PF_CC   jmpCtlColor;
static BYTE    origCtlColor[6];
static BYTE    wrapCtlColor[6];

typedef void (*PF_DX_T)(class CGetExchange *,int,class CValue &);
static BYTE*   adrDX_Text;
static PF_DX_T jmpDX_Text;
static BYTE    origDX_Text[6];
static BYTE    wrapDX_Text[6];

struct CWrapModule::paramdefs CWrapModule::glFnNames[] = {
	{"","OnStartSystem",false,0},
	{"","OnFinishSystem",false,0},
	{"","OnDeleteItem",false,2},
	{"","OnOpenHistory",false,3},
	{"","OnWriteHistory",false,4},
	{"","OnDeleteHistory",false,4},
	{"","OnWriteConst",false,2},
	{"","OnDeleteDoc",false,2},
	{"","OnChangeTimeDoc",false,1},
	{"","OnUnPosting",false,1},
	{"","OnSetSelectInJournal",false,2},
	{"","OnDeleteAccount",false,2},
	{"","OnOperEntryOffOn",false,1},
	{"","OnPeriodChange",false,2},
	{"","SheetCellProcessing",true,4},
	{NULL,NULL}
};

int CWrapModule::FindFunction(char const * lpFnName)const
{
	int i;

	for (i = 0;glFnNames[i].rusName != NULL;i++){
		if (!stricmp(lpFnName,glFnNames[i].rusName))
			return i;
		if (!stricmp(lpFnName,glFnNames[i].engName))
			return i;
	}
	return -1;
};

static bool bCallSysProc = false;
static bool bCallSysProcEx = false;

int  CWrapModule::WrapGetProcInfo(int nProc, class CBLProcInfo & cProcInfo)const
{
	int ret = 0;
	BYTE* adr1 = adrGetProcInfo;
	for(int i = 0; i<6;i++) *adr1++ = origGetProcInfo[i];

	if((GetGlobalModule() == (CBLModule*)this) && bCallSysProc)
	{
		cProcInfo.m_Module = (CBLModule*)this;
		cProcInfo.m_ProcID = (ULONG) -nProc;
		ret = 1;
	}
	else
		ret = ((CBLModule*)this)->GetProcInfo(nProc, cProcInfo);

	adr1 = adrGetProcInfo;
	for(i = 0; i<6;i++) *adr1++ = wrapGetProcInfo[i];

	return ret;
}

int  CWrapModule::WrapGetNParams()const
{
	int ret = 0;
	BYTE* adr1 = adrGetNParams;
	for(int i = 0; i<6;i++) *adr1++ = origGetNParams[i];

	CBLProcInfo* This = (CBLProcInfo*)this;
	if((GetGlobalModule() == This->m_Module) && bCallSysProc)
	{
		ret = glFnNames[-((int)This->m_ProcID)].ParamsNum;
	}
	else
		ret = ((CBLProcInfo*)this)->GetNParams();

	adr1 = adrGetNParams;
	for(i = 0; i<6;i++) *adr1++ = wrapGetNParams[i];

	return ret;
}

int  CWrapModule::WrapFindFunc(char const * fName)const
{
	int ret = 0;
	BYTE* adr1 = adrWrapFindFunc;
	for(int i = 0; i<6;i++) *adr1++ = origWrapFindFunc[i];

	int nProcNum = FindFunction(fName);
	if((GetGlobalModule() == (CBLModule*)this) && !bCallSysProc && !bCallSysProcEx && (nProcNum >= 0))
	{
		BYTE* adr1_ = adrWrapCallAsFunc;
		for(int i_ = 0; i_<6;i_++) *adr1_++ = wrapWrapCallAsFunc[i_];
		bCallSysProc = true;
		ret = nProcNum;
	}
	else
		ret = ((CBLModule*)this)->FindFunc(fName);

	adr1 = adrWrapFindFunc;
	for(i = 0; i<6;i++) *adr1++ = wrapWrapFindFunc[i];

	return ret;
}

int  CWrapModule::WrapFindProc(char const * pName,int flag)const
{
	int ret = 0;
	BYTE* adr1 = adrWrapFindProc;
	for(int i = 0; i<6;i++) *adr1++ = origWrapFindProc[i];

	int nProcNum = FindFunction(pName);
	if((GetGlobalModule() == (CBLModule*)this) && !bCallSysProc && !bCallSysProcEx && (nProcNum >= 0))
	{
		BYTE* adr1_ = adrWrapCallAsProc;
		for(int i_ = 0; i_<6;i_++) *adr1_++ = wrapWrapCallAsProc[i_];
		bCallSysProc = true;
		ret = nProcNum;
	}
	else
		ret = ((CBLModule*)this)->FindProc(pName,flag);

	adr1 = adrWrapFindProc;
	for(i = 0; i<6;i++) *adr1++ = wrapWrapFindProc[i];

	return ret;
}

int CWrapModule::WrapCallAsFunc(int num,class CValue & retValue,int argNum,class CValue * * ppValue)
{
	int ret = 0;
	BYTE* adr1 = adrWrapCallAsFunc;
	for(int i = 0; i<6;i++) *adr1++ = origWrapCallAsFunc[i];
	
	if(bCallSysProc)
	{
		bCallSysProc = false;
		bCallSysProcEx = true;
		argNum = glFnNames[num].ParamsNum;
		if(glFnNames[num].HasFSO)
			*(ppValue[1]) = 0L;
		BOOL res = _CallFromGlobalModules(NULL,
								NULL,
								glFnNames[num].rusName,
								glFnNames[num].engName,
								argNum,
								ppValue,
								true);

		if(glFnNames[num].HasFSO)
		{
			if(res)
			{
				if(ppValue[1]->GetNumeric() != 0)
					ret = 0;
				else
					ret = 1;
			}
			else
				ret = 0;
		}
		else
			ret = 1;

		bCallSysProcEx = false;
	}
	else
		ret = ((CBLModule*)this)->CallAsFunc(num,retValue,argNum,ppValue);

	adr1 = adrWrapCallAsFunc;
	for(i = 0; i<6;i++) *adr1++ = wrapWrapCallAsFunc[i];

	return ret;
}

int CWrapModule::WrapCallAsProc(int num,int argNum,class CValue * * ppValue)
{
	int ret = 0;
	BYTE* adr1 = adrWrapCallAsProc;
	for(int i = 0; i<6;i++) *adr1++ = origWrapCallAsProc[i];
//
//	CBLModule* This = (CBLModule*)this;
//	CBLProcInfo ProcInfo;
//	This->GetProcInfo(num, ProcInfo);
//	pBkEndUI->DoMessageLine(CString("CallAsProc PROCEDURE: ")+ProcInfo.GetName());
//
	if(bCallSysProc)
	{
		bCallSysProc = false;
		bCallSysProcEx = true;
		argNum = glFnNames[num].ParamsNum;
		if(glFnNames[num].HasFSO)
			*(ppValue[1]) = 0L;
		BOOL res = _CallFromGlobalModules(NULL,
								NULL,
								glFnNames[num].rusName,
								glFnNames[num].engName,
								argNum,
								ppValue,
								true);
		if(glFnNames[num].HasFSO)
		{
			if(res)
			{
				if(ppValue[1]->GetNumeric() != 0)
					ret = 0;
				else
					ret = 1;
			}
			else
				ret = 0;
		}
		else
			ret = 1;
		bCallSysProcEx = false;
	}
	else
		ret = ((CBLModule*)this)->CallAsProc(num,argNum,ppValue);

	adr1 = adrWrapCallAsProc;
	for(i = 0; i<6;i++) *adr1++ = wrapWrapCallAsProc[i];

	return ret;
}

#ifdef FORMEX_DLL

int  CWrapModule::WrapCompile(void)
{
	int ret = 0;
	BYTE* adr1 = adrWrapCompile;
	for(int i = 0; i<6;i++) *adr1++ = origWrapCompile[i];

//	pBkEndUI->DoMessageLine(((CBLModule*)this)->pIntInfo->mSource);

	ret= ((CBLModule*)this)->Compile();
	adr1 = adrWrapCompile;
	for(i = 0; i<6;i++) *adr1++ = wrapWrapCompile[i];
	return ret;
}

void  CWrapModule::WrapAssignCompiled(class CBLModule const & Mod)
{
	BYTE* adr1 = adrWrapAssignCompiled;
	for(int i = 0; i<6;i++) *adr1++ = origWrapAssignCompiled[i];
	((CBLModule*)this)->AssignCompiled(Mod);
	adr1 = adrWrapAssignCompiled;
	for(i = 0; i<6;i++) *adr1++ = wrapWrapAssignCompiled[i];
}

void  CWrapModule::WrapAssignContext(class CBLContext * pCont)
{
	if(pCont)
//		if(!pCont->GetLoadedID())
			if(CString("CGroupContext") == pCont->GetRuntimeClass()->m_lpszClassName)
				pCont->m_FlagAutoDestroy=(int)this;

	BYTE* adr1 = adrWrapAssignContext;
	for(int i = 0; i<6;i++) *adr1++ = origWrapAssignContext[i];
	((CBLModule*)this)->AssignContext(pCont);
	adr1 = adrWrapAssignContext;
	for(i = 0; i<6;i++) *adr1++ = wrapWrapAssignContext[i];
}

#endif

union PtrC{
	void* pV;
	PF_LF pLF;
	PF_GHTB pGHTB;
	PF_GLTB pGLTB;
	PF_LayF pLalF;
	PF_CC pCC;
} conv;

int  CWrapModule::WrapOnCreateFrame(class CFrameWnd * pParent,struct CCreateContext * pCreateCont)
{
	int ret = 0;
	BYTE* adr1 = adrWrapOnCreateFrame;
	for(int i = 0; i<6;i++) *adr1++ = origWrapOnCreateFrame[i];

	conv.pV = adrWrapOnCreateFrame;
	ret= (((CGetDoc7*)this)->*conv.pLF)(pParent,pCreateCont);
	
	adr1 = adrWrapOnCreateFrame;
	for(i = 0; i<6;i++) *adr1++ = wrapWrapOnCreateFrame[i];

	return ret;
}

int  CWrapModule::WrapSetIndicators(unsigned int const * num1,int num2)
{
	return 1;
}

void CWrapModule::WrapInitFieldsState ()
{
	//--------------------------------------------------
	CGetDoc7 *RealThis = reinterpret_cast<CGetDoc7*>(this);
	BYTE* adr1 = adrInitFieldsState;
	for(int i = 0; i<6;i++) *adr1++ = origInitFieldsState[i];
	RealThis -> InitFieldsState ();
	adr1 = adrInitFieldsState;
	for(i = 0; i<6;i++) *adr1++ = wrapInitFieldsState[i];
	//--------------------------------------------------
	
	/*
	CWnd *pWnd = RealThis -> GetFrame ();
	if (pWnd && !pWnd -> IsKindOf (&CTabFrame::classCTabFrame))
//		RUNTIME_CLASS_RM("CTabFrame")))
		_CallModuleProc(RealThis,"","OnActivate",0,NULL);
		//CallAfterOpen (RealThis);
	*/
}

//int CWrapModule::WrapLoadWindowPosition(CWnd *pWnd, char const *sz, int i)
int WrapLoadWindowPosition(CWnd *pWnd, char const *sz, int i)
{
	//--------------------------------------------------
	BYTE* adr1 = adrLoadWindowPosition;
	for(int f = 0; f<6;f++) *adr1++ = origLoadWindowPosition[f];
	int ret = LoadWindowPosition (pWnd, sz, i);
	adr1 = adrLoadWindowPosition;
	for(f = 0; f<6;f++) *adr1++ = wrapLoadWindowPosition[f];
	//--------------------------------------------------

	/*
	CDocument *pDoc = NULL;

	if (
		pWnd
		&& pWnd -> IsKindOf (&CTabFrame::classCTabFrame)
		//RUNTIME_CLASS_RM ("CTabFrame"))
		&& (pDoc = reinterpret_cast<CTabFrame*> (pWnd) -> GetActiveDocument ())
		&& pDoc -> GetRuntimeClass () -> IsDerivedFrom (&CGetDoc7::classCGetDoc7)
		//RUNTIME_CLASS_RM ("CGetDoc7"))
		)
		_CallModuleProc(reinterpret_cast<CGetDoc7*>(pDoc),"","OnActivate",0,NULL);
		//CallAfterOpen (reinterpret_cast<CGetDoc7*>(pDoc));
	*/
	return ret;
}

int  CWrapModule::WrapLayoutForm(class CFormView * pFormView)
{
	int ret = 0;
	BYTE* adr1 = adrLayoutForm;
	for(int i = 0; i<6;i++) *adr1++ = origLayoutForm[i];

	conv.pV = adrLayoutForm;
	ret = (((CGetDoc7*)this)->*(conv.pLalF))(pFormView);

	_CallModuleProc(reinterpret_cast<CGetDoc7*>(this),"","OnActivate",0,NULL);

	adr1 = adrLayoutForm;
	for(i = 0; i<6;i++) *adr1++ = wrapLayoutForm[i];

	return ret;
}

int  CWrapModule::WrapGetHiTrackBound(int iNum)
{
	int ret = 0;
	BYTE* adr1 = adrGetHiTrackBound;
	for(int i = 0; i<6;i++) *adr1++ = origGetHiTrackBound[i];

	/*
	UINT uFlag = ((DWORD*)this)[0x27];
	if(uFlag == 0)
	{
		CRect cRect;
		((CBrowse*)this)->GetCellRect(cRect,0,iNum);
		ret = cRect.right+1;
	}
	else
	{
		conv.pV = adrGetHiTrackBound;
		ret = (((CBrowse*)this)->*(conv.pGHTB))(iNum);
	}
	*/
		conv.pV = adrGetHiTrackBound;
		ret = (((CBrowse*)this)->*(conv.pGHTB))(iNum);

	adr1 = adrGetHiTrackBound;
	for(i = 0; i<6;i++) *adr1++ = wrapGetHiTrackBound[i];

	return ret;
}

int  CWrapModule::WrapGetLoTrackBound(int iNum)
{
	int ret = 0;
	BYTE* adr1 = adrGetLoTrackBound;
	for(int i = 0; i<6;i++) *adr1++ = origGetLoTrackBound[i];

	/*
	UINT uFlag = ((DWORD*)this)[0x27];
	if(uFlag == 0)
	{
		CRect cRect;
		((CBrowse*)this)->GetCellRect(cRect,0,iNum);
		ret = cRect.right+1;
	}
	else
	{
		conv.pV = adrGetLoTrackBound;
		ret = (((CBrowse*)this)->*(conv.pGLTB))(iNum);
	}
	*/
		conv.pV = adrGetLoTrackBound;
		ret = (((CBrowse*)this)->*(conv.pGLTB))(iNum);

	adr1 = adrGetLoTrackBound;
	for(i = 0; i<6;i++) *adr1++ = wrapGetLoTrackBound[i];

	return ret;
}

HBRUSH CWrapModule::WrapCtlColor(class CDC * pDC,unsigned int uID)
{
	HBRUSH ret = NULL;
	BYTE* adr1 = adrCtlColor;
	for(int i = 0; i<6;i++) *adr1++ = origCtlColor[i];

	//TEXTMETRIC Metrics;
	//pDC->GetOutputTextMetrics(&Metrics);
	//pDC->m_hAttribDC

	CDrawStatic* This = (CDrawStatic*)this;
	CFont* pFont = This->GetFont();
	LOGFONT lFont;
	::GetObject(pFont->m_hObject, sizeof(LOGFONT), (LPSTR)&lFont);

//	CString str;
//	This->GetWindowText(str);
//	if(IsTextUnicode((void *const)LPCSTR(str),str.GetLength(), NULL) == 0)
//	{
//		WCHAR buf[1024];
//		MultiByteToWideChar(CP_ACP,MB_COMPOSITE,str,str.GetLength(),(LPWSTR)&buf,1024);
//		This->SetWindowText((const char*)&buf);
//	}
	//CFont* pFont = This->GetFont();
	//pDC->SelectObject(pFont);

	//pDC->GetOutputTextMetrics(&Metrics);

	conv.pV = adrCtlColor;
	ret = (This->*(conv.pCC))(pDC, uID);

	adr1 = adrCtlColor;
	for(i = 0; i<6;i++) *adr1++ = wrapCtlColor[i];

	return ret;
}

class CWnd * CWrapModule::WrapCreateControl(class CGetField * pGetField,unsigned int id,class CRect const & rect,class CWnd * pParent,unsigned long style,unsigned long styleex)
{
	CControlID* set = pGetField->m_Set;
	CWnd * ret = 0;
	BYTE* adr1 = adrCreateControl;
	for(int i = 0; i<6;i++) *adr1++ = origCreateControl[i];
	ret = ((CGetDoc7*)this)->CreateControl(pGetField,id,rect,pParent,style,styleex);
	adr1 = adrCreateControl;
	for(i = 0; i<6;i++) *adr1++ = wrapCreateControl[i];
	return ret;
}

void DX_TextWrap(class CGetExchange * pGet,int iID,class CValue & cVal)
{
	BYTE* adr1 = adrDX_Text;
	for(int i = 0; i<6;i++) *adr1++ = origDX_Text[i];

	DX_Text(pGet,iID,cVal);
	if(pGet)
	{
		CGetCtrl* pCtrl = pGet->PrepareControl(iID);
		if(pCtrl)
		{
			CWnd* pWnd = pCtrl->GetDlgItem();
			if(pWnd)
				pWnd->Invalidate();
		}
	}

	adr1 = adrDX_Text;
	for(i = 0; i<6;i++) *adr1++ = wrapDX_Text[i];
}

CWrapModule::CWrapModule()
{

	DWORD old;
	HINSTANCE hBr32=GetModuleHandle("br32.dll");
	HINSTANCE hBl=GetModuleHandle("blang.dll");
	HINSTANCE hBas=GetModuleHandle("basic.dll");
	HINSTANCE hFrame=GetModuleHandle("frame.dll");
	HINSTANCE hSev=GetModuleHandle("seven.dll");
	HINSTANCE hBk=GetModuleHandle("bkend.dll");
	BYTE* adr1;
	int i;
//?Compile@CBLModule@@QAEHXZ
	/*
	adr1=(BYTE*)GetProcAddress(hBl,"?Compile@CBLModule@@QAEHXZ");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpWrapCompile=(PF_Comp)WrapCompile;
	adrWrapCompile = adr1;
	for(i = 0; i<6;i++) origWrapCompile[i] = *adr1++;
	adr1 = adrWrapCompile;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpWrapCompile;
	adr1 = adrWrapCompile;
	for(i = 0; i<6;i++) wrapWrapCompile[i] = *adr1++;
	*/

//?OnCreateFrame@CGetDoc7@@UAEHPAVCFrameWnd@@PAUCCreateContext@@@Z
	adr1=(BYTE*)GetProcAddress(hBas,"?OnCreateFrame@CGetDoc7@@UAEHPAVCFrameWnd@@PAUCCreateContext@@@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpWrapOnCreateFrame=(PF_LF)WrapOnCreateFrame;
	adrWrapOnCreateFrame = adr1;
	for(i = 0; i<6;i++) origWrapOnCreateFrame[i] = *adr1++;
	adr1 = adrWrapOnCreateFrame;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpWrapOnCreateFrame;
	adr1 = adrWrapOnCreateFrame;
	for(i = 0; i<6;i++) wrapWrapOnCreateFrame[i] = *adr1++;

#ifdef FORMEX_DLL
//?AssignCompiled@CBLModule@@QAEXABV1@@Z
	/*adr1=(BYTE*)GetProcAddress(hBl,"?AssignCompiled@CBLModule@@QAEXABV1@@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpWrapAssignCompiled=(PF_AsComp)WrapAssignCompiled;
	adrWrapAssignCompiled = adr1;
	for(i = 0; i<6;i++) origWrapAssignCompiled[i] = *adr1++;
	adr1 = adrWrapAssignCompiled;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpWrapAssignCompiled;
	adr1 = adrWrapAssignCompiled;
	for(i = 0; i<6;i++) wrapWrapAssignCompiled[i] = *adr1++;*/

//?AssignContext@CBLModule@@QAEXPAVCBLContext@@@Z
	adr1=(BYTE*)GetProcAddress(hBl,"?AssignContext@CBLModule@@QAEXPAVCBLContext@@@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpWrapAssignContext=(PF_AsCont)WrapAssignContext;
	adrWrapAssignContext = adr1;
	for(i = 0; i<6;i++) origWrapAssignContext[i] = *adr1++;
	adr1 = adrWrapAssignContext;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpWrapAssignContext;
	adr1 = adrWrapAssignContext;
	for(i = 0; i<6;i++) wrapWrapAssignContext[i] = *adr1++;
#endif

//?SetIndicators@SECStatusBar@@QAEHPBIH@Z
	adr1=(BYTE*)GetProcAddress(hFrame,"?SetIndicators@SECStatusBar@@QAEHPBIH@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpWrapSetIndicators=(PF_SI)WrapSetIndicators;
	adrWrapSetIndicators = adr1;
	for(i = 0; i<6;i++) origWrapSetIndicators[i] = *adr1++;
	adr1 = adrWrapSetIndicators;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpWrapSetIndicators;
	adr1 = adrWrapSetIndicators;
	for(i = 0; i<6;i++) wrapWrapSetIndicators[i] = *adr1++;

//?InitFieldsState@CGetDoc7@@QAEXXZ
	adr1=(BYTE*)GetProcAddress(hBas,"?InitFieldsState@CGetDoc7@@QAEXXZ");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpInitFieldsState=(PF_IFS)WrapInitFieldsState;
	adrInitFieldsState = adr1;
	for(i = 0; i<6;i++) origInitFieldsState[i] = *adr1++;
	adr1 = adrInitFieldsState;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpInitFieldsState;
	adr1 = adrInitFieldsState;
	for(i = 0; i<6;i++) wrapInitFieldsState[i] = *adr1++;

//?LoadWindowPosition@@YAHPAVCWnd@@PBDH@Z
	adr1=(BYTE*)GetProcAddress(hFrame,"?LoadWindowPosition@@YAHPAVCWnd@@PBDH@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpLoadWindowPosition=(PF_LWP)WrapLoadWindowPosition;
	//jmpLoadWindowPosition=*(DWORD*)WrapLoadWindowPosition;
	adrLoadWindowPosition = adr1;
	for(i = 0; i<6;i++) origLoadWindowPosition[i] = *adr1++;
	adr1 = adrLoadWindowPosition;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpLoadWindowPosition;
	adr1 = adrLoadWindowPosition;
	for(i = 0; i<6;i++) wrapLoadWindowPosition[i] = *adr1++;

//?LayoutForm@CGetDoc7@@UAEHPAVCFormView@@@Z
	adr1=(BYTE*)GetProcAddress(hBas,"?LayoutForm@CGetDoc7@@UAEHPAVCFormView@@@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpLayoutForm=(PF_LayF)WrapLayoutForm;
	adrLayoutForm = adr1;
	for(i = 0; i<6;i++) origLayoutForm[i] = *adr1++;
	adr1 = adrLayoutForm;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpLayoutForm;
	adr1 = adrLayoutForm;
	for(i = 0; i<6;i++) wrapLayoutForm[i] = *adr1++;

//?CallAsFunc@CBLModule@@QAEHHAAVCValue@@HPAPAV2@@Z
	adr1=(BYTE*)GetProcAddress(hBl,"?CallAsFunc@CBLModule@@QAEHHAAVCValue@@HPAPAV2@@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpWrapCallAsFunc=(PF_CAF)WrapCallAsFunc;
	adrWrapCallAsFunc = adr1;
	for(i = 0; i<6;i++) origWrapCallAsFunc[i] = *adr1++;
	adr1 = adrWrapCallAsFunc;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpWrapCallAsFunc;
	adr1 = adrWrapCallAsFunc;
	for(i = 0; i<6;i++) wrapWrapCallAsFunc[i] = *adr1++;

//?CallAsProc@CBLModule@@QAEHHHPAPAVCValue@@@Z
	adr1=(BYTE*)GetProcAddress(hBl,"?CallAsProc@CBLModule@@QAEHHHPAPAVCValue@@@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpWrapCallAsProc=(PF_CAP)WrapCallAsProc;
	adrWrapCallAsProc = adr1;
	for(i = 0; i<6;i++) origWrapCallAsProc[i] = *adr1++;
	adr1 = adrWrapCallAsProc;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpWrapCallAsProc;
	adr1 = adrWrapCallAsProc;
	for(i = 0; i<6;i++) wrapWrapCallAsProc[i] = *adr1++;

//?FindProc@CBLModule@@QBEHPBDH@Z
	adr1=(BYTE*)GetProcAddress(hBl,"?FindProc@CBLModule@@QBEHPBDH@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpWrapFindProc=(PF_FP)WrapFindProc;
	adrWrapFindProc = adr1;
	for(i = 0; i<6;i++) origWrapFindProc[i] = *adr1++;
	adr1 = adrWrapFindProc;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpWrapFindProc;
	adr1 = adrWrapFindProc;
	for(i = 0; i<6;i++) wrapWrapFindProc[i] = *adr1++;

//?FindFunc@CBLModule@@QBEHPBD@Z
	adr1=(BYTE*)GetProcAddress(hBl,"?FindFunc@CBLModule@@QBEHPBD@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpWrapFindFunc=(PF_FF)WrapFindFunc;
	adrWrapFindFunc = adr1;
	for(i = 0; i<6;i++) origWrapFindFunc[i] = *adr1++;
	adr1 = adrWrapFindFunc;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpWrapFindFunc;
	adr1 = adrWrapFindFunc;
	for(i = 0; i<6;i++) wrapWrapFindFunc[i] = *adr1++;

//?GetHiTrackBound@CBrowse@@IAEHH@Z
	adr1=(BYTE*)GetProcAddress(hBr32,"?GetHiTrackBound@CBrowse@@IAEHH@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpGetHiTrackBound=(PF_GHTB)WrapGetHiTrackBound;
	adrGetHiTrackBound = adr1;
	for(i = 0; i<6;i++) origGetHiTrackBound[i] = *adr1++;
	adr1 = adrGetHiTrackBound;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpGetHiTrackBound;
	adr1 = adrGetHiTrackBound;
	for(i = 0; i<6;i++) wrapGetHiTrackBound[i] = *adr1++;

//?GetLoTrackBound@CBrowse@@IAEHH@Z
	adr1=(BYTE*)GetProcAddress(hBr32,"?GetLoTrackBound@CBrowse@@IAEHH@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpGetLoTrackBound=(PF_GLTB)WrapGetLoTrackBound;
	adrGetLoTrackBound = adr1;
	for(i = 0; i<6;i++) origGetLoTrackBound[i] = *adr1++;
	adr1 = adrGetLoTrackBound;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpGetLoTrackBound;
	adr1 = adrGetLoTrackBound;
	for(i = 0; i<6;i++) wrapGetLoTrackBound[i] = *adr1++;

//?CtlColor@CDrawStatic@@IAEPAUHBRUSH__@@PAVCDC@@I@Z
	adr1=(BYTE*)GetProcAddress(hSev,"?CtlColor@CDrawStatic@@IAEPAUHBRUSH__@@PAVCDC@@I@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpCtlColor=(PF_CC)WrapCtlColor;
	adrCtlColor = adr1;
	for(i = 0; i<6;i++) origCtlColor[i] = *adr1++;
	adr1 = adrCtlColor;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpCtlColor;
	adr1 = adrCtlColor;
	for(i = 0; i<6;i++) wrapCtlColor[i] = *adr1++;

//?_GetBaseMessageMap@CDrawStatic@@KGPBUAFX_MSGMAP@@XZ
	adr1=(BYTE*)GetProcAddress(hSev,"?messageMap@CDrawStatic@@1UAFX_MSGMAP@@B");
	VirtualProtect(adr1,4,PAGE_EXECUTE_READWRITE,&old);
	*(DWORD*)adr1 = (DWORD)&CDrawStaticWrap::pubGetMessageMap;

//?DX_Text@@YAXPAVCGetExchange@@HAAVCValue@@@Z
	adr1=(BYTE*)GetProcAddress(hBk,"?DX_Text@@YAXPAVCGetExchange@@HAAVCValue@@@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpDX_Text=(PF_DX_T)DX_TextWrap;
	adrDX_Text = adr1;
	for(i = 0; i<6;i++) origDX_Text[i] = *adr1++;
	adr1 = adrDX_Text;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpDX_Text;
	adr1 = adrDX_Text;
	for(i = 0; i<6;i++) wrapDX_Text[i] = *adr1++;

//?GetProcInfo@CBLModule@@QBEHHAAVCBLProcInfo@@@Z
	adr1=(BYTE*)GetProcAddress(hBl,"?GetProcInfo@CBLModule@@QBEHHAAVCBLProcInfo@@@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpGetProcInfo=(PF_GPI)WrapGetProcInfo;
	adrGetProcInfo = adr1;
	for(i = 0; i<6;i++) origGetProcInfo[i] = *adr1++;
	adr1 = adrGetProcInfo;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpGetProcInfo;
	adr1 = adrGetProcInfo;
	for(i = 0; i<6;i++) wrapGetProcInfo[i] = *adr1++;

//?GetNParams@CBLProcInfo@@QBEHXZ
	adr1=(BYTE*)GetProcAddress(hBl,"?GetNParams@CBLProcInfo@@QBEHXZ");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpGetNParams=(PF_GNP)WrapGetNParams;
	adrGetNParams = adr1;
	for(i = 0; i<6;i++) origGetNParams[i] = *adr1++;
	adr1 = adrGetNParams;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpGetNParams;
	adr1 = adrGetNParams;
	for(i = 0; i<6;i++) wrapGetNParams[i] = *adr1++;

	/*
//?CreateControl@CGetDoc7@@QAEPAVCWnd@@PAVCGetField@@IABVCRect@@PAV2@KK@Z
	adr1=(BYTE*)GetProcAddress(hBas,"?CreateControl@CGetDoc7@@QAEPAVCWnd@@PAVCGetField@@IABVCRect@@PAV2@KK@Z");
	VirtualProtect(adr1,6,PAGE_EXECUTE_READWRITE,&old);

	jmpCreateControl=(PF_GDCC)WrapCreateControl;
	adrCreateControl = adr1;
	for(i = 0; i<6;i++) origCreateControl[i] = *adr1++;
	adr1 = adrCreateControl;
	*adr1++=0xFF;
	*adr1++=0x25;
	*(DWORD*)adr1=(DWORD)&jmpCreateControl;
	adr1 = adrCreateControl;
	for(i = 0; i<6;i++) wrapCreateControl[i] = *adr1++;
	*/
}

BEGIN_MESSAGE_MAP(CDrawStaticWrap, CWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

   // Map "Static Styles" to "Text Styles"
#define MAP_STYLE(src, dest) if(dwStyle & (src)) dwText |= (dest)
#define NMAP_STYLE(src, dest) if(!(dwStyle & (src))) dwText |= (dest)

   void CDrawStaticWrap::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	
	// Where to draw text
	CRect client_rect;
	GetClientRect(client_rect);
	
	// Get the caption
	CString szText;
	GetWindowText(szText);
	
	// Get the font
	CFont *pFont, *pOldFont;
	pFont = GetFont();
	pOldFont = dc.SelectObject(pFont);
	
	DWORD dwStyle = GetStyle(), dwText = 0;
	
	MAP_STYLE(	SS_RIGHT,			DT_RIGHT					);
	MAP_STYLE(	SS_CENTER,			DT_CENTER					);
	MAP_STYLE(	SS_CENTERIMAGE,		DT_VCENTER | DT_SINGLELINE	);
	MAP_STYLE(	SS_NOPREFIX,		DT_NOPREFIX					);
	MAP_STYLE(	SS_WORDELLIPSIS,	DT_WORD_ELLIPSIS			);
	MAP_STYLE(	SS_ENDELLIPSIS,		DT_END_ELLIPSIS				);
	MAP_STYLE(	SS_PATHELLIPSIS,	DT_PATH_ELLIPSIS			);
	
	NMAP_STYLE(	SS_LEFTNOWORDWRAP |
				SS_CENTERIMAGE |
				SS_WORDELLIPSIS |
				SS_ENDELLIPSIS |
				SS_PATHELLIPSIS,	DT_WORDBREAK);
	
	conv.pV = adrCtlColor;
	HBRUSH hBrush = (((CDrawStatic*)this)->*(conv.pCC))(&dc, GetDlgCtrlID());

	CBrush* pBrush = CBrush::FromHandle(hBrush);
	dc.FillRect(client_rect,pBrush);
	// Set transparent background
	if(((CDrawStatic*)this)->IsTransparent())
		dc.SetBkMode(TRANSPARENT);
	
	// Draw the text
	dc.DrawText(szText, client_rect, dwText);
	
	dc.SelectObject(pOldFont);
}
