#include "stdafx.h"
#include "TableEx.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CBkEndUI * pBkEndUI;

IMPLEMENT_DYNCREATE(CTableEx,CBLContext);

class CObjID CTableEx::ObjID;

struct CTableEx::paramdefs CTableEx::defFnNames[] = {
	{{"Write",""}, FALSE, 2},
	{NULL,0,0}
};

struct CTableEx::parampropdefs CTableEx::defPropNames[] = {
	{NULL,0,0, NULL}
};

CTableEx::CTableEx():CBLContext()
{
	pSheetDoc = NULL;
}

CTableEx::~CTableEx()
{
	pSheetDoc = NULL;
}

int  CTableEx::CallAsFunc(int iMethNum,class CValue & rValue,class CValue **ppValue)
{

	switch (iMethNum) {
	case methWrite:
			break;
	default:
		return S_FALSE;
	};
	return S_OK;
}

int  CTableEx::CallAsProc(int iMethNum,class CValue * * ppValue)
{
	switch (iMethNum) {
	case methWrite:
		{
			if(pSheetDoc)
			{
				CSheetSaveAsType num = shMxl;
				CString st = ppValue[1]->Format();
				st.MakeUpper();
				if((st == "0") || (st == "MXL"))
					num = shMxl;
				else if((st == "1") || (st == "XLS"))
					num = shExc;
				else if((st == "2") || (st == "HTM") || (st == "HTML"))
					num = shHtml;
				else if((st == "3") || (st == "TXT"))
					num = shText;
				pSheetDoc->SaveAs(ppValue[0]->GetString(),num);
			}
			break;
		}
	default:
		return S_FALSE;
	};
	return S_OK;
}


int  CTableEx::FindMethod(char const * lpMethodName)const
{
	int i;
	for (i = 0;i<lastMethod;i++){
		if (!stricmp(lpMethodName,defFnNames[i].Names[0]))
			return i;
		if (!stricmp(lpMethodName,defFnNames[i].Names[1]))
			return i;
	}
	return -1;
}

char const *  CTableEx::GetMethodName(int iMethodNum,int iMethodAlias)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].Names[iMethodAlias];
	return 0;
}

int  CTableEx::GetNMethods(void)const
{
	return lastMethod;
}

int  CTableEx::HasRetVal(int iMethodNum)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
	{
		return defFnNames[iMethodNum].HasReturnValue;
	}
	return 0;
}

int CTableEx::GetNParams(int iMethodNum)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].NumberOfParams;
	return 0;
}

int  CTableEx::GetParamDefValue(int iMethodNum,int iParamNum,class CValue * pDefValue)const
{
	switch (iMethodNum) {
	case methWrite:
		{
			if(iParamNum == 1) (*pDefValue) = 0L;
			break;
		}
	default:
		return 0;
	};
	return 1;
}

void  CTableEx::DecrRef(void)
{
	CBLContext::DecrRef();
}

char const *  CTableEx::GetCode(void)const
{
	return NULL;
}

int  CTableEx::GetDestroyUnRefd(void)const
{
	return 1;
}

void  CTableEx::GetExactValue(class CValue & vParam)
{
	CBLContext::GetExactValue(vParam);
}

class CObjID   CTableEx::GetID(void)const
{
	return ObjID;
}

class CBLContextInternalData *  CTableEx::GetInternalData(void)
{

	return CBLContext::GetInternalData();

}

long  CTableEx::GetTypeID(void)const
{
	return 100;
}

char const *  CTableEx::GetTypeString(void)const
{
	return "";
}

class CType   CTableEx::GetValueType(void)const
{
	CType tType(100);
	
	return tType;
}

void  CTableEx::IncrRef(void)
{
	CBLContext::IncrRef();
}

void  CTableEx::InitObject(class CType const & tType)
{
	CBLContext::InitObject(tType);
}

void  CTableEx::InitObject(char const * strName)
{
	CBLContext::InitObject(strName);
}

int  CTableEx::IsExactValue(void)const
{
	return 0;
}

int  CTableEx::IsOleContext(void)const
{
	return 0;
}

int  CTableEx::IsPropReadable(int iPropNum)const
{
	if ((iPropNum>=0) && (iPropNum<lastProp))
		return defPropNames[iPropNum].IsReadable;
	return 0;
}

int  CTableEx::IsPropWritable(int iPropNum)const
{
	if ((iPropNum>=0) && (iPropNum<lastProp))
		return defPropNames[iPropNum].IsWritable;
	return 0;
}

int  CTableEx::IsSerializable(void)
{
	return 0;
}

int  CTableEx::SaveToString(class CString & csStr)
{
	csStr = "";
	return 1;
}

void  CTableEx::SelectByID(class CObjID cID,long lNum)
{
	CBLContext::SelectByID(cID,lNum);
}

int  CTableEx::GetNProps(void)const
{
	return lastProp;
}

char const *  CTableEx::GetPropName(int iPropNum,int iPropAlias)const
{
	if ((iPropNum>=0) && (iPropNum<lastProp))
		return defPropNames[iPropNum].Names[iPropAlias];
	return NULL;
}

int  CTableEx::GetPropVal(int iPropNum,class CValue & rValue)const
{
	return S_OK;
}

int  CTableEx::SetPropVal(int iPropNum,class CValue const & vValue)
{
	return S_OK;
}

int  CTableEx::FindProp(char const * lpPropName)const
{
	int i;
	for (i = 0;i<lastProp;i++)
	{
		if (!stricmp(lpPropName,defPropNames[i].Names[0]))
			return i;
		if (!stricmp(lpPropName,defPropNames[i].Names[1]))
			return i;
	}
	return S_FALSE;
}

