//////////////////////////////////////////////////////////////////////
//  CVTExtRow  
//
// :   aka ADirks
// : e-mail: adirks@ngs.ru, ICQ: 13472890
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "VTExtended.h"

CVTExtRow::CVTExtRow(int numValues)
{
	Values.SetSize(numValues);
	while( --numValues >= 0 ) Values[numValues] = new CValue;
}

CVTExtRow::~CVTExtRow()
{
	for( int i = Values.GetUpperBound(); i >= 0; i-- )
	{
		delete ((CValue*)(Values[i]));
	}
}

int CVTExtRow::NewColumn()
{
	return Values.Add(new CValue);
}

CVTExtRow& CVTExtRow::operator= (CVTExtRow const& SrcRow)
{
	int i = min(Values.GetUpperBound(), SrcRow.Values.GetUpperBound());
	while( i >= 0 )
	{
		SetValue(i, SrcRow.GetValue(i));
		i--;
	}
	return *this;
}
