//////////////////////////////////////////////////////////////////////
//  CVTExtended,   1 ""
//
// :   aka ADirks
// : e-mail: adirks@ngs.ru, ICQ: 13472890
//////////////////////////////////////////////////////////////////////

#include <errno.h>
#include "stdafx.h"
#include "VTExtended.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

///////////////////////////////////////////////////////////////////////////
////  CVTExtended  ////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
BEGIN_BL_METH_MAP(CVTExtended)
    BL_METH("NewColumn",     "",     1, NULL,    funcNewColumn, NULL)
    BL_METH("RemoveColumn",  "",   1, procRemoveColumn, NULL, NULL)
    BL_METH("ColumnCount",   "",0, NULL,    funcGetColCount,    NULL)
    BL_METH("ColumnName",    "",       1, NULL,    funcGetColumnName, NULL)
    BL_METH("ColumnNumber",  "",     1, NULL,    funcGetColumnNumber, NULL)

    BL_METH("NewRow",        "",     0, NULL,    funcNewRow, NULL)
    BL_METH("RemoveRow",     "",   1, procRemoveRow, NULL, NULL)
    BL_METH("RemoveRows",    "",   2, procRemoveAllRows, NULL,    NULL)
    BL_METH("RowCount",      "", 1, NULL,    funcGetRowsCount,    NULL)
    BL_METH("RowNumber",     "",     1, NULL,    funcGetCurrentRow,    NULL)

    BL_METH("Clenup",        "",       0, procCleanup, NULL, NULL)

	BL_METH("AddIndex",      "",  3, NULL, funcAddIndex, NULL)
    BL_METH("DropIndex",     "",   1, procDropIndex, NULL, NULL)
    BL_METH("Sort",          "",     1, procReindex, NULL, NULL)

	BL_METH("IndexIsUnique",  "",  1, NULL, funcIndexIsUnique, NULL)
	BL_METH("UniqueKeyCount", "",  1, NULL, funcUniqueKeyCount, NULL)
	BL_METH("KeyValueCount",  "",  2, NULL, funcKeyValueCount, NULL)

    BL_METH("FindRow",       "",          4, NULL, funcFindRow, NULL)
    BL_METH("FindNearestGE", "", 3, NULL, funcFindNearestGE, NULL)
    BL_METH("FindNearestLE", "", 3, NULL, funcFindNearestLE, NULL)

    BL_METH("SetFilter",   "", 3, procSetFilter, NULL, NULL)
    BL_METH("Subset",      "",     3, procSetFilter2, NULL, NULL)
    BL_METH("DropFilter",  "",  1, procDropFilter, NULL, NULL)

    BL_METH("SelectRows",  "",   1, NULL, funcFirstRow, NULL)
    BL_METH("FirstRow",    "",         1, NULL, funcFirstRow, NULL)
    BL_METH("LastRow",     "",          1, NULL, funcLastRow, NULL)
    BL_METH("GetRow",      "",  2, NULL, funcNextRow, defsNextRow)
    BL_METH("Next",        "", 2, NULL, funcNextRow, defsNextRow)
    BL_METH("Previous",    "",2, NULL, funcPrevRow, defsNextRow)

    BL_METH("Get",         "",           2, NULL, funcGetValue, NULL)
    BL_METH("GetValue",    "",   2, NULL, funcGetValue, NULL)
    BL_METH("Set",         "",         3, procSetValue, NULL, NULL)
    BL_METH("SetValue",    "", 3, procSetValue, NULL, NULL)

    BL_METH("FillRow",     "",   4, procFillRow, NULL, defsFillRow)
    BL_METH("FillColumn",  "",  5, procFillColumn, NULL, NULL)

    BL_METH("GroupBy",     "",           3, procGroupBy, NULL, NULL)
    BL_METH("Sum",         "",               2, NULL, funcSum, NULL)
    BL_METH("NodeSum",     "",         2, NULL, funcNodeSum, NULL)
	BL_METH("Group",       "",       4, procGroup, NULL, defsGroup)

	BL_METH("Unload",      "",          3, procDumpIntoVT, NULL, NULL)
    BL_METH("Load",        "",          2, procLoadFromVT, NULL, NULL)
    BL_METH("Union",       "",         2, procUnionVT, NULL, NULL)
    BL_METH("Conjunction", "",        4, procConjunctionVT, NULL, NULL)
    //BL_METH("Subtract",    "",            2, procSubtractVT, NULL, NULL)
    //BL_METH("NotConjunction", "",   2, procNotConjunctionVT, NULL, NULL)

    BL_METH("Copy",        "",              1, NULL, funcCopy, NULL)

    BL_METH("SaveToFile",  "",              4, procSaveToFile, NULL, defsSaveToFile)
    BL_METH("LoadFromFile","",            3, NULL, funcLoadFromFile, defsLoadFromFile)
    
	BL_METH("SaveToString",  "",          2, NULL, funcSaveToString, defsSaveToString)
    BL_METH("LoadFromString","",         1, procLoadFromString, NULL, NULL)
    
    BL_METH("ChooseLine",  "",      4, NULL, funcShowTable, NULL)
    BL_METH("Show",        "",           4, NULL, funcShowTable, NULL)
END_BL_METH_MAP()

BEGIN_BL_PROP_MAP(CVTExtended)
//    BL_PROP("CurrentRow", "", propGetCurrentRow, propSetCurrentRow)
END_BL_PROP_MAP()

BEGIN_REG_NAMES(CVTExtended)
	"",
	"IndexedTable",
END_REG_NAMES()

IMPLEMENT_MY_CONTEXT(CVTExtended, "", NULL, NULL, -1);

enum VTExt_FixedProp {
	VTExt_FixedProp_CurrentRowEng,
	VTExt_FixedProp_CurrentRowRus,
	VTExt_FixedProp_Last
};

///////////////////////////////////////////////////////////////////////////
CVTExtended::CVTExtended()
{
	FixedProps["RowNumber"] = VTExt_FixedProp_CurrentRowEng;
	FixedProps[""] = VTExt_FixedProp_CurrentRowRus;

	DefaultIndex = new CVTExtIndex("", this);
	Indexes.Add(DefaultIndex);
}

CVTExtended::~CVTExtended()
{
	procCleanup(NULL);
}


BOOL CVTExtended::procCleanup(CValue** params)
{
	for( int i = Indexes.GetUpperBound(); i > 0; i-- )
	{
		Indexes.RemoveIndex(i);
	}
	DefaultIndex->Reindex(CString(""));

	ColumnNames.RemoveAll();
	procRemoveAllRows(NULL);
	return TRUE;
}

//===========================================================================
// Exported methods and props
//===========================================================================
int CVTExtended::NewColumn(CString const& ColumnName)
{
	int ColNum;

	//validity checks
	if( ColumnName.IsEmpty() )
	{
		RuntimeError("   !");
		return -1;
	}
	if( ColumnNames.Lookup(ColumnName, ColNum) )
	{
		RuntimeError(" %s  !", ColumnName);
		return -1;
	}

	//adding a column into each row
	ColumnNames[ColumnName] = ColumnNames.GetCount();
	for( int i = Rows.GetUpperBound(); i >= 0; i-- )
	{
		GetRow(i)->NewColumn();
	}

	//inform all indexes that column added
	Indexes.NewColumn();

	return ColumnNames.GetCount() - 1;
}

BOOL CVTExtended::funcNewColumn(CValue& RetVal, CValue** params)
{
	CString const& ColName = params[0]->GetString();
	int ColNum = NewColumn(ColName);

	RetVal = ColNum + 1;

	return TRUE;
}

void CVTExtended::RemoveColumn(int nCol, bool bCheckIndexes)
{
	if( bCheckIndexes ) Indexes.RemoveColumn(nCol);

	for( int i = Rows.GetUpperBound(); i >= 0; i-- )
		GetRow(i)->RemoveColumn(nCol);

	ColumnNames.RemoveKey(ColumnName(nCol));
}

BOOL CVTExtended::procRemoveColumn(CValue** params)
{
	int nCol = ColumnNumber(params[0]);
	CheckBounds_Col(nCol);
	RemoveColumn(nCol);
	return TRUE;
}

BOOL CVTExtended::funcGetColumnName(CValue& RetVal, CValue** params)
{
	int col_num = ColumnNumber(params[0]);
	CheckBounds_Col(col_num);
	RetVal = ColumnName(col_num);
	return TRUE;
}

BOOL CVTExtended::funcGetColumnNumber(CValue& RetVal, CValue** params)
{
	RetVal = 1L + ColumnNumber(params[0], true);
	return TRUE;
}



int CVTExtended::NewRow()
{
	CVTExtRow* row = new CVTExtRow(ColumnNames.GetCount());
	int row_num = Rows.Add(row);
	Indexes.InsertRow(row, row_num);
	return row_num;
}

BOOL CVTExtended::funcNewRow(CValue& RetVal, CValue** params)
{
	RetVal = 1L + NewRow();
	//DefaultIndex->SetCurrentRow(row_num);
	return TRUE;
}

BOOL CVTExtended::procRemoveRow(CValue** params)
{
	int row_num = (int)(params[0]->GetNumeric()) - 1;
	CheckBounds_Row(row_num);

	Indexes.RemoveRow(row_num);

	delete GetRow(row_num);
	Rows.RemoveAt(row_num);

	return TRUE;
}

BOOL CVTExtended::procRemoveAllRows(CValue** params)
{
	CVTExtIndex *pIndex = NULL;
	if( params != NULL && !(params[0]->IsEmpty()) ) pIndex = GetIndex(params[0]);
	if( pIndex != NULL && pIndex->pFilter == NULL ) pIndex = NULL;

	if( pIndex == NULL )
	{
		Indexes.RemoveAllRows();
		for( int i = Rows.GetUpperBound(); i >= 0; i-- )
		{
			delete GetRow(i);
		}
		Rows.RemoveAll();
	}
	else
	{
		bool *pDeletedRows = new bool[GetRowsCount()];
		int nInverse = params[1]->GetNumeric();
		if( nInverse == 0 )
			memset((void*)pDeletedRows, 0, sizeof(bool) * GetRowsCount());
		else
			memset((void*)pDeletedRows, ~(int)0, sizeof(bool) * GetRowsCount());

		bool bDeleteFlag = !nInverse;
		pIndex->Last();
		while( pIndex->Prev() ) pDeletedRows[pIndex->CurrentRow] = bDeleteFlag;

		for( int i = GetRowsCount() - 1; i >= 0; i-- )
		{
			if( pDeletedRows[i] )
			{
				//Message("Delete row %i", i);
				delete GetRow(i);
				Rows.RemoveAt(i);
			}
		}
		Indexes.Reindex();
		delete[] pDeletedRows;
	}

	return TRUE;
}

BOOL CVTExtended::funcGetRowsCount(CValue& RetVal, CValue** params)
{
	CVTExtIndex *pIndex = GetIndex(params[0]);
	if( pIndex->IsEmpty() )
		RetVal = (long)GetRowsCount();
	else
		RetVal = pIndex->GetRowsCount();
	return TRUE;
}

BOOL CVTExtended::funcGetCurrentRow(CValue& RetVal, CValue** params)
{
	CVTExtIndex *pIndex = GetIndex(params[0]);
	RetVal = 1L + pIndex->GetCurrentRow();
	return TRUE;
}

BOOL CVTExtended::funcGetColCount(CValue& RetVal, CValue** params)
{
	RetVal = (long)GetColumnsCount();
	return TRUE;
}

BOOL CVTExtended::funcGetValue(CValue& RetVal, CValue** params) 
{
	int row_num;
	if( params[0]->IsEmpty() )
		row_num = DefaultIndex->CurrentRow;
	else
		row_num = (int)(params[0]->GetNumeric()) - 1;
	int col_num = ColumnNumber(params[1]);
	CheckBounds(row_num, col_num);
	RetVal = GetValue(row_num, col_num); 
	return TRUE;
}

BOOL CVTExtended::procSetValue(CValue** params)
{
	int row_num;
	if( params[0]->IsEmpty() )
		row_num = DefaultIndex->CurrentRow;
	else
		row_num = (int)(params[0]->GetNumeric()) - 1;
	int col_num = ColumnNumber(params[1]);
	CheckBounds(row_num, col_num);
	SetValue(row_num, col_num, *(params[2])); 
	return TRUE;
}

BOOL CVTExtended::funcSum(CValue& RetVal, CValue** params)
{
	int nCol = ColumnNumber(params[0]);
	CVTExtIndex *Index = GetIndex(params[1]);
	Index->Sum(nCol, RetVal);
	return TRUE;
}

BOOL CVTExtended::funcNodeSum(CValue& RetVal, CValue** params)
{
	int nCol = ColumnNumber(params[0]);
	CVTExtIndex *Index = GetIndex(params[1]);
	Index->NodeSum(nCol, RetVal);
	return TRUE;
}

void CVTExtended::propSetCurrentRow(CValue const& Value)
{
	int row = Value.GetNumeric();
	row--;
	CheckBounds_Row(row);
	DefaultIndex->SetCurrentRow(row);
}

BOOL CVTExtended::funcAddIndex(CValue& RetVal, CValue** params)
{
	CString IndexName = params[0]->GetString();
	CString IndexExpr = params[1]->GetString();
	bool bUnique = (int)(params[2]->GetNumeric()) == 0 ? false : true;
	RetVal = 1L + Indexes.AddIndex(IndexName, IndexExpr, bUnique, this);
	return TRUE;
}

BOOL CVTExtended::procDropIndex(CValue** params)
{
	CVTExtIndex* Index = GetIndex(params[0]);
	if( Index == DefaultIndex )
		RuntimeError("   !");
	Indexes.RemoveIndex(Index);
	return TRUE;
}

BOOL CVTExtended::procReindex(CValue** params)
{
	CString IndexExpr = params[0]->GetString();
	DefaultIndex->Reindex(IndexExpr);
	return TRUE;
}

BOOL CVTExtended::funcIndexIsUnique(CValue& RetVal, CValue** params)
{
	CVTExtIndex* Index = GetIndex(params[0]);
	if( Index->IsEmpty() )
		RuntimeError("   !");
	RetVal = Index->Count == Index->UniqueCount ? 1L : 0L;
	return TRUE;
}

BOOL CVTExtended::funcUniqueKeyCount(CValue& RetVal, CValue** params)
{
	CVTExtIndex* Index = GetIndex(params[0]);
	if( Index->IsEmpty() )
		RuntimeError("   !");
	RetVal = Index->UniqueCount;
	return TRUE;
}

BOOL CVTExtended::funcKeyValueCount(CValue& RetVal, CValue** params)
{
	CVTExtIndex* Index = GetIndex(params[0]);
	if( Index->IsEmpty() )
		RuntimeError("   !");
	RetVal = Index->KeyCount(*(params[1]));
	return TRUE;
}

//:
// 1:  ,    (  DefaultIndex). 
// 2:  -  ,    
// 3: 0 -   , 1 - 
// 4: 1 -    
//: 0 -  ,   -  
BOOL CVTExtended::funcFindRow(CValue& RetVal, CValue** params)
{
	CVTExtIndex *pIndex = GetIndex(params[0]);
	CValue &What = *(params[1]);
	bool bFindLastRow = (int)(params[2]->GetNumeric()) == 0 ? false : true;
	bool bChangePosition = (int)(params[3]->GetNumeric()) == 0 ? false : true;
	
	int found = pIndex->Find(What, bFindLastRow, bChangePosition);
	RetVal = 1L + found;

	if( found >= 0 )
		SetCurrentRow(pIndex);

	return TRUE;
}

//  ,     (funcFindRow),    3
BOOL CVTExtended::funcFindNearestGE(CValue& RetVal, CValue** params)
{
	CValue &What = *(params[0]);
	CVTExtIndex *Index = GetIndex(params[1]);
	bool bChangePosition = (int)(params[2]->GetNumeric()) == 0 ? false : true;
	
	RetVal = 1L + Index->FindNearestGE(What, bChangePosition);
	SetCurrentRow(Index);

	return TRUE;
}

//  ,     (funcFindRow),    3
BOOL CVTExtended::funcFindNearestLE(CValue& RetVal, CValue** params)
{
	CValue &What = *(params[0]);
	CVTExtIndex *Index = GetIndex(params[1]);
	bool bChangePosition = (int)(params[2]->GetNumeric()) == 0 ? false : true;
	
	RetVal = 1L + Index->FindNearestLE(What, bChangePosition);
	SetCurrentRow(Index);

	return TRUE;
}

BOOL CVTExtended::procSetFilter(CValue** params)
{
	CValue &Min = *(params[0]);
	CValue &Max = *(params[1]);
	CVTExtIndex *Index = GetIndex(params[2]);
	
	Index->SetFilter(Min, Max);

	return TRUE;
}

BOOL CVTExtended::procSetFilter2(CValue** params)
{
	CValue &SubSet = *(params[0]);
	int nCols = -1;
	if( !params[1]->IsEmpty() ) nCols = params[1]->GetNumeric();
	CVTExtIndex *Index = GetIndex(params[2]);
	
	Index->SetFilter(SubSet, nCols);

	return TRUE;
}

BOOL CVTExtended::procDropFilter(CValue** params)
{
	CVTExtIndex *Index = GetIndex(params[0]);
	Index->DropFilter();
	return TRUE;
}


BOOL CVTExtended::defsNextRow(int nParam, CValue* param) const
{
	switch( nParam )
	{
	case 0:
		*param = "";
		break;
	case 1:
		*param = 0L;
		break;
	}
	return TRUE;
}

BOOL CVTExtended::funcFirstRow(CValue& RetVal, CValue** params)
{
	CVTExtIndex *Index = GetIndex(params[0]);
	if( Index->First() )
		RetVal = 1L;
	else
		RetVal = 0L;
	SetCurrentRow(Index);
	return TRUE;
}

BOOL CVTExtended::funcNextRow(CValue& RetVal, CValue** params)
{
	CVTExtIndex *Index = GetIndex(params[0]);
	bool bUnique = params[1]->GetNumeric() != 0L;
	if( Index->Next(bUnique) )
		RetVal = 1L;
	else
		RetVal = 0L;
	SetCurrentRow(Index);

	return TRUE;
}

BOOL CVTExtended::funcLastRow(CValue& RetVal, CValue** params)
{
	CVTExtIndex *Index = GetIndex(params[0]);
	if( Index->Last() )
		RetVal = 1L;
	else
		RetVal = 0L;
	SetCurrentRow(Index);

	return TRUE;
}

BOOL CVTExtended::funcPrevRow(CValue& RetVal, CValue** params)
{
	CVTExtIndex *Index = GetIndex(params[0]);
	bool bUnique = params[1]->GetNumeric() != 0L;
	if( Index->Prev(bUnique) )
		RetVal = 1L;
	else
		RetVal = 0L;
	SetCurrentRow(Index);

	return TRUE;
}

BOOL CVTExtended::procGroupBy(CValue** params)
{
	if( params[2]->IsEmpty() )
	{
		CVTExtIndex Index("", params[0]->GetString(), false, this);
		Index.GroupBy(params[1]->GetString());
	}
	else
	{
		CVTExtIndex* pIndex = GetIndex(params[2]);
		pIndex->GroupBy(params[1]->GetString());
	}

	Indexes.Reindex();
	return TRUE;
}


int* CVTExtended::ColumnNumbersMap(CVTExtended* pDest, CVTExtended* pSrc, bool bJoinColumns)
{
	int nColumns = pSrc->GetColumnsCount();
	int *pColNumbersMap = new int[nColumns];
	for( int i = 0; i < nColumns; i++ )
	{
		int nDestCol = pDest->ColumnNumber(pSrc->ColumnName(i), true);
		if( nDestCol < 0 && bJoinColumns ) 
			nDestCol = pDest->NewColumn(pSrc->ColumnName(i));
		pColNumbersMap[i] = nDestCol;
	}
	return pColNumbersMap;
}

int* CVTExtended::ColumnNumbersMap(CVTExtended* pDest, CValueTable* pSrc, bool bJoinColumns)
{
	int nColumns = pSrc->GetColumnCount();
	int *pColNumbersMap = new int[nColumns];
	for( int i = 0; i < nColumns; i++ )
	{
		int nDestCol = pDest->ColumnNumber(pSrc->GetColumnCode(i), true);
		if( nDestCol < 0 && bJoinColumns ) 
			nDestCol = pDest->NewColumn(pSrc->GetColumnCode(i));
		pColNumbersMap[i] = nDestCol;
	}
	return pColNumbersMap;
}

int* CVTExtended::ColumnNumbersMap(CVTExtended* pDest, CPtrArray* ppValueList)
{
	int nColumns = ppValueList->GetUpperBound() + 1;
	int *pColNumbersMap = new int[nColumns];
	for( int i = 0; i < nColumns; i++ )
	{
		CValueItem* pVLItem = (CValueItem*)(ppValueList->GetAt(i));
		pColNumbersMap[i] = pDest->ColumnNumber(pVLItem->m_text, true);
	}
	return pColNumbersMap;
}

void CVTExtended::CopyRowFromVTExt(CVTExtRow *pDest, CVTExtRow *pSrc, int nColumns, int *pColNumbersMap)
{
	for( int i = 0; i < nColumns; i++ )
	{
		int nCol = pColNumbersMap[i];
		if( nCol >= 0 )
		{
			pDest->SetValue(nCol, pSrc->GetValue(i));
		}
	}
}

void CVTExtended::CopyRowFromVL(CVTExtRow *pDest, CPtrArray* ppValueList, int *pColNumbersMap)
{
	for( int i = ppValueList->GetUpperBound(); i >= 0; i-- )
	{
		int nCol = pColNumbersMap[i];
		if( nCol >= 0 )
		{
			CValue* val = (CValue*)(ppValueList->GetAt(i));
			pDest->SetValue(nCol, *val);
		}
	}
}

void CVTExtended::LoadFromVTExt(CVTExtended* pSrc, CValue* IndexName, bool bMerge)
{
	CVTExtIndex *pIndex = pSrc->GetIndex(IndexName);

	if( !bMerge ) procCleanup(NULL);

	int nColumns = pSrc->GetColumnsCount();
	int *pColNumbersMap = ColumnNumbersMap(this, pSrc, true);


	CVTExtPosition Pos;
	Pos = *pIndex;
	pIndex->First();
	while( pIndex->Next() )
	{
		int nRow = NewRow();
		CopyRowFromVTExt(GetRow(nRow), pIndex->pCurrentRow, nColumns, pColNumbersMap);
	}
	*pIndex = Pos;

	delete[] pColNumbersMap;
}

void CVTExtended::LoadFromVT(CValueTable* pVT, bool bMerge)
{
	if( !bMerge ) procCleanup(NULL);

	int nColumns = pVT->GetColumnCount();
	int *pColNumbersMap = ColumnNumbersMap(this, pVT, true);

	int nRows = pVT->GetRowCount();
	for( int nRow = 0; nRow < nRows; nRow++ )
	{
		int nDestRow = NewRow();
		CVTExtRow *pDest = GetRow(nDestRow);
		for( int i = 0; i < nColumns; i++ )
		{
			pDest->SetValue(pColNumbersMap[i], pVT->GetValue(i, nRow));
		}
	}

	delete[] pColNumbersMap;
}

BOOL CVTExtended::defsFillRow(int nParam, CValue* param) const
{
	switch( nParam )
	{
	case 0:
		*param = -1L;
		break;
	case 2:
		*param = -1L;
		break;
	case 3:
		*param = 0L;
		break;
	}
	return TRUE;
}

BOOL CVTExtended::procFillRow(CValue** params)
{
	//param 0
	int nDestRow = (int)(params[0]->GetNumeric()) - 1;
	CVTExtRow *pRow = NULL;
	if( nDestRow < 0 )
		pRow = DefaultIndex->pCurrentRow;
	else
	{
		CheckBounds_Row(nDestRow);
		pRow = GetRow(nDestRow);
	}
	if( pRow == NULL )
		RuntimeError("  !");
	//param1
	CValue const& Value = *(params[1]);
	CVTExtended* pVTExt = CValue2VTExt(Value);
	CValueTable* pVT = CValue2VT(Value);
	CPtrArray* ppValueList = (CPtrArray*)CValue2VL(Value);
	//param 2
	int nSrcRow = (int)(params[2]->GetNumeric()) - 1;
	//param 3
	bool ByColNames = params[3]->GetNumeric() != 0;


	if( ppValueList )
	{
		if( ByColNames )
		{
			int *pColNumMap = ColumnNumbersMap(this, ppValueList);
			CopyRowFromVL(pRow, ppValueList, pColNumMap);
			delete[] pColNumMap;
		}
		else
		{
			for( int i = min(ppValueList->GetUpperBound(), GetColumnsCount()-1); i >= 0; i-- )
			{
				pRow->SetValue(i, *(CValue*)(ppValueList->GetAt(i)));
			}
		}
	}
	else if( pVTExt )
	{
		if( nSrcRow < 0 ) nSrcRow = pVTExt->DefaultIndex->CurrentRow;
		pVTExt->CheckBounds_Row(nSrcRow);
		if( ByColNames )
		{
			int *pColNumMap = ColumnNumbersMap(this, pVTExt, false);
			CopyRowFromVTExt(pRow, 
				pVTExt->GetRow(nSrcRow), 
				pVTExt->GetColumnsCount(), 
				pColNumMap);
			delete[] pColNumMap;
		}
		else
			*pRow = *(pVTExt->GetRow(nSrcRow));
	}
	else if( pVT )
	{
		if( nSrcRow < 0 ) nSrcRow = pVT->GetIndex(0);
		if( ByColNames )
		{
			int nColumns = pVT->GetColumnCount();
			int *pColNumMap = ColumnNumbersMap(this, pVT, false);
			for( int i = 0; i < nColumns; i++ )
			{
				pRow->SetValue(pColNumMap[i], pVT->GetValue(i, nSrcRow));
			}
			delete[] pColNumMap;
		}
		else
		{
			int nColumns = min(GetColumnsCount(), pVT->GetColumnCount());
			for( int nCol = 0; nCol < nColumns; nCol++ )
				pRow->SetValue(nCol, pVT->GetValue(nCol, nSrcRow));
		}
	}
	else
	{
		for( int i = GetColumnsCount()-1; i >= 0; i-- )
		{
			pRow->SetValue(i, Value);
		}
	}

	Indexes.OnChangeRow(DefaultIndex->CurrentRow);

	return TRUE;
}

BOOL CVTExtended::procFillColumn(CValue** params)
{
	//param 0
	CVTExtIndex *pIndex = GetIndex(params[0]);
	//param 1
	int nDestCol = ColumnNumber(params[1]);
	//param 2
	CValue const& Value = *(params[2]);
	CVTExtended* pVTExt = CValue2VTExt(Value);
	CValueTable* pVT = CValue2VT(Value);
	CPtrArray* ppValueList = (CPtrArray*)CValue2VL(Value);

	bool bNeedReindex = Indexes.ColumnIndexed(nDestCol);
	bool *bChangedRows;
	if( bNeedReindex )
	{
		bChangedRows = new bool[GetRowsCount()];
		memset((void*)bChangedRows, 0, sizeof(bool) * GetRowsCount());
	}

	if( ppValueList )
	{
		int nValue = 0, nValues = ppValueList->GetSize();
		pIndex->First();
		while( nValue < nValues && pIndex->Next() )
		{
			CValue *pVal = (CValue*)(ppValueList->GetAt(nValue));
			pIndex->pCurrentRow->SetValue(nDestCol, *pVal);
			if( bNeedReindex ) bChangedRows[pIndex->CurrentRow] = true;
			nValue++;
		}
	}
	else if( pVT )
	{
		int nSrcCol = GetVTColumnNumber(pVT, params[3], params[1]);
		if( nSrcCol < 0 || nSrcCol >= pVT->GetColumnCount() )
			RuntimeError("    -!");
		int nSrcRow = 0, nSrcRows = pVT->GetRowCount();
		pIndex->First();
		while( nSrcRow < nSrcRows && pIndex->Next() )
		{
			CValue const& Value = pVT->GetValue(nSrcCol, nSrcRow);
			pIndex->pCurrentRow->SetValue(nDestCol, Value);
			if( bNeedReindex ) bChangedRows[pIndex->CurrentRow] = true;
			nSrcRow++;
		}
	}
	else if( pVTExt )
	{
		CVTExtIndex *pSrcIndex = pVTExt->GetIndex(params[3]);
		int nSrcCol = GetVTColumnNumber(pVTExt, params[4], params[1]);
		if( nSrcCol < 0 || nSrcCol >= pVTExt->GetColumnsCount() )
			RuntimeError("    -!");

		pIndex->First();
		pSrcIndex->First();
		while( pIndex->Next() && pSrcIndex->Next() )
		{
			CValue const& Value = pSrcIndex->pCurrentRow->GetValue(nSrcCol);
			pIndex->pCurrentRow->SetValue(nDestCol, Value);
			if( bNeedReindex ) bChangedRows[pIndex->CurrentRow] = true;
		}
	}
	else
	{
		pIndex->First();
		while( pIndex->Next() )
		{
			pIndex->pCurrentRow->SetValue(nDestCol, Value);
			if( bNeedReindex ) bChangedRows[pIndex->CurrentRow] = true;
		}
	}

	if( bNeedReindex )
	{
		for( int i = GetRowsCount() - 1; i >= 0; i-- )
			if( bChangedRows[i] ) Indexes.OnChangeRow(i);
		delete[] bChangedRows;
	}

	return TRUE;
}

void CVTExtended::DumpIntoVT(CValueTable* pVT, CVTExtIndex* pIndex)
{
	pVT->Clear(TRUE);
	int nColumns = GetColumnsCount(), i;
	CType Type1C(UNDEFINE_TYPE_1C);
	for( i = 0; i < nColumns; i++ )
	{
		pVT->AddColumn(ColumnName(i), Type1C, ColumnName(i), 0, "", 0);
	}

	CVTExtPosition Pos;
	Pos = *pIndex;
	pIndex->First();
	while( pIndex->Next() )
	{
		pVT->AddRow((CValue**)(pIndex->pCurrentRow->Values.GetData()), -1);
	}
	*pIndex = Pos;
}

BOOL CVTExtended::procDumpIntoVT(CValue** params)
{
	CValue &Dest = *(params[0]);
	CVTExtended* pVTExt = NULL;
	CValueTable* pVT = NULL;
	CPtrArray* pVL = NULL;

	if( Dest.GetTypeCode() == UNDEFINE_TYPE_1C )
	{
        Dest.CreateObject("");
		pVTExt = CValue2VTExt(Dest);
	}
	else
	{
		pVTExt = CValue2VTExt(Dest);
		pVT = CValue2VT(Dest);
		pVL = (CPtrArray*)CValue2VL(Dest);
	}

	if( pVTExt )
	{
		pVTExt->LoadFromVTExt(this, params[1], false);
	}
	else if( pVT )
	{
		CVTExtIndex *pIndex = GetIndex(params[1]);
		DumpIntoVT(pVT, pIndex);
	}
	else if( pVL )
	{
		CVTExtIndex *pIndex = GetIndex(params[1]);
		int nCol = ColumnNumber(params[2]);

		CBLContext* pCont = Dest.GetContext();
		int nRemoveAllMethod = pCont->FindMethod("RemoveAll");
		int nAddMethod = pCont->FindMethod("AddValue");
		CValue vString = "";
		CValue* params[2];
		params[1] = &vString;

		pCont->CallAsProc(nRemoveAllMethod, NULL);

		pIndex->First();
		while( pIndex->Next() )
		{
			params[0] = &(pIndex->pCurrentRow->GetValue(nCol));
			pCont->CallAsProc(nAddMethod, params);
		}
	}
	else
	{
		RuntimeError("    ,   !");
	}

	return TRUE;
}

BOOL CVTExtended::procLoadFromVT(CValue** params)
{
	CVTExtended* pVTExt = CValue2VTExt(*params[0]);
	CValueTable* pVT = CValue2VT(*params[0]);

	if( pVTExt != NULL )
	{
		if( pVTExt == this )
			RuntimeError("    !");
		LoadFromVTExt(pVTExt, params[1], false);
	}
	else if( pVT != NULL )
	{
		LoadFromVT(pVT, false);
	}
	else
	{
		RuntimeError("      !");
		return FALSE;
	}

	return TRUE;
}

BOOL CVTExtended::procUnionVT(CValue** params)
{
	CVTExtended* pVTExt = CValue2VTExt(*params[0]);
	CValueTable* pVT = CValue2VT(*params[0]);

	if( pVTExt == NULL && pVT == NULL )
	{
		RuntimeError("      !");
		return FALSE;
	}

	if( pVTExt != NULL )
	{
		if( pVTExt == this )
			RuntimeError("    !");
		LoadFromVTExt(pVTExt, params[1], true);
	}
	else
	{
		LoadFromVT(pVT, true);
	}

	return TRUE;
}

void CVTExtended::FillKeyRow(CVTExtRow & KeyRow, CVTExtRow& SrcRow, 
							 TVTExtIndexFields& DestIdxFields, TVTExtIndexFields& SrcIdxFields, 
							 int nKeyFields)
{
	for( int i = 0; i < nKeyFields; i++ )
	{
		CValue &val = SrcRow.GetValue(SrcIdxFields[i].ColumnNumber);
		KeyRow.SetValue(DestIdxFields[i].ColumnNumber, val);
	}
}

BOOL CVTExtended::procConjunctionVT(CValue** params)
{
	CVTExtended* pVTExt = CValue2VTExt(*params[0]);
	CValueTable* pVT = CValue2VT(*params[0]);

	if( pVTExt == NULL  )
		RuntimeError("    !");
	else if( pVTExt == this )
		RuntimeError("    !");

	// ,     
	CVTExtIndex *pIndexDest = GetIndex(params[1]);
	CVTExtIndex *pIndexSrc = pVTExt->GetIndex(params[2]);
	int nKeyFields = pIndexDest->IndexFields.size();

	if( nKeyFields != pIndexSrc->IndexFields.size() )
		RuntimeError("     !");

	//     Src
	CVTExtRow SrcKeyRow(pVTExt->GetColumnsCount());
	CVTIndexRecord SrcIdxRec(&SrcKeyRow, &(pIndexSrc->IndexFields));


	//    ,  ,     Src - 
	TVTExtIndexFields &SrcIdxFields = pIndexSrc->IndexFields;
	TVTExtIndexFields &DestIdxFields = pIndexDest->IndexFields;
	for( int nRow = GetRowsCount() - 1; nRow >= 0; nRow-- )
	{
		CVTExtRow *pDestRow = GetRow(nRow);
		FillKeyRow(SrcKeyRow, *pDestRow, SrcIdxFields, DestIdxFields, nKeyFields);
		if( pIndexSrc->Search(SrcIdxRec) == NULL )
		{
			delete pDestRow;
			Rows.RemoveAt(nRow);
		}
	}

	//  ,      
	int *pColNumbersMap = ColumnNumbersMap(this, pVTExt, true);

	//     
	CVTExtRow DestKeyRow(GetColumnsCount());
	CVTIndexRecord DestIdxRec(&DestKeyRow, &(pIndexDest->IndexFields));

	//    Src,  ,    , 
	int nSrcColumns = pVTExt->GetColumnsCount();
	int nSrcRows = pVTExt->GetRowsCount();
	for( nRow = 0; nRow < nSrcRows; nRow++ )
	{
		CVTExtRow *pSrcRow = pVTExt->GetRow(nRow);
		FillKeyRow(DestKeyRow, *pSrcRow, DestIdxFields, SrcIdxFields, nKeyFields);
		if( pIndexDest->Search(DestIdxRec) )
		{
			CVTExtRow *NewRow = new CVTExtRow(GetColumnsCount());
			CopyRowFromVTExt(NewRow, pSrcRow, nSrcColumns, pColNumbersMap);
			Rows.Add(NewRow);
		}
	}

	delete[] pColNumbersMap;

	Indexes.Reindex();

	return TRUE;
}


BOOL CVTExtended::funcCopy(CValue& RetVal, CValue** params)
{
	RetVal.CreateObject("IndexedTable");
	CVTExtended* pVT = (CVTExtended*)(RetVal.GetContext());
	for( int nCol = 0; nCol < GetColumnsCount(); nCol++ )
	{
		pVT->NewColumn(ColumnName(nCol));
		pVT->Indexes.NewColumn();
	}

	for( int nRow = 0; nRow < GetRowsCount(); nRow++ )
	{
		pVT->NewRow();
		CVTExtRow *pDestRow = pVT->GetRow(nRow);
		CVTExtRow *pSrcRow = GetRow(nRow);
		*pDestRow = *pSrcRow;
	}

	int bCopyIndexes = (int)(params[0]->GetNumeric());
	if( bCopyIndexes )
	{
		*(pVT->DefaultIndex) = *DefaultIndex;
		int nIndexCount = Indexes.GetUpperBound();
		for( int nIndex = 1; nIndex <= nIndexCount; nIndex++ )
		{
			CVTExtIndex* pIndex = new CVTExtIndex(Indexes[nIndex]->GetName(), pVT);
			*pIndex = *(Indexes[nIndex]);
			pVT->Indexes.AddIndex(pIndex);
		}
	}

	Indexes.Reindex();

	return TRUE;
}


void CVTExtended::SaveToStorage(CSerialStorage& Storage, CVTExtIndex *pIndex, bool InnerFormat)
{
	int nCol;
	CString str;

	if( pIndex == NULL ) pIndex = DefaultIndex;

	int nRows = pIndex->IsEmpty() ? GetRowsCount() : pIndex->Count;

	Storage.AddString("{IndexedTable:\n%i, %i, %i\n", InnerFormat ? 1 : 2, GetColumnsCount(), nRows);

	for( nCol = 0; nCol < GetColumnsCount(); nCol++ )
		Storage.AddString("%s\n", ColumnName(nCol));

	pIndex->First();
	while( pIndex->Next() )
	{
		CVTExtRow *pRow = pIndex->pCurrentRow;

		Storage.AddString("{\n");
		for( nCol = 0; nCol < GetColumnsCount(); nCol++ )
		{
			CValue& val = pRow->GetValue(nCol);
			CVTExtended *pVT = CValue2VTExt(val);

			if( pVT )
				pVT->SaveToStorage(Storage, NULL, InnerFormat);
			else
			{
				if( InnerFormat )
				{
					if( val.GetTypeCode() == AGREGATE_TYPE_1C )
						//val.GetContext()->SaveToString(str);
						val.SaveToString(str);
					else
						val.SaveToString(str);
					Storage.AddString("%s\n", str);
				}
				else
				{
					char t;
					switch( val.GetTypeCode() )
					{
					case 1:  t = 'N'; break;
					case 2:  t = 'S'; break;
					case 3:  t = 'D'; break;
					default: t = 'S'; break;
					}
					Storage.AddString("%c:%s\n", t, val.Format());
				}
			}
		}
		Storage.AddString("}\n");
	}
	Storage.AddString("}\n");
}

void CVTExtended::SaveToStorage_CSV(CSerialStorage& Storage, CVTExtIndex *pIndex, bool InnerFormat, bool bWithColNames)
{
	int nCol;
	int nRows = pIndex->IsEmpty() ? GetRowsCount() : pIndex->Count;
	int nCols = GetColumnsCount();
	char *semicolon = "";

	if( bWithColNames )
	{
		for( nCol = 0; nCol < nCols; nCol++ )
		{
			Storage.AddString("%s%s", semicolon, ColumnName(nCol));
			semicolon = ";";
		}
		Storage.AddString("\n");
	}

	CString str;
	pIndex->First();
	while( pIndex->Next() )
	{
		CVTExtRow *pRow = pIndex->pCurrentRow;

		semicolon = "";
		for( nCol = 0; nCol < nCols; nCol++ )
		{
			CValue& val = pRow->GetValue(nCol);
			if( InnerFormat )
			{
				if( val.GetTypeCode() == AGREGATE_TYPE_1C )
					//val.GetContext()->SaveToString(str);
					val.SaveToString(str);
				else
					val.SaveToString(str);
			}
			else
			{
				str = val.Format();
			}

			char *quote = "";
			if( str.Find(';') >= 0 )
			{
				str.Replace("\"", "\"\"");
				quote = "\"";
			}
			Storage.AddString("%s%s%s%s", semicolon, quote, str, quote);

			semicolon = ";";
		}
		Storage.AddString("\n");
	}
}

BOOL CVTExtended::defsSaveToFile(int nParam, CValue* param) const
{
	switch(nParam)
	{
	case 0:
		break;
	case 1:
		*param = 1L;
		break;
	case 2:
		*param = "";
		break;
	case 3:
		*param = 1L;
		break;
	}
	return TRUE;
}

BOOL CVTExtended::procSaveToFile(CValue** params)
{
	CString FileName = params[0]->GetString();
	int format = params[1]->GetNumeric();
	CVTExtIndex *pIndex = GetIndex(params[2]);
	bool bWithColNames = params[3]->GetNumeric() != 0;

	FILE *f = fopen(FileName, "wt");
	if( f == NULL )
		RuntimeError("   %s! %s", FileName, strerror(errno));
	CSerialStorage Storage(f);

	switch( format )
	{
	case 1:
		SaveToStorage(Storage, pIndex, true);
		break;
	case 2:
		SaveToStorage(Storage, pIndex, false);
		break;
	case 3:
		SaveToStorage_CSV(Storage, pIndex, true, bWithColNames);
		break;
	case 4:
		SaveToStorage_CSV(Storage, pIndex, false, bWithColNames);
		break;
	}

	fclose(f);

	return TRUE;
}

bool CVTExtended::LoadFromStorage2(CSerialStorage& Storage)
{
	char *str;
	int nCol, nRow;
	CVTExtRow *pRow;
	enum {read_table, read_row} state = read_table;

	procCleanup(NULL);

	int nFormat = 0, nCols = 0, nRows = 0;
	str = Storage.ReadString();
	sscanf(str, "%i, %i, %i", &nFormat, &nCols, &nRows);
	bool bInnerFormat = nFormat == 1;

	for( nCol = 0; nCol < nCols; nCol++ )
	{
		str = Storage.ReadString();
		NewColumn(str);
	}

	while( (str = Storage.ReadString()) != NULL )
	{
		switch( state )
		{
		case read_table:
			if( strcmp(str, "{") == 0 )
			{
				nRow = NewRow();
				pRow = GetRow(nRow);
				nCol = 0;
				state = read_row;
			}
			else if( strcmp(str, "}") == 0 )
			{
				return true;
			}
			break;
		case read_row:
			if( strcmp(str, "}") == 0 )
			{
				//if( (nCol + 1) != nCols ) return false;
				state = read_table;
			}
			else 
			{
				if( nCol >= nCols ) return false;

				if( strncmp(str, "{IndexedTable:", 14) == 0 )
				{
					pRow->GetValue(nCol).CreateObject("IndexedTable");
					CVTExtended *pVT = CValue2VTExt(pRow->GetValue(nCol));

					if( !pVT->LoadFromStorage2(Storage) ) return false;
				}
				else
				{
					CValue &val = pRow->GetValue(nCol);
					if( bInnerFormat )
						val.LoadFromString(str, 0);
					else
					{
						char t;
						sscanf(str, "%c:", &t);
						switch( t )
						{
						case 'N':
							{
								CNumeric n;
								n.FromString(str + 2, NULL);
								val = n;
							}
							break;
						case 'S':
							val = str + 2;
							break;
						case 'D':
							{
								int dd, mm, yy;
								sscanf(str+2, "%i.%i.%i", &dd, &mm, &yy);
								if( yy < 100 ) yy += 2000;
								CDate d(yy, mm, dd);
								val = d;
							}
							break;
						default:
							val = str + 2;
							break;
						}
					}
				}
				nCol++;
			}
			break;
		}
	}

	return true;
}

bool CVTExtended::LoadFromStorage(CSerialStorage& Storage)
{
	char *str = Storage.ReadString();

	if( strncmp(str, "{IndexedTable:", 14) != 0 ) return false;
	
	return LoadFromStorage2(Storage);
}

bool parse_string(char*& ptr, CString& Token)
{
	if( ptr == NULL || *ptr == '\0' ) return false;

	char *token = NULL;
	if( *ptr == '"' )
	{
		token = ptr + 1;
		char *pos = strchr(ptr+1, '"');
		while( pos != NULL && *(pos+1) == '"' ) pos = strchr(pos+2, '"');
		if( pos )
		{
			*pos = '\0';
			ptr = pos + 1;
		}
		else
			ptr = NULL; // 

		if( ptr != NULL && *ptr == ';' ) ptr++;

		Token = token;
		Token.Replace("\"\"", "\"");
	}
	else
	{
		token = ptr;
		ptr = strchr(ptr, ';');
		if( ptr )
		{
			*ptr = '\0';
			ptr++;
		}
		else
		{
			ptr = NULL;
		}
		Token = token;
	}

	return true;
}

bool CVTExtended::LoadFromStorage_CSV(CSerialStorage& Storage, bool bInnerFormat, bool bWithColNames)
{
	char *ptr;
	CString Token;
	int nCols = 0, nCol, nRow;
	CVTExtRow *pRow;

	procCleanup(NULL);

	if( bWithColNames )
	{
		ptr = Storage.ReadString();
		while( parse_string(ptr, Token) )
		{
			NewColumn(Token);
			nCols++;
		}
	}

	while( (ptr = Storage.ReadString()) != NULL )
	{
		nRow = NewRow();
		pRow = GetRow(nRow);
		nCol = 0;

		// ,   ,      
		while( parse_string(ptr, Token) )
		{
			if( nCol >= nCols )
			{
				CString ColName;
				ColName.Format("__column__%i", nCol+1);
				NewColumn(ColName);
				nCols++;
			}
			if( bInnerFormat )
				pRow->GetValue(nCol).LoadFromString(Token, 0);
			else
				pRow->GetValue(nCol) = Token;

			nCol++;
		}
	}
	
	return true;
}

BOOL CVTExtended::defsLoadFromFile(int nParam, CValue* param) const
{
	switch(nParam)
	{
	case 0:
		break;
	case 1:
		*param = 1L;
		break;
	case 2:
		*param = 1L;
		break;
	}
	return TRUE;
}

BOOL CVTExtended::funcLoadFromFile(CValue& RetVal, CValue** params)
{
	CString FileName = params[0]->GetString();
	int format = params[1]->GetNumeric();
	bool bWithColNames = params[2]->GetNumeric() != 0L;

	FILE *f = fopen(FileName, "rt");
	if( f == NULL )
		RuntimeError("   %s! %s", FileName, strerror(errno));
	CSerialStorage Storage(f);

	switch( format )
	{
	case 1:
	case 2:
		RetVal = LoadFromStorage(Storage) ? 1 : 0;
		break;
	case 3:
		RetVal = LoadFromStorage_CSV(Storage, true, bWithColNames) ? 1 : 0;
		break;
	case 4:
		RetVal = LoadFromStorage_CSV(Storage, false, bWithColNames) ? 1 : 0;
		break;
	}

	fclose(f);

	return TRUE;
}

BOOL CVTExtended::defsSaveToString(int nParam, CValue* param) const
{
	switch( nParam )
	{
	case 0:
		*param = 1L;
		break;
	}
	return TRUE;
}

BOOL CVTExtended::funcSaveToString(CValue& RetVal, CValue** params)
{
	bool bInnerFormat = params[0]->GetNumeric() != 0L;
	CVTExtIndex *pIndex = GetIndex(params[1]);
	CSerialStorage Storage;
	SaveToStorage(Storage, pIndex, bInnerFormat);
	RetVal = Storage.GetResultString();
	return TRUE;
}

BOOL CVTExtended::procLoadFromString(CValue** params)
{
	CSerialStorage Storage(params[0]->GetString());
	LoadFromStorage(Storage);
	return TRUE;
}

void CVTExtended::Group(CStringArrayEx const& arrGroupings, int* arrSumCols, int nSumCols, bool bSaveLastLevel, bool bRemoveColumns, int nGrouping)
{
	CStringArrayEx IndexParts;
	IndexParts.FillSeparateString(arrGroupings[nGrouping], ":");
	if( IndexParts.GetSize() != 2 )
		RuntimeError("   %i: '%s'", nGrouping+1, arrGroupings[nGrouping]);

	bool bIsLastLevel = arrGroupings.GetUpperBound() <= nGrouping;

	int nColumns = GetColumnsCount();
	int nChildrenCol = -1;
	if( !bIsLastLevel || bSaveLastLevel )
		nChildrenCol = NewColumn("");

	int nIndex = Indexes.AddIndex(IndexParts[0], IndexParts[1], false, this);
	CVTExtIndex *pIndex = Indexes[nIndex];

	bool *deleted = new bool[GetRowsCount()];
	memset((void*)deleted, 0, sizeof(bool) * GetRowsCount());

	CValue *Sums = new CValue[nSumCols];

	CVTExtIndexTreeNode *node = pIndex->Min(pIndex->Root);
	while( node != pIndex->Nil )
	{
		int nRow = node->ID;
		CVTExtRow *pRow = GetRow(nRow);
		CVTExtended *pChildVT = NULL;
		if( nChildrenCol >= 0 )
		{
			CValue& vVT = pRow->GetValue(nChildrenCol);
			vVT.CreateObject("IndexedTable");
			pChildVT = CValue2VTExt(vVT);

			for( int nColName = 0; nColName < nColumns; nColName++ )
			{
				pChildVT->NewColumn(ColumnName(nColName));
			}

			//   
			pChildVT->NewRow();
			*(pChildVT->GetRow(0)) = *pRow;
		}

		if( node->ArrayEqualIDs )
		{
			pIndex->CurrentNode = node;
			int nEquals = node->ArrayEqualIDs->size();
			
			//    
			for( int nSumCol = 0; nSumCol < nSumCols; nSumCol++ )
			{
				pIndex->NodeSum(arrSumCols[nSumCol], Sums[nSumCol]);
			}

			//   
			for( int i = 0; i < nEquals; i++ )
			{
				deleted[ node->ArrayEqualIDs->at(i) ] = true;
			}

			if( nChildrenCol >= 0 )
			{
				//       
				for( int i = 0; i < nEquals; i++ )
				{
					int nRow = node->ArrayEqualIDs->at(i);
					CVTExtRow* pRow = GetRow(nRow);
					pChildVT->Rows.Add(pRow);
				}
			}
		}

		//  
		if( pChildVT && !bIsLastLevel )
			pChildVT->Group(arrGroupings, arrSumCols, nSumCols, bSaveLastLevel, bRemoveColumns, nGrouping + 1);

		//   
		if( node->ArrayEqualIDs )
		{
			for( int nSumCol = 0; nSumCol < nSumCols; nSumCol++ )
			{
				pRow->SetValue(arrSumCols[nSumCol], Sums[nSumCol]);
			}
		}

		node = pIndex->Successor(node);
	}

	//,     -,    Rows
	for( int nRow = GetRowsCount() - 1; nRow >= 0; nRow-- )
	{
		if( deleted[nRow] )
		{
			if( nChildrenCol < 0 )
				delete GetRow(nRow);
			Rows.RemoveAt(nRow);
		}
	}
	delete[] deleted;

	Indexes.Reindex();
}

BOOL CVTExtended::defsGroup(int nParam, CValue* param) const
{
	switch( nParam )
	{
	case 2:
		*param = 0L;
		break;
	case 3:
		*param = 0L;
		break;
	}
	return TRUE;
}

BOOL CVTExtended::procGroup(CValue** params)
{
	CString Groupings = params[0]->GetString();
	CString SumCols = params[1]->GetString();
	bool bSaveLastLevel = params[2]->GetNumeric() != 0;
	bool bRemoveColumns = params[3]->GetNumeric() != 0;

	CStringArrayEx arrGroupings;
	arrGroupings.FillSeparateString(Groupings, ";");
	if( arrGroupings.GetSize() == 0 )
		RuntimeError("   !");

	CStringArrayEx arrSumColNames;
	arrSumColNames.FillSeparateString(SumCols, ",");
	int* arrSumCols = new int[arrSumColNames.GetSize()];
	for( int nSumCol = arrSumColNames.GetUpperBound(); nSumCol >= 0; nSumCol-- )
	{
		int nCol = ColumnNames[arrSumColNames[nSumCol]];
		arrSumCols[nSumCol] = nCol;
	}

	Group(arrGroupings, arrSumCols, arrSumColNames.GetSize(), bSaveLastLevel, bRemoveColumns, 0);

	delete[] arrSumCols;

	return TRUE;
}

BOOL CVTExtended::funcShowTable(CValue& RetVal, CValue** params)
{
	CValue VT;
	VT.CreateObject("ValueTable");

	CValueTable* pVT = CValue2VT(VT);
	CVTExtIndex* pIndex = GetIndex(params[3]);

	DumpIntoVT(pVT, pIndex);

	int nMethod = VT.GetContext()->FindMethod("ChooseLine");
	CValue* pParams[3] = {params[0], params[1], params[2]};
	int res = VT.GetContext()->CallAsFunc(nMethod, RetVal, pParams);

	return TRUE;
}

//===========================================================================
// Inner methods
//===========================================================================
void CVTExtended::CheckBounds_Row(int row) const
{
	if( row < 0 )
		RuntimeError("      1!");
	if( row > Rows.GetUpperBound() )
		RuntimeError("   !    = %i,   = %i", row+1, Rows.GetUpperBound()+1);
}
void CVTExtended::CheckBounds_Col(int col) const
{
	if( col < 0 )
		RuntimeError("      1!");
	else if( col >= ColumnNames.GetCount() )
		RuntimeError("   !    = %i,   = %i", col+1, ColumnNames.GetCount());
}
void CVTExtended::CheckBounds(int row, int col) const
{
	CheckBounds_Row(row);
	CheckBounds_Col(col);
}

CVTExtIndex* CVTExtended::GetIndex(CValue* IndexName)
{
	if( IndexName->IsEmpty() )
		return DefaultIndex;
	else
		return Indexes[IndexName];
}


void CVTExtended::SetCurrentRow(CVTExtIndex* Index)
{
	if( Index != DefaultIndex ) DefaultIndex->SetCurrentRow(Index->GetCurrentRow());
}

CValue& CVTExtended::GetValue(int row, int col)
{
	CheckBounds(row, col);
	return GetRow(row)->GetValue(col);
}

void CVTExtended::SetValue(int row_num, int col_num, CValue const& val)
{
	CVTExtRow *row = GetRow(row_num);
	row->SetValue(col_num, val);
	Indexes.OnChangeValue(row_num, col_num);
}


LPCSTR CVTExtended::ColumnName(int ColNum) const
{
	POSITION pos = ColumnNames.GetStartPosition();
	CString ColName;
	int i;
	while( pos )
	{
		ColumnNames.GetNextAssoc(pos, ColName, i);
		if( i == ColNum ) return ColName;
	}
	return NULL;
}

int CVTExtended::ColumnNumber(CString const& ColName, bool bQuiet)
{
	int nCol;
	if( !ColumnNames.Lookup(ColName, nCol) )
	{
		if( !bQuiet ) RuntimeError(" '%s'  !", (LPCSTR)ColName);
		return -1;
	}
	return nCol;
}

int CVTExtended::ColumnNumber(CValue* ColNum, bool bQuiet)
{
	int col_num;
	switch( ColNum->GetTypeCode() )
	{
	case 1:
		col_num = (int)(ColNum->GetNumeric()) - 1;
		CheckBounds_Col(col_num);
		break;
	case 2:
		col_num = ColumnNumber(ColNum->GetString(), bQuiet);
		break;
	default:
		col_num = ColumnNumber(ColNum->Format(), bQuiet);
	}
	return col_num;
}


//==================================================================================
//      
//==================================================================================
int CVTExtended::GetNProps(void)const
{
	return ColumnNames.GetCount() + VTExt_FixedProp_Last;
}

int CVTExtended::FindProp(char const * Name)const
{
	int i;
	if( FixedProps.Lookup(Name, i) )
	{
		return i;
	}
	if( ColumnNames.Lookup(Name, i) )
	{
		return i + VTExt_FixedProp_Last;
	}
	return -1;
}

char const *  CVTExtended::GetPropName(int A, int B)const
{
	if( A <= ColumnNames.GetCount() ) return ColumnName(A);
	return NULL;
}

int CVTExtended::GetPropVal(int iPropNum, class CValue & lValue) const
{
	switch( iPropNum )
	{
	case VTExt_FixedProp_CurrentRowRus:
	case VTExt_FixedProp_CurrentRowEng:
		propGetCurrentRow(lValue);
		break;
	default:
		//Message(mmBlueTriangle, "Get NumCol = %i", (int)(iPropNum - VTExt_FixedProp_Last));
		DefaultIndex->GetCurrentValue(iPropNum - VTExt_FixedProp_Last, lValue);
	}
	return 1;
}

int CVTExtended::SetPropVal(int iPropNum, class CValue const & vValue)
{
	switch( iPropNum )
	{
	case VTExt_FixedProp_CurrentRowRus:
	case VTExt_FixedProp_CurrentRowEng:
		propSetCurrentRow(vValue);
		break;
	default:
		DefaultIndex->SetCurrentValue(iPropNum - VTExt_FixedProp_Last, vValue);
		Indexes.OnChangeValue(DefaultIndex->GetCurrentRow(), iPropNum - VTExt_FixedProp_Last);
	}
	return 1;
}

int CVTExtended::IsPropReadable(int iPropNum)const
{
	return 1;
}

int CVTExtended::IsPropWritable(int iPropNum)const
{
	return 1;
}

int CVTExtended::SaveToString(CString &str)
{
	CSerialStorage Storage("");

	CVTExtIndex *pIndex = DefaultIndex;
	if( !(pIndex->IsEmpty()) ) pIndex = new CVTExtIndex("", this);

	SaveToStorage(Storage, pIndex, true);

	if( pIndex != DefaultIndex ) delete pIndex;

	str = Storage.GetResultString();

	return TRUE;
}


//======================================================================================
//======================================================================================
//======================================================================================
CVTExtended* CValue2VTExt(CValue const& Value)
{
	if( Value.GetTypeCode() != AGREGATE_TYPE_1C ) return NULL;

    CBLContext* pVTContext = Value.GetContext();
	if( strcmp(pVTContext->GetRuntimeClass()->m_lpszClassName, "CVTExtended") == 0 )
	{
		return (CVTExtended*)pVTContext;
	}
	else if( strcmp(pVTContext->GetRuntimeClass()->m_lpszClassName, "CComponentClass") == 0 )
	{
		CValue vBaseClass;
		if( static_cast<CComponentClass*>(pVTContext)->GetBaseClass("", vBaseClass) )
		{
			return (CVTExtended*)(vBaseClass.GetContext());
		}
	}

	return NULL;
}

int GetVTColumnNumber(CVTExtended* pVT, CValue const* pVal, CValue const* pDefVal)
{
	CValue* pRealVal = (CValue*)pVal;

	if( pVal->IsEmpty() ) pRealVal = (CValue*)pDefVal;
	if( pRealVal->IsEmpty() ) return -1;

	if( pRealVal->GetTypeCode() == NUMBER_TYPE_1C )
		return (int)(pRealVal->GetNumeric()) - 1;
	else
	{
		try 
		{
			return pVT->ColumnNumber(pRealVal);
		}
		catch(...)
		{
			return -1;
		}
	}
}

CValueTable* CValue2VT(CValue const& Value)
{
	if( Value.GetTypeCode() != AGREGATE_TYPE_1C ) return NULL;

    CBLContext* pVTContext = Value.GetContext();
	if( strcmp(pVTContext->GetRuntimeClass()->m_lpszClassName, "CValueTableContext") == 0 )
	{
		return ((CValueTableContextData*)pVTContext->GetInternalData())->GetValueTable();
	}
	else if( strcmp(pVTContext->GetRuntimeClass()->m_lpszClassName, "CComponentClass") == 0 )
	{
		CValue vBaseClass;
		if( static_cast<CComponentClass*>(pVTContext)->GetBaseClass("", vBaseClass) )
		{
			pVTContext = vBaseClass.GetContext();
			return ((CValueTableContextData*)pVTContext->GetInternalData())->GetValueTable();
		}
	}

	return NULL;
}

int GetVTColumnNumber(CValueTable* pVT, CValue const* pVal, CValue const* pDefVal)
{
	CValue* pRealVal = (CValue*)pVal;

	if( pVal->IsEmpty() ) pRealVal = (CValue*)pDefVal;
	if( pRealVal->IsEmpty() ) return -1;

	if( pRealVal->GetTypeCode() == NUMBER_TYPE_1C )
		return (int)(pRealVal->GetNumeric()) - 1;
	else
		return pVT->GetColumnIdx(pRealVal->GetString());
}


CPValueArray* CValue2VL(CValue const& Value)
{
    if( Value.GetTypeCode() != AGREGATE_TYPE_1C )
		return NULL;
	if( strcmp(Value.GetContext()->GetRuntimeClass()->m_lpszClassName, "CValueListContext") != 0 )
		return NULL;

	return (CPValueArray*)(((CValueListContext*)(Value.GetContext()))->m_pValueItemList);
}

void RuntimeError(char *msg, ...)
{
	CString str;
	va_list ap;
	va_start(ap, msg);
	str.FormatV(msg, ap);
	va_end(ap);

	CBLModule::RaiseExtRuntimeError((LPCSTR)str, mmRedErr);
}

extern class CBkEndUI * pBkEndUI;
void Message(MessageMarker marker, char *msg, ...)
{
	CString str;
	va_list ap;
	va_start(ap, msg);
	str.FormatV(msg, ap);
	va_end(ap);

	pBkEndUI->DoMessageLine((LPCSTR)str, marker);
}

void Message(char *msg, ...)
{
	CString str;
	va_list ap;
	va_start(ap, msg);
	str.FormatV(msg, ap);
	va_end(ap);

	pBkEndUI->DoMessageLine((LPCSTR)str, mmBlueTriangle);
}
