//////////////////////////////////////////////////////////////////////
//  
//
// :   aka ADirks
// : e-mail: adirks@ngs.ru, ICQ: 13472890
//////////////////////////////////////////////////////////////////////


#pragma once

#include "../mycontextbase.h"
#include "RBTree.h"
#include "../StringArrayEx.h"
#include "SerialStorage.h"


class CVTIndexRecord;
class CVTExtended;

typedef enum { CmpByStringRepr, CmpByInnerRepr } TCompareType ;
typedef struct {
	int ColumnNumber;
	int Direction;
	TCompareType CompareType;
	bool TrimStrings;
	bool NoCaseStringCompare;
} TVTIndexDescrRecord;

typedef CArray<class CValueItem *,class CValueItem *> CPValueArray;
typedef CArray<int, int> CIntArray;
typedef CIStringMap<int, int> CIStringMapInt;
typedef CRBTree<CVTIndexRecord, CVTIndexRecord&, int, int>  CVTExtIndexTree;
typedef CBinaryTreeNode<CVTIndexRecord, int> CVTExtIndexTreeNode;
typedef vector<TVTIndexDescrRecord> TVTExtIndexFields;


CVTExtended* CValue2VTExt(CValue const& Value);
CValueTable* CValue2VT(CValue const& Value);
int GetVTColumnNumber(CValueTable* pVT, CValue const* pVal, CValue const* pDefVal);
int GetVTColumnNumber(CVTExtended* pVT, CValue const* pVal, CValue const* pDefVal);
CPValueArray* CValue2VL(CValue const& Value);

void RuntimeError(char *msg, ...);
void Message(MessageMarker marker, char *msg, ...);
void Message(char *msg, ...);


class CVTExtRow
{
public:
	CPtrArray Values;

	CVTExtRow(int numValues);
	~CVTExtRow();

	int NewColumn();
	void RemoveColumn(int col_num) { Values.RemoveAt(col_num); }


	CVTExtRow& operator= (CVTExtRow const& SrcRow);
	CValue& GetValue(int i) const { return *((CValue*)(Values[i])); }
	CValue& SetValue(int i, CValue const& val) { return (CValue&)(*((CValue*)(Values[i])) = val); }
};


class CVTIndexRecord
{
public:
	CVTExtRow *Row;
	TVTExtIndexFields *IndexFields;

public:
	CVTIndexRecord() {}
	CVTIndexRecord(CVTExtRow *aRow, TVTExtIndexFields *aIndexFields) { Row = aRow; IndexFields = aIndexFields; }
	~CVTIndexRecord() {}
	CVTIndexRecord& operator= (CVTIndexRecord const& rec) { Row = rec.Row; IndexFields = rec.IndexFields; return *this; }

	int compare(CVTIndexRecord& RightRecord);
};


class CVTExtPosition
{
	friend class CVTExtIndex;
private:
	int CurrentRow;
	CVTExtRow *pCurrentRow;
	CVTExtIndexTreeNode* CurrentNode;
	int IndexInNode;
	bool SelStarted;
public:
	CVTExtPosition& operator= (CVTExtIndex& Index);
};

class CVTExtFilter
{
public:
	CVTExtRow Row_min, Row_max;
	CVTIndexRecord Rec_min, Rec_max;

	CVTExtFilter(int ColumnsCount, TVTExtIndexFields *pIndexFields);
	CVTExtFilter(int ColumnsCount, TVTExtIndexFields *pIndexFields, CValue const& Min, CValue const& Max);
	void Set(CValue const& Min, CValue const& Max);

	CVTExtFilter& operator= (CVTExtFilter& SrcFilter);

	void NewColumn() { Row_min.NewColumn(); Row_max.NewColumn(); }
	void RemoveColumn(int col_num) { Row_min.RemoveColumn(col_num); Row_max.RemoveColumn(col_num); }
};
///////////////////////////////////////////////////////////////////////////
class CVTExtIndex : public CVTExtIndexTree, public CCollectionItem
{
	friend class CVTExtPosition;
	friend class CVTExtended;
private:
	CVTExtended* pVT;
	TVTExtIndexFields IndexFields;

	CVTExtRow KeyRow;
	CVTExtFilter *pFilter;

	int CurrentRow;
	CVTExtRow *pCurrentRow;
	CVTExtIndexTreeNode* CurrentNode;
	int IndexInNode;
	bool SelStarted;

public:
	CVTExtIndex(LPCSTR Name, CString const& IndexExpression, bool bUnique, CVTExtended* vt);
	CVTExtIndex(LPCSTR Name, CVTExtended* vt);
	~CVTExtIndex();
	CVTExtIndex& operator= (CVTExtPosition& Pos);
	CVTExtIndex& operator= (CVTExtIndex& SrcIndex);

	void Reindex();
	void Reindex(CString& IndexExpression);

	void InsertRow(CVTExtRow* row, int row_num);
	void RemoveRow(int row_num);
	void RemoveAllRows();
	void OnChangeRow(int row_num);
	void OnChangeValue(int row_num, int col_num);

	bool ColumnIndexed(int col_num);
	void NewColumn();
	void RemoveColumn(int col_num);

	CVTExtIndexTreeNode* Find(CPtrArray* pKeyValues);
	int Find(CValue const& What, bool FindLast, bool ChangePosition);
	int FindNearestGE(CValue const& What, bool ChangePosition);
	int FindNearestLE(CValue const& What, bool ChangePosition);

	int KeyCount(CValue const& What);

	void SetFilter(CValue const& Min, CValue const& Max);
	void SetFilter(CValue const& SubSet, int nCols);
	void DropFilter();
	int GetRowsCount(); //   

	bool First();
	bool Last();
	bool Next(bool bUnique = false);
	bool Prev(bool bUnique = false);

	int  GetCurrentRow() { return CurrentRow; }
	void SetCurrentRow(int row_num);
	void SetCurrentValue(int col_num, CValue const& NewVal);
	void GetCurrentValue(int col_num, CValue& RetVal);

	void GroupBy(CString Columns);
	void Sum(int col_num, CValue& RetVal);
	void NodeSum(int col_num, CValue& RetVal);

private:
	void ResetPosition();
	int PositioningOnNode(CVTExtIndexTreeNode* node, bool FindLastRow, bool ChangePosition);
	bool BuildIndexFields(CString IndexExpr, TVTExtIndexFields& IndexFields, LPCSTR strInfo);
	void RemoveRowFromTree(int row_num, int delta);

	void GoToNode_Backward(bool bUnique);
};

///////////////////////////////////////////////////////////////////////////
class CVTExtIndexCollection: public CCollection
{
public:
	~CVTExtIndexCollection() { RemoveAll(); }

	CVTExtIndex* operator [](int nIndex) const;
	CVTExtIndex* operator [](LPCSTR szName) const;
	CVTExtIndex* operator [](CValue* Index) const;

	int AddIndex(CVTExtIndex* pIndex);
	int AddIndex(CString& IndexName, CString& IndexExpr, bool bUnique, CVTExtended* pVT);
	void RemoveIndex(int nIndex);
	void RemoveIndex(CVTExtIndex* Index);
	void RemoveAll();

	void Reindex();

	bool ColumnIndexed(int col_num);
	void NewColumn();
	void RemoveColumn(int col_num);

	void InsertRow(CVTExtRow* row, int row_num);
	void RemoveRow(int row_num);
	void RemoveAllRows();
	void OnChangeValue(int row_num, int col_num);
	void OnChangeRow(int row_num);
};


///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
class CVTExtended : public CMyContextBase
{
	DECLARE_DYNCREATE(CVTExtended);

	friend class CVTExtIndex;

private:
	CPtrArray Rows;
	CIStringMapInt FixedProps;
	CIStringMapInt ColumnNames;
	
	CVTExtIndexCollection Indexes;
	CVTExtIndex* DefaultIndex;

private:
	void SetRow(int i, CVTExtRow* aRow) { Rows[i] = aRow; }
	CVTExtRow* GetRow(int i) { return (CVTExtRow*)(Rows[i]); }

	void CheckBounds_Row(int row) const;
	void CheckBounds_Col(int col) const;
	void CheckBounds(int row, int col) const;

	CVTExtIndex* GetIndex(CValue* IndexName);

	static int* ColumnNumbersMap(CVTExtended* pDest, CVTExtended* pSrc, bool bJoinColumns);
	static int* ColumnNumbersMap(CVTExtended* pDest, CValueTable* pSrc, bool bJoinColumns);
	static int* ColumnNumbersMap(CVTExtended* pDest, CPtrArray* ppValueList);
	static void CopyRowFromVTExt(CVTExtRow *pDest, CVTExtRow *pSrc, int nColumns, int *pColNumbersMap);
	static void CopyRowFromVL(CVTExtRow *pDest, CPtrArray* ppValueList, int *pColNumbersMap);
	static void FillKeyRow(CVTExtRow & KeyRow, CVTExtRow& SrcRow, 
					TVTExtIndexFields& DestIdxFields, TVTExtIndexFields& SrcIdxFields, 
					int nKeyFields);

	void Group(CStringArrayEx const& arrGroupings, int* arrSumCols, int nSumCols, bool bSaveLastLevel, bool bRemoveColumns, int nGrouping);

public:
	CVTExtended();
	~CVTExtended();

	BOOL procCleanup(CValue** params);

	int NewColumn(CString const& ColumnName);
	BOOL funcNewColumn(CValue& RetVal, CValue** params);
	void RemoveColumn(int nCol, bool bCheckIndexes = true);
	BOOL procRemoveColumn(CValue** params);
	LPCSTR ColumnName(int ColNum) const;
	BOOL funcGetColumnName(CValue& RetVal, CValue** params);
	BOOL funcGetColumnNumber(CValue& RetVal, CValue** params);
	int ColumnNumber(CString const& ColName, bool bQuiet = false);
	int ColumnNumber(CValue* ColNum, bool bQuiet = false);
	int GetColumnsCount() { return ColumnNames.GetCount(); }
	BOOL funcGetColCount(CValue& RetVal, CValue** params);

	int NewRow();
	BOOL funcNewRow(CValue& RetVal, CValue** params);
	BOOL procRemoveRow(CValue** params);
	BOOL procRemoveAllRows(CValue** params);
	int GetRowsCount() { return Rows.GetUpperBound() + 1; }
	BOOL funcGetRowsCount(CValue& RetVal, CValue** params);
	void propGetCurrentRow(CValue& RetVal) const { RetVal = 1L + DefaultIndex->GetCurrentRow(); }
	void propSetCurrentRow(CValue const& Value);
	void SetCurrentRow(CVTExtIndex* Index);
	BOOL funcGetCurrentRow(CValue& RetVal, CValue** params);

	BOOL funcGetValue(CValue& RetVal, CValue** params); 
	BOOL procSetValue(CValue** params);
	BOOL funcSum(CValue& RetVal, CValue** params);
	BOOL funcNodeSum(CValue& RetVal, CValue** params);

	CValue& GetValue(int row, int col);
	void SetValue(int row, int col, CValue const& val);
	CValue& CurRow_GetValue(int col) const;
	void CurRow_SetValue(int col, CValue const& val);

	//operations with index
	BOOL funcAddIndex(CValue& RetVal, CValue** params);
	BOOL procDropIndex(CValue** params);
	BOOL procReindex(CValue** params);

	BOOL funcIndexIsUnique(CValue& RetVal, CValue** params);
	BOOL funcUniqueKeyCount(CValue& RetVal, CValue** params);
	BOOL funcKeyValueCount(CValue& RetVal, CValue** params);

	BOOL funcFindRow(CValue& RetVal, CValue** params);
	BOOL funcFindNearestGE(CValue& RetVal, CValue** params);
	BOOL funcFindNearestLE(CValue& RetVal, CValue** params);
	
	BOOL procSetFilter(CValue** params);
	BOOL procSetFilter2(CValue** params);
	BOOL procDropFilter(CValue** params);

	BOOL defsNextRow(int nParam, CValue* param) const;
	BOOL funcFirstRow(CValue& RetVal, CValue** params);
	BOOL funcNextRow(CValue& RetVal, CValue** params);
	BOOL funcLastRow(CValue& RetVal, CValue** params);
	BOOL funcPrevRow(CValue& RetVal, CValue** params);

	BOOL procGroupBy(CValue** params);

	BOOL procFillRow(CValue** params);
	BOOL defsFillRow(int nParam, CValue* param) const;
	BOOL procFillColumn(CValue** params);
	BOOL defsFillColumn(int nParam, CValue* param) const;

	void LoadFromVTExt(CVTExtended* pVTExt, CValue* IndexName, bool bMerge);
	void LoadFromVT(CValueTable* pVT, bool bMerge);
	void DumpIntoVT(CValueTable* pVT, CVTExtIndex* pIndex);
	BOOL procDumpIntoVT(CValue** params);
	BOOL procLoadFromVT(CValue** params);
	BOOL procUnionVT(CValue** params);
	BOOL procConjunctionVT(CValue** params);

	BOOL funcCopy(CValue& RetVal, CValue** params);

	BOOL defsSaveToFile(int nParam, CValue* param) const;
	BOOL procSaveToFile(CValue** params);
	void SaveToStorage(CSerialStorage& Storage, CVTExtIndex *pIndex, bool InnerFormat);
	void SaveToStorage_CSV(CSerialStorage& Storage, CVTExtIndex *pIndex, bool InnerFormat, bool bWithColNames);

	BOOL defsLoadFromFile(int nParam, CValue* param) const;
	BOOL funcLoadFromFile(CValue& RetVal, CValue** params);
	bool LoadFromStorage(CSerialStorage& Storage);
	bool LoadFromStorage2(CSerialStorage& Storage);
	bool LoadFromStorage_CSV(CSerialStorage& Storage, bool bInnerFormat, bool bWithColNames);

	BOOL defsSaveToString(int nParam, CValue* param) const;
	BOOL funcSaveToString(CValue& RetVal, CValue** params);
	BOOL procLoadFromString(CValue** params);

	BOOL defsGroup(int nParam, CValue* param) const;
	BOOL procGroup(CValue** params);

	BOOL funcShowTable(CValue& RetVal, CValue** params);

public:
	//      
	virtual int				GetNProps(void)const;
	virtual int				FindProp(char const* szName)const;
	virtual char const* 	GetPropName(int nPropIndex, int nAlias)const;
	virtual int				GetPropVal(int nPropIndex, class CValue& Value) const;
	virtual int				SetPropVal(int nPropIndex, class CValue const& Value);
	virtual int				IsPropReadable(int nPropIndex)const;
	virtual int				IsPropWritable(int nPropIndex)const;
	virtual int             IsSerializable(void) { return TRUE; }
	virtual int				SaveToString(CString &str);

protected:
    virtual void Release() {DecrRef();};

	DECLARE_MY_CONTEXT()
};


