// v7Windows.cpp: implementation of the Cv7Windows class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "addin.h"
#include "v7Windows.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

extern CBkEndUI * pBkEndUI;
extern CMDIFrameWnd * pMainWindow;
extern CWinApp* pApp;
extern UINT uMainWindowStyle;
extern UINT uChildWindowStyle;
extern UINT uChildModalWindowStyle;
extern BOOL bModalState;
extern CStringArray unvisibleMenus;
extern CStringArray unenableMenus;
extern CDWordArray srcMenus;
extern CDWordArray tempMenus;
extern bool bMinimizeToTray;
extern NOTIFYICONDATA	nidIconData;

IMPLEMENT_DYNCREATE(Cv7Windows,CBLContext);

class CObjID Cv7Windows::ObjID;

struct Cv7Windows::paramdefs Cv7Windows::defFnNames[] = {
	{{"GetMenu",""}, TRUE, 0},
	{{"EnableMenu",""}, TRUE, 2},
	{{"VisibleMenu",""}, TRUE, 2},
	{{"GetToolBars",""}, TRUE, 0},
	{{"ShowToolBar",""}, TRUE, 2},
	{{"ShowToolBars",""}, TRUE, 1},
	{{"ShowStatusBar",""}, TRUE, 1},
	{{"WindowsStyle",""}, TRUE, 2},
	{{"WindowsSize",""}, TRUE, 4},
	{{"WindowsPos",""}, TRUE, 3},
	{{"WindowsMenu",""}, TRUE, 5},
	{{"CenterWindow",""}, TRUE, 1},
	{{"Maximize",""}, TRUE, 1},
	{{"Minimize",""}, TRUE, 1},
	{{"Restore",""}, TRUE, 1},
	{{"GetResolution",""}, TRUE, 2},
	{{"BringWindowToTop",""}, TRUE, 1},
	{{"BeginModalState",""}, TRUE, 0},
	{{"EndModalState",""}, TRUE, 0},
	{{"MinimizeToTray",""}, FALSE, 1},
	{NULL,0,0}
};

Cv7Windows::Cv7Windows(int param):CBLContext(param)
{

}

Cv7Windows::~Cv7Windows()
{
}

void Cv7Windows::MenuToValueList(CMenu* pNextMenu, CValue& retValue)
{
	if(pNextMenu)
	{
		CBLContext* pVLCont = CBLContext::CreateInstance("");
		if(pVLCont)
		{
			int num = pVLCont->FindMethod("AddValue");
			if(num >= 0)
			{
				CString st = "";
				CValue v1;
				CValue v2 = st;
				CValue *pParam[2] = {&v1, &v2};
				UINT c = pNextMenu->GetMenuItemCount();
				if(c != 0xFFFFFFFF)
				{
					for(UINT i = 0; i < c ; i++)
					{
						//CString stDeb = "";
						//stDeb.Format("%x",pNextMenu->GetMenuItemID(i));
						//stDeb.Format("%x",pNextMenu->GetMenuState(i,MF_BYPOSITION));
						//stDeb.MakeUpper();
						CString stMenu = "";
						pNextMenu->GetMenuString(i,stMenu,MF_BYPOSITION);
						//if(!stMenu.IsEmpty())
						{
							CMenu* pSubMenu = pNextMenu->GetSubMenu(i);
							v1 = pNextMenu->GetMenuItemID(i);
							MenuToValueList(pSubMenu, v1);
							//v2 = stDeb+"h :: "+stMenu;
							v2 = stMenu;
							pVLCont->CallAsProc(num,pParam);
						}
					}
					retValue.AssignContext(pVLCont);
				}
			}
			pVLCont->DecrRef();
		}
	}
}

void Cv7Windows::SetMenuItemStyle(CMenu* pNextMenu,CString& stName,UINT uStyle)
{
	if(pNextMenu)
	{
		UINT c = pNextMenu->GetMenuItemCount();
		if(c != 0xFFFFFFFF)
		for(UINT i = 0; i < c ; i++)
		{
			CString stMenu = "";
			pNextMenu->GetMenuString(i,stMenu,MF_BYPOSITION);
			stMenu.TrimLeft();
			stMenu.TrimRight();
			if(stMenu.CompareNoCase(stName) == 0)
			{
				MENUITEMINFO MenuItemInfo;
				MenuItemInfo.cbSize = sizeof(MENUITEMINFO);
				MenuItemInfo.fMask = MIIM_ID;
				pNextMenu->GetMenuItemInfo(i,&MenuItemInfo,TRUE);
				UINT idMenu = MenuItemInfo.wID;
				pNextMenu->EnableMenuItem(i,MF_BYPOSITION | uStyle);
			}
		}
	}
}

void Cv7Windows::SetVisibleMainMenu(CMenu* pMenu)
{
	int n = unvisibleMenus.GetSize();
	int nn = srcMenus.GetSize();
	int p = -1;
	for(int i = 0; i < nn; i++)
		if(srcMenus.GetAt(i) == (DWORD)pMenu->GetSafeHmenu()) p = i;

	if(p >= 0)
	{
		CMenu *pMenuT = CMenu::FromHandle((HMENU)tempMenus.GetAt(p));
		if(pMenuT)
		{
			if(int(pMenu->GetMenuItemCount()) >= 0)
			{
				while(pMenu->GetMenuItemCount()) pMenu->DeleteMenu(0,MF_BYPOSITION);
				CopyMenu(pMenuT,pMenu, true);
			}
		}
	}
	else
	{
		CMenu cMenu;
		cMenu.CreateMenu();
		CopyMenu(pMenu,&cMenu, true);
		tempMenus.Add((DWORD)cMenu.Detach());
		srcMenus.Add((DWORD)pMenu->GetSafeHmenu());
	}

	for(i = 0; i < n; i++)
	{
		CString st = unvisibleMenus.GetAt(i);
		int nnn = pMenu->GetMenuItemCount();
		for(int f = 0; f < nnn; f++)
		{
			CString stMenu = "";
			pMenu->GetMenuString(f,stMenu,MF_BYPOSITION);
			if(stMenu == st)
			{
				pMenu->DeleteMenu(f,MF_BYPOSITION);
				f--; nn--;
			}
		}
	}
}

int  Cv7Windows::CallAsFunc(int iMethNum,class CValue & rValue,class CValue * *ppValue)
{
	switch (iMethNum) {
	case methGetMenu:
		{
			CMenu* pMenu = pMainWindow->GetMenu();
			MenuToValueList(pMenu, rValue);
			break;
		}
	case methEnableMenu:
		{
			CString stMenu = ppValue[0]->GetString();
			int flag = ppValue[1]->GetNumeric();
			if(flag == 0)
			{
				bool add = true;
				int n = unenableMenus.GetSize();
				for(int i = 0; i < n; i++)
					if(unenableMenus.GetAt(i) == stMenu)
					{
						add = false;
						//break;
					}
				if(add) unenableMenus.Add(LPCTSTR(stMenu));
			}
			else
			{
				int n = unenableMenus.GetSize();
				for(int i = 0; i < n; i++)
					if(unenableMenus.GetAt(i) == stMenu)
					{
						unenableMenus.RemoveAt(i);
						i--;n--;
					}
			}

			UINT Style = 0;
			if(ppValue[1]->GetNumeric() == 0) Style = MF_GRAYED | MF_DISABLED;
			CString st = "";
			st = ppValue[0]->GetString();
			CMenu7* pMenu1 = (CMenu7*)(((DWORD*)pApp)+0x66);
			CMenu7* pMenu2 = (CMenu7*)(((DWORD*)pApp)+0x68);
			CMenu* pMenu = pMainWindow->GetMenu();

			SetMenuItemStyle(pMenu,st,Style);
			SetMenuItemStyle(pMenu1,st,Style);
			SetMenuItemStyle(pMenu2,st,Style);
			pMainWindow->DrawMenuBar();
			break;
		}
	case methVisibleMenu:
		{
			CString stMenu = ppValue[0]->GetString();
			int flag = ppValue[1]->GetNumeric();
			if(flag == 0)
			{
				bool add = true;
				int n = unvisibleMenus.GetSize();
				for(int i = 0; i < n; i++)
					if(unvisibleMenus.GetAt(i) == stMenu)
					{
						add = false;
						//break;
					}
				if(add) unvisibleMenus.Add(LPCTSTR(stMenu));
			}
			else
			{
				int n = unvisibleMenus.GetSize();
				for(int i = 0; i < n; i++)
					if(unvisibleMenus.GetAt(i) == stMenu)
					{
						unvisibleMenus.RemoveAt(i);
						i--;n--;
					}
			}
			
			CMenu7* pMenu1 = (CMenu7*)(((DWORD*)pApp)+0x66);
			CMenu7* pMenu2 = (CMenu7*)(((DWORD*)pApp)+0x68);
			CMenu* pMenu = pMainWindow->GetMenu();
			SetVisibleMainMenu(pMenu1);
			SetVisibleMainMenu(pMenu2);
			SetVisibleMainMenu(pMenu);

			pMainWindow->DrawMenuBar();
			break;
		}
	case methGetToolBars:
		{
			CBLContext* pVLCont = CBLContext::CreateInstance("");
			if(pVLCont)
			{
				int num = pVLCont->FindMethod("AddValue");
				if(num >= 0)
				{
					CString st = "";
					CValue v1;
					CValue v2 = st;
					CValue *pParam[2] = {&v1, &v2};
					CWnd *pWnd = pMainWindow->GetWindow(GW_CHILD);
					while(pWnd)
					{
						CString st = "";
						BOOL vis = FALSE;
						if((CString("CDockBar7") == pWnd->GetRuntimeClass()->m_lpszClassName) ||
							(CString("CControlBar") == pWnd->GetRuntimeClass()->m_lpszClassName))
						{
							CWnd* pChWnd = pWnd->GetWindow(GW_CHILD);
							while(pChWnd)
							{
								pChWnd->GetWindowText(st);
								if(st.IsEmpty())
									st = " ";

								vis = pChWnd->IsWindowVisible();

								v1 = long(vis);
								v2 = st;

								pVLCont->CallAsProc(num,pParam);

								pChWnd = pChWnd->GetNextWindow();
							}
						}

						pWnd = pWnd->GetNextWindow();
					}
					rValue.AssignContext(pVLCont);
					pVLCont->DecrRef();
				}
			}
			break;
		}
	case methShowToolBar:
		{
			CWnd *pWnd = pMainWindow->GetWindow(GW_CHILD);
			while(pWnd)
			{
				CString st = ppValue[0]->GetString();
				CString stWnd = "";
				BOOL vis = (ppValue[1]->GetNumeric() != 0L);
				if((CString("CDockBar7") == pWnd->GetRuntimeClass()->m_lpszClassName) ||
					(CString("CControlBar") == pWnd->GetRuntimeClass()->m_lpszClassName))
				{
					CWnd* pChWnd = pWnd->GetWindow(GW_CHILD);
					while(pChWnd)
					{
						pChWnd->GetWindowText(stWnd);
						if(stWnd.IsEmpty())
						{
							stWnd = " ";
							if(st == stWnd)
							{
								if(vis)
									pWnd->ShowWindow(SW_SHOW);
								else
									pWnd->ShowWindow(SW_HIDE);
							}
						}
						else
						if(st == stWnd)
						{
							if(vis)
								pChWnd->ShowWindow(SW_SHOW);
							else
								pChWnd->ShowWindow(SW_HIDE);
						}

//CCustomToolBar7(0x1a8)->SECCustomToolBar(0x1a8)->SECControlBar(0x134)->CControlBar(0x7c)->CWnd(0x40)->CCmdTarget(0x20)->CObject(0x4)->
						pChWnd = pChWnd->GetNextWindow();
					}
				}

				pWnd = pWnd->GetNextWindow();
			}
			pMainWindow->RecalcLayout();
			break;
		}
	case methShowToolBars:
		{
			CWnd *pWnd = pMainWindow->GetWindow(GW_CHILD);
			UINT Style = SW_SHOW;
			if(ppValue[0]->GetNumeric() == 0) Style = SW_HIDE;
			while(pWnd)
			{
				if(CString("CDockBar7") == pWnd->GetRuntimeClass()->m_lpszClassName)
					pWnd->ShowWindow(Style);
				else if(CString("CControlBar") == pWnd->GetRuntimeClass()->m_lpszClassName)
					pWnd->ShowWindow(Style);
				pWnd = pWnd->GetNextWindow();
			}
			pMainWindow->RecalcLayout();
			break;
		}
	case methShowStatusBar:
		{
			CWnd *pWnd = pMainWindow->GetWindow(GW_CHILD);
			UINT Style = SW_SHOW;
			if(ppValue[0]->GetNumeric() == 0) Style = SW_HIDE;
			while(pWnd)
			{
				if(CString("SECStatusBar") == pWnd->GetRuntimeClass()->m_lpszClassName)
					pWnd->ShowWindow(Style);
				pWnd = pWnd->GetNextWindow();
			}
			pMainWindow->RecalcLayout();
			break;
		}
	case methWindowStyle:
		{
			bool current = false;
			CFormAllCtrlsContext* pForm;
			CBLContext* pBLCont = ppValue[0]->GetContext();
			if (pBLCont)
			{
				if(!strcmp(pBLCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
				{
					pForm = (CFormAllCtrlsContext*)pBLCont;
					pForm->IncrRef();
					current = true;
				}
			}

			if(current)
			{
				CGetDoc7* pDoc = (CGetDoc7*)pForm->m_GetDoc;

				if (pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd * pWnd = NULL;
					bool modal = false;
					if(pView == NULL)
					{
						pWnd = pDoc->GetFrame();
						pView = pWnd;
						modal = true;
					}
					else
						pWnd = pView->GetParent();

					if(pWnd)
					{
						UINT curStyle = pWnd->GetStyle();
						DWORD style = ppValue[1]->GetNumeric();
						if(style == 0x01)
						{
							if(modal)
							{
								if(uChildModalWindowStyle != 0) curStyle = uChildModalWindowStyle;
								else uChildModalWindowStyle = curStyle;
							}
							else
							{
								if(uChildWindowStyle != 0) curStyle = uChildWindowStyle;
								else uChildWindowStyle = curStyle;
							}
							curStyle ^= WS_BORDER;
						}
						else if((style == 0x02) && modal)
						{
							if(uChildModalWindowStyle == 0) uChildModalWindowStyle = curStyle;
							curStyle = WS_POPUPWINDOW | WS_VISIBLE;
						}
						else if((style == 0x02) && (!modal))
						{
							if(uChildWindowStyle == 0) uChildWindowStyle = curStyle;
							curStyle = 0x0000C000 | WS_DLGFRAME /*WS_THICKFRAME*/ | WS_VISIBLE | WS_CHILD | WS_CLIPSIBLINGS;
						}
						else if(style == 0x00)
						{
							if(modal)
							{
								if(uChildModalWindowStyle != 0) curStyle = uChildModalWindowStyle;
							}
							else
							{
								if(uChildWindowStyle != 0) curStyle = uChildWindowStyle;
							}

						}
						pWnd->ModifyStyle(0xFFFFFFFF,curStyle,SWP_DRAWFRAME);
					}
					pView->Invalidate();
				}
				pForm->DecrRef();
			}
			else
			{
				UINT curStyle = pMainWindow->GetStyle();
				DWORD style = ppValue[1]->GetNumeric();
				if(style == 0x01)
				{
					if(curStyle != (WS_POPUPWINDOW | WS_VISIBLE))
					{
						if(uMainWindowStyle == 0) uMainWindowStyle = curStyle;
						pMainWindow->ModifyStyle(WS_BORDER,0,SWP_DRAWFRAME);
					}
					else if(uMainWindowStyle != 0)
					{
						pMainWindow->ModifyStyle(0xFFFFFFFF,uMainWindowStyle);
						pMainWindow->ModifyStyle(WS_BORDER,0,SWP_DRAWFRAME);
					}
				}
				else if(style == 0x02)
				{
					if(curStyle != (WS_POPUPWINDOW | WS_VISIBLE))
					{
						if(uMainWindowStyle == 0) uMainWindowStyle = curStyle;
						pMainWindow->ModifyStyle(0xFFFFFFFF,WS_POPUPWINDOW | WS_VISIBLE,SWP_DRAWFRAME);
					}
				}
				else
					if((uMainWindowStyle != 0) && (uMainWindowStyle != curStyle))
						pMainWindow->ModifyStyle(0xFFFFFFFF,uMainWindowStyle,SWP_DRAWFRAME);
			}
			break;
		}
	case methWindowSize:
		{
			bool current = false;
			CFormAllCtrlsContext* pForm;
			CBLContext* pBLCont = ppValue[0]->GetContext();
			if (pBLCont)
			{
				if(!strcmp(pBLCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
				{
					pForm = (CFormAllCtrlsContext*)pBLCont;
					pForm->IncrRef();
					current = true;
				}
			}

			if(current)
			{
				CGetDoc7* pDoc = (CGetDoc7*)pForm->m_GetDoc;

				if (pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd * pWnd = NULL;
					bool modal = false;
					if(pView == NULL)
					{
						pWnd = pDoc->GetFrame();
						pView = pWnd;
						modal = true;
					}
					else
						pWnd = pView->GetParent();

					if(pWnd)
					{
						RECT rect;
						pMainWindow->GetWindowRect(&rect);
						int w = rect.right - rect.left;
						int h = rect.bottom - rect.top;
						if(ppValue[1]->type == 1)
							if(ppValue[1]->GetNumeric() > 0)
								rect.right = rect.left + ppValue[1]->GetNumeric();
						if(ppValue[2]->type == 1)
							if(ppValue[2]->GetNumeric() > 0)
								rect.bottom = rect.top + ppValue[2]->GetNumeric();
						(*ppValue[1]) = w;
						(*ppValue[2]) = h;
						pWnd->MoveWindow(&rect);
						pWnd->CenterWindow();
					}
				}
				pForm->DecrRef();
			}
			else
			{
				UINT curStyle = pMainWindow->GetStyle();
				int f = ppValue[3]->GetNumeric();
				if(f == 1)
				{
					if(curStyle != (WS_POPUPWINDOW | WS_VISIBLE))
					{
						if(uMainWindowStyle == 0) uMainWindowStyle = curStyle;
						pMainWindow->ModifyStyle(0xFFFFFFFF,WS_POPUPWINDOW | WS_VISIBLE,SWP_DRAWFRAME);
					}
				}
				else if(f == 2)
					if((uMainWindowStyle != 0) && (uMainWindowStyle != curStyle))
						pMainWindow->ModifyStyle(0xFFFFFFFF,uMainWindowStyle,SWP_DRAWFRAME);
				RECT rect;
				pMainWindow->GetWindowRect(&rect);
				int w = rect.right - rect.left;
				int h = rect.bottom - rect.top;
				if(ppValue[1]->type == 1)
					if(ppValue[1]->GetNumeric() > 0)
						rect.right = rect.left + ppValue[1]->GetNumeric();
				if(ppValue[2]->type == 1)
					if(ppValue[2]->GetNumeric() > 0)
						rect.bottom = rect.top + ppValue[2]->GetNumeric();
				(*ppValue[1]) = w;
				(*ppValue[2]) = h;
				pMainWindow->MoveWindow(&rect);
				if(f != 0)
					pMainWindow->CenterWindow();
			}
			break;
		}
	case methWindowPos:
		{
			bool current = false;
			CFormAllCtrlsContext* pForm;
			CBLContext* pBLCont = ppValue[0]->GetContext();
			if (pBLCont)
			{
				if(!strcmp(pBLCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
				{
					pForm = (CFormAllCtrlsContext*)pBLCont;
					pForm->IncrRef();
					current = true;
				}
			}

			if(current)
			{
				CGetDoc7* pDoc = (CGetDoc7*)pForm->m_GetDoc;

				if (pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd * pWnd = NULL;
					bool modal = false;
					if(pView == NULL)
					{
						pWnd = pDoc->GetFrame();
						pView = pWnd;
						modal = true;
					}
					else
						pWnd = pView->GetParent();

					if(pWnd)
					{
						RECT rect;
						pWnd->GetWindowRect(&rect);
						if(pView)
							pMainWindow->ScreenToClient(&rect);

						int l = rect.left;
						int t = rect.top;
						if(ppValue[1]->type == 1)
							if(ppValue[1]->GetNumeric() >= 0)
							{
								rect.left = ppValue[1]->GetNumeric();
								rect.right = rect.right - l + rect.left;
							}
						if(ppValue[2]->type == 1)
							if(ppValue[2]->GetNumeric() >= 0)
							{
								rect.top = ppValue[2]->GetNumeric();
								rect.bottom = rect.bottom - t + rect.top;
							}
						(*ppValue[1]) = (long)l;
						(*ppValue[2]) = (long)t;
						pWnd->MoveWindow(&rect);
					}
				}
				pForm->DecrRef();
			}
			else
			{
				RECT rect;
				pMainWindow->GetWindowRect(&rect);
				int l = rect.left;
				int t = rect.top;
				if(ppValue[1]->type == 1)
					if(ppValue[1]->GetNumeric() >= 0)
					{
						rect.left = ppValue[1]->GetNumeric();
						rect.right = rect.right - l + rect.left;
					}
				if(ppValue[2]->type == 1)
					if(ppValue[2]->GetNumeric() >= 0)
					{
						rect.top = ppValue[2]->GetNumeric();
						rect.bottom = rect.bottom - t + rect.top;
					}
				(*ppValue[1]) = (long)l;
				(*ppValue[2]) = (long)t;
				pMainWindow->MoveWindow(&rect);
			}
			break;
		}
	case methWindowMenu:
		{
			bool current = false;
			CFormAllCtrlsContext* pForm;
			CBLContext* pBLCont = ppValue[0]->GetContext();
			if (pBLCont)
			{
				if(!strcmp(pBLCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
				{
					pForm = (CFormAllCtrlsContext*)pBLCont;
					pForm->IncrRef();
					current = true;
				}
			}

			if(current)
			{
				CGetDoc7* pDoc = (CGetDoc7*)pForm->m_GetDoc;

				if (pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd * pWnd = NULL;
					bool modal = false;
					if(pView == NULL)
					{
						pWnd = pDoc->GetFrame();
						pView = pWnd;
						modal = true;
					}
					else
						pWnd = pView->GetParent();

					if(pWnd)
					{
						pWnd->GetSystemMenu(TRUE);
						CMenu* pMenu = pWnd->GetSystemMenu(FALSE);
						if(pMenu)
						{
							if(ppValue[1]->GetNumeric() == 0)
								pMenu->DeleteMenu(SC_CLOSE, MF_BYCOMMAND);

							if(ppValue[2]->GetNumeric() == 0)
								pMenu->DeleteMenu(SC_MAXIMIZE, MF_BYCOMMAND);

							if(ppValue[3]->GetNumeric() == 0)
								pMenu->DeleteMenu(SC_MINIMIZE, MF_BYCOMMAND);

							if(ppValue[4]->GetNumeric() == 0)
								pMenu->DeleteMenu(SC_RESTORE, MF_BYCOMMAND);
						}
						//else pBkEndUI->DoMessageLine("pMenu = NULL");
					}
				}
				pForm->DecrRef();
			}
			else
			{
				pMainWindow->GetSystemMenu(TRUE);
				CMenu* pMenu = pMainWindow->GetSystemMenu(FALSE);
				if(pMenu)
				{
					if(ppValue[1]->GetNumeric() == 0)
						pMenu->DeleteMenu(SC_CLOSE, MF_BYCOMMAND);

					if(ppValue[2]->GetNumeric() == 0)
						pMenu->DeleteMenu(SC_MAXIMIZE, MF_BYCOMMAND);

					if(ppValue[3]->GetNumeric() == 0)
						pMenu->DeleteMenu(SC_MINIMIZE, MF_BYCOMMAND);

					if(ppValue[4]->GetNumeric() == 0)
						pMenu->DeleteMenu(SC_RESTORE, MF_BYCOMMAND);
				}
				//else pBkEndUI->DoMessageLine("pMenu = NULL");
			}
			break;
		}
	case methCenterWindow:
		{
			bool current = false;
			CFormAllCtrlsContext* pForm;
			CBLContext* pBLCont = ppValue[0]->GetContext();
			if (pBLCont)
			{
				if(!strcmp(pBLCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
				{
					pForm = (CFormAllCtrlsContext*)pBLCont;
					pForm->IncrRef();
					current = true;
				}
			}

			if(current)
			{
				CGetDoc7* pDoc = (CGetDoc7*)pForm->m_GetDoc;

				if (pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd * pWnd = NULL;
					bool modal = false;
					if(pView == NULL)
					{
						pWnd = pDoc->GetFrame();
						pView = pWnd;
						modal = true;
					}
					else
						pWnd = pView->GetParent();

					if(pWnd) pWnd->CenterWindow();
				}
				pForm->DecrRef();
			}
			else
			{
				pMainWindow->CenterWindow();
			}
			break;
		}
	case methMaximize:
		{
			bool current = false;
			CFormAllCtrlsContext* pForm;
			CBLContext* pBLCont = ppValue[0]->GetContext();
			if (pBLCont)
			{
				if(!strcmp(pBLCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
				{
					pForm = (CFormAllCtrlsContext*)pBLCont;
					pForm->IncrRef();
					current = true;
				}
			}

			if(current)
			{
				CGetDoc7* pDoc = (CGetDoc7*)pForm->m_GetDoc;

				if (pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd * pWnd = NULL;
					bool modal = false;
					if(pView == NULL)
					{
						pWnd = pDoc->GetFrame();
						pView = pWnd;
						modal = true;
					}
					else
						pWnd = pView->GetParent();

					if(pWnd) pWnd->ShowWindow(SW_MAXIMIZE);
				}
				pForm->DecrRef();
			}
			else
			{
				pMainWindow->ShowWindow(SW_MAXIMIZE);
			}
			break;
		}
	case methMinimize:
		{
			bool current = false;
			CFormAllCtrlsContext* pForm;
			CBLContext* pBLCont = ppValue[0]->GetContext();
			if (pBLCont)
			{
				if(!strcmp(pBLCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
				{
					pForm = (CFormAllCtrlsContext*)pBLCont;
					pForm->IncrRef();
					current = true;
				}
			}

			if(current)
			{
				CGetDoc7* pDoc = (CGetDoc7*)pForm->m_GetDoc;

				if (pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd * pWnd = NULL;
					bool modal = false;
					if(pView == NULL)
					{
						pWnd = pDoc->GetFrame();
						pView = pWnd;
						modal = true;
					}
					else
						pWnd = pView->GetParent();

					if(pWnd) pWnd->ShowWindow(SW_MINIMIZE);
				}
				pForm->DecrRef();
			}
			else
			{
				pMainWindow->ShowWindow(SW_MINIMIZE);
			}
			break;
		}
	case methRestore:
		{
			bool current = false;
			CFormAllCtrlsContext* pForm;
			CBLContext* pBLCont = ppValue[0]->GetContext();
			if (pBLCont)
			{
				if(!strcmp(pBLCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
				{
					pForm = (CFormAllCtrlsContext*)pBLCont;
					pForm->IncrRef();
					current = true;
				}
			}

			if(current)
			{
				CGetDoc7* pDoc = (CGetDoc7*)pForm->m_GetDoc;

				if (pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd * pWnd = NULL;
					bool modal = false;
					if(pView == NULL)
					{
						pWnd = pDoc->GetFrame();
						pView = pWnd;
						modal = true;
					}
					else
						pWnd = pView->GetParent();

					if(pWnd) pWnd->ShowWindow(SW_RESTORE);
				}
				pForm->DecrRef();
			}
			else
			{
				pMainWindow->ShowWindow(SW_RESTORE);
			}
			break;
		}
	case methBringWindowToTop:
		{
			bool current = false;
			CFormAllCtrlsContext* pForm;
			CBLContext* pBLCont = ppValue[0]->GetContext();
			if (pBLCont)
			{
				if(!strcmp(pBLCont->GetRuntimeClass()->m_lpszClassName,"CFormAllCtrlsContext"))
				{
					pForm = (CFormAllCtrlsContext*)pBLCont;
					pForm->IncrRef();
					current = true;
				}
			}

			if(current)
			{
				CGetDoc7* pDoc = (CGetDoc7*)pForm->m_GetDoc;

				if (pDoc->ExistWindow())
				{
					POSITION aPOS = ((CDocument*)pDoc)->GetFirstViewPosition();
					CWnd* pView = (CWnd*)((CDocument*)pDoc)->GetNextView(aPOS);
					CWnd * pWnd = NULL;
					bool modal = false;
					if(pView == NULL)
					{
						pWnd = pDoc->GetFrame();
						pView = pWnd;
						modal = true;
					}
					else
						pWnd = pView->GetParent();

					if(pWnd) pWnd->BringWindowToTop();
				}
				pForm->DecrRef();
			}
			else
			{
				pMainWindow->BringWindowToTop();
			}
			break;
		}
	case methGetResolution:
		{
			(*ppValue[0]) = ::GetSystemMetrics(SM_CXSCREEN);
			(*ppValue[1]) = ::GetSystemMetrics(SM_CYSCREEN);
			break;
		}
	case methBeginModalState:
		{
			if(!bModalState)
			{
				bModalState = TRUE;
				HWND hwnd;

				if(hwnd=::FindWindowEx(GetDesktopWindow(),NULL,"Progman",NULL))
					if(hwnd=::FindWindowEx(hwnd,NULL,"SHELLDLL_DefView",NULL))
						::EnableWindow(hwnd, FALSE);
				if(hwnd=::FindWindowEx(::GetDesktopWindow(),NULL,"Shell_TrayWnd",NULL))
					::EnableWindow(hwnd, FALSE);

				::SetWindowPos(pMainWindow->GetSafeHwnd(),HWND_TOPMOST,0,0,0,0, SWP_SHOWWINDOW | SWP_NOSIZE);
			}
			break;
		}
	case methEndModalState:
		{
			if(bModalState)
			{
				bModalState = FALSE;
				HWND hwnd;

				if(hwnd=::FindWindowEx(GetDesktopWindow(),NULL,"Progman",NULL))
					if(hwnd=::FindWindowEx(hwnd,NULL,"SHELLDLL_DefView",NULL))
						::EnableWindow(hwnd, TRUE);
				if(hwnd=::FindWindowEx(::GetDesktopWindow(),NULL,"Shell_TrayWnd",NULL))
					::EnableWindow(hwnd, TRUE);

				::SetWindowPos(pMainWindow->GetSafeHwnd(),HWND_NOTOPMOST,0,0,0,0, SWP_DRAWFRAME | SWP_NOSIZE);
			}
			break;
		}
	default:
		return FALSE;
	};
	return TRUE;
}

/*
					//CCustomToolBar7 SECCustomToolBar
					CWnd* pWndBtn = pWnd->GetWindow(GW_CHILD);
					while(pWndBtn)
					{
						if(CString("CCustomToolBar7") == pWndBtn->GetRuntimeClass()->m_lpszClassName)
						{
							SECCustomToolBar* pToolBar = (SECCustomToolBar*)pWndBtn;
							int cToolBtn = pToolBar->GetBtnCount();
							CString stDeb1 = "";
							for(int f = 0; f < cToolBtn; f++)
							{
								UINT styleBtn = pToolBar->GetButtonStyle(f);
								UINT idBnt = pToolBar->GetItemID(f);
								stDeb1.Format("Style = %x ID = %x",styleBtn,idBnt);
								if(idBnt == MenuItemInfo.wID)
								{
									pBkEndUI->DoMessageLine(stDeb1);
									if(uStyle)
										styleBtn |= 0x00040000;
									else
										styleBtn |= 0x00040000;
									pToolBar->SetButtonStyle(f,styleBtn);
									pToolBar->RedrawWindow();
								}
							}
						}
						pWndBtn = pWndBtn->GetNextWindow();
					}
*/

int  Cv7Windows::CallAsProc(int iMethNum,class CValue * * ppValue)
{
	switch (iMethNum) {
	case methMinimizeToTray:
		{
			int param = ppValue[0]->GetNumeric();
			if(param == 1)
				bMinimizeToTray = true;
			else if(param == 0)
				bMinimizeToTray = false;
			break;
		}
	default:
		return FALSE;
	};
	return TRUE;
}


int  Cv7Windows::FindMethod(char const * lpMethodName)const
{
	int i;
	for (i = 0;i<lastMethod;i++){
		if (!stricmp(lpMethodName,defFnNames[i].Names[0]))
			return i;
		if (!stricmp(lpMethodName,defFnNames[i].Names[1]))
			return i;
	}
	return -1;
}

char const *  Cv7Windows::GetMethodName(int iMethodNum,int iMethodAlias)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].Names[iMethodAlias];
	return NULL;
}

int  Cv7Windows::GetNMethods(void)const
{
	return lastMethod;
}

int  Cv7Windows::HasRetVal(int iMethodNum)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].HasReturnValue;
	return FALSE;
}

int Cv7Windows::GetNParams(int iMethodNum)const
{
	if ((iMethodNum>=0) && (iMethodNum<lastMethod))
		return defFnNames[iMethodNum].NumberOfParams;
	return 0;
}

int  Cv7Windows::GetParamDefValue(int iMethodNum,int iParamNum,class CValue * pDefValue)const
{
	switch (iMethodNum)
	{
	case methGetResolution:
		{
			switch (iParamNum)
			{
			case 0:
				*pDefValue = -1L;
				break;
			case 1:
				*pDefValue = -1L;
				break;
			default:
				return FALSE;
			}
			break;
		}
	case methWindowStyle:
	case methCenterWindow:
	case methMaximize:
	case methMinimize:
	case methRestore:
	case methBringWindowToTop:
		{
			switch (iParamNum)
			{
			case 0:
				*pDefValue = 0L;
				break;
			default:
				return FALSE;
			}
			break;
		}
	case methWindowSize:
	case methWindowPos:
		{
			switch (iParamNum)
			{
			case 0:
				*pDefValue = 0L;
				break;
			case 1:
			case 2:
				*pDefValue = -1L;
				break;
			case 3:
				*pDefValue = 0L;
				break;
			default:
				return FALSE;
			}
			break;
		}
	case methWindowMenu:
		{
			switch (iParamNum)
			{
			case 0:
				*pDefValue = 0L;
				break;
			case 1:
			case 2:
			case 3:
			case 4:
				*pDefValue = 1L;
				break;
			default:
				return FALSE;
			}
			break;
		}
	default:
		return FALSE;
	}
	return TRUE;
}

void  Cv7Windows::DecrRef(void)
{
	CBLContext::DecrRef();
}

char const *  Cv7Windows::GetCode(void)const
{
	return NULL;
}

int  Cv7Windows::GetDestroyUnRefd(void)const
{
	return 1;
}

void  Cv7Windows::GetExactValue(class CValue & vParam)
{
	CBLContext::GetExactValue(vParam);
}

class CObjID   Cv7Windows::GetID(void)const
{
	return ObjID;
}

class CBLContextInternalData *  Cv7Windows::GetInternalData(void)
{
	return CBLContext::GetInternalData();
}

long  Cv7Windows::GetTypeID(void)const
{
	return 100;
}

char const *  Cv7Windows::GetTypeString(void)const
{
	return "";
}

class CType   Cv7Windows::GetValueType(void)const
{
	CType tType(100);
	
	return tType;
}

void  Cv7Windows::IncrRef(void)
{
	CBLContext::IncrRef();
}

void  Cv7Windows::InitObject(class CType const & tType)
{
	CBLContext::InitObject(tType);
}

void  Cv7Windows::InitObject(char const * strName)
{
	CBLContext::InitObject(strName);
}

int  Cv7Windows::IsExactValue(void)const
{
	return FALSE;
}

int  Cv7Windows::IsOleContext(void)const
{
	return FALSE;
}

int  Cv7Windows::IsPropReadable(int iPropNum)const
{
	return TRUE;
}

int  Cv7Windows::IsPropWritable(int iPropNum)const
{
	return TRUE;
}

int  Cv7Windows::IsSerializable(void)
{
	return FALSE;
}

int  Cv7Windows::SaveToString(class CString & csStr)
{
	csStr = "";
	return TRUE;
}

void  Cv7Windows::SelectByID(class CObjID cID,long lNum)
{
	CBLContext::SelectByID(cID,lNum);
}

int  Cv7Windows::GetNProps(void)const
{
	return 0;
}

char const *  Cv7Windows::GetPropName(int A,int B)const
{
	return NULL;
}

int  Cv7Windows::GetPropVal(int iPropNum,class CValue & rValue)const
{
	return FALSE;
}

int  Cv7Windows::SetPropVal(int iPropNum,class CValue const & vValue)
{
	return FALSE;
}

int  Cv7Windows::FindProp(char const * Name)const
{
	return -1;
}