// Monitor.cpp: implementation of the CV7Monitor class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Monitor.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

BL_INIT_CONTEXT(CV7Monitor);

CV7Monitor::CV7Monitor()
{
}

CV7Monitor::~CV7Monitor()
{
}

BOOL CV7Monitor::GetActiveUsers(CValue& retVal, CValue** ppParams)
{
	retVal.Reset();

	BOOL bAccess = TRUE;
	if (ppParams[0]->GetNumeric() == 1)
		bAccess = TestAccess(17, 0, 16, 1, 0);

	if (bAccess)
	{
		CTemplate7* pT = CTemplate7::FromID(0x19D);
		CMonitorDoc* pDoc = (CMonitorDoc*)pT->OpenDocumentFile(NULL, FALSE);
		if (pDoc)
		{
			retVal.CreateObject("");
			CValueTable* pVT = ((CValueTableContextData*)(retVal.GetContext()->GetInternalData()))->GetValueTable();
			pVT->AddColumn("", CType(STRING_TYPE_1C), "", 0, "", 0);
			pVT->AddColumn("", CType(NUMBER_TYPE_1C), "", 0, "", 0);
			pVT->AddColumn("", CType(STRING_TYPE_1C), "", 0, "", 0);
			pVT->AddColumn("", CType(STRING_TYPE_1C), "", 0, "", 0);

			CValue p0, p1, p2, p3;
			CValue* ppVTRowValues[4] = {&p0, &p1, &p2, &p3};

			for (int i=0; i<pDoc->m_ActiveUsers.GetSize(); i++)
			{
				CMonitorRec& rec = pDoc->m_ActiveUsers[i];
				p0 = rec.m_UserName;
				p1 = rec.m_Mode;
				p2 = rec.m_DateTime;
				p3 = rec.m_HostName;
				pVT->AddRow(ppVTRowValues, -1);
			}
			pDoc->OnCloseDocument();
		}
	}
	
	return TRUE;
}

BOOL CV7Monitor::OpenActiveList(CValue& retVal, CValue** ppParams)
{
	BOOL bAccess = TRUE;
	if (ppParams[0]->GetNumeric() == 1)
		bAccess = TestAccess(17, 0, 16, 1, 0);
	
	if (bAccess)
	{
		CTemplate7* pT = CTemplate7::FromID(0x19D);
		POSITION pos = pT->GetFirstDocPosition();
		if (pos)
			ActivateOpenDocFrame(pT->GetNextDoc(pos));
		else
			pT->OpenDocumentFile(NULL, TRUE);
	}

	return TRUE;
}
